#!/bin/sh -x

set -x

# Here is how this archive is built.
# (Order is important.)

DIR=${1-'(unspecified)'}
[ -d $DIR ] || {
  >&2 echo "No such directory: $DIR"
  exit 2
}

case `uname -s` in
    CYGWIN* )
      CWD=`pwd`
      CWD=`cygpath -m $CWD`
      DIR=`cygpath -m $DIR`
      JAR1=$CWD/`basename $DIR`-all.jar
      JAR0=$CWD/`basename $DIR`-cls.jar
      TMPFILE=`cygpath -m /tmp/jar_tmp.$$`
      ;;
    * )
      JAR1=`pwd`/`basename $DIR`-all.jar
      JAR0=`pwd`/`basename $DIR`-cls.jar
      TMPFILE=/tmp/jar_tmp.$$
      ;;
esac

set -x
rm -f $JAR1 $JAR0

cd $DIR


trap 'rm -f $TMPFILE ; exit 1' HUP INT QUIT TERM

# Deflate all files, to start with.  (Omit directories.)
find * -type f -print | LC_COLLATE=C sort > $TMPFILE
jar cvf $JAR1 @${TMPFILE}

#Remove directories
find * -type d -print | LC_COLLATE=C sort | \
zip -d $JAR1 -@

# Remove some files.
find BUILDME.sh* java -print | \
zip -d $JAR1 -@

# Restore those files at the end.  (Include directories.)
find BUILDME.sh java -print | LC_COLLATE=C sort -r | \
egrep 'BUILDME\.sh|\.class' > $TMPFILE
jar 0uvf $JAR1 @${TMPFILE}

# Make an abbreviated JAR containing only the "good" class files.
find java -type f -print | LC_COLLATE=C sort > ${TMPFILE}
jar cvf $JAR0 @${TMPFILE}

#Remove directories
find . -type d -print | LC_COLLATE=C sort | \
zip -d $JAR0 -@


ls -l $JAR1 $JAR0

rm -f $TMPFILE
