#!/usr/bin/perl
package IkiWiki;
use warnings;
use strict;
use Test::More tests => 14;

# We check for English error messages
$ENV{LC_ALL} = 'C';

BEGIN { use_ok("IkiWiki"); }
BEGIN { use_ok("IkiWiki::Plugin::pagespec_alias"); }

$config{srcdir} = 'placeholder';
$config{wiki_file_chars} = "-[:alnum:]+/.:_";
$config{pagespec_aliases} = {
	"foo" => "bar",
	"baz" => "qaz",
	"alpha" => "beta()",
	"beta" => "gamma",
};

# undef any pagespec functions we've defined in testing so far
sub clean {
	no strict 'refs';
	map { undef *{ "IkiWiki::PageSpec::match_$_" }} keys %{$config{pagespec_aliases}};
}

is(checkconfig(), 1, "checkconfig passes");
is(checkconfig(), 1, "checkconfig passes a second time");

ok(  pagespec_match("bar", "foo()"), "alias correctly matches");
ok(! pagespec_match("bar", "baz()"), "alias correctly doesn't match");
ok(  pagespec_match("gamma", "alpha()"), "chained aliases match");
ok(! pagespec_match("beta", "alpha()"), "pagespecs vs pagenames");

ok(! eval { IkiWiki::Plugin::pagespec_alias::define_aliases(); },
	"duplicate PageSpec alias definitions caught");
ok(  $@ =~ /PageSpec already defined for alias/, "correct error thrown 1" );

$config{pagespec_aliases}{'bad4you!'} = ".";
clean();
ok(! eval { IkiWiki::Plugin::pagespec_alias::define_aliases(); },
	"alias names must be only word characters" );
ok(  $@ =~ /Only word-characters are permitted in PageSpec aliases/, "correct error thrown 2" );
delete $config{pagespec_aliases}{'bad4you!'};

# catch recursive definitions
$config{pagespec_aliases}{beta} = "alpha()";
clean();
IkiWiki::Plugin::pagespec_alias::define_aliases();
ok(! eval { IkiWiki::PageSpec::match_alpha("."); }, "recursive aliases caught");
ok(  $@ =~ /PageSpec alias defined recursively: 'alpha'/, "correct error thrown 3" );
