# ASRock Industrial IMB-1222 Thin Mini-ITX Motherboard

This page describes how to run coreboot on the [ASRock IMB-1222].

## Technology

```{eval-rst}
+---------+---------------------------------------------------------------+
| CPU     | | Intel 10th Gen (Comet lake-S) Core Processors (LGA-1200)    |
|         | | CPUs over 80W will be limited due to power design           |
+---------+---------------------------------------------------------------+
| DRAM    | 2 SO-DIMM slots, DDR4 2933/2666/2400 MHz                      |
+---------+---------------------------------------------------------------+
| Chipset | Intel Q470E                                                   |
+---------+---------------------------------------------------------------+
| SuperIO | Fintek F81966                                                 |
+---------+---------------------------------------------------------------+
| TPM     | Infineon SLB 9670VQ2.0                                        |
+---------+---------------------------------------------------------------+
| Boot    | USB, SATA, NVMe                                               |
+---------+---------------------------------------------------------------+
| Power   | | Laptop Power Supply:                                        |
|         | | - 12V DC-in (IMB-1222)                                      |
|         | | - 12V~28V DC-in (IMB-1222-WV)                               |
+---------+---------------------------------------------------------------+
```

```text
+--------------+                        +---------------------------+    +---------------+
|     eDP      |------------------------|                           |----|  DDR4 SODIMM  |
+--------------+                        |                           |    +---------------+
+--------------+    +--------------+    |                           |    +---------------+
|     HDMI     |----|  ITE IT6563  |----|                           |----|  DDR4 SODIMM  |
+--------------+    +--------------+    |                           |    +---------------+
+--------------+                        |      Intel 10th Gen       |
| Display Port |------------------------|      (Comet lake-S)       |
+--------------+                        |      Core Processors      |
+--------------+                        |         LGA-1200          |
| Display Port |------------------------|                           |
+--------------+                        |                           |
+--------------+    +--------------+    |                           |    +---------------+
|     LVDS     |----|  CH7511B-BF  |----|                           |----| PCIe Gen3 x16 |
+--------------+    +--------------+    +---------------------------+    +---------------+
                                                      |
                                                      |
+------------------+                    +---------------------------+    +---------------+
| 4 x USB 3.2 Gen1 |                    |                           |    |   2 x SATA    |
|    Connector     |--------------------|                           |----|   Connector   |
+------------------+                    |                           |    +---------------+
+------------------+                    |                           |    +---------------+
| 2 x USB 3.2 Gen1 |                    |                           |    | M.2 KeyM SATA |
|      Header      |--------------------|      Intel Q470E PCH      |----|  PCIe Gen3x4  |
+------------------+                    |                           |    +---------------+
+--------------+                        |                           |    +---------------+
| 2 x USB 2.0  |                        |                           |    |   M.2 Key E   |
|    Header    |------------------------|                           |----| PCIe Gen3 x1/ |
+--------------+                        |                           |    |  CNVi/USB2.0  |
+--------------+    +--------------+    |                           |    +---------------+
|     RJ45     |----| I225LM/I225V |----|                           |    +---------------+
+--------------+    +--------------+    |                           |    |  M.2 Key B    |
+--------------+    +--------------+    |                           |----| PCIe Gen3 x1/ |
|     RJ45     |----|    I219LM    |----|                           |    | USB3.0/USB2.0 |
+--------------+    +--------------+    |                           |    +---------------+
+--------------+    +--------------+    |                           |    +---------------+
|    Mic-in    |    |   Realtek    |    |                           |    | TPM INFINEON  |
|   Line-out   |----|    ALC887    |----|                           |----| SLB 9670VQ2.0 |
|    SPDIF     |    +--------------+    |                           |    +---------------+
+--------------+            |           +---------------------------+
                    +--------------+                  |
                    |    ALC122    |                  | LPC
                    +--------------+           +--------------+
+-----------------------+   +--------------+   |              |    +------------+
| 2 x COM RS232/422/485 |---|   ST3243E    |---|    Fintek    |----| CPU FAN x1 |
+-----------------------+   +--------------+   |    F81966    |    +------------+
+-----------------------+   +--------------+   |    SuperIO   |    +------------+
| 2 x COM RS232         |---|   ST3243E    |---|              |----| NCT 3941SA |
+-----------------------+   +--------------+   +--------------+    +------------+
                                                      |                   |
                                               +--------------+    +------------+
                                               |   8 x GPIO   |    | CHA FAN x1 |
                                               +--------------+    +------------+

```

This port was created without a schematic/boardview, reverse engineering only.
Feel free to make changes.

## Required proprietary blobs

To build full working image of coreboot, the following blobs are required:

```{eval-rst}
+-----------------+-------------------------------------------+-------------------------+
| Binary file     | Apply                                     | Required/Optional       |
+=================+===========================================+=========================+
| FSP-M & FSP-S   | | Intel Firmware Support Package 2.1      | Required                |
|                 | | 10th Generation Intel® Core™ processors |                         |
|                 | | and chipsets (formerly Comet Lake)      |                         |
+-----------------+-------------------------------------------+-------------------------+
| IFD             | Intel Flash Descriptor                    | Required                |
+-----------------+-------------------------------------------+-------------------------+
| ME              | Intel Management Engine                   | Required                |
+-----------------+-------------------------------------------+-------------------------+
| GBE             | Gigabit Ethernet Configuration            | | Optional              |
|                 |                                           | | (if LAN2 is enabled)  |
+-----------------+-------------------------------------------+-------------------------+
```

### FSP

Intel company provides [Firmware Support Package (2.1)](../../soc/intel/fsp/index.md)
to initialize this generation silicon. Please see this
[document](../../soc/intel/code_development_model/code_development_model.md).

### IFD, ME, GBE

Use the [vendor's firmware] version 1.80 to extract the IFD, ME, GBE blobs from it, according to
the [Intel IFD Binary Extraction Tutorial](../../util/ifdtool/binary_extraction.md).

```bash
wget --tries=5 "https://web.archive.org/web/20250413105432/https://download.asrock.com/IPC/BIOS/IMB-1222(1.80)ROM.zip"
unzip "IMB-1222(1.80)ROM.zip"
ifdtool --platform cnl -x IM12221.80
File IM12221.80 is 33554432 bytes
  flashregion_0_flashdescriptor.bin  Flash Region 0 (Flash Descriptor): 00000000 - 00000fff
  flashregion_2_intel_me.bin         Flash Region 2 (Intel ME):         00003000 - 01002fff
  flashregion_3_gbe.bin              Flash Region 3 (GbE):              00001000 - 00002fff
```

## Building coreboot

The following commands will help quickly configure and build a project for this board:

```bash
make distclean
touch .config
./util/scripts/config --enable VENDOR_ASROCK
./util/scripts/config --enable BOARD_ASROCK_IMB_1222
make olddefconfig
make
```

## Payloads

```{eval-rst}
+---------------+------+---------+-----------+
| OS / Payload  | EDK2 | SeaBIOS | LinuxBoot |
+===============+======+=========+===========+
| Ubuntu 22.04  |  V   |    V    |     V     |
+---------------+------+---------+-----------+
| Ubuntu 24.04  |  V   |    V    |     V     |
+---------------+------+---------+-----------+
| Windows 10    |  V   |         |           |
+---------------+------+---------+-----------+
| Windows 11    |  V   |         |           |
+---------------+------+---------+-----------+
| Android 13    |      |    V    |           |
+---------------+------+---------+-----------+
```

- LinuxBoot/Linux as payload;
- SeaBIOS (1.16.3);
- edk2 [MrChromebox fork] (uefipayload_2408).

### Additional information

- Ubuntu 22.04 (Linux 6.5.0-15-generic);
- Ubuntu 24.04 (Linux 6.8.0-41-generic);
- Microsoft Windows 10 Pro (10.0.19045.4780, 22H2 2022);
- Microsoft Windows 11 Pro (10.0.26100.3194, 24H2 2024);
- Andoid 13, [Bliss OS] x86_64 (16.9.7, Linux 6.1.112-gloria-xanmod1).

## Flashing coreboot

```{eval-rst}
+---------------------+--------------------------+
| Type                | Value                    |
+=====================+==========================+
| Socketed flash      | yes                      |
+---------------------+--------------------------+
| Model               | | W25Q256JV              |
|                     | | MX25L25673G            |
+---------------------+--------------------------+
| Size                | 32 MiB                   |
+---------------------+--------------------------+
| Package             | WSON-8 8x6 mm            |
+---------------------+--------------------------+
| Write protection    | chipset PRR              |
+---------------------+--------------------------+
| Dual BIOS feature   | no                       |
+---------------------+--------------------------+
| Internal flashing   | after flashing coreboot  |
+---------------------+--------------------------+
```

The SPI flash can be accessed using [flashrom]. By default, only the
BIOS region of the flash is writable:

```bash
flashrom -p internal -N -w coreboot.rom --ifd -i bios
```

If you wish to change any other region, such as the Management Engine
or firmware descriptor, then an external programmer is required. More
information about this [here](../../tutorial/flashing_firmware/index.md).

## Working

- Dual Channel DDR4 2933/2666/2400 MHz;
- Intel UHD Graphics:
  - DP (both);
  - HDMI;
    - VGA Option ROM;
    - libgfxinit;
    - GOP;
- PCIe x16 Slot (Gen3);
- SATA ports;
- USB 2.0 ports;
- USB 3.2 ports;
- M.2 Key-E 2230 slot for Wireless (PCIe x1, USB 2.0 and CNVi);
- M.2 Key-B 3042/3052 WWAN slot for 4G/5G modem (PCIe x1, USB 3.0);
- M.2 Key-M 2242/2260/2280 for SSD/NVMe (PCIE x4, SATA3);
- LAN1 Intel I225LM/I225V, 10/100/1000/2500 Mbps;
- LAN2 Intel I219LM, 10/100/1000 Mbps;
- Realtek ALC887 HD Audio (line-out, mic-in);
- COM 1/2/3/4 ports (Fintek f81966);
- onboard speaker;
- HWM/FANs control (Fintek f81966);
- S3 suspend and wake;
- TPM;
- disabling ME with me_cleaner [XutaxKamay fork] (v1.2-9-gf20532d).

## Unknown/untested

- eDP/LVDS (currently disabled);
- PCIe riser cards;
- SPDIF;
- SATA RAID.

[ASRock IMB-1222]: https://web.archive.org/web/20220924171403/https://www.asrockind.com/en-gb/IMB-1222
[vendor's firmware]: https://web.archive.org/web/20250413105432/https://download.asrock.com/IPC/BIOS/IMB-1222(1.80)ROM.zip
[flashrom]: https://flashrom.org/
[MrChromebox fork]: https://github.com/MrChromebox/edk2
[XutaxKamay fork]: https://github.com/XutaxKamay/me_cleaner
[Bliss OS]: https://blissos.org/
