# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models


class ActionStatus(_serialization.Model):
    """Model that represents the an action and its status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar action_name: The name of the action status.
    :vartype action_name: str
    :ivar action_id: The id of the action status.
    :vartype action_id: str
    :ivar status: The status of the action.
    :vartype status: str
    :ivar start_time: String that represents the start time of the action.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: String that represents the end time of the action.
    :vartype end_time: ~datetime.datetime
    :ivar targets: The array of targets.
    :vartype targets:
     list[~azure.mgmt.chaos.models.ExperimentExecutionActionTargetDetailsProperties]
    """

    _validation = {
        "action_name": {"readonly": True},
        "action_id": {"readonly": True},
        "status": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "targets": {"readonly": True},
    }

    _attribute_map = {
        "action_name": {"key": "actionName", "type": "str"},
        "action_id": {"key": "actionId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "targets": {"key": "targets", "type": "[ExperimentExecutionActionTargetDetailsProperties]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.action_name: Optional[str] = None
        self.action_id: Optional[str] = None
        self.status: Optional[str] = None
        self.start_time: Optional[datetime.datetime] = None
        self.end_time: Optional[datetime.datetime] = None
        self.targets: Optional[List["_models.ExperimentExecutionActionTargetDetailsProperties"]] = None


class BranchStatus(_serialization.Model):
    """Model that represents the a list of actions and action statuses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar branch_name: The name of the branch status.
    :vartype branch_name: str
    :ivar branch_id: The id of the branch status.
    :vartype branch_id: str
    :ivar status: The status of the branch.
    :vartype status: str
    :ivar actions: The array of actions.
    :vartype actions: list[~azure.mgmt.chaos.models.ActionStatus]
    """

    _validation = {
        "branch_name": {"readonly": True},
        "branch_id": {"readonly": True},
        "status": {"readonly": True},
        "actions": {"readonly": True},
    }

    _attribute_map = {
        "branch_name": {"key": "branchName", "type": "str"},
        "branch_id": {"key": "branchId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "actions": {"key": "actions", "type": "[ActionStatus]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.branch_name: Optional[str] = None
        self.branch_id: Optional[str] = None
        self.status: Optional[str] = None
        self.actions: Optional[List["_models.ActionStatus"]] = None


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.chaos.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.chaos.models.SystemData
    """


class Capability(ProxyResource):
    """Model that represents a Capability resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.chaos.models.SystemData
    :ivar publisher: String of the Publisher that this Capability extends.
    :vartype publisher: str
    :ivar target_type: String of the Target Type that this Capability extends.
    :vartype target_type: str
    :ivar description: Localized string of the description.
    :vartype description: str
    :ivar parameters_schema: URL to retrieve JSON schema of the Capability parameters.
    :vartype parameters_schema: str
    :ivar urn: String of the URN for this Capability Type.
    :vartype urn: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "publisher": {"readonly": True},
        "target_type": {"readonly": True},
        "description": {"readonly": True},
        "parameters_schema": {"readonly": True, "max_length": 2048},
        "urn": {"readonly": True, "max_length": 2048},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "target_type": {"key": "properties.targetType", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "parameters_schema": {"key": "properties.parametersSchema", "type": "str"},
        "urn": {"key": "properties.urn", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.publisher: Optional[str] = None
        self.target_type: Optional[str] = None
        self.description: Optional[str] = None
        self.parameters_schema: Optional[str] = None
        self.urn: Optional[str] = None


class CapabilityListResult(_serialization.Model):
    """Model that represents a list of Capability resources and a link for pagination.

    All required parameters must be populated in order to send to server.

    :ivar value: The Capability items on this page. Required.
    :vartype value: list[~azure.mgmt.chaos.models.Capability]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Capability]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Capability"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Capability items on this page. Required.
        :paramtype value: list[~azure.mgmt.chaos.models.Capability]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CapabilityType(ProxyResource):
    """Model that represents a Capability Type resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.chaos.models.SystemData
    :ivar publisher: String of the Publisher that this Capability Type extends.
    :vartype publisher: str
    :ivar target_type: String of the Target Type that this Capability Type extends.
    :vartype target_type: str
    :ivar display_name: Localized string of the display name.
    :vartype display_name: str
    :ivar description: Localized string of the description.
    :vartype description: str
    :ivar parameters_schema: URL to retrieve JSON schema of the Capability Type parameters.
    :vartype parameters_schema: str
    :ivar urn: String of the URN for this Capability Type.
    :vartype urn: str
    :ivar kind: String of the kind of this Capability Type.
    :vartype kind: str
    :ivar azure_rbac_actions: Control plane actions necessary to execute capability type.
    :vartype azure_rbac_actions: list[str]
    :ivar azure_rbac_data_actions: Data plane actions necessary to execute capability type.
    :vartype azure_rbac_data_actions: list[str]
    :ivar required_azure_role_definition_ids: Required Azure Role Definition Ids to execute
     capability type.
    :vartype required_azure_role_definition_ids: list[str]
    :ivar runtime_properties: Runtime properties of this Capability Type.
    :vartype runtime_properties: ~azure.mgmt.chaos.models.CapabilityTypePropertiesRuntimeProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "publisher": {"readonly": True},
        "target_type": {"readonly": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "parameters_schema": {"readonly": True, "max_length": 2048},
        "urn": {"readonly": True, "max_length": 2048},
        "kind": {"readonly": True},
        "azure_rbac_actions": {"readonly": True},
        "azure_rbac_data_actions": {"readonly": True},
        "required_azure_role_definition_ids": {"readonly": True},
        "runtime_properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "target_type": {"key": "properties.targetType", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "parameters_schema": {"key": "properties.parametersSchema", "type": "str"},
        "urn": {"key": "properties.urn", "type": "str"},
        "kind": {"key": "properties.kind", "type": "str"},
        "azure_rbac_actions": {"key": "properties.azureRbacActions", "type": "[str]"},
        "azure_rbac_data_actions": {"key": "properties.azureRbacDataActions", "type": "[str]"},
        "required_azure_role_definition_ids": {"key": "properties.requiredAzureRoleDefinitionIds", "type": "[str]"},
        "runtime_properties": {
            "key": "properties.runtimeProperties",
            "type": "CapabilityTypePropertiesRuntimeProperties",
        },
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.publisher: Optional[str] = None
        self.target_type: Optional[str] = None
        self.display_name: Optional[str] = None
        self.description: Optional[str] = None
        self.parameters_schema: Optional[str] = None
        self.urn: Optional[str] = None
        self.kind: Optional[str] = None
        self.azure_rbac_actions: Optional[List[str]] = None
        self.azure_rbac_data_actions: Optional[List[str]] = None
        self.required_azure_role_definition_ids: Optional[List[str]] = None
        self.runtime_properties: Optional["_models.CapabilityTypePropertiesRuntimeProperties"] = None


class CapabilityTypeListResult(_serialization.Model):
    """Model that represents a list of Capability Type resources and a link for pagination.

    All required parameters must be populated in order to send to server.

    :ivar value: The CapabilityType items on this page. Required.
    :vartype value: list[~azure.mgmt.chaos.models.CapabilityType]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CapabilityType]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.CapabilityType"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The CapabilityType items on this page. Required.
        :paramtype value: list[~azure.mgmt.chaos.models.CapabilityType]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CapabilityTypePropertiesRuntimeProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Runtime properties of this Capability Type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kind: String of the kind of the resource's action type (continuous or discrete).
    :vartype kind: str
    """

    _validation = {
        "kind": {"readonly": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class ChaosExperimentAction(_serialization.Model):
    """Model that represents the base action model. 9 total per experiment.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ContinuousAction, DelayAction, DiscreteAction

    All required parameters must be populated in order to send to server.

    :ivar name: String that represents a Capability URN. Required.
    :vartype name: str
    :ivar type: Chaos experiment action discriminator type. Required. Known values are: "delay",
     "discrete", and "continuous".
    :vartype type: str or ~azure.mgmt.chaos.models.ExperimentActionType
    """

    _validation = {
        "name": {"required": True, "max_length": 2048},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"continuous": "ContinuousAction", "delay": "DelayAction", "discrete": "DiscreteAction"}}

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: String that represents a Capability URN. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type: Optional[str] = None


class ChaosExperimentBranch(_serialization.Model):
    """Model that represents a branch in the step. 9 total per experiment.

    All required parameters must be populated in order to send to server.

    :ivar name: String of the branch name. Required.
    :vartype name: str
    :ivar actions: List of actions. Required.
    :vartype actions: list[~azure.mgmt.chaos.models.ChaosExperimentAction]
    """

    _validation = {
        "name": {"required": True, "min_length": 1},
        "actions": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "actions": {"key": "actions", "type": "[ChaosExperimentAction]"},
    }

    def __init__(self, *, name: str, actions: List["_models.ChaosExperimentAction"], **kwargs: Any) -> None:
        """
        :keyword name: String of the branch name. Required.
        :paramtype name: str
        :keyword actions: List of actions. Required.
        :paramtype actions: list[~azure.mgmt.chaos.models.ChaosExperimentAction]
        """
        super().__init__(**kwargs)
        self.name = name
        self.actions = actions


class ChaosExperimentStep(_serialization.Model):
    """Model that represents a step in the Experiment resource.

    All required parameters must be populated in order to send to server.

    :ivar name: String of the step name. Required.
    :vartype name: str
    :ivar branches: List of branches. Required.
    :vartype branches: list[~azure.mgmt.chaos.models.ChaosExperimentBranch]
    """

    _validation = {
        "name": {"required": True, "min_length": 1},
        "branches": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "branches": {"key": "branches", "type": "[ChaosExperimentBranch]"},
    }

    def __init__(self, *, name: str, branches: List["_models.ChaosExperimentBranch"], **kwargs: Any) -> None:
        """
        :keyword name: String of the step name. Required.
        :paramtype name: str
        :keyword branches: List of branches. Required.
        :paramtype branches: list[~azure.mgmt.chaos.models.ChaosExperimentBranch]
        """
        super().__init__(**kwargs)
        self.name = name
        self.branches = branches


class ChaosTargetFilter(_serialization.Model):
    """Model that represents available filter types that can be applied to a targets list.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ChaosTargetSimpleFilter

    All required parameters must be populated in order to send to server.

    :ivar type: Chaos target filter discriminator type. Required. "Simple"
    :vartype type: str or ~azure.mgmt.chaos.models.FilterType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"Simple": "ChaosTargetSimpleFilter"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None


class ChaosTargetSelector(_serialization.Model):
    """Model that represents a selector in the Experiment resource.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ChaosTargetListSelector, ChaosTargetQuerySelector

    All required parameters must be populated in order to send to server.

    :ivar id: String of the selector ID. Required.
    :vartype id: str
    :ivar type: Chaos target selector discriminator type. Required. Known values are: "List" and
     "Query".
    :vartype type: str or ~azure.mgmt.chaos.models.SelectorType
    :ivar filter: Model that represents available filter types that can be applied to a targets
     list.
    :vartype filter: ~azure.mgmt.chaos.models.ChaosTargetFilter
    """

    _validation = {
        "id": {"required": True, "min_length": 1},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "filter": {"key": "filter", "type": "ChaosTargetFilter"},
    }

    _subtype_map = {"type": {"List": "ChaosTargetListSelector", "Query": "ChaosTargetQuerySelector"}}

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        filter: Optional["_models.ChaosTargetFilter"] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword id: String of the selector ID. Required.
        :paramtype id: str
        :keyword filter: Model that represents available filter types that can be applied to a targets
         list.
        :paramtype filter: ~azure.mgmt.chaos.models.ChaosTargetFilter
        """
        super().__init__(**kwargs)
        self.id = id
        self.type: Optional[str] = None
        self.filter = filter


class ChaosTargetListSelector(ChaosTargetSelector):
    """Model that represents a list selector.

    All required parameters must be populated in order to send to server.

    :ivar id: String of the selector ID. Required.
    :vartype id: str
    :ivar type: Chaos target selector discriminator type. Required. Known values are: "List" and
     "Query".
    :vartype type: str or ~azure.mgmt.chaos.models.SelectorType
    :ivar filter: Model that represents available filter types that can be applied to a targets
     list.
    :vartype filter: ~azure.mgmt.chaos.models.ChaosTargetFilter
    :ivar targets: List of Target references. Required.
    :vartype targets: list[~azure.mgmt.chaos.models.TargetReference]
    """

    _validation = {
        "id": {"required": True, "min_length": 1},
        "type": {"required": True},
        "targets": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "filter": {"key": "filter", "type": "ChaosTargetFilter"},
        "targets": {"key": "targets", "type": "[TargetReference]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        targets: List["_models.TargetReference"],
        filter: Optional["_models.ChaosTargetFilter"] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword id: String of the selector ID. Required.
        :paramtype id: str
        :keyword filter: Model that represents available filter types that can be applied to a targets
         list.
        :paramtype filter: ~azure.mgmt.chaos.models.ChaosTargetFilter
        :keyword targets: List of Target references. Required.
        :paramtype targets: list[~azure.mgmt.chaos.models.TargetReference]
        """
        super().__init__(id=id, filter=filter, **kwargs)
        self.type: str = "List"
        self.targets = targets


class ChaosTargetQuerySelector(ChaosTargetSelector):
    """Model that represents a query selector.

    All required parameters must be populated in order to send to server.

    :ivar id: String of the selector ID. Required.
    :vartype id: str
    :ivar type: Chaos target selector discriminator type. Required. Known values are: "List" and
     "Query".
    :vartype type: str or ~azure.mgmt.chaos.models.SelectorType
    :ivar filter: Model that represents available filter types that can be applied to a targets
     list.
    :vartype filter: ~azure.mgmt.chaos.models.ChaosTargetFilter
    :ivar query_string: Azure Resource Graph (ARG) Query Language query for target resources.
     Required.
    :vartype query_string: str
    :ivar subscription_ids: Subscription id list to scope resource query. Required.
    :vartype subscription_ids: list[str]
    """

    _validation = {
        "id": {"required": True, "min_length": 1},
        "type": {"required": True},
        "query_string": {"required": True},
        "subscription_ids": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "filter": {"key": "filter", "type": "ChaosTargetFilter"},
        "query_string": {"key": "queryString", "type": "str"},
        "subscription_ids": {"key": "subscriptionIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        query_string: str,
        subscription_ids: List[str],
        filter: Optional["_models.ChaosTargetFilter"] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword id: String of the selector ID. Required.
        :paramtype id: str
        :keyword filter: Model that represents available filter types that can be applied to a targets
         list.
        :paramtype filter: ~azure.mgmt.chaos.models.ChaosTargetFilter
        :keyword query_string: Azure Resource Graph (ARG) Query Language query for target resources.
         Required.
        :paramtype query_string: str
        :keyword subscription_ids: Subscription id list to scope resource query. Required.
        :paramtype subscription_ids: list[str]
        """
        super().__init__(id=id, filter=filter, **kwargs)
        self.type: str = "Query"
        self.query_string = query_string
        self.subscription_ids = subscription_ids


class ChaosTargetSimpleFilter(ChaosTargetFilter):
    """Model that represents a simple target filter.

    All required parameters must be populated in order to send to server.

    :ivar type: Chaos target filter discriminator type. Required. "Simple"
    :vartype type: str or ~azure.mgmt.chaos.models.FilterType
    :ivar parameters: Model that represents the Simple filter parameters.
    :vartype parameters: ~azure.mgmt.chaos.models.ChaosTargetSimpleFilterParameters
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "parameters": {"key": "parameters", "type": "ChaosTargetSimpleFilterParameters"},
    }

    def __init__(
        self, *, parameters: Optional["_models.ChaosTargetSimpleFilterParameters"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword parameters: Model that represents the Simple filter parameters.
        :paramtype parameters: ~azure.mgmt.chaos.models.ChaosTargetSimpleFilterParameters
        """
        super().__init__(**kwargs)
        self.type: str = "Simple"
        self.parameters = parameters


class ChaosTargetSimpleFilterParameters(_serialization.Model):
    """Model that represents the Simple filter parameters.

    :ivar zones: List of Azure availability zones to filter targets by.
    :vartype zones: list[str]
    """

    _attribute_map = {
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(self, *, zones: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword zones: List of Azure availability zones to filter targets by.
        :paramtype zones: list[str]
        """
        super().__init__(**kwargs)
        self.zones = zones


class ContinuousAction(ChaosExperimentAction):
    """Model that represents a continuous action.

    All required parameters must be populated in order to send to server.

    :ivar name: String that represents a Capability URN. Required.
    :vartype name: str
    :ivar type: Chaos experiment action discriminator type. Required. Known values are: "delay",
     "discrete", and "continuous".
    :vartype type: str or ~azure.mgmt.chaos.models.ExperimentActionType
    :ivar duration: ISO8601 formatted string that represents a duration. Required.
    :vartype duration: ~datetime.timedelta
    :ivar parameters: List of key value pairs. Required.
    :vartype parameters: list[~azure.mgmt.chaos.models.KeyValuePair]
    :ivar selector_id: String that represents a selector. Required.
    :vartype selector_id: str
    """

    _validation = {
        "name": {"required": True, "max_length": 2048},
        "type": {"required": True},
        "duration": {"required": True},
        "parameters": {"required": True},
        "selector_id": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
        "parameters": {"key": "parameters", "type": "[KeyValuePair]"},
        "selector_id": {"key": "selectorId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        duration: datetime.timedelta,
        parameters: List["_models.KeyValuePair"],
        selector_id: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: String that represents a Capability URN. Required.
        :paramtype name: str
        :keyword duration: ISO8601 formatted string that represents a duration. Required.
        :paramtype duration: ~datetime.timedelta
        :keyword parameters: List of key value pairs. Required.
        :paramtype parameters: list[~azure.mgmt.chaos.models.KeyValuePair]
        :keyword selector_id: String that represents a selector. Required.
        :paramtype selector_id: str
        """
        super().__init__(name=name, **kwargs)
        self.type: str = "continuous"
        self.duration = duration
        self.parameters = parameters
        self.selector_id = selector_id


class DelayAction(ChaosExperimentAction):
    """Model that represents a delay action.

    All required parameters must be populated in order to send to server.

    :ivar name: String that represents a Capability URN. Required.
    :vartype name: str
    :ivar type: Chaos experiment action discriminator type. Required. Known values are: "delay",
     "discrete", and "continuous".
    :vartype type: str or ~azure.mgmt.chaos.models.ExperimentActionType
    :ivar duration: ISO8601 formatted string that represents a duration. Required.
    :vartype duration: ~datetime.timedelta
    """

    _validation = {
        "name": {"required": True, "max_length": 2048},
        "type": {"required": True},
        "duration": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
    }

    def __init__(self, *, name: str, duration: datetime.timedelta, **kwargs: Any) -> None:
        """
        :keyword name: String that represents a Capability URN. Required.
        :paramtype name: str
        :keyword duration: ISO8601 formatted string that represents a duration. Required.
        :paramtype duration: ~datetime.timedelta
        """
        super().__init__(name=name, **kwargs)
        self.type: str = "delay"
        self.duration = duration


class DiscreteAction(ChaosExperimentAction):
    """Model that represents a discrete action.

    All required parameters must be populated in order to send to server.

    :ivar name: String that represents a Capability URN. Required.
    :vartype name: str
    :ivar type: Chaos experiment action discriminator type. Required. Known values are: "delay",
     "discrete", and "continuous".
    :vartype type: str or ~azure.mgmt.chaos.models.ExperimentActionType
    :ivar parameters: List of key value pairs. Required.
    :vartype parameters: list[~azure.mgmt.chaos.models.KeyValuePair]
    :ivar selector_id: String that represents a selector. Required.
    :vartype selector_id: str
    """

    _validation = {
        "name": {"required": True, "max_length": 2048},
        "type": {"required": True},
        "parameters": {"required": True},
        "selector_id": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "parameters": {"key": "parameters", "type": "[KeyValuePair]"},
        "selector_id": {"key": "selectorId", "type": "str"},
    }

    def __init__(self, *, name: str, parameters: List["_models.KeyValuePair"], selector_id: str, **kwargs: Any) -> None:
        """
        :keyword name: String that represents a Capability URN. Required.
        :paramtype name: str
        :keyword parameters: List of key value pairs. Required.
        :paramtype parameters: list[~azure.mgmt.chaos.models.KeyValuePair]
        :keyword selector_id: String that represents a selector. Required.
        :paramtype selector_id: str
        """
        super().__init__(name=name, **kwargs)
        self.type: str = "discrete"
        self.parameters = parameters
        self.selector_id = selector_id


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.chaos.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.chaos.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetail"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.chaos.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.chaos.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.chaos.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Experiment(TrackedResource):
    """Model that represents a Experiment resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.chaos.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.chaos.models.ManagedServiceIdentity
    :ivar provisioning_state: Most recent provisioning state for the given experiment resource.
     Known values are: "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.chaos.models.ProvisioningState
    :ivar steps: List of steps. Required.
    :vartype steps: list[~azure.mgmt.chaos.models.ChaosExperimentStep]
    :ivar selectors: List of selectors. Required.
    :vartype selectors: list[~azure.mgmt.chaos.models.ChaosTargetSelector]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "steps": {"required": True},
        "selectors": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "steps": {"key": "properties.steps", "type": "[ChaosExperimentStep]"},
        "selectors": {"key": "properties.selectors", "type": "[ChaosTargetSelector]"},
    }

    def __init__(
        self,
        *,
        location: str,
        steps: List["_models.ChaosExperimentStep"],
        selectors: List["_models.ChaosTargetSelector"],
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity: ~azure.mgmt.chaos.models.ManagedServiceIdentity
        :keyword steps: List of steps. Required.
        :paramtype steps: list[~azure.mgmt.chaos.models.ChaosExperimentStep]
        :keyword selectors: List of selectors. Required.
        :paramtype selectors: list[~azure.mgmt.chaos.models.ChaosTargetSelector]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.steps = steps
        self.selectors = selectors


class ExperimentExecution(ProxyResource):
    """Model that represents the execution of a Experiment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.chaos.models.SystemData
    :ivar status: The status of the execution.
    :vartype status: str
    :ivar started_at: String that represents the start date time.
    :vartype started_at: ~datetime.datetime
    :ivar stopped_at: String that represents the stop date time.
    :vartype stopped_at: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "status": {"readonly": True},
        "started_at": {"readonly": True},
        "stopped_at": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "status": {"key": "properties.status", "type": "str"},
        "started_at": {"key": "properties.startedAt", "type": "iso-8601"},
        "stopped_at": {"key": "properties.stoppedAt", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status: Optional[str] = None
        self.started_at: Optional[datetime.datetime] = None
        self.stopped_at: Optional[datetime.datetime] = None


class ExperimentExecutionActionTargetDetailsError(_serialization.Model):  # pylint: disable=name-too-long
    """Model that represents the Experiment action target details error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None


class ExperimentExecutionActionTargetDetailsProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Model that represents the Experiment action target details properties model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the execution.
    :vartype status: str
    :ivar target: The target for the action.
    :vartype target: str
    :ivar target_failed_time: String that represents the failed date time.
    :vartype target_failed_time: ~datetime.datetime
    :ivar target_completed_time: String that represents the completed date time.
    :vartype target_completed_time: ~datetime.datetime
    :ivar error: The error of the action.
    :vartype error: ~azure.mgmt.chaos.models.ExperimentExecutionActionTargetDetailsError
    """

    _validation = {
        "status": {"readonly": True},
        "target": {"readonly": True},
        "target_failed_time": {"readonly": True},
        "target_completed_time": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "target_failed_time": {"key": "targetFailedTime", "type": "iso-8601"},
        "target_completed_time": {"key": "targetCompletedTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "ExperimentExecutionActionTargetDetailsError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status: Optional[str] = None
        self.target: Optional[str] = None
        self.target_failed_time: Optional[datetime.datetime] = None
        self.target_completed_time: Optional[datetime.datetime] = None
        self.error: Optional["_models.ExperimentExecutionActionTargetDetailsError"] = None


class ExperimentExecutionDetails(_serialization.Model):
    """Model that represents the execution details of an Experiment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: String of the resource type.
    :vartype type: str
    :ivar id: String of the fully qualified resource ID.
    :vartype id: str
    :ivar name: String of the resource name.
    :vartype name: str
    :ivar properties: The properties of the experiment execution details.
    :vartype properties: ~azure.mgmt.chaos.models.ExperimentExecutionDetailsProperties
    """

    _validation = {
        "type": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "ExperimentExecutionDetailsProperties"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.properties: Optional["_models.ExperimentExecutionDetailsProperties"] = None


class ExperimentExecutionDetailsProperties(_serialization.Model):
    """Model that represents the extended properties of an experiment execution.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the execution.
    :vartype status: str
    :ivar started_at: String that represents the start date time.
    :vartype started_at: ~datetime.datetime
    :ivar stopped_at: String that represents the stop date time.
    :vartype stopped_at: ~datetime.datetime
    :ivar failure_reason: The reason why the execution failed.
    :vartype failure_reason: str
    :ivar last_action_at: String that represents the last action date time.
    :vartype last_action_at: ~datetime.datetime
    :ivar run_information: The information of the experiment run.
    :vartype run_information:
     ~azure.mgmt.chaos.models.ExperimentExecutionDetailsPropertiesRunInformation
    """

    _validation = {
        "status": {"readonly": True},
        "started_at": {"readonly": True},
        "stopped_at": {"readonly": True},
        "failure_reason": {"readonly": True},
        "last_action_at": {"readonly": True},
        "run_information": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "started_at": {"key": "startedAt", "type": "iso-8601"},
        "stopped_at": {"key": "stoppedAt", "type": "iso-8601"},
        "failure_reason": {"key": "failureReason", "type": "str"},
        "last_action_at": {"key": "lastActionAt", "type": "iso-8601"},
        "run_information": {"key": "runInformation", "type": "ExperimentExecutionDetailsPropertiesRunInformation"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status: Optional[str] = None
        self.started_at: Optional[datetime.datetime] = None
        self.stopped_at: Optional[datetime.datetime] = None
        self.failure_reason: Optional[str] = None
        self.last_action_at: Optional[datetime.datetime] = None
        self.run_information: Optional["_models.ExperimentExecutionDetailsPropertiesRunInformation"] = None


class ExperimentExecutionDetailsPropertiesRunInformation(_serialization.Model):  # pylint: disable=name-too-long
    """The information of the experiment run.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar steps: The steps of the experiment run.
    :vartype steps: list[~azure.mgmt.chaos.models.StepStatus]
    """

    _validation = {
        "steps": {"readonly": True},
    }

    _attribute_map = {
        "steps": {"key": "steps", "type": "[StepStatus]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.steps: Optional[List["_models.StepStatus"]] = None


class ExperimentExecutionListResult(_serialization.Model):
    """Model that represents a list of Experiment executions and a link for pagination.

    All required parameters must be populated in order to send to server.

    :ivar value: The ExperimentExecution items on this page. Required.
    :vartype value: list[~azure.mgmt.chaos.models.ExperimentExecution]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExperimentExecution]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.ExperimentExecution"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The ExperimentExecution items on this page. Required.
        :paramtype value: list[~azure.mgmt.chaos.models.ExperimentExecution]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExperimentListResult(_serialization.Model):
    """Model that represents a list of Experiment resources and a link for pagination.

    All required parameters must be populated in order to send to server.

    :ivar value: The Experiment items on this page. Required.
    :vartype value: list[~azure.mgmt.chaos.models.Experiment]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Experiment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Experiment"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Experiment items on this page. Required.
        :paramtype value: list[~azure.mgmt.chaos.models.Experiment]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExperimentUpdate(_serialization.Model):
    """Describes an experiment update.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.chaos.models.ManagedServiceIdentity
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity: ~azure.mgmt.chaos.models.ManagedServiceIdentity
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity


class KeyValuePair(_serialization.Model):
    """A map to describe the settings of an action.

    All required parameters must be populated in order to send to server.

    :ivar key: The name of the setting for the action. Required.
    :vartype key: str
    :ivar value: The value of the setting for the action. Required.
    :vartype value: str
    """

    _validation = {
        "key": {"required": True, "min_length": 1},
        "value": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: str, value: str, **kwargs: Any) -> None:
        """
        :keyword key: The name of the setting for the action. Required.
        :paramtype key: str
        :keyword value: The value of the setting for the action. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.chaos.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.chaos.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.chaos.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str, ~azure.mgmt.chaos.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.chaos.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.chaos.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.chaos.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.chaos.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.is_data_action: Optional[bool] = None
        self.display = display
        self.origin: Optional[Union[str, "_models.Origin"]] = None
        self.action_type: Optional[Union[str, "_models.ActionType"]] = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider: Optional[str] = None
        self.resource: Optional[str] = None
        self.operation: Optional[str] = None
        self.description: Optional[str] = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.chaos.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Operation"]] = None
        self.next_link: Optional[str] = None


class OperationStatusResult(_serialization.Model):
    """The current status of an async operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar resource_id: Fully qualified ID of the resource against which the original async
     operation was started.
    :vartype resource_id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.chaos.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.chaos.models.ErrorDetail
    """

    _validation = {
        "resource_id": {"readonly": True},
        "status": {"required": True},
        "percent_complete": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "operations": {"key": "operations", "type": "[OperationStatusResult]"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[List["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword percent_complete: Percent of the operation that is complete.
        :paramtype percent_complete: float
        :keyword start_time: The start time of the operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword operations: The operations list.
        :paramtype operations: list[~azure.mgmt.chaos.models.OperationStatusResult]
        :keyword error: If present, details of the operation error.
        :paramtype error: ~azure.mgmt.chaos.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.id = id
        self.resource_id: Optional[str] = None
        self.name = name
        self.status = status
        self.percent_complete = percent_complete
        self.start_time = start_time
        self.end_time = end_time
        self.operations = operations
        self.error = error


class StepStatus(_serialization.Model):
    """Model that represents the a list of branches and branch statuses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar step_name: The name of the step.
    :vartype step_name: str
    :ivar step_id: The id of the step.
    :vartype step_id: str
    :ivar status: The value of the status of the step.
    :vartype status: str
    :ivar branches: The array of branches.
    :vartype branches: list[~azure.mgmt.chaos.models.BranchStatus]
    """

    _validation = {
        "step_name": {"readonly": True},
        "step_id": {"readonly": True},
        "status": {"readonly": True},
        "branches": {"readonly": True},
    }

    _attribute_map = {
        "step_name": {"key": "stepName", "type": "str"},
        "step_id": {"key": "stepId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "branches": {"key": "branches", "type": "[BranchStatus]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.step_name: Optional[str] = None
        self.step_id: Optional[str] = None
        self.status: Optional[str] = None
        self.branches: Optional[List["_models.BranchStatus"]] = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.chaos.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.chaos.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.chaos.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.chaos.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Target(ProxyResource):
    """Model that represents a Target resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.chaos.models.SystemData
    :ivar properties: The properties of the target resource. Required.
    :vartype properties: dict[str, any]
    :ivar location: Azure resource location.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "{object}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, properties: Dict[str, Any], location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The properties of the target resource. Required.
        :paramtype properties: dict[str, any]
        :keyword location: Azure resource location.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.location = location


class TargetListResult(_serialization.Model):
    """Model that represents a list of Target resources and a link for pagination.

    All required parameters must be populated in order to send to server.

    :ivar value: The Target items on this page. Required.
    :vartype value: list[~azure.mgmt.chaos.models.Target]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Target]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Target"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Target items on this page. Required.
        :paramtype value: list[~azure.mgmt.chaos.models.Target]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TargetReference(_serialization.Model):
    """Model that represents a reference to a Target in the selector.

    All required parameters must be populated in order to send to server.

    :ivar type: Enum of the Target reference type. Required. "ChaosTarget"
    :vartype type: str or ~azure.mgmt.chaos.models.TargetReferenceType
    :ivar id: String of the resource ID of a Target resource. Required.
    :vartype id: str
    """

    _validation = {
        "type": {"required": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.TargetReferenceType"],
        id: str,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Enum of the Target reference type. Required. "ChaosTarget"
        :paramtype type: str or ~azure.mgmt.chaos.models.TargetReferenceType
        :keyword id: String of the resource ID of a Target resource. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.id = id


class TargetType(ProxyResource):
    """Model that represents a Target Type resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.chaos.models.SystemData
    :ivar display_name: Localized string of the display name.
    :vartype display_name: str
    :ivar description: Localized string of the description.
    :vartype description: str
    :ivar properties_schema: URL to retrieve JSON schema of the Target Type properties.
    :vartype properties_schema: str
    :ivar resource_types: List of resource types this Target Type can extend.
    :vartype resource_types: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "properties_schema": {"readonly": True, "max_length": 2048},
        "resource_types": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "properties_schema": {"key": "properties.propertiesSchema", "type": "str"},
        "resource_types": {"key": "properties.resourceTypes", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_name: Optional[str] = None
        self.description: Optional[str] = None
        self.properties_schema: Optional[str] = None
        self.resource_types: Optional[List[str]] = None


class TargetTypeListResult(_serialization.Model):
    """Model that represents a list of Target Type resources and a link for pagination.

    All required parameters must be populated in order to send to server.

    :ivar value: The TargetType items on this page. Required.
    :vartype value: list[~azure.mgmt.chaos.models.TargetType]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TargetType]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.TargetType"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The TargetType items on this page. Required.
        :paramtype value: list[~azure.mgmt.chaos.models.TargetType]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None
