# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.netapp.aio import NetAppManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetAppManagementRansomwareReportsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetAppManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_ransomware_reports_get(self, resource_group):
        response = await self.client.ransomware_reports.get(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            volume_name="str",
            ransomware_report_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_ransomware_reports_list(self, resource_group):
        response = self.client.ransomware_reports.list(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            volume_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_ransomware_reports_begin_clear_suspects(self, resource_group):
        response = await (
            await self.client.ransomware_reports.begin_clear_suspects(
                resource_group_name=resource_group.name,
                account_name="str",
                pool_name="str",
                volume_name="str",
                ransomware_report_name="str",
                body={"extensions": ["str"], "resolution": "str"},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
