// Copyright John Maddock 2008
// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)
//
// High precision test data generated with NTL::RR at 1000 bit precision, a few values
// (5) are commented out as they are too close to numeric_limits<double>::min(), to expect
// our implementation to cope :-(
//
#define SC_(x) static_cast<typename table_type<T>::type>(BOOST_JOIN(x, L))
   static const std::array<std::array<T, 7>, 1542-5> hypergeometric_dist_data2 = {{
      {{ SC_(3.0), SC_(3.0), SC_(4.0), SC_(3.0), SC_(0.25), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(15.0), SC_(1.0), SC_(0.4351648351648351648351648351648351648351648351648351648351648351648351648351648351648351648351648352), SC_(0.9186813186813186813186813186813186813186813186813186813186813186813186813186813186813186813186813187), SC_(0.08131868131868131868131868131868131868131868131868131868131868131868131868131868131868131868131868132) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(29.0), SC_(1.0), SC_(0.2668308702791461412151067323481116584564860426929392446633825944170771756978653530377668308702791461), SC_(0.9783798576902025177887246852764094143404488232074438970990695128626163108921729611384783798576902025), SC_(0.02162014230979748221127531472359058565955117679255610290093048713738368910782703886152162014230979748) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(36.0), SC_(0.0), SC_(0.7641456582633053221288515406162464985994397759103641456582633053221288515406162464985994397759103641), SC_(0.7641456582633053221288515406162464985994397759103641456582633053221288515406162464985994397759103641), SC_(0.2358543417366946778711484593837535014005602240896358543417366946778711484593837535014005602240896359) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(126.0), SC_(1.0), SC_(0.06915207373271889400921658986175115207373271889400921658986175115207373271889400921658986175115207373), SC_(0.9988632872503840245775729646697388632872503840245775729646697388632872503840245775729646697388632873), SC_(0.00113671274961597542242703533026113671274961597542242703533026113671274961597542242703533026113671275) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(244.0), SC_(1.0), SC_(0.03627933583224194252510198858932092911228529708410483373225549082479037769648797964744313477547456683), SC_(0.9996972540440001940250325744612878244274170752064443072888179693942237409698909947295441582575213971), SC_(0.000302745955999805974967425538712175572582924793555692711182030605776259030109005270455841742478602886) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(312.0), SC_(1.0), SC_(0.02847574062696975257912919981170162686602889901302928997151588169117471057103875276264032617108024223), SC_(0.9998148931247157572227585711664126766294591209019172923332242904901342822720273192215936744512618385), SC_(0.0001851068752842427772414288335873233705408790980827076667757095098657177279726807784063255487381615377) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(835.0), SC_(2.0), SC_(0.2581655589043871544223599921164347357001646994902729971495771013355154666872564732609107917496038177e-4), SC_(0.999999989656828569535771056796474674822326294063914283242267742404763568288643161568250269995561228), SC_(0.1034317143046422894320352532517767370593608571675773225759523643171135683843174973000443877201938372e-7) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(1339.0), SC_(2.0), SC_(0.1003947183170306346342155134292225965295905454265948800011213749375291485656947505252493605792007758e-4), SC_(0.9999999974951417585571198943559003635423503859882598446458363273173309646325062733110092184319021812), SC_(0.2504858241442880105644099636457649614011740155354163672682669035367493726688990781568097818842334726e-8) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(2247.0), SC_(0.0), SC_(0.9959982256598179603781831335142372603637685458403018690405199622630601323646210027212323518973270201), SC_(0.9959982256598179603781831335142372603637685458403018690405199622630601323646210027212323518973270201), SC_(0.004001774340182039621816866485762739636231454159698130959480037736939867635378997278767648102672979931) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(6337.0), SC_(3.0), SC_(0.2358879496308800831829226846824974806129072443631243697852416096666081626809510143119559709141024524e-10), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(10473.0), SC_(0.0), SC_(0.9991408114976269951015415508516841451171918547688566755322788787348098070250189775285068875184289701), SC_(0.9991408114976269951015415508516841451171918547688566755322788787348098070250189775285068875184289701), SC_(0.0008591885023730048984584491483158548828081452311433244677211212651901929749810224714931124815710299385) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(19470.0), SC_(1.0), SC_(0.0004621546458171547706035663976460440873902809077223878291601948898604009482839619586692293887835934892), SC_(0.9999999525159191114148724475287847286487033774428645094517372539046053407646527981249525685746332899), SC_(0.474840808885851275524712152713512966225571354905482627460953946592353472018750474314253667100720009e-7) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(50688.0), SC_(1.0), SC_(0.000177542806299746271839033476123055921258690574273239708494936745387243192897196272502864976921637669), SC_(0.9999999929940820013404761079588834178272825101176741447805926107966813260382970495239146011235174132), SC_(0.7005917998659523892041116582172717489882325855219407389203318673961702950476085398876482586792219422e-8) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(130605.0), SC_(0.0), SC_(0.9999310909828938264780256376352712049908502603854155913311921295205351793875440461586537741274280803), SC_(0.9999310909828938264780256376352712049908502603854155913311921295205351793875440461586537741274280803), SC_(0.6890901710617352197436236472879500914973961458440866880787047946482061245595384134622587257191965793e-4) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(256574.0), SC_(3.0), SC_(0.3552371635159513860325600038240152740963615324848620192169438646974730526842238040838310286570387811e-15), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(523360.0), SC_(0.0), SC_(0.9999828034897454825588550340971601268382643851743865821447352933652727689275377226040612992775727358), SC_(0.9999828034897454825588550340971601268382643851743865821447352933652727689275377226040612992775727358), SC_(0.1719651025451744114496590283987316173561482561341785526470663472723107246227739593870072242726417493e-4) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(1030167.0), SC_(0.0), SC_(0.9999912635693755541371926426083995287806774581972598520754866150606576927567956450750202377959147594), SC_(0.9999912635693755541371926426083995287806774581972598520754866150606576927567956450750202377959147594), SC_(0.8736430624445862807357391600471219322541802740147924513384939342307243204354924979762204085240624246e-5) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(2063277.0), SC_(2.0), SC_(0.4228218588078016537393349224242898158519654500706774154042360990115337890442550174169690336289444862e-11), SC_(0.9999999999999999993169078871608882230549845820699047309406224442792096195912643384389346637753886614), SC_(0.6830921128391117769450154179300952690593775557207903804087356615610653362246113385544044834804609231e-18) }}, 
      {{ SC_(3.0), SC_(3.0), SC_(2427690.0), SC_(1.0), SC_(0.3707221750341069722722473098862872930454653367564927579893098340856950440114769756467321264276216895e-5), SC_(0.9999999999969458799372235119189781595585754725019076995712217203898365865515984553898056310910853473), SC_(0.3054120062776488081021840441424527498092300428778279610163413448401544610194368908914652696290939e-11) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(15.0), SC_(3.0), SC_(0.008791208791208791208791208791208791208791208791208791208791208791208791208791208791208791208791208791), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(29.0), SC_(3.0), SC_(0.001094690749863163656267104542966611932129173508483853311439518336070060207991242474001094690749863164), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(36.0), SC_(0.0), SC_(0.6946778711484593837535014005602240896358543417366946778711484593837535014005602240896358543417366947), SC_(0.6946778711484593837535014005602240896358543417366946778711484593837535014005602240896358543417366947), SC_(0.3053221288515406162464985994397759103641456582633053221288515406162464985994397759103641456582633053) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(126.0), SC_(1.0), SC_(0.09070353302611367127496159754224270353302611367127496159754224270353302611367127496159754224270353303), SC_(0.9977388632872503840245775729646697388632872503840245775729646697388632872503840245775729646697388633), SC_(0.002261136712749615975422427035330261136712749615975422427035330261136712749615975422427035330261136713) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(244.0), SC_(2.0), SC_(0.0006021466528172936518689126736816751719881377109394993150581824203284709991118336870944918634933538063), SC_(0.999998327370408840850967030798128662013411144061914056946347060604387976469446911573091404189268074), SC_(0.1672629591159149032969201871337986588855938085943053652939395612023530553088426908595810731925982795e-5) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(312.0), SC_(1.0), SC_(0.03772190883486392251043220859629945824324000861704419426647411296306639113401897345471663488466724646), SC_(0.9996305841238939465264535278019356434458602283516711480615639935212593650515027965499908244436820311), SC_(0.0003694158761060534735464721980643565541397716483288519384360064787406349484972034500091755563179689308) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(835.0), SC_(0.0), SC_(0.9856803963130937982395818793635577696378167861294347575759722749221172120250331640862953547420777642), SC_(0.9856803963130937982395818793635577696378167861294347575759722749221172120250331640862953547420777642), SC_(0.0143196036869062017604181206364422303621832138705652424240277250778827879749668359137046452579222358) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(1339.0), SC_(2.0), SC_(0.2006391451395746964620923808802577340823403864438685101818817897329362475077881616036046352892710116e-4), SC_(0.9999999899805670342284795774236014541694015439530393785833453092693238585300250932440368737276087246), SC_(0.1001943296577152042257639854583059845604696062141665469073067614146997490675596312627239127536933891e-7) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(2247.0), SC_(0.0), SC_(0.9946666772297914657787470598063305260584693900303549414081128500140453460914062687603750893947904866), SC_(0.9946666772297914657787470598063305260584693900303549414081128500140453460914062687603750893947904866), SC_(0.00533332277020853422125294019366947394153060996964505859188714998595465390859373123962491060520951338) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(6337.0), SC_(1.0), SC_(0.001891847586779657220992289872156166488235360255077830625107557828393192391528917256534678376235067316), SC_(0.9999991035786138127295078882572136695730741748298899712547699421248349449556601798499554117049193322), SC_(0.8964213861872704921117427863304269258251701100287452300578751650550443398201500445882950806677721395e-6) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(10473.0), SC_(1.0), SC_(0.001145147061888397702122110660001930252283314446726483295739001580211816397736411435562758610336308275), SC_(0.9999996717940432933781331338466855928064043406039015380040831299199686693233212861051789564761812013), SC_(0.3282059567066218668661533144071935956593960984619959168700800313306766787138948210435238187987321505e-6) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(19470.0), SC_(0.0), SC_(0.9993837621484391269391302975464367060307904716165822291704854305575073462056712912693552634670662399), SC_(0.9993837621484391269391302975464367060307904716165822291704854305575073462056712912693552634670662399), SC_(0.0006162378515608730608697024535632939692095283834177708295145694424926537943287087306447365329337601333) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(50688.0), SC_(2.0), SC_(0.1401146740059159687000362838102443888793059676616274704507737953139928522420410555413751420906679839e-7), SC_(0.9999999999998157016362745429606976083395019540829725278619661333353710917379396616259673781922745177), SC_(0.1842983637254570393023916604980459170274721380338666646289082620603383740326218077254822588202299001e-12) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(130605.0), SC_(3.0), SC_(0.1077312767938766344390907616615286138463711258594000990959287806376972053683257695934949699507976875e-13), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(256574.0), SC_(3.0), SC_(0.1420948654063805544130240015296061096385446129939448076867775458789892210736894719317979792309046884e-14), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(523360.0), SC_(2.0), SC_(0.1314318489170914747961350984206668104616213903674985872735338593180689053854775895523763664456140065e-9), SC_(0.9999999999999998325781444917144037122785784811016969180680195157170424802825618788227889935366343215), SC_(0.1674218555082855962877214215188983030819319804842829575197174381211772110064633656785356306142944377e-15) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(1030167.0), SC_(1.0), SC_(0.116485289360067976066396337974349660300380614138788758148273861062187583424300947722703945197920028e-4), SC_(0.9999999999660775592353976223337476050051999867433202612323477356002373559905965339602305294458630394), SC_(0.3392244076460237766625239499480001325667973876765226439976264400940346603976947055413696055605937866e-10) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(2063277.0), SC_(3.0), SC_(0.2732368451356447107780061671720381076237510222883161521634942646244261344898444398493772797510164856e-17), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(4.0), SC_(3.0), SC_(2427690.0), SC_(3.0), SC_(0.1677382432156413377242616054304921472914716600670585866309205358076859280920068600936144194911254535e-17), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(15.0), SC_(2.0), SC_(0.2417582417582417582417582417582417582417582417582417582417582417582417582417582417582417582417582418), SC_(0.967032967032967032967032967032967032967032967032967032967032967032967032967032967032967032967032967), SC_(0.03296703296703296703296703296703296703296703296703296703296703296703296703296703296703296703296703297) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(29.0), SC_(2.0), SC_(0.07578628268283440697233800682076544145509662751042061386888973095869647593785524820007578628268283441), SC_(0.9957475474716854027198854785061681613405751336785819544440234095406509199612647888509957475474716854), SC_(0.004252452528314597280114521493831838659424866321418045555976590459349080038735211149004252452528314597) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(36.0), SC_(2.0), SC_(0.05052202699261522790934555640437993379169849758085052202699261522790934555640437993379169849758085052), SC_(0.9978100331041507512095747389865036923860453272217978100331041507512095747389865036923860453272217978), SC_(0.00218996689584924879042526101349630761395467277820218996689584924879042526101349630761395467277820219) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(126.0), SC_(1.0), SC_(0.1179883356437251008454785008679579883356437251008454785008679579883356437251008454785008679579883356), SC_(0.995526581993930538383724851073395526581993930538383724851073395526581993930538383724851073395526582), SC_(0.004473418006069461616275148926604473418006069461616275148926604473418006069461616275148926604473418006) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(244.0), SC_(4.0), SC_(0.6940371747548336236386729756589155970356589568228438393939400879765686942275630326123695983095364296e-8), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(312.0), SC_(2.0), SC_(0.0007324642492206586895229555067242613251114564780008581410965847177294444880392033680527501919352863389), SC_(0.9999968162485042758712150055552977741084159565906715771321122858801240872955223982340171995396496742), SC_(0.3183751495724128784994444702225891584043409328422867887714119875912704477601765982800460350325761298e-5) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(835.0), SC_(2.0), SC_(0.0001028941677509724898412851084980980319980090827127785192792956118852539541178586164607109839551672529), SC_(0.9999998346584374697424940569628764124242063834736297681756742475761483873064351548770776333425052069), SC_(0.1653415625302575059430371235875757936165263702318243257524238516126935648451229223666574947930983215e-6) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(1339.0), SC_(0.0), SC_(0.9880909320426824437134692361830228840844758238421095618838255536221414907847590547315977953304078473), SC_(0.9880909320426824437134692361830228840844758238421095618838255536221414907847590547315977953304078473), SC_(0.01190906795731755628653076381697711591552417615789043811617444637785850921524094526840220466959215269) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(2247.0), SC_(0.0), SC_(0.9928936528497027109377867263663905429460657012780726687852819893188331440484625855718539216775092202), SC_(0.9928936528497027109377867263663905429460657012780726687852819893188331440484625855718539216775092202), SC_(0.007106347150297289062213273633609457053934298721927331214718010681166855951537414428146078322490779845) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(6337.0), SC_(2.0), SC_(0.1792088020315431532357710646185190863500499136480420547938955947325411169746369362047374527535586343e-5), SC_(0.9999999996226239704452740671125367621685059250794582114650439116028086076612450530346364353921831), SC_(0.3773760295547259328874632378314940749205417885349560883971913923387549469653635646078168999789679461e-9) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(10473.0), SC_(0.0), SC_(0.9984729184189811975305760619552847385187612855550137652891623349764942906131013656439544533776439971), SC_(0.9984729184189811975305760619552847385187612855550137652891623349764942906131013656439544533776439971), SC_(0.001527081581018802469423938044715261481238714444986234710837665023505709386898634356045546622356002859) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(19470.0), SC_(1.0), SC_(0.0008213972463335401464543116433319457182150638283179388537898888831828282498223013643761074749819211917), SC_(0.9999998100831892820489710312789356653194517694878206833108278472198944673930380172926373440733026808), SC_(0.1899168107179510289687210643346805482305121793166891721527801055326069619827073626559266973192396099e-6) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(50688.0), SC_(3.0), SC_(0.7371789102938592940714151264226464838607396937246521085174380076366727946705655482101878509258780512e-12), SC_(0.9999999999999999963638480077842154621211076157039377127853972963625004512398488298246350195793270647), SC_(0.36361519922157845378788923842960622872146027036374995487601511701753649804206729352960887603872921e-17) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(130605.0), SC_(0.0), SC_(0.9998774974256664887745632210109924461885365380324673187739144251096710547802769442529237855403490051), SC_(0.9998774974256664887745632210109924461885365380324673187739144251096710547802769442529237855403490051), SC_(0.0001225025743335112254367789890075538114634619675326812260855748903289452197230557470762144596509948626) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(256574.0), SC_(1.0), SC_(0.6235798935432414171546777011609626623238870428651025037671732799539967626564678889992049737857949758e-4), SC_(0.9999999989062844533612416787311455174190619319966037232755788855667556924413564130505504850433584283), SC_(0.1093715546638758321268854482580938068003396276724421114433244307558643586949449514956641571746668899e-8) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(523360.0), SC_(3.0), SC_(0.6696861424335152985878223261020262674063600454629049884930495974667144650174002263610433343666241457e-15), SC_(0.9999999999999999999996801000932283592341600066082637696580308814432896035449612455014051303261159029), SC_(0.3198999067716407658399933917362303419691185567103964550387544985948696738840970830200887735256048232e-21) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(1030167.0), SC_(2.0), SC_(0.6784470590706022112968207274240780708724860166271899900303671710262234388309601436183511216413409852e-10), SC_(0.9999999999999999121889277328985886413764038902869445620637072351017557145419077058975906484065703422), SC_(0.8781107226710141135862359610971305543793629276489824428545809229410240935159342965780088505914835162e-16) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(2063277.0), SC_(1.0), SC_(0.7754620542052528941190130444500341980100874627945521672464928007244219390588010229186090977433172526e-5), SC_(0.9999999999830871393095262177694582876721508254747002268433419655222049927185780598810230027191687018), SC_(0.1691286069047378223054171232784917452529977315665803447779500728142194011897699728083129819773498922e-10) }}, 
      {{ SC_(4.0), SC_(4.0), SC_(2427690.0), SC_(4.0), SC_(0.6909385073761211298007593459556036148460310578219456899959530854170369724209916101428960933055832492e-24), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(29.0), SC_(1.0), SC_(0.3735632183908045977011494252873563218390804597701149425287356321839080459770114942528735632183908046), SC_(0.4731800766283524904214559386973180076628352490421455938697318007662835249042145593869731800766283525), SC_(0.5268199233716475095785440613026819923371647509578544061302681992337164750957854406130268199233716475) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(36.0), SC_(1.0), SC_(0.4411764705882352941176470588235294117647058823529411764705882352941176470588235294117647058823529412), SC_(0.6274509803921568627450980392156862745098039215686274509803921568627450980392156862745098039215686275), SC_(0.3725490196078431372549019607843137254901960784313725490196078431372549019607843137254901960784313725) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(126.0), SC_(3.0), SC_(0.001397849462365591397849462365591397849462365591397849462365591397849462365591397849462365591397849462), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(244.0), SC_(3.0), SC_(0.000190261615994353202500246712864695974482362957276022353021856250867676600413808560852773470756580543), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(312.0), SC_(2.0), SC_(0.006220428777736111000295213551099869946462623570807369168535022699528456192702640166596187755818499517), SC_(0.9999092417798983507934861528887044912353490301835909138056218234622964422777720153511046571932372161), SC_(0.9075822010164920651384711129550876465096981640908619437817653770355772222798464889534280676278394357e-4) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(835.0), SC_(0.0), SC_(0.9470077437773024171112463423313580806466385287583348507627752776895878758171945812745466083732420293), SC_(0.9470077437773024171112463423313580806466385287583348507627752776895878758171945812745466083732420293), SC_(0.05299225622269758288875365766864191935336147124166514923722472231041212418280541872545339162675797067) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(1339.0), SC_(2.0), SC_(0.0003482253927253891922866427314603424493399121163973358337763446492967889778843034984535969587754613737), SC_(0.9999988602895001434895519319346654117694256246582293138555289293855889077903543565091943865154924267), SC_(0.11397104998565104480680653345882305743753417706861444710706144110922096456434908056134845075732623e-5) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(2247.0), SC_(3.0), SC_(0.2409536321989971546897667307498297245553381432991656758066372309059954805624651069021371827245364882e-6), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(6337.0), SC_(3.0), SC_(0.1073290170820504378482298215305363536788727961852215882522849323983067140198327115119399667659166158e-7), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(10473.0), SC_(3.0), SC_(0.2377243947618723127512810946787116527508440650772201314525874976208377993804676105173729465335144838e-8), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(19470.0), SC_(2.0), SC_(0.1660889923926911474538532700522835604228350954619785751021455084158410437661557823648675618663185022e-5), SC_(0.9999999996300596417193549358519502251898078839206962664258165893381493001960192634352736793038159335), SC_(0.3699403582806450641480497748101921160793037335741834106618506998039807365647263206961840665231115443e-9) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(50688.0), SC_(3.0), SC_(0.2096393887377073822064705138165272306187495570135233310153831480936349004621073062877360694080115114e-10), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(130605.0), SC_(1.0), SC_(0.0003444764978075083563469401077906776992105943278589273740071374168532506402039630819485944353675653312), SC_(0.9999999630686275358815517133559911084661681962487835477483196039122677182788077037744590820609926144), SC_(0.3693137246411844828664400889153383180375121645225168039608773228172119229622554091793900738557962078e-7) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(256574.0), SC_(3.0), SC_(0.1616329093997578806448148017399269497138444972806122187437094584373502389547539543732095426759649899e-12), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(523360.0), SC_(2.0), SC_(0.2300009012988322791466436142801205601193359423571860440582858719655948371885382367566621110249191068e-8), SC_(0.9999999999999809557639359325134222716883022253180244302372199128135821321414137160922499668789868252), SC_(0.1904423606406748657772831169777468197556976278008718641786785858628390775003312101317480773689833236e-13) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(1030167.0), SC_(1.0), SC_(0.436810506489414800730613664088031211555041532707759641899047960216928611853607350679405851034465152e-4), SC_(0.9999999994063615125303878748337095866398800261952676539693104741682709877785764111155982827455610354), SC_(0.5936384874696121251662904133601199738047323460306895258317290122214235888844017172544389645776595582e-9) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(2063277.0), SC_(1.0), SC_(0.2180966943488266662892248676295050649564700803712134940657769292131494536971235317105256971434073151e-4), SC_(0.9999999998520128993064202566762132178889099981785036852741952598447735943781707304773829605082534598), SC_(0.1479871006935797433237867821110900018214963147258047401552264056218292695226170394917465402002419188e-9) }}, 
      {{ SC_(15.0), SC_(3.0), SC_(2427690.0), SC_(2.0), SC_(0.1068936591446146721969335331529108812149036588677403192535452530888193839728753312881753048015865741e-9), SC_(0.9999999999999998091977483422079783386524238228151824559509866737208577073278905187572568148999547951), SC_(0.1908022516577920216613475761771848175440490133262791422926721094812427431851000452049461661225240455e-15) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(29.0), SC_(3.0), SC_(0.2681992337164750957854406130268199233716475095785440613026819923371647509578544061302681992337164751), SC_(0.9425287356321839080459770114942528735632183908045977011494252873563218390804597701149425287356321839), SC_(0.05747126436781609195402298850574712643678160919540229885057471264367816091954022988505747126436781609) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(36.0), SC_(0.0), SC_(0.1016042780748663101604278074866310160427807486631016042780748663101604278074866310160427807486631016), SC_(0.1016042780748663101604278074866310160427807486631016042780748663101604278074866310160427807486631016), SC_(0.8983957219251336898395721925133689839572192513368983957219251336898395721925133689839572192513368984) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(126.0), SC_(0.0), SC_(0.5983545015173654040687872316511183545015173654040687872316511183545015173654040687872316511183545015), SC_(0.5983545015173654040687872316511183545015173654040687872316511183545015173654040687872316511183545015), SC_(0.4016454984826345959312127683488816454984826345959312127683488816454984826345959312127683488816454985) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(244.0), SC_(2.0), SC_(0.01902446120835717090764675653767923310502355836315801933477910993355211744807999855584744677014219593), SC_(0.9992673743583287976268870168068944486957691584051778060431357568431319340863733844627743826520244533), SC_(0.0007326256416712023731129831931055513042308415948221939568642431568680659136266155372256173479755466551) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(312.0), SC_(1.0), SC_(0.1674118788324602288629305123384313896517541347520109341336040012707119108481413282007024548738084074), SC_(0.9877300851115153502912900227967451989453493950368645113882636074972002740040338363841444837554696037), SC_(0.01226991488848464970870997720325480105465060496313548861173639250279972599596616361585551624453039627) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(835.0), SC_(0.0), SC_(0.9299342868582404744950580068325956152503649975908167945591194734043188636329903520448372344242052139), SC_(0.9299342868582404744950580068325956152503649975908167945591194734043188636329903520448372344242052139), SC_(0.0700657131417595255049419931674043847496350024091832054408805265956811363670096479551627655757947861) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(1339.0), SC_(4.0), SC_(0.1023692065739380641977304192743919677582642308999530962039474021939110460158824076898339378059816438e-7), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(2247.0), SC_(0.0), SC_(0.9735464328138171329295904086746548663660825700228808451945030570463649592027586278373738557527325153), SC_(0.9735464328138171329295904086746548663660825700228808451945030570463649592027586278373738557527325153), SC_(0.02645356718618286707040959132534513363391742997711915480549694295363504079724137216262614424726748472) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(6337.0), SC_(2.0), SC_(0.3125268056194895374738247521831257887970756765910368175437447847305819231481147043431201817444873683e-4), SC_(0.9999999571293948188210281408238950943705439205007618647599276478874520101490390795426649628657852987), SC_(0.4287060518117897185917610490562945607949923813524007235211254798985096092045733503713421470125813673e-7) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(10473.0), SC_(3.0), SC_(0.9498077250886955670498176459025659845151202416724233561532607641332270127682637137691256064364830839e-8), SC_(0.9999999999972753651030157901117331679692984337793599534088570758572769341246895381159831792490845508), SC_(0.2724634896984209888266832030701566220640046591142924142723065875310461884016820750915449243937128755e-11) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(19470.0), SC_(1.0), SC_(0.003075020538005377423658642746475029079786494251481674425062313489455935158035328903943605462719170505), SC_(0.9999966789593487381737906211536794567465679305818405230302643467710701133930889595624604964762742481), SC_(0.3321040651261826209378846320543253432069418159476969735653228929886606911040437539503523725751930428e-5) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(50688.0), SC_(3.0), SC_(0.8383590210520545469901138677419263574741163107464747165861702881206480269204982564086771111857288993e-10), SC_(0.9999999999999950366525306254541057953118954358749779520673095348131159423936527106268017257814433208), SC_(0.4963347469374545894204688104564125022047932690465186884057606347289373198274218556679161157928653717e-14) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(130605.0), SC_(1.0), SC_(0.0004592527617819727236299006630441495983676931143110785227060745470159451338974493194633098345955701677), SC_(0.9999999261421565070679271987454835429657333717566579292663420224056764262810460469089291281241018582), SC_(0.7385784349293207280125451645703426662824334207073365797759432357371895395309107087187589814177073204e-7) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(256574.0), SC_(1.0), SC_(0.0002338123844641967863025857659150177449161469428896372434752616894307771088829533721978871619620987119), SC_(0.9999999808610720418970724817674698938233660649427858478607958949176664159600518931013611242485677406), SC_(0.1913892795810292751823253010617663393505721415213920410508233358403994810689863887575143225938796146e-7) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(523360.0), SC_(1.0), SC_(0.0001146346397682874801226008804487274677864675420977415877682888644075881868141022194865935741439758461), SC_(0.9999999954000200611854924338104142349062114078173690420182988034780448130215760820949768939904127313), SC_(0.4599979938814507566189585765093788592182630957981701196521955186978423917905023106009587268742921838e-8) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(1030167.0), SC_(3.0), SC_(0.9988400389873903278637757346887488751395211214891713169479380388325382978185175148248718618309219913e-14), SC_(0.9999999999999999999709118642980630918195438420343187546554434358767685356059706323290414678404857834), SC_(0.2908813570193690818045615796568124534455656412323146439402936767095853215951421661578494421020230272e-19) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(2063277.0), SC_(2.0), SC_(0.2959717149427146688272278085036762843316574652903093740260263066353784498182762125530147489288002537e-9), SC_(0.9999999999999987567777775910898271221407481403443324179193499468577867476958599553716677609536975651), SC_(0.1243222222408910172877859251859655667582080650053142213252304140044628332239046302434854468039703959e-14) }}, 
      {{ SC_(15.0), SC_(4.0), SC_(2427690.0), SC_(2.0), SC_(0.2137861734813781840171475302734329183642784470469896751957984853460487362786469130886996431157151929e-9), SC_(0.9999999999999992367938227620196185706362294007824180206067411920652116969120955029138099444563810467), SC_(0.763206177237980381429363770599217581979393258807934788303087904497086190055543618953346415774062173e-15) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(29.0), SC_(3.0), SC_(0.0005338533003879896996806034547225871068593670141193593089935940182643456393578236681452875213580000505), SC_(0.0005530000737505344335056414001461601500591293620475623901155717290993306236458654057903968552359527151), SC_(0.9994469999262494655664943585998538398499408706379524376098844282709006693763541345942096031447640473) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(36.0), SC_(15.0), SC_(0.1796008441641981608241362614650354082345866340017272141342933271447192854610587869195756902757292505e-9), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(126.0), SC_(3.0), SC_(0.1743834370980068591272528273100785145497638564403968197792175885457926293267975097229565456667627551), SC_(0.9194237739160238565488009422862269799078200393056282976099055627091305587890512015594272216030312741), SC_(0.08057622608397614345119905771377302009217996069437170239009443729086944121094879844057277839696872589) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(244.0), SC_(4.0), SC_(0.007631083659385376993817238544862760794540114932445662098714861299763208671458829621558612789522337371), SC_(0.99908939670470760076500192820774727205190052384859796164773254086685320756736555741146081130839513), SC_(0.00091060329529239923499807179225272794809947615140203835226745913314679243263444258853918869160487002) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(312.0), SC_(9.0), SC_(0.3229946309121264421592979319598236377706458517385969709366388331294108775320060984050428555388062903e-9), SC_(0.9999999999959868456549869411094883481798153316019932801922524612050866783980786241926301951637625205), SC_(0.4013154345013058890511651820184668398006719807747538794913321601921375807369804836237479518559456548e-11) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(835.0), SC_(13.0), SC_(0.7823305762917541055106361700172536858098373092808982810633970875745793585105782227439270634481632098e-24), SC_(0.9999999999999999999999999997270559286922561506869702995386221380100996018922163723256500285962484861), SC_(0.2729440713077438493130297004613778619899003981077836276743499714037515138866162870493901888077966996e-27) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(1339.0), SC_(14.0), SC_(0.3523301042186689962465730488608373144369122966482695697415356098010266705801145781053387709275455986e-30), SC_(0.9999999999999999999999999999999999822593099587779961607969260392327636235190182956561143131150246827), SC_(0.1774069004122200383920307396076723637648098170434388568688497531727223920342973706471997839514328291e-34) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(2247.0), SC_(9.0), SC_(0.6224538174065764412939893152677726536694459928500739024232814764620150386281782214747456625425094286e-17), SC_(0.999999999999999999989927611454589805212737671550465396338512611281398877216785535491869606965044247), SC_(0.1007238854541019478726232844953460366148738871860112278321446450813039303495575295589976911749758466e-19) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(6337.0), SC_(0.0), SC_(0.965038558040565957583391469990019014819417646448833359265048524323473706594294069058717553053816079), SC_(0.965038558040565957583391469990019014819417646448833359265048524323473706594294069058717553053816079), SC_(0.03496144195943404241660853000998098518058235355116664073495147567652629340570593094128244694618392102) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(10473.0), SC_(8.0), SC_(0.1151265338415215065291878971560799293881557223140343089828047608474791737955698006953048291292525013e-19), SC_(0.9999999999999999999999940009956596569193273260478122791230572695320741091340904457210202828828463336), SC_(0.5999004340343080672673952187720876942730467925890865909554278979717117153666447788291071696845938132e-23) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(19470.0), SC_(10.0), SC_(0.4184658734027306416861067181449924533322714550391317237413128413306005816630939096819262776493640351e-29), SC_(0.9999999999999999999999999999999995110153742029403130226451324203545756418369263998684748235614412521), SC_(0.4889846257970596869773548675796454243581630736001315251764385587479248356980980105605856651095167783e-33) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(50688.0), SC_(3.0), SC_(0.9511524637442751439723098274977467517696047101740646605938190985037281146085513403440272416527661153e-8), SC_(0.999999999993237959402207177561319077679011993013006284241167754545569224904643603562848974555635763), SC_(0.6762040597792822438680922320988006986993715758832245454430775095356396437151025444364237044918218039e-11) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(130605.0), SC_(8.0), SC_(0.1971829461485305341013736385430904817899504367560759437523554392117376371477163782199267746695370789e-28), SC_(0.9999999999999999999999999999999991778616123322654795550798283609938099023171206795619843751861163467), SC_(0.8221383876677345204449201716390061900976828793204380156248138836533041501401487724083612054553315789e-33) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(256574.0), SC_(14.0), SC_(0.3662403447053403569767046168197544752190105787405173532436565329887144094569583483946020725179387891e-62), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999990483271691752764939664180771421), SC_(0.951672830824723506033581922857911760956896409118415525587113900995234386584011247839795073415399036e-69) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(523360.0), SC_(4.0), SC_(0.5959077111333614249469334051667565703421595048591691971301748890744421200809154852703312489610234612e-15), SC_(0.9999999999999999999724432230145230986136658851045209736784923646740612637640564813376392815208725978), SC_(0.2755677698547690138633411489547902632150763532593873623594351866236071847912740216431001639445728119e-19) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(1030167.0), SC_(3.0), SC_(0.1136034967556009714438224303815368875036596898593724179830569359850238120963924837135663213284931809e-11), SC_(0.9999999999999999602984255532405949438258238864179586636049111510217409460400277480067271683361645621), SC_(0.3970157444675940505617417611358204133639508884897825905395997225199327283166383543786366855839526988e-16) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(2063277.0), SC_(10.0), SC_(0.2340467081227185534869161063005325147757060234791904108399066838661169425311739073097136992798196177e-49), SC_(0.9999999999999999999999999999999999999999999999999999999742191873053957367721942032374244036256305858), SC_(0.2578081269460426322780579676257559637436941420924183114103333396100475070256183366032001054027949885e-55) }}, 
      {{ SC_(15.0), SC_(15.0), SC_(2427690.0), SC_(12.0), SC_(0.2366198645507987533431219984230503035479312833373003370282424567252719482433259855808892897015423341e-62), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999993252230771580308162142324162095), SC_(0.674776922841969183785767583790494993164466058107622339908304842131740911583671710820835718606054205e-69) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(36.0), SC_(3.0), SC_(0.5117647058823529411764705882352941176470588235294117647058823529411764705882352941176470588235294118), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(126.0), SC_(3.0), SC_(0.01122580645161290322580645161290322580645161290322580645161290322580645161290322580645161290322580645), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(244.0), SC_(2.0), SC_(0.03650095925307052977197040783727321233530870888049228834126996074338349549477219621283207969745475955), SC_(0.9984720528684761173583826340905327492510801005584910204880398621084165048397537220189977268963856147), SC_(0.001527947131523882641617365909467250748919899441508979511960137891583495160246277981002273103614385284) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(312.0), SC_(0.0), SC_(0.7455301077928398745741345056768768002042558623826127197146800922342878571485562461602291495456104936), SC_(0.7455301077928398745741345056768768002042558623826127197146800922342878571485562461602291495456104936), SC_(0.2544698922071601254258654943231231997957441376173872802853199077657121428514437538397708504543895064) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(835.0), SC_(3.0), SC_(0.3779394840691629255846568153819921972149045720903275366925299392147329788762961351343621927295882813e-4), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(1339.0), SC_(1.0), SC_(0.0622819350257356274571829614262175882333622825644966117020529535097884562300407102837147976522033839), SC_(0.998658613343691957503106105627282018224602116982445670394987013174194211964445871790599341664640466), SC_(0.001341386656308042496893894372717981775397883017554329605012986825805788035554128209400658335359534039) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(2247.0), SC_(1.0), SC_(0.0377587247238282804169545323382188394532912482836720527543988250168853553447671409932473591885706912), SC_(0.9995211843560520666694975629300918075968936183597326148664424599297353259655025943384904392100954234), SC_(0.0004788156439479333305024370699081924031063816402673851335575400702646740344974056615095607899045766158) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(6337.0), SC_(3.0), SC_(0.861934567951235823950399489829845794159563070902856447195272841721786226436195006295887117720130361e-7), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(10473.0), SC_(1.0), SC_(0.008262709747109963576560195439600336272903633068003830818756344208525459586402530759076417565410939173), SC_(0.9999778267508138677885321584316315013494523284254291343756959559949949883360028317507540292668020523), SC_(0.2217324918613221146784156836849865054767157457086562430404400500501166399716824924597073319794768618e-4) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(19470.0), SC_(1.0), SC_(0.004455569057678140115801710310433635772530373727778236104792360179217944475020922065179108856218254406), SC_(0.9999935795427972862200482243853697941888284759608946917491451133265469404512474051113480405346854658), SC_(0.6420457202713779951775614630205811171524039105308250854886673453059548752594888651959465314534186663e-5) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(50688.0), SC_(3.0), SC_(0.1683565552632050054027347818649649452045957980939371981385076973921191046788000213572280434322800137e-9), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(130605.0), SC_(3.0), SC_(0.984125213512063055601094107778063887486600234725619905241309411125363674322485521281724899150131409e-11), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(256574.0), SC_(1.0), SC_(0.0003390094563411942734147570260055467588103187562671762585586477720042796964048873174998154050243872292), SC_(0.9999999629981688090394148917678559162470356600097177383207560658573705969236614513644659869054037949), SC_(0.370018311909605851082321440837529643399902822616792439341426294030763385486355340130945962050600475e-7) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(523360.0), SC_(1.0), SC_(0.0001662157809969209197353606739772589588047328490452731955312685895944640420851106808933448613377842539), SC_(0.9999999911067167830368223279365629331234258496078243093355687366805542072635147816349932065294161766), SC_(0.8893283216963177672063437066876574150392175690664431263319445792736485218365006793470583823361553714e-8) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(1030167.0), SC_(0.0), SC_(0.9999155499687398092862395797309732015831511395115069820892240052537792588266552228327472095644472102), SC_(0.9999155499687398092862395797309732015831511395115069820892240052537792588266552228327472095644472102), SC_(0.8445003126019071376042026902679841684886048849301791077599474622074117334477716725279043555278982411e-4) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(2063277.0), SC_(1.0), SC_(0.4216478869393227584835932844651631874978599345700193864458952335671751958406234530769806902412155056e-4), SC_(0.9999999994277857991152045774889178794822090027312204720615728160481393937645938370215115579546072945), SC_(0.5722142008847954225110821205177909972687795279384271839518606062354061629784884420453927055002477598e-9) }}, 
      {{ SC_(29.0), SC_(3.0), SC_(2427690.0), SC_(3.0), SC_(0.1532288851774883620111129765607545765507593614712580188873459094603210491130071216177245357124722118e-14), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(36.0), SC_(0.0), SC_(0.0005941770647653000594177064765300059417706476530005941770647653000594177064765300059417706476530005942), SC_(0.0005941770647653000594177064765300059417706476530005941770647653000594177064765300059417706476530005942), SC_(0.9994058229352346999405822935234699940582293523469994058229352346999405822935234699940582293523469994) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(126.0), SC_(3.0), SC_(0.03541148701809598741148701809598741148701809598741148701809598741148701809598741148701809598741148702), SC_(0.9976270653029110936270653029110936270653029110936270653029110936270653029110936270653029110936270653), SC_(0.002372934697088906372934697088906372934697088906372934697088906372934697088906372934697088906372934697) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(244.0), SC_(3.0), SC_(0.005452425448591448430667778764074006821871840330695943486662732725152721318721157940506036801279549145), SC_(0.999835159230623979466049578781551250956548060641165006359705545289704685169434011504124236096705502), SC_(0.0001648407693760205339504212184487490434519393588349936402944547102953148305659884958757639032944979974) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(312.0), SC_(2.0), SC_(0.0418319073715776511180041611864439734489068693815210260448688964443383021804669641628100797727281706), SC_(0.9972685503682268107664095471024414261378561299106946085918375583368237113417235126399969510350639489), SC_(0.002731449631773189233590452897558573862143870089305391408162441663176288658276487360003048964936051136) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(835.0), SC_(4.0), SC_(0.1181060887716134142452052548068725616296576787782273552164156060046040558988425422294881852279963379e-5), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(1339.0), SC_(1.0), SC_(0.08130216668030159751895739874799661218486812933569018773082361595888552968951422060987919693521160293), SC_(0.9973533033281825281851411932620618891298909314197166994910517716335699030015408269642939417138457843), SC_(0.002646696671817471814858806737938110870109068580283300508948228366430096998459173035706058286154215737) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(2247.0), SC_(2.0), SC_(0.0009422854654787806164658885075491332483887299036923506926231435833090819515628163527726613701247587822), SC_(0.9999923270887914569777305071838663742210879833115787902127540317213898669412840025148767698951578028), SC_(0.767291120854302226949281613362577891201668842120978724596827861013305871599748512323010484219722474e-5) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(6337.0), SC_(0.0), SC_(0.9818158050819453773960229555414812339117018233186048874265840850296977087740444006979678860613857159), SC_(0.9818158050819453773960229555414812339117018233186048874265840850296977087740444006979678860613857159), SC_(0.01818419491805462260397704445851876608829817668139511257341591497030229122595559930203211393861428415) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(10473.0), SC_(0.0), SC_(0.9889682460970078762060362240305441637597177581878584139864380598531545701694915704540693356040329143), SC_(0.9889682460970078762060362240305441637597177581878584139864380598531545701694915704540693356040329143), SC_(0.01103175390299212379396377596945583624028224181214158601356194014684542983050842954593066439596708574) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(19470.0), SC_(2.0), SC_(0.1281717096779040666178125943310646752256130522194386509828798325557121747578834107207222971943402921e-4), SC_(0.9999999881282811814233791150150863474225897566135056636816942573181747260599852992818840766495451828), SC_(0.1187171881857662088498491365257741024338649433631830574268182527394001470071811592335045481717205539e-7) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(50688.0), SC_(4.0), SC_(0.8636224596711709855916157301941577538363402881409425178260235044283509364997140288621740414795857467e-13), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(130605.0), SC_(0.0), SC_(0.9991121113162878832385849170081960212504967065021088590536054578068695489098338079497717415683209807), SC_(0.9991121113162878832385849170081960212504967065021088590536054578068695489098338079497717415683209807), SC_(0.0008878886837121167614150829918039787495032934978911409463945421931304510901661920502282584316790192733) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(256574.0), SC_(0.0), SC_(0.9995479627219270297395231985179298419901247822078205022881005648746595078072699217232779933952957226), SC_(0.9995479627219270297395231985179298419901247822078205022881005648746595078072699217232779933952957226), SC_(0.0004520372780729702604768014820701580098752177921794977118994351253404921927300782767220066047042773975) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(523360.0), SC_(4.0), SC_(0.7597942685733239829465683047127206852108534840428626203625458096126747035844429655858631772859879897e-17), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(1030167.0), SC_(0.0), SC_(0.9998874014885472443601993560890946286347216550963596524383328971426898070064734578494729098686468785), SC_(0.9998874014885472443601993560890946286347216550963596524383328971426898070064734578494729098686468785), SC_(0.0001125985114527556398006439109053713652783449036403475616671028573101929935265421505270901313531215034) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(2063277.0), SC_(2.0), SC_(0.1144408433809667280016189024339430366489383200482392820389833491807740651706595520778902457200695637e-8), SC_(0.9999999999999900160200382174970123916519241859759120723027692262430561396684641627561403299208784267), SC_(0.9983979961782502987608348075814024087927697230773756943860331535837243859670079121573312501787244651e-14) }}, 
      {{ SC_(29.0), SC_(4.0), SC_(2427690.0), SC_(4.0), SC_(0.1641048048869025295389783522579154145620808365432903208309388173174003954101165903644744795301385787e-19), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(36.0), SC_(15.0), SC_(0.01392961876832844574780058651026392961876832844574780058651026392961876832844574780058651026392961877), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(126.0), SC_(9.0), SC_(0.000961784354275477185051300860645515834375978827890225781770158381560424295505595395489533564811046086), SC_(0.9998621249983798868373361571697162596898838771741716193947918274395696555587925979304803947314795171), SC_(0.0001378750016201131626638428302837403101161228258283806052081725604303444412074020695196052685204828722) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(244.0), SC_(11.0), SC_(0.9391949532974654028380726890893724593186371909325732138205129389893497433571621039878701318234117525e-8), SC_(0.9999999997292418332297512820447721787174178948749777880730348806536018038071343685536595571172609088), SC_(0.2707581667702487179552278212825821051250222119269651193463981961928656314463404428827390912371586078e-9) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(312.0), SC_(8.0), SC_(0.8183295827721627050762027821928500065107283413458891015643795113881955818838137074757987466164816892e-5), SC_(0.9999994959837867918723912323477133539415449697573804836476577469381054547175779713339403705852594608), SC_(0.5040162132081276087676522866460584550302426195163523422530618945452824220286660596294147405392348778e-6) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(835.0), SC_(14.0), SC_(0.1387072449256485995315699613139618832868431246646720744300769016829282495140720615754811642214410521e-20), SC_(0.9999999999999999999999982790664401284292862088094129781404058704326964680884065747282669611879712894), SC_(0.1720933559871570713791190587021859594129567303531911593425271733038812028710571483566763824087357967e-23) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(1339.0), SC_(12.0), SC_(0.3441686314462873938855550167454544016167312881476780464876642033859355127597715563575344467347572723e-18), SC_(0.9999999999999999999989659331259723859810761358507365052671242009531893867350274016551017235121503736), SC_(0.1034066874027614018923864149263494732875799046810613264972598344898276487849626396846705539008121337e-20) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(2247.0), SC_(12.0), SC_(0.6871800383017527545395809879576074646893241870637722101045614713535184828685958111611916988540683981e-21), SC_(0.999999999999999999999998782201796149177840719546526615208465659464575571670216144347519664166808545), SC_(0.1217798203850822159280453473384791534340535424428329783855652480335833191454993288849502435264836742e-23) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(6337.0), SC_(4.0), SC_(0.4623719047488026664833257223019747337013116157998351621996372316793715819031201667205575487431288574e-6), SC_(0.9999999959363759508630350866808954627497078607497261049216310981336513875254708206615363364730373774), SC_(0.4063624049136964913319104537250292139250273895078368901866348612474529179338463663526962622648836554e-8) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(10473.0), SC_(3.0), SC_(0.843097207243845965264910528239192006165213086066315435499897924539810284440122740029423665866256956e-5), SC_(0.9999999366341809149334602632352095540896277788153059739241419451195134449429945367803729322349405925), SC_(0.6336581908506653973676479044591037222118469402607585805488048655505700546321962706776505940750600525e-7) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(19470.0), SC_(11.0), SC_(0.1235731821977367168565799011365513129276486463920398804386772433710952337642668872050569277271758143e-28), SC_(0.9999999999999999999999999999999961848505806870674430755806136427906049590624447728961317645327540395), SC_(0.3815149419312932556924419386357209395040937555227103868235467245960538251433860536724454979384353138e-32) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(50688.0), SC_(1.0), SC_(0.008515771945119741969792826413086638876102624482173128652012191083828220269260167294952318314843163151), SC_(0.999966967716589470843718559035552905267407031148053819643178667958495382422550219370492918441813273), SC_(0.3303228341052915628144096444709473259296885194618035682133204150461757744978062950708155818672700718e-4) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(130605.0), SC_(12.0), SC_(0.4592127279141932954128961260753986912821134173099699998698011053141115026206616392743606692006085345e-42), SC_(0.9999999999999999999999999999999999999999999999862027785652774237916746064956913992119917631302513206), SC_(0.1379722143472257620832539350430860078800823686974867942313365445729104906985502492107469972809759505e-46) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(256574.0), SC_(8.0), SC_(0.5927080867908401810322314381032195813942369498938374902367694362615216349492818668615448331585455583e-28), SC_(0.9999999999999999999999999999999962261677159854568085714891535019359007324262740975793964631161713894), SC_(0.3773832284014543191428510846498064099267573725902420603536883828610609483790213900157109112767104842e-32) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(523360.0), SC_(13.0), SC_(0.200788968418165471261704787475249137507977099578616504043481399279904088913890734220690925233948231e-54), SC_(0.999999999999999999999999999999999999999999999999999999999999123025451438991801992643559333280117877), SC_(0.8769745485610081980073564406667198821230439367983541005901950040362526782192077326023042440412977585e-60) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(1030167.0), SC_(3.0), SC_(0.9121746923778822859015454790995598019589645825928485412439333529465346275317949367615856551379100276e-11), SC_(0.9999999999999993092752162327682516300970548690744983795763590873440126115236718608851932010831392937), SC_(0.6907247837672317483699029451309255016204236409126559873884763281391148067989168607063030285470805344e-15) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(2063277.0), SC_(14.0), SC_(0.4002588538205458217996350910582927631795835897491133404591961706762243768809180941989437609487113852e-68), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999980600545653234811239383967), SC_(0.1939945434676518876061603312148092537492262635170921481369162459753819145712915081498062856422818863e-74) }}, 
      {{ SC_(29.0), SC_(15.0), SC_(2427690.0), SC_(6.0), SC_(0.8360933121367972266830125108955409376186560621646713472109283748375538748322170105557409807541968759e-26), SC_(0.9999999999999999999999999999998981539053575805901839819023896546997571066875219844823395689790002288), SC_(0.1018460946424194098160180976103453002428933124780155176604310209997711923468917820933848245336089246e-30) }}, 
      //{{ SC_(29.0), SC_(29.0), SC_(29.0), SC_(29.0), SC_(1.0), SC_(1.0), SC_(0.9332636185032188789900895447238171696170914463717080246217143397959669109757756344544403270978811024e-301) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(36.0), SC_(29.0), SC_(0.1197937630575201732696988863971786172924692848791520518275736492055277634025262108753569854139114101e-6), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(126.0), SC_(6.0), SC_(0.1915773635590765595162650852040582069373563088849067304309589093786276065567632134549530759119850094), SC_(0.4750450044498295360614999558838301562553402584679779598962879769611894124067020371599827511025126148), SC_(0.5249549955501704639385000441161698437446597415320220401037120230388105875932979628400172488974873852) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(244.0), SC_(22.0), SC_(0.1737405782393416863309652407816958452866398810650016622889814112246568959023210004929624759159620444e-18), SC_(0.9999999999999999999982162707365811231254510784339820903186540260895212793836298110058978146260660571), SC_(0.1783729263418876874548921566017909681345973910478720616370188994102185373933942877546548162246344178e-20) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(312.0), SC_(13.0), SC_(0.5639317166735260163478845118757400059987175161552709340113986380218210183827971346942398267158628967e-7), SC_(0.9999999959276189152974790192128030112789820628739785446578701720056774934545591522821071333634769277), SC_(0.4072381084702520980787196988721017937126021455342129827994322506545440847717892866636523072271089602e-8) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(835.0), SC_(8.0), SC_(0.1881405021874180684955894560903054162865284433027792170408438883158649159835420739500490928129800934e-5), SC_(0.9999998764930765161357552153724796118578730766929094173086051082629805972880848614572379048712072262), SC_(0.1235069234838642447846275203881421269233070905826913948917370194027119151385427620951287927737759402e-6) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(1339.0), SC_(3.0), SC_(0.01996557592800880076863961737252548307194366892606296310358066070104171898565628092301806754107485267), SC_(0.9970987357817459211270163266865318399525384923262209506659059824401050568988290472121602441111276753), SC_(0.002901264218254078872983673313468160047461507673779049334094017559894943101170952787839755888872324738) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(2247.0), SC_(19.0), SC_(0.1050906302193012289776909960171098418722711790017935933306532209531160584625828270722972207980077013e-31), SC_(0.999999999999999999999999999999999976171505686819430752259740179560009984049341180303121043047228333), SC_(0.2382849431318056924774025982043999001595065881969687895695277166704927899314682556188148756930609968e-34) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(6337.0), SC_(24.0), SC_(0.5176282957547622838690605132216172242085714522154320813344991279989448856834016943494827178497121483e-57), SC_(0.9999999999999999999999999999999999999999999999999999999999999178808977932817892186032255630193196821), SC_(0.8211910220671821078139677443698068031792054954652999085689011507970741128166741247316080168842292826e-61) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(10473.0), SC_(4.0), SC_(0.1060598990762010772050380193233785374373406861413197705606831358023614424887034177392481595772051024e-5), SC_(0.999999987158821180021912666360059165891191552729945325592156581335344600538048842671521822663209354), SC_(0.1284117881997808733363994083410880844727005467440784341866465539946195115732847817733679064595251195e-7) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(19470.0), SC_(24.0), SC_(0.100653079222759083151673295052354691296994458724450653178669947297975004953431179485568010298623934e-68), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999482140938223160241158932694), SC_(0.5178590617768397588410673063132707717042834669452129163178686214025451970156582114619025968341935254e-73) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(50688.0), SC_(6.0), SC_(0.9482412836819153498800110652971926623869738329038951948148009724733627965388084930720824097293986234e-14), SC_(0.9999999999999999858313787496892032679691608217028997720592330096370097807286717209435187654579976986), SC_(0.1416862125031079673203083917829710022794076699036299021927132827905648123454200230138025824001381423e-16) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(130605.0), SC_(13.0), SC_(0.8902021082090078464436572755699868855193684773418735778198579419185494015660549649622763520150230668e-41), SC_(0.9999999999999999999999999999999999999999999987530846327328080651098783872615411969511331082421658705), SC_(0.1246915367267191934890121612738458803048866891757834129530307336572853351372680177281142157984486595e-44) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(256574.0), SC_(23.0), SC_(0.2261490151119036032473395004168239349600735255858979957944002678838534402673587064719528110487861298e-90), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999986777), SC_(0.1322307807626593136421089355027207266077562106641290895140636237488983835572407676575974098854511966e-95) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(523360.0), SC_(24.0), SC_(0.4909136664141883216102288069814313750907878390478390131083379823692692709740156240531870243596322641e-103), SC_(1.0), SC_(0.9380640473030382116114295053868140038229254217194218838132011972707013219240644600591887008898927693e-109) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(1030167.0), SC_(25.0), SC_(0.4163306297530282384655314701980983052385737420470691586428105350418894602733911737761478688144549386e-116), SC_(1.0), SC_(0.2487087103789402804992062215693684046116337778853863252957798583403284888807870318824091917448099231e-122) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(2063277.0), SC_(1.0), SC_(0.0004074491669035074706125788797228478039858079266289510341768917371327261689707863688393863102253874728), SC_(0.9999999225779078873960406362183364579580864385798802622523059879166852457363091107510087511352855333), SC_(0.7742209211260395936378166354204191356142011973774769401208331475426369088924899124886471446669792009e-7) }}, 
      {{ SC_(29.0), SC_(29.0), SC_(2427690.0), SC_(9.0), SC_(0.1242399281637395523078244763598898185952332001452298533526023732705548815023828016266816811000464795e-37), SC_(0.9999999999999999999999999999999999999999997952884194218253206044360588435921590410616414779779045475), SC_(0.2047115805781746793955639411564078409589383585220220954525289129883520250606552216793212639094797863e-42) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(126.0), SC_(1.0), SC_(0.4429493087557603686635944700460829493087557603686635944700460829493087557603686635944700460829493088), SC_(0.8038709677419354838709677419354838709677419354838709677419354838709677419354838709677419354838709677), SC_(0.1961290322580645161290322580645161290322580645161290322580645161290322580645161290322580645161290323) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(244.0), SC_(1.0), SC_(0.3240753285462674434358488009754775775640157160276385313643137786207830917219888903942555209321230186), SC_(0.9422190107734071966560789213546292532879716188210972115592085785826471370435602924425577182656169243), SC_(0.05778098922659280334392107864537074671202838117890278844079142141735286295643970755744228173438307566) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(312.0), SC_(0.0), SC_(0.6913781685589589334014186207942042399048933640780959523828520820534097165152034978816433022428251139), SC_(0.6913781685589589334014186207942042399048933640780959523828520820534097165152034978816433022428251139), SC_(0.3086218314410410665985813792057957600951066359219040476171479179465902834847965021183566977571748861) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(835.0), SC_(1.0), SC_(0.1187068822273233594476001747789108319845406822531709448523302829079764417721596888443052230585078558), SC_(0.9947197075530337064822051682862435457963825688807380101051750558492470352204122074453354339624963844), SC_(0.005280292446966293517794831713756454203617431119261989894824944150752964779587792554664566037503615585) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(1339.0), SC_(3.0), SC_(0.1788468784390216395429887140430761824404382470922872862295425691252390520855939418039621842653426995e-4), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(2247.0), SC_(0.0), SC_(0.9526811285324441272282521427668911587527162855208714393669456465772670262159114059355029668633971873), SC_(0.9526811285324441272282521427668911587527162855208714393669456465772670262159114059355029668633971873), SC_(0.04731887146755587277174785723310884124728371447912856063305435342273297378408859406449703313660281269) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(6337.0), SC_(2.0), SC_(0.936387881493230504605425376796182473965414984441189392030588650980857760823183574943169780819748518e-4), SC_(0.9999998315760039635516206073932031366967988423842275247291999733374906980417718458009757812634367673), SC_(0.168423996036448379392606796863303201157615772475270800026662509301958228154199024218736563232669151e-6) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(10473.0), SC_(1.0), SC_(0.01024341133721188178410810042310016618153805675407828308528931284205246094716783397436876963558424531), SC_(0.9999656085946747189801083588957875189995901144282160978537520860533249607962080888126846135922657246), SC_(0.3439140532528101989164110421248100040988557178390214624791394667503920379191118731538640773427543767e-4) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(19470.0), SC_(1.0), SC_(0.005527068796217620866497207042243453916486891684646224880918384569797139596358078657433393441773401147), SC_(0.9999900396119658493644020889392323104458691066480299460476410601281121084521931200578565541875209113), SC_(0.9960388034150635597911060767689554130893351970053952358939871887891547806879942143445812479088723867e-5) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(50688.0), SC_(2.0), SC_(0.1470275213308941367872296926038655931810894200871397751743395153156140843136306669273502561367559872e-5), SC_(0.999999999671027420750059184845230886010988038105962233609548003637398752222296002351770073210014168), SC_(0.3289725792499408151547691139890119618940377663904519963626012477777039976482299267899858319941103717e-9) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(130605.0), SC_(0.0), SC_(0.9991733007154431594050896369474840535793488051750447979823429186374877276750906726004384118431033411), SC_(0.9991733007154431594050896369474840535793488051750447979823429186374877276750906726004384118431033411), SC_(0.0008266992845568405949103630525159464206511948249552020176570813625122723249093273995615881568966589021) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(256574.0), SC_(3.0), SC_(0.2536393347503892896272478427303469057048021341941914817208979193939946985296667626746071459647743933e-11), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(523360.0), SC_(2.0), SC_(0.1379950033014284309418889521820555985102271305140571087761515585250906013827588528232025708158598027e-7), SC_(0.9999999999997011519879177102106264172625887665289987514148355549208273043729536999285684650046880209), SC_(0.2988480120822897893735827374112334710012485851644450791726956270463000714315349953119790592828887519e-12) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(1030167.0), SC_(3.0), SC_(0.3918571952794248171844572598057591733040046626911988545093729090735363660037183078360146565088026085e-13), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(2063277.0), SC_(2.0), SC_(0.8879117020113575477187606502204698466084837006890391371168871103098142392189388529370804035240984221e-9), SC_(0.9999999999999951227223143287419126125899159791197789160442521535566838816273764540139031919576611119), SC_(0.4877277685671258087387410084020880221083955747846443316118372623545986096808042338888126288436996653e-14) }}, 
      {{ SC_(36.0), SC_(3.0), SC_(2427690.0), SC_(3.0), SC_(0.2994127641399197878378069656934284829152769132196995771361931564167181290666194867045970967680122205e-14), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(126.0), SC_(2.0), SC_(0.2520849724626278520849724626278520849724626278520849724626278520849724626278520849724626278520849725), SC_(0.929913453973249409913453973249409913453973249409913453973249409913453973249409913453973249409913454), SC_(0.07008654602675059008654602675059008654602675059008654602675059008654602675059008654602675059008654603) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(244.0), SC_(3.0), SC_(0.01030728488971898511138266009610568731469597829956741842760728303455761699171238410993282337841458742), SC_(0.9995911774022106652539956396836881157675661450914835038364049995911774022106652539956396836881157676), SC_(0.0004088225977893347460043603163118842324338549085164961635950004088225977893347460043603163118842324339) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(312.0), SC_(1.0), SC_(0.3221956513672818330414378038652602283051930240363942302366689314423656931332987174594065874529670434), SC_(0.9330249070844203081824969736931494111337881321053916250603537806351839863651775359761982428325503964), SC_(0.06697509291557969181750302630685058886621186789460837493964621936481601363482246402380175716744960358) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(835.0), SC_(1.0), SC_(0.1516176043832960216021431719531922004674341726855404536014539030090660642506590897578706134256903223), SC_(0.9897260286131823632362123724722268641624175161417224054539352001980701416362468359194331709732562703), SC_(0.01027397138681763676378762752777313583758248385827759454606479980192985836375316408056682902674372971) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(1339.0), SC_(2.0), SC_(0.004007768611567508527842342523419729684316195784011288325274784419378075069974321537082678795957108335), SC_(0.9999297865361218062500446874397338372322679566911677360167459617683336917044768757316795073610425357), SC_(0.7021346387819374995531256026616276773204330883226398325403823166630829552312426832049263895746425589e-4) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(2247.0), SC_(4.0), SC_(0.5560468435361472800533078401919147489738572537673054057076243790138357243749194774664704216720072804e-7), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(6337.0), SC_(1.0), SC_(0.02234912762434806043009627198650768577268638706786884236337484526376415422327211874417566068601299368), SC_(0.9998130566392375367408346120630729982475396214667436285059774527025602882383263121526361537451090644), SC_(0.0001869433607624632591653879369270017524603785332563714940225472974397117616736878473638462548909355864) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(10473.0), SC_(3.0), SC_(0.1487474600421573465431679201154917516805977928061224269905264169816799820366832273889776135084679439e-6), SC_(0.9999999998824215248301429425140236331366477961708410663360630427640276956885254525435818122104948442), SC_(0.1175784751698570574859763668633522038291589336639369572359723043114745474564181877895051558345176332e-9) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(19470.0), SC_(2.0), SC_(0.1987439337007414910642649062295380768244117829790084459157995170728924702034548240716790162449982433e-4), SC_(0.9999999768086508864389553021845437873497103272371788964699368501039657530757032927990601381383331612), SC_(0.2319134911356104469781545621265028967276282110353006314989603424692429670720093986186166683881170021e-7) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(50688.0), SC_(4.0), SC_(0.2141875331014707882037561558969595490283761722577669109197167046791798741716797392536161084306134412e-12), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(130605.0), SC_(3.0), SC_(0.7690069575431900195558594925652186429804350403583338875931008729411185375877207807321081369753306537e-10), SC_(0.999999999999995141030872771241518786357547608502933630043055429501204234479699065367085990445786992), SC_(0.4858969127228758481213642452391497066369956944570498795765520300934632914009554213007965925184359789e-14) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(256574.0), SC_(3.0), SC_(0.1014426847277289601434221437003523149470494013772554097504639424494531920779089265002502629553718206e-10), SC_(0.9999999999999996737706893311073130751652053388166282136924894704265526193672963823259619607251855167), SC_(0.3262293106688926869248347946611833717863075105295734473806327036176740380392748144832781847632281486e-15) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(523360.0), SC_(0.0), SC_(0.9997248823840679563213933578135924013092182103412294464088455384115033142644300909100184478845373313), SC_(0.9997248823840679563213933578135924013092182103412294464088455384115033142644300909100184478845373313), SC_(0.0002751176159320436786066421864075986907817896587705535911544615884966857355699090899815521154626687396) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(1030167.0), SC_(4.0), SC_(0.1255264932983585037633531124519013741407402497933296271157728866415973637346827180214812122527818436e-17), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(2063277.0), SC_(1.0), SC_(0.69788337663255196780336070862306848564871709907898114430097012753367332036733052704263811632123403e-4), SC_(0.9999999982241863502986347400556140958714036009248515774236280164518910634592646091119393505317172177), SC_(0.1775813649701365259944385904128596399075148422576371983548108936540735390888060649468282782316183925e-8) }}, 
      {{ SC_(36.0), SC_(4.0), SC_(2427690.0), SC_(2.0), SC_(0.1282694849328937353163384160417272117455414644542809969908419495298269488920887751223470632752151382e-8), SC_(0.9999999999999880236115336015394577331741134506812278817209875903999196848813781807643049939729541409), SC_(0.1197638846639846054226682588654931877211827901240960008031511862181923569500602704585905223806271254e-13) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(126.0), SC_(13.0), SC_(0.8994080214415085540637912465721005024664754184671512482515963287898704268624900283202512431484146018e-6), SC_(0.9999999662544206353864289494833879355220219299303272039124608646009467317125602638692879927782554797), SC_(0.3374557936461357105051661206447797807006967279608753913539905326828743973613071200722174452029174386e-7) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(244.0), SC_(5.0), SC_(0.03964037734603113077633374353503885458281859451808378064400540199065294576321184075326939282030538513), SC_(0.9874033849951485521007302717742262198992337219537959821331794301470758977886765404826676104707195927), SC_(0.01259661500485144789926972822577378010076627804620401786682056985292410221132345951733238952928040727) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(312.0), SC_(3.0), SC_(0.1627795253227722345288027846685237836504280843185624938702025190751003123570796278206130278248500031), SC_(0.9194782896811581152222635662451866775331751848222128595328188615293425358923782219929711993646433218), SC_(0.08052171031884188477773643375481332246682481517778714046718113847065746410762177800702880063535667825) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(835.0), SC_(6.0), SC_(0.1510762982539868028949498414760876971634151489989935609161322677125480932749535908749047229133163003e-4), SC_(0.9999992355776937254423793457758115329415018824446068233735683467950328508520704850154738099318289771), SC_(0.7644223062745576206542241884670584981175553931766264316532049671491479295149845261900681710229204618e-6) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(1339.0), SC_(1.0), SC_(0.2777477584346258000992846386612294889101632417002613062549047371942370214200015057270786885416619923), SC_(0.9407419447720936821881326002062754355864603130921813502596680820893694669947828777311609654494440443), SC_(0.05925805522790631781186739979372456441353968690781864974033191791063053300521712226883903455055595575) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(2247.0), SC_(6.0), SC_(0.4861713050678966112304850469136082077340003187774148357257997544137245087246614524328045314445511006e-7), SC_(0.9999999991374708223389041755324703036884343575343308968556208669774943034902139190835882842903422448), SC_(0.8625291776610958244675296963115656424656691031443791330225056965097860809164117157096577552128105884e-9) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(6337.0), SC_(1.0), SC_(0.07884891297797696977915289638414354216960693606938232867427022035533998213519343448638775684698142102), SC_(0.9968546831493495790412533770639777081331602824919873293689681377146408482166029208121652148043373358), SC_(0.003145316850650420958746622936022291866839717508012670631031862285359151783397079187834785195662664193) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(10473.0), SC_(7.0), SC_(0.1919882095423639169413850228758167832804639298349494407600385343703672073338867005222217975503690357e-13), SC_(0.9999999999999999465071881992666263479985493776937280980238664794544516587497303689362986498329676551), SC_(0.5349281180073337365200145062230627190197613352054554834125026963106370135016703234492216689501005441e-16) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(19470.0), SC_(8.0), SC_(0.3769314239952920113701075323157236367270516354324951629592561753842252249694336969816455892049543627e-18), SC_(0.999999999999999999999577126959318461638308233176860254660995268184756052002605306543180958698459771), SC_(0.4228730406815383616917668231397453390047318152439479973946934568190413015402290405765802921938823689e-21) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(50688.0), SC_(5.0), SC_(0.4036186525984671200399264615524949780200095348723856918725794304154251506185072896739251487503955018e-12), SC_(0.9999999999999995879090495793359455246711743563173300543792623139874256600584350426640758113451273652), SC_(0.4120909504206640544753288256436826699456207376860125743399415649573359241886548726347814838421637313e-15) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(130605.0), SC_(3.0), SC_(0.8723170725513304783555121943043962031554495985767243537062929787365547813643179632213710294014505e-8), SC_(0.9999999999933817938915705014438021390313398807292937136934104429846901856314154186032344929211393369), SC_(0.6618206108429498556197860968660119270706286306589557015309814368584581396765507078860663121304953086e-11) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(256574.0), SC_(1.0), SC_(0.002100639980686256876523640969409670019491306959937340932841699410487869051911648042257146672063593911), SC_(0.999997992583577662419765263259865581278728393239504832518552994923105373425736834915071401489863458), SC_(0.200741642233758023473674013441872127160676049516748144700507689462657426316508492859851013654197561e-5) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(523360.0), SC_(6.0), SC_(0.3414006790665213598462787423102332706353189803301398344222302150954927482821138844923148623267032052e-21), SC_(0.9999999999999999999999999748353926327516273016148774166198107441802134520394373916691811006112364723), SC_(0.251646073672483726983851225833801892558197865479605626083308188993887635277169090140767825207179681e-25) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(1030167.0), SC_(1.0), SC_(0.0005239375783602908233372323289072328587196465316659776537074777157057385936603933969726038988647680284), SC_(0.9999998753705227020523738155824849934618791396060398715503478889558929566766467884229544997039814204), SC_(0.1246294772979476261844175150065381208603939601284496521110441070433233532115770455002960185796188771e-6) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(2063277.0), SC_(8.0), SC_(0.2390271425427542727530120568732924964256281918570016382854930547189801972450274739112801929073090141e-34), SC_(0.9999999999999999999999999999999999999997477010197344701454911967122771970147329845641961096447054434), SC_(0.2522989802655298545088032877228029852670154358038903552945565970156452972847116344154983918366104124e-39) }}, 
      {{ SC_(36.0), SC_(15.0), SC_(2427690.0), SC_(2.0), SC_(0.2244370197487181729610526118968349294497428985601568334372548326089129131477304855300462338087243311e-7), SC_(0.9999999999986378385789032334230612189634793297078079740284885472070211518778872225124368942506832796), SC_(0.136216142109676657693878103652067029219202597151145279297884812211277748756310574931672038420220293e-11) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(126.0), SC_(12.0), SC_(0.04193492305367818670043104060417935150883612406064936013670565072017494167600365740720448348896806866), SC_(0.9736464844602040884727385927001107164271537122699159453578315018791489063761825817093985517788942867), SC_(0.0263535155397959115272614072998892835728462877300840546421684981208510936238174182906014482211057133) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(244.0), SC_(20.0), SC_(0.3590547440220898963733084985211372138185124889315625391244609726511616944418246633643020396322021036e-12), SC_(0.9999999999999873483216652802578479295192485012006814199419557458039021973264805705505820454755581117), SC_(0.126516783347197421520704807514987993185800580442541960978026735194294494179545244418883399118639192e-13) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(312.0), SC_(26.0), SC_(0.1393890634822620357817865021259022188879066440016919830507892786968441560849019405575513058822720873e-25), SC_(0.9999999999999999999999999999433433764282361446131215361723054879444820678282290435972290151247486998), SC_(0.5665662357176385538687846382769451205551793217177095640277098487525130018050002931917524691653401973e-28) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(835.0), SC_(27.0), SC_(0.810121772804049201787014007465070735204928776772529348822782917998650173069421002345517954389116019e-40), SC_(0.9999999999999999999999999999999999999999999347152410230704213438123524842242294678865495106046743572), SC_(0.6528475897692957865618764751577577053211345048939532564281439776227763811018672624098519431832194663e-43) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(1339.0), SC_(9.0), SC_(0.1680492213519518597822129847788198074991169317928121486078342279353653094048403648933023426188761358e-7), SC_(0.9999999992678127866588585658547715249984577525831806610505511861415249761970674063860487574246580196), SC_(0.7321872133411414341452284750015422474168193389494488138584750238029325936139512425753419803613631772e-9) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(2247.0), SC_(3.0), SC_(0.00937898745062745548994469706270051645127026272231290121652262416365441305409922644878453071726539292), SC_(0.9990083688780463218280219286087905145810281215020793643543727515085247393945197307981160245157895559), SC_(0.0009916311219536781719780713912094854189718784979206356456272484914752606054802692018839754842104441399) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(6337.0), SC_(15.0), SC_(0.5134721949579218335957827150695703578147977347152351212358771363879715400004081409173478703958427905e-27), SC_(0.9999999999999999999999999999984958583309827429865745338613415244431082788323680080964143889887694001), SC_(0.1504141669017257013425466138658475556891721167631991903585611011230599882558839008178797309129900979e-29) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(10473.0), SC_(7.0), SC_(0.4478923045372296641603646275416923030806660586978392248877950497821717008841560240549114540779367834e-11), SC_(0.999999999999965490973036026383177549005967418210289945474361966781150311931599931810426819972512376), SC_(0.3450902696397361682245099403258178971005452563803321884968806840006818957318002748762395813826125563e-13) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(19470.0), SC_(15.0), SC_(0.2553329158433264970077183639814352356514127612995400306996904102696624173317616092858457577220921635e-34), SC_(0.9999999999999999999999999999999999999758228756730666571695340923488137687826354683282890134168067498), SC_(0.2417712432693334283046590765118623121736453167171098658319325022241312522404991496285464424642668009e-37) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(50688.0), SC_(3.0), SC_(0.118187694152186719421385860109882773828367633138793163829297487382764532178809976878873096648085864e-5), SC_(0.9999999949766775127729083065914928581773605912378610763354420492195123492287414039941826781689633317), SC_(0.5023322487227091693408507141822639408762138923664557950780487650771258596005817321831036668321958235e-8) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(130605.0), SC_(1.0), SC_(0.007933798202830677506934671976833659860526009215823645008302080200080460171973973799975119009524184522), SC_(0.9999701499228684863505735747812807784935966692185386287523268420819597565691639192132731964554880735), SC_(0.2985007713151364942642521871922150640333078146137124767315791804024343083608078672680354451192648277e-4) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(256574.0), SC_(23.0), SC_(0.1099947882342488463628451775319730218322039536388202183497627017935908520353930029261391865589449427e-86), SC_(0.999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999986064701), SC_(0.1393529901458325979432725257550173347030606203713893980715661650430827925283365275296587788575361362e-91) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(523360.0), SC_(3.0), SC_(0.1090201776512215360013648398989323860196665347436654216037894132541969284055249623854485993863982237e-8), SC_(0.9999999999995529901689523829748146059176324699135263943148100649274622059351356321669857053739550628), SC_(0.447009831047617025185394082367530086473605685189935072537794064864367833014294626044937157862095102e-12) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(1030167.0), SC_(15.0), SC_(0.3615163194584630137548151731663460726295399845460958754625405226671206983258505957455484528604449141e-60), SC_(0.9999999999999999999999999999999999999999999999999999999999999999935512620908884175151725915535235861), SC_(0.6448737909111582484827408446476413939593449435770580496653085652336702878975109622985599137021877359e-65) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(2063277.0), SC_(22.0), SC_(0.8002591885054865307518354106002770676446479796050533674997916145487406128521730409441906670273642489e-102), SC_(1.0), SC_(0.1652650033416642979322196254087280915890140441177764098592959492453353619611156614161747405052795918e-107) }}, 
      {{ SC_(36.0), SC_(29.0), SC_(2427690.0), SC_(9.0), SC_(0.1167815677260845521405085279464944721988178588584686158765112916392723576510356699510171933568214736e-36), SC_(0.9999999999999999999999999999999999999999974022778061172210545471991421375825703525363196107743063981), SC_(0.2597722193882778945452800857862417429647463680389225693601923776914376609098364182246625725368144756e-41) }}, 
      //{{ SC_(36.0), SC_(36.0), SC_(36.0), SC_(36.0), SC_(1.0), SC_(1.0), SC_(0.9332636185032188789900895447238171696170914463717080246217143397959669109757756344544403270978811024e-301) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(126.0), SC_(36.0), SC_(0.2329831625709742611804140041059926017320892506879662754849962280457778944574604396215943091998897527e-31), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(244.0), SC_(4.0), SC_(0.1739000858352807153888180466453386196874388943372693281396470029110484859670298333217021151605871473), SC_(0.3538164144257911432541512889506640859174657499104368140160842443719998412025772217052591291747615506), SC_(0.6461835855742088567458487110493359140825342500895631859839157556280001587974227782947408708252384494) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(312.0), SC_(10.0), SC_(0.002681977330078823861362492351114738564251613665082091541693962865490046687038964315935552920245975696), SC_(0.9991798268976707195189389118875803243975352053637053886869278194065992297794356643167921823588793115), SC_(0.0008201731023292804810610881124196756024647946362946113130721805934007702205643356832078176411206884901) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(835.0), SC_(13.0), SC_(0.1964505728554772212059384932844507375183316706528756020340241170039630041349576800342196704192107971e-9), SC_(0.9999999999900358858420271966026593780062901132419465720436078452321891199963827304446747452516746345), SC_(0.9964114157972803397340621993709886758053427956392154767810880003617269555325254748325365467417949468e-11) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(1339.0), SC_(28.0), SC_(0.9957684640487960679990058470163215253966790931614141010711277892491605708218271808062359134981106972e-43), SC_(0.9999999999999999999999999999999999999999999998302216135945850655625818444648146074654616878630419967), SC_(0.1697783864054149344374181555351853925345383121369580033219574236197206531398427158504594904581820635e-45) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(2247.0), SC_(1.0), SC_(0.3314563378425366809934108351951053017749169433693487206913363810205560412481951470440519129209286423), SC_(0.8879756211337093799453105091029364257426787248289959554323456133513661845784981099822131494301421652), SC_(0.1120243788662906200546894908970635742573212751710040445676543866486338154215018900177868505698578348) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(6337.0), SC_(7.0), SC_(0.7513712766970706272940725191991443497182375118313282606832394336554853736623900789697156141118916889e-9), SC_(0.9999999999872313921902142287097702333829659610489627728778594537373310105041351007913891226463738297), SC_(0.1276860780978577129022976661703403895103722712214054626266898949586489920861087735362617029897733706e-10) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(10473.0), SC_(20.0), SC_(0.5122905188492832897634292626048262249021472332982394354590078083725950417033172345548309358697397586e-42), SC_(0.9999999999999999999999999999999999999999999994001920765115461286675127117857041995793003648326908831), SC_(0.5998079234884538713324872882142958004206996351673091168969467730390907267770159807279142619967729435e-45) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(19470.0), SC_(31.0), SC_(0.1279854225136503784633097109353897844915775681726284840720259861444056062577774210584530403373652376e-87), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999948537773), SC_(0.5146222661882176687391766922721673884393257588566477989809605310274824943940676463886607019949061101e-92) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(50688.0), SC_(5.0), SC_(0.5002254755554662842503439051112680808892769862384576883692606821040260454870399935865446725177006931e-10), SC_(0.9999999999998413271773437988847665415713714515286110695340089240037385696530385255099866436708519811), SC_(0.1586728226562011152334584286285484713889304659910759962614303469614744900133563291480188895203694727e-12) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(130605.0), SC_(5.0), SC_(0.4455365261847875098886341760813704251983734237045102891942669383765795688616602272364119806392807561e-12), SC_(0.9999999999999994528038295876978512300745182661968989850234756615881188267931150860278203944601065786), SC_(0.5471961704123021487699254817338031010149765243384118811732068849139721796055398934214293136556734906e-15) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(256574.0), SC_(33.0), SC_(0.1389771362748744670580999526944063518117376935258876028394478955939794975636003356771566353846816498e-133), SC_(1.0), SC_(0.1434031943797076547482626751585658736865342359396309586318103508418316856352404756427915907974765792e-139) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(523360.0), SC_(31.0), SC_(0.609866578318812274468691858326035931597369933524175924799166701616189882056632810251722976908912294e-132), SC_(1.0), SC_(0.9104538441922910547556744624752889611772677250219048030497053784430646627957930025516156192257617259e-138) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(1030167.0), SC_(20.0), SC_(0.7170112862945047230706073376560035576766644596623090469688496176480635684475845200726120646052490082e-82), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999991514746111454), SC_(0.8485253888546163285238623967520465469352877323073944229826880071907668710487723535909899910505519349e-87) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(2063277.0), SC_(4.0), SC_(0.4592732322131306020973670421822455076371170212628140465174885156782584404693055918543144078625992825e-14), SC_(0.9999999999999999995440771409292317009621036828392676781861017165679688074499699914632102904036279584), SC_(0.4559228590707682990378963171607323218138982834320311925500300085367897095963720416032120833458006855e-18) }}, 
      {{ SC_(36.0), SC_(36.0), SC_(2427690.0), SC_(22.0), SC_(0.5435533987181425281632117265262824648673312224162294232906749748372814198212179354639588983787198934e-100), SC_(1.0), SC_(0.1908038998805508426034337098633255053712465991485626875388712543808908698609198294534768573358022273e-105) }}, 
      {{ SC_(126.0), SC_(3.0), SC_(244.0), SC_(2.0), SC_(0.3885727618961598097216577097352060094235951165906456517484833431182164416143551762031642806605548781), SC_(0.86388976701942424744213119771987134133184803825638400899205668207158520124242926031301590168952315), SC_(0.13611023298057575255786880228012865866815196174361599100794331792841479875757073968698409831047685) }}, 
      {{ SC_(126.0), SC_(3.0), SC_(312.0), SC_(2.0), SC_(0.2921716547118476378926539698243878308186989859015582488251298540687608211723967350976997279248083107), SC_(0.9350729656195894138016324511501360375958446697996537224833044768736087064061340588671778382389314865), SC_(0.06492703438041058619836754884986396240415533020034627751669552312639129359386594113282216176106851348) }}, 
      {{ SC_(126.0), SC_(3.0), SC_(835.0), SC_(2.0), SC_(0.0577498047855682142757589832124638939278808925888022033437508032119063969877788706487635333287237266), SC_(0.9966332976993838934789872525066546672087178040991953581501527505414779533490904654628835551797076906), SC_(0.003366702300616106521012747493345332791282195900804641849847249458522046650909534537116444820292309402) }}, 
      {{ SC_(126.0), SC_(3.0), SC_(1339.0), SC_(2.0), SC_(0.02392734524410293184915205626480714073164539636650122921284211062671856288748074831708155840226404718), SC_(0.99918466864241034252561284556833303505063917857943221972454179122898788079196273350059958415996682), SC_(0.0008153313575896574743871544316669649493608214205677802754582087710121192080372664994004158400331799534) }}, 
      {{ SC_(126.0), SC_(3.0), SC_(2247.0), SC_(0.0), SC_(0.8409657651411231134234174939269027121351607528644428784105897712699455624579709676451355011091373714), SC_(0.8409657651411231134234174939269027121351607528644428784105897712699455624579709676451355011091373714), SC_(0.1590342348588768865765825060730972878648392471355571215894102287300544375420290323548644988908626286) }}, 
      {{ SC_(126.0), SC_(3.0), SC_(6337.0), SC_(3.0), SC_(0.7678152760485146707604133386415292993950130804019698236509614394648095695264955515854166853254034825e-5), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(126.0), SC_(3.0), SC_(10473.0), SC_(3.0), SC_(0.1700643747142625006605318600393860285063730619398574786545433636825993487875652906008898771355142077e-5), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(126.0), SC_(3.0), SC_(19470.0), SC_(3.0), SC_(0.2646496409238460843520663773642143599644249786338389014734778083213092961578426755749624475896105663e-6), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(126.0), SC_(3.0), SC_(50688.0), SC_(0.0), SC_(0.9925609894157223718444487624196595211222460727297455359715831854959150546280402923737522061090033464), SC_(0.9925609894157223718444487624196595211222460727297455359715831854959150546280402923737522061090033464), SC_(0.007439010584277628155551237580340478877753927270254464028416814504084945371959707626247793890996653582) }}, 
      {{ SC_(126.0), SC_(3.0), SC_(130605.0), SC_(0.0), SC_(0.9971085461211538441221019681188182113831770291142874668470065312251598084988685330538477409291813614), SC_(0.9971085461211538441221019681188182113831770291142874668470065312251598084988685330538477409291813614), SC_(0.002891453878846155877898031881181788616822970885712533152993468774840191501131466946152259070818638636) }}, 
      {{ SC_(126.0), SC_(3.0), SC_(256574.0), SC_(1.0), SC_(0.001471824007003953657618378815386445797381318742858231584443707794574651617699886464862001832073771591), SC_(0.9999992824729719422332870922825623160493645630048213450877534675886760082090461670893892850765559018), SC_(0.7175270280577667129077174376839506354369951786549122465324113239917909538329106107149234440982077131e-6) }}, 
      {{ SC_(126.0), SC_(3.0), SC_(523360.0), SC_(2.0), SC_(0.1724640890667626643232689595881941183447065833197793270836539231213593742613846872211124399515597942e-6), SC_(0.9999999999863760465080132596020866693238996505867077850880914743318329934845991547387587664301913236), SC_(0.1362395349198674039791333067610034941329221491190852566816700651540084526124123356980867639438115156e-10) }}, 
      {{ SC_(126.0), SC_(3.0), SC_(1030167.0), SC_(2.0), SC_(0.4451790190619272258648847871480705712822392648122483374606863754385894571133316920712598155028263832e-7), SC_(0.9999999999982135921979908574510708566097090390628788022730254169867955058572296037572763227343403975), SC_(0.1786407802009142548929143390290960937121197726974583013204494142770396242723677265659602498533700208e-11) }}, 
      {{ SC_(126.0), SC_(3.0), SC_(2063277.0), SC_(3.0), SC_(0.2223464827291308833956025185362460100788273943871172688230434576470173169416744538589364826738244655e-12), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(126.0), SC_(3.0), SC_(2427690.0), SC_(0.0), SC_(0.999844304446870441543211809517988373001328919233996962464887483472844606160660247012770096189733775), SC_(0.999844304446870441543211809517988373001328919233996962464887483472844606160660247012770096189733775), SC_(0.0001556955531295584567881904820116269986710807660030375351125165271553938393397529872299038102662250005) }}, 
      {{ SC_(126.0), SC_(4.0), SC_(244.0), SC_(4.0), SC_(0.06946704836767974093202432647492043575179539956209446843973870583068473131610456838796283855679938816), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(126.0), SC_(4.0), SC_(312.0), SC_(0.0), SC_(0.1246575046406470250630959899526690023989683715591373319341352307356115928525631019933770222534933926), SC_(0.1246575046406470250630959899526690023989683715591373319341352307356115928525631019933770222534933926), SC_(0.8753424953593529749369040100473309976010316284408626680658647692643884071474368980066229777465066074) }}, 
      {{ SC_(126.0), SC_(4.0), SC_(835.0), SC_(1.0), SC_(0.3706027087723702957053437641140779088328762573164163550889041929812694673155723125187497331909312012), SC_(0.8897406301876350353243372114643537096979767288747297413840755426732858243092113058485856689702911774), SC_(0.1102593698123649646756627885356462903020232711252702586159244573267141756907886941514143310297088226) }}, 
      {{ SC_(126.0), SC_(4.0), SC_(1339.0), SC_(1.0), SC_(0.2803906609965483781941688291070492158110927017947910750900054029091807564388654186740658672804136886), SC_(0.9535507796588966671127090735902427696432795453894283783814866281474916994766177135066446359496608378), SC_(0.04644922034110333288729092640975723035672045461057162161851337185250830052338228649335536405033916215) }}, 
      {{ SC_(126.0), SC_(4.0), SC_(2247.0), SC_(1.0), SC_(0.1888800114220704318918905601333150476453302225684844967553196277718594311402929446047897916929613347), SC_(0.9826257737076759373423354140268889978691584197908062509770794920988401358131906760987278448788583724), SC_(0.01737422629232406265766458597311100213084158020919374902292050790115986418680932390127215512114162759) }}, 
      {{ SC_(126.0), SC_(4.0), SC_(6337.0), SC_(0.0), SC_(0.9227901359904048968270483016357497487262072376636054502341621274887415264764538014656636422516359064), SC_(0.9227901359904048968270483016357497487262072376636054502341621274887415264764538014656636422516359064), SC_(0.07720986400959510317295169836425025127379276233639454976583787251125847352354619853433635774836409363) }}, 
      {{ SC_(126.0), SC_(4.0), SC_(10473.0), SC_(0.0), SC_(0.9527311209817994196886912953974905601448046911501494727748492645544015339306820704847544568265862061), SC_(0.9527311209817994196886912953974905601448046911501494727748492645544015339306820704847544568265862061), SC_(0.0472688790182005803113087046025094398551953088498505272251507354455984660693179295152455431734137939) }}, 
      {{ SC_(126.0), SC_(4.0), SC_(19470.0), SC_(0.0), SC_(0.9743622646069935685806430735748591746127202128503818806288776442987358217781119931218977847631366927), SC_(0.9743622646069935685806430735748591746127202128503818806288776442987358217781119931218977847631366927), SC_(0.02563773539300643141935692642514082538727978714961811937112235570126417822188800687810221523686330733) }}, 
      {{ SC_(126.0), SC_(4.0), SC_(50688.0), SC_(1.0), SC_(0.009869798533402862294753914891180988431402032566948638653046817115318954079757962066812096515318885007), SC_(0.9999633383157745185655141985880452624457975971549570149613682983324042701878587639238612784954925102), SC_(0.3666168422548143448580141195473755420240284504298503863170166759572981214123607613872150450748982684e-4) }}, 
      {{ SC_(126.0), SC_(4.0), SC_(130605.0), SC_(2.0), SC_(0.5529558497230872775812681974660528812408467172780574074476186997580410724040000848564475089968812593e-5), SC_(0.9999999964958238453435566260248239991834159158666718112751427252173917131622286381358030006384169608), SC_(0.3504176154656443373975176000816584084133328188724857274782608286837771361864196999361583039246892025e-8) }}, 
      {{ SC_(126.0), SC_(4.0), SC_(256574.0), SC_(3.0), SC_(0.4622970556390199545581998281745821306886817544151389651425888343444833827108568273549596912713709087e-9), SC_(0.999999999999944567185312812485951675798928560953804759779962154030531980726492629405544201124698243), SC_(0.5543281468718751404832420107143904619524022003784596946801927350737059445579887530175697946150455952e-13) }}, 
      {{ SC_(126.0), SC_(4.0), SC_(523360.0), SC_(2.0), SC_(0.3448464536240823343983437215216747769643125427200098466169803524422459057725035800430213299573024813e-6), SC_(0.999999999945513791786516135504987841967169788036395825313687699168086093259250601925285026997235227), SC_(0.5448620821348386449501215803283021196360417468631230083191390674074939807471497300276477300847621053e-10) }}, 
      {{ SC_(126.0), SC_(4.0), SC_(1030167.0), SC_(2.0), SC_(0.8902508664533948375789989286249541068093191614678988540038389890478888700786348939225487054756677152e-7), SC_(0.9999999999928550086750101499125385730503572513049103944431343711101074143941809189681589526272213281), SC_(0.7144991324989850087461426949642748695089605556865628889892585605819081031841047372778671907989475855e-11) }}, 
      {{ SC_(126.0), SC_(4.0), SC_(2063277.0), SC_(1.0), SC_(0.0002442272189366349920128193298140424772255285298787222992469032794027893731933132718560915278831938999), SC_(0.9999999778036203859865845944631118774036039717088988696140286636870510888042639112768698522151501734), SC_(0.2219637961401341540553688812259639602829110113038597133631294891119573608872313014778484982659725432e-7) }}, 
      {{ SC_(126.0), SC_(4.0), SC_(2427690.0), SC_(2.0), SC_(0.1603249681025458542413301058467103549111242862013117355627986164359472149007848190553240720605955258e-7), SC_(0.99999999999945403276540275036876273842539991382420935408382355916676281679864702586833939833620242), SC_(0.5459672345972496312372615746000861757906459161764408332371832013529741316606016637975800194226491536e-12) }}, 
      {{ SC_(126.0), SC_(15.0), SC_(244.0), SC_(7.0), SC_(0.1936814149552231426650631958187933295001703224572583518940171061490935414853561963979856223425265171), SC_(0.4470811936860118667829311489691731578151177222154816965653884847219197303455652265584231487255810586), SC_(0.5529188063139881332170688510308268421848822777845183034346115152780802696544347734415768512744189414) }}, 
      {{ SC_(126.0), SC_(15.0), SC_(312.0), SC_(4.0), SC_(0.1217954754209025802076424577939632638891746796310026663267782254699693574724568889949625052599766473), SC_(0.2022968702236301743700302797613153333666137319861751873329483956606160272233111839917666565017516651), SC_(0.7977031297763698256299697202386846666333862680138248126670516043393839727766888160082333434982483349) }}, 
      {{ SC_(126.0), SC_(15.0), SC_(835.0), SC_(6.0), SC_(0.01295585599617980611358324691764399123095341711352121461667780114959759721493162486345262823360927447), SC_(0.9965952276764970420256760393507169640106229558874803737536133075221050822037308930357638962260065738), SC_(0.003404772323502957974323960649283035989377044112519626246386692477894917796269106964236103773993426242) }}, 
      {{ SC_(126.0), SC_(15.0), SC_(1339.0), SC_(7.0), SC_(0.0001701351299782105189198902589525695702466335086764890031728445835860276026018677812359067366677554549), SC_(0.9999818581749354066344898082126507967064906670626699301654199160342091146429420454146394792528622574), SC_(0.1814182506459336551019178734920329350933293733006983458008396579088535705795458536052074713774264477e-4) }}, 
      {{ SC_(126.0), SC_(15.0), SC_(2247.0), SC_(1.0), SC_(0.3764005510694159799160848705209559122503960961155872134219149934083222821131027172822209786335103412), SC_(0.7960174617060612019706831891387623181295413736370381439404202268005630484688209317338821437027200179), SC_(0.2039825382939387980293168108612376818704586263629618560595797731994369515311790682661178562972799821) }}, 
      {{ SC_(126.0), SC_(15.0), SC_(6337.0), SC_(11.0), SC_(0.1567875730018763984054925981416889658876676087982693572791077093094788714032151067345983546264052717e-15), SC_(0.9999999999999999990277509817239659858269072718880614014122186499909057729670587896543135009253412644), SC_(0.9722490182760340141730927281119385985877813500090942270329412103456864990746587356367618843688247651e-18) }}, 
      {{ SC_(126.0), SC_(15.0), SC_(10473.0), SC_(10.0), SC_(0.1256163060561006063706121709216550256954014721465967319414906971835157200818419259678295074298367771e-15), SC_(0.9999999999999999993572451798082468897432645688089445430523362800421074506292350763264521518060028271), SC_(0.6427548201917531102567354311910554569476637199578925493707649236735478481939971729035951564430020048e-18) }}, 
      {{ SC_(126.0), SC_(15.0), SC_(19470.0), SC_(14.0), SC_(0.1600216411063820257767369162255546976574003646854621848507311550800587711332249152564845756578019133e-29), SC_(0.9999999999999999999999999999999993823261716323825859183025014729071499300785482226438963578064044332), SC_(0.6176738283676174140816974985270928500699214517773561036421935955668108066901430420707979209289293595e-33) }}, 
      {{ SC_(126.0), SC_(15.0), SC_(50688.0), SC_(9.0), SC_(0.1336305835189066048895994642195068747799846252700707283577914853636265283489747352434669185993870648e-19), SC_(0.9999999999999999999999814256032739933656036923789526560128159038401756686853401948006509526052027575), SC_(0.1857439672600663439630762104734398718409615982433131465980519934904739479724247433395594132341155563e-22) }}, 
      {{ SC_(126.0), SC_(15.0), SC_(130605.0), SC_(15.0), SC_(0.245390582136720821743737273378358129884130315726769460685881388527575201662980888871636804352317461e-45), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(126.0), SC_(15.0), SC_(256574.0), SC_(2.0), SC_(0.2496415872890232233631026666018487358017726177449679120207547459644146015927024694185422693939163059e-4), SC_(0.9999999476150110604608684898137552954983830149064089334463838419566785864216254889493567827210659811), SC_(0.5238498893953913151018624470450161698509359106655361615804332141357837451105064321727893401888851543e-7) }}, 
      {{ SC_(126.0), SC_(15.0), SC_(523360.0), SC_(7.0), SC_(0.2541592953287815457278239841369083105185796452161977147546580568794651666910134047002644456017792103e-21), SC_(0.9999999999999999999999999421852044550389308737650167848355353045908054780657906901313825539671526208), SC_(0.5781479554496106912623498321516446469540919452193420930986861744603284737921902003506432815120441663e-25) }}, 
      {{ SC_(126.0), SC_(15.0), SC_(1030167.0), SC_(11.0), SC_(0.7979662992505503925879074948470527681689286529778841010774937062055348002789973762031531154990372148e-40), SC_(0.9999999999999999999999999999999999999999999970302562235058901074730429020872384851166016185817625164), SC_(0.2969743776494109892526957097912761514883398381418237483569995004169493557804643946686155079459358672e-44) }}, 
      {{ SC_(126.0), SC_(15.0), SC_(2063277.0), SC_(13.0), SC_(0.9089070615728027143926897884369203941819219034138630210664763845495382065778935171849834068812923184e-53), SC_(0.9999999999999999999999999999999999999999999999999999999999288834551475200783529730752082000242127934), SC_(0.7111654485247992164702692479179997578720661135459716943095604707787136421151497318038732482922119913e-58) }}, 
      {{ SC_(126.0), SC_(15.0), SC_(2427690.0), SC_(5.0), SC_(0.1043137825761245075536496934835025422239985389124963972450817819312473700896014564365484635619109371e-17), SC_(0.9999999999999999999999133368764550184009160544280103484476762302509655527338003760355034974687676014), SC_(0.8666312354498159908394557198965155232376974903444726619962396449650253123239861211367851336970271337e-22) }}, 
      {{ SC_(126.0), SC_(29.0), SC_(244.0), SC_(8.0), SC_(0.003490711505047764313625147607615506569103164772229307683213853056004721846432189528185702138948593611), SC_(0.004835344150025918231592858207667743468630081705001895796094519649679672891940379641708386073691594485), SC_(0.9951646558499740817684071417923322565313699182949981042039054803503203271080596203582916139263084055) }}, 
      {{ SC_(126.0), SC_(29.0), SC_(312.0), SC_(5.0), SC_(0.003883225701063076498007122155554742801313269068276145338570670755333574577362493031260624938038763804), SC_(0.00515478051160154824760705766678505087606458261809402255785383791772920075032447660247493519868513255), SC_(0.9948452194883984517523929423332149491239354173819059774421461620822707992496755233975250648013148674) }}, 
      {{ SC_(126.0), SC_(29.0), SC_(835.0), SC_(6.0), SC_(0.1316408171446036684781486341385233455901545510542565931525301891219752546497309011929091931690619386), SC_(0.8674241864001741343937456521305160673488359450954898910751638806229566787033879944664223080565503001), SC_(0.1325758135998258656062543478694839326511640549045101089248361193770433212966120055335776919434496999) }}, 
      {{ SC_(126.0), SC_(29.0), SC_(1339.0), SC_(19.0), SC_(0.7355255554074857065731832064952629196812636507916470427243737968708368034228519096363408379797345247e-13), SC_(0.9999999999999966044547931204964264268086524038435738360828738188866945775394087813472480466925161266), SC_(0.3395545206879503573573191347596156426163917126181113305422460591218652751953307483873403818761573484e-14) }}, 
      {{ SC_(126.0), SC_(29.0), SC_(2247.0), SC_(19.0), SC_(0.5329016045887465169706865532822249707367502313182347525258474161014757024196016805321327375983301603e-17), SC_(0.9999999999999999998620528788748418380436187487652445317289917808591227823001122031041253700422609705), SC_(0.1379471211251581619563812512347554682710082191408772176998877968958746299577390294540387670019267749e-18) }}, 
      {{ SC_(126.0), SC_(29.0), SC_(6337.0), SC_(22.0), SC_(0.7578668013882222486522808152493191541766053574326605787823533005588557860992713190869554631627188918e-32), SC_(0.9999999999999999999999999999999999611797074132689981726370667889378483498351477753281875203303280785), SC_(0.3882029258673100182736293321106215165016485222467181247966967192147353074929865686044184378479516492e-34) }}, 
      {{ SC_(126.0), SC_(29.0), SC_(10473.0), SC_(0.0), SC_(0.7036417928255682509002214364912581602830712110305268019806043080141230326048024616742569699236945265), SC_(0.7036417928255682509002214364912581602830712110305268019806043080141230326048024616742569699236945265), SC_(0.2963582071744317490997785635087418397169287889694731980193956919858769673951975383257430300763054735) }}, 
      {{ SC_(126.0), SC_(29.0), SC_(19470.0), SC_(19.0), SC_(0.1175041557206692660170542560025328356961583215924494969659520963807916118200761557137919593202203326e-34), SC_(0.9999999999999999999999999999999999999674100275843316397884771993147807882977082511744308732412961517), SC_(0.3258997241566836021152280068521921170229174882556912675870384825122556385916774804017168736218388539e-37) }}, 
      {{ SC_(126.0), SC_(29.0), SC_(50688.0), SC_(4.0), SC_(0.8138565970553795250350959678863016604351092689678486549050112447773830736162937829432848292522503316e-6), SC_(0.9999999900818341660644089390724697644043045604727745231146430922388376210047240188852060699809890093), SC_(0.9918165833935591060927530235595695439527225476885356907761162378995275981114793930019010990737217161e-8) }}, 
      {{ SC_(126.0), SC_(29.0), SC_(130605.0), SC_(29.0), SC_(0.1072802722373649461559320758015662660628604084866590921536286739850442265858285871212778475657196894e-88), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(126.0), SC_(29.0), SC_(256574.0), SC_(26.0), SC_(0.2130221217183705541925339696607748453673375986098418273314716851855680154263263598754625438347207823e-83), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999077007350043), SC_(0.9229926499571899372941822616033615908126418295790704309611466469852713041791266611989912967807873248e-88) }}, 
      {{ SC_(126.0), SC_(29.0), SC_(523360.0), SC_(17.0), SC_(0.5130658652470950852234889956365070558884710857304780042855877971498293646928099556228016123181243925e-54), SC_(0.9999999999999999999999999999999999999999999999999999999999287354683735776945576141009278145555994624), SC_(0.7126453162642230544238589907218544440053757144079449421542549211582111708402494315123813040191752204e-58) }}, 
      {{ SC_(126.0), SC_(29.0), SC_(1030167.0), SC_(16.0), SC_(0.6292065254075940228518258172620748575076313206373571865616565495298043383709832216770652166460854054e-55), SC_(0.999999999999999999999999999999999999999999999999999999999994861202297804002910965458531206710363997), SC_(0.5138797702195997089034541468793289636002979631456368351273110083840646777181864857209087604594564489e-59) }}, 
      {{ SC_(126.0), SC_(29.0), SC_(2063277.0), SC_(18.0), SC_(0.1348455109635779118331712671766373142277886472357072178213518826473584968226917049033673521586190303e-68), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999591321599285525127327095629), SC_(0.4086784007144748726729043709963421728806388721129934961825334700967626164507564998982157505920059346e-73) }}, 
      {{ SC_(126.0), SC_(29.0), SC_(2427690.0), SC_(27.0), SC_(0.4106567422039495726330467534768462713550110824214119043171970502778664615971335856130386881867276793e-114), SC_(1.0), SC_(0.1196234191372199801136199635367873855138349406800776166312199935950093113105065637677217459017189752e-119) }}, 
      {{ SC_(126.0), SC_(36.0), SC_(244.0), SC_(13.0), SC_(0.01909658718733740523510329149404899670000876629676461577112122463279409531786799124062787351710430501), SC_(0.03268340459427747609649809961139075093374317907613997687021008022612994999961543722497252311102980816), SC_(0.9673165954057225239035019003886092490662568209238600231297899197738700500003845627750274768889701918) }}, 
      {{ SC_(126.0), SC_(36.0), SC_(312.0), SC_(14.0), SC_(0.1411111689087979735845489777150397457521503420916066292966035049412395439450586493641404305762126452), SC_(0.4980707423963282387946443827582126326149502153493377709294283078423329727355541227395939352520310987), SC_(0.5019292576036717612053556172417873673850497846506622290705716921576670272644458772604060647479689013) }}, 
      {{ SC_(126.0), SC_(36.0), SC_(835.0), SC_(18.0), SC_(0.3799585706998840609408594612322193364676904938174623435887150953773714205956232978332861622106897387e-6), SC_(0.9999999354930715813276556862521139790879324956494442900207109419617548196367404723080980204731725536), SC_(0.6450692841867234431374788602091206750435055570997928905803824518036325952769190197952682744636644403e-7) }}, 
      {{ SC_(126.0), SC_(36.0), SC_(1339.0), SC_(4.0), SC_(0.1982568382972962648706835179640444664628718905646203171258931234261400353942764155948600756970592584), SC_(0.7542748620716567850126473939353663558064459457856118398118301388530416501634383306941505944742735962), SC_(0.2457251379283432149873526060646336441935540542143881601881698611469583498365616693058494055257264038) }}, 
      {{ SC_(126.0), SC_(36.0), SC_(2247.0), SC_(3.0), SC_(0.1889181540616172818652031788372512273599006463774594831072279030474882432951967924403256784863597123), SC_(0.8605515221177317474325235474722867468824887455315729759034614862897770239573063816257513219778339513), SC_(0.1394484778822682525674764525277132531175112544684270240965385137102229760426936183742486780221660487) }}, 
      {{ SC_(126.0), SC_(36.0), SC_(6337.0), SC_(4.0), SC_(0.004705772353215059396236178853919163496040551789884113140075110967950439677799555716111125007309980734), SC_(0.9993399510784776707219782930624213063854278187458143899433444744021443698750822466522818920673189633), SC_(0.0006600489215223292780217069375786936145721812541856100566555255978556301249177533477181079326810366675) }}, 
      {{ SC_(126.0), SC_(36.0), SC_(10473.0), SC_(11.0), SC_(0.2234057995462267906974670983888825583434005305420667928420398418313693676638782603892165104221859483e-12), SC_(0.9999999999999947074136069452919798593597062406925004009547934863379362846871173727076880670648936915), SC_(0.5292586393054708020140640293759307499599045206513662063715312882627292311932935106308534246654769258e-14) }}, 
      {{ SC_(126.0), SC_(36.0), SC_(19470.0), SC_(32.0), SC_(0.710984505982622454970604301845630953342413131888059599458042661843254468022925750029585844427017159e-67), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999580975537221850730379274495393), SC_(0.419024462778149269620725504607004283308198549498315330310754789575229454406555766982071638412996708e-70) }}, 
      {{ SC_(126.0), SC_(36.0), SC_(50688.0), SC_(11.0), SC_(0.812049975491024514330282542628428479799432305411948326217553342942512931100287724437484429890237495e-20), SC_(0.9999999999999999999999613425911236827349536486282186804147343085173496617411053527906164672642022225), SC_(0.3865740887631726504635137178131958526569148265033825889464720938353273579777753061976348956493051309e-22) }}, 
      {{ SC_(126.0), SC_(36.0), SC_(130605.0), SC_(24.0), SC_(0.505270146831766057588181409341112529584494485111962153192356124792074924330221806397547163158870586e-64), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999810327966973932996852566713747927), SC_(0.1896720330260670031474332862520728161729802060360195801841205370240874416495202326361718672470994297e-67) }}, 
      {{ SC_(126.0), SC_(36.0), SC_(256574.0), SC_(35.0), SC_(0.3012189225112239476042649007648521890212378589479439669128531668136749103564029882971229482939467064e-116), SC_(1.0), SC_(0.2969079495921349794109018632497464203370300451235392424051057153808816579375159301815885575728076926e-121) }}, 
      {{ SC_(126.0), SC_(36.0), SC_(523360.0), SC_(31.0), SC_(0.4513926036151357238267200832133074540286594469131634085932305993997186222481461603979531740726777645e-108), SC_(1.0), SC_(0.1280604107180418383834001686913230776618391911552287409421315495054524185247996535288964697494564586e-112) }}, 
      {{ SC_(126.0), SC_(36.0), SC_(1030167.0), SC_(10.0), SC_(0.1316354251384409194538965934852445271082935897146324726033960888553977333574059424209506488848780909e-30), SC_(0.9999999999999999999999999999999999649515765054863652293482686746802369785265648163796457354185957299), SC_(0.3504842349451363477065173132531976302147343518362035426458140427009507878548561628543802073377794356e-34) }}, 
      {{ SC_(126.0), SC_(36.0), SC_(2063277.0), SC_(1.0), SC_(0.0021937876595543216322720191681151314948437544079315812738172788020958692684709335300930380273848307), SC_(0.9999976723661402627007286104478809227461813247505621437325494160230329032520641596356046796708791458), SC_(0.2327633859737299271389552119077253818675249437856267450583976967096747935840364395320329120854228124e-5) }}, 
      {{ SC_(126.0), SC_(36.0), SC_(2427690.0), SC_(5.0), SC_(0.1308169186421169247090743688454531736062658255878829476766771074563501178771954968102101898254369729e-15), SC_(0.999999999999999999966303373684757476525405591764580675255913314270857250118738767885330003855615291), SC_(0.336966263152425234745944082354193247440866857291427498812612321146699961443847090466253498842411902e-19) }}, 
      {{ SC_(126.0), SC_(126.0), SC_(244.0), SC_(104.0), SC_(0.680341983753352392087212740587743413393591398754507804652434864636931832775061744643459118569429033e-24), SC_(0.9999999999999999999999999662434303858759988490149707470545662262260613165831006767516082434548038543), SC_(0.3375656961412400115098502925294543377377393868341689932324839175654519614574228221202734415289751718e-25) }}, 
      {{ SC_(126.0), SC_(126.0), SC_(312.0), SC_(48.0), SC_(0.07464075179208186576041652468318641530701312254312105670715132587580618311491845790468881209431013461), SC_(0.2878745807652788022214077848970976769525925456270790350758975793754059769288955078069385023942590811), SC_(0.7121254192347211977785922151029023230474074543729209649241024206245940230711044921930614976057409189) }}, 
      {{ SC_(126.0), SC_(126.0), SC_(835.0), SC_(26.0), SC_(0.01862258299343730298804086832081539875115734340146564983990714271133082197397617209520421469936958651), SC_(0.9753619234532405221324860185513752832120148022076313018191209964260251705336452335112385090960437049), SC_(0.02463807654675947786751398144862471678798519779236869818087900357397482946635476648876149090395629509) }}, 
      {{ SC_(126.0), SC_(126.0), SC_(1339.0), SC_(43.0), SC_(0.1425609360440266951697458948904278274070748566435544550061456409983116894739616508639427509986112413e-15), SC_(0.9999999999999999772874107669101724197218312457822675674522821787702159411807990918458235666197060713), SC_(0.2271258923308982758027816875421773243254771782122978405881920090815417643338029392869324146040886877e-16) }}, 
      {{ SC_(126.0), SC_(126.0), SC_(2247.0), SC_(84.0), SC_(0.5260538266268178070125896280281270530992267991569354011296481843135169489728780863731669893044712167e-87), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999947016246538), SC_(0.5298375346217474851939483235600576927649453007578185714092525904926855501479471729102148377865299174e-89) }}, 
      {{ SC_(126.0), SC_(126.0), SC_(6337.0), SC_(18.0), SC_(0.288922211403480422355650422424336610456838170626818615446126340969084175310238623339651675250349712e-10), SC_(0.9999999999967957732455708694006334053948516338632134576267084385733067518433067784378301398520389851), SC_(0.3204226754429130599366594605148366136786542373291561426693248156693221562169860147961014895178756384e-11) }}, 
      {{ SC_(126.0), SC_(126.0), SC_(10473.0), SC_(20.0), SC_(0.2401342748666235432069219766075193249957057018241805347211687005119501578630199130044612949271015356e-16), SC_(0.9999999999999999986812065217230973367505036019298294274816299877354223916153245257530403482668507697), SC_(0.1318793478276902663249496398070170572518370012264577608384675474246959651733149230334807736065940971e-17) }}, 
      {{ SC_(126.0), SC_(126.0), SC_(19470.0), SC_(101.0), SC_(0.1851494711590709946638091185680259754400443839839201839296162433457747134140823292859000453091245278e-220), SC_(1.0), SC_(0.5873823814092258717050020395953623761353205965050217581026580510386362285080514761196052671434154135e-224) }}, 
      {{ SC_(126.0), SC_(126.0), SC_(50688.0), SC_(41.0), SC_(0.2344859889024429719761685100434434565904385060640500382955789598886176097579529003946402780482998009e-76), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999198290229577263773063), SC_(0.8017097704227362269373194583314829395548721769042395076611245878956375397922220771702573567984398674e-79) }}, 
      {{ SC_(126.0), SC_(126.0), SC_(130605.0), SC_(73.0), SC_(0.2357494277319900780433770221824452746493745022246749283463882801047965016837605483946110755849459977e-195), SC_(1.0), SC_(0.6863145808554650904715187157061546098527151039191071072888834965675005673982364296795106912578599016e-199) }}, 
      {{ SC_(126.0), SC_(126.0), SC_(256574.0), SC_(30.0), SC_(0.1103166749538659739361241957613881058497519849994057068848755705123384113873678933641450250592540574e-71), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999987192582630879465274548401), SC_(0.1280741736912053472545159885715397644051913845640145111739156429333646729573450294058368741400772407e-74) }}, 
      {{ SC_(126.0), SC_(126.0), SC_(523360.0), SC_(4.0), SC_(0.311495903305621481658291345641842685458124422405792282170101936985249755607779472145712790658302431e-7), SC_(0.9999999998219116212092754459163425143503415661920231393624681525749227931601356204933379913900219976), SC_(0.1780883787907245540836574856496584338079768606375318474250772068398643795066620086099780023652145827e-9) }}, 
      {{ SC_(126.0), SC_(126.0), SC_(1030167.0), SC_(15.0), SC_(0.8760861746657609973645847916753283734614286125710991759992469557077761276093918808532836450193642305e-40), SC_(0.9999999999999999999999999999999999999999999344511778584942151615815671211246199887187472869022083236), SC_(0.6554882214150578483841843287887538001128125271309779167643344418369892747739082671792763485387052126e-43) }}, 
      {{ SC_(126.0), SC_(126.0), SC_(2063277.0), SC_(106.0), SC_(0.3773470045471354266117527624547707691807631640604038314999730438327110011863882241330658382210813389e-453), SC_(1.0), SC_(0.6837397185999943795252528588658103792700248479219314131730684828486887144428526574338201245231151216e-459) }}, 
      {{ SC_(126.0), SC_(126.0), SC_(2427690.0), SC_(93.0), SC_(0.9711216263017168014877138636253120991142002947370986581807968552225503372297288322472942539447971513e-389), SC_(1.0), SC_(0.4634582492589620051768115386461652489036912744475034457560421930704315119680085598722212533011485363e-394) }}, 
      {{ SC_(244.0), SC_(3.0), SC_(312.0), SC_(3.0), SC_(0.4770180239841063407083529477472014553230194761156279670956571693009821834632538916326905124747672201), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(244.0), SC_(3.0), SC_(835.0), SC_(1.0), SC_(0.4400003744228057828050877439676167714317881548863029466299077249475588279511175512293402261606835471), SC_(0.7940443915471672665102744669142373703024482959082051810083444052673841690210741600737137141506324668), SC_(0.2059556084528327334897255330857626296975517040917948189916555947326158309789258399262862858493675332) }}, 
      {{ SC_(244.0), SC_(3.0), SC_(1339.0), SC_(3.0), SC_(0.005990228212349126971361948211008827423530691924080782590054932768615380667728026870636338120283588327), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(244.0), SC_(3.0), SC_(2247.0), SC_(2.0), SC_(0.03144626965820539275782296147938095029533541067314917021275170416905626694408779261564654970298982919), SC_(0.9987335667736252779085716164623048444048142503939254286584313675471939396571028048239330229608714364), SC_(0.001266433226374722091428383537695155595185749606074571341568632452806060342897195176066977039128563599) }}, 
      {{ SC_(244.0), SC_(3.0), SC_(6337.0), SC_(3.0), SC_(0.5641128218170703896473013567478505050268533520887275953766973359875520909943842174702412349067048251e-4), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(244.0), SC_(3.0), SC_(10473.0), SC_(0.0), SC_(0.9317153643716630369782064721589410814624612304080385468634409507460088992277859800195495969544758839), SC_(0.9317153643716630369782064721589410814624612304080385468634409507460088992277859800195495969544758839), SC_(0.06828463562833696302179352784105891853753876959196145313655904925399110077221401998045040304552411612) }}, 
      {{ SC_(244.0), SC_(3.0), SC_(19470.0), SC_(3.0), SC_(0.1944377253116700999530700539936670494165174588645229609509492054817650348512737079716407052268782338e-5), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(244.0), SC_(3.0), SC_(50688.0), SC_(3.0), SC_(0.1101848040352654709743671805370222299999615199170655579817037224636559606375173065885645487405214683e-6), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(244.0), SC_(3.0), SC_(130605.0), SC_(1.0), SC_(0.005583849204998768799080765737887550258876350994478648797621325686151293335375441756939587525555405137), SC_(0.9999895848804557385796402477396405068119668418267767070067994686249085797130838153038887644927657497), SC_(0.1041511954426142035975226035949318803315817322329299320053137509142028691618469611123550723425028331e-4) }}, 
      {{ SC_(244.0), SC_(3.0), SC_(256574.0), SC_(2.0), SC_(0.2699503752209403051603052131960100774609581944181207424365775340619697157747134018700342592428205576e-5), SC_(0.9999999991504702167327591535807505742150816168539007913082716333157549153523551324784283219242649136), SC_(0.8495297832672408464192494257849183831460992086917283666842450846476448675215716780757350864027477903e-9) }}, 
      {{ SC_(244.0), SC_(3.0), SC_(523360.0), SC_(1.0), SC_(0.001397356331403569238585378628024806019827986884162097162953114348556280129749515397460638602861558385), SC_(0.9999993507929428023989019846670526424355349963398605880113895417212876149812442504868383647810717439), SC_(0.649207057197601098015332947357564465003660139411988610458278712385018755749513161635218928256056582e-6) }}, 
      {{ SC_(244.0), SC_(3.0), SC_(1030167.0), SC_(3.0), SC_(0.1312471342447911488104856032519501317146809701071276405354779784728481053249529636831714320183543859e-10), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(244.0), SC_(3.0), SC_(2063277.0), SC_(0.0), SC_(0.9996452663443166054003242855400061151503793154764165316890523206363214038726963380749664963582775732), SC_(0.9996452663443166054003242855400061151503793154764165316890523206363214038726963380749664963582775732), SC_(0.0003547336556833945996757144599938848496206845235834683109476793636785961273036619250335036417224268376) }}, 
      {{ SC_(244.0), SC_(3.0), SC_(2427690.0), SC_(2.0), SC_(0.301778142236890381051219292548925766727949557126569024695897642163972278968864445922536008902131187e-7), SC_(0.9999999999989971584617285345418683523231572053432817346184064828633825121977491668308698708825162293), SC_(0.1002841538271465458131647676842794656718265381593517136617487802250833169130129117483770747541739898e-11) }}, 
      {{ SC_(244.0), SC_(4.0), SC_(312.0), SC_(2.0), SC_(0.1743796932738175790955031717833787876475709486626655715387799136111108744169609829317610506968658794), SC_(0.2080574553273574343579771450022189431045016464488118216178895538789519090076076168039798288040272365), SC_(0.7919425446726425656420228549977810568954983535511881783821104461210480909923923831960201711959727635) }}, 
      {{ SC_(244.0), SC_(4.0), SC_(835.0), SC_(3.0), SC_(0.07028102460426857035972400551868663586706251150652958246283777073355645490138368838981035783247815263), SC_(0.9928351408927120450690805899619274622487470113058064173546768600901915796822193447961318543834064151), SC_(0.007164859107287954930919410038072537751252988694193582645323139909808420317780655203868145616593584934) }}, 
      {{ SC_(244.0), SC_(4.0), SC_(1339.0), SC_(0.0), SC_(0.4467861332960385479737173695646000011358887161444167603380167322686532742456999060658795554790003747), SC_(0.4467861332960385479737173695646000011358887161444167603380167322686532742456999060658795554790003747), SC_(0.5532138667039614520262826304353999988641112838555832396619832677313467257543000939341204445209996253) }}, 
      {{ SC_(244.0), SC_(4.0), SC_(2247.0), SC_(2.0), SC_(0.05611001056660177923454685283575816621324553669130538214432166822321804493945076721615364750925636189), SC_(0.9953423023987207747680220814008029772161016080664289495178404974897466951827403958163632970125097882), SC_(0.004657697601279225231977918599197022783898391933571050482159502510253304817259604183636702987490211845) }}, 
      {{ SC_(244.0), SC_(4.0), SC_(6337.0), SC_(2.0), SC_(0.008196243818720019081357533523391169857466410185601966646382483029108850148545882354061379728734213294), SC_(0.9997807939866848191742913004689985026131950435498111801025417326881802712406750113870445998182071562), SC_(0.0002192060133151808257086995310014973868049564501888198974582673118197287593249886129554001817928437932) }}, 
      {{ SC_(244.0), SC_(4.0), SC_(10473.0), SC_(1.0), SC_(0.08685331381344251423980224611529383911245101823096901831315361680306635010948606652331235975430453321), SC_(0.9968553497317449226580581567454114607967994940812653105983061633483086618099005299120338667702042838), SC_(0.003144650268255077341941843254588539203200505918734689401693836651691338190099470087966133229795716216) }}, 
      {{ SC_(244.0), SC_(4.0), SC_(19470.0), SC_(3.0), SC_(0.7681224034195652831350952603035378213555174734944918985448090459942291180049495678764605123936838595e-5), SC_(0.9999999759287554322122083070376108221740592236190950910001368525305601679224464996368399747442287154), SC_(0.2407124456778779169296238917782594077638090490899986314746943983207755350036316002525577128457268935e-7) }}, 
      {{ SC_(244.0), SC_(4.0), SC_(50688.0), SC_(0.0), SC_(0.9808829760642084364113470145043876051147331069207867615724336243040348151423129666647026694027032668), SC_(0.9808829760642084364113470145043876051147331069207867615724336243040348151423129666647026694027032668), SC_(0.01911702393579156358865298549561239488526689307921323842756637569596518485768703333529733059729673321) }}, 
      {{ SC_(244.0), SC_(4.0), SC_(130605.0), SC_(2.0), SC_(0.2077878373707448305809445604671712091555953647966052063248621202820765745243512440656117055447000878e-4), SC_(0.9999999742723242758211692949676638653724246215950165372671157117309228719452996566653740056763390042), SC_(0.2572767572417883070503233613462757537840498346273288428826907712805470034333462599432366099580079428e-7) }}, 
      {{ SC_(244.0), SC_(4.0), SC_(256574.0), SC_(3.0), SC_(0.3394927241892370473087702122398059471286148631980243008479875629712343642785154294188480806616160795e-8), SC_(0.9999999999992020272058517718526761048145964846754379493033323854357238227862077747633631474165442215), SC_(0.7979727941482281473238951854035153245620506966676145642761772137922252366368525834557785452564012061e-12) }}, 
      {{ SC_(244.0), SC_(4.0), SC_(523360.0), SC_(2.0), SC_(0.1297613630967264505781892691260565399213924005416530630516480277051086158226445976173551879711940452e-5), SC_(0.9999999995997582860311548756133982727182346033018632962767047999614261434563260288174282579640473308), SC_(0.4002417139688451243866017272817653966981367037232952000385738565436739711825717420359526691893212668e-9) }}, 
      {{ SC_(244.0), SC_(4.0), SC_(1030167.0), SC_(1.0), SC_(0.0009467489183446274947256370601964061583951637412246343485208638784015154765655623273172408439829046921), SC_(0.999999664882994985453565925008436806418996639522039601795865262428174561635908241994043794571540284), SC_(0.335117005014546434074991563193581003360477960398204134737571825438364091758005956205428459716005757e-6) }}, 
      {{ SC_(244.0), SC_(4.0), SC_(2063277.0), SC_(2.0), SC_(0.8354695090311114083699114997632573775302091220869586012378222546537713942254703411438011616912522249e-7), SC_(0.9999999999934662662892266013153676331697021559161246622552972727538568323452368578885237235637715029), SC_(0.6533733710773398684632366830297844083875337744702727246143167654763142111476276436228497142854501093e-11) }}, 
      {{ SC_(244.0), SC_(4.0), SC_(2427690.0), SC_(3.0), SC_(0.4010967938965633939597379112812046228813065980066881437703582538642874442109626697296186202430355507e-11), SC_(0.9999999999999999004464699430267676971013602169004850011134232032228084078324106050357937031155388969), SC_(0.9955353005697323230289863978309951499888657679677719159216758939496420629688446110306590261576354439e-16) }}, 
      {{ SC_(244.0), SC_(15.0), SC_(312.0), SC_(5.0), SC_(0.000143231166224605180492664750747876993366479767895568988939441556844770930680484778098380926754251396), SC_(0.0001602737242433244351998593491057141553081698468312161190790888544031149130254313888628803498175709665), SC_(0.999839726275756675564800140650894285844691830153168783880920911145596885086974568611137119650182429) }}, 
      {{ SC_(244.0), SC_(15.0), SC_(835.0), SC_(4.0), SC_(0.2240778925031697024987561911821959604652537046108869839280815902792519348945308539074878851528459315), SC_(0.5421278084300252702715562947469493100376969666696057666710540292531411113476198227891167379423078457), SC_(0.4578721915699747297284437052530506899623030333303942333289459707468588886523801772108832620576921543) }}, 
      {{ SC_(244.0), SC_(15.0), SC_(1339.0), SC_(10.0), SC_(0.3943374654492209268095306539150108255417137108582899045911979361509155812341709065077260259131297053e-4), SC_(0.9999958682954455826283590713141021164125232868935466009541595247025065893788054400400873451260738589), SC_(0.4131704554417371640928685897883587476713106453399045840475297493410621194559959912654873926141134903e-5) }}, 
      {{ SC_(244.0), SC_(15.0), SC_(2247.0), SC_(13.0), SC_(0.1842590157231676312453503946037483456083529066394968792279742423427889412412760343582003910583017728e-10), SC_(0.9999999999996939512872987825933652826695874605035692129800622819606509510357031521291645152084952507), SC_(0.30604871270121740663471733041253949643078701993771803934904896429684787083548479150474929579751725e-12) }}, 
      {{ SC_(244.0), SC_(15.0), SC_(6337.0), SC_(15.0), SC_(0.3972722827411798402634113268738217226044912512202962501855799571584508105557346650027819712160174954e-21), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(244.0), SC_(15.0), SC_(10473.0), SC_(7.0), SC_(0.1833703422945858159993829051775311000250242637739371633670425773567285467577914559144996270970614625e-7), SC_(0.9999999995671106024096816338588230259689105439894264281736809055722054361950261386590246718599596985), SC_(0.4328893975903183661411769740310894560105735718263190944277945638049738613409753281400403015260806844e-9) }}, 
      {{ SC_(244.0), SC_(15.0), SC_(19470.0), SC_(15.0), SC_(0.1914237498692942974344186235040060301629099331440041059429600633461384510647294986331940206691784938e-28), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(244.0), SC_(15.0), SC_(50688.0), SC_(0.0), SC_(0.9301673029997237388547097843356152151662471244105204163097989992934693174042036721784171071989946548), SC_(0.9301673029997237388547097843356152151662471244105204163097989992934693174042036721784171071989946548), SC_(0.06983269700027626114529021566438478483375287558947958369020100070653068259579632782158289280100534517) }}, 
      {{ SC_(244.0), SC_(15.0), SC_(130605.0), SC_(10.0), SC_(0.127924982000466227101425390598724586934983894933531502414759804459384126167652649393910992730528275e-23), SC_(0.9999999999999999999999999989555853292074427742551014743435651037978415497395381256284653418372748633), SC_(0.104441467079255722574489852565643489620215845026046187437153465816272513672968008316863653438289886e-26) }}, 
      {{ SC_(244.0), SC_(15.0), SC_(256574.0), SC_(3.0), SC_(0.3822014659919447063523351354494708474265664471671023085404386629000581027271178784157374101566128086e-6), SC_(0.9999999989196986252102894550169080113836614533309818265948161989378723756543080577261346635477386074), SC_(0.1080301374789710544983091988616338546669018173405183801062127624345691942273865336452261392633840662e-8) }}, 
      {{ SC_(244.0), SC_(15.0), SC_(523360.0), SC_(2.0), SC_(0.2259300084408491720216374428324111720031755847765900100076053551104297821568491884907404386249551941e-4), SC_(0.9999999546451448369156636263918899303286793970784001532009125344237863102058973917466935500970613459), SC_(0.4535485516308433637360811006967132060292159984679908746557621368979410260825330644990293865408719578e-7) }}, 
      {{ SC_(244.0), SC_(15.0), SC_(1030167.0), SC_(10.0), SC_(0.1382762135776937406397449398066313994192261198199239302894294100405263492462613998219850432305154946e-32), SC_(0.9999999999999999999999999999999999998571861470732491160171976153930468279696974802023161396871529566), SC_(0.1428138529267508839828023846069531720303025197976838603128470433957275217601778339164654189623608897e-36) }}, 
      {{ SC_(244.0), SC_(15.0), SC_(2063277.0), SC_(10.0), SC_(0.1331944005795815279808656006210226749632119686157229588712163303333075442291117006457674486347567774e-35), SC_(0.9999999999999999999999999999999999999999313263451565223317598302965398390362673224708813052581273958), SC_(0.6867365484347766824016970346016096373267752911869474187260415641877845840384754572770509648070507768e-40) }}, 
      {{ SC_(244.0), SC_(15.0), SC_(2427690.0), SC_(5.0), SC_(0.2952590034149598183761385151299351948209537826077935883003538659650865686537914368758472394615396354e-16), SC_(0.999999999999999999995154299351812970842452814011899270836576403667356109945060915875011051567521002), SC_(0.4845700648187029157547185988100729163423596332643890054939084124988948432478998037887354404352921527e-20) }}, 
      {{ SC_(244.0), SC_(29.0), SC_(312.0), SC_(18.0), SC_(0.01872365716512474145982059686936167128702265951831428959753359145475958545774070379578492385802337595), SC_(0.02884394781223418495828171168519673526032199470226478976721681845902613455487538025064726431032434938), SC_(0.9711560521877658150417182883148032647396780052977352102327831815409738654451246197493527356896756506) }}, 
      {{ SC_(244.0), SC_(29.0), SC_(835.0), SC_(29.0), SC_(0.925692894606394856102688813511459437841915087079918195795746923982338083317580606898868697013763104e-16), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(244.0), SC_(29.0), SC_(1339.0), SC_(21.0), SC_(0.1390992646030932133146570216258392436225896872262353287065512029780189072819927098700037176826495664e-9), SC_(0.9999999999889554557139798093748884742279693190089705636402200703492558636020112239785175898135973999), SC_(0.1104454428602019062511152577203068099102943635977992965074413639798877602148241018640260012009014583e-10) }}, 
      {{ SC_(244.0), SC_(29.0), SC_(2247.0), SC_(0.0), SC_(0.03488291105209833251761075939958726888729253371696974272434780607078391144254916722488746119186387697), SC_(0.03488291105209833251761075939958726888729253371696974272434780607078391144254916722488746119186387697), SC_(0.965117088947901667482389240600412731112707466283030257275652193929216088557450832775112538808136123) }}, 
      {{ SC_(244.0), SC_(29.0), SC_(6337.0), SC_(15.0), SC_(0.1837204261887107861978465442598916805092840171740960478626407691323863533651994288914294665103076678e-13), SC_(0.9999999999999993767218485709053982213279875216784108115493406015241778586104652491404072695402707458), SC_(0.623278151429094601778672012478321589188450659398475822141389534750859592730459729254236924339537992e-15) }}, 
      {{ SC_(244.0), SC_(29.0), SC_(10473.0), SC_(5.0), SC_(0.0004495210961888959552912093961868074693608083184909435307228560993019194447013201168848891558032466902), SC_(0.9999544495972792748963323753380632209335665049356148142832783424754254971173914384501964838414657104), SC_(0.4555040272072510366762466193677906643349506438518571672165752457450288260856154980351615853428963285e-4) }}, 
      {{ SC_(244.0), SC_(29.0), SC_(19470.0), SC_(0.0), SC_(0.6935081370436300326421316721046764276432674424300740169141886598615743526444741010372427663765032538), SC_(0.6935081370436300326421316721046764276432674424300740169141886598615743526444741010372427663765032538), SC_(0.3064918629563699673578683278953235723567325575699259830858113401384256473555258989627572336234967462) }}, 
      {{ SC_(244.0), SC_(29.0), SC_(50688.0), SC_(24.0), SC_(0.8697026837897281543357552616529377984403999579892747666840133414478659851447997514305470108009860783e-51), SC_(0.9999999999999999999999999999999999999999999999999999992408308696267564454971816727361458828715934502), SC_(0.7591691303732435545028183272638541171284065498430673848388190349930839875067433232859716007461958489e-54) }}, 
      {{ SC_(244.0), SC_(29.0), SC_(130605.0), SC_(4.0), SC_(0.2695993453646231106950748186005856879113329247208851881913990109871514166560154624304904053223426088e-6), SC_(0.9999999974995092426495255961510500098256936397979145640699795138199499621158445715980246043685981414), SC_(0.2500490757350474403848949990174306360202085435930020486180050037884155428401975395631401858578558684e-8) }}, 
      {{ SC_(244.0), SC_(29.0), SC_(256574.0), SC_(27.0), SC_(0.2346900738473939004915804534175837969200283902259565914521490482688076382282031872062343349908620483e-79), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999985808075377657591), SC_(0.1419192462234240934263183662013489535875840197797738580855609702901700050709773996433434049133990057e-83) }}, 
      {{ SC_(244.0), SC_(29.0), SC_(523360.0), SC_(9.0), SC_(0.8897133220352106581929283553637880739960898046871058257930451380892700294425450881661492839370890401e-23), SC_(0.9999999999999999999999999919997900798512094759612247760971588387588639608714501154840743884403935857), SC_(0.8000209920148790524038775223902841161241136039128549884515925611559606414341446824829607114495716867e-26) }}, 
      {{ SC_(244.0), SC_(29.0), SC_(1030167.0), SC_(3.0), SC_(0.4766684676093044992381714944068139314151245420196101495259544173526047126694435571266088806978958374e-7), SC_(0.9999999999274130068094521901714249496480660694038920266037918507945834202739514905935536906458382823), SC_(0.7258699319054780982857505035193393059610797339620814920541657972604850940644630935416171772762499428e-10) }}, 
      {{ SC_(244.0), SC_(29.0), SC_(2063277.0), SC_(4.0), SC_(0.4518752069402577053967811266572457701787831502995634512051018263157538307439680438846020808718494395e-11), SC_(0.9999999999999973703380708508675921224850619352776586871969272287172659442736991392718069563528026174), SC_(0.2629661929149132407877514938064722341312803072771282734055726300860728193043647197382595012756955949e-14) }}, 
      {{ SC_(244.0), SC_(29.0), SC_(2427690.0), SC_(13.0), SC_(0.5227357975112688864231471678705863292768689777659476072913263535136486589544411632073979032416206762e-44), SC_(0.9999999999999999999999999999999999999999999999994314346015102057547294146965673965960692971422787139), SC_(0.5685653984897942452705853034326034039307028577212860956281584685673787630269444975479529419633736942e-48) }}, 
      {{ SC_(244.0), SC_(36.0), SC_(312.0), SC_(18.0), SC_(0.4851117178947432170595969688234252137097782778088878871014541169844537123416946466290615935556280959e-4), SC_(0.6082530151642620649882409375008633949910868858475015310600467786283654815132453948806769187545598903e-4), SC_(0.999939174698483573793501175906249913660500891311415249846893995322137163451848675460511932308124544) }}, 
      {{ SC_(244.0), SC_(36.0), SC_(835.0), SC_(32.0), SC_(0.299766883653674697435400227064909747357238287287156178359657015755146460101634636822273744933903753e-13), SC_(0.9999999999999986476891085419297995266509329587532078176718670005683061865729350163043198752535256799), SC_(0.1352310891458070200473349067041246792182328132999431693813427064983695680124746474320128294391553127e-14) }}, 
      {{ SC_(244.0), SC_(36.0), SC_(1339.0), SC_(19.0), SC_(0.1739047212308058700693982796262207175514815053212279312027913957230188766155186661169619969448481626e-5), SC_(0.9999996352370795877797925601546366910703392312345440027996826035966746859270689937457889984101244724), SC_(0.3647629204122202074398453633089296607687654559972003173964033253140729310062542110015898755275790702e-6) }}, 
      {{ SC_(244.0), SC_(36.0), SC_(2247.0), SC_(1.0), SC_(0.06878122142214665016535173919529238975241472277522141462253433446319943968545453679702266608597255753), SC_(0.08419122185005928763409174633740707816689015246803058401883984109156652726525582646192938362435985184), SC_(0.9158087781499407123659082536625929218331098475319694159811601589084334727347441735380706163756401482) }}, 
      {{ SC_(244.0), SC_(36.0), SC_(6337.0), SC_(14.0), SC_(0.1832396387482455133957514181726545566341887246852519333370007709116366116369223808533542517132586952e-10), SC_(0.9999999999989293037596163518449676692794926674623225682086243061531600314183674863807850293490097004), SC_(0.1070696240383648155032330720507332537677431791375693846839968581632513619214970650990299630249248876e-11) }}, 
      {{ SC_(244.0), SC_(36.0), SC_(10473.0), SC_(30.0), SC_(0.2922148429087151772791719984860617799898342720955187974231924908994153919973708847610655592084626221e-43), SC_(0.9999999999999999999999999999999999999999999998812319589441733923522852954544263736849101912772681592), SC_(0.1187680410558266076477147045455736263150898087227318408032117262152274775842069400252522952981490888e-45) }}, 
      {{ SC_(244.0), SC_(36.0), SC_(19470.0), SC_(12.0), SC_(0.1073473944861550495054975200684813947188191075068166388415157680292952486450349113656805741622139752e-13), SC_(0.9999999999999997557542242373317740909941941292893350568167257686689590317379552928089619842574006605), SC_(0.2442457757626682259090058058707106649431832742313310409682620447071910380157425993394925536795609379e-15) }}, 
      {{ SC_(244.0), SC_(36.0), SC_(50688.0), SC_(27.0), SC_(0.5475571807394376841767182967291186147303638368597578524567967716426103368490504897606056342877956218e-55), SC_(0.9999999999999999999999999999999999999999999999999999999999241865366317443357998940652017145755811586), SC_(0.7581346336825566420010593479828542441884137504755223526763914035205592377408635116092099521798727761e-58) }}, 
      {{ SC_(244.0), SC_(36.0), SC_(130605.0), SC_(33.0), SC_(0.6698932207747914846687686414904942509477875007738058350811557941168363401279811491483867679967915421e-87), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999043182007), SC_(0.9568179925979815065308174638187843973556881592697755445966218184868767599748672555003240461015995175e-91) }}, 
      {{ SC_(244.0), SC_(36.0), SC_(256574.0), SC_(14.0), SC_(0.1260033861657281735435129438796329316651803873286028051858115561027296645027577320518494901894699949e-32), SC_(0.9999999999999999999999999999999999983396978557518105741319390517411192797127014052232947795767909467), SC_(0.1660302144248189425868060948258880720287298594776705220423209053297546842084065422043104966144894215e-35) }}, 
      {{ SC_(244.0), SC_(36.0), SC_(523360.0), SC_(16.0), SC_(0.2184112393461744590178151564246778413898041498620469448588525881009309714431977935030016735056109526e-43), SC_(0.999999999999999999999999999999999999999999999988795108779419934693229105963447525808233742731737142), SC_(0.1120489122058006530677089403655247419176625726826285796458024546574422059532907347072282521327875035e-46) }}, 
      {{ SC_(244.0), SC_(36.0), SC_(1030167.0), SC_(24.0), SC_(0.3769122215900548105596724482427273998170344675207126672374166658531545174400582066022085796280464367e-78), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999613505701716910944), SC_(0.3864942982830890556944697829848817387522445517135380009409132897329814191025824773402053845739625719e-82) }}, 
      {{ SC_(244.0), SC_(36.0), SC_(2063277.0), SC_(12.0), SC_(0.7095099433992653909201959194120133337265124573998677703231555380798762986693513583339504888857374524e-38), SC_(0.9999999999999999999999999999999999999999985266941153219184906700945742206698151364540509227998258862), SC_(0.1473305884678081509329905425779330184863545949077200174113770636262075523518559777187593568958321395e-41) }}, 
      {{ SC_(244.0), SC_(36.0), SC_(2427690.0), SC_(9.0), SC_(0.8464406705498068260239180972117985765464478762810789298222711098541213747712458811292211840712908207e-28), SC_(0.9999999999999999999999999999999778699606480791889373865567583849245607628264129458820484674493601818), SC_(0.2213003935192081106261344324161507543923717358705411795153255063981823161284617113781101106246482306e-31) }}, 
      {{ SC_(244.0), SC_(126.0), SC_(312.0), SC_(113.0), SC_(0.2020113250644574074591084695388386569710754517058558565013921504778014930443208819314565310270394159e-4), SC_(0.9999929986465220685451875101708229702495662574976557577590333463133434619062089272038289686510206604), SC_(0.7001353477931454812489829177029750433742502344242240966653686656538093791072796171031348979339584121e-5) }}, 
      {{ SC_(244.0), SC_(126.0), SC_(835.0), SC_(87.0), SC_(0.3478462174714855855687132993362914559496149827930914678601652322125422820518215463383055958323082295e-23), SC_(0.9999999999999999999999995029325427857582809474034259839988233417970601145805739271142268011981911139), SC_(0.4970674572142417190525965740160011766582029398854194260728857731988018088860695918630507435344174186e-24) }}, 
      {{ SC_(244.0), SC_(126.0), SC_(1339.0), SC_(84.0), SC_(0.1428698588412447862619036719317901107488720223801389004526350356024686808360289888860980102241216339e-36), SC_(0.9999999999999999999999999999999999999884568944588844311852875631075234724268063889498168032106621806), SC_(0.1154310554111556881471243689247652757319361105018319678933781941834473343466444156706173918347096652e-37) }}, 
      {{ SC_(244.0), SC_(126.0), SC_(2247.0), SC_(99.0), SC_(0.8488776719788461174219425216661151265165621481589288191159796732321131718018208787377878930273175448e-78), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999828691946265626229008), SC_(0.1713080537343737709923359898362378848237051648042133389253613473438220477101855207404104686453035512e-79) }}, 
      {{ SC_(244.0), SC_(126.0), SC_(6337.0), SC_(65.0), SC_(0.1269373870130067533146313949489719649272632435867308774300607988161518820052135306173759991672527701e-59), SC_(0.9999999999999999999999999999999999999999999999999999999999999642471493590924223528034207723650250482), SC_(0.3575285064090757764719657922763497495179620758137466169412586370655873947416238573329698812960107496e-61) }}, 
      {{ SC_(244.0), SC_(126.0), SC_(10473.0), SC_(12.0), SC_(0.2911350505311702293370527142545685516592600720282071540739568254635981680511290245728424433815287247e-4), SC_(0.9999928490810324820893961187233737462211234794467138053010964927448464048893258194617902392523465479), SC_(0.7150918967517910603881276626253778876520553286194698903507255153595110674180538209760747653452050224e-5) }}, 
      {{ SC_(244.0), SC_(126.0), SC_(19470.0), SC_(43.0), SC_(0.1405194037770045764069294572523311014575571213787461614940351580589986179347698179306239935567508824e-49), SC_(0.9999999999999999999999999999999999999999999999999997162958217710316805208271321452829648283596444632), SC_(0.2837041782289683194791728678547170351716403555368119723742616734955392607229763915189211299708629463e-51) }}, 
      {{ SC_(244.0), SC_(126.0), SC_(50688.0), SC_(99.0), SC_(0.6807486948113179904196046949457324161348557502028178966206776264906235074898933514068592243018647398e-212), SC_(1.0), SC_(0.5289959883589811031024929990765947455027343813631069589575327695028296813681103559180179212273654179e-215) }}, 
      {{ SC_(244.0), SC_(126.0), SC_(130605.0), SC_(23.0), SC_(0.4677254497194537704494064606718119001076666501527774011052772626086461481801425488605528094734330797e-38), SC_(0.9999999999999999999999999999999999999999657071612665910991004324990285330832718096638433160573880776), SC_(0.3429283873340890089956750097146691672819033615668394261192241131865989932824447261942150246019256354e-40) }}, 
      //{{ SC_(244.0), SC_(126.0), SC_(256574.0), SC_(104.0), SC_(0.5975939329133893099583805746941522957391651140229518013274042560149808147901372804442918554328101285e-301), SC_(1.0), SC_(0.6839910252227458630874281724764477407733769285217382412582029975630647734720741470507677459191107096e-305) }}, 
      {{ SC_(244.0), SC_(126.0), SC_(523360.0), SC_(7.0), SC_(0.3511720567456293329025022213660631503997231866983967182669921931521824525008315250640201054692740945e-12), SC_(0.9999999999999976187741768287443583369259316190423643872898885975445512078637256531774463283229649197), SC_(0.2381225823171255641663074068380957635612710111402455448792136274346822553671677035080288203690004796e-14) }}, 
      {{ SC_(244.0), SC_(126.0), SC_(1030167.0), SC_(122.0), SC_(0.3821457004076598243309778298280577428642565477128874996703435982704958699898067325107611549432616036e-451), SC_(1.0), SC_(0.1472113959011237930775920757338406154293800643216679737373265569266618119066316443837897641624611374e-456) }}, 
      {{ SC_(244.0), SC_(126.0), SC_(2063277.0), SC_(54.0), SC_(0.2502962623202246813285233667882924239716348271062529649226634228079979355523860222998364312996617594e-178), SC_(1.0), SC_(0.3018123399498337967663529666872552274357799349373534944598048209182000159426012696333093844374210068e-182) }}, 
      {{ SC_(244.0), SC_(126.0), SC_(2427690.0), SC_(14.0), SC_(0.1000913218789896581128236556815019725330639940014205934524181591457918054725900057867892172452290913e-37), SC_(0.9999999999999999999999999999999999999999929139268502051027694025961022786286710501534329450069747843), SC_(0.7086073149794897230597403897721371328949846567054993025215703839288240025679335506426975748147566025e-41) }}, 
      {{ SC_(244.0), SC_(244.0), SC_(312.0), SC_(197.0), SC_(0.01692983162264328252598462467014525090402022461469176280018229077478398732676248936080677658550951122), SC_(0.984796516315017468256422606452788587888247736520219714119660216751257689624045948785252205785031896), SC_(0.01520348368498253174357739354721141211175226347978028588033978324874231037595405121474779421496810396) }}, 
      {{ SC_(244.0), SC_(244.0), SC_(835.0), SC_(70.0), SC_(0.06530227709727861126067265253091868165496602575470538027494436188586168708033221776634877694697876678), SC_(0.4486095468566429831870236540501271370519310730451461119589989375918194634871187988066475573770302035), SC_(0.5513904531433570168129763459498728629480689269548538880410010624081805365128812011933524426229697965) }}, 
      {{ SC_(244.0), SC_(244.0), SC_(1339.0), SC_(231.0), SC_(0.1816404347508350129809964307479622838093979617682164997917238237020657138863152455950623223800697317e-223), SC_(1.0), SC_(0.1222448155174563471255978420860217362311231527585376532912677564733437483318486081113543169236283462e-226) }}, 
      {{ SC_(244.0), SC_(244.0), SC_(2247.0), SC_(124.0), SC_(0.1767413881124691899469948271016911063438659554485404823793293918826061056728677930436128738679724415e-65), SC_(0.999999999999999999999999999999999999999999999999999999999999999999885088287233437299221396551970872), SC_(0.114911712766562700778603448029127978486529751080030579487912661986221422744463600110184228831357454e-66) }}, 
      {{ SC_(244.0), SC_(244.0), SC_(6337.0), SC_(115.0), SC_(0.3061764645357946331097533860127817346824078939345230283510819739156568700428844678270227969627718058e-105), SC_(1.0), SC_(0.7540359903346477850800284993648364871452219444844586157113175447790194195532757601989070025920987291e-107) }}, 
      {{ SC_(244.0), SC_(244.0), SC_(10473.0), SC_(93.0), SC_(0.5065985038949099151197163982435087724873420140581543014087202906290479195459137241991365125722319631e-92), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999998751488), SC_(0.1248511765606084272127209994103733917504042059631842245163148239374605881005423732430747440609026272e-93) }}, 
      {{ SC_(244.0), SC_(244.0), SC_(19470.0), SC_(121.0), SC_(0.1063116977036712541755663818225343695193623590139469623750962887948995374413596233739945902493615942e-173), SC_(1.0), SC_(0.694490341569558278738137390569730043788476284045057317718982543387066440095233584871031792252857751e-176) }}, 
      {{ SC_(244.0), SC_(244.0), SC_(50688.0), SC_(97.0), SC_(0.2073107276614154366606563966785031033293506692961582663921063656873057182072934761242733379112672758e-164), SC_(1.0), SC_(0.9127304168993233832842554945273821947396453086223394904208138166897870642125573316484956839900759953e-167) }}, 
      {{ SC_(244.0), SC_(244.0), SC_(130605.0), SC_(17.0), SC_(0.9598989207393151016916510712837920158323169290883013828338211972972907607186178699829140717911623159e-21), SC_(0.9999999999999999999999784392179622826567356998555933669178360710362668470536963914377476632750810867), SC_(0.2156078203771734326430014440663308216392896373315294630360856225233672491891330300674026768815675588e-22) }}, 
      {{ SC_(244.0), SC_(244.0), SC_(256574.0), SC_(204.0), SC_(0.8007727036642996631973091307326786703603314090556960216174508743225627800438240671105501891999613452e-627), SC_(1.0), SC_(0.2438678438028337021112440130697525090500260760200112126956278245826347335806606041518397777822699307e-631) }}, 
      {{ SC_(244.0), SC_(244.0), SC_(523360.0), SC_(0.0), SC_(0.8924273077231438613965285503778694188375070562142588235998194944852884687694320134953145196867685743), SC_(0.8924273077231438613965285503778694188375070562142588235998194944852884687694320134953145196867685743), SC_(0.1075726922768561386034714496221305811624929437857411764001805055147115312305679865046854803132314257) }}, 
      {{ SC_(244.0), SC_(244.0), SC_(1030167.0), SC_(132.0), SC_(0.8943071404055347984695053401763544222555893617716617784088253507039908546225600871399152676295810561e-426), SC_(1.0), SC_(0.8191283035776988360645554826976744095526623263438238157730893346027617368707648215930038800813451419e-430) }}, 
      {{ SC_(244.0), SC_(244.0), SC_(2063277.0), SC_(11.0), SC_(0.1783248177391298167150858963246492111260847328112328011658809165328530958120243059669573771044408714e-24), SC_(0.9999999999999999999999999996081160537628475751916867659978306522435711853480875656008935226420791466), SC_(0.3918839462371524248083132340021693477564288146519124343991064773579208534059637858480705968364636927e-27) }}, 
      {{ SC_(244.0), SC_(244.0), SC_(2427690.0), SC_(244.0), SC_(0.1466739038902170165634002418236321102762066893071402360741066774318795897679200697886978541852773418e-1079), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(312.0), SC_(3.0), SC_(835.0), SC_(3.0), SC_(0.05185362819577492824554109758321973514344349724553587428164735070782717946524665955642585298454021681), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(312.0), SC_(3.0), SC_(1339.0), SC_(3.0), SC_(0.01255765591899041969122767758944586396291733715564013582353347832838856364988445126505097615715865353), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(312.0), SC_(3.0), SC_(2247.0), SC_(3.0), SC_(0.002654895963463464649558904058467552427929160045196864320516330906473945632117401252164005232739721465), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(312.0), SC_(3.0), SC_(6337.0), SC_(2.0), SC_(0.006895214707985796314710862874458768781073024240181608509511721115587559876428984194741210670633328234), SC_(0.9998817418224356516261377390046427541730493699853689461334468252533426199965868334660929584891896912), SC_(0.0001182581775643483738622609953572458269506300146310538665531747466573800034131665339070415108103088107) }}, 
      {{ SC_(312.0), SC_(3.0), SC_(10473.0), SC_(3.0), SC_(0.2619315302741955391125829752911381764766728721610833471239309788071425398659529409140562945748129301e-4), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(312.0), SC_(3.0), SC_(19470.0), SC_(0.0), SC_(0.952689902806673310777397346075354230633230517821598312973371849914454423225226628397394333838182181), SC_(0.952689902806673310777397346075354230633230517821598312973371849914454423225226628397394333838182181), SC_(0.04731009719332668922260265392464576936676948217840168702662815008554557677477337160260566616181781904) }}, 
      {{ SC_(312.0), SC_(3.0), SC_(50688.0), SC_(1.0), SC_(0.01823999965869193318144869821751691900786714910013274407112315462179032380075150464687878515584295338), SC_(0.9998871607772255251497144289965738400573327140254392075740695124402366604877774609309299854127157457), SC_(0.0001128392227744748502855710034261599426672859745607924259304875597633395122225390690700145872842542754) }}, 
      {{ SC_(312.0), SC_(3.0), SC_(130605.0), SC_(3.0), SC_(0.1350228411440694022415456243132436575920723231733619261999004128736899895832171891988703888500484401e-7), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(312.0), SC_(3.0), SC_(256574.0), SC_(1.0), SC_(0.003639231809203836967990542879335650455625534463296636120853363252732588271173919589501433352098032573), SC_(0.999995581623920996601811609394884566864385642972266692028847893757547849395790098797951355329440947), SC_(0.4418376079003398188390605115433135614357027733307971152106242452150604209901202048644670559053043247e-5) }}, 
      {{ SC_(312.0), SC_(3.0), SC_(523360.0), SC_(0.0), SC_(0.9982126186512091063993363867259741560427784748575378012608790856102420150650380781441279954631691477), SC_(0.9982126186512091063993363867259741560427784748575378012608790856102420150650380781441279954631691477), SC_(0.001787381348790893600663613274025843957221525142462198739120914389757984934961921855872004536830852317) }}, 
      {{ SC_(312.0), SC_(3.0), SC_(1030167.0), SC_(2.0), SC_(0.2742146687945010652681279650646760737091044880041848240141786828097044523804030700262169778861369874e-6), SC_(0.9999999999724859171675315682844932315163948378332152289136828985813875446965149501298645615270602089), SC_(0.2751408283246843171550676848360516216678477108631710141861245530348504987013543847293979109982049108e-10) }}, 
      {{ SC_(312.0), SC_(3.0), SC_(2063277.0), SC_(1.0), SC_(0.0004535105332207965667106567644106304190901074420349302903698684352631346489895330890536047037220377852), SC_(0.9999999316280649714076472066349740505658692943466352471838473366206655549616580428859293855097130274), SC_(0.6837193502859235279336502594943413070565336475281615266337933444503834195711407061449028697260153873e-7) }}, 
      {{ SC_(312.0), SC_(3.0), SC_(2427690.0), SC_(1.0), SC_(0.0003854529211129920202763607683268178253647596829030975066362988825404527079234772831532219215882082522), SC_(0.9999999506129614089116775321124269734478101657155838809134660528476067788996560009015620514030859327), SC_(0.4938703859108832246788757302655218983428441611908653394715239322110034399909843794859691406733517006e-7) }}, 
      {{ SC_(312.0), SC_(4.0), SC_(835.0), SC_(3.0), SC_(0.1303819593576456128481634328654996225001007166318041454293344443278539175977115526346669284178583336), SC_(0.9807418616436364749664997606331551704815816819124151620756862603741362999341812286022408791199243666), SC_(0.01925813835636352503350023936684482951841831808758483792431373962586370006581877139775912088007563341) }}, 
      {{ SC_(312.0), SC_(4.0), SC_(1339.0), SC_(1.0), SC_(0.4211935377066894410449861398343695212993866668321369021359964960997777845114400299667932759329121209), SC_(0.7667882353121782131844619468779547695450372652585056423501474672585698128285190289139057074676092458), SC_(0.2332117646878217868155380531220452304549627347414943576498525327414301871714809710860942925323907542) }}, 
      {{ SC_(312.0), SC_(4.0), SC_(2247.0), SC_(0.0), SC_(0.5496982988299796225493425891224419781207950757052142668215853348216586889970199827108226087095994129), SC_(0.5496982988299796225493425891224419781207950757052142668215853348216586889970199827108226087095994129), SC_(0.4503017011700203774506574108775580218792049242947857331784146651783413110029800172891773912904005871) }}, 
      {{ SC_(312.0), SC_(4.0), SC_(6337.0), SC_(0.0), SC_(0.8170941004317138722112469653266868972519858272277725872771282076547830521122691510182732339433243073), SC_(0.8170941004317138722112469653266868972519858272277725872771282076547830521122691510182732339433243073), SC_(0.1829058995682861277887530346733131027480141727722274127228717923452169478877308489817267660566756927) }}, 
      {{ SC_(312.0), SC_(4.0), SC_(10473.0), SC_(1.0), SC_(0.1088579437738126982880746198601068390009732313610569989607833773534887035304433240603044111636035618), SC_(0.9948988034327785550270665978560726006771640039296603606944673093701058914008305723011475270288960146), SC_(0.005101196567221444972933402143927399322835996070339639305532690629894108599169427698852472971103985443) }}, 
      {{ SC_(312.0), SC_(4.0), SC_(19470.0), SC_(1.0), SC_(0.06107551233896996413675409091806863306263274702015486179641280467936708892921779587198582876817441629), SC_(0.9984965370609007838799629142639057054302050780867144593206814534239797399221399753013837054143129932), SC_(0.001503462939099216120037085736094294569794921913285540679318546576020260077860024698616294585687006827) }}, 
      {{ SC_(312.0), SC_(4.0), SC_(50688.0), SC_(0.0), SC_(0.9756044677325420267972269834573036260042365374762249676636858416176106800421339350083162890507931966), SC_(0.9756044677325420267972269834573036260042365374762249676636858416176106800421339350083162890507931966), SC_(0.02439553226745797320277301654269637399576346252377503233631415838238931995786606499168371094920680342) }}, 
      {{ SC_(312.0), SC_(4.0), SC_(130605.0), SC_(3.0), SC_(0.5388135263222380859790111645654876917242884244721166735689690661567868088695275898455715198841297478e-7), SC_(0.9999999999680540436490119253207166828128265338999782944667242192341853669988819401434606756859131327), SC_(0.3194595635098807467928331718717346610002170553327578076581463300111805985653932431408686728651062371e-10) }}, 
      {{ SC_(312.0), SC_(4.0), SC_(256574.0), SC_(1.0), SC_(0.004846427400480829927088442150560293437988442245691035346056947808574138700707683039213958258747533953), SC_(0.9999911703650777820791373981284691364872514401932383324175372413613086184067818159835122144739235314), SC_(0.8829634922217920862601871530863512748559806761667582462758638691381593218184016487785526076468625577e-5) }}, 
      {{ SC_(312.0), SC_(4.0), SC_(523360.0), SC_(4.0), SC_(0.1238905063976170610045238255584137985205480064506889273990601452719578971358947807755465387996412005e-12), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(312.0), SC_(4.0), SC_(1030167.0), SC_(4.0), SC_(0.8252910794041284106308890100444196370225026564383908133414920895551325408500970423944650742768676388e-14), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(312.0), SC_(4.0), SC_(2063277.0), SC_(4.0), SC_(0.5128687898465351372433042197790246526698608301576335593054597906186760923051343474334543732657123013e-15), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(312.0), SC_(4.0), SC_(2427690.0), SC_(2.0), SC_(0.9875726027790280897491991261611595208809064873920182013899563721730138710717208184762290303696246867e-7), SC_(0.9999999999915915478630820195723832815057862097609082505143761223454253876691753440364561549470362886), SC_(0.8408452136917980427616718494213790239091749485623877654574612330824655963543845052963711435566056831e-11) }}, 
      {{ SC_(312.0), SC_(15.0), SC_(835.0), SC_(10.0), SC_(0.01477853249203084597773444618576389344439017532359136611187458074903971225528392761870753316618632419), SC_(0.9952282192674488093928666777011542026134894754536895827090199524516586347029412596380055394785947095), SC_(0.004771780732551190607133322298845797386510524546310417290980047548341365297058740361994460521405290451) }}, 
      {{ SC_(312.0), SC_(15.0), SC_(1339.0), SC_(11.0), SC_(0.4673194360902635412927897208402714462780940475153312377424496946851684035372891877511060273252717719e-4), SC_(0.9999950987293629889477906052889647047024429400887476018263127380980018316132928493400237580639175703), SC_(0.4901270637011052209394711035295297557059911252398173687261901998168386707150659976241936082429693598e-5) }}, 
      {{ SC_(312.0), SC_(15.0), SC_(2247.0), SC_(12.0), SC_(0.12603979762474696240508652051066006315442995710355720592076865176803803534743956143957534544867258e-7), SC_(0.9999999995385137432590785242248790819894808385999755665557782331231241281463169807023131591990917401), SC_(0.4614862567409214757751209180105191614000244334442217668768758718536830192976868408009082598556576996e-9) }}, 
      {{ SC_(312.0), SC_(15.0), SC_(6337.0), SC_(11.0), SC_(0.3906095134536516956190644734852368501439576764783067672523967882154351007149048464407685921883893053e-11), SC_(0.999999999999934166658841208125815583212840874511451796700521209014078369907094163139974339759090144), SC_(0.6583334115879187418441678715912548854820329947879098592163009290583686002566024090985600044482778081e-13) }}, 
      {{ SC_(312.0), SC_(15.0), SC_(10473.0), SC_(11.0), SC_(0.1675638181353226500527828862810533804202540010714816681707394491835925914273036416369936255634211223e-13), SC_(0.9999999999999998333600141109823344606628399832423470305693347915725362624520664925429116758721202154), SC_(0.1666399858890176655393371600167576529694306652084274637375479335074570883241278797846131573493040891e-15) }}, 
      {{ SC_(312.0), SC_(15.0), SC_(19470.0), SC_(0.0), SC_(0.7847387514581619260781899358660101304315278555480658831664274210136316330501436950665426069756103397), SC_(0.7847387514581619260781899358660101304315278555480658831664274210136316330501436950665426069756103397), SC_(0.2152612485418380739218100641339898695684721444519341168335725789863683669498563049334573930243896603) }}, 
      {{ SC_(312.0), SC_(15.0), SC_(50688.0), SC_(8.0), SC_(0.116198673147034920091694055576305094815501119253924349928785273367805378850953685902534089851087994e-13), SC_(0.9999999999999999452571707284006704496221946357628996121048266104887058934335019650544884070751538585), SC_(0.5474282927159932955037780536423710038789517338951129410656649803494551159292484614152640878717396651e-16) }}, 
      {{ SC_(312.0), SC_(15.0), SC_(130605.0), SC_(5.0), SC_(0.2209806042234959529623033779045608177253926208178526715008073808063333549143267465183354722453209399e-9), SC_(0.9999999999991295120764203923921796350273304857243722318141076405460782497118084212123865263579366793), SC_(0.8704879235796076078203649726695142756277681858923594539217502881915787876134736420633207210506008428e-12) }}, 
      {{ SC_(312.0), SC_(15.0), SC_(256574.0), SC_(5.0), SC_(0.7640030878257210335532649900893427465423173280673702907558225554728048733431266628429870182217258816e-11), SC_(0.9999999999999847215133992331404173909986068235753239394334648016678619291235160399007331799603262866), SC_(0.1527848660076685958260900139317642467606056653519833213807087648396009926682003967371341952629206028e-13) }}, 
      {{ SC_(312.0), SC_(15.0), SC_(523360.0), SC_(8.0), SC_(0.9339995768528548592350437687234769446495100928154898461173820993969995271039220347441963437391142154e-22), SC_(0.9999999999999999999999999577632789078790667485276046020569447406687458432037920673638978435696466418), SC_(0.4223672109212093325147239539794305525933125415679620793263610215643035335816165847405145234048265806e-25) }}, 
      {{ SC_(312.0), SC_(15.0), SC_(1030167.0), SC_(9.0), SC_(0.953461376148190805469151437881251422978227789367948374729241655843514219778314403508392201254338415e-28), SC_(0.9999999999999999999999999999999831662489215310911536220035704523633611304195336177012956811328334446), SC_(0.1683375107846890884637799642954763663886958046638229870431886716655540557142313695785427697613535969e-31) }}, 
      {{ SC_(312.0), SC_(15.0), SC_(2063277.0), SC_(13.0), SC_(0.1761117263069269477772433312879217381843713412273800205761612176245373216971097818782409743222541961e-47), SC_(0.9999999999999999999999999999999999999999999999999999635351899606584189237323503544750407053207913946), SC_(0.3646481003934158107626764964552495929467920860541834047762727747435623788166390773961425860990914915e-52) }}, 
      {{ SC_(312.0), SC_(15.0), SC_(2427690.0), SC_(7.0), SC_(0.3478634909528917069948764548693873892052579365448640099639355728328145738753325268293212129617314805e-23), SC_(0.9999999999999999999999999995628657494046413161184187257678344047574177456684234621399455638638894009), SC_(0.4371342505953586838815812742321655952425822543315765378600544361361105990925909443327416312401964534e-27) }}, 
      {{ SC_(312.0), SC_(29.0), SC_(835.0), SC_(24.0), SC_(0.4064767267713647403690225524211486595353577950399123301509571907635641883716501576774007072266218567e-6), SC_(0.9999999508147081203582205058361987432926601982170760747457126836508156916310119512733388259619629036), SC_(0.4918529187964177949416380125670733980178292392525428731634918430836898804872666117403803709638974698e-7) }}, 
      {{ SC_(312.0), SC_(29.0), SC_(1339.0), SC_(16.0), SC_(0.0001385244992681627558984267276639195887607626272292822933571107720095154105406682403596199762071993342), SC_(0.9999619636701636874686451615128522777970926554699182243523911538335983658710823282886902472340931615), SC_(0.3803632983631253135483848714772220290734453008177564760884616640163412891767171130975276590683849805e-4) }}, 
      {{ SC_(312.0), SC_(29.0), SC_(2247.0), SC_(15.0), SC_(0.1068690347740739596629791001518424749463447635723883951720098403679423672257469386087287688735267805e-5), SC_(0.9999998365881529129157605002818001689860215160486423394173422251293666978992422607037957382103874218), SC_(0.1634118470870842394997181998310139784839513576605826577748706333021007577392962042617896125782032119e-6) }}, 
      {{ SC_(312.0), SC_(29.0), SC_(6337.0), SC_(3.0), SC_(0.1174106552880303914021163077504243062761002877464824481353487980476422922346981920121588451929063348), SC_(0.9481467827222466952992359491412557952991672691578304859597329601156518759654335857686512723680837772), SC_(0.0518532172777533047007640508587442047008327308421695140402670398843481240345664142313487276319162228) }}, 
      {{ SC_(312.0), SC_(29.0), SC_(10473.0), SC_(5.0), SC_(0.001320979886800693566934377414601477268207140894348651786836654714976698586487766443286159238646135308), SC_(0.9998227145875092804554459368763730148760558224392656436205263032926613241282222752074545750777555691), SC_(0.0001772854124907195445540631236269851239441775607343563794736967073386758717777247925454249222444309182) }}, 
      {{ SC_(312.0), SC_(29.0), SC_(19470.0), SC_(7.0), SC_(0.2798340488756381148562598493091928587064862813111148745104851310198814285251242441764506996290587843e-6), SC_(0.9999999872658568862865988869763055043497580901864008785983049179077796439674968156956274744421843238), SC_(0.1273414311371340111302369449565024190981359912140169508209222035603250318430437252555781567622129142e-7) }}, 
      {{ SC_(312.0), SC_(29.0), SC_(50688.0), SC_(28.0), SC_(0.1046736532832582933079450036543955498282692592319350906457230581975681471226117929666698544149394966e-60), SC_(0.9999999999999999999999999999999999999999999999999999999999999999796514230007958392204714471054577603), SC_(0.2034857699920416077952855289454223970310743869677238596333869202090579106007085284353676809279926473e-64) }}, 
      {{ SC_(312.0), SC_(29.0), SC_(130605.0), SC_(27.0), SC_(0.207024533247338869651539675717156008434945493121065860873639259004868354571629329665896091992476783e-68), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999996765154603686112115145809171), SC_(0.323484539631388788485419082891296195879669776298898416280653579503837197044320213636943573508333815e-72) }}, 
      {{ SC_(312.0), SC_(29.0), SC_(256574.0), SC_(8.0), SC_(0.1828744275693931685257169403193374285892658732467135300478504739567816819357749627114080419129754798e-16), SC_(0.9999999999999999999492564330892779545847887711071045842969348878673251138558856277918760178548249664), SC_(0.5074356691072204541521122889289541570306511213267488614411437220812398214517503358785838150945237209e-19) }}, 
      {{ SC_(312.0), SC_(29.0), SC_(523360.0), SC_(22.0), SC_(0.8326098627067413306640975537651346743081060433905253291753520670466130179117255793448748519518040903e-65), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999985948160445746868353499626976747), SC_(0.1405183955425313164650037302325330533817408709617715617942941892810796687572184701017195478965818422e-68) }}, 
      {{ SC_(312.0), SC_(29.0), SC_(1030167.0), SC_(29.0), SC_(0.2361315844475447555532594209152323415530443143177803409621754308979603450994136574912547445523401627e-102), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(312.0), SC_(29.0), SC_(2063277.0), SC_(5.0), SC_(0.9059436711443402787813041339012900728484089288004374545220733888384809817132241965917755737768754085e-14), SC_(0.9999999999999999946045925976690639894799452853302494983555488884130453406600738896873290599113275986), SC_(0.5395407402330936010520054714669750501644451111586954659339926110312670940088672401380480346746827103e-17) }}, 
      {{ SC_(312.0), SC_(29.0), SC_(2427690.0), SC_(15.0), SC_(0.2370561278737669383430810785623310629587418839765952539914457270961621911861761028157871779406119467e-50), SC_(0.9999999999999999999999999999999999999999999999999999997461827686143397041840889858190485781148284897), SC_(0.2538172313856602958159110141809514218851715102805133072932574774230420916998724021992190570221815528e-54) }}, 
      {{ SC_(312.0), SC_(36.0), SC_(835.0), SC_(12.0), SC_(0.1251328872179339793878948841131042608760411008840464149663011966812250961338309066288754678037280931), SC_(0.3736662600754361117583896337163407180756542713642610688414340709796499190704315268183591753156433019), SC_(0.6263337399245638882416103662836592819243457286357389311585659290203500809295684731816408246843566981) }}, 
      {{ SC_(312.0), SC_(36.0), SC_(1339.0), SC_(4.0), SC_(0.03457655696358424536216119337264409508734210573933442954160881274954800673710649999885837913613994369), SC_(0.0526485396162118410141517281967043080567460686717596540718082185394462445045634986706883464068483271), SC_(0.9473514603837881589858482718032956919432539313282403459281917814605537554954365013293116535931516729) }}, 
      {{ SC_(312.0), SC_(36.0), SC_(2247.0), SC_(29.0), SC_(0.1366529078398498544283788921512139862982840399819893943873629092530083922789654788565750568337318256e-18), SC_(0.9999999999999999999951867586647291011738886254328383129644920403139014257021568921874326462429161353), SC_(0.4813241335270898826111374567161687035507959686098574297843107812567353757083864734510465114793288281e-20) }}, 
      {{ SC_(312.0), SC_(36.0), SC_(6337.0), SC_(28.0), SC_(0.1541488555555234981084642146305778306333105498852271399824279745644848438692249838517352927524431242e-29), SC_(0.999999999999999999999999999999979710090525853752772788364726185814020365659519690937645359873077567), SC_(0.2028990947414624722721163527381418597963434048030906235464012692243300233727962255303646864835640776e-31) }}, 
      {{ SC_(312.0), SC_(36.0), SC_(10473.0), SC_(17.0), SC_(0.3718245875744946661222274973115998185979564641279176212170154425624413634073291566826402736386062994e-16), SC_(0.9999999999999999988263739570754134938281617806739440603426442789217717560754349581997995672695763198), SC_(0.1173626042924586506171838219326055939657355721078228243924565041800200432730423680186771422509619611e-17) }}, 
      {{ SC_(312.0), SC_(36.0), SC_(19470.0), SC_(4.0), SC_(0.002286807724013785213631588397252230564675659860959138564384009394125836537700745226171507862041360008), SC_(0.999743360700797549745656746168563954700960990551516197494439341934719522392229090081488200547815428), SC_(0.0002566392992024502543432538314360452990390094484838025055606580652804776077709099185117994521845720074) }}, 
      {{ SC_(312.0), SC_(36.0), SC_(50688.0), SC_(18.0), SC_(0.799995830496693081398979061458364112152369225596955635849028004729117349467387975656518045455913962e-30), SC_(0.9999999999999999999999999999999955533924332264083710048583939014631342652872082981219509701434088352), SC_(0.4446607566773591628995141606098536865734712791701878049029856591164837491224754456876682516939486614e-32) }}, 
      {{ SC_(312.0), SC_(36.0), SC_(130605.0), SC_(27.0), SC_(0.4727617711482949189141652530332046252585659152634909202705522499474324401513754253223039999871604627e-63), SC_(0.9999999999999999999999999999999999999999999999999999999999999999996673875664328226743571761958451206), SC_(0.3326124335671773256428238041548793867062855528689908897613248120125459770839410558354183604623604556e-66) }}, 
      {{ SC_(312.0), SC_(36.0), SC_(256574.0), SC_(28.0), SC_(0.2059193749876558319167567679235766161414414746130096819705275368245258740788737284126939575119283292e-74), SC_(0.999999999999999999999999999999999999999999999999999999999999999999999999999999370280541825290857594), SC_(0.6297194581747091424059681738135740449335048647683647807344849700243479936033439856806652257267962759e-78) }}, 
      {{ SC_(312.0), SC_(36.0), SC_(523360.0), SC_(3.0), SC_(0.1469302843653811856171342873774545561883686335839283520680651750626202202025813486956409636514116896e-5), SC_(0.9999999928113478912041769325398106971914232445769469142094241342658851595565566362578062457530801037), SC_(0.7188652108795823067460189302808576755423053085790575865734114840443443363742193754246919896274463816e-8) }}, 
      {{ SC_(312.0), SC_(36.0), SC_(1030167.0), SC_(7.0), SC_(0.1807746001081209087978134982607369064017165153364139527669983016906963407601263205399077366977527342e-17), SC_(0.9999999999999999999980574152782751945411852274466332151660823416239429895273272298453724563678706067), SC_(0.1942584721724805458814772553366784833917658376057010472672770154627543632129393322169935702195310694e-20) }}, 
      {{ SC_(312.0), SC_(36.0), SC_(2063277.0), SC_(2.0), SC_(0.1428637158455541797574209299161023734134955406141164796449611956071669532477838807628803526775893045e-4), SC_(0.9999999756391048883459333536025087222414660660227162453754324418676414137834292993791839806764407081), SC_(0.243608951116540666463974912777585339339772837546245675581323585862165707006208160193235592918942101e-7) }}, 
      {{ SC_(312.0), SC_(36.0), SC_(2427690.0), SC_(5.0), SC_(0.1274826291292552318296133175790310535535177816617746967315685531198300931501528810238099701138229312e-13), SC_(0.9999999999999999916650602068364145738606675771244884264651274060963977694029839756173306077911535002), SC_(0.8334939793163585426139332422875511573534872593903602230597016024382669392208846499829077215285163585e-17) }}, 
      {{ SC_(312.0), SC_(126.0), SC_(835.0), SC_(22.0), SC_(0.9762546102036121396544712867427388051900855681284322259987467100531573747735290592759878997475154876e-7), SC_(0.1383684614265775810773881106940828676099497035673446307865060033544170934096457784723309639813565828e-6), SC_(0.9999998616315385734224189226118893059171323900502964326553692134939966455829065903542215276690360186) }}, 
      {{ SC_(312.0), SC_(126.0), SC_(1339.0), SC_(43.0), SC_(0.001183119217204639199838893398333759584174859000784154292235029266571472088143185867487639735703542495), SC_(0.9987333831682537940624791664538901119552545077127755439554473380016190051462532284257726372483602511), SC_(0.001266616831746205937520833546109888044745492287224456044552661998380994853746771574227362751639748904) }}, 
      {{ SC_(312.0), SC_(126.0), SC_(2247.0), SC_(109.0), SC_(0.1846940881506996440993161586937744750611356043036855411471347118284253053030934028372220919055875132e-81), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999969340921874684424), SC_(0.3065907812531557628223505224485855097817554257363741825007159531435156204337991460967945195256029192e-83) }}, 
      {{ SC_(312.0), SC_(126.0), SC_(6337.0), SC_(85.0), SC_(0.2178798445163732023324455748223987858468754001921053971464761965383806716553370687652522850157752458e-83), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999599074583736212), SC_(0.4009254162637876010114082807573879305615967771064453552067313578919889371246112284237788227392874001e-85) }}, 
      {{ SC_(312.0), SC_(126.0), SC_(10473.0), SC_(23.0), SC_(0.1817949445050688343330295610888862215203960350547959373816913145606561808364870809106191877083124305e-11), SC_(0.99999999999974642107305658099798089191948924657626175924055729848329366944282500974093201947528761), SC_(0.2535789269434190020191080805107534237382407594427015167063305571749902590679805247123899979943720197e-12) }}, 
      {{ SC_(312.0), SC_(126.0), SC_(19470.0), SC_(109.0), SC_(0.4864690010997119064675632495887839545161631576103620525611350772637269829968364134463203768552853405e-184), SC_(1.0), SC_(0.7985114282970473131902359266014727798251512136650067941062627792642215845418852012189609567225406681e-187) }}, 
      {{ SC_(312.0), SC_(126.0), SC_(50688.0), SC_(34.0), SC_(0.4158849986410385131907225937050417500716589001344258610223966307723941511032006941710899694563415349e-45), SC_(0.9999999999999999999999999999999999999999999999938710576593442065757994296808308111503587917232662588), SC_(0.6128942340655793424200570319169188849641208276733741242599516928403898806009797537636158661552008864e-47) }}, 
      {{ SC_(312.0), SC_(126.0), SC_(130605.0), SC_(89.0), SC_(0.4062134352768003899009596691227250179457393597576882309298595815224618988897740251406066308790282851e-207), SC_(1.0), SC_(0.2860949521837947076355578215745589920201751625881003324872642742309931179398408742960185733054249732e-210) }}, 
      {{ SC_(312.0), SC_(126.0), SC_(256574.0), SC_(51.0), SC_(0.1628611659666486110460084695487594647669894311156626606568797846992357991623749863500711638197601797e-114), SC_(1.0), SC_(0.2396475440207661537705739518764693308241379140700173483876787864998788652698362126796559571945534148e-117) }}, 
      {{ SC_(312.0), SC_(126.0), SC_(523360.0), SC_(112.0), SC_(0.1153995283552762104883761729772473279025048133316193067389419171056850219244272653319645090119681603e-352), SC_(1.0), SC_(0.546728499633865762689239748243856386747887762117714892516513666608966370376511867294781887590416752e-357) }}, 
      {{ SC_(312.0), SC_(126.0), SC_(1030167.0), SC_(19.0), SC_(0.1227568810999923535860306005478474341353976206203581008240747500225400574498673585160267509330545543e-44), SC_(0.9999999999999999999999999999999999999999999999981286376886244307299239351542398037205031712563108995), SC_(0.1871362311375569270076064845760196279496828743689100451109387982982806566937010974654586509389227047e-47) }}, 
      {{ SC_(312.0), SC_(126.0), SC_(2063277.0), SC_(28.0), SC_(0.2495931674607168734479416978408367002309792594563181432789858214678681581896434562759387570301294131e-79), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999883828298150492318), SC_(0.1161717018495076823905400792007265255192880913494708327847935140883327317678109025556079713348860824e-82) }}, 
      {{ SC_(312.0), SC_(126.0), SC_(2427690.0), SC_(91.0), SC_(0.6255727272227336234015121801862784800316816939456868977960638842349203943035043621021221761375676915e-329), SC_(1.0), SC_(0.2166872508644459711693580931496202549409777046896519185622003861265715568853929896586404011393121976e-333) }}, 
      {{ SC_(312.0), SC_(244.0), SC_(835.0), SC_(218.0), SC_(0.712073082043167447364553881124676391846720695446629275643788335163626410915438535215755365992303423e-92), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999998369813), SC_(0.1630187115273795112960024886953386785674997681096405214554555749358371051839768637714319721850376641e-93) }}, 
      {{ SC_(312.0), SC_(244.0), SC_(1339.0), SC_(150.0), SC_(0.1234937092483205293097738659875085307155425525212030620982789066274734253002728692556411278829602215e-46), SC_(0.9999999999999999999999999999999999999999999999985100644090072517004823506173490729075526763812165987), SC_(0.1489935590992748299517649382650927092447323618783401315950086091087359832466427689740679870610489152e-47) }}, 
      {{ SC_(312.0), SC_(244.0), SC_(2247.0), SC_(9.0), SC_(0.2238116897570784182235546010591240859313744185346905223241471403257104712265328232676327914291951032e-7), SC_(0.2822097551960062733950098404978885567194126769478184782774142203562419411442388411788375836528947247e-7), SC_(0.9999999717790244803993726604990159502111443280587323052181521722585779643758058855761158821162416347) }}, 
      {{ SC_(312.0), SC_(244.0), SC_(6337.0), SC_(7.0), SC_(0.04045211205694618626207160746577246677968018784631084963199077068495299982564055152161834671803277999), SC_(0.07941830636671239094773325288063459554302689896372897257614503636358295361242975496708963023874399656), SC_(0.9205816936332876090522667471193654044569731010362710274238549636364170463875702450329103697612560034) }}, 
      {{ SC_(312.0), SC_(244.0), SC_(10473.0), SC_(98.0), SC_(0.9822391811546049918975621771610803088549496762942152364820403476918518386866811003700506608320804675e-88), SC_(0.999999999999999999999999999999999999999999999999999999999999999999999999999999999999999996806652632), SC_(0.3193347367965179271619747018387696871768958294290417014128179498377982111558621265236924313949351626e-89) }}, 
      {{ SC_(312.0), SC_(244.0), SC_(19470.0), SC_(196.0), SC_(0.5326371551589551118722139367033397526173192556109407709379556758466306142070168640262401650567978901e-335), SC_(1.0), SC_(0.7888633301733360998392220516844199593393900234483036746564328723090029290367806778870870324396990327e-338) }}, 
      {{ SC_(312.0), SC_(244.0), SC_(50688.0), SC_(217.0), SC_(0.19814189819078444682784098186494915497493005218512629924931484701701979244468618495540739078177347e-488), SC_(1.0), SC_(0.4631311441038592694734699837575388705328835570918721699793132478751891339189963735277426377520383037e-492) }}, 
      {{ SC_(312.0), SC_(244.0), SC_(130605.0), SC_(64.0), SC_(0.610270063708335585978128038887394419371784162676759532042095086935515907324185727658441475068884199e-111), SC_(1.0), SC_(0.3237802202884993038567965820055569044767238131434247056893635323292141004114014413168056571697519609e-113) }}, 
      {{ SC_(312.0), SC_(244.0), SC_(256574.0), SC_(217.0), SC_(0.2082558172959426725073560379079178012803771272228489282146556024604636054696093971867149938066202095e-641), SC_(1.0), SC_(0.9563278125248753979769538567508760361170918775448514823108296415070095820251071961245560731757089108e-646) }}, 
      {{ SC_(312.0), SC_(244.0), SC_(523360.0), SC_(165.0), SC_(0.8851785898487692217369830704282130813523990554444162018646409697618491948831169777438331306304997366e-490), SC_(1.0), SC_(0.1184260093317771271074980410567901966927027989200167014712530213542243407592260352736325893417492174e-493) }}, 
      {{ SC_(312.0), SC_(244.0), SC_(1030167.0), SC_(139.0), SC_(0.122669947834841461197189736343459409163054594948418235125848594219501455129747781877558296744845789e-433), SC_(1.0), SC_(0.1545848158280867094423909005153763476702119438814083242275837077042761958585156654573891106989298615e-437) }}, 
      {{ SC_(312.0), SC_(244.0), SC_(2063277.0), SC_(102.0), SC_(0.8762903736475564298543003602326347896777912547091843956597589833849277354862709251464006683611108591e-327), SC_(1.0), SC_(0.1230030667624561247001571605658507278534578612753114552056759144623028340371168561362369508264650373e-330) }}, 
      {{ SC_(312.0), SC_(244.0), SC_(2427690.0), SC_(147.0), SC_(0.7792518725912498895050441530033409064376126122491501607421300560248725606754270715932406194017984171e-520), SC_(1.0), SC_(0.3471926226461210308389743446410434051718119371830105984688572180055769359327212070530657001454914229e-524) }}, 
      {{ SC_(312.0), SC_(312.0), SC_(835.0), SC_(27.0), SC_(0.5699111152322135550873136385172865987811850486233236501892311978424543752677960110666775448934975778e-44), SC_(0.6182889628837568539274091021688980910990761128564130541834162596345697626857407522929927494281657747e-44), SC_(0.9999999999999999999999999999999999999999999938171103711624314607259089783110190890092388714358694582) }}, 
      {{ SC_(312.0), SC_(312.0), SC_(1339.0), SC_(243.0), SC_(0.5851376545260473622954638389282379582156613686439868782513645924423158357168474524897870825175036348e-135), SC_(1.0), SC_(0.1214409225453343806051540586856911912264970320709781488130544588762990313900576497795801277802794233e-136) }}, 
      {{ SC_(312.0), SC_(312.0), SC_(2247.0), SC_(202.0), SC_(0.1107266102658269861880122949699425500662006061991977514031266356938472617929891503621634755208895435e-122), SC_(1.0), SC_(0.3733353972479250123050380588520076005396774182876711074698100414445030672886353071681644752533200763e-124) }}, 
      {{ SC_(312.0), SC_(312.0), SC_(6337.0), SC_(158.0), SC_(0.7038240445721245912497287312051874245208458733372714615209027583853050542370296188490522981470795601e-136), SC_(1.0), SC_(0.1833466340987639896906951011571705798133962259394401519423062787170211413887865767561560321751550036e-137) }}, 
      {{ SC_(312.0), SC_(312.0), SC_(10473.0), SC_(151.0), SC_(0.1914726978039463043557016525422970207551428119110341571844176947043037106160709177563347925169820335e-157), SC_(1.0), SC_(0.3320441544184310085720368356336625519048891907288512278817898547879448829616443496101506711927901646e-159) }}, 
      {{ SC_(312.0), SC_(312.0), SC_(19470.0), SC_(263.0), SC_(0.7132728222800068924330052326411851704259544569794428821532691510222112569427477842953904461651050559e-488), SC_(1.0), SC_(0.3396102903056499532932182103196850374670147276504128593244785071075330522662943348479387259856848552e-491) }}, 
      {{ SC_(312.0), SC_(312.0), SC_(50688.0), SC_(105.0), SC_(0.1397509946793843037324111936822456132298705049494838101078149443929222639764514962435438201388452824e-155), SC_(1.0), SC_(0.1134989436824805588719564273570233513646291466732092268113411950938546942977969255387589268703413967e-157) }}, 
      {{ SC_(312.0), SC_(312.0), SC_(130605.0), SC_(119.0), SC_(0.2125587117937791253628481431605775373591244775924038210064239525017688451530438538083707945717048985e-234), SC_(1.0), SC_(0.5083347352783550862599503244869745664036407214979445861854779313118335138911521349609455235894160744e-237) }}, 
      {{ SC_(312.0), SC_(312.0), SC_(256574.0), SC_(221.0), SC_(0.1868066073493619458671256481351437110791800818343343291001980924340349409988082752185981483406663347e-610), SC_(1.0), SC_(0.2720520277816885924660839770034000730424568281031610137670627845941919192567135829419550734768864428e-614) }}, 
      {{ SC_(312.0), SC_(312.0), SC_(523360.0), SC_(241.0), SC_(0.383224616309652862729571792200241204845402772861446950295745868189536466783264383368851955703148072e-764), SC_(1.0), SC_(0.152646923264494497337378863533891716051112591372343659231755910032002224872892545768088857025428923e-768) }}, 
      {{ SC_(312.0), SC_(312.0), SC_(1030167.0), SC_(234.0), SC_(0.1480274521947007097922224776097192409706719522060319735368327042311824786889046795090257182700612825e-802), SC_(1.0), SC_(0.3721607714539490719636405291280614492968909182372223515600304083659770678737121511286161505674976629e-807) }}, 
      {{ SC_(312.0), SC_(312.0), SC_(2063277.0), SC_(64.0), SC_(0.9263169883678563307033034335494271399145519532363576337610696858710526387302708994899302177606364615e-180), SC_(1.0), SC_(0.4251130531127156049157536982529105701995714219958024057447714934208278580707807950886465954801331537e-183) }}, 
      {{ SC_(312.0), SC_(312.0), SC_(2427690.0), SC_(91.0), SC_(0.1115798853660292628143749719740709013684888585085151657526194859144760567406673289491331380793838487e-279), SC_(1.0), SC_(0.2441055835135167188640865146051023221013483731047587285571356117020784965306406482084215396834088368e-283) }}, 
      {{ SC_(835.0), SC_(3.0), SC_(1339.0), SC_(0.0), SC_(0.05312930574955717425228459791548352296859447061210010999609044230533836715991174572841326505894661608), SC_(0.05312930574955717425228459791548352296859447061210010999609044230533836715991174572841326505894661608), SC_(0.9468706942504428257477154020845164770314055293878998900039095576946616328400882542715867349410533839) }}, 
      {{ SC_(835.0), SC_(3.0), SC_(2247.0), SC_(3.0), SC_(0.0511998110033848610204471584143538377027895887790784928513413026831910690573295231273690723298134765), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(835.0), SC_(3.0), SC_(6337.0), SC_(2.0), SC_(0.04519067954287270466824554585900082008615858312065015308354218569328111898842249488327900041269823405), SC_(0.9977193847050034555320096607475737499617248212928933977027389651834179587957496705296394397586466964), SC_(0.002280615294996544467990339252426250038275178707106602297261034816582041204250329470360560241353303585) }}, 
      {{ SC_(835.0), SC_(3.0), SC_(10473.0), SC_(3.0), SC_(0.0005051363605363643827012023677249654598779506543337413834289697817618680250809512019306412359523185645), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(835.0), SC_(3.0), SC_(19470.0), SC_(1.0), SC_(0.1178724428678451754909198441760664873145866418638621118371026802604722197607958173001278943643216986), SC_(0.994645787361481564681462541394687987567158656973380167669731119898547617286906980475091190049114597), SC_(0.005354212638518435318537458605312012432841343026619832330268880101452382713093019524908809950885402998) }}, 
      {{ SC_(835.0), SC_(3.0), SC_(50688.0), SC_(0.0), SC_(0.9513887169169219080876385033192060879903605889789986177849894125784599685551162702952534258754390716), SC_(0.9513887169169219080876385033192060879903605889789986177849894125784599685551162702952534258754390716), SC_(0.04861128308307809191236149668079391200963941102100138221501058742154003144488372970474657412456092838) }}, 
      {{ SC_(835.0), SC_(3.0), SC_(130605.0), SC_(0.0), SC_(0.9809422473032495390593039331159755679120346169646776751389036173914448556824394852690205092275252383), SC_(0.9809422473032495390593039331159755679120346169646776751389036173914448556824394852690205092275252383), SC_(0.0190577526967504609406960668840244320879653830353223248610963826085551443175605147309794907724747617) }}, 
      {{ SC_(835.0), SC_(3.0), SC_(256574.0), SC_(3.0), SC_(0.3434509095243792171735094101091399921239916965612364004692535137327880857817996630493345765231731986e-7), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(835.0), SC_(3.0), SC_(523360.0), SC_(3.0), SC_(0.40466760276052791804252360487240614947053236543296537799875402145726561103045208844383519274028348e-8), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(835.0), SC_(3.0), SC_(1030167.0), SC_(2.0), SC_(0.1967014759933714434699575690834203872694575404929686774428436595120551011479484657256595943289960564e-5), SC_(0.999999999469389437348758183590669628307519884755491486288703391099312416565210850166752030848552823), SC_(0.530610562651241816409330371692480115244508513711296608900687583434789149833247969151447177000829639e-9) }}, 
      {{ SC_(835.0), SC_(3.0), SC_(2063277.0), SC_(2.0), SC_(0.4905502998424276173276148341684047617261048714911439272843132698939806489772407103392985401969338381e-6), SC_(0.9999999999339571892981326335101943623364469293329872455480569649267174629832697139392914093075080381), SC_(0.6604281070186736648980563766355307066701275445194303507328253701673028606070859069249196190217486222e-10) }}, 
      {{ SC_(835.0), SC_(3.0), SC_(2427690.0), SC_(3.0), SC_(0.4054323288154975520462757638540907301448855075498516999036429967913634025401884633823244191623369269e-10), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(835.0), SC_(4.0), SC_(1339.0), SC_(3.0), SC_(0.3654378267144529160781888394042175635805474702836706119528243314936009551264941012880359311093747378), SC_(0.8491843889749876854280490504046086245540597741686438744321677362089900820112881486747788220818453463), SC_(0.1508156110250123145719509495953913754459402258313561255678322637910099179887118513252211779181546537) }}, 
      {{ SC_(835.0), SC_(4.0), SC_(2247.0), SC_(1.0), SC_(0.3690415516979539128812535914874056634826043516006605431782554480722115463247577215902081599624107969), SC_(0.5247240506028692012793632652615836814008646903447715328004596176332133633222378502490714226531403816), SC_(0.4752759493971307987206367347384163185991353096552284671995403823667866366777621497509285773468596184) }}, 
      {{ SC_(835.0), SC_(4.0), SC_(6337.0), SC_(3.0), SC_(0.007924183993098192398410386212092976135516282441743306497966664705294847303937677768186802935223161555), SC_(0.9997004307032780036316122573005969939956038919033292243272306313597416706217340899716861404924524868), SC_(0.0002995692967219963683877426994030060043961080966707756727693686402583293782659100283138595075475131958) }}, 
      {{ SC_(835.0), SC_(4.0), SC_(10473.0), SC_(2.0), SC_(0.03227728367335961639230575013145004469288046118605922112106812774041797305005349632302746139842465163), SC_(0.9980998767503950167289107780276523362300063793151594965955141789985759875549390465962906996717529977), SC_(0.001900123249604983271089221972347663769993620684840503404485821001424012445060953403709300328247002325) }}, 
      {{ SC_(835.0), SC_(4.0), SC_(19470.0), SC_(3.0), SC_(0.0003009933862108940372567241775459212300321336175678593636718341601097452962260660754812855770336948061), SC_(0.9999966403743315338900053985173635872489483936789667767776955330557927111874636425144244643198270454), SC_(0.335962566846610999460148263641275105160632103322322230446694420728881253635748557553568017295457578e-5) }}, 
      {{ SC_(835.0), SC_(4.0), SC_(50688.0), SC_(0.0), SC_(0.9357152518162879968071180702468664000457625601381687105964629025754410463149362942531001929543383194), SC_(0.9357152518162879968071180702468664000457625601381687105964629025754410463149362942531001929543383194), SC_(0.06428474818371200319288192975313359995423743986183128940353709742455895368506370574689980704566168057) }}, 
      {{ SC_(835.0), SC_(4.0), SC_(130605.0), SC_(0.0), SC_(0.974670622240094201735874592185883841910851259089870965756650784199667881517250037672258588413958704), SC_(0.974670622240094201735874592185883841910851259089870965756650784199667881517250037672258588413958704), SC_(0.02532937775990579826412540781411615808914874091012903424334921580033211848274996232774141158604129603) }}, 
      {{ SC_(835.0), SC_(4.0), SC_(256574.0), SC_(0.0), SC_(0.9870456475330159171624522499851540534738475310516163224391368302087594234687139294862738058704305237), SC_(0.9870456475330159171624522499851540534738475310516163224391368302087594234687139294862738058704305237), SC_(0.01295435246698408283754775001484594652615246894838367756086316979124057653128607051372619412956947631) }}, 
      {{ SC_(835.0), SC_(4.0), SC_(523360.0), SC_(2.0), SC_(0.1520617432658818401340502151367366819834781162352417834890804572224859624310276616262778540444688784e-4), SC_(0.9999999838325953417022002050514282567526576519523159159143536104477298747569193983492292036150072383), SC_(0.1616740465829779979494857174324734234804768408408564638955227012524308060165077079638499276167064184e-7) }}, 
      {{ SC_(835.0), SC_(4.0), SC_(1030167.0), SC_(0.0), SC_(0.9967617423204828397073775245626662901485300334138018710697641753209707041322942973191000454161566858), SC_(0.9967617423204828397073775245626662901485300334138018710697641753209707041322942973191000454161566858), SC_(0.003238257679517160292622475437333709851469966586198128930235824679029295867705702680899954583843314202) }}, 
      {{ SC_(835.0), SC_(4.0), SC_(2063277.0), SC_(2.0), SC_(0.9807045026082975479832375789130468228448082583923088959897583594553232999859454812535477676548523434e-6), SC_(0.9999999997359086510192892975141496504550966256322449505585776754926273001500358611120441574432936103), SC_(0.2640913489807107024858503495449033743677550494414223245073726998499641388879558425567063897034282364e-9) }}, 
      {{ SC_(835.0), SC_(4.0), SC_(2427690.0), SC_(0.0), SC_(0.9986249153411855327738983225738007857659848447176441911299613153824039133646072578634124889423934886), SC_(0.9986249153411855327738983225738007857659848447176441911299613153824039133646072578634124889423934886), SC_(0.001375084658814467226101677426199214234015155282355808870038684617596086635392742136587511057606511429) }}, 
      {{ SC_(835.0), SC_(15.0), SC_(1339.0), SC_(15.0), SC_(0.000799534597514741452390466354641415098469332749232849523292056098420324262709502500967380286439706832), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(835.0), SC_(15.0), SC_(2247.0), SC_(13.0), SC_(0.0001018577882913664259347909774022021760033368252340771233050284957060917338035553519633093234284614274), SC_(0.999991194430061221169823164496328806315981984366678973885356248752719008328782510805918444651818194), SC_(0.8805569938778830176835503671193684018015633321026114643751247280991671217489194081555348181805970987e-5) }}, 
      {{ SC_(835.0), SC_(15.0), SC_(6337.0), SC_(9.0), SC_(0.249275392350365986740600480231229122852471726021010556507548831765284010592358380925349923134515666e-4), SC_(0.9999975913604000582026854268579595000477627540720090253603341149963295011346225098922660418598725179), SC_(0.2408639599941797314573142040499952237245927990974639665885003670498865377490107733958140127482140629e-5) }}, 
      {{ SC_(835.0), SC_(15.0), SC_(10473.0), SC_(7.0), SC_(0.6657727278204352855840482514649261485220140231961840006392016626894725030481556013372939338812558931e-4), SC_(0.9999938735062075913764779824575427252501617384176233517399188762397946556785178895637923872114411747), SC_(0.6126493792408623522017542457274749838261582376648260081123760205344321482110436207612788558825321708e-5) }}, 
      {{ SC_(835.0), SC_(15.0), SC_(19470.0), SC_(12.0), SC_(0.1433952099372013815208395275135252504359757794446438484585193379717772952796854227951697429023136048e-13), SC_(0.9999999999999998529158569184676435930640165004573144661308688598568453109517800669230653723063955812), SC_(0.1470841430815323564069359834995426855338691311401431546890482199330769346276936044188496212476452236e-15) }}, 
      {{ SC_(835.0), SC_(15.0), SC_(50688.0), SC_(11.0), SC_(0.290397121505837190554012966781045210493676132831122629393041198960714539450698012537321370610597135e-16), SC_(0.999999999999999999839384140483858041402340590315154308053931972537470288907626672985089457187475452), SC_(0.1606158595161419585976594096848456919460680274625297110923733270149105428125245480324440107895859272e-18) }}, 
      {{ SC_(835.0), SC_(15.0), SC_(130605.0), SC_(15.0), SC_(0.1074777276838534407767134084205255589962493549333750077384722659523952882809580333376610951660633138e-32), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(835.0), SC_(15.0), SC_(256574.0), SC_(5.0), SC_(0.1048717406333934008661338100021053736447855776846348482824363960981473382101607983411784873887214538e-8), SC_(0.9999999999943033987862665739555054254570249752462187087961970485649247352778283644541070341124246934), SC_(0.5696601213733426044494574542975024753781291203802951435075264722171635545892965887575306584700945618e-11) }}, 
      {{ SC_(835.0), SC_(15.0), SC_(523360.0), SC_(0.0), SC_(0.9763332231311082353220591296131868359939838018874553257136133194818036926645990871295013333694447331), SC_(0.9763332231311082353220591296131868359939838018874553257136133194818036926645990871295013333694447331), SC_(0.02366677686889176467794087038681316400601619811254467428638668051819630733540091287049866663055526691) }}, 
      {{ SC_(835.0), SC_(15.0), SC_(1030167.0), SC_(11.0), SC_(0.1263589824401388379147086312125552126397271244368744973642947866703750240198301106349799971063645541e-30), SC_(0.9999999999999999999999999999999999662760837372319674373214257113204257701715491001642784963419084439), SC_(0.337239162627680325626785742886795742298284508998357215036580915560860599357689107092674934600972299e-34) }}, 
      {{ SC_(835.0), SC_(15.0), SC_(2063277.0), SC_(10.0), SC_(0.3345733831860729963467741145484352799576583070342021381791940598869386793962788871340258726460089288e-30), SC_(0.999999999999999999999999999999999939158544829133313865583619533541796247611004139639306968147078249), SC_(0.6084145517086668613441638046645820375238899586036069303185292175095167861028762259078228173370911087e-34) }}, 
      {{ SC_(835.0), SC_(15.0), SC_(2427690.0), SC_(15.0), SC_(0.9828487891698869158495976591391209307731131670262277869155468794023565216455803464689447325721568169e-52), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(835.0), SC_(29.0), SC_(1339.0), SC_(8.0), SC_(0.0001035453312189564530752650418946875068707255245890137999841620471367705822413849394270636601214870228), SC_(0.0001300304533181261991096320761572908356105126482392453185149983284650054852059760481589698160708333029), SC_(0.9998699695466818738008903679238427091643894873517607546814850016715349945147940239518410301839291667) }}, 
      {{ SC_(835.0), SC_(29.0), SC_(2247.0), SC_(28.0), SC_(0.1267570467458881233026724830375331685411767075805835667689370395884728609053747025219496029403108461e-10), SC_(0.9999999999997501881978999420838496222188842207995195623644194321129663666334182436291134185187671844), SC_(0.2498118021000579161503777811157792004804376355805678870336333665817563708865814812328155943460751509e-12) }}, 
      {{ SC_(835.0), SC_(29.0), SC_(6337.0), SC_(15.0), SC_(0.6213485790231901659680501293519908938311851982232442193226540767324580777110259071867627829528799382e-6), SC_(0.9999999085085588849594745758624461287046110712178267944413323007597602048346800763589968174914101576), SC_(0.9149144111504052542413755387129538892878217320555866769924023979516531992364100318250858984235559034e-7) }}, 
      {{ SC_(835.0), SC_(29.0), SC_(10473.0), SC_(28.0), SC_(0.3087437707372628749920075004508303706875759591812908129098203174539001286927586000843562726719621298e-29), SC_(0.9999999999999999999999999999999910857087611190209687748190401564171582001631809682332856929468774715), SC_(0.8914291238880979031225180959843582841799836819031766714307053122528547339734820869549252314698050059e-32) }}, 
      {{ SC_(835.0), SC_(29.0), SC_(19470.0), SC_(16.0), SC_(0.4423143835232785649160344885563531880523408878421071442808213055105146178455649784331140012799156956e-14), SC_(0.9999999999999998467803561749301059337175206471944804110184824592948636908906438787440515012541607697), SC_(0.153219643825069894066282479352805519588981517540705136309109356121255948498745839230294382510534565e-15) }}, 
      {{ SC_(835.0), SC_(29.0), SC_(50688.0), SC_(28.0), SC_(0.2136697408546769283650891626006928231039607868391959133106189099120127025002514394057891213270962879e-48), SC_(0.9999999999999999999999999999999999999999999999999998807310867261996606639887101051165542246644064728), SC_(0.119268913273800339336011289894883445775335593527198309264872836690901769075359426784035976744709933e-51) }}, 
      {{ SC_(835.0), SC_(29.0), SC_(130605.0), SC_(23.0), SC_(0.114875011466623343958241994563902513264830389875153820438503512521282939365600972287039420013221501e-44), SC_(0.9999999999999999999999999999999999999999999999982006855835913877848065836557155237005481697431119722), SC_(0.1799314416408612215193416344284476299451830256888027802276256676662239959284221572572172724683749304e-47) }}, 
      {{ SC_(835.0), SC_(29.0), SC_(256574.0), SC_(22.0), SC_(0.2174287477159840597245224391744295947540484348777759942380819743686595462919871974081418431442236668e-48), SC_(0.99999999999999999999999999999999999999999999999999978945944532871201123649560345572867072014740206), SC_(0.2105405546712879887635043965442713292798525979400371818984839537356625660160155906350185827253464341e-51) }}, 
      {{ SC_(835.0), SC_(29.0), SC_(523360.0), SC_(13.0), SC_(0.2615323284059283774157802956938513679623741243369039716443989918698356769478702267281249597415730759e-28), SC_(0.9999999999999999999999999999999529047259479245228382173834767029260642560255190232262508411214900486), SC_(0.4709527405207547716178261652329707393574397448097677374915887850995140060719412697815927214586673228e-31) }}, 
      {{ SC_(835.0), SC_(29.0), SC_(1030167.0), SC_(21.0), SC_(0.4020160537032143647165955103968911452425247682559842264526295069780378227711566140618293936061566057e-58), SC_(0.9999999999999999999999999999999999999999999999999999999999999884365615717317330565035854493380995138), SC_(0.1156343842826826694349641455066190048622061259370053494032386850799608219873798111233507735653361166e-61) }}, 
      {{ SC_(835.0), SC_(29.0), SC_(2063277.0), SC_(19.0), SC_(0.5569875610552389265207458120339346192281515489328523960048930743297756297549997158092701707870631852e-57), SC_(0.9999999999999999999999999999999999999999999999999999999999998897954906859974178411188445733911343306), SC_(0.1102045093140025821588811554266088656694196558930084598378898671728157940926433225292446019464513178e-60) }}, 
      {{ SC_(835.0), SC_(29.0), SC_(2427690.0), SC_(8.0), SC_(0.8070696676065241265172538722890047396629283045361378985013307529028818021565582292117608709823293255e-21), SC_(0.9999999999999999999999993578318273090420897909294708178081656404329240738302864983549499624253093371), SC_(0.6421681726909579102090705291821918343595670759261697135016450500375746906628771797157190327704673777e-24) }}, 
      {{ SC_(835.0), SC_(36.0), SC_(1339.0), SC_(16.0), SC_(0.01182419379075173728812310790204379196026821458909331899622128971151605722993269983830605223817543203), SC_(0.02036514280705625507915913905863992037697070624999425975544627487430868948570163948080116288757768998), SC_(0.97963485719294374492084086094136007962302929375000574024455372512569131051429836051919883711242231) }}, 
      {{ SC_(835.0), SC_(36.0), SC_(2247.0), SC_(0.0), SC_(0.4606100302087312331950692537784888019403234832255262285923469839463105305267396787454097770209182748e-7), SC_(0.4606100302087312331950692537784888019403234832255262285923469839463105305267396787454097770209182748e-7), SC_(0.9999999539389969791268766804930746221511198059676516774473771407653016053689469473260321254590222979) }}, 
      {{ SC_(835.0), SC_(36.0), SC_(6337.0), SC_(2.0), SC_(0.08932318263230832557895752951379699733021301224513829642517126342202871698285710350333592197412900123), SC_(0.1288742451546976038532618086063336079578895125897239874612941101404914307014079084385821764339489969), SC_(0.8711257548453023961467381913936663920421104874102760125387058898595085692985920915614178235660510031) }}, 
      {{ SC_(835.0), SC_(36.0), SC_(10473.0), SC_(26.0), SC_(0.2186012800633610970811977614462634570587600468933256249885234519161998129158939554234036725715272435e-20), SC_(0.9999999999999999999999300991422034652931493225300449507712150708136429944336905630244010955697636791), SC_(0.6990085779653470685067746995504922878492918635700556630943697559890443023632090737968387720049793346e-22) }}, 
      {{ SC_(835.0), SC_(36.0), SC_(19470.0), SC_(27.0), SC_(0.5056085003405158452209670356668675108140204829162560738119681007701379718733902811622905012155638812e-29), SC_(0.9999999999999999999999999999999286524725157695853336830731907826589147792604339436664563339853628704), SC_(0.7134752748423041466631692680921734108522073956605633354366601463712959012092881284224905479780701787e-31) }}, 
      {{ SC_(835.0), SC_(36.0), SC_(50688.0), SC_(15.0), SC_(0.6231019027843611498480122309617670606402335875023701812331464027068649165314473678956220621500984412e-17), SC_(0.9999999999999999998627801303385218379245305034958110104755366363971637040976737633871078482284741828), SC_(0.1372198696614781620754694965041889895244633636028362959023262366128921517715258171542631625618739055e-18) }}, 
      {{ SC_(835.0), SC_(36.0), SC_(130605.0), SC_(29.0), SC_(0.113908289929799918964745237148085081620006540228454861089615006913997694928614092488059011633026751e-56), SC_(0.9999999999999999999999999999999999999999999999999999999999983471456846985015949172513347658002298872), SC_(0.1652854315301498405082748665234199770112798837758597969456099008301449065020787537027678452148376848e-59) }}, 
      {{ SC_(835.0), SC_(36.0), SC_(256574.0), SC_(32.0), SC_(0.8006183163997088792578023853867418790840233823070938074928105405801620152276982744125127994226446688e-75), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999996951996731945057928786), SC_(0.3048003268054942071213833603792198690754526983662859314272966689165966017974390315445691866836581696e-78) }}, 
      {{ SC_(835.0), SC_(36.0), SC_(523360.0), SC_(3.0), SC_(0.2741537299263386078261306702863050922866178923173357312801959073866430529750223780056060595208340138e-4), SC_(0.9999996361474699518339347505836074416934713651104586387064511718907378829146763291210956890014272057), SC_(0.363852530048166065249416392558306528634889541361293548828109262117085323670878904310998572794342835e-6) }}, 
      {{ SC_(835.0), SC_(36.0), SC_(1030167.0), SC_(13.0), SC_(0.1346392676146256818272459152708618133022904714530614003946754597302233778066939662739387205812630405e-30), SC_(0.999999999999999999999999999999999823149839882823079941463789218237882699573808430067785825666842336), SC_(0.1768501601171769200585362107817621173004261915699322141743331576640104077005841050057733738385281708e-33) }}, 
      {{ SC_(835.0), SC_(36.0), SC_(2063277.0), SC_(36.0), SC_(0.3344707778033236842944086713155333562867858645229123255856281101106181376732100419738563052008006847e-122), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(835.0), SC_(36.0), SC_(2427690.0), SC_(25.0), SC_(0.1076320348783196077110174450020296289614773449419515977683009522392066963365844005192847878373291308e-77), SC_(0.999999999999999999999999999999999999999999999999999999999999999999999999999999999847995134203291829), SC_(0.1520048657967081710340199525872208050501341770696993586382549109188613857963971149976329403991211799e-81) }}, 
      {{ SC_(835.0), SC_(126.0), SC_(1339.0), SC_(66.0), SC_(0.004214954609239854688850965211187536679911395560870595658089838405361044752712484018975300618962086722), SC_(0.01043595713379508128568710166442494198477360711522535690068533310874780088298111696102460830300572066), SC_(0.9895640428662049187143128983355750580152263928847746430993146668912521991170188830389753916969942793) }}, 
      {{ SC_(835.0), SC_(126.0), SC_(2247.0), SC_(121.0), SC_(0.8612859840889384690162955550272700011445163326308796287542353494525835104772462813221275367462931837e-47), SC_(0.9999999999999999999999999999999999999999999999998180180022847951976510061165540610927041113771239769), SC_(0.181981997715204802348993883445938907295888622876023091103604653812000013166211239706228114087890408e-48) }}, 
      {{ SC_(835.0), SC_(126.0), SC_(6337.0), SC_(123.0), SC_(0.3152476009168752062942492611201943851881263169683876671414419350194908328170956488423898065448209359e-106), SC_(1.0), SC_(0.98938829945621534553476117314392603863334598389226828578872640565924181519637076472617578294727563e-109) }}, 
      {{ SC_(835.0), SC_(126.0), SC_(10473.0), SC_(58.0), SC_(0.6226984351180500188355697349464978256535444902687015133159668021430575505916245892157991010535426553e-30), SC_(0.9999999999999999999999999999999359571091740272224013457192008700575546363330971839575668377358852788), SC_(0.6404289082597277759865428079912994244536366690281604243316226411472115836901262356100924649862020854e-31) }}, 
      {{ SC_(835.0), SC_(126.0), SC_(19470.0), SC_(71.0), SC_(0.1001081680162206673917556770580483445017345659956005501901678812363407381143277353718916251689171282e-62), SC_(0.999999999999999999999999999999999999999999999999999999999999999967573080326747487087205737508342577), SC_(0.3242691967325251291279426249165742302010921779127068484509171157326967844865131800997312959217517343e-64) }}, 
      {{ SC_(835.0), SC_(126.0), SC_(50688.0), SC_(99.0), SC_(0.1176593099829095429818065620118121186076716881852469272550411116483574936585918011515853824822593584e-151), SC_(1.0), SC_(0.471037058758102874468722990673323548405877870000864623170228240568305152659386180672678184553286629e-154) }}, 
      {{ SC_(835.0), SC_(126.0), SC_(130605.0), SC_(2.0), SC_(0.1453606084504887157477493663465659060753690142228632234368063325602288218449083768365729698098544248), SC_(0.9524145746140709560632124684206973125144358988824435620847042702914279642771595521817459700535594488), SC_(0.04758542538592904393678753157930268748556410111755643791529572970857203572284044781825402994644055125) }}, 
      {{ SC_(835.0), SC_(126.0), SC_(256574.0), SC_(12.0), SC_(0.1760239566554823186633411376423777087230171609481960517871443712315038635647198017894577857153845058e-13), SC_(0.9999999999999994898174078589742626013688133411218035039771546657453041391421187130535478641328201376), SC_(0.5101825921410257373986311866588781964960228453342546958608578812869464521358671798624032048905168957e-15) }}, 
      {{ SC_(835.0), SC_(126.0), SC_(523360.0), SC_(119.0), SC_(0.1712866597681840432158043780995967606732456169162282456087788104107369719857329552350578185337283842e-325), SC_(1.0), SC_(0.1369243659162173035674368610458815963034520932065195210025223689351539047488989787577419555799268651e-329) }}, 
      {{ SC_(835.0), SC_(126.0), SC_(1030167.0), SC_(9.0), SC_(0.2168081183964470175231510823281021153298524970129830014451132096717477484759775759992855606781508464e-14), SC_(0.9999999999999999794685925716698003896832368652209158538288597457067638360574346502116691374796470776), SC_(0.205314074283301996103167631347790841461711402542932361639425653497883308625203529224345551699754821e-16) }}, 
      {{ SC_(835.0), SC_(126.0), SC_(2063277.0), SC_(19.0), SC_(0.4254778576994903186933835968542481708752715593693604489296985543342645521683995091756121208633881318e-42), SC_(0.999999999999999999999999999999999999999999999097538774090879000869360583831722192955236314181951175), SC_(0.9024612259091209991306394161682778070447636858180488250221758024772732464042113625675596784500791667e-45) }}, 
      {{ SC_(835.0), SC_(126.0), SC_(2427690.0), SC_(68.0), SC_(0.7335080567670418738450007053197662386393283034958420403770787008746827549033217204618289088458630467e-200), SC_(1.0), SC_(0.1949203416335661263353337338122797844168658645972600056069302772565424141096089410011221538385836247e-203) }}, 
      {{ SC_(835.0), SC_(244.0), SC_(1339.0), SC_(211.0), SC_(0.5487055814738094255479306079150557158159552950762515042446995244730654191798111147356965607554373703e-19), SC_(0.9999999999999999999859554374077453395808363793523947459155674881105798648397242211878965323950992525), SC_(0.1404456259225466041916362064760525408443251188942013516027577881210346760490074752093330317357039028e-19) }}, 
      {{ SC_(835.0), SC_(244.0), SC_(2247.0), SC_(19.0), SC_(0.114324982007840208855927668485150974172932448671383312447460448026721564710227068741850338774461831e-27), SC_(0.1300870506397966599119239260883510687098372716980422097621761397229769971694566198053100289651143283e-27), SC_(0.9999999999999999999999999998699129493602033400880760739116489312901627283019577902378238602770230028) }}, 
      {{ SC_(835.0), SC_(244.0), SC_(6337.0), SC_(118.0), SC_(0.1470744751393422878271461804868633160270460991435256545241759027011292725937034151885528503001800556e-41), SC_(0.9999999999999999999999999999999999999999997590213145617635360608885540322101752550122827924931197833), SC_(0.2409786854382364639391114459677898247449877172075068802166731033250971588062453626430933684846694864e-42) }}, 
      {{ SC_(835.0), SC_(244.0), SC_(10473.0), SC_(199.0), SC_(0.1971929670122994359103903674441583739231223994728407593874686150433754211707956420803105690545114814e-180), SC_(1.0), SC_(0.2984464022658656897233973448357416143649157771084097230626451123993448885695264894361464745486403404e-182) }}, 
      {{ SC_(835.0), SC_(244.0), SC_(19470.0), SC_(108.0), SC_(0.295653125593473891405127062952476017582131235442519672368124272843778989115433200788130688658302032e-81), SC_(0.999999999999999999999999999999999999999999999999999999999999999999999999999999999984770917895043537), SC_(0.1522908210495646295951128324857047675700759503488783614124027005254494752746254890783707837293332776e-82) }}, 
      {{ SC_(835.0), SC_(244.0), SC_(50688.0), SC_(168.0), SC_(0.5384589658803347720043884589729245331957057814186124399612188873789791306105884459028473205862556426e-243), SC_(1.0), SC_(0.3263913347645237791628026777932406944548459698488926597165096246025319984347378282532162726432941935e-245) }}, 
      {{ SC_(835.0), SC_(244.0), SC_(130605.0), SC_(189.0), SC_(0.3415889799761332397477186281840883332930878595673170605216206296615468885711799222930242600023182248e-369), SC_(1.0), SC_(0.4931316175189690383699989715947765655500671614281311690911772158189800775669769483172953647285998775e-372) }}, 
      {{ SC_(835.0), SC_(244.0), SC_(256574.0), SC_(215.0), SC_(0.3798723552340198003769386281623095135154686443535236199332710759637116904531361368117428541356831219e-510), SC_(1.0), SC_(0.1236972045970510146069612110949421464473134415218775461544527830415255437870107559390443781680526522e-513) }}, 
      {{ SC_(835.0), SC_(244.0), SC_(523360.0), SC_(123.0), SC_(0.864166361249043979774714159188405541590936437203731255661369750953257839011137016507633640216130039e-276), SC_(1.0), SC_(0.1150804376270644833987388795427227625183129210614240086618808120879492588924911982580922640585230346e-278) }}, 
      {{ SC_(835.0), SC_(244.0), SC_(1030167.0), SC_(221.0), SC_(0.8807175539067009527083046383828250118407172578047286285461500454941880904187189828937324525312509036e-665), SC_(1.0), SC_(0.5443261640853099400354914120229395420537924961249103612570870336940183136993575705858674168862997041e-669) }}, 
      {{ SC_(835.0), SC_(244.0), SC_(2063277.0), SC_(240.0), SC_(0.1922420351121087833643056894641459103821963475146710646229342742258240386987945344946842020592889518e-822), SC_(1.0), SC_(0.9205104178226544291116639155677005167520612612518281049014829061672905623637883237322812576100618643e-828) }}, 
      {{ SC_(835.0), SC_(244.0), SC_(2427690.0), SC_(28.0), SC_(0.2851419355096664689947804705048360840478636501170922683933932733250126535718708556924447119115746891e-60), SC_(0.9999999999999999999999999999999999999999999999999999999999999992920216868617045357607126440323908893), SC_(0.7079783131382954642392873559676091106824087645404963783923780075870074991851330413137313796208179795e-63) }}, 
      {{ SC_(835.0), SC_(312.0), SC_(1339.0), SC_(73.0), SC_(0.1235833362640954023020212008908456686382189357936352290756017618663265253950303210112264516469960533e-57), SC_(0.1381373560155829689786159674939367281627511111057673648204627846612002476867447543857569697342783058e-57), SC_(0.9999999999999999999999999999999999999999999999999999999998618626439844170310213840325060632718372489) }}, 
      {{ SC_(835.0), SC_(312.0), SC_(2247.0), SC_(273.0), SC_(0.2643814239596106174600554377304848699674192423295417952179619634620929482845169496401722207516006646e-87), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999836902692773), SC_(0.1630973072265152714809000031077429712371288392898817050951227547795764570882298161902506017818096384e-88) }}, 
      {{ SC_(835.0), SC_(312.0), SC_(6337.0), SC_(29.0), SC_(0.007437896198288289080976325211608663871507898639836375528277813551681659037667557180825183969771673388), SC_(0.0197302403550836830178389136133484205861014736063132100607901876800394043737090362415665587564618794), SC_(0.9802697596449163169821610863866515794138985263936867899392098123199605956262909637584334412435381206) }}, 
      {{ SC_(835.0), SC_(312.0), SC_(10473.0), SC_(297.0), SC_(0.1696876567590944804040597969332067458805031042032109693935553098646753112069367359567389480876335861e-325), SC_(1.0), SC_(0.4787267468780574354703600619601540564325846009085407942547360646139762995042661025492076904603503189e-328) }}, 
      {{ SC_(835.0), SC_(312.0), SC_(19470.0), SC_(299.0), SC_(0.7178554465700651319247837256106287042236097987923564888620171206499766091814886744996771012091091428e-412), SC_(1.0), SC_(0.8963380831912548774409496470160430800854405381219562799449299912125376450200998046723383861263567915e-415) }}, 
      {{ SC_(835.0), SC_(312.0), SC_(50688.0), SC_(113.0), SC_(0.1712889803322646449824572843852429230932473304431442250660294671406812149340796565965144846852967786e-118), SC_(1.0), SC_(0.4459053970265939192495029850225400088579625340427807905002091244849745403426333672812038511931955567e-120) }}, 
      {{ SC_(835.0), SC_(312.0), SC_(130605.0), SC_(225.0), SC_(0.4199702490254779689656841859934049453119763120189087264450536435665010084331441192574776125238285782e-429), SC_(1.0), SC_(0.7618089902306077814837597594064396795535324271230452411915008649907798050945136778627905460818176535e-432) }}, 
      {{ SC_(835.0), SC_(312.0), SC_(256574.0), SC_(151.0), SC_(0.2769498952459873325078680691218754963578875676235426185712263139641637786457069768557424665261338934e-289), SC_(1.0), SC_(0.7872809924474871058848408852012090597565130764538747007349557571447614359650366611938302028578546558e-292) }}, 
      {{ SC_(835.0), SC_(312.0), SC_(523360.0), SC_(180.0), SC_(0.2390221278236537113034364402037645857207308185474180688514511075547995006769905389940988756155846437e-421), SC_(1.0), SC_(0.2187600951263409415083490320342999843797328138294979697898983809487880471285535404559142434101280413e-424) }}, 
      {{ SC_(835.0), SC_(312.0), SC_(1030167.0), SC_(4.0), SC_(0.0001294359671819074698199567330994323198685107322053247977616161699341052091378929009874313565916033258), SC_(0.999993285724297157823692992954198371032732883197659311022004767268962312020324034531153977824110154), SC_(0.6714275702842176307007045801628967267116802340688977995232731037687979675965468846022175889845987388e-5) }}, 
      {{ SC_(835.0), SC_(312.0), SC_(2063277.0), SC_(202.0), SC_(0.5218861105956630693330058572715117591883930129953463766814003364584819624722841745051568006126255311e-610), SC_(1.0), SC_(0.8681373110856984385988873814413077903430546612689615558448166990200688087520294345381182962148188916e-614) }}, 
      {{ SC_(835.0), SC_(312.0), SC_(2427690.0), SC_(89.0), SC_(0.2057134808915777687786927860787383795010108397639412776230821652197814654157618606511309851109290623e-230), SC_(1.0), SC_(0.1568141417394917087480289776344836313297272071414390555860673629359992435901887496002525911821339699e-233) }}, 
      {{ SC_(835.0), SC_(835.0), SC_(1339.0), SC_(806.0), SC_(0.1438536310862187137558589488438665401365603723771832105141282798369342021068628464953133460229643562e-282), SC_(1.0), SC_(0.3155880366318474726637180109726951241859974585201354302037408640343050114072926303829283629974945117e-285) }}, 
      {{ SC_(835.0), SC_(835.0), SC_(2247.0), SC_(104.0), SC_(0.6499531186119452089296076987337774211134624893096613294296466682672496787356059526708538945073477175e-84), SC_(0.7487095673823831294249397360847160452626056827860391382282391255232459083109166629377106607694696233e-84), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999992512904326176169) }}, 
      {{ SC_(835.0), SC_(835.0), SC_(6337.0), SC_(322.0), SC_(0.261498439512657689323120298995027004596914023369998130948181509044425431796847712723086516901943369e-91), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999949055495), SC_(0.5094450472165381283063375182293919234967426523038439399572598922377096450596141136192900285191284542e-92) }}, 
      {{ SC_(835.0), SC_(835.0), SC_(10473.0), SC_(416.0), SC_(0.3529066805256148616357513648579674510325906935595262148769221458678779190239856169447305643306839333e-266), SC_(1.0), SC_(0.1687956173007374774176788107288794351155022807191587778554734457346908539618756728596505876890410185e-267) }}, 
      {{ SC_(835.0), SC_(835.0), SC_(19470.0), SC_(456.0), SC_(0.5365190197011561445600301592131673893164666849114234445060550879783745079886588617587651028127125717e-444), SC_(1.0), SC_(0.9397273076927248081591488685091944383646610081262209953417568048943240798898816640105642138399860498e-446) }}, 
      {{ SC_(835.0), SC_(835.0), SC_(50688.0), SC_(71.0), SC_(0.1502747780730370188723288920198851797687097434224107304271396869854459915353833607257640086056610219e-28), SC_(0.9999999999999999999999999999970387340250958027263227918098875160286309658710994532730934271014577623), SC_(0.2961265974904197273677208190112483971369034128900546726906572898542237742538987823326563138010486905e-29) }}, 
      {{ SC_(835.0), SC_(835.0), SC_(130605.0), SC_(440.0), SC_(0.1194245729748551619706471412029900825878569518691341978409088129474773798745569031996877576598417267e-778), SC_(1.0), SC_(0.3274734643476268014995009851243513908908603285759448931456457347990262412093518974929151503516770332e-781) }}, 
      {{ SC_(835.0), SC_(835.0), SC_(256574.0), SC_(572.0), SC_(0.3061557112533727437599326122867655114732496154306399584631435388795715331264725530202070075200216251e-1314), SC_(1.0), SC_(0.1447274039681101124186583243847424551288119451473283513919330225406415346274720015679598762922396892e-1317) }}, 
      {{ SC_(835.0), SC_(835.0), SC_(523360.0), SC_(416.0), SC_(0.122210574120061134174002760451707872827964579242974991242658745461364189558019885951600611322049374e-968), SC_(1.0), SC_(0.9862547163712101300774439612552741192531774106064561911362763743265679536312607972242225411757133375e-972) }}, 
      {{ SC_(835.0), SC_(835.0), SC_(1030167.0), SC_(529.0), SC_(0.2350928435195370953505640987135406460645638400356500424030711948556410253449247021332951842253807861e-1494), SC_(1.0), SC_(0.4036951812738728731162365542535467965498579346690623850515382340329436279841286043118335104396117347e-1498) }}, 
      {{ SC_(835.0), SC_(835.0), SC_(2063277.0), SC_(635.0), SC_(0.2376113893802100327951763840698086768305153684681663003560666294618755591801764831249795783919662778e-2107), SC_(1.0), SC_(0.7246751743194427210205153027246512478808771823127826994234802439446436250266697164889940676403803585e-2112) }}, 
      {{ SC_(835.0), SC_(835.0), SC_(2427690.0), SC_(571.0), SC_(0.2409380141861532372457004608235233768916614357086659174863998044282401968664102990705341349599296789e-1868), SC_(1.0), SC_(0.1209879157006345118431594112175686046556265543446018374671235383416871994115366415047825112599874058e-1872) }}, 
      {{ SC_(1339.0), SC_(3.0), SC_(2247.0), SC_(0.0), SC_(0.06585551700529862068105607689257235618466001110192536435823351787195323101649522758365795590777833885), SC_(0.06585551700529862068105607689257235618466001110192536435823351787195323101649522758365795590777833885), SC_(0.9341444829947013793189439231074276438153399888980746356417664821280467689835047724163420440922216611) }}, 
      {{ SC_(1339.0), SC_(3.0), SC_(6337.0), SC_(3.0), SC_(0.009417217538626095056495484744207277919223111756309314803364918578820620412708273443741801549189014021), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(1339.0), SC_(3.0), SC_(10473.0), SC_(3.0), SC_(0.002085831400095040047905155027123975277677040460349811634145772212949854944136524928561891977810608377), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(1339.0), SC_(3.0), SC_(19470.0), SC_(3.0), SC_(0.0003245915154130988134755124116049045636834151488369789966125962612490696011575285964546988996756291341), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(1339.0), SC_(3.0), SC_(50688.0), SC_(3.0), SC_(0.1839409119808065129245960910567392932751346375666661843015272171910951410968802518322989735284859467e-4), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(1339.0), SC_(3.0), SC_(130605.0), SC_(2.0), SC_(0.0003118694401590785127458703599705131275637244683226265180590281212852637122567826028627078186716851225), SC_(0.9999989247767098007520112501130194570986659222079171441016852977050014200104879219364390863087375151), SC_(0.1075223290199247988749886980542901334077792082855898314702294998579989512078063560913691262484931564e-5) }}, 
      {{ SC_(1339.0), SC_(3.0), SC_(256574.0), SC_(0.0), SC_(0.9844252021889663405339281771289994264695537503707750499571583765291345683675709876618621256066239542), SC_(0.9844252021889663405339281771289994264695537503707750499571583765291345683675709876618621256066239542), SC_(0.01557479781103365946607182287100057353044624962922495004284162347086543163242901233813787439337604583) }}, 
      {{ SC_(1339.0), SC_(3.0), SC_(523360.0), SC_(3.0), SC_(0.1670971362154262498958674879095233080534012386550042274058266116045072059419132204085637993879877063e-7), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(1339.0), SC_(3.0), SC_(1030167.0), SC_(1.0), SC_(0.003889245193316463471607022700063471098594902240854824903770228034186722515108788587659956643805338539), SC_(0.9999949398059636747336350875284181428643402079042120781888856498664592888323431635196229803206899393), SC_(0.5060194036325266364912471581857135659792095787921811114350133540711167656836480377019679310060696547e-5) }}, 
      {{ SC_(1339.0), SC_(3.0), SC_(2063277.0), SC_(1.0), SC_(0.001944378662337361316557872623051245495438982028087519943616154547563570815282883602408415064023163811), SC_(0.9999987380114161374226254964427656920683722275014926786342109429928505213419736307129067491876363529), SC_(0.1261988583862577374503557234307931627772498507321365789057007149478658026369287093250812363647119951e-5) }}, 
      {{ SC_(1339.0), SC_(3.0), SC_(2427690.0), SC_(1.0), SC_(0.001652835967108027062227618041722122034950559370424902851636920165826827788344086405509850160477141221), SC_(0.999999088383487005008186992678124680506510125681376510809413775887360848267921319395483385201199222), SC_(0.9116165129949918130073218753194934898743186234891905862241126391517320786806045166147988007779847949e-6) }}, 
      {{ SC_(1339.0), SC_(4.0), SC_(2247.0), SC_(1.0), SC_(0.1571845584137163156718967681981361585227446610792835345377445283966940754564832615588556202504727196), SC_(0.1837439358155858574349786530411744750767185069113880152615419141694737876088576737527996710956328786), SC_(0.8162560641844141425650213469588255249232814930886119847384580858305262123911423262472003289043671214) }}, 
      {{ SC_(1339.0), SC_(4.0), SC_(6337.0), SC_(0.0), SC_(0.3868476558439932428009742513295004466415676444200899345440638149097697220562656196010061985464005449), SC_(0.3868476558439932428009742513295004466415676444200899345440638149097697220562656196010061985464005449), SC_(0.6131523441560067571990257486704995533584323555799100654559361850902302779437343803989938014535994551) }}, 
      {{ SC_(1339.0), SC_(4.0), SC_(10473.0), SC_(2.0), SC_(0.07458076390899487108981850501383986882984270293782629033721888838460820603825139452356634155677904863), SC_(0.9924551473940401760559442186067584344110616163978636039915598199380289487636734983672878726854208825), SC_(0.00754485260595982394405578139324156558893838360213639600844018006197105123632650163271212731457911752) }}, 
      {{ SC_(1339.0), SC_(4.0), SC_(19470.0), SC_(0.0), SC_(0.7519922077537151871177034061348177640243521572515434504313025958443333563924256325072242520241304601), SC_(0.7519922077537151871177034061348177640243521572515434504313025958443333563924256325072242520241304601), SC_(0.2480077922462848128822965938651822359756478427484565495686974041556666436075743674927757479758695399) }}, 
      {{ SC_(1339.0), SC_(4.0), SC_(50688.0), SC_(0.0), SC_(0.8984448203536055907099747679316164955141879203997522071064260507567467679116698761145087873183883193), SC_(0.8984448203536055907099747679316164955141879203997522071064260507567467679116698761145087873183883193), SC_(0.1015551796463944092900252320683835044858120796002477928935739492432532320883301238854912126816116807) }}, 
      {{ SC_(1339.0), SC_(4.0), SC_(130605.0), SC_(1.0), SC_(0.0397616279694256938323642881268406649468809470597372229477372872881866219002154403198989531249646632), SC_(0.9993783785691033379423166735151537480366255063918531023154305277872756458379700354774097243210807352), SC_(0.0006216214308966620576833264848462519633744936081468976845694722127243541620299645225902756789192647673) }}, 
      {{ SC_(1339.0), SC_(4.0), SC_(256574.0), SC_(2.0), SC_(0.0001615943873123099176877328051185382290140568528614338283089973628290227782907931060639030753008639925), SC_(0.9999994349383424760200737227326306208293393964337943090099779584824377413145950024498351668471365532), SC_(0.5650616575239799262772673693791706606035662056909900220415175622586854049975501648331528634468435437e-6) }}, 
      {{ SC_(1339.0), SC_(4.0), SC_(523360.0), SC_(3.0), SC_(0.6666823154696547587737673664899276539214690393282135276273519881564333414950035461539588698485350356e-7), SC_(0.9999999999573442651987439797574353712958605426966021177049154501011385436957062653651668697120521623), SC_(0.4265573480125602024256462870413945730339788229508454989886145630429373463483313028794783773871783771e-10) }}, 
      {{ SC_(1339.0), SC_(4.0), SC_(1030167.0), SC_(4.0), SC_(0.2841492737459820100929205241644150177094261566905256309365745542400584763428550898227345596651010811e-11), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(1339.0), SC_(4.0), SC_(2063277.0), SC_(4.0), SC_(0.1765816907497578239920211748714387064235015036765126491571449614909731023984797029159825733655344565e-12), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(1339.0), SC_(4.0), SC_(2427690.0), SC_(0.0), SC_(0.9977956107430555505636528253972963050600640076745662896679580021247571524620653903071285107406919644), SC_(0.9977956107430555505636528253972963050600640076745662896679580021247571524620653903071285107406919644), SC_(0.002204389256944449436347174602703694939935992325433710332041997875242847537934609692871489259308035597) }}, 
      {{ SC_(1339.0), SC_(15.0), SC_(2247.0), SC_(8.0), SC_(0.1805173918106110969760996837116845351358209722989941507461372433355662433156928561188680349656759144), SC_(0.4026772434127623331313209237396664026386692643235207435924282156243575357968921568765183615937572989), SC_(0.5973227565872376668686790762603335973613307356764792564075717843756424642031078431234816384062427011) }}, 
      {{ SC_(1339.0), SC_(15.0), SC_(6337.0), SC_(3.0), SC_(0.2489665482851080759214279658602299089068280357610906811502805169843489702904591877498343709056663483), SC_(0.6055622819872241736577446357875694926072832853259117998495629684563371351594429731100823364663751356), SC_(0.3944377180127758263422553642124305073927167146740882001504370315436628648405570268899176635336248644) }}, 
      {{ SC_(1339.0), SC_(15.0), SC_(10473.0), SC_(14.0), SC_(0.3849063625275312331696963184495414384943829475767369686370448055604071159274830801134680131367763857e-11), SC_(0.9999999999999627763717722079494963982467012887814024481858594864255569604870179155223265517056309507), SC_(0.3722362822779205050360175329871121859755181414051357444303951298208447767344829436904934803344490994e-13) }}, 
      {{ SC_(1339.0), SC_(15.0), SC_(19470.0), SC_(7.0), SC_(0.2616658552243799351704320595941909744755925972389579378862278438519832547771093480627556884796601346e-4), SC_(0.9999979620817167760404079573017361417152173696091999740166540179443391063090573045472489360904637083), SC_(0.2037918283223959592042698263858284782630390800025983345982055660893690942695452751063909536291722295e-5) }}, 
      {{ SC_(1339.0), SC_(15.0), SC_(50688.0), SC_(1.0), SC_(0.2724521907729808821347863825768355038763961948094712795081915473369190765908302109084808418126762947), SC_(0.9416794166522446023299412834694508677669616053608910243195746684654678763721898551788269872360462226), SC_(0.05832058334775539767005871653054913223303839463910897568042533153453212362781014482117301276395377744) }}, 
      {{ SC_(1339.0), SC_(15.0), SC_(130605.0), SC_(13.0), SC_(0.1342382778979103406840198337816422640350912939381398576149121957778158028120291597983571959893748392e-23), SC_(0.9999999999999999999999999980314902171779944525588515984725276192236820290466780333205061747987695595), SC_(0.1968509782822005547441148401527472380776317970953321966679493825201230440519162000829492528603524723e-26) }}, 
      {{ SC_(1339.0), SC_(15.0), SC_(256574.0), SC_(0.0), SC_(0.9245125656644497767828143239158822865121382341519000340725196476091900611502893168509498917838636977), SC_(0.9245125656644497767828143239158822865121382341519000340725196476091900611502893168509498917838636977), SC_(0.07548743433555022321718567608411771348786176584809996592748035239080993884971068314905010821613630234) }}, 
      {{ SC_(1339.0), SC_(15.0), SC_(523360.0), SC_(8.0), SC_(0.1136507106472067776976820403189878929543445163421885291771078514783307717121796424070741229115430254e-16), SC_(0.9999999999999999999774271226885578709831352307488329469571652238221533901558863445154034143599041987), SC_(0.2257287731144212901686476925116705304283477617784660984411365548459658564009580125744768294121144717e-19) }}, 
      {{ SC_(1339.0), SC_(15.0), SC_(1030167.0), SC_(15.0), SC_(0.4720183286271297002851000957435621101149286252032616075058553966186748639278391924690271536546892488e-43), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(1339.0), SC_(15.0), SC_(2063277.0), SC_(8.0), SC_(0.1973687619823740844085769811059032593770445783384889128737372146037956390917425569774917958683423952e-21), SC_(0.9999999999999999999999999008698508210278867065753001144952309424631080558508522214688712544975538886), SC_(0.9913014917897211329342469988550476905753689194414914777853112874550244611144502720227810536793479436e-25) }}, 
      {{ SC_(1339.0), SC_(15.0), SC_(2427690.0), SC_(7.0), SC_(0.9793427157488641788158912172171855476552717171747104363916306108111849256718498176952442446664490561e-19), SC_(0.9999999999999999999999462136757738895606509787672351149850175039670838534103570467323795028055170284), SC_(0.5378632422611043934902123276488501498249603291614658964295326762049719448297158560801883794970417952e-22) }}, 
      {{ SC_(1339.0), SC_(29.0), SC_(2247.0), SC_(24.0), SC_(0.004957842082555695477601506316969263565707018469523837283973155160010707536877849921795297468781337402), SC_(0.9981779196396374252295937650217999047625405998540040929292792905084556349031516362887077901206118368), SC_(0.00182208036036257477040623497820009523745940014599590707072070949154436509684836371129220987938816324) }}, 
      {{ SC_(1339.0), SC_(29.0), SC_(6337.0), SC_(14.0), SC_(0.0007603156711416783982710556182454990433546019859977970044096593385369602440196209270917311922851173704), SC_(0.9997393822068511055077172091206354041863680582122781872210935798968729726319887928966765918906909293), SC_(0.0002606177931488944922827908793645958136319417877218127789064201031270273680112071033234081093090706691) }}, 
      {{ SC_(1339.0), SC_(29.0), SC_(10473.0), SC_(5.0), SC_(0.1523445619778533269329921717408509230023758648588780245695990087205645516056272329319811216806986623), SC_(0.8425160385385843486345979566780808483743623464360891031461330687708834692391341846015905992637699715), SC_(0.1574839614614156513654020433219191516256376535639108968538669312291165307608658153984094007362300285) }}, 
      {{ SC_(1339.0), SC_(29.0), SC_(19470.0), SC_(11.0), SC_(0.1517457059116484467160019583373038942718826277345613897896942206282188206078069226205186431962229266e-5), SC_(0.9999998156977005600063225700797734352761213939071596583332383626100889908433841208366664146724675521), SC_(0.1843022994399936774299202265647238786060928403416667616373899110091566158791633335853275324479138748e-6) }}, 
      {{ SC_(1339.0), SC_(29.0), SC_(50688.0), SC_(21.0), SC_(0.2156822921670958801855092452390132612219567168809033470525978021070090074336685750628597985102286159e-26), SC_(0.9999999999999999999999999999788788505102966294314906895446420860289468178868429228898207413536650298), SC_(0.2112114948970337056850931045535791397105318211315707711017925864633497019090702136458553004161988976e-28) }}, 
      {{ SC_(1339.0), SC_(29.0), SC_(130605.0), SC_(26.0), SC_(0.5320290756121497324056391702747738791618723122808260462096273030026345803419050784150112070574120192e-48), SC_(0.9999999999999999999999999999999999999999999999999993991101846489570246130674731275636533749814118738), SC_(0.6008898153510429753869325268724363466250185881261901386103690850083890214692479084003874268617973506e-51) }}, 
      {{ SC_(1339.0), SC_(29.0), SC_(256574.0), SC_(0.0), SC_(0.8592040442711021235343578411990524205078794401342254090975251214067617825804795229565661399955416278), SC_(0.8592040442711021235343578411990524205078794401342254090975251214067617825804795229565661399955416278), SC_(0.1407959557288978764656421588009475794921205598657745909024748785932382174195204770434338600044583722) }}, 
      {{ SC_(1339.0), SC_(29.0), SC_(523360.0), SC_(8.0), SC_(0.7315007824924454465931924870965630395559657609033832390196281685626376044807480547391320526812751475e-14), SC_(0.9999999999999999562563050797076823198514620925113989743855510684793918135863727065413931643167189189), SC_(0.4374369492029231768014853790748860102561444893152060818641362729345860683568328108113517393822367075e-16) }}, 
      {{ SC_(1339.0), SC_(29.0), SC_(1030167.0), SC_(28.0), SC_(0.3365094324351089213113370097986823105038183138797996452714549257933545925788674555660223479567710587e-79), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999985213712009419094), SC_(0.1478628799058090591460959393118867592191965231467319878242700147396938687426891479333876996006442613e-83) }}, 
      {{ SC_(1339.0), SC_(29.0), SC_(2063277.0), SC_(19.0), SC_(0.4736481039598401283803164008881326225975004949486213149964535287765828178176753887841346477072927233e-53), SC_(0.999999999999999999999999999999999999999999999999999999998483490599796567534783858073835519738035628), SC_(0.151650940020343246521614192616448026196437204415858916134995599729632070043996611250775466195442265e-56) }}, 
      {{ SC_(1339.0), SC_(29.0), SC_(2427690.0), SC_(20.0), SC_(0.5866532519360425419171177482318526343658073079860489261943663227333261806486918457775507458002325084e-58), SC_(0.9999999999999999999999999999999999999999999999999999999999999863295412398958839110587915528498606847), SC_(0.1367045876010411608894120844715013931531901544821935016963223458001071905270821104797731155220924477e-61) }}, 
      {{ SC_(1339.0), SC_(36.0), SC_(2247.0), SC_(9.0), SC_(0.184753149675015161911950045680034415198111663935081703972032570555749315073308881197185400469307358e-4), SC_(0.2324826468676633253776491427075288486554988182994847137108757350955442571414205378844233168667363172e-4), SC_(0.9999767517353132336674622350857292471151344501181700515286289124264904455742858579462115576683133264) }}, 
      {{ SC_(1339.0), SC_(36.0), SC_(6337.0), SC_(12.0), SC_(0.03310733935377035671181168774330666421937026511128242102471660531241399720416713393192326064941544994), SC_(0.9723831817563131507115320843173167977670167189361851091742321984118696848413327886323403879529924319), SC_(0.02761681824368684928846791568268320223298328106381489082576780158813031515866721136765961204700756809) }}, 
      {{ SC_(1339.0), SC_(36.0), SC_(10473.0), SC_(14.0), SC_(0.5647006504567302002546907992558839338980572874893097250609624048151261812869899935458246270345271934e-4), SC_(0.9999852003228934759110825193476636554395233670754768674579131431319742516234311393555458972065541311), SC_(0.1479967710652408891748065233634456047663292452313254208685686802574837656886064445410279344586888021e-4) }}, 
      {{ SC_(1339.0), SC_(36.0), SC_(19470.0), SC_(23.0), SC_(0.1418053333244060254526164010175939003865619642260670669952465092128020399851524603074787135608502643e-17), SC_(0.9999999999999999999422066616998842051509796210133509362609749639265196136314407014883213267036469762), SC_(0.5779333830011579484902037898664906373902503607348038636855929851167867329635302375763312254393807052e-19) }}, 
      {{ SC_(1339.0), SC_(36.0), SC_(50688.0), SC_(19.0), SC_(0.5021480482408594198905816233273771687729198747899220570510906683890448965638150157208688723503525603e-20), SC_(0.9999999999999999999998834249920897794874330902323326401946923525086736117799257895644281615301505519), SC_(0.1165750079102205125669097676673598053076474913263882200742104355718384698494481328159720096376540059e-21) }}, 
      {{ SC_(1339.0), SC_(36.0), SC_(130605.0), SC_(29.0), SC_(0.1184232452482554620610020623329040126453030529151204996748781385787717138854196382237208884820120444e-50), SC_(0.9999999999999999999999999999999999999999999999999999971940971670028464593376056837719882291088047792), SC_(0.2805902832997153540662394316228011770891195220813503077963344193655812465086436776575857833574034898e-53) }}, 
      {{ SC_(1339.0), SC_(36.0), SC_(256574.0), SC_(10.0), SC_(0.3218347525019536391783524568397416453198871691953876882152686144536657941264716247584585167460682703e-14), SC_(0.9999999999999999599531180810761355640764869556062060206017983191240830108895246144271293013766717988), SC_(0.4004688191892386443592351304439379397939820168087591698911047538557287069862332820121585478441472194e-16) }}, 
      {{ SC_(1339.0), SC_(36.0), SC_(523360.0), SC_(18.0), SC_(0.170616715622070554723304661422775541570395697831845786163331958415365467174724268098029439756200479e-36), SC_(0.9999999999999999999999999999999999999995900756303393239512082450681686532208217060308598735666403518), SC_(0.4099243696606760487917549318313467791782939691401264333596481601888581011813554392894812712761551479e-39) }}, 
      {{ SC_(1339.0), SC_(36.0), SC_(1030167.0), SC_(7.0), SC_(0.4960979961724796658828464550015128475256798188762627361983946396770481130364978389032496215718007974e-13), SC_(0.9999999999999997662243029935833293997693942497655581779094322862660470465467041643222506299344197754), SC_(0.2337756970064166706002306057502344418220905677137339529534532958356777493700655802245839403080519214e-15) }}, 
      {{ SC_(1339.0), SC_(36.0), SC_(2063277.0), SC_(19.0), SC_(0.202395611056441098080297547291175019896475314805238394218711876176920816663991166847540365497481377e-50), SC_(0.9999999999999999999999999999999999999999999999999999988981222213558526225152017597168811029575617571), SC_(0.110187777864414737748479824028311889704243824291081702749433002092805620681292365388336906230090394e-53) }}, 
      {{ SC_(1339.0), SC_(36.0), SC_(2427690.0), SC_(16.0), SC_(0.4846218588921956093966311590997362285963529248925054160119995148986290436184199088529033988164336187e-42), SC_(0.9999999999999999999999999999999999999999999996889404623358019546780249837250266486306413804773241879), SC_(0.3110595376641980453219750162749733513693586195226758121394237247790465904930236637842271601794802199e-45) }}, 
      {{ SC_(1339.0), SC_(126.0), SC_(2247.0), SC_(83.0), SC_(0.02521555907865179115341283726587835358268877805813913520519571301058327212727142489634958531326326517), SC_(0.9431866957657256005700875223523984859826407873897043570033901113137562871430828431324203875532180709), SC_(0.05681330423427439942991247764760151401735921261029564299660988868624371285691715686757961244678192914) }}, 
      {{ SC_(1339.0), SC_(126.0), SC_(6337.0), SC_(109.0), SC_(0.784243345961440566984504542046430289188156251830530867455626466641114895912152701254375725720532933e-56), SC_(0.999999999999999999999999999999999999999999999999999999999689767487945280659406885106728178995951436), SC_(0.3102325120547193405931148932718210040485640425545153189184429422246110551315105180627463406851138922e-57) }}, 
      {{ SC_(1339.0), SC_(126.0), SC_(10473.0), SC_(38.0), SC_(0.1349899609444660726866980918680952645856492174460515076409836124098012419271242983810110368217512642e-6), SC_(0.9999999367354081936886551362551284317073228683132217360095802866501134040334050081260121176534056984), SC_(0.6326459180631134486374487156829267713168677826399041971334988659596659499187398788234659430162045873e-7) }}, 
      {{ SC_(1339.0), SC_(126.0), SC_(19470.0), SC_(75.0), SC_(0.1762292262851975073833313392803123182847305168121962749568878398050078903765432467656470283987101834e-53), SC_(0.9999999999999999999999999999999999999999999999999999999134065211738628900629816305988964302850480862), SC_(0.8659347882613710993701836940110356971495191382552604895996936408438938519694130950609447279460400538e-55) }}, 
      {{ SC_(1339.0), SC_(126.0), SC_(50688.0), SC_(125.0), SC_(0.1973798659099100473016242953761317079736336624321227289447047061116377288239957841167879341278722815e-197), SC_(1.0), SC_(0.3853653251278162266747527322993372012813036307205481929304810750568082188705370622614062909096064888e-201) }}, 
      {{ SC_(1339.0), SC_(126.0), SC_(130605.0), SC_(84.0), SC_(0.1978967205642995472318124942014233752357048142492515193843708025078134991085623891083837250190542749e-134), SC_(1.0), SC_(0.9540686837783833270989255531178652911870512927224456066741771733165101966282382264239210278951175476e-137) }}, 
      {{ SC_(1339.0), SC_(126.0), SC_(256574.0), SC_(62.0), SC_(0.3195716709287481272819848559282569753428636590408786351797797184148406487258305692168410891034317997e-105), SC_(1.0), SC_(0.1632707126034547233761541034931736811135822656685157454884967949118103664291015223568278817053065056e-107) }}, 
      {{ SC_(1339.0), SC_(126.0), SC_(523360.0), SC_(101.0), SC_(0.5177427566770494780305784704849055380355994634842345234347391861475260566936440848914720833565230046e-237), SC_(1.0), SC_(0.3011246936663408421385363695571645897597105638500620991526125997915536575044065646123991579045489691e-240) }}, 
      {{ SC_(1339.0), SC_(126.0), SC_(1030167.0), SC_(44.0), SC_(0.8498144655672019208276649364829334669254584527921410239609995069964042206923606767111408891745742556e-93), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999980463), SC_(0.1953662559747853574604748487785509269181311290476491592493929725560110879352499661563957865349818322e-95) }}, 
      {{ SC_(1339.0), SC_(126.0), SC_(2063277.0), SC_(13.0), SC_(0.5423965026301999438044145912365067538086294448412000652960685785493906059730439453102052333315322248e-24), SC_(0.9999999999999999999999999971709085628696575175375146764952235783499080166479808141300336144517130527), SC_(0.2829091437130342482462485323504776421650091983352019185869966385548286947336339213382802670185209177e-26) }}, 
      {{ SC_(1339.0), SC_(126.0), SC_(2427690.0), SC_(57.0), SC_(0.1836293023425208290826542467894220847272787054443225182649255929048234647717113375567650886232474026e-149), SC_(1.0), SC_(0.1154978758530681048229395135807314522426423553676399885512042761662528424459440797315932089406772032e-152) }}, 
      {{ SC_(1339.0), SC_(244.0), SC_(2247.0), SC_(188.0), SC_(0.5903535961351018305584941440574659768547325546367458785049478354632758899875490355474094336242638851e-9), SC_(0.9999999996169294302400217733984772280646398006387350021508426435592420767264179507620650789938760404), SC_(0.3830705697599782266015227719353601993612649978491573564407579232735820492379349210061239596170857425e-9) }}, 
      {{ SC_(1339.0), SC_(244.0), SC_(6337.0), SC_(234.0), SC_(0.7522175899100079541966758843359584281952672727995028129448525531295144518498802861521241435728531471e-149), SC_(1.0), SC_(0.714990945925865988661618489919440399913155333364137095515607986553554534614195122115352509697197662e-151) }}, 
      {{ SC_(1339.0), SC_(244.0), SC_(10473.0), SC_(10.0), SC_(0.2065926155497213864687602047915835733620735698378257896423566162308531738099606746502134898528304037e-5), SC_(0.2845950307895224341860719695346101908032785114953075745358283812410088078152364536949686468324618235e-5), SC_(0.9999971540496921047756581392803046538980919672148850469242546417161875899119218476354630503135316754) }}, 
      {{ SC_(1339.0), SC_(244.0), SC_(19470.0), SC_(57.0), SC_(0.1124515343085605159075086092278545733779753327418585361249544304515830592559551979256098874984607549e-15), SC_(0.9999999999999999666399112362569346017435826608916648005998658612086907035629030604317485613933026092), SC_(0.333600887637430653982564173391083351994001341387913092964370969395682514386066973908389134170194683e-16) }}, 
      {{ SC_(1339.0), SC_(244.0), SC_(50688.0), SC_(49.0), SC_(0.1139623505953082542420011432657048359672124647929539784231859994409777417524090968001837646773409943e-27), SC_(0.9999999999999999999999999999870475455964811429789662700288482893728203851091305099042108988902106532), SC_(0.1295245440351885702103372997115171062717961489086949009578910110978934677685754739504368508764161018e-28) }}, 
      {{ SC_(1339.0), SC_(244.0), SC_(130605.0), SC_(206.0), SC_(0.405785615447760575625680404832200981861415146045341213051843460363933125400861552999041925050261612e-372), SC_(1.0), SC_(0.6541194056785688788699880669664877700670398070901205806390520488362742127100475712524815436333301796e-375) }}, 
      {{ SC_(1339.0), SC_(244.0), SC_(256574.0), SC_(185.0), SC_(0.182548374910139522115003503381718840902766611868348085216653728515893693944541612404403447030887062e-370), SC_(1.0), SC_(0.2622348225289835508459466572670657187529825806136036311921064286281699225394194246553184969633097661e-373) }}, 
      {{ SC_(1339.0), SC_(244.0), SC_(523360.0), SC_(129.0), SC_(0.54720248522191512049772296024659774306220596623944741369934482753143938687704724925707357091682906e-265), SC_(1.0), SC_(0.1124530241120565337384575706299451619399451215330247754136255095017312723958258624402278428122909265e-267) }}, 
      {{ SC_(1339.0), SC_(244.0), SC_(1030167.0), SC_(81.0), SC_(0.1409211581248318461211089162238083302100260964645083761107554570018919107418752614434023616443543554e-168), SC_(1.0), SC_(0.3433944056474448732319837248593240066050687001239407796111515430134823153976249018015846447660121503e-171) }}, 
      {{ SC_(1339.0), SC_(244.0), SC_(2063277.0), SC_(213.0), SC_(0.3062655997090061472825796188251816090133797769381922653912295549825966308381501315364727045174809557e-647), SC_(1.0), SC_(0.2422971528566615749955120974067278136668543480749293991421025392123784679884946693241976676618721163e-651) }}, 
      {{ SC_(1339.0), SC_(244.0), SC_(2427690.0), SC_(151.0), SC_(0.1958524897805358638882595784321817128952453762573243953029246565101502173916659265058914478514592012e-426), SC_(1.0), SC_(0.5869154156627967826583359636417899439138234512754984470635189991528151651666983767286210052939568876e-430) }}, 
      {{ SC_(1339.0), SC_(312.0), SC_(2247.0), SC_(311.0), SC_(0.1040650146134592105159643483551822671939519264568987909327381821590505944903010502767062105533661822e-74), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999962237788382950670531737), SC_(0.3776221161704932946826335356274969313911335860643706832389262511984073588615069739228721353243972215e-77) }}, 
      {{ SC_(1339.0), SC_(312.0), SC_(6337.0), SC_(125.0), SC_(0.3028266449997325328570330416817105039133563191680356362940042650572939326809619448707720723847682532e-14), SC_(0.9999999999999982111538479416669430914260510208890573116520634670099776314781804942216253747909800246), SC_(0.178884615205833305690857394897911094268834793653299002236852181950577837462520901997538690974227206e-14) }}, 
      {{ SC_(1339.0), SC_(312.0), SC_(10473.0), SC_(166.0), SC_(0.1686991011595395227472143968510510082157514248182998109153874437865507747611684230736425704171188227e-67), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999978318888717379867485371711477666), SC_(0.2168111128262013251462828852233387683926172194833121547426546435115196823183643878456648033668831037e-68) }}, 
      {{ SC_(1339.0), SC_(312.0), SC_(19470.0), SC_(214.0), SC_(0.2201805935828512966365815085182894919353519833696082123086435679008255404756032902481685702879611499e-175), SC_(1.0), SC_(0.6440946549318465194087563000050801625953606686576724224398001761530340162980079589026754343507602573e-177) }}, 
      {{ SC_(1339.0), SC_(312.0), SC_(50688.0), SC_(186.0), SC_(0.3600448347767381957363005753523636500090970347096106129845209727241921240987757134442893170911198898e-210), SC_(1.0), SC_(0.5772278712230392572615420217416141508846781075079747719416338161904239713776121025262766424978907874e-212) }}, 
      {{ SC_(1339.0), SC_(312.0), SC_(130605.0), SC_(228.0), SC_(0.9146588351416794011588132238852077983958621035804483570894661411031631065988907277447353307682184605e-385), SC_(1.0), SC_(0.2894411546275955561005184568547020361948504606931671201227480893476587616634985267725710381913066123e-387) }}, 
      {{ SC_(1339.0), SC_(312.0), SC_(256574.0), SC_(294.0), SC_(0.57248255323791730774507076187386238016413103719707789041309704926398709034758443035965359039422536e-657), SC_(1.0), SC_(0.1430605120332395675667258421199981963652031308902143372302091628384938714689250669056765536201483148e-660) }}, 
      {{ SC_(1339.0), SC_(312.0), SC_(523360.0), SC_(243.0), SC_(0.1812552409829616540795498072579185536826947086730701149972689309332745033856746944753864659198676945e-569), SC_(1.0), SC_(0.1076916276794937429867351420214432011523417213313279824967945944428518112177686287039357308481023041e-572) }}, 
      {{ SC_(1339.0), SC_(312.0), SC_(1030167.0), SC_(140.0), SC_(0.2831304657407057000441822412063278877793133040234467684869370170031953404368634070474925044917835582e-315), SC_(1.0), SC_(0.4031382773705499811010270886823296786557985087233459493298711893525931941782227426021734123319745101e-318) }}, 
      {{ SC_(1339.0), SC_(312.0), SC_(2063277.0), SC_(28.0), SC_(0.2240368031138029760890083558848785634807054640956344446816147761626134481022725507766452051640003426e-49), SC_(0.999999999999999999999999999999999999999999999999999859642103832159019980897349676074404967917366108), SC_(0.1403578961678409800191026503239255950320826338919930808646921745821246908910392742958787853590083327e-51) }}, 
      {{ SC_(1339.0), SC_(312.0), SC_(2427690.0), SC_(302.0), SC_(0.1957043955199269692369785357488541654853573036654895950990749088374041747641215788223257511878038295e-981), SC_(1.0), SC_(0.2760515448289970120308605687042059070925509392378600460273150289770803049036886777743737903728761558e-986) }}, 
      {{ SC_(1339.0), SC_(835.0), SC_(2247.0), SC_(196.0), SC_(0.3860397306083720903749045242065426872883316857428022183216566885345843600269489783685935083508578503e-163), SC_(0.4159682682639753775140050543729986181612238109940124383950028480568597037585469523884187756383063122e-163), SC_(1.0) }}, 
      {{ SC_(1339.0), SC_(835.0), SC_(6337.0), SC_(375.0), SC_(0.4280355380712632556578413246717773268962281509295079701291255915849692123025590566561078734486970195e-62), SC_(0.999999999999999999999999999999999999999999999999999999999999998501721268974512728051089261045008144), SC_(0.1498278731025487271948910738954991855968891511699432676559991788577393164198227441661848842616940758e-62) }}, 
      {{ SC_(1339.0), SC_(835.0), SC_(10473.0), SC_(586.0), SC_(0.2566003791162201097336488547986066764478210247982322275380201124299215804687285072555463780186873752e-371), SC_(1.0), SC_(0.956502102816550054326061989862526834560243137819889103112090701704975411893241183173355574273562272e-373) }}, 
      {{ SC_(1339.0), SC_(835.0), SC_(19470.0), SC_(124.0), SC_(0.9377121098313886077144933575640498296886182062634241785951528133618354834661737229604753946591365607e-16), SC_(0.9999999999999999390024295046922695192874291095214717684988396285211411238248933492650118469978967348), SC_(0.6099757049530773048071257089047852823150116037147885887617510665073498815300210326519391374970722683e-16) }}, 
      {{ SC_(1339.0), SC_(835.0), SC_(50688.0), SC_(347.0), SC_(0.743830793028107539527958787960378765774359514594905245087897141692580326224330914627050495914640041e-328), SC_(1.0), SC_(0.2179320418002873533491569743663856921540942284819389614746576452261453309075769753476957250884519146e-329) }}, 
      {{ SC_(1339.0), SC_(835.0), SC_(130605.0), SC_(814.0), SC_(0.3753193957536377079913980221960321578445773374696856174478974848794817613648299848169465561621215783e-1716), SC_(1.0), SC_(0.3928692556753312350729793135200593549864370196583434811310297898213898933682814485481953984230287646e-1720) }}, 
      {{ SC_(1339.0), SC_(835.0), SC_(256574.0), SC_(432.0), SC_(0.1041677437356688975328832067479614293547188879732131880795125570777146316960211147962496070976653759e-770), SC_(1.0), SC_(0.3462059615882464007442581460936639605055407708101143009659194656857527546726441309310633976129715006e-773) }}, 
      {{ SC_(1339.0), SC_(835.0), SC_(523360.0), SC_(589.0), SC_(0.5342917970524235128020451718279129157185600935536583984658401429534804482969571352048802091503274799e-1375), SC_(1.0), SC_(0.3204035225946903103465352570710371951958131044662433581814509461368199511227011338214699912549437252e-1378) }}, 
      {{ SC_(1339.0), SC_(835.0), SC_(1030167.0), SC_(444.0), SC_(0.2354955915838906913539131809093529808281048293787655503528237918772883581210760160046669252213778916e-1068), SC_(1.0), SC_(0.1802082599492970746053796596842953448881840627750968905245510853707412390786047389512583975221107202e-1071) }}, 
      {{ SC_(1339.0), SC_(835.0), SC_(2063277.0), SC_(707.0), SC_(0.248357755311635886921292219883012343448187611279148553959012424218954896468858397092093884859410431e-2200), SC_(1.0), SC_(0.1376405731851699512802727670375552097778725224002270367698239141972592682002931427901489826326294209e-2204) }}, 
      {{ SC_(1339.0), SC_(835.0), SC_(2427690.0), SC_(315.0), SC_(0.658093262760414091234253970175459520565064047274824453671870484615931082702847993049357149301374597e-805), SC_(1.0), SC_(0.4574492249780827062488537852575394234276166634666168342972367941967456382548843837494560087802263397e-808) }}, 
      {{ SC_(1339.0), SC_(1339.0), SC_(2247.0), SC_(707.0), SC_(0.3778137180870704530549569659003067917173356784776739397924128314764404668082265666945440870878378748e-15), SC_(0.7312680328310309467089927617056686371709137944526229789864043690469481026240949380734643292444323017e-15), SC_(0.9999999999999992687319671689690532910072382943313628290862055473770210135956309530518973759050619265) }}, 
      {{ SC_(1339.0), SC_(1339.0), SC_(6337.0), SC_(218.0), SC_(0.1157264748994242580845821695300763231512804392399735656499273797151878380432848760901716540607828625e-6), SC_(0.3433953447897007140900992953216578074725082703641540379964283417456571181562935704385323637327140046e-6), SC_(0.9999996566046552102992859099007046783421925274917296358459620035716582543428818437064295614676362673) }}, 
      {{ SC_(1339.0), SC_(1339.0), SC_(10473.0), SC_(46.0), SC_(0.4065814660355104305174897370391837413463339584022166938239532643295424456906528737050381180811687662e-35), SC_(0.5173109854980034393817492212159061318620091716485768276590697974387690278352374411158398255588030848e-35), SC_(0.9999999999999999999999999999999999948268901450199656061825077878409386813799082835142317234093020256) }}, 
      {{ SC_(1339.0), SC_(1339.0), SC_(19470.0), SC_(1291.0), SC_(0.1260762385721832439071893501952345594336682357111735019765975795810467225534672853417033098787389043e-1883), SC_(1.0), SC_(0.1243368138237830920242428945927713076784843943446916106700649956941968105262305379155534999864916288e-1887) }}, 
      {{ SC_(1339.0), SC_(1339.0), SC_(50688.0), SC_(72.0), SC_(0.8338190604141495132687884201953360964618161935835200790687343649717287577394278750378565321878695266e-8), SC_(0.999999993125876534139625891783188082274444351082122944548989279699361312559003087391044667867970321), SC_(0.6874123465860374108216811917725555648917877055451010720300638687440996912608955332132029678963337892e-8) }}, 
      {{ SC_(1339.0), SC_(1339.0), SC_(130605.0), SC_(1188.0), SC_(0.1476624894843358747530107756450261892024020552632807977833505997328664819692687173148004411907410028e-2529), SC_(1.0), SC_(0.2193440026438075706424754775460459797865691150840160870475717286929102633910983804687172290133263387e-2533) }}, 
      {{ SC_(1339.0), SC_(1339.0), SC_(256574.0), SC_(1103.0), SC_(0.8383113967331085126873191149203419197687422167322144945420862929119716319424512496147308272129472643e-2548), SC_(1.0), SC_(0.1658842859083909734235307237330571025990406885756112254198232279328012186295735413509377593077077863e-2551) }}, 
      {{ SC_(1339.0), SC_(1339.0), SC_(523360.0), SC_(699.0), SC_(0.4634283433070907437256453614031991713614417089673988173099240036780647298174636270766077379863036206e-1509), SC_(1.0), SC_(0.5206836301051059399014301845493441105379070299652583108143119406187249490913692508958865639526076953e-1512) }}, 
      {{ SC_(1339.0), SC_(1339.0), SC_(1030167.0), SC_(482.0), SC_(0.6325470350559393329293668598850740122461798522485767876174506193810264006966091739035781908354326465e-1056), SC_(1.0), SC_(0.9370572257167455578644743656091410026563553464482024223563249760541997992462708980344544154047133432e-1059) }}, 
      {{ SC_(1339.0), SC_(1339.0), SC_(2063277.0), SC_(339.0), SC_(0.1526701717879239965276579964133116305307411445470214323043205594799499586271615501882705464614973024e-773), SC_(1.0), SC_(0.2181862129194613298235598708693019522150919773142004530665984522394460128338462213027466705147402279e-776) }}, 
      {{ SC_(1339.0), SC_(1339.0), SC_(2427690.0), SC_(926.0), SC_(0.3094692542018462342742265948378542124573253083548460802435246876175779067472768469142291933981836374e-2850), SC_(1.0), SC_(0.2347419715146783654006083655571597535690871922928549380850250847206202841109011201125410330539880679e-2854) }}, 
      {{ SC_(2247.0), SC_(3.0), SC_(6337.0), SC_(1.0), SC_(0.4432198993426867170216106612627266125052082643950800537086290231241787348734446242111911682102362636), SC_(0.7120053834715849960876756936380457627679721547447443853450146404705135024394795780422769856918333331), SC_(0.2879946165284150039123243063619542372320278452552556146549853595294864975605204219577230143081666669) }}, 
      {{ SC_(2247.0), SC_(3.0), SC_(10473.0), SC_(0.0), SC_(0.4845279303501030052561052398446425466405757204301383677385191150938878518917602701119194908105204564), SC_(0.4845279303501030052561052398446425466405757204301383677385191150938878518917602701119194908105204564), SC_(0.5154720696498969947438947601553574533594242795698616322614808849061121481082397298880805091894795436) }}, 
      {{ SC_(2247.0), SC_(3.0), SC_(19470.0), SC_(3.0), SC_(0.001535317624824685046718393864380338860940933996351795870079526940821277849967152435392861842634626093), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(2247.0), SC_(3.0), SC_(50688.0), SC_(0.0), SC_(0.8728158834418495627923108739096156540312841533345766434751449044752462259242307004956771523922634385), SC_(0.8728158834418495627923108739096156540312841533345766434751449044752462259242307004956771523922634385), SC_(0.1271841165581504372076891260903843459687158466654233565248550955247537740757692995043228476077365615) }}, 
      {{ SC_(2247.0), SC_(3.0), SC_(130605.0), SC_(1.0), SC_(0.04985369955134297259513267154705203686894306474848328082196388169915164984408375485228822081387771878), SC_(0.9991225705811870002499092906085282635934729592532036477087753327579076754021971837610699652691128985), SC_(0.0008774294188129997500907093914717364065270407467963522912246672420923245978028162389300347308871014503) }}, 
      {{ SC_(2247.0), SC_(3.0), SC_(256574.0), SC_(3.0), SC_(0.6708050338343502851212734257654032022961388937187157325070638203018324798598090963927901006664705966e-6), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(2247.0), SC_(3.0), SC_(523360.0), SC_(3.0), SC_(0.790369329163685808727091412461861768330023677825159482164370364481418981852008009252857427610473043e-7), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(2247.0), SC_(3.0), SC_(1030167.0), SC_(0.0), SC_(0.9934706569536794265974626082192855775795656920155957100162547613767947101439329515299213212353176512), SC_(0.9934706569536794265974626082192855775795656920155957100162547613767947101439329515299213212353176512), SC_(0.006529343046320573402537391780714422420434307984404289983745238623205289856067048470078678764682348765) }}, 
      {{ SC_(2247.0), SC_(3.0), SC_(2063277.0), SC_(1.0), SC_(0.003260023746957502198833206571576180698590263256120498609490581165370935954109598504422125504279200649), SC_(0.9999964461092667800295417177423983959269084798761351860625618629163561737312758349162604009126042814), SC_(0.3553890733219970458282257601604073091520123864813937438137083643826268724165083739599087395718649539e-5) }}, 
      {{ SC_(2247.0), SC_(3.0), SC_(2427690.0), SC_(0.0), SC_(0.997225854445610919221012697745772898105172007109384903121019398099891430261441812069781133960813831), SC_(0.997225854445610919221012697745772898105172007109384903121019398099891430261441812069781133960813831), SC_(0.002774145554389080778987302254227101894827992890615096878980601900108569738558187930218866039186169045) }}, 
      {{ SC_(2247.0), SC_(4.0), SC_(6337.0), SC_(1.0), SC_(0.3814088934876125248256697996509896625452671055356461971499579931652757958452040045838015989145239123), SC_(0.5548421542446076726853173821135613971717142195013989794988541122202916144499379572689370166674900038), SC_(0.4451578457553923273146826178864386028282857804986010205011458877797083855500620427310629833325099962) }}, 
      {{ SC_(2247.0), SC_(4.0), SC_(10473.0), SC_(0.0), SC_(0.3805418501689490938128895307776977708715811030656187008513698838029646424169956734603929296021881292), SC_(0.3805418501689490938128895307776977708715811030656187008513698838029646424169956734603929296021881292), SC_(0.6194581498310509061871104692223022291284188969343812991486301161970353575830043265396070703978118708) }}, 
      {{ SC_(2247.0), SC_(4.0), SC_(19470.0), SC_(1.0), SC_(0.3195831358574128258580866803094153517725191004536935789961163761317046231541748461093070819700488328), SC_(0.9318685830608673053058228435190428948880930779584336135213860687204845086364724484682599025668713629), SC_(0.06813141693913269469417715648095710511190692204156638647861393127951549136352755153174009743312863705) }}, 
      {{ SC_(2247.0), SC_(4.0), SC_(50688.0), SC_(2.0), SC_(0.01076495195951492688620495323150361804838623024497768467788789628270192349486651844969883312374628709), SC_(0.9996635397573180834988367820789651658120347216998735775101592050406281298660783603489738879383486393), SC_(0.0003364602426819165011632179210348341879652783001264224898407949593718701339216396510261120616513606988) }}, 
      {{ SC_(2247.0), SC_(4.0), SC_(130605.0), SC_(4.0), SC_(0.8738416886477458222987983611136493028914803266367484396776444290789835144203983740920252410083549336e-7), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(2247.0), SC_(4.0), SC_(256574.0), SC_(0.0), SC_(0.9654264749534878478607389333288743817044078528854272301498300835102057005748040080348654867106110139), SC_(0.9654264749534878478607389333288743817044078528854272301498300835102057005748040080348654867106110139), SC_(0.03457352504651215213926106667112561829559214711457276985016991648979429942519599196513451328938898613) }}, 
      {{ SC_(2247.0), SC_(4.0), SC_(523360.0), SC_(3.0), SC_(0.3147921837128199701872341726372156456718940446559440941683184012030082725824069401470249070173338537e-6), SC_(0.999999999661113011836411674099401913117734584971143381470075325642563852219544291397630548429778018), SC_(0.3388869881635883259005980868822654150288566185299246743574361477804557086023694515702219819717473016e-9) }}, 
      {{ SC_(2247.0), SC_(4.0), SC_(1030167.0), SC_(0.0), SC_(0.9913036926973329442203221738023687228915536045130630612725532493371454603945213703165508884302139373), SC_(0.9913036926973329442203221738023687228915536045130630612725532493371454603945213703165508884302139373), SC_(0.008696307302667055779677826197631277108446395486936938727446750662854539605478629683449111569786062708) }}, 
      {{ SC_(2247.0), SC_(4.0), SC_(2063277.0), SC_(0.0), SC_(0.9956509306917661948726110398584318892136357115175682004606955472812619376571287885501399526837557487), SC_(0.9956509306917661948726110398584318892136357115175682004606955472812619376571287885501399526837557487), SC_(0.004349069308233805127388960141568110786364288482431799539304452718738062342871211449860047316244251257) }}, 
      {{ SC_(2247.0), SC_(4.0), SC_(2427690.0), SC_(4.0), SC_(0.7319479150023198094840253786108107347522246809725828447700487818434383331203829045348669709255324312e-12), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(2247.0), SC_(15.0), SC_(6337.0), SC_(0.0), SC_(0.001391979754749438592595982615720620532818462140416858333537908611438243614174573008029809442123198308), SC_(0.001391979754749438592595982615720620532818462140416858333537908611438243614174573008029809442123198308), SC_(0.9986080202452505614074040173842793794671815378595831416664620913885617563858254269919701905578768017) }}, 
      {{ SC_(2247.0), SC_(15.0), SC_(10473.0), SC_(1.0), SC_(0.1093500022831609432784437421633208849127150871796438859942215919125380516090425567907571026639848817), SC_(0.135992406043710347408471334824504421684802798080674462816193041631741804162475503723428733789237629), SC_(0.864007593956289652591528665175495578315197201919325537183806958368258195837524496276571266210762371) }}, 
      {{ SC_(2247.0), SC_(15.0), SC_(19470.0), SC_(1.0), SC_(0.3110109804655770651441676359350087171210734445779705896222612716776636681199485607634363906458025954), SC_(0.4698060542775371812713292097906848783118924004522413469819851768638649458139463291116926388767361917), SC_(0.5301939457224628187286707902093151216881075995477586530180148231361350541860536708883073611232638083) }}, 
      {{ SC_(2247.0), SC_(15.0), SC_(50688.0), SC_(5.0), SC_(0.0003256016138170223948585304821875100260593263130831710995731276351987572471231541994700914518794450848), SC_(0.9999733127797205216935249393683826414586542609839644411436902657686157492876963286238788457807626686), SC_(0.266872202794783064750606316173585413457390160355588563097342313842507123036713761211542192373313808e-4) }}, 
      {{ SC_(2247.0), SC_(15.0), SC_(130605.0), SC_(6.0), SC_(0.1103462971177626748666235644074999034085962890572723339032747821986302057440449830832807568926474708e-6), SC_(0.9999999974790494162472939465318442758665629111348369956097689738114744229078165205744101734213351397), SC_(0.2520950583752706053468155724133437088865163004390231026188525577092183479425589826578664860322879942e-8) }}, 
      {{ SC_(2247.0), SC_(15.0), SC_(256574.0), SC_(10.0), SC_(0.7478415873179038459746430623931741769736889943652535020143484607490010220621764241545604967931167647e-17), SC_(0.9999999999999999999700124657999797671359354209261451758837723117310696645771056607535977565377287973), SC_(0.299875342000202328640645790738548241162276882689303354228943392464022434622712027301845857776197632e-19) }}, 
      {{ SC_(2247.0), SC_(15.0), SC_(523360.0), SC_(1.0), SC_(0.06063793824887297123498591267365138907505256642365214814158168792248178945793247681282494177521850229), SC_(0.9981359054213831755838933183501701606407198950336124135155640631060233380558284691523845674672136783), SC_(0.001864094578616824416106681649829839359280104966387586484435936893976661944171530847615432532786321667) }}, 
      {{ SC_(2247.0), SC_(15.0), SC_(1030167.0), SC_(7.0), SC_(0.147163385599554328143263207465445419235807584932492359172225120002061747952000461139163748800838788e-14), SC_(0.9999999999999999967876154400030262694157657467269726602327568716426778770983312996468376414581615892), SC_(0.3212384559996973730584234253273027339767243128357322122901668700353162358541838410751033722992816395e-17) }}, 
      {{ SC_(2247.0), SC_(15.0), SC_(2063277.0), SC_(6.0), SC_(0.8213556834375992717039534294402272939531459215286119624851726818157953364164315492666919361133660009e-14), SC_(0.9999999999999999885050492346323006457819310706976951229097700525640550552545510111660732859690197568), SC_(0.1149495076536769935421806892930230487709022994743594494474544898883392671403098024324358788665155954e-16) }}, 
      {{ SC_(2247.0), SC_(15.0), SC_(2427690.0), SC_(13.0), SC_(0.370363239193708855472990617896608984711377830616960226464197041002811284160499835272132805798005765e-37), SC_(0.99999999999999999999999999999999999999999512641254518182451812011558132332421158057694975804353729), SC_(0.4873587454818175481879884418676675788419423050241956462709950397026931404935441703078727861198139851e-41) }}, 
      {{ SC_(2247.0), SC_(29.0), SC_(6337.0), SC_(4.0), SC_(0.006536364103578358172933762360874970215718231988730488610130765563926401657125074410015166954339899502), SC_(0.008774690952134846793609851195648577972737967734040106279388905559734120205945335406797026523294183979), SC_(0.991225309047865153206390148804351422027262032265959893720611094440265879794054664593202973476705816) }}, 
      {{ SC_(2247.0), SC_(29.0), SC_(10473.0), SC_(14.0), SC_(0.0008943827218963621316022050480476714102902342435330085769316300695475906384530334744277012922399358611), SC_(0.9996843897603527503928545424783930505511789521010166856643558373808268365133061415214791413853874667), SC_(0.0003156102396472496071454575216069494488210478989833143356441626191731634866938584785208586146125333093) }}, 
      {{ SC_(2247.0), SC_(29.0), SC_(19470.0), SC_(15.0), SC_(0.1158817322998873575717784715313471265321812355976100758342413175355082018642165873779811853328812265e-6), SC_(0.9999999854245285450144708549041091115201074888239722973851783796497821476096684558285972689622070579), SC_(0.145754714549855291450958908884798925111760277026148216203502178523903315441714027310377929420616622e-7) }}, 
      {{ SC_(2247.0), SC_(29.0), SC_(50688.0), SC_(9.0), SC_(0.2641801171044362123924609670570255557664910790868719752502647678669821268924188512572371609988835595e-5), SC_(0.9999997348773530163672920735480982796236125873246043348396520214482586913525305618478845885462035597), SC_(0.2651226469836327079264519017203763874126753956651603479785517413086474694381521154114537964402794585e-6) }}, 
      {{ SC_(2247.0), SC_(29.0), SC_(130605.0), SC_(25.0), SC_(0.1512693313592606961187383453177255643162917328389517795246884277363868387410612888890900218769230829e-39), SC_(0.99999999999999999999999999999999999999999959635089019405733625200458641222132501011495321543568409), SC_(0.4036491098059426637479954135877786749898850467845643159099512505734114213561438830921471680475496235e-42) }}, 
      {{ SC_(2247.0), SC_(29.0), SC_(256574.0), SC_(6.0), SC_(0.1739979285698459464382271342045335334723143007199037692071166662952454515770657179808654397838862014e-6), SC_(0.999999994837382073774089613384079111534502256458554665671779008923007835390158984429889429007697355), SC_(0.516261792622591038661592088846549774354144533432822099107699216460984101557011057099230264503466749e-8) }}, 
      {{ SC_(2247.0), SC_(29.0), SC_(523360.0), SC_(26.0), SC_(0.8857458578829085791872892646175200714428379306937331753328543448893020301695291454548391120800837944e-58), SC_(0.9999999999999999999999999999999999999999999999999999999999999580417765822173022907778686586698187527), SC_(0.4195822341778269770922213134133018124733462411554556450744778877060031196346222733267677166224022119e-61) }}, 
      {{ SC_(2247.0), SC_(29.0), SC_(1030167.0), SC_(6.0), SC_(0.4833213284762861628715993789608568285094806619535934578392946492875464125031751519903457257153368893e-10), SC_(0.9999999999996516902160787842964709373722631406941819531434017917184104552823155583406190723853116038), SC_(0.3483097839212157035290626277368593058180468565982082815895447176844416593809276146883962059160582393e-12) }}, 
      {{ SC_(2247.0), SC_(29.0), SC_(2063277.0), SC_(0.0), SC_(0.9688943449352099683964382496091135202811790098034526675212993396672153799490148489860075387523627105), SC_(0.9688943449352099683964382496091135202811790098034526675212993396672153799490148489860075387523627105), SC_(0.03110565506479003160356175039088647971882099019654733247870066033278462005098515101399246124763728946) }}, 
      {{ SC_(2247.0), SC_(29.0), SC_(2427690.0), SC_(12.0), SC_(0.1961033181976116723196920075602109470529673912352097998465528410847631775534814356967587106286574691e-28), SC_(0.9999999999999999999999999999999763442253546788334907189504878968009699430385866287050208616366776011), SC_(0.2365577464532116650928104951210319903005696141337129497913836332239891603316309921410078161480214802e-31) }}, 
      {{ SC_(2247.0), SC_(36.0), SC_(6337.0), SC_(17.0), SC_(0.04626739725250230211170919401035645729923413337312581139146264325244833345976257344455226766386435524), SC_(0.9487955548653665459503884590525817413585431711231499685512676029198466634361237436151530473196812027), SC_(0.05120444513463345404961154094741825864145682887685003144873239708015333656387625638484695268031879729) }}, 
      {{ SC_(2247.0), SC_(36.0), SC_(10473.0), SC_(23.0), SC_(0.396730476501862109606565003373164350149361288781270702614189376321106164317604178617032659566185009e-7), SC_(0.9999999933298473901397649215504143583593452182105357435726106152752120773678401000918652925679964899), SC_(0.6670152609860235078449585641640654781789464256427389384724787922632159899908134707432003510133656677e-8) }}, 
      {{ SC_(2247.0), SC_(36.0), SC_(19470.0), SC_(12.0), SC_(0.0003634851598081517257045549662781144095319498744879066617096665348789580908441525522124527971612771107), SC_(0.9998899456741524229685875525608629938832428370798112687777552534968389947462568148028908093401340907), SC_(0.0001100543258475770314124474391370061167571629201887312222447465031610052537431851971091906598659092861) }}, 
      {{ SC_(2247.0), SC_(36.0), SC_(50688.0), SC_(10.0), SC_(0.2258987685833524554716739338652237650421172434171811814000784822667093065730531607622268884649080701e-5), SC_(0.9999997273756721692761772665944165354518726950864317732258828639573948403717734324081523325130520074), SC_(0.2726243278307238227334055834645481273049135682267741171360426051596282265675918476674869479925993116e-6) }}, 
      {{ SC_(2247.0), SC_(36.0), SC_(130605.0), SC_(29.0), SC_(0.4223593034210586199715214148913259455590016173307227830698343491967799100880487125614852092584301606e-44), SC_(0.999999999999999999999999999999999999999999999982912791003118424553700926101297883170449555009350007), SC_(0.1708720899688157544629907389870211682955044499064999304156927355328585032104688287574157492133398603e-46) }}, 
      {{ SC_(2247.0), SC_(36.0), SC_(256574.0), SC_(33.0), SC_(0.6912529414730313813760470511505065318156444563418359051710327665536905829110724202737225161561418837e-64), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999468768482070635866438721534268881), SC_(0.531231517929364133561278465731118914390657880183710398102967256345392010716746561368398260801245461e-67) }}, 
      {{ SC_(2247.0), SC_(36.0), SC_(523360.0), SC_(20.0), SC_(0.2841432342188514470539831425808971952674816195658477856442395043156231349224071131801357894597002514e-37), SC_(0.99999999999999999999999999999999999999990720914640993277188931336363038916769531194616576566295844), SC_(0.9279085359006722811068663636961083230468805383423433704155996324279979451993792269249032345047454221e-40) }}, 
      {{ SC_(2247.0), SC_(36.0), SC_(1030167.0), SC_(27.0), SC_(0.1101978266525755026734492838205787194038590819384927481783435580521397266986404474854325878711887478e-63), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999234556343929138126728377308449034), SC_(0.7654436560708618732716226915509659677175425942764766458926357035554874133530949901907147153123881026e-67) }}, 
      {{ SC_(2247.0), SC_(36.0), SC_(2063277.0), SC_(16.0), SC_(0.2653999233066214449099229155080759754962637690168840445812807903056919428926674570505987873623596173e-37), SC_(0.9999999999999999999999999999999999999999661625706362159572915890876831411076064559445767295247150004), SC_(0.3383742936378404270841091231685889239354405542327047528499957952726935718172235940112679926953122946e-40) }}, 
      {{ SC_(2247.0), SC_(36.0), SC_(2427690.0), SC_(26.0), SC_(0.2916338507048749100091465886927074922282737868428611148052918379572912087021167757433640368976099109e-70), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999901062473211299015893791383), SC_(0.9893752678870098410620861665711202209395841857108345707372040073397029440024468973886832335569683913e-74) }}, 
      {{ SC_(2247.0), SC_(126.0), SC_(6337.0), SC_(96.0), SC_(0.422916266128329903673514024643642689574025932991149333689077450603259840577370974656388794276768997e-20), SC_(0.9999999999999999999991797707538737640314242195575494086636864401228539113527082163204014222294549733), SC_(0.8202292461262359685757804424505913363135598771460886472917836795985777705450266583121740882542387579e-21) }}, 
      {{ SC_(2247.0), SC_(126.0), SC_(10473.0), SC_(100.0), SC_(0.3675433212154851213993606036410414706750134748053736319138099094849031936032830747261750618418311726e-43), SC_(0.9999999999999999999999999999999999999999999973538857276046061010671941596875903298231960416992394455), SC_(0.2646114272395393898932805840312409670176803958300760554480848729465779963551360079710666204532847458e-44) }}, 
      {{ SC_(2247.0), SC_(126.0), SC_(19470.0), SC_(5.0), SC_(0.001759798990787181556424975811688780745343949023921135576766889514102179117032384986911648412137004057), SC_(0.002474350270021755835838146297838489857655178930025310829224170083254771827173791794108896208038702557), SC_(0.9975256497299782441641618537021615101423448210699746891707758299167452281728262082058911037919612974) }}, 
      {{ SC_(2247.0), SC_(126.0), SC_(50688.0), SC_(95.0), SC_(0.288329903553332684865085505392202349309554568347750248124899058883071165860455592078344065979789156e-100), SC_(1.0), SC_(0.4196468471537893704800629762204677220424548448503367545403084242006712051697304417123114674129704889e-102) }}, 
      {{ SC_(2247.0), SC_(126.0), SC_(130605.0), SC_(64.0), SC_(0.1033098878555107173378826493562915499875725412198877557584656860894826750783587310350590072437667283e-76), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999998296528772172469850797), SC_(0.1703471227827530149203466963244326352984016492971794599316872561644222236861357176868751352064312658e-78) }}, 
      {{ SC_(2247.0), SC_(126.0), SC_(256574.0), SC_(111.0), SC_(0.2364843376210738561999446690725919185189140755110750720420529961489923097096435952140194869534684861e-210), SC_(1.0), SC_(0.2662932852949161639484046345044859679165490049348039677103049741354184316445273405633228769762190747e-213) }}, 
      {{ SC_(2247.0), SC_(126.0), SC_(523360.0), SC_(108.0), SC_(0.4237888590351018606618986420097063491531868008166694030222547676581789083440159776256878791033835279e-235), SC_(1.0), SC_(0.2874511440104174118367330301912077542679460243988570574214347124361531366795830030315597556571978417e-238) }}, 
      {{ SC_(2247.0), SC_(126.0), SC_(1030167.0), SC_(62.0), SC_(0.2217469942115708079185739106638682002268048671314282884693627126719722833310229230771840951979173008e-128), SC_(1.0), SC_(0.4798717394738863500734748898959376193716883758865398338325932955326952937275616658863386162756717348e-131) }}, 
      {{ SC_(2247.0), SC_(126.0), SC_(2063277.0), SC_(124.0), SC_(0.9747716644676734774625443435240313314050389997563352997816320817199319737081905900545125400098397491e-365), SC_(1.0), SC_(0.1606542870503800381420981356603685282411925372662747185117626542135731637163761042537031658171577056e-369) }}, 
      {{ SC_(2247.0), SC_(126.0), SC_(2427690.0), SC_(28.0), SC_(0.7309713184695169268506226725277140227705881510848768321108090217752000902318313621666792418034738867e-57), SC_(0.9999999999999999999999999999999999999999999999999999999999977332797625577963969005140585556469505169), SC_(0.2266720237442203603099485941444353049483089439935047264533598408925520071905232953001250951035575982e-59) }}, 
      {{ SC_(2247.0), SC_(244.0), SC_(6337.0), SC_(44.0), SC_(0.5107717989524108067740792697209811705505702533897713869072167818875216429191783193217823680620002372e-9), SC_(0.8236741514925007344987377056665148171809579337914048582441217271029715044598911344231135207532179411e-9), SC_(0.9999999991763258485074992655012622943334851828190420662085951417558782728970284955401088655768864792) }}, 
      {{ SC_(2247.0), SC_(244.0), SC_(10473.0), SC_(68.0), SC_(0.003292335107706795662494926935272527875939656359653914419979766333767094941155982583588295877521179965), SC_(0.9934423018641382220623764352837447691768106609999248321209116014475224131790410854391697815236914563), SC_(0.006557698135861777937623564716255230823189339000075167879088398552477586820958914560830218476308543665) }}, 
      {{ SC_(2247.0), SC_(244.0), SC_(19470.0), SC_(170.0), SC_(0.1425580274833127325962313602001273505913289813985485631449437651708529809535705302405545953025453279e-101), SC_(1.0), SC_(0.7875510726553002134664935151345694788115060344478888046876199397966446195427172103584789901915278286e-103) }}, 
      {{ SC_(2247.0), SC_(244.0), SC_(50688.0), SC_(145.0), SC_(0.1748115475376314431985000190932928699438553720950733348421105342003988146561076413259087751079042911e-129), SC_(1.0), SC_(0.5307787374052345163841119204467854404495618928179001697774652002017384931117354276226948888680358461e-131) }}, 
      {{ SC_(2247.0), SC_(244.0), SC_(130605.0), SC_(13.0), SC_(0.0002608988532694929728295355694962429035471618432234442864133729853211860884314205037888510966265286503), SC_(0.9998983944257087754718521622409440169004108183024146484225705911663768826593950106904033414792167166), SC_(0.0001016055742912245281478377590559830995891816975853515774294088336231173406049893095966585207832834419) }}, 
      {{ SC_(2247.0), SC_(244.0), SC_(256574.0), SC_(26.0), SC_(0.3039965960260773205536436012014631545135619633553349209072420661350456644647824869344540430732824533e-19), SC_(0.9999999999999999999976993717697438910060016663295679287133302152611658186154616666106725518200846556), SC_(0.2300628230256108993998333670432071286669784738834181384538333389327448179915344429066882363936195825e-20) }}, 
      {{ SC_(2247.0), SC_(244.0), SC_(523360.0), SC_(196.0), SC_(0.3207117524333373804472466964379004017279524097349140064265211915961009103874638223531923248219964356e-416), SC_(1.0), SC_(0.3078708498475722772354842060560173463473806269237782109473201559051065839953676331591702756189661043e-419) }}, 
      {{ SC_(2247.0), SC_(244.0), SC_(1030167.0), SC_(234.0), SC_(0.1069409998138717779538729532782561974627862590374161008382049824129716516057182525242637418273479363e-610), SC_(1.0), SC_(0.8912449008070581454968153248825006406530887295216882790166659995650215624203237447572351106580262605e-615) }}, 
      {{ SC_(2247.0), SC_(244.0), SC_(2063277.0), SC_(37.0), SC_(0.1231278149905970038270535261726950317064361083135735434089619700177362382395922283506042675394281346e-65), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999927663122475563485975437724757864), SC_(0.7233687752443651402456227524213568940411258324374571535490495545736207201192401431714066773123902549e-68) }}, 
      {{ SC_(2247.0), SC_(244.0), SC_(2427690.0), SC_(233.0), SC_(0.2094811591421034366575751196182891823114878306567748857673853990572758801008033748855272488668366491e-693), SC_(1.0), SC_(0.8177250808274884749254488551505231730626868202746795232139450794439198497833391710389862625405840424e-698) }}, 
      {{ SC_(2247.0), SC_(312.0), SC_(6337.0), SC_(273.0), SC_(0.2289183521935941942114189364424587510213156576596881480597549092223996288512188203641212098063522993e-84), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999829844385069178), SC_(0.1701556149308218744623516415781255598454577374936446679098316309571233328655799454147810524064556604e-85) }}, 
      {{ SC_(2247.0), SC_(312.0), SC_(10473.0), SC_(83.0), SC_(0.004704702479058171449127758718396389902584501518830619261224555698666477248992343766050109918099494367), SC_(0.9884006871986439630146174436787954386340689080895412526335342371337514688214393690247053859009712937), SC_(0.01159931280135603698538255632120456136593109191045874736646576286624853117856063097529461409902870628) }}, 
      {{ SC_(2247.0), SC_(312.0), SC_(19470.0), SC_(96.0), SC_(0.2526574447912911405332692332773109663284537559623086699616497607231000217235438214645426528290711336e-19), SC_(0.9999999999999999999901757000481785809008733700888112221775305224175969940960022295693389603217586724), SC_(0.9824299951821419099126629911188777822469477582403005903997770430661039678241327563297472213777258275e-20) }}, 
      {{ SC_(2247.0), SC_(312.0), SC_(50688.0), SC_(179.0), SC_(0.260713016581875737420798842857107303291815107403820173878977599404773289983594365459630396419819084e-156), SC_(1.0), SC_(0.8511881021589819672908058868025520284096135959757651909634067068957773663985023823328271057580413325e-158) }}, 
      {{ SC_(2247.0), SC_(312.0), SC_(130605.0), SC_(210.0), SC_(0.6247065434048705569102612041536585861577626681747983200340002767881937092691402305838522663211698235e-291), SC_(1.0), SC_(0.4832816218639174123474369443730187887452339049371618719362329230864928882691169021906008710822751955e-293) }}, 
      {{ SC_(2247.0), SC_(312.0), SC_(256574.0), SC_(27.0), SC_(0.126725009935560091667697775430288564183394920483105960411742735883228553699687841273164946172333133e-17), SC_(0.9999999999999999998767772929014511581144224184009004803579335579709929615668413280028421453063261865), SC_(0.1232227070985488418855775815990995196420664420290070384331586719971578546936738134531769832719780203e-18) }}, 
      {{ SC_(2247.0), SC_(312.0), SC_(523360.0), SC_(176.0), SC_(0.360918913330440523376092391773708504834110315941016972880051941245731258793927443376177017307673395e-328), SC_(1.0), SC_(0.110572376743857758286027185694330739126096812360373735488916402356366732732426544492963412702124459e-330) }}, 
      {{ SC_(2247.0), SC_(312.0), SC_(1030167.0), SC_(170.0), SC_(0.4385568054398624027974912346111465459917896550426275691243337867179737099013279242948488834034148583e-363), SC_(1.0), SC_(0.7371817021727781808552180797714145650351020133680290228557253226195263740944380263171526231772791534e-366) }}, 
      {{ SC_(2247.0), SC_(312.0), SC_(2063277.0), SC_(263.0), SC_(0.3130213474882863293222787454942752608914971442832023536140229972717859882276136661496528870432212644e-728), SC_(1.0), SC_(0.559383012247739851099670316302119147156590356849363389830354018517210940437210593900918593403633216e-732) }}, 
      {{ SC_(2247.0), SC_(312.0), SC_(2427690.0), SC_(135.0), SC_(0.9210063200021943226901800227919243440999297687220643811536244703442738293591591685973248587326816511e-320), SC_(1.0), SC_(0.104500223314501065388202074920940574542315097933462004286010304272883431419910417449397993165648886e-322) }}, 
      {{ SC_(2247.0), SC_(835.0), SC_(6337.0), SC_(300.0), SC_(0.02948806341703268433573851220881365920996069137623497101050485860125044357977669617284891340453683678), SC_(0.6352306176817483669003412319883376414699252604135056786377507861658623184537147666809558724889667301), SC_(0.3647693823182516330996587680116623585300747395864943213622492138341376815462852333190441275110332699) }}, 
      {{ SC_(2247.0), SC_(835.0), SC_(10473.0), SC_(706.0), SC_(0.3064244605356512021282828440789441193528155523432587739443209890298918173802856123898150222067035199e-370), SC_(1.0), SC_(0.1101806766682204087299428535470974729004372313962543088250766058269905681350253714848559493104205076e-371) }}, 
      {{ SC_(2247.0), SC_(835.0), SC_(19470.0), SC_(183.0), SC_(0.1070428153547109526379557203110372255669840336653228972136618739026034896735246678961408068540990522e-17), SC_(0.9999999999999999991630386281689678145409027022005609681354041706988230978794309799629661468390101787), SC_(0.8369613718310321854590972977994390318645958293011769021205690200370338531609898213095995514875723752e-18) }}, 
      {{ SC_(2247.0), SC_(835.0), SC_(50688.0), SC_(215.0), SC_(0.721619036757549650614033357178840499819677985159769241617735214510106387920755286974772976132678027e-101), SC_(1.0), SC_(0.1001311756278272676167887005304646863635219395811906836833241673743276676026548073168608797367736026e-101) }}, 
      {{ SC_(2247.0), SC_(835.0), SC_(130605.0), SC_(137.0), SC_(0.9069641716121371882846531164373641430611804940549110463064825208167725504941821667453530221049925637e-88), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999917336654181), SC_(0.8266334581941623668798941187142296637242560596221834380666317724895407166482487405711968236504297057e-89) }}, 
      {{ SC_(2247.0), SC_(835.0), SC_(256574.0), SC_(93.0), SC_(0.2697367477313786548267686655511506343851974427272967856365370270486445439545339202951593535522302314e-69), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999806327915684934648076550018876), SC_(0.193672084315065351923449981123848563937631257125441915976861815696704523949386380540318787307788306e-70) }}, 
      {{ SC_(2247.0), SC_(835.0), SC_(523360.0), SC_(334.0), SC_(0.6152941857826512534431366135865897693575010516905640087557661692042036387309755573897690813634726239e-560), SC_(1.0), SC_(0.3399817597022980098024577166362855537437453972055229032748752468943909694309282690749659885723686841e-562) }}, 
      {{ SC_(2247.0), SC_(835.0), SC_(1030167.0), SC_(417.0), SC_(0.6954403361056440738018027172602658122508270965053388024381723121634980293275152828155845662883661761e-878), SC_(1.0), SC_(0.1240788943744052815057347227905629843609409809083034038821972393007393454695420400511073549617188087e-880) }}, 
      {{ SC_(2247.0), SC_(835.0), SC_(2063277.0), SC_(156.0), SC_(0.1906382178661436287269400406132824502227343226835871716473417932060990732324631106829933062763987555e-291), SC_(1.0), SC_(0.8404022237276350578179072905824728300388246035223819889362651229407105366159269861987858150488081226e-294) }}, 
      {{ SC_(2247.0), SC_(835.0), SC_(2427690.0), SC_(284.0), SC_(0.1298957929783942532306922525782931944327720344256120509591530544108027770824896191892694690783178589e-638), SC_(1.0), SC_(0.2036131468864666312237360302865200146464702665009177470007788733797343537882725719461098449090278413e-641) }}, 
      {{ SC_(2247.0), SC_(1339.0), SC_(6337.0), SC_(87.0), SC_(0.3019126700279849939794231535410437759120003397700534942825423391718697877888387194586360687312609806e-166), SC_(0.3321613225067623607223516710203693378555068318582643627939984088101413953433885078815993354297383914e-166), SC_(1.0) }}, 
      {{ SC_(2247.0), SC_(1339.0), SC_(10473.0), SC_(824.0), SC_(0.1715845120845210648933482006916414196383994281483455127191503195039921200750763570928937331185492768e-262), SC_(1.0), SC_(0.223234959672122620738462121087885404699247288793164633864474333677146849141632428239520016858585487e-263) }}, 
      {{ SC_(2247.0), SC_(1339.0), SC_(19470.0), SC_(21.0), SC_(0.8895448790986852969650597839751327048415793227943615220911544441181208560050239082726367656823914826e-46), SC_(0.1002874681886419401759649789426910975174138578861162810535259847769121414172237263393447374227845918e-45), SC_(0.9999999999999999999999999999999999999999999998997125318113580598240350210573089024825861421138837189) }}, 
      {{ SC_(2247.0), SC_(1339.0), SC_(50688.0), SC_(437.0), SC_(0.6681992635909168666908713712106801184932738243127920790103006390007163820317729509858633217211793362e-259), SC_(1.0), SC_(0.5682768474006668985445614572637207370952635446533841727696321198962793175306414917564067009330333213e-260) }}, 
      {{ SC_(2247.0), SC_(1339.0), SC_(130605.0), SC_(1188.0), SC_(0.2238663746871430110863132898775916777341196615664067049308084766451835909500964251867136766358868103e-2060), SC_(1.0), SC_(0.2350805901712722853090381105995098749762326247762938234556672383152618071706229895467604662049490883e-2063) }}, 
      {{ SC_(2247.0), SC_(1339.0), SC_(256574.0), SC_(1136.0), SC_(0.6477571481160961484250970820856557401879974596393201993632228102215822673031848685488227874065801214e-2244), SC_(1.0), SC_(0.506000915160294922424250095474095727149592579170553899166610629422390746742338730801683564383061942e-2247) }}, 
      {{ SC_(2247.0), SC_(1339.0), SC_(523360.0), SC_(138.0), SC_(0.6903326252859001286849537170127801232064075646854987150382824989710852436956551339622518752800801052e-139), SC_(1.0), SC_(0.2506624783379198598294114008431176184401566261662979995840080702599570825893222102933716074961833895e-140) }}, 
      {{ SC_(2247.0), SC_(1339.0), SC_(1030167.0), SC_(566.0), SC_(0.6082998227176892441239416408930848698979290783202324047261913483647200996374750801639982941344056017e-1146), SC_(1.0), SC_(0.1360239332964686436906297436804962920178622512785704450274790049414269612388033294709224974077418961e-1148) }}, 
      {{ SC_(2247.0), SC_(1339.0), SC_(2063277.0), SC_(1317.0), SC_(0.1437483586925705305927318520852519090819816034951390804499834662119997538072923981866633932529076085e-4069), SC_(1.0), SC_(0.1082720456421097570257887575013103209095179766490239258320030970440493215986848959929549241300529717e-4074) }}, 
      {{ SC_(2247.0), SC_(1339.0), SC_(2427690.0), SC_(389.0), SC_(0.8609310750962804079168522699286404055025559921171467997291516011188357834808049080897574205509849437e-847), SC_(1.0), SC_(0.1610126796934753476478921750012906645034177365210837552680170447966268659199386703692144012548597013e-849) }}, 
      {{ SC_(2247.0), SC_(2247.0), SC_(6337.0), SC_(638.0), SC_(0.3791512846679541642289907424727887797152494457960913478172193982899222662249559093784889567574159577e-18), SC_(0.9664055218440404845316809759109428221960648524141100755648982859119252574153280669531647299016725015e-18), SC_(0.999999999999999999033594478155959515468319024089057177803935147585889924435101714088074742584671933) }}, 
      {{ SC_(2247.0), SC_(2247.0), SC_(10473.0), SC_(1930.0), SC_(0.2032130269328375279151608277233373700947785267346097242549848736605999286010295539884040032091477906e-1385), SC_(1.0), SC_(0.1345729853579641053184846528881398549148428376669067253728449336816301546049542211993444641605358906e-1387) }}, 
      {{ SC_(2247.0), SC_(2247.0), SC_(19470.0), SC_(1950.0), SC_(0.1172318745504654394878894989531679824938893105295292382401158322762109987641752479766827852396749388e-1992), SC_(1.0), SC_(0.3139600575606466138215684014418576538846433169687426321556577857453011246675117544743937155180852278e-1995) }}, 
      {{ SC_(2247.0), SC_(2247.0), SC_(50688.0), SC_(480.0), SC_(0.8178987678281922498384622007507793757945161716914830481703330656959137791922123884413207573527760464e-196), SC_(1.0), SC_(0.1320427883300680989266987337127972659616788213940974296066568557698373423771021474366883983802694577e-196) }}, 
      {{ SC_(2247.0), SC_(2247.0), SC_(130605.0), SC_(302.0), SC_(0.6959929199894771181442453397965893632687019064965077404039664623275418259495139536991682575789966385e-171), SC_(1.0), SC_(0.7623249195348577458445456787687790039136092914434413540123058747581510953819941463181937283492496961e-172) }}, 
      {{ SC_(2247.0), SC_(2247.0), SC_(256574.0), SC_(635.0), SC_(0.2620178745014622558281982442624037550115738999381991084584959010456664070674669526525046214460638673e-774), SC_(1.0), SC_(0.430555889332938126621757642780337649023919692932476143224178267042078246512674361166672331830185666e-776) }}, 
      {{ SC_(2247.0), SC_(2247.0), SC_(523360.0), SC_(758.0), SC_(0.1314288728332476179003692727678745967661447235940846380360534361317661721701474861079553891189139096e-1236), SC_(1.0), SC_(0.7430022105271453831680864662221366797785641471154195115130353698149695392194058759131858975214059771e-1239) }}, 
      {{ SC_(2247.0), SC_(2247.0), SC_(1030167.0), SC_(1635.0), SC_(0.6420423929295372497620496364510509042510728991516169767884295479287001264299973321616575742716617789e-4145), SC_(1.0), SC_(0.1431128321008358847363612995509809029788626271188873648295458702035182621805712777381646593434910125e-4148) }}, 
      {{ SC_(2247.0), SC_(2247.0), SC_(2063277.0), SC_(1703.0), SC_(0.3656207725056775965236288933952161205969250650245331286944943219981706395759873566074988812686594066e-4911), SC_(1.0), SC_(0.3081950384907155010667747225068327189342354940142960220930266759244869813247744583942167736818249016e-4915) }}, 
      {{ SC_(2247.0), SC_(2247.0), SC_(2427690.0), SC_(2162.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.1527978215032293192365904125989012456915733863632512884666738201831137390038682299553338292561912781e-7219))), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.210437457760999598884326987601636894905850233465146310254828507989206975112224126654426077074407763e-7225))) }}, 
      {{ SC_(6337.0), SC_(3.0), SC_(10473.0), SC_(1.0), SC_(0.2831210166665693515297756414013373367417418453187539845091606454867305392404794311327016711132090281), SC_(0.3446865462494212635398799232146627036393464315345095456033098279832927426606120895043069895279166249), SC_(0.6553134537505787364601200767853372963606535684654904543966901720167072573393879104956930104720833751) }}, 
      {{ SC_(6337.0), SC_(3.0), SC_(19470.0), SC_(1.0), SC_(0.4442923607448364258928151017923742447731552860384267616293183109341558734931947701153251293996691202), SC_(0.7511674850907649466649236232607697109830496661852145059328572484375171261805410710139803434413847174), SC_(0.2488325149092350533350763767392302890169503338147854940671427515624828738194589289860196565586152826) }}, 
      {{ SC_(6337.0), SC_(3.0), SC_(50688.0), SC_(3.0), SC_(0.001953240553553594360828622025326401075681097409553902095619322342291818670162726868104313963641051649), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(6337.0), SC_(3.0), SC_(130605.0), SC_(1.0), SC_(0.1317803479093094023799089958108248185755389294332986464348348793868511941468266519040967764781060603), SC_(0.993166740697602611371638587806404057179921687045117572207871074092533896278218109439499657850449333), SC_(0.006833259302397388628361412193595942820078312954882427792128925907466103721781890560500342149550666998) }}, 
      {{ SC_(6337.0), SC_(3.0), SC_(256574.0), SC_(3.0), SC_(0.1505957231269465837355495685905871438978635420544793184260551657231077489676592494898101485328012531e-4), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(6337.0), SC_(3.0), SC_(523360.0), SC_(1.0), SC_(0.03545069530841769450599643930925880304774356191626329955127903637156967053576325340669091812054901297), SC_(0.9995637845227370270600327892178535960911091989426357890206303929336625268247910894318983880678504081), SC_(0.0004362154772629729399672107821464039088908010573642109793696070663374731752089105681016119321495919389) }}, 
      {{ SC_(6337.0), SC_(3.0), SC_(1030167.0), SC_(2.0), SC_(0.0001128044792365640318192593944957063464746826690893504194908046074434937196191663090026488113805506142), SC_(0.9999997673388563975031201224785807115440047282866919048947229278795668985656517766006570673393784251), SC_(0.232661143602496879877521419288455995271713308095105277072120433101434348223399342932660621574893969e-6) }}, 
      {{ SC_(6337.0), SC_(3.0), SC_(2063277.0), SC_(1.0), SC_(0.009157480839026989457221139854686394498271254158771169379534661028168539507470817603484493760996092343), SC_(0.9999717632053674050144005081372029862864505707036373837397085898956250395074568588113463056863559152), SC_(0.2823679463259498559949186279701371354942929636261626029141010437496049254314118865369431364408475013e-4) }}, 
      {{ SC_(6337.0), SC_(3.0), SC_(2427690.0), SC_(0.0), SC_(0.992189519028879063169640568052449483194471129518060497440135589048153789423886801701919194114420343), SC_(0.992189519028879063169640568052449483194471129518060497440135589048153789423886801701919194114420343), SC_(0.007810480971120936830359431947550516805528870481939502559864410951846210576113198298080805885579656957) }}, 
      {{ SC_(6337.0), SC_(4.0), SC_(10473.0), SC_(2.0), SC_(0.3426656660170741950893330399080942436667958609244747365520614803827936383242937298293787560980501246), SC_(0.5160193792579583610845464431687098254727443619967469138793405681746895618227589544189963675769416872), SC_(0.4839806207420416389154535568312901745272556380032530861206594318253104381772410455810036324230583128) }}, 
      {{ SC_(6337.0), SC_(4.0), SC_(19470.0), SC_(0.0), SC_(0.206979523432580339946462469146762853615652807896816308763829365049526544808386342569442798601105758), SC_(0.206979523432580339946462469146762853615652807896816308763829365049526544808386342569442798601105758), SC_(0.793020476567419660053537530853237146384347192103183691236170634950473455191613657430557201398894242) }}, 
      {{ SC_(6337.0), SC_(4.0), SC_(50688.0), SC_(3.0), SC_(0.006836592427002502791524925752806646077342989145595352616577888148602896307813917279455020507167349842), SC_(0.9997559075531970313370526094128752604436546498768449360585251496948589054067907524517594411631507858), SC_(0.0002440924468029686629473905871247395563453501231550639414748503051410945932092475482405588368492141885) }}, 
      {{ SC_(6337.0), SC_(4.0), SC_(130605.0), SC_(4.0), SC_(0.5537379538534908734663468444227557680103997850378569557882411458996367788900895487948916210789788451e-5), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(6337.0), SC_(4.0), SC_(256574.0), SC_(2.0), SC_(0.003481056053818511012367777098652884335873757299699140475746060549309167495510785917714039430775210443), SC_(0.9999408770433202672910195182461973240157774153024434873634109725185465562319952757091397672531148415), SC_(0.5912295667973270898048175380267598422258469755651263658902748145344376800472429086023274688515845952e-4) }}, 
      {{ SC_(6337.0), SC_(4.0), SC_(523360.0), SC_(0.0), SC_(0.952439251573184998609148007248860108681609115107613167504101480239510054568375362384284043492411231), SC_(0.952439251573184998609148007248860108681609115107613167504101480239510054568375362384284043492411231), SC_(0.04756074842681500139085199275113989131839088489238683249589851976048994543162463761571595650758876902) }}, 
      {{ SC_(6337.0), SC_(4.0), SC_(1030167.0), SC_(1.0), SC_(0.02415449562782861958056875696832993329472153011763023958396084359924182898972240944765766807482999681), SC_(0.9997748520722381232619230547675381791261425501485208543278411729084590183385524259783141160520287878), SC_(0.0002251479277618767380769452324618208738574498514791456721588270915409816614475740216858839479712122418) }}, 
      {{ SC_(6337.0), SC_(4.0), SC_(2063277.0), SC_(0.0), SC_(0.9877711624960006064899464919622574756251482831828673634075615166706045874409732445808288771538804876), SC_(0.9877711624960006064899464919622574756251482831828673634075615166706045874409732445808288771538804876), SC_(0.01222883750399939351005350803774252437485171681713263659243848332939541255902675541917112284611951237) }}, 
      {{ SC_(6337.0), SC_(4.0), SC_(2427690.0), SC_(3.0), SC_(0.7092375978801080162581217306394899336672258015974521443737168915893253810380969829775651437899688872e-7), SC_(0.9999999999536177609690470144689875552855105261412915813254174227956113503786663918720803593146219698), SC_(0.4638223903095298553101244471448947385870841867458257720438864962133360812791964068537803016074911926e-10) }}, 
      {{ SC_(6337.0), SC_(15.0), SC_(10473.0), SC_(7.0), SC_(0.1130542194463136365242442163752289785559654875826685268456614266644648995868309225236502267513944643), SC_(0.2011275121445204015066595287957087796952099917286468735601023127045225922405630557782420763988310799), SC_(0.7988724878554795984933404712042912203047900082713531264398976872954774077594369442217579236011689201) }}, 
      {{ SC_(6337.0), SC_(15.0), SC_(19470.0), SC_(7.0), SC_(0.1066924482848160483366828470088813226941373459130836796631564478408304697405145275082335363653306676), SC_(0.9222311138701358284351347898473778977214086587727612889025729281282127492398337497237844248287508819), SC_(0.07776888612986417156486521015262210227859134122723871109742707187178725076016625027621557517124911805) }}, 
      {{ SC_(6337.0), SC_(15.0), SC_(50688.0), SC_(14.0), SC_(0.2954255264710991019071302359741304129210332937002268954420619112432341461052946991609510717755797202e-11), SC_(0.9999999999999719213305393074996977327158040115352393453207959755186297166172158317436536751763162846), SC_(0.2807866946069250030226728419598846476065467920402448137028338278416825634632482368371541606483116609e-13) }}, 
      {{ SC_(6337.0), SC_(15.0), SC_(130605.0), SC_(9.0), SC_(0.550737552492866551260259890956646291404960704213019334196860264735129919384479812303681232923760903e-8), SC_(0.9999999998277632650341022296550197921100517835157671622253804619815225270453520664779632622567656214), SC_(0.1722367349658977703449802078899482164842328377746195380184774729546479335220367377432343786314990148e-9) }}, 
      {{ SC_(6337.0), SC_(15.0), SC_(256574.0), SC_(15.0), SC_(0.7639099953874330789880975053482291888124960770930883341361961744845220307852184901209135158150388089e-24), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(6337.0), SC_(15.0), SC_(523360.0), SC_(5.0), SC_(0.690921071125122663876552772604918143579877562722041215422416225784085836923394550548987593563249709e-6), SC_(0.9999999856720772184612809047089530190553797538959498706260295388447382229294219424257780986166045394), SC_(0.143279227815387190952910469809446202461040501293739704611552617770705780575742219013833954606138443e-7) }}, 
      {{ SC_(6337.0), SC_(15.0), SC_(1030167.0), SC_(14.0), SC_(0.1632600107770404111089868159335485765372632528290768958141327594368603237043769573117720691094392904e-29), SC_(0.9999999999999999999999999999999993278226215008178314484998244188796646284926549405967707967394071021), SC_(0.6721773784991821685515001755811203353715073450594032292032605928979479411244474596577681672758875839e-33) }}, 
      {{ SC_(6337.0), SC_(15.0), SC_(2063277.0), SC_(2.0), SC_(0.0009515067220747225030339286501068161495277166602392117264901005773693945848451983410030999897707021862), SC_(0.9999871831245155505778439613109676184723238185746459554398752327981408903697635584762063562809007093), SC_(0.1281687548444942215603868903238152767618142535404456012476720185910963023644152379364371909929070188e-4) }}, 
      {{ SC_(6337.0), SC_(15.0), SC_(2427690.0), SC_(10.0), SC_(0.4322310483788055298602185154122454234855402221796351538396781061687286425422697578238495155100247149e-22), SC_(0.9999999999999999999999999486178825092851279482925619887071829985789838277336256760770874983005813806), SC_(0.5138211749071487205170743801129281700142101617226637432392291250169941861941453159686706518209854672e-25) }}, 
      {{ SC_(6337.0), SC_(29.0), SC_(10473.0), SC_(27.0), SC_(0.8000971815888311366794302234569194479497592125847113054431466101609413101611868016982661695832379058e-4), SC_(0.9999908202315059514106349780047604110266975681817626289288376180787053792427715110576390122918787512), SC_(0.9179768494048589365021995239588973302431818237371071162381921294620757228488942360987708121248845388e-5) }}, 
      {{ SC_(6337.0), SC_(29.0), SC_(19470.0), SC_(22.0), SC_(0.1837533227920354453155188190575481533451786776677594610145118245290582638177705738845151311654057481e-5), SC_(0.9999996952595839595210003740290730573123579784832030710489583207718575747466503227308201252501231769), SC_(0.3047404160404789996259709269426876420215167969289510416792281424252533496772691798747498768230641845e-6) }}, 
      {{ SC_(6337.0), SC_(29.0), SC_(50688.0), SC_(23.0), SC_(0.3508981464166022602578691051742318916128131679004574740321372594198769771277295651188898775360616668e-15), SC_(0.9999999999999999871462277399565717492793782621830959984226878156502154827834227520320246743919547605), SC_(0.1285377226004342825072062173781690400157731218434978451721657724796797532560804523953249465061237824e-16) }}, 
      {{ SC_(6337.0), SC_(29.0), SC_(130605.0), SC_(5.0), SC_(0.009672964030541456728977912205004679727319902616963628926910330784285793128014271956317378110158898269), SC_(0.9976456076564854965077965915499607598493175299206532885351339671724193911469381454622455295499913614), SC_(0.002354392343514503492203408450039240150682470079346711464866032827580608853061854537754470450008638613) }}, 
      {{ SC_(6337.0), SC_(29.0), SC_(256574.0), SC_(8.0), SC_(0.3502373450903507004264907271617632667477593704818241669060349713040853975765397593087452327076772318e-6), SC_(0.9999999782362067198981421661249322467565503332524144426614746637197749267566733273316686423306434792), SC_(0.2176379328010185783387506775324344966674758555733852533628022507324332667266833135766935652084905433e-7) }}, 
      {{ SC_(6337.0), SC_(29.0), SC_(523360.0), SC_(27.0), SC_(0.6568072179202880514938721375482147284493024100365709983349563199447861974034674390469756308460030566e-49), SC_(0.999999999999999999999999999999999999999999999999999942718692842168579247072760666838702493867457666), SC_(0.5728130715783142075292723933316129750613254233397762598471080089178015961678292760371694491338577611e-52) }}, 
      {{ SC_(6337.0), SC_(29.0), SC_(1030167.0), SC_(21.0), SC_(0.1463812481855588910350609354973426610826903163313560388836685248799831879123577638495977086331443152e-39), SC_(0.9999999999999999999999999999999999999999996710076830784761967310858669625683045104061679364073346985), SC_(0.3289923169215238032689141330374316954895938320635926653015446154033098462686926160901630207506185271e-42) }}, 
      {{ SC_(6337.0), SC_(29.0), SC_(2063277.0), SC_(21.0), SC_(0.6942385018129389715306873443817234247542278238012886352354496727503405130884093396927619979248048256e-46), SC_(0.9999999999999999999999999999999999999999999999999224103317550551222546979031203076308722735130544326), SC_(0.7758966824494487774530209687969236912772648694556739026662815723721087509465419869767486610187337927e-49) }}, 
      {{ SC_(6337.0), SC_(29.0), SC_(2427690.0), SC_(27.0), SC_(0.6805850558594621754655088303068317574275120818875037794075061245945358928054153017872449534212627584e-67), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999873303440438702334203596729373), SC_(0.1266965595612976657964032706267927178618019688814263015398365541460383822926806347929494386415701305e-70) }}, 
      {{ SC_(6337.0), SC_(36.0), SC_(10473.0), SC_(24.0), SC_(0.104565231080610598551908854214037583323152257898195109698435980899605335481613123136844425343345238), SC_(0.8227760243766143882787876661340752913682970939375153123325056926376359380581253833062548622406910472), SC_(0.1772239756233856117212123338659247086317029060624846876674943073623640619418746166937451377593089528) }}, 
      {{ SC_(6337.0), SC_(36.0), SC_(19470.0), SC_(6.0), SC_(0.01710905588493007724845541420693107462463551488449129227956599647995960049511542424961024018991754757), SC_(0.02684593592949819474683958054863363349141740922754970372156133156504550567620590559771754285983036638), SC_(0.9731540640705018052531604194513663665085825907724502962784386684349544943237940944022824571401696336) }}, 
      {{ SC_(6337.0), SC_(36.0), SC_(50688.0), SC_(36.0), SC_(0.2840339323714860725693787215469565301487825764942487686961732090424529670253942504316760234855334893e-32), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(6337.0), SC_(36.0), SC_(130605.0), SC_(33.0), SC_(0.2455967667976531758548777089554712099724068340449880195095700650971322949577895289878705193158517153e-39), SC_(0.9999999999999999999999999999999999999999988974772474515104260300216592320327581664968716348379275841), SC_(0.1102522752548489573969978340767967241833503128365162072415916071082373370786579932175756007707238309e-41) }}, 
      {{ SC_(6337.0), SC_(36.0), SC_(256574.0), SC_(30.0), SC_(0.9455616240975181530237893975284661473454826716241560814284840060877872724054486038858574343647797629e-42), SC_(0.9999999999999999999999999999999999999999999953690370802945108243609785054964455698081324436830180495), SC_(0.4630962919705489175639021494503554430191867556316981950495785436519783897190968192722921506060173886e-44) }}, 
      {{ SC_(6337.0), SC_(36.0), SC_(523360.0), SC_(30.0), SC_(0.5259517729855745695686335003788126651739190751351098999812434303419699991227054547013138605239465493e-51), SC_(0.9999999999999999999999999999999999999999999999999999987558270868574094274769652681128743646442409064), SC_(0.1244172913142590572523034731887125635355759093569420631623292474918601739705824746893824297655865274e-53) }}, 
      {{ SC_(6337.0), SC_(36.0), SC_(1030167.0), SC_(23.0), SC_(0.2872407059610467990783081439546795668841127073679920011473659627354290100664691498505954150648442083e-41), SC_(0.9999999999999999999999999999999999999999999903761961120282780817064881349925155123123916769083491358), SC_(0.9623803887971721918293511865007484487687608323091650864244678780926575613228897687874899346234186364e-44) }}, 
      {{ SC_(6337.0), SC_(36.0), SC_(2063277.0), SC_(4.0), SC_(0.4745961658612397279583955810312798587940031377060814787967159652084382423645375836889525299018828607e-5), SC_(0.9999999049740028582579653875949281139885967934202330720141175613708986087875175903366869537615504821), SC_(0.950259971417420346124050718860114032065797669279858824386291013912124824096633130462384495179263034e-7) }}, 
      {{ SC_(6337.0), SC_(36.0), SC_(2427690.0), SC_(3.0), SC_(0.0001164455829982699223857805563230004423198170730678121719778090151783982726227761806718555665501945182), SC_(0.9999974442995337259436905890677129525345594929633702558562260238406875011189562212314621383794809695), SC_(0.2555700466274056309410932287047465440507036629744143773976159312498881043778768537861620519030504205e-5) }}, 
      {{ SC_(6337.0), SC_(126.0), SC_(10473.0), SC_(36.0), SC_(0.211245793950687655490146215032342029149428141049770882284503343030564614846871746347742744980380699e-12), SC_(0.2819498727915717000637903985949953609289154438216205201094549110529065822445745269080855196527607413e-12), SC_(0.9999999999997180501272084282999362096014050046390710845561783794798905450889470934177554254730919145) }}, 
      {{ SC_(6337.0), SC_(126.0), SC_(19470.0), SC_(46.0), SC_(0.04739479652623212266205317608927631860836464205617510872409578456623518002579574958089365119909267574), SC_(0.8523287662269307266706427356360713158117261007598888775592342447063934650062965485717658814813509868), SC_(0.1476712337730692733293572643639286841882738992401111224407657552936065349937034514282341185186490132) }}, 
      {{ SC_(6337.0), SC_(126.0), SC_(50688.0), SC_(53.0), SC_(0.8845448756119097661657812786046929800405989546100320407615524523429842636462850515743907467617488206e-16), SC_(0.9999999999999999791919284826384648594445978501190223501238652411599195097186564562350028444029728648), SC_(0.2080807151736153514055540214988097764987613475884008049028134354376499715559702713519574262179725799e-16) }}, 
      {{ SC_(6337.0), SC_(126.0), SC_(130605.0), SC_(112.0), SC_(0.1810104673320174214505923482586953021844820822057670814135505343097003705264392884366648184366038205e-129), SC_(1.0), SC_(0.1129965963254789862857848824581895497008012889002155830779504729011835155524077548458896044482866293e-131) }}, 
      {{ SC_(6337.0), SC_(126.0), SC_(256574.0), SC_(84.0), SC_(0.1016625849609676658264184658005937238336545771265920666426670131657425874614464334354000328956732479e-101), SC_(1.0), SC_(0.1270580402920299362071928647961779748384102935990708969732792930696934117547577021201530165958221264e-103) }}, 
      {{ SC_(6337.0), SC_(126.0), SC_(523360.0), SC_(110.0), SC_(0.3171755284264603159930358382204271932279060135500066834553636410636634725852311048020855589161299459e-191), SC_(1.0), SC_(0.551542768764691418110269928218807215416437999228820636028354978889817959645265430672875498621269416e-194) }}, 
      {{ SC_(6337.0), SC_(126.0), SC_(1030167.0), SC_(13.0), SC_(0.1518759827274882797064750138417735192024139684265917215121070129279588159605373886335089589983910415e-11), SC_(0.9999999999999206247499484496227931878239213294675581328234636127090425693172912683145557380645004759), SC_(0.793752500515503772068121760786705324418671765363872909574306827087316854442619354995240604753126164e-13) }}, 
      {{ SC_(6337.0), SC_(126.0), SC_(2063277.0), SC_(22.0), SC_(0.7559663765479279371717096182444053498599162063232602732064226538104193309700151185576999141643699691e-31), SC_(0.9999999999999999999999999999999989365006497275223389690251295561202759794887369649010732828636683881), SC_(0.1063499350272477661030974870443879724020511263035098926717136331611867566240384617059500415767993084e-32) }}, 
      {{ SC_(6337.0), SC_(126.0), SC_(2427690.0), SC_(17.0), SC_(0.4126551824607759751323558656966073496261946806862691105980629470954296178154214719068183177213747787e-23), SC_(0.9999999999999999999999999337928707158399179207661617160268566825726226183847120874817595701801456333), SC_(0.6620712928416008207923383828397314331742737738161528791251824042981985436670038773455128813601305285e-25) }}, 
      {{ SC_(6337.0), SC_(244.0), SC_(10473.0), SC_(222.0), SC_(0.1766851791129837630038590167875015219329778583220595782630146207513645850951313103186787716896035377e-26), SC_(0.9999999999999999999999999996994682070131759773923476026941443905031891578148619208356578402101568857), SC_(0.3005317929868240226076523973058556094968108421851380791643421597898431143100198748482092695084791529e-27) }}, 
      {{ SC_(6337.0), SC_(244.0), SC_(19470.0), SC_(93.0), SC_(0.009669707716055344568155477252268907627104421255136872682273779841021642534538452242585238450911954372), SC_(0.972419230218082143138171455932252379235377023352390393849523715849169586097408721376013706641290571), SC_(0.02758076978191785686182854406774762076462297664760960615047628415083041390259127862398629335870942904) }}, 
      {{ SC_(6337.0), SC_(244.0), SC_(50688.0), SC_(128.0), SC_(0.22116919009670436247681040939306756888952844808054252109952931211043137863410760980018818362937808e-50), SC_(0.9999999999999999999999999999999999999999999999999996813874478995993113806513183748432648354880415764), SC_(0.3186125521004006886193486816251567351645119584235629345936218927042657382199232505392854736423798554e-51) }}, 
      {{ SC_(6337.0), SC_(244.0), SC_(130605.0), SC_(145.0), SC_(0.8989248367936958781664536006926582717941558907227075461641555366183788758359573312034744954061442335e-123), SC_(1.0), SC_(0.3144069725582176589763425958455166620642833205000266866380801331800101612064927698983174328162304945e-124) }}, 
      {{ SC_(6337.0), SC_(244.0), SC_(256574.0), SC_(8.0), SC_(0.1050805117501903813422623208743323793200603327280055339250857425043927289173668437739662717607421938), SC_(0.8471794580805884941438624543737677232549813316782577634849831683895735357495912574910245145599420919), SC_(0.1528205419194115058561375456262322767450186683217422365150168316104264642504087425089754854400579081) }}, 
      {{ SC_(6337.0), SC_(244.0), SC_(523360.0), SC_(65.0), SC_(0.3204292760765245500029297179928116682530573779905668993726601651210809703903085618655637340649473705e-65), SC_(0.9999999999999999999999999999999999999999999999999999999999999999998910299701850951460854571561356546), SC_(0.1089700298149048539145428438643454187070338262823850315292544110706027576823143724912696279903142799e-66) }}, 
      {{ SC_(6337.0), SC_(244.0), SC_(1030167.0), SC_(164.0), SC_(0.110026629345970771160942388845778292997721897327315102360103827814963590095211530276175666866394343e-297), SC_(1.0), SC_(0.3225919755209843050210672854656519011968274699560749695220964721571641489750494250505257085956945199e-300) }}, 
      {{ SC_(6337.0), SC_(244.0), SC_(2063277.0), SC_(22.0), SC_(0.2869660597202076462594519057605250417664232733047991986079327026724119664162619924422342129985153524e-24), SC_(0.9999999999999999999999999912483138708200436615367403934903819986113927474017311421505528148496071202), SC_(0.8751686129179956338463259606509618001388607252598268857849447185150392879765910157065769727641279668e-26) }}, 
      {{ SC_(6337.0), SC_(244.0), SC_(2427690.0), SC_(113.0), SC_(0.2379732058121924952919116327225356623153046420001708661975210827675138436722118683049813479768563087e-220), SC_(1.0), SC_(0.7050061196796296213364435367210097834375041355782131981474708444989451911443855026074662617377048635e-223) }}, 
      {{ SC_(6337.0), SC_(312.0), SC_(10473.0), SC_(4.0), SC_(0.2397201812124978671277263955805266097296086733307845591374071041660536527497981425045334475987378217e-119), SC_(0.2416066141327377461624089182940374979692965233747381691512630421320743215921530987963670968962858772e-119), SC_(1.0) }}, 
      {{ SC_(6337.0), SC_(312.0), SC_(19470.0), SC_(253.0), SC_(0.7273462552895201705957272248959187083349444277932596502385376031028019768805545138070411039751183487e-70), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999912108088056329629838344605103), SC_(0.8789191194367037016165539489735572879880976521465480105377017358451286647779026082145427819213881983e-71) }}, 
      {{ SC_(6337.0), SC_(312.0), SC_(50688.0), SC_(121.0), SC_(0.3479189277009725523362255397341863728911630216174234358417969497228299345522864450295381888028499989e-31), SC_(0.9999999999999999999999999999999902133559391689063066830754478315709361532344600999453105306311037766), SC_(0.9786644060831093693316924552168429063846765539900054689469368896223439263045249108722284188665195595e-32) }}, 
      {{ SC_(6337.0), SC_(312.0), SC_(130605.0), SC_(307.0), SC_(0.5462615746226550860825905453369216011989400245152560703696356044324216260933314477243644357640419909e-396), SC_(1.0), SC_(0.430590780097692018774235304275097808142885518738614945844211796686649234206256780398136109213020428e-399) }}, 
      {{ SC_(6337.0), SC_(312.0), SC_(256574.0), SC_(303.0), SC_(0.4111632834382996919136131454081776573400319581009053871842071653693137038664202260583127325453255278e-473), SC_(1.0), SC_(0.2937146604739114879598443825173333852651864423984738396493000738633404828120032297661124799746200959e-476) }}, 
      {{ SC_(6337.0), SC_(312.0), SC_(523360.0), SC_(238.0), SC_(0.2601148478597411683377980223969956599973087160649841380474240700621864082359036776275178674433134363e-385), SC_(1.0), SC_(0.95360824083641342236130234202441746119206185882940939404341476024296042026057854573350120220779832e-388) }}, 
      {{ SC_(6337.0), SC_(312.0), SC_(1030167.0), SC_(54.0), SC_(0.1061058462746980702174456213023099783708661731758903068816711862496945263567381055358189395640657069e-58), SC_(0.9999999999999999999999999999999999999999999999999999999999996856274591994718530738541236564930683104), SC_(0.3143725408005281469261458763435069316896038379629157919071866598438497838867987869990382439149929231e-60) }}, 
      {{ SC_(6337.0), SC_(312.0), SC_(2063277.0), SC_(152.0), SC_(0.4036423535438136731548459576376918505037511414228140447114532245841883025744493676576102413634430547e-290), SC_(1.0), SC_(0.127328944232513955557648679057245069936387047958014885188475091722597149687917558032387913592583046e-292) }}, 
      {{ SC_(6337.0), SC_(312.0), SC_(2427690.0), SC_(303.0), SC_(0.8054007402241377317057417060319879239909072532153837741099189996271398806748103314638631930925329567e-769), SC_(1.0), SC_(0.5942346416680865775635673732892520668275812643955431191559282577831433456161978642135279906115327028e-773) }}, 
      {{ SC_(6337.0), SC_(835.0), SC_(10473.0), SC_(514.0), SC_(0.02397561400612251111596642689449768547018109087908577092198158938706252400192622626653276361129024018), SC_(0.7523969656695764363597042100393350206885259963461702721332198067659013356016804793135289335095271537), SC_(0.2476030343304235636402957899606649793114740036538297278667801932340986643983195206864710664904728463) }}, 
      {{ SC_(6337.0), SC_(835.0), SC_(19470.0), SC_(662.0), SC_(0.124309543787366211216130766978082115936076070420132556466625751377449087005570513365003965459769085e-176), SC_(1.0), SC_(0.1601690457560248252539160035360707838302772657576002824548491334323050558755708824128620739424330429e-177) }}, 
      {{ SC_(6337.0), SC_(835.0), SC_(50688.0), SC_(472.0), SC_(0.9246138866408689557938085675956123368154846736149037740046159593676286828619648026657962475502691308e-206), SC_(1.0), SC_(0.1053249274516485223624250774031726893730269766206775742613369321331567445811228488645290384099020188e-206) }}, 
      {{ SC_(6337.0), SC_(835.0), SC_(130605.0), SC_(635.0), SC_(0.1594101417114346546762701301102844831979897938816241059910283177254735549042239455616319623841227309e-653), SC_(1.0), SC_(0.2337391904760674794846944463820216061336866100509534584244489641503847419893939634501971170675549241e-655) }}, 
      {{ SC_(6337.0), SC_(835.0), SC_(256574.0), SC_(195.0), SC_(0.1427321873260854736664131031238103016436666210415120539238400720654092798722467955907644077058917975e-125), SC_(1.0), SC_(0.124627148040168287524763259977533904706083870949920269635946233799286669814023309041320661136743376e-126) }}, 
      {{ SC_(6337.0), SC_(835.0), SC_(523360.0), SC_(678.0), SC_(0.192144433693302399119239798220727853488630283021502908666546204537117703917364858535280401300253499e-1142), SC_(1.0), SC_(0.4876526281353170469051203567100201949711746227716797378234425978247267190063077984376998651439387432e-1145) }}, 
      {{ SC_(6337.0), SC_(835.0), SC_(1030167.0), SC_(94.0), SC_(0.1400487218555065144713691833193779582163504039208144545066375990499187861152379681691051694420041108e-83), SC_(0.999999999999999999999999999999999999999999999999999999999999999999999999999999999999930054253013704), SC_(0.6994574698629601762191754387070869476217746224650864588423403935372578428450946816480031935284640356e-85) }}, 
      {{ SC_(6337.0), SC_(835.0), SC_(2063277.0), SC_(763.0), SC_(0.1730206303364859167541315011660245806335314257452158314582478457933050492860572162628315604963913136e-1832), SC_(1.0), SC_(0.4419840355112113007960569462971107461922158136867795902404022641047894578415475693312664550063192104e-1836) }}, 
      {{ SC_(6337.0), SC_(835.0), SC_(2427690.0), SC_(328.0), SC_(0.6481654871140543521403702387314038548666033134501261108194742527230691494907642714348631114198641603e-610), SC_(1.0), SC_(0.2488792012760973691896619702955441593595860207065170447747110310754338343780692572083249039735622781e-612) }}, 
      {{ SC_(6337.0), SC_(1339.0), SC_(10473.0), SC_(1251.0), SC_(0.1227298138074849040149451537784369859447489677442482734940232004755761587055286482656548411015657785e-187), SC_(1.0), SC_(0.1186917117210754115020238609904576239146339115738541380180091808958768904279745272092079051503796116e-188) }}, 
      {{ SC_(6337.0), SC_(1339.0), SC_(19470.0), SC_(791.0), SC_(0.3579012256135384913719519194153736464058000066578783151302865119813068134212706120175466386325306044e-94), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999843344), SC_(0.1566562131416163986800009692688847118867216923846055190843077895923256028679937075057055033925076197e-94) }}, 
      {{ SC_(6337.0), SC_(1339.0), SC_(50688.0), SC_(558.0), SC_(0.7986374464246393800337857854407209356481476071726659654449296984985619909007165685110855554577243206e-162), SC_(1.0), SC_(0.1814915485679329145529242771383401817571052766625942168563574451918199057293348957923315666915795049e-162) }}, 
      {{ SC_(6337.0), SC_(1339.0), SC_(130605.0), SC_(718.0), SC_(0.8693502083047282711033756160279918480346838250939756159703911512632675156289997855143817056668152357e-573), SC_(1.0), SC_(0.3551076751490443633247835816747949431480099712222726102078555831685619349386095250902323687137993193e-574) }}, 
      {{ SC_(6337.0), SC_(1339.0), SC_(256574.0), SC_(415.0), SC_(0.1099885534118338621599888727730104444557748710134330688012668686196211429836765308165835091925502808e-323), SC_(1.0), SC_(0.6124835651387457970504549822095698352429242823836688339633015700007025550099856990894618047734358618e-325) }}, 
      {{ SC_(6337.0), SC_(1339.0), SC_(523360.0), SC_(44.0), SC_(0.4191820931474176363966984840834066683998788812234612697040084665679308747543676886717142715407267809e-8), SC_(0.9999999977717115712603215455743180512742203787002069690811280682256128142469248788752574621198144034), SC_(0.2228288428739678454425681948725779621299793030918871931774387185753075121124742537880185596623869312e-8) }}, 
      {{ SC_(6337.0), SC_(1339.0), SC_(1030167.0), SC_(354.0), SC_(0.545127313931546507969613898589634929234561873972960945458825116330960599205490082909842685127840474e-455), SC_(1.0), SC_(0.8992737598100332446130921374626109498048015869016935741294366609923450530492201882832553255280353732e-457) }}, 
      {{ SC_(6337.0), SC_(1339.0), SC_(2063277.0), SC_(772.0), SC_(0.8236560383462929140102430308953394475753131445068838100149906915845350599678333190578836462252077648e-1567), SC_(1.0), SC_(0.1638221651190896931979766701018494169481390183201912419255764031223370463939697849671813892606150108e-1569) }}, 
      {{ SC_(6337.0), SC_(1339.0), SC_(2427690.0), SC_(241.0), SC_(0.609953878766164704750661387359508054678119187040883956795095430424870385384275894640952505066736661e-353), SC_(1.0), SC_(0.7050712266668685486162298957309780639574696561442793239038606540606474935404915746982340967289834024e-355) }}, 
      {{ SC_(6337.0), SC_(2247.0), SC_(10473.0), SC_(2137.0), SC_(0.2104170158912669608475840610887030882819928173277592237559766032881625392165082992554278362929642587e-386), SC_(1.0), SC_(0.119240979281264105719172240745362052125054217052169931020669172765767599294091269715616256829318891e-387) }}, 
      {{ SC_(6337.0), SC_(2247.0), SC_(19470.0), SC_(1090.0), SC_(0.3659462571404961812169801129905599625560538793579856868386117519560999618132989915911595045305108036e-62), SC_(0.9999999999999999999999999999999999999999999999999999999999999968350202830892025396686285468611724289), SC_(0.3164979716910797460331371453138827571107483718501806279307209500579858410156721770830197678583737353e-62) }}, 
      {{ SC_(6337.0), SC_(2247.0), SC_(50688.0), SC_(663.0), SC_(0.3914540005030832337796178594305289287326556058554334333834786141680176248100867981513509918290883499e-106), SC_(1.0), SC_(0.1809708602608039845486281194324636236819278423935568598040871793073715538936962277294490959268240967e-106) }}, 
      {{ SC_(6337.0), SC_(2247.0), SC_(130605.0), SC_(1344.0), SC_(0.2329383026235004738333387144050340694978359665518154659380483360072292904953257615982558589279250661e-1189), SC_(1.0), SC_(0.6505954447076373794761777590564010482756532108877794343046866567605809714438407219172064989944140979e-1191) }}, 
      {{ SC_(6337.0), SC_(2247.0), SC_(256574.0), SC_(1881.0), SC_(0.3310342676117864054431954579119992975413204000465735932778688375287206297748300664386006449796070669e-2726), SC_(1.0), SC_(0.1152034544001732257730759761427685696405214622647718885446635625822975099278854155957505362772060699e-2728) }}, 
      {{ SC_(6337.0), SC_(2247.0), SC_(523360.0), SC_(2175.0), SC_(0.715185196723593678014021065277470708090932065541495016177714947373057273721047787828200109442233814e-4215), SC_(1.0), SC_(0.1905715206430560743728176738826230754206202503135366158195345058137987711117147063645518490097728297e-4218) }}, 
      {{ SC_(6337.0), SC_(2247.0), SC_(1030167.0), SC_(734.0), SC_(0.1698609300888673765384241852218037168449629067225214869261680250511816899079713459274728369958959274e-1030), SC_(1.0), SC_(0.193818954728779900073679728944067404627847817274684855643305342722536369369256897325223505772882547e-1032) }}, 
      {{ SC_(6337.0), SC_(2247.0), SC_(2063277.0), SC_(424.0), SC_(0.1125874166849798512429424878628304141078299824192819517644909839344035458145119922581606517852348417e-602), SC_(1.0), SC_(0.1406808818634535655104261618517453148999743687554194513746936682490395091397016290514495123862489284e-604) }}, 
      {{ SC_(6337.0), SC_(2247.0), SC_(2427690.0), SC_(443.0), SC_(0.4020652419790875229378219431936309242768339191859030416429293456026502677733062267268917183270279877e-670), SC_(1.0), SC_(0.401913395716956765433689012533309296516228599266181728989382780065231457782389098591899732235114037e-672) }}, 
      {{ SC_(6337.0), SC_(6337.0), SC_(10473.0), SC_(3512.0), SC_(0.1075158294207301010411781531538659458932338222460333703004934510542264272108473853245906808828752413e-39), SC_(0.2530733025350785248477348050571011715167560248436910021310119277706711360070744847184354227108024569e-39), SC_(0.9999999999999999999999999999999999999997469266974649214751522651949428988284832439751563089978689881) }}, 
      {{ SC_(6337.0), SC_(6337.0), SC_(19470.0), SC_(1533.0), SC_(0.2053434338376577787504764255141811656840931198063906353196009580560251118344198161195265752024622155e-68), SC_(0.4585837513963347476084213781290062906307879583288439449299823998689792923767941048950654372054776141e-68), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999954141624860366525239157862187099) }}, 
      {{ SC_(6337.0), SC_(6337.0), SC_(50688.0), SC_(5876.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.6515066163384563961717634577219344037592322980208202233566676280000099035064587249378940801448388782e-6465))), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.5372121820056628965811434917359692874695743803767926856153661889000867369365305334985537474872238863e-6468))) }}, 
      {{ SC_(6337.0), SC_(6337.0), SC_(130605.0), SC_(2780.0), SC_(0.2266781144510476905821751424706563147588960341068831608697841509373395108742421230726359302580716208e-2114), SC_(1.0), SC_(0.8877569305555708097469801159669545801080824858122910106211607733753935639057819958081870242690647487e-2116) }}, 
      {{ SC_(6337.0), SC_(6337.0), SC_(256574.0), SC_(2001.0), SC_(0.2900848799817021783347582106541251720559161237806028490509927401459835758266175011499166204133293363e-1685), SC_(1.0), SC_(0.115178399664021698658200161602457969216178981253858678525296060759286214372753749398615069418980388e-1686) }}, 
      {{ SC_(6337.0), SC_(6337.0), SC_(523360.0), SC_(1652.0), SC_(0.1897429507058017280881689418627397155452314427006952658160768306430341193774272502572599854520131886e-1709), SC_(1.0), SC_(0.5048315205298606840851698404182809753195856733746507949341338572707442087109927625277089312941640637e-1711) }}, 
      {{ SC_(6337.0), SC_(6337.0), SC_(1030167.0), SC_(5582.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.3157412878853225008829814429556694982647712064685422515600990116998872804529128707466977458661523105e-13058)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.3151323409973385424099693390050400936383991895832342882411393383196803591736643365545908226489944238e-13062)) }}, 
      {{ SC_(6337.0), SC_(6337.0), SC_(2063277.0), SC_(3795.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.3307029462850956124299085585403372779592382713739154493782255168338428908267574905716830560767895694e-8323)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2742444079959298033325930824744780413732051397065120236877882054125587366545066790536954035515611739e-8326)) }}, 
      {{ SC_(6337.0), SC_(6337.0), SC_(2427690.0), SC_(4513.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.2790484143431446955943293753525213523673713453321748617112143524188004797921239641006247685429079077e-10980))), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.8502933861884789353211170629645403171440919813867985275997464351295114414046202286918540081908776713e-10984))) }}, 
      {{ SC_(10473.0), SC_(3.0), SC_(19470.0), SC_(3.0), SC_(0.1556173310068632272396262534435913088820963646270489556137261226354336275561956691012756080869528012), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(10473.0), SC_(3.0), SC_(50688.0), SC_(1.0), SC_(0.3901826397306986710584784862073885753383652619069096382758681088433509985401516538659639091905878134), SC_(0.8895751885543590567892336141827447859141850612978055065080678688903822122737242837049787308042963254), SC_(0.1104248114456409432107663858172552140858149387021944934919321311096177877262757162950212691957036746) }}, 
      {{ SC_(10473.0), SC_(3.0), SC_(130605.0), SC_(1.0), SC_(0.2035338853923006756882000288520184386040625139162672747462517296809449641908869053567392855243697535), SC_(0.9817421559348730099580198660840428515231888322828985397536428072694676642748131950165386778066278581), SC_(0.01825784406512699004198013391595714847681116771710146024635719273053233572518680498346132219337214194) }}, 
      {{ SC_(10473.0), SC_(3.0), SC_(256574.0), SC_(0.0), SC_(0.8824741332762971170828438806113450148514674229338957865869887498630833514209597844046824574362583943), SC_(0.8824741332762971170828438806113450148514674229338957865869887498630833514209597844046824574362583943), SC_(0.1175258667237028829171561193886549851485325770661042134130112501369166485790402155953175425637416057) }}, 
      {{ SC_(10473.0), SC_(3.0), SC_(523360.0), SC_(0.0), SC_(0.9411599600545806799262242575490896386103509005114513982099172291184018506171034919123609601221164707), SC_(0.9411599600545806799262242575490896386103509005114513982099172291184018506171034919123609601221164707), SC_(0.05884003994541932007377574245091036138964909948854860179008277088159814938289650808763903987788352929) }}, 
      {{ SC_(10473.0), SC_(3.0), SC_(1030167.0), SC_(1.0), SC_(0.02988202492176240637122173232657714744181879274974732197683596568965890092353236676779071019061409523), SC_(0.9996920684152457023858571656488377104528340515605097982238145298207501549996721366244789766627951861), SC_(0.0003079315847542976141428343511622895471659484394902017761854701792498450003278633755210233372048138992) }}, 
      {{ SC_(10473.0), SC_(3.0), SC_(2063277.0), SC_(2.0), SC_(0.7689489311155991722304437201550332801026065278335566776282115953422903221407402802640006023325504087e-4), SC_(0.9999998692574602395643725618718560280904642957568776992320102739958999195148667485635448382571544586), SC_(0.1307425397604356274381281439719095357042431223007679897260041000804851332514364551617428455413522074e-6) }}, 
      {{ SC_(10473.0), SC_(3.0), SC_(2427690.0), SC_(0.0), SC_(0.9871138131809814543241810357019805731135656060793022716471284526093310615852037527134746110662442827), SC_(0.9871138131809814543241810357019805731135656060793022716471284526093310615852037527134746110662442827), SC_(0.01288618681901854567581896429801942688643439392069772835287154739066893841479624728652538893375571728) }}, 
      {{ SC_(10473.0), SC_(4.0), SC_(19470.0), SC_(0.0), SC_(0.04557967824227238063292482217416092376756469051630036633036622273178460552857392221801540749674864174), SC_(0.04557967824227238063292482217416092376756469051630036633036622273178460552857392221801540749674864174), SC_(0.9544203217577276193670751778258390762324353094836996336696337772682153944714260777819845925032513583) }}, 
      {{ SC_(10473.0), SC_(4.0), SC_(50688.0), SC_(3.0), SC_(0.02798773465954654463203077779704124270082416492996768731633701686817071714398485590959281706361544958), SC_(0.9981783440141399209107462250184320414579284532710632743615438980069019805514265731606773791206262977), SC_(0.001821655985860079089253774981567958542071546728936725638456101993098019448573426839322620879373702332) }}, 
      {{ SC_(10473.0), SC_(4.0), SC_(130605.0), SC_(4.0), SC_(0.4132532863867608215710548796994946761516185554666453234155258999273081305449938830895721381387754856e-4), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(10473.0), SC_(4.0), SC_(256574.0), SC_(2.0), SC_(0.009196796058070751345927990135135095444000771881371516908171903834711354154097226815906325723215622247), SC_(0.9997363568121731508715493938684535563264625587970114278068583885500838345722101203657415482737184012), SC_(0.0002636431878268491284506061315464436735374412029885721931416114499161654277898796342584517262815988357) }}, 
      {{ SC_(10473.0), SC_(4.0), SC_(523360.0), SC_(3.0), SC_(0.3140316716766720602981504589120325316412638427139225014810878785978567763373089471617774154710147869e-4), SC_(0.9999998397350877262069192959835546227053616935098553280367512479849318188803592730864979306692621833), SC_(0.1602649122737930807040164453772946383064901446719632487520150681811196407269135020693307378166674117e-6) }}, 
      {{ SC_(10473.0), SC_(4.0), SC_(1030167.0), SC_(1.0), SC_(0.03943768404062751390714983980486227387644826573448544275953967138697621509715945158409749683230125994), SC_(0.9993883065239539314449978131759072684183514581116265583166333176711340385582581535896082305960195674), SC_(0.0006116934760460685550021868240927315816485418883734416833666823288659614417418464103917694039804325888) }}, 
      {{ SC_(10473.0), SC_(4.0), SC_(2063277.0), SC_(4.0), SC_(0.6634477007376436766407184248848639777477084916928342296909004469092216962997032173586155972207919822e-9), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(10473.0), SC_(4.0), SC_(2427690.0), SC_(4.0), SC_(0.3461495202943776586958495613821620863532730694818461168902231371844554913120612398825228423579179355e-9), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(10473.0), SC_(15.0), SC_(19470.0), SC_(13.0), SC_(0.007061198830299553928367767630616904542832663715466686472240610569661232633325993683965340179926774192), SC_(0.998736195551109486068068062361640057086764756520079809960271894763154660926978130217799841176126572), SC_(0.001263804448890513931931937638359942913235243479920190039728105236845339073021869782200158823873428003) }}, 
      {{ SC_(10473.0), SC_(15.0), SC_(50688.0), SC_(9.0), SC_(0.0008551446713610111763871168369882875917400671107299162409027014307142101936492315398086834181244775812), SC_(0.9998492303805671485510095141551044882332170167445443997675912418004565573619783492801455044803268784), SC_(0.0001507696194328514489904858448955117667829832554556002324087581995434426380216507198544955196731216319) }}, 
      {{ SC_(10473.0), SC_(15.0), SC_(130605.0), SC_(5.0), SC_(0.004313925198974376342731478072318471598549061272276818505648967349169573369225411341790054706586440812), SC_(0.9992966995227504637038298817615742833270393957687831286616585807027551452383783857344743543041862762), SC_(0.000703300477249536296170118238425716672960604231216871338341419297244854761621614265525645695813723811) }}, 
      {{ SC_(10473.0), SC_(15.0), SC_(256574.0), SC_(8.0), SC_(0.3695733507438991827702198445520275210918061282699046891654326800722381371066775774346939935631108067e-7), SC_(0.9999999987458626722581800010543979847714476537808329254619925285249788981236856066882245704405075643), SC_(0.1254137327741819998945602015228552346219167074538007471475021101876314393311775429559492435742896434e-8) }}, 
      {{ SC_(10473.0), SC_(15.0), SC_(523360.0), SC_(3.0), SC_(0.002860117872410943658465965021813861841117898650043021599095407151992165245454075411823088563017322159), SC_(0.9998166974131642044607193589206678369417357696525664903845927928951494246635093139016947805849028527), SC_(0.0001833025868357955392806410793321630582642303474335096154072071048505753364906860983052194150971473468) }}, 
      {{ SC_(10473.0), SC_(15.0), SC_(1030167.0), SC_(15.0), SC_(0.126806104375045722864133243815740812964387227144791298032275005349411388244132428323426515430269563e-29), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(10473.0), SC_(15.0), SC_(2063277.0), SC_(3.0), SC_(0.5596483143683572183022040573423285025615222856339546597667361556733619500546715145038656708816488335e-4), SC_(0.9999991339863543144633557400890613993239224358422469898181034703439558591933122158504551561802217072), SC_(0.8660136456855366442599109386006760775641577530101818965296560441408066877841495448438197782927975026e-6) }}, 
      {{ SC_(10473.0), SC_(15.0), SC_(2427690.0), SC_(5.0), SC_(0.4293038341964113725668912151998853816444293955667093244351496380146801761593096607773100838533257829e-8), SC_(0.9999999999688409046933015360903941909975179122134418239240223390144703646272717452329208162905039584), SC_(0.3115909530669846390960580900248208778655817607597766098552963537272825476707918370949604164033880292e-10) }}, 
      {{ SC_(10473.0), SC_(29.0), SC_(19470.0), SC_(22.0), SC_(0.00832603818920663663012767533440674601596847400520338801853014778563765131296712480097340226571133379), SC_(0.995959343329429799561902961334414744745701155993911908958630209160289574818865696722770762149821846), SC_(0.004040656670570200438097038665585255254298844006088091041369790839710425181134303277229237850178153968) }}, 
      {{ SC_(10473.0), SC_(29.0), SC_(50688.0), SC_(17.0), SC_(0.7309257923962288047283677930471640904998378740541647256029717147612760241747479919069429351119076946e-5), SC_(0.9999985140595969354736531089568180748136381037633484695364368492262633970415025114158654720263770127), SC_(0.1485940403064526346891043181925186361896236651530463563150773736602958497488584134527973622987323699e-5) }}, 
      {{ SC_(10473.0), SC_(29.0), SC_(130605.0), SC_(26.0), SC_(0.8884035901391804996877450390631072988710389790234206052107884493604663791494051003345177700097121454e-25), SC_(0.9999999999999999999999999991362162207847051045416312122594737664214009462808105625569910251297631676), SC_(0.8637837792152948954583687877405262335785990537191894374430089748702368323846201324052902283084298713e-27) }}, 
      {{ SC_(10473.0), SC_(29.0), SC_(256574.0), SC_(16.0), SC_(0.2320891109242707313933596055089165821733386509593875742210362904538071861946585360826508908753256462e-14), SC_(0.9999999999999999223940026050121640244802650853777055145249248078619858819342473605005046789196813586), SC_(0.7760599739498783597551973491462229448547507519213801411806575263949949532108031864143995188556488509e-16) }}, 
      {{ SC_(10473.0), SC_(29.0), SC_(523360.0), SC_(23.0), SC_(0.3492106104557581837968612108622864930874603650039257391592423138250919409553764676972907118812046423e-33), SC_(0.9999999999999999999999999999999999982139327991936759135195953118671989243403228085181347249661327688), SC_(0.1786067200806324086480404688132801075659677191481865275033867231168102699461333654202431945316637103e-35) }}, 
      {{ SC_(10473.0), SC_(29.0), SC_(1030167.0), SC_(18.0), SC_(0.4101745063323984314096162233280214890184268661443898897951638477411459963814529670927296596949279853e-28), SC_(0.9999999999999999999999999999997552647678327967194373875619535436676741252525978369382222395009885538), SC_(0.2447352321672032805626124380464563323258747474021630617777604990114462285479997834167607772636055093e-30) }}, 
      {{ SC_(10473.0), SC_(29.0), SC_(2063277.0), SC_(20.0), SC_(0.1211228445164956991301888653619525283210520205131438219657510022265263240664737862968041102452117105e-38), SC_(0.9999999999999999999999999999999999999999973518107016834142081768180383207922119039215778523746725496), SC_(0.2648189298316585791823181961679207788096078422147625327450384688548853018087394966546605314740107872e-41) }}, 
      {{ SC_(10473.0), SC_(29.0), SC_(2427690.0), SC_(5.0), SC_(0.1598039205672432560641836012940885830731987528009275019802903693485604397284204067765344744399376604e-6), SC_(0.9999999971919266395926235500390735350242243407011185588276954206119952869616887906962313766886683407), SC_(0.2808073360407376449960926464975775659298881441172304579388004713038311209303768623311331659274207741e-8) }}, 
      {{ SC_(10473.0), SC_(36.0), SC_(19470.0), SC_(25.0), SC_(0.02277021734256849133805840014632866057806520665661269239239550111106502496359673209386313079879681118), SC_(0.9814018627525824875474348809789794069233305101047720436608468012587859403660089591634417568940861602), SC_(0.01859813724741751245256511902102059307666948989522795633915319874121405963399104083655824310591383976) }}, 
      {{ SC_(10473.0), SC_(36.0), SC_(50688.0), SC_(8.0), SC_(0.1541266429818720158314627037038612687563877341468157705763153097372748933742191155636674299076783884), SC_(0.6805501069873489228777991433219853812591437806111801007871805046601774757509336619914698829361726957), SC_(0.3194498930126510771222008566780146187408562193888198992128194953398225242490663380085301170638273043) }}, 
      {{ SC_(10473.0), SC_(36.0), SC_(130605.0), SC_(8.0), SC_(0.00497623178535222555085114910105405470074969775885374445441577620474545845393139928511243637647890168), SC_(0.9982543274149987713678455929092612183250393533848301559180792526378662912569775514763381159749628431), SC_(0.001745672585001228632154407090738781674960646615169844081920747362133708743022448523661884025037156874) }}, 
      {{ SC_(10473.0), SC_(36.0), SC_(256574.0), SC_(8.0), SC_(0.7247696132989388748753321915665909447588116758956489200066950454980635065316066886085528433820571432e-4), SC_(0.9999891883878055541189073456026716680797360960809052454009502628588224481762479315277448963695286779), SC_(0.1081161219444588109265439732833192026390391909475459904973714117755182375206847225510363047132212123e-4) }}, 
      {{ SC_(10473.0), SC_(36.0), SC_(523360.0), SC_(19.0), SC_(0.3181157674328438592442071729316252601287149288886333286168769091158616205200448375532893686209657584e-22), SC_(0.9999999999999999999999994401598258546241565817961428707204490952573001864901588379832319588395353564), SC_(0.5598401741453758434182038571292795509047426998135098411620167680411604646436296588995867297842665943e-24) }}, 
      {{ SC_(10473.0), SC_(36.0), SC_(1030167.0), SC_(29.0), SC_(0.1206833549121689712137180710977384254503872369448337462294820664904793921902251310543534309865527972e-50), SC_(0.9999999999999999999999999999999999999999999999999999971100848157380620182459161649089987833454196655), SC_(0.2889915184261937981754083835091001216654580334510546415044128830659279420640039046905769648292090504e-53) }}, 
      {{ SC_(10473.0), SC_(36.0), SC_(2063277.0), SC_(26.0), SC_(0.5164643337250520818750336155773640701209356329187629728589705766208329423661834937176561270576937725e-51), SC_(0.9999999999999999999999999999999999999999999999999999990249354846639366614304686224220203228397239451), SC_(0.9750645153360633385695313775779796771602760548999585218428758560423040168483918393201870454671606701e-54) }}, 
      {{ SC_(10473.0), SC_(36.0), SC_(2427690.0), SC_(36.0), SC_(0.6754010879348924612068880218147986651866186530226137977423323920445295175834773006784576436015219535e-85), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(10473.0), SC_(126.0), SC_(19470.0), SC_(30.0), SC_(0.4242312602164450273291433122067639404207703899764367959275995187969764699985112422022836273189504413e-11), SC_(0.5730348933150306713168119199539516477937506846978587129389048839026602951521149165054359845276024344e-11), SC_(0.9999999999942696510668496932868318808004604835220624931530214128706109511609733970484788508349456402) }}, 
      {{ SC_(10473.0), SC_(126.0), SC_(50688.0), SC_(89.0), SC_(0.1765385947012381931759457834163830705979299560289653540810069515178062263330461307100455770011146039e-32), SC_(0.9999999999999999999999999999999997911738453977692130023954059590604527113301602546013359865443176995), SC_(0.2088261546022307869976045940409395472886698397453986640134556823004761643257081248393071419275213112e-33) }}, 
      {{ SC_(10473.0), SC_(126.0), SC_(130605.0), SC_(125.0), SC_(0.6046701207862675793876274296650755523189357609888016574977176790307218036218967250086449187623304032e-135), SC_(1.0), SC_(0.4133763977281271627336364286437168992016419012308761653045659396641159826933270910008511382590948607e-138) }}, 
      {{ SC_(10473.0), SC_(126.0), SC_(256574.0), SC_(17.0), SC_(0.1184751972849501856120816339288999361264746237325240190049111774737031147492011937449814789282537375e-4), SC_(0.9999960014111869779970047778701772499654861530258368269201582895987179316647260336393656627185428793), SC_(0.3998588813022002995222129822750034513846974163173079841710401282068335273966360634337281457120743052e-5) }}, 
      {{ SC_(10473.0), SC_(126.0), SC_(523360.0), SC_(4.0), SC_(0.1363002155808367490182989209878595711781834887106335456607293151394500669765382171034007069569914266), SC_(0.8903581182169669052222804952859203914927462599327720999422387047408785193089291566999655261830765776), SC_(0.1096418817830330947777195047140796085072537400672279000577612952591214806910708433000344738169234224) }}, 
      {{ SC_(10473.0), SC_(126.0), SC_(1030167.0), SC_(66.0), SC_(0.6903215979164878500919583179599656894308748075750950095626652923381494348868560562020736265593724786e-95), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999363), SC_(0.636605505048402751399031169654889575154904549803250875250863239535641018351660059456243516534701411e-97) }}, 
      {{ SC_(10473.0), SC_(126.0), SC_(2063277.0), SC_(22.0), SC_(0.3926231849525734828433357422320362443632064051955574269286490308920097116852011265125752439670279681e-26), SC_(0.9999999999999999999999999999075947404035046220919695243989694801781712772310018659020477994327061649), SC_(0.9240525959649537790803047560103051982182872276899813409795220056729383514692744820764954957593936483e-28) }}, 
      {{ SC_(10473.0), SC_(126.0), SC_(2427690.0), SC_(36.0), SC_(0.1967119248070311969724057829783969258146002363850156404665305149049874315254351770289765226094559496e-53), SC_(0.9999999999999999999999999999999999999999999999999999999791282038559435204766975416812264695409293406), SC_(0.2087179614405647952330245831877353045907065936221804180713902590304380522333902234545862812765625169e-55) }}, 
      {{ SC_(10473.0), SC_(244.0), SC_(19470.0), SC_(196.0), SC_(0.193118873119253739302397024084724729986724880946914090157048747942794024716638421645483422534903599e-17), SC_(0.9999999999999999992599547093396204157024966207584568297968518739835552740829393822735954148810613944), SC_(0.7400452906603795842975033792415431702031481260164447259170606177264045851189386055754495275698774676e-18) }}, 
      {{ SC_(10473.0), SC_(244.0), SC_(50688.0), SC_(159.0), SC_(0.3081755680085741223549931419168535784805309163442978941085889677042107455479039455368007143066964246e-50), SC_(0.9999999999999999999999999999999999999999999999999995142901790023646024681530733028292078399982887075), SC_(0.485709820997635397531846926697170792160001711292473903688292923404349165084003224212941510521040147e-51) }}, 
      {{ SC_(10473.0), SC_(244.0), SC_(130605.0), SC_(54.0), SC_(0.4989384064781552337918873513984858269039861465109709063229076587266979800851210980946895208608056743e-11), SC_(0.9999999999978898225992997826693673315756462814373709868345478972134031046105385330145934030371063467), SC_(0.2110177400700217330632668424353718562629013165452102786596895389461466985406596962893653313641127777e-11) }}, 
      {{ SC_(10473.0), SC_(244.0), SC_(256574.0), SC_(21.0), SC_(0.0006789109129955634552976958661240488724907511057754468761718264757623578878548095051143275235554490853), SC_(0.9995134472537857427051122211643562274200624557625946607512765500420761453514192828123095616284206169), SC_(0.0004865527462142572948877788356437725799375442374053392487234499579238546485807171876904383715793831272) }}, 
      {{ SC_(10473.0), SC_(244.0), SC_(523360.0), SC_(86.0), SC_(0.7590873493795917489669309873455243443451155986605808013080469816724298726239900651472686327309744052e-80), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999997102617536707419659), SC_(0.2897382463292580341396177550528523807608780245142488684918392860899297263216902593952928637080238613e-81) }}, 
      {{ SC_(10473.0), SC_(244.0), SC_(1030167.0), SC_(155.0), SC_(0.3013568289695267922565666741292041008230061283023499762789073036171520083249726954443514975085167416e-241), SC_(1.0), SC_(0.1749764017652545253583068742635204536118342473524384204341230111249195978893531312465184354880135693e-243) }}, 
      {{ SC_(10473.0), SC_(244.0), SC_(2063277.0), SC_(102.0), SC_(0.1489492257671362319542244225181093890290135774553000281207125088255701873304425110322079037332844368e-163), SC_(1.0), SC_(0.1044664547805376161868034422351570861688750877034254450227125729223517237003859302145197197318960994e-165) }}, 
      {{ SC_(10473.0), SC_(244.0), SC_(2427690.0), SC_(224.0), SC_(0.1416818482648529866686154582715451849135280587811000406640918066331312685195973233547625890282708871e-501), SC_(1.0), SC_(0.5341777288669928044876328780417598375163456319057482298590689903813106446879130295567890946522097386e-505) }}, 
      {{ SC_(10473.0), SC_(312.0), SC_(19470.0), SC_(220.0), SC_(0.4559307236688022436648508807971245026407418486978069455804074761032777240850731633153050970407190673e-9), SC_(0.9999999995911343687010815034625705717112543312962932170281699680584552233220941919345437446820280641), SC_(0.4088656312989184965374294282887456687037067829718300319415447766779058080654562553179719359058818826e-9) }}, 
      {{ SC_(10473.0), SC_(312.0), SC_(50688.0), SC_(100.0), SC_(0.7129580991462900928620082905141159675840721221167348890423012947874093544166729265137384397877550642e-6), SC_(0.9999991778040287808080194997569568724049500439559927738355695455408829578917749027332521339284762812), SC_(0.8221959712191919805002430431275950499560440072261644304544591170421082250972667478660715237187522535e-6) }}, 
      {{ SC_(10473.0), SC_(312.0), SC_(130605.0), SC_(280.0), SC_(0.155855248886846512206921060601689555214886027235543964313624127117873260570883624255943333546990277e-265), SC_(1.0), SC_(0.1520510906694699542868899027899362340801469510668700056504856905002021523748906809538589964172255757e-267) }}, 
      {{ SC_(10473.0), SC_(312.0), SC_(256574.0), SC_(197.0), SC_(0.2392258725782898212957391954202455183566451003424916411400137112497869896292163167605268576212160462e-188), SC_(1.0), SC_(0.5946584605429456304736785408126173278900851897686177769823714902610789563874268850497782501605896695e-190) }}, 
      {{ SC_(10473.0), SC_(312.0), SC_(523360.0), SC_(11.0), SC_(0.02681679950539037130074528328242701569228616001428129733356555054878852844095781380117446570333624126), SC_(0.9751844406690695702742015640759797709320069752538674431982886738393874617473514178723800859854455349), SC_(0.02481555933093042972579843592402022906799302474613255680171132616061253825264858212761991401455446514) }}, 
      {{ SC_(10473.0), SC_(312.0), SC_(1030167.0), SC_(164.0), SC_(0.2370644487358628539986083440350670045425290602120030593122848047679431618914157827682960485812981777e-235), SC_(1.0), SC_(0.2169495982415679275635041737652004932136963943244485746556814347901167759642712183961307182854799345e-237) }}, 
      {{ SC_(10473.0), SC_(312.0), SC_(2063277.0), SC_(54.0), SC_(0.4738794576881264791554289025565236807708775686950027269467495731857458851098641138654609609077081112e-63), SC_(0.9999999999999999999999999999999999999999999999999999999999999999884471671417074549616459183229209638), SC_(0.1155283285829254503835408167707903623978512241340031913221732392463715100165731473098449300483711266e-64) }}, 
      {{ SC_(10473.0), SC_(312.0), SC_(2427690.0), SC_(54.0), SC_(0.8843826003795339457681488141391333190505899441247583286301786053514419852254996866497453098909066278e-67), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999981755704067598094195305505400228), SC_(0.1824429593240190580469449459977150990481120818329633155227000704596407976341215127476971520749823115e-68) }}, 
      {{ SC_(10473.0), SC_(835.0), SC_(19470.0), SC_(18.0), SC_(0.1643115922765065088965218918738135951354522830672362851707101528511485439351154499020982292643619573e-250), SC_(0.1671868498796718923037370589586664996892142216433616971555929910717726406954334787910320190436671621e-250), SC_(1.0) }}, 
      {{ SC_(10473.0), SC_(835.0), SC_(50688.0), SC_(704.0), SC_(0.178287746938317031639049657938648766364525106536724281535690042465037837973719716212165092288233541e-346), SC_(1.0), SC_(0.8452795665397214669388314478513364991012616186000006870514482736570243677004970486032836858550995969e-348) }}, 
      {{ SC_(10473.0), SC_(835.0), SC_(130605.0), SC_(225.0), SC_(0.3351736685114387627716133015705795776777192109052393840915347109646912444154656613362823898534277977e-59), SC_(0.9999999999999999999999999999999999999999999999999999999999989931746223995058010886988116457964883398), SC_(0.1006825377600494198911301188354203511660166365445446154288473551434462903221283774828884795593398435e-59) }}, 
      {{ SC_(10473.0), SC_(835.0), SC_(256574.0), SC_(647.0), SC_(0.2898470237476624559879538684565767505073457463606731462214747765134268576723920950106626434761903295e-718), SC_(1.0), SC_(0.3399173309371244139991036070672975601911334074995989862162856718850195577253195012986118345109756953e-720) }}, 
      {{ SC_(10473.0), SC_(835.0), SC_(523360.0), SC_(83.0), SC_(0.2425099897594934941198081062076907471595446724530007323365129864945389422837360119471524338832938231e-31), SC_(0.9999999999999999999999999999999946369770041562631742880986001207301159729292428610210300854026026984), SC_(0.5363022995843736825711901399879269884027070757138978969914597397301571070136812192084991725125892781e-32) }}, 
      {{ SC_(10473.0), SC_(835.0), SC_(1030167.0), SC_(603.0), SC_(0.3330882422349393622646040200782815154729052804967498394287132336578813546613984931938089737431515726e-997), SC_(1.0), SC_(0.1243266464213039170821701345775776514318016845655929122997683166385539600673501366957182201829838152e-999) }}, 
      {{ SC_(10473.0), SC_(835.0), SC_(2063277.0), SC_(239.0), SC_(0.5714643964478763937867695686886536632979036203609085469032297133849439280104583314914875051453453633e-335), SC_(1.0), SC_(0.7165182443520489152153266798118997130610925661276455857031263349999879026579841740997884047889522069e-337) }}, 
      {{ SC_(10473.0), SC_(835.0), SC_(2427690.0), SC_(180.0), SC_(0.8851072866802102717040257166059240372699780690721104706602360537153365649333940617934920383940239285e-240), SC_(1.0), SC_(0.1385477957354884646238909719028225271502706930607609814423462896899167159459984979453353381853625361e-241) }}, 
      {{ SC_(10473.0), SC_(1339.0), SC_(19470.0), SC_(481.0), SC_(0.1364862326728530459818902644718065497682725000145519605664465962349214279080576071561078225812425931e-41), SC_(0.2503224217781448651280394315361847552290918581097819391636540195638167636297026304340798114780953665e-41), SC_(0.9999999999999999999999999999999999999999974967757822185513487196056846381524477090814189021806083635) }}, 
      {{ SC_(10473.0), SC_(1339.0), SC_(50688.0), SC_(656.0), SC_(0.3223558872818804547640723176864171409598836237806882375153324827201446568978953401288717542930686338e-120), SC_(1.0), SC_(0.112011777240362102735829304252915316098237109227862758376630311804838471710048544049091601216199531e-120) }}, 
      {{ SC_(10473.0), SC_(1339.0), SC_(130605.0), SC_(899.0), SC_(0.63047818120127722738967687185506327092205415108401465408527724059743566030540577331780389448572703e-649), SC_(1.0), SC_(0.2565457654490029896570326900155311672819162113726546195433190064454517822254513102922982261651137255e-650) }}, 
      //{{ SC_(10473.0), SC_(1339.0), SC_(256574.0), SC_(474.0), SC_(0.203518785659476281950934415552222941808864139562855170957627515226947957872858883206028323805960837e-301), SC_(1.0), SC_(0.1631839064425172634241764208197138810139462522407672666840822354590785138926015197258346864306790786e-302) }}, 
      {{ SC_(10473.0), SC_(1339.0), SC_(523360.0), SC_(1005.0), SC_(0.9331296449495271628440210755090582376064578510511456618428283823460869251557597207545352464839489806e-1406), SC_(1.0), SC_(0.575797476267876731079684271414200375159139357856116020247953112758362970747546502223465866728881829e-1408) }}, 
      {{ SC_(10473.0), SC_(1339.0), SC_(1030167.0), SC_(682.0), SC_(0.532761022557672177860227953754896496746360357093530032717971514321133408605542976722104073666514969e-970), SC_(1.0), SC_(0.4969740636274041383574605536487997596063984621766649052069624607967634924556315597528042729931488232e-972) }}, 
      {{ SC_(10473.0), SC_(1339.0), SC_(2063277.0), SC_(292.0), SC_(0.248373715232413476627121146798958296862060575023781825978560076259075082406264965317917404458086561e-370), SC_(1.0), SC_(0.4483149507495574190080628733681177411442457773686449111155267972860668264358887792297625826211120785e-372) }}, 
      {{ SC_(10473.0), SC_(1339.0), SC_(2427690.0), SC_(1051.0), SC_(0.2265887593761264255991554102885625596650472824973631669172606644181333366279925620901460437789873003e-2208), SC_(1.0), SC_(0.2420782508157641642538029555835804281692649612837476641512194756779139590120235761772334891250095596e-2211) }}, 
      {{ SC_(10473.0), SC_(2247.0), SC_(19470.0), SC_(2034.0), SC_(0.646680061681881774889453623821176958908241953087419490957793433268782444571492304172670862573647138e-349), SC_(1.0), SC_(0.7224087184144022101324339232439345548963117393245964679951302936754411447294406751289800859412117322e-350) }}, 
      {{ SC_(10473.0), SC_(2247.0), SC_(50688.0), SC_(907.0), SC_(0.1499570306685635255491840421141752380378108838973695831394439353626704080517019077202577350257269734e-104), SC_(1.0), SC_(0.8535369878574129467314653221488654757205922425262075087219363906322024657755332338950819873243921429e-105) }}, 
      {{ SC_(10473.0), SC_(2247.0), SC_(130605.0), SC_(1024.0), SC_(0.3079294259741135284271724958813415000609479350786060181098404620959358681975902444039509835389427219e-512), SC_(1.0), SC_(0.322468623591147084392129394556108112325926066911123550167169423762875338211884722051887286510929832e-513) }}, 
      {{ SC_(10473.0), SC_(2247.0), SC_(256574.0), SC_(1597.0), SC_(0.1509110261987108352668241344661375024813748999107730675274060891180620598052869851060564510513629477e-1696), SC_(1.0), SC_(0.2252832074736923379458051188888616859316344465773984771993799097262561566849846492219782825748805244e-1698) }}, 
      {{ SC_(10473.0), SC_(2247.0), SC_(523360.0), SC_(1595.0), SC_(0.1358559687554210642954893018690749494571001783618395886737923384480522879575931092005942362856517741e-2182), SC_(1.0), SC_(0.9687624920827451732010420476301431289871032394797775481318329357401717097825965378271032105049498788e-2185) }}, 
      {{ SC_(10473.0), SC_(2247.0), SC_(1030167.0), SC_(1778.0), SC_(0.2073088283869054068306764283231680996410668683801513182286425662963725586714336496446437362171910777e-3115), SC_(1.0), SC_(0.4672925658356327727756943617852615197902556509163516158215981742180828688369085656577964775457232159e-3118) }}, 
      {{ SC_(10473.0), SC_(2247.0), SC_(2063277.0), SC_(1742.0), SC_(0.9798258313750047798510666915398981689222657150110956819744796289496847590852221139918014473315341887e-3546), SC_(1.0), SC_(0.1209205803402081533299019186926616014915813682002122451515829572800295137892997783765836440737292791e-3548) }}, 
      {{ SC_(10473.0), SC_(2247.0), SC_(2427690.0), SC_(1130.0), SC_(0.6619685297940856211573826736611136034423488412330288773252320335982491657796113592378492652146758556e-2027), SC_(1.0), SC_(0.2537802478266899294428381315186340650960704627133415890246949968638483976621438984929601062822126701e-2029) }}, 
      {{ SC_(10473.0), SC_(6337.0), SC_(19470.0), SC_(6149.0), SC_(0.3389625652317688290864418372188657311369405886025935045167528196007009439598879315388692039367724169e-1856), SC_(1.0), SC_(0.516262349851222795824008212674787255949291965446973227090552396978789367029852982460475925658831783e-1858) }}, 
      {{ SC_(10473.0), SC_(6337.0), SC_(50688.0), SC_(4202.0), SC_(0.6970470540620002904065534050464836094997728174390752260341085134621401670001263381951650314871528147e-1609), SC_(1.0), SC_(0.6362520239484871583193378389239851052363846409514744182170427465700071061282355334262837358108248406e-1610) }}, 
      {{ SC_(10473.0), SC_(6337.0), SC_(130605.0), SC_(6329.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.4358652987584007202257896858534549119423424915348602556700871963302970495430636148619036902144573757e-7922)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1900384495520811308655204878486430921457113124741692643277437965039981178948987173638121323946922506e-7926)) }}, 
      {{ SC_(10473.0), SC_(6337.0), SC_(256574.0), SC_(2691.0), SC_(0.4692959981235794128708386023553660284784019214666094745453882019284895097793200498135761519062990587e-2072), SC_(1.0), SC_(0.2132713745443410781242112118603533758191923653549683230892783480087824780034601081749531474271857777e-2073) }}, 
      {{ SC_(10473.0), SC_(6337.0), SC_(523360.0), SC_(3160.0), SC_(0.3509518614018862437790644434154992688942782237974764233995109072919933346000633216367906579505569893e-3709), SC_(1.0), SC_(0.5134698871620745736238886222343807692688146631244280310915657388410482106303628446305656112788932919e-3711) }}, 
      {{ SC_(10473.0), SC_(6337.0), SC_(1030167.0), SC_(907.0), SC_(0.165889090615039873939631279604814613427453540596492487591191730124400494388755683356826468496984924e-718), SC_(1.0), SC_(0.9914833455754618112979481835649961694268039091902648448579792393681477629517588567889571999149662392e-720) }}, 
      {{ SC_(10473.0), SC_(6337.0), SC_(2063277.0), SC_(1927.0), SC_(0.2653053593883414455411879784790505097466683741721199813388732190571541778833410484661320423752387186e-2822), SC_(1.0), SC_(0.2556156588918498057704488229139203773130914745191083182437570400111441312435573218499384550900373611e-2824) }}, 
      {{ SC_(10473.0), SC_(6337.0), SC_(2427690.0), SC_(5162.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.6252171049267233204191735061666134485707046527865005168429981340522450183597520471780517806395575426e-11565)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.3129358268803765378275868415626970192243324364573134933382485603576794179207883726753521964382172603e-11568)) }}, 
      {{ SC_(10473.0), SC_(10473.0), SC_(19470.0), SC_(10222.0), SC_(0.232176076494910574627491618848872550158244106810655170103294645593622818122737427278278410667702451e-4825), SC_(1.0), SC_(0.1636933403548001657973800880912164524245845127505268602908100804547350633633034114682340681374520837e-4828) }}, 
      {{ SC_(10473.0), SC_(10473.0), SC_(50688.0), SC_(8695.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.5599835536704939070078365520614185454795258686134727114491288031301984616048241967729772448492083996e-5981)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.5346629944552498186245479477139475041960866359542513860676367946862886040159275682955316718632231764e-5983)) }}, 
      {{ SC_(10473.0), SC_(10473.0), SC_(130605.0), SC_(8356.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.8470087940293155166578665437576866760914885543706746013129152278946538347531119068129483778786781697e-8926)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.386646597984919876751741241600890685536659858718829399763342629543608830607390340705304275696806045e-8928)) }}, 
      {{ SC_(10473.0), SC_(10473.0), SC_(256574.0), SC_(4427.0), SC_(0.3514427930804025423763954720854603366597323066849774767077897163299965210006739237660000186926559597e-3581), SC_(1.0), SC_(0.1251582388507550852508965517277196668848768130829506498596150700755097191053684439730659150019647233e-3582) }}, 
      {{ SC_(10473.0), SC_(10473.0), SC_(523360.0), SC_(2743.0), SC_(0.504270955429900770438109090048491453486599933371325104290466937499829733144917406266852548661570009e-2265), SC_(1.0), SC_(0.2271618727269752249645213900494422046475776467017347629948838560449257547299867545456805858983955468e-2266) }}, 
      {{ SC_(10473.0), SC_(10473.0), SC_(1030167.0), SC_(1840.0), SC_(0.3527529968092875050953921861289275622725779971993119535362757176989405962456747351663332336698247924e-1660), SC_(1.0), SC_(0.1471278062711829984904788013738329116989710513192869791301438012551506320700258584304706293857378659e-1661) }}, 
      {{ SC_(10473.0), SC_(10473.0), SC_(2063277.0), SC_(6550.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.7970331005886673655672024634426030425282082568179511324599500165732380396567208730918925299601243268e-13193)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.9149267908611955742113708185129115471611093036511846654405945196656014450931710673179923310935994776e-13196)) }}, 
      {{ SC_(10473.0), SC_(10473.0), SC_(2427690.0), SC_(2865.0), SC_(0.7061711765528215415140537522186488982266631488315721139755523130347396468536346162661062166038264485e-4307), SC_(1.0), SC_(0.5968719023791774414389271090477348120461526899071619354497127249533515310282702345811674292035990173e-4309) }}, 
      {{ SC_(19470.0), SC_(3.0), SC_(50688.0), SC_(2.0), SC_(0.2726127509746102753275935067358178538493769715306106751561291219726854452175294385343073889183562491), SC_(0.9433315711451330125773849446992877829164833228505143547105353562414393379087400099367256470896858708), SC_(0.05666842885486698742261505530071221708351667714948564528946464375856066209125999006327435291031412921) }}, 
      {{ SC_(19470.0), SC_(3.0), SC_(130605.0), SC_(2.0), SC_(0.05672993297660790697626696784512705849469250246585994438090714075840689082799501781857472597029820584), SC_(0.9966874571911380971100794369310330271748333899071538777246666960108068565685303497903878087046400878), SC_(0.003312542808861902889920563068966972825166610092846122275333303989193143431469650209612191295359912208) }}, 
      {{ SC_(19470.0), SC_(3.0), SC_(256574.0), SC_(3.0), SC_(0.0004369161292673548353955488043850058065675441575890151463252145552456729622224224489165106188748013163), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(19470.0), SC_(3.0), SC_(523360.0), SC_(0.0), SC_(0.8924944873263585481223736551309588031425547535696452443734497562403089054202644663502024788129839306), SC_(0.8924944873263585481223736551309588031425547535696452443734497562403089054202644663502024788129839306), SC_(0.1075055126736414518776263448690411968574452464303547556265502437596910945797355336497975211870160694) }}, 
      {{ SC_(19470.0), SC_(3.0), SC_(1030167.0), SC_(1.0), SC_(0.05457667749732296667239380724060263881256906299660706360611700223359047271667805383430474613027856622), SC_(0.9989419413760566732458411451800117131948578684298509627909213775070389762431700094655127869981764164), SC_(0.001058058623943326754158854819988286805142131570149037209078622492961023756829990534487213001823583615) }}, 
      {{ SC_(19470.0), SC_(3.0), SC_(2063277.0), SC_(1.0), SC_(0.02777760377666507479671132010459565629233561870903039773598914898671158849499519544911238210066878676), SC_(0.9997345544146887555858326963479294229171772416436284467824418562634751418677413773781365592950862615), SC_(0.0002654455853112444141673036520705770828227583563715532175581437365248581322586226218634407049137384921) }}, 
      {{ SC_(19470.0), SC_(3.0), SC_(2427690.0), SC_(1.0), SC_(0.0236755562847916796590505094972071290109599366174122047219483984989587772769231007893075588529230042), SC_(0.9998080816237481803465920243122243831201178999954499522152051751402147146662199582538108743661458066), SC_(0.0001919183762518196534079756877756168798821000045500477847948248597852853337800417461891256338541934281) }}, 
      {{ SC_(19470.0), SC_(4.0), SC_(50688.0), SC_(1.0), SC_(0.3589469127816263234380882572402965254161593405466675247399891275735651810373058838967637892526805454), SC_(0.5028160432705639927513898102674646820785298312395826092900502551699806551780288315834289366784949166), SC_(0.4971839567294360072486101897325353179214701687604173907099497448300193448219711684165710633215050834) }}, 
      {{ SC_(19470.0), SC_(4.0), SC_(130605.0), SC_(4.0), SC_(0.0004937540838587055600839466567401728915906218792777711086653606282547459509497711692165321643763038159), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(19470.0), SC_(4.0), SC_(256574.0), SC_(3.0), SC_(0.001615062683059377730010425242368037178954612796317367859256013686768915797931843288724940178394908781), SC_(0.9999668495414974895971070575062070034881711090414903268184887888664392648385361170861818832180801296), SC_(0.3315045850251040289294249379299651182889095850967318151121113356073516146388291381811678191987040161e-4) }}, 
      {{ SC_(19470.0), SC_(4.0), SC_(523360.0), SC_(0.0), SC_(0.859291783114426347097179351691051115087965742527467547489771756798272688423905322763150078792751054), SC_(0.859291783114426347097179351691051115087965742527467547489771756798272688423905322763150078792751054), SC_(0.140708216885573652902820648308948884912034257472532452510228243201727311576094677236849921207248946) }}, 
      {{ SC_(19470.0), SC_(4.0), SC_(1030167.0), SC_(3.0), SC_(0.2649011823255174959425105620745718491511768236457964472403775033762962587512308685815682413508529148e-4), SC_(0.9999998724436869721872852716280667720966276879727745824732971793616469784797174417000936995108678888), SC_(0.1275563130278127147283719332279033723120272254175267028206383530215202825582999063004891321112174102e-6) }}, 
      {{ SC_(19470.0), SC_(4.0), SC_(2063277.0), SC_(0.0), SC_(0.9627851189622877770434413583710309564134079178626897014324497032171724964070564727228857057469947855), SC_(0.9627851189622877770434413583710309564134079178626897014324497032171724964070564727228857057469947855), SC_(0.03721488103771222295655864162896904358659208213731029856755029678282750359294352727711429425300521454) }}, 
      {{ SC_(19470.0), SC_(4.0), SC_(2427690.0), SC_(1.0), SC_(0.03131425141437011125138690991622624487836414751484914644053159974157323395205158404721457569547590534), SC_(0.9996182138997340841260816972521869377679310740141746073236554764473944160932051483440124033722170583), SC_(0.0003817861002659158739183027478130622320689259858253926763445235526055839067948516559875966277829416579) }}, 
      {{ SC_(19470.0), SC_(15.0), SC_(50688.0), SC_(6.0), SC_(0.2049898626929410975719441756101770384772479906816521016212616976190375322897695923009906702507891341), SC_(0.6582920171287188541347378368721435748190306822901988336753642593342523557451330543490211986080401236), SC_(0.3417079828712811458652621631278564251809693177098011663246357406657476442548669456509788013919598764) }}, 
      {{ SC_(19470.0), SC_(15.0), SC_(130605.0), SC_(13.0), SC_(0.136099444689070979490652949507898060390024558798583681199504671677983561177183360491049960401869574e-8), SC_(0.9999999999655628988724937593573950830694930054145072202500439304612823372967983459486903750238494391), SC_(0.3443710112750624064260491693050699458549277974995606953871766270320165405130962497615056094063236652e-10) }}, 
      {{ SC_(19470.0), SC_(15.0), SC_(256574.0), SC_(8.0), SC_(0.4067928203755680236189212793246295891783215417691873153375291516268803805211945704116537587072067764e-5), SC_(0.9999997270095737229237734648556832766068688351537122413056967683948638429379688461826495724701841817), SC_(0.2729904262770762265351443167233931311648462877586943032316051361570620311538173504275298158183471015e-6) }}, 
      {{ SC_(19470.0), SC_(15.0), SC_(523360.0), SC_(14.0), SC_(0.1398296434997940226673782002629192704911524350946032281346841939004770818318846738296503576071205525e-18), SC_(0.9999999999999999999996400635662635373454501961057221010767329031101760833506534606525073427114156892), SC_(0.3599364337364626545498038942778989232670968898239166493465393474926572885843108233921048810994926079e-21) }}, 
      {{ SC_(19470.0), SC_(15.0), SC_(1030167.0), SC_(3.0), SC_(0.002442842402211968643463440308394599325602272055903767960062479192799089597513578749810787961519750876), SC_(0.9998526660066690181233331089242203753280710208035294811293881257486762795764174279212672491746993546), SC_(0.0001473339933309818766668910757796246719289791964705188706118742513237204235825720787327508253006453858) }}, 
      {{ SC_(19470.0), SC_(15.0), SC_(2063277.0), SC_(3.0), SC_(0.0003411661542512986460911390253345214711773131974898781496680777094206227509919653268780828891867417653), SC_(0.9999900437004692794675290375285904973808331306180622254833225470024775080334086446566235223659367032), SC_(0.9956299530720532470962471409502619166869381937774516677452997522491966591355343376477634063296800759e-5) }}, 
      {{ SC_(19470.0), SC_(15.0), SC_(2427690.0), SC_(15.0), SC_(0.3633012748446568620497346276075644830081502921430090327502895175067411282765289538897196514926481152e-31), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(19470.0), SC_(29.0), SC_(50688.0), SC_(27.0), SC_(0.919601796571766979326717800639324215683685921420515812457562101336440320271046808167870128150849147e-9), SC_(0.9999999999582100619055267140014296513398893814268476089248168478213305507769903061853883471847603882), SC_(0.4178993809447328599857034866011061857315239107518315217866944922300969381461165281523961175676563081e-10) }}, 
      {{ SC_(19470.0), SC_(29.0), SC_(130605.0), SC_(18.0), SC_(0.7706828572916637275494520428976220074661515993208915621783089015077263675621243199783019845952380362e-8), SC_(0.9999999991451451136856791998750228092600702611839438053366559623859666074597072555655382479590681866), SC_(0.8548548863143208001249771907399297388160561946633440376140333925402927444344617520409318133629211012e-9) }}, 
      {{ SC_(19470.0), SC_(29.0), SC_(256574.0), SC_(24.0), SC_(0.1050684888656610763869087210769347659092579245882147289204828912896201426678969927302355705637532124e-21), SC_(0.9999999999999999999999982545955428943853085690343642063512065553518211336045309766994175579042700717), SC_(0.1745404457105614691430965635793648793444648178866395469023300582442095729928261903655088485642043958e-23) }}, 
      {{ SC_(19470.0), SC_(29.0), SC_(523360.0), SC_(18.0), SC_(0.4216797663783890568049804393824317894427419894151090915453948323666435390476911537773731034182203163e-18), SC_(0.9999999999999999999903905292297396743349378199456509870425174590845240783557140021956288311869541819), SC_(0.9609470770260325665062180054349012957482540915475921644285997804371168813045818129133697889223744065e-20) }}, 
      {{ SC_(19470.0), SC_(29.0), SC_(1030167.0), SC_(24.0), SC_(0.4594372702628245537450556313695977193394727140857430941766791429018820218772141505494370208280674912e-36), SC_(0.9999999999999999999999999999999999999982268170411004345953147454896164274828174560364703735543483558), SC_(0.1773182958899565404685254510383572517182543963529626445651644231569520352843354331568250268320361728e-38) }}, 
      {{ SC_(19470.0), SC_(29.0), SC_(2063277.0), SC_(29.0), SC_(0.1821666582326692003876314113049739219253785435082388595671065832844358094879698959294664908204703511e-58), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(19470.0), SC_(29.0), SC_(2427690.0), SC_(2.0), SC_(0.02101055853728067200616331700582039964550453454712769823354886227336318854514209267824801098769246072), SC_(0.9983876678826104536153893655830464498141545323743524525515665085728325331176833610725794010839990108), SC_(0.001612332117389546384610634416953550185845467625647547448433491427167466882316638927420598916000989196) }}, 
      {{ SC_(19470.0), SC_(36.0), SC_(50688.0), SC_(13.0), SC_(0.1319432870987789682649779850602060928161916366491085791394222045726403092675147857645916458714291706), SC_(0.4605852286972013546514110475978564692527513740257033949771225325949384874282467825549052271008921827), SC_(0.5394147713027986453485889524021435307472486259742966050228774674050615125717532174450947728991078173) }}, 
      {{ SC_(19470.0), SC_(36.0), SC_(130605.0), SC_(25.0), SC_(0.2177081115961960550020121689218805273755673118290881197703187284857066641904140932996917179914907779e-12), SC_(0.9999999999999827766163695145570373553077243572369959884048819685676978399717146305071610746614429187), SC_(0.1722338363048544296264469227564276300401159511803143230216002828536949283892533855708133814317974958e-13) }}, 
      {{ SC_(19470.0), SC_(36.0), SC_(256574.0), SC_(16.0), SC_(0.1814719700998142338849338705218643549683748757458147352295701034224573977253070513243265399738264571e-8), SC_(0.9999999998083760781951934154832669524155694646252913340181390112831446553001778866241229235657326579), SC_(0.1916239218048065845167330475844305353747086659818609887168553446998221133758770764342673421259954792e-9) }}, 
      {{ SC_(19470.0), SC_(36.0), SC_(523360.0), SC_(32.0), SC_(0.8950237668378292930564240762928330386157308609609438442369162766480905411975159667909242291837980023e-41), SC_(0.9999999999999999999999999999999999999999999580068991208008915920433413077589369275869275099526011414), SC_(0.419931008791991084079566586922410630724130724900473988585556882075255354426479039702756517933773395e-43) }}, 
      {{ SC_(19470.0), SC_(36.0), SC_(1030167.0), SC_(11.0), SC_(0.4088071326926696311747111843861883064478037918357679149958752784942226638481529012394118666290765291e-10), SC_(0.9999999999983000345923195267209870335351911170014600063533859834019305127064107319176007794268395803), SC_(0.1699965407680473279012966464808882998539993646614016598069487293589268082399220573160419656624522143e-11) }}, 
      {{ SC_(19470.0), SC_(36.0), SC_(2063277.0), SC_(21.0), SC_(0.1413604562276030094853728052576021296614503783626822280716625573037908860934537872951286640011396807e-32), SC_(0.9999999999999999999999999999999999907747516602022768135567654315323925597660432190453643873922376926), SC_(0.9225248339797723186443234568467607440233956780954635612607762307439705484825888436974876431259929845e-35) }}, 
      {{ SC_(19470.0), SC_(36.0), SC_(2427690.0), SC_(22.0), SC_(0.261302070492311150534266430255894370595468917531653944601122676696135855421568986659032101845413327e-36), SC_(0.9999999999999999999999999999999999999987098890786402520376911300445138378683722162798159877962811249), SC_(0.1290110921359747962308869955486162131627783720184012203718875102390592914440391843947366629032024808e-38) }}, 
      {{ SC_(19470.0), SC_(126.0), SC_(50688.0), SC_(23.0), SC_(0.5208404894570237766542211335802900122348812033649700549435407778219026564164490131937523262172689609e-6), SC_(0.7945475157131558246961089267549997827402361500101539403652831470142978496467063166028694908110464071e-6), SC_(0.999999205452484286844175303891073245000217259763849989846059634716852985702150353293683397130509189) }}, 
      {{ SC_(19470.0), SC_(126.0), SC_(130605.0), SC_(106.0), SC_(0.645206926088180192355405394648053443760442763144495901347355444869380276217891557906030072467330781e-66), SC_(0.999999999999999999999999999999999999999999999999999999999999999999978319991341391275488669873746416), SC_(0.216800086586087245113301262535840087927963915879636991639940570914216613252020234082531217276722531e-67) }}, 
      {{ SC_(19470.0), SC_(126.0), SC_(256574.0), SC_(75.0), SC_(0.100564400876370961915068412108682350333701224248283812482321757202598910654739041840253381305784514e-49), SC_(0.9999999999999999999999999999999999999999999999999994169493759864989726780149715504867026297225411634), SC_(0.5830506240135010273219850284495132973702774588365926077850529615886769325844232802122122393576924476e-51) }}, 
      {{ SC_(19470.0), SC_(126.0), SC_(523360.0), SC_(79.0), SC_(0.1771950135020912440148490711844432895797328145941778927746853124254776520638282631456258449974920997e-78), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999959040654266615617314), SC_(0.4095934573338438268626544409622923523205400386656521221371274431631831403741131332465276446181790071e-80) }}, 
      {{ SC_(19470.0), SC_(126.0), SC_(1030167.0), SC_(118.0), SC_(0.3189838404448919354914233544872231921647056413867963943051151362707367388695740771489287206477944009e-191), SC_(1.0), SC_(0.4110596365910280806128290527180777418724941369478231741818003848905195110386408279395913798352292149e-194) }}, 
      {{ SC_(19470.0), SC_(126.0), SC_(2063277.0), SC_(21.0), SC_(0.4647847952364470846092009042420856845413340506166514587324631834073506480911271044403118674181631894e-19), SC_(0.9999999999999999999977942568154002411944993082210363334633066502321646284706080405668730942252660705), SC_(0.2205743184599758805500691778963666536693349767835371529391959433126905774733929526547688288867667648e-20) }}, 
      {{ SC_(19470.0), SC_(126.0), SC_(2427690.0), SC_(9.0), SC_(0.8797896681300518470114408311721077059572072658296818799322734713708039827061295031740492286787988016e-6), SC_(0.9999999091335524379879435422039142068467681767124164920582127052086062542300157602139823971825468225), SC_(0.9086644756201205645779608579315323182328758350794178729479139374576998423978601760281745317745178572e-7) }}, 
      {{ SC_(19470.0), SC_(244.0), SC_(50688.0), SC_(14.0), SC_(0.9344550033630484233985996991172125143626500371925714382530342862864098852584027456515136967719775878e-32), SC_(0.1033413817988380533954344160910075639330809993511769417921945953044001098117315690256559566590790188e-31), SC_(0.99999999999999999999999999999998966586182011619466045655839089924360669190006488230582078054046956) }}, 
      {{ SC_(19470.0), SC_(244.0), SC_(130605.0), SC_(217.0), SC_(0.1209546989003235920527568076305408635669222902807211905991915205226729895320301589879405655337875471e-145), SC_(1.0), SC_(0.2650317811719576573344644108453309272171037686631219242499504128234247178987565881646332330410600292e-147) }}, 
      {{ SC_(19470.0), SC_(244.0), SC_(256574.0), SC_(82.0), SC_(0.8989140357734334527809277498011871144804564417953497104448385036861067888423346364960053096897169871e-31), SC_(0.999999999999999999999999999999982983928953921188728804577051459670098178559850876145279422474034105), SC_(0.1701607104607881127119542294854032990182144014912385472057752596589502689914300085739780174415153617e-31) }}, 
      //{{ SC_(19470.0), SC_(244.0), SC_(523360.0), SC_(227.0), SC_(0.2988017607761462584503598248028767789212229085304836399097860736088167254997089664372752459707147615e-299), SC_(1.0), SC_(0.8531161553493089133771114519957120955128157739185118853501171172239424887891414657826689357178329175e-302) }}, 
      {{ SC_(19470.0), SC_(244.0), SC_(1030167.0), SC_(201.0), SC_(0.8729278584817511846613845872589567649549954124019889467645642177286912025029438207826879991429744046e-299), SC_(1.0), SC_(0.355686951495649231214327298878318428851473348253497842516270025559617746272144442051613501692474897e-301) }}, 
      {{ SC_(19470.0), SC_(244.0), SC_(2063277.0), SC_(200.0), SC_(0.1471786345787735845817609383641175160135824709354246021254706638725457047282840514416261925023895622e-356), SC_(1.0), SC_(0.3043860953835496360936504556676784553310603749155043801023804747178373136162089035934059601741590596e-359) }}, 
      {{ SC_(19470.0), SC_(244.0), SC_(2427690.0), SC_(109.0), SC_(0.3263635117330201409863103256075416765657645863236041331302965512960512729105765312561181190682098045e-157), SC_(1.0), SC_(0.3251871641328586210838063255744227194298871271316447011319914788000813414679300480970032352667233656e-159) }}, 
      {{ SC_(19470.0), SC_(312.0), SC_(50688.0), SC_(280.0), SC_(0.1333724727679504981916667979663730585631086024952395225601067726158765458522451808961351032913801963e-79), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999989978228955425892373), SC_(0.1002177104457410762684288630150267458226020046200710089767280565609478619747881541566267353080229995e-80) }}, 
      {{ SC_(19470.0), SC_(312.0), SC_(130605.0), SC_(164.0), SC_(0.1908218179785356939187194709883554959118742894068082319766535767312696563980619378892513600123314081e-53), SC_(0.9999999999999999999999999999999999999999999999999999996482104031859783073321355295683281479362255546), SC_(0.3517895968140216926678644704316718520637744453513613874876473506756124194881412853777062031962647639e-54) }}, 
      {{ SC_(19470.0), SC_(312.0), SC_(256574.0), SC_(22.0), SC_(0.08234409579339694567503209029064985601424412964394972188750988596938687389489095878672702458611280168), SC_(0.4118181224637250099453125669859843455931622441974497478620746815094224569331600912169843523692286899), SC_(0.5881818775362749900546874330140156544068377558025502521379253184905775430668399087830156476307713101) }}, 
      {{ SC_(19470.0), SC_(312.0), SC_(523360.0), SC_(276.0), SC_(0.2395079120440828981991373949312117364827627456240139534142915377140430827489989693777985143220205217e-348), SC_(1.0), SC_(0.1191488853210426340426522299939142532019932768743572424191851883622808141815712895401195754029729796e-350) }}, 
      {{ SC_(19470.0), SC_(312.0), SC_(1030167.0), SC_(63.0), SC_(0.1701485140560305526551596406156496981692077612155788310159986152240802014926078084404045876874690641e-43), SC_(0.9999999999999999999999999999999999999999999986282051008356512466948704897992397241118721680374737706), SC_(0.1371794899164348753305129510200760275888127831962526229395378674339360521589027970277339223196093932e-44) }}, 
      {{ SC_(19470.0), SC_(312.0), SC_(2063277.0), SC_(261.0), SC_(0.3952156844210644794768559326849161866059456215760783136334306415248050668046574689060152228014734706e-470), SC_(1.0), SC_(0.7243612302611695028755246827756432013184596486841533430503440167544980639388100608508084602337717893e-473) }}, 
      {{ SC_(19470.0), SC_(312.0), SC_(2427690.0), SC_(199.0), SC_(0.3020197202181729752750905337535712822439671823971637842266206885410786209950578207726215760821792816e-330), SC_(1.0), SC_(0.1371679738721813648821206974225564260916252151614698320796080737311114390052953638407657731953255219e-332) }}, 
      {{ SC_(19470.0), SC_(835.0), SC_(50688.0), SC_(109.0), SC_(0.145391515092132642277438882978179512830897029067150441356017259585663871726631708879603232265519685e-59), SC_(0.1901411357909087394963794869022089994262848008605079103148584611438733611887122970151866433934864977e-59), SC_(0.9999999999999999999999999999999999999999999999999999999999980985886420909126050362051309779100057372) }}, 
      {{ SC_(19470.0), SC_(835.0), SC_(130605.0), SC_(604.0), SC_(0.7090877916224425703795628410503926172159035272780815403035284661663508216720572859657438181809934313e-306), SC_(1.0), SC_(0.4923301462024088843010331937549747545022319717679956138797874780755717053439877893073567380579361e-307) }}, 
      {{ SC_(19470.0), SC_(835.0), SC_(256574.0), SC_(755.0), SC_(0.1280129009649122053815390688841807119538457622311171554608339997605659732749004746498681410435524492e-740), SC_(1.0), SC_(0.1078475759700519485744359540650272201006732921178139166315930870240830632879222178496212902084737782e-742) }}, 
      {{ SC_(19470.0), SC_(835.0), SC_(523360.0), SC_(754.0), SC_(0.7848310491508126907098210134340138659619646508800968796793229137156472404856528105285254896253687088e-971), SC_(1.0), SC_(0.3140298477520792151279321728083579009980301030738898409204400582648875554894436679582225463037167757e-973) }}, 
      {{ SC_(19470.0), SC_(835.0), SC_(1030167.0), SC_(612.0), SC_(0.1600912869569835240229718413961747325110527873795779963443269561704990187023969407454030719529137416e-851), SC_(1.0), SC_(0.1094264405446091280105187851063104121330315962330793464281786193061095616118567223250961519074348882e-853) }}, 
      {{ SC_(19470.0), SC_(835.0), SC_(2063277.0), SC_(727.0), SC_(0.4253993366900116359833592056824663834680649996358207004177825414919668104802497425927135308073842671e-1340), SC_(1.0), SC_(0.5795569305203345267049443148542515884429456857650674695467614537472080148208973539665332072376248558e-1343) }}, 
      {{ SC_(19470.0), SC_(835.0), SC_(2427690.0), SC_(114.0), SC_(0.3798138651623371495428386201351020356507838467391142598637798272697603943348037994923563658601477166e-98), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999998), SC_(0.2015006013577042290148174030003531287208541943758721153338151920829298667058720458066694756245894486e-99) }}, 
      {{ SC_(19470.0), SC_(1339.0), SC_(50688.0), SC_(695.0), SC_(0.1078877126498314304488579777194212796802739517929018256016661938793874763097868742689178700258884786e-23), SC_(0.9999999999999999999999985933338858047270846532234000019472154138916158308324206358509539011499005689), SC_(0.140666611419527291534677659999805278458610838416916757936414904609885009943114661220094184915032228e-23) }}, 
      {{ SC_(19470.0), SC_(1339.0), SC_(130605.0), SC_(619.0), SC_(0.1931330504421713967704015113839497491813297378869764061921511955257741812332085205438506190274260503e-164), SC_(1.0), SC_(0.4771549834345953740062915076476338920124307722478801382238699175236754708472582958075539144793446513e-165) }}, 
      {{ SC_(19470.0), SC_(1339.0), SC_(256574.0), SC_(695.0), SC_(0.2114016267632296956992015245613587292639484245015621047640139069014125907630479705465575419333792325e-403), SC_(1.0), SC_(0.1675837281723562226365876159352125321674893420217241340155528894505235461199248873858159672762833214e-404) }}, 
      {{ SC_(19470.0), SC_(1339.0), SC_(523360.0), SC_(101.0), SC_(0.2313923991239243431542813053200691917669673880315923182609137114414360111560318067105475031196046867e-10), SC_(0.9999999999800048038197970766447148596470888219431724119966675921820362085397238205895094346094729907), SC_(0.1999519618020292335528514035291117805682758800333240781796379146027617941049056539052700928226713896e-10) }}, 
      {{ SC_(19470.0), SC_(1339.0), SC_(1030167.0), SC_(895.0), SC_(0.671322836479335909915302672283884089448649773243798650204054284198642030287097670660118719893770949e-1187), SC_(1.0), SC_(0.6172568313754324238423986912597331828329758027222831795900050188436955063670280967332494309832509863e-1189) }}, 
      {{ SC_(19470.0), SC_(1339.0), SC_(2063277.0), SC_(15.0), SC_(0.08346126653420503472343754755307572918900120354967571802401388102813781628781926380469899258555001165), SC_(0.7959137825824670022753429567123991702510109328135470492802092614426379516385811622545177400145781966), SC_(0.2040862174175329977246570432876008297489890671864529507197907385573620483614188377454822599854218034) }}, 
      {{ SC_(19470.0), SC_(1339.0), SC_(2427690.0), SC_(1208.0), SC_(0.1434989309892887428871011355477339694211387518897715748160289774287988385346415551528791744020554702e-2363), SC_(1.0), SC_(0.118011207997389048977957621957138483495263293379613101751341989936799812032717801017374340547709161e-2366) }}, 
      {{ SC_(19470.0), SC_(2247.0), SC_(50688.0), SC_(2014.0), SC_(0.1950920472495098527777856731985149616180795014807158497171820943878131213757971697498330086418213651e-587), SC_(1.0), SC_(0.1358927331538654006839721349166348993091505657646026793010907079685708803992130716485385908619338411e-588) }}, 
      {{ SC_(19470.0), SC_(2247.0), SC_(130605.0), SC_(2162.0), SC_(0.9069630130843565017235053020368271764182472898095060843556722299456786937557042194550488210908989734e-1683), SC_(1.0), SC_(0.5588708098169232276892363014931753889968941742871149432178657404012316505291519402217527012573014916e-1685) }}, 
      {{ SC_(19470.0), SC_(2247.0), SC_(256574.0), SC_(1083.0), SC_(0.1100720196517425498801216895358596237154849248721310369419683526779135277293161381167618766801263893e-588), SC_(1.0), SC_(0.1005037472221680411974507310424974060281699594741969703428909358674201609467030425115165202186347869e-589) }}, 
      {{ SC_(19470.0), SC_(2247.0), SC_(523360.0), SC_(369.0), SC_(0.6997617096118525259278643314037486895915145141892069829416623619999214997889794534417883223383394744e-125), SC_(1.0), SC_(0.1673234012398752158885865532353864424664718998703867385219551300434430313811330626710635771750935024e-125) }}, 
      {{ SC_(19470.0), SC_(2247.0), SC_(1030167.0), SC_(808.0), SC_(0.2273855242510854734718835976406967342619888895206696996492800593756428955078708783295291650717415491e-775), SC_(1.0), SC_(0.7732583524312323407474500158297918200803397680438438748115333781662956829759338047014525221172050521e-777) }}, 
      {{ SC_(19470.0), SC_(2247.0), SC_(2063277.0), SC_(1848.0), SC_(0.5327213934760762987165972586139038260184635921238429840149725899749262488317176347826816169984472561e-3328), SC_(1.0), SC_(0.9932131390666134097003108590697530127323332032823358935272437880540749249689999439756297951516454645e-3331) }}, 
      {{ SC_(19470.0), SC_(2247.0), SC_(2427690.0), SC_(2236.0), SC_(0.2500908953820543084333042361429300631282798331973213033087382339410742872164858351299999658318392663e-4714), SC_(1.0), SC_(0.8800963143175587147704203627713583911617767117279171369904305618783160769853308085783357401367071999e-4719) }}, 
      {{ SC_(19470.0), SC_(6337.0), SC_(50688.0), SC_(1697.0), SC_(0.1334731981673617871372414112054156660093297832403780383416033465671976420506480060938402180824433383e-95), SC_(0.2941130462276453407047043807897439409589965355453174593453658353872512166314722795863844887148899644e-95), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999970589) }}, 
      {{ SC_(19470.0), SC_(6337.0), SC_(130605.0), SC_(2991.0), SC_(0.7448997128386292057978802219695482964229460740272024847689442086716967966504280668622163341884401806e-865), SC_(1.0), SC_(0.1535916979148232989441429534923433255934243904426417942967453983944561882075132699763070411565227551e-865) }}, 
      {{ SC_(19470.0), SC_(6337.0), SC_(256574.0), SC_(547.0), SC_(0.0001416727725887365638895682254246118116389318947674783794905206026765392144078128095176014103058929108), SC_(0.9991662848140923475988238453780360381433640808415059683771252586656774096509760515032622058321696786), SC_(0.0008337151859076524011761546219639618566359191584940316228747413343225903490239484967377941678303214019) }}, 
      {{ SC_(19470.0), SC_(6337.0), SC_(523360.0), SC_(4336.0), SC_(0.1510467978369016015109342981921083931387236847811407181680377287284441996764123477267772099332623795e-4728), SC_(1.0), SC_(0.2131051427177858975529983166210216525206733828504770597305316224645940075567541118921361604056007946e-4730) }}, 
      {{ SC_(19470.0), SC_(6337.0), SC_(1030167.0), SC_(5554.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2211782118280954899398722497746693543761959609144897826511423685812385086640058543118164969819179618e-8925)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.4304202310799274755480807895729759316481699418880424705685756365777012924467590609649237095478407582e-8928)) }}, 
      {{ SC_(19470.0), SC_(6337.0), SC_(2063277.0), SC_(179.0), SC_(0.23049766659072476426347807323879638114185308974658212599581684909450476497275899453966049664563543e-35), SC_(0.9999999999999999999999999999999999989002472647743172886530766442298171664567391983336481993119822617), SC_(0.1099752735225682711346923355770182833543260801666351800688017738293596159309907276422047256950945498e-35) }}, 
      {{ SC_(19470.0), SC_(6337.0), SC_(2427690.0), SC_(584.0), SC_(0.1618130303195943219798130494053412171339853886101722725477273212413777540426749179431594915149849366e-402), SC_(1.0), SC_(0.1355504994218256111771589554864178440269876545744599576666993147564602076800756782480286809111793953e-403) }}, 
      {{ SC_(19470.0), SC_(10473.0), SC_(50688.0), SC_(9830.0), SC_(0.9674418290489920451976747997725067045241047911961998489425286072267279013317877302465941766013081149e-3995), SC_(1.0), SC_(0.2036887173715511213652506529108111299792292172403127798672855073147844650668137093048567641999105383e-3996) }}, 
      {{ SC_(19470.0), SC_(10473.0), SC_(130605.0), SC_(2826.0), SC_(0.6042565740689057491941436065915365178802514337134171038823908401553588340278317898428935575569488264e-245), SC_(1.0), SC_(0.464948537289295645995813806870861105884351602807747909628101114159172059003092137052035957210474223e-245) }}, 
      {{ SC_(19470.0), SC_(10473.0), SC_(256574.0), SC_(1346.0), SC_(0.4877269032479976797112013889919334364516178940851092435206821928608045038012789457585352463283300296e-81), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999994318142528090597423), SC_(0.5681857471909402577319579368402385134212832724504564685579563299193176894807768023611274710360377139e-81) }}, 
      {{ SC_(19470.0), SC_(10473.0), SC_(523360.0), SC_(6388.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.6303134846919213437841022939979920932617077774400766221604728935833519013708250331645118378225461069e-6635)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1072789140625584948950488568147950074169717674995394311513479950799639417359143617608491001413400413e-6636)) }}, 
      {{ SC_(19470.0), SC_(10473.0), SC_(1030167.0), SC_(3514.0), SC_(0.4650856388543472697289528558391798649347298850141786159456023043137205429457245670680811885418303492e-3348), SC_(1.0), SC_(0.1511257026377704889634320407747334573407716544425454622191489849032441089867381115729474724175506626e-3349) }}, 
      {{ SC_(19470.0), SC_(10473.0), SC_(2063277.0), SC_(8472.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.6956900609689648148217650251329914457768704602953205513843547177523375927186169684821696054403492272e-15889)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.8860885349294031341606035303204472376332105538153414293674597073212153296572512774747711263841723037e-15892)) }}, 
      {{ SC_(19470.0), SC_(10473.0), SC_(2427690.0), SC_(182.0), SC_(0.4070887107163598936083521970978224822130584872142866304202468360697829029410106919538423518665583525e-20), SC_(0.9999999999999999999966652742843983511250920280548384823124510038682308338409990619496706117279726866), SC_(0.3334725715601648874907971945161517687548996131769166159000938050329388272027313419108738256829863514e-20) }}, 
      {{ SC_(19470.0), SC_(19470.0), SC_(50688.0), SC_(4746.0), SC_(0.6607100518678935641853265259506252573604042967056871696668109915077111861127365375909589597914097709e-592), SC_(0.1033889106997365105405739591649103845135881907848742061592841344474400967498936204741949343400912385e-591), SC_(1.0) }}, 
      {{ SC_(19470.0), SC_(19470.0), SC_(130605.0), SC_(1875.0), SC_(0.1098049870440035182462545335674644608369179591906586155318566652749932957723762772990390631402009315e-121), SC_(0.2529936334552406383388907989510614609667519778021028659998279579327795150094195469972190133355813522e-121), SC_(1.0) }}, 
      {{ SC_(19470.0), SC_(19470.0), SC_(256574.0), SC_(18473.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.3848822366938353726164455132869798763440146331494985996562756798359228772224210931039818796481877363e-25421)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.8772943239345008224317975839135770677324328994940501722947823878497612450211539746553963584573220136e-25425)) }}, 
      {{ SC_(19470.0), SC_(19470.0), SC_(523360.0), SC_(8452.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.3604603631364207695817548195435641916380782590408907472004079120282110439177283889511834083089836194e-7317)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.108182147301235502073836221197841302010659233941400709234061094440201140629386934659298388801679249e-7318)) }}, 
      {{ SC_(19470.0), SC_(19470.0), SC_(1030167.0), SC_(19363.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1080611857212819222084276245670534197494561030488028076326539747425279582091171956808322547723075413e-41172)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.632218257025464594202103529816284542305066219817521348362660503207424737471823211660327534873868408e-41179)) }}, 
      {{ SC_(19470.0), SC_(19470.0), SC_(2063277.0), SC_(13500.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2920278119312893012530341750596659906313480384819292092416286142751784010571922875811482495409652887e-24916)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.3787913157856221516861511103786934523999935231044031321312587163056059836724464695326714571970190017e-24919)) }}, 
      {{ SC_(19470.0), SC_(19470.0), SC_(2427690.0), SC_(17286.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.9201368700077278393143795739107406517707243195765353662349833278138008505952242739916601213973402466e-38668)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1055323299112794304018558695329323309417928194065627667687866236100040981130035910878490626560326449e-38671)) }}, 
      {{ SC_(50688.0), SC_(3.0), SC_(130605.0), SC_(2.0), SC_(0.2764984720001450575702492722453106316861498889922581745280457138104943705337584119239780518561815989), SC_(0.9415451799917441329212155335617961356672372867122072573873371746082384632815937391403546831942910189), SC_(0.05845482000825586707878446643820386433276271328779274261266282539176153671840626085964531680570898105) }}, 
      {{ SC_(50688.0), SC_(3.0), SC_(256574.0), SC_(2.0), SC_(0.09395436403009174213576567795533925386642885351932337182484824776729410769032854504124935787617654557), SC_(0.9922899551285189699770853463359264748105362306171369521251011752677100950254768789351446237023295924), SC_(0.007710044871481030022914653664073525189463769382863047874898824732289904974523121064855376297670407581) }}, 
      {{ SC_(50688.0), SC_(3.0), SC_(523360.0), SC_(3.0), SC_(0.0009084283339470566362224572721458761635948007772398809867670825064565695072529491102509403131827176863), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(50688.0), SC_(3.0), SC_(1030167.0), SC_(1.0), SC_(0.1334426287553659315511952430862864339637799435108234648633731361435959757526818040410887918515879574), SC_(0.9929753629029587644239992145221724916733054573086377726152547732497393220464445906237520180513936383), SC_(0.007024637097041235576000785477827508326694542691362227384745226750260677953555409376247981948606361681) }}, 
      {{ SC_(50688.0), SC_(3.0), SC_(2063277.0), SC_(3.0), SC_(0.1482578790241872582865078010438066195274823142463717701979536265004394992775601542473607663065538859e-4), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(50688.0), SC_(3.0), SC_(2427690.0), SC_(2.0), SC_(0.001280481750910045082983531859500493131117683234015710015446518763208187350189777568885007128797263212), SC_(0.9999908985495136834066503234893042241172081707837015814770254123681799801005595262185465566829383874), SC_(0.9101450486316593349676510695775882791829216298418522974587631820019899440473781453443317061612615784e-5) }}, 
      {{ SC_(50688.0), SC_(4.0), SC_(130605.0), SC_(3.0), SC_(0.14307694677263086719453662897480706959713933194960360825641797267660043792757276647706270963354932), SC_(0.9773144166849018497198496908054979030665221196996081594514416677763507271527617578200438260180344663), SC_(0.02268558331509815028015030919450209693347788030039184054855833222364927284723824217995617398196553375) }}, 
      {{ SC_(50688.0), SC_(4.0), SC_(256574.0), SC_(3.0), SC_(0.02474777427549868609153499630560650747212954890708835331773925235250385439567419501369144597723085217), SC_(0.9984768986973936414999690954123281016785686178439090404545359883557772696590328599941050556936259809), SC_(0.001523101302606358500030904587671898321431382156090959545464011644222730340967140005894944306374019138) }}, 
      {{ SC_(50688.0), SC_(4.0), SC_(523360.0), SC_(4.0), SC_(0.8797759484655133227784332079004146949749879603101394996969482942126575469636225070848745017783402786e-4), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(50688.0), SC_(4.0), SC_(1030167.0), SC_(3.0), SC_(0.0004530194801137706758729458395113420057475653609827257772580703306296732009885587102734277188926414289), SC_(0.9999941394117817823386957198010688252709957754708571063146784348376257158321979928400642345301214746), SC_(0.5860588218217661304280198931174729004224529142893685321565162374284167802007159935765469878525409325e-5) }}, 
      {{ SC_(50688.0), SC_(4.0), SC_(2063277.0), SC_(1.0), SC_(0.09120127263139642921683940726685930595930343116404449734170083185680165884242294904407833057462975913), SC_(0.9964964336168940513946820688118961151814598356025686979756985747934174775595708241110885044939737525), SC_(0.003503566383105948605317931188103884818540164397431302024301425206582522440429175888911495506026247498) }}, 
      {{ SC_(50688.0), SC_(4.0), SC_(2427690.0), SC_(3.0), SC_(0.3564572534906767639381479618563787662568301564373566435482127640251969408199012457801660289285267154e-4), SC_(0.9999998099808509503257487771883506335863645915376125153931141176872806030412261704554383339552450467), SC_(0.190019149049674251222811649366413635408462387484606885882312719396958773829544561666044754953297135e-6) }}, 
      {{ SC_(50688.0), SC_(15.0), SC_(130605.0), SC_(9.0), SC_(0.05247442003344390979019042370110221295934814069770111403414887707215934812988460212976154988525313745), SC_(0.9728657691235191594048939665563238019866940491287790944649462291533571003973853498964143699996558337), SC_(0.02713423087648084059510603344367619801330595087122090553505377084664289960261465010358563000034416632) }}, 
      {{ SC_(50688.0), SC_(15.0), SC_(256574.0), SC_(5.0), SC_(0.1000360936394281798299515114316961846406862800300444330474970810566669108654977647842903349678667582), SC_(0.9420521162044971907936251236532407005990539478490508863303650527486924781709833397534697569096447131), SC_(0.05794788379550280920637487634675929940094605215094911366963494725130752182901666024653024309035528695) }}, 
      {{ SC_(50688.0), SC_(15.0), SC_(523360.0), SC_(13.0), SC_(0.5642687866821811349494125985686632781668878192202344105888375096654395589220174564472346660256952172e-11), SC_(0.9999999999999129606331189150547844208257582535446913172833265169708931189286141228396420358334577644), SC_(0.8703936688108494521557917424174645530868271667348302910688107138587716035796416654223560895476987292e-13) }}, 
      {{ SC_(50688.0), SC_(15.0), SC_(1030167.0), SC_(7.0), SC_(0.299973632906468091896880522166350123340913867844037837815392352167405976734485074483686714846949735e-5), SC_(0.999999838339042963819710751030266338896011503654995816350707770256721752868006393232438686330131982), SC_(0.1616609570361802892489697336611039884963450041836492922297432782471319936067675613136698680179639351e-6) }}, 
      {{ SC_(50688.0), SC_(15.0), SC_(2063277.0), SC_(2.0), SC_(0.04586163017462996297753206698339377450903248446584263571445768064210292932021691044845782588816044936), SC_(0.9945949639780252209864322663104026579407950055330553484220063955664422226893942522848657407525365632), SC_(0.005405036021974779013567733689597342059204994466944651577993604433557777310605747715134259247463436756) }}, 
      {{ SC_(50688.0), SC_(15.0), SC_(2427690.0), SC_(4.0), SC_(0.0002056540074997549205983798701553085096027221410706150718067665656172554488393457524267058679578428358), SC_(0.9999900003233820756240254867523870477130186978939967170294997365716463429229016791520692961688135662), SC_(0.9999676617924375974513247612952286981302106003282970500263428353657077098320847930703831186433763971e-5) }}, 
      {{ SC_(50688.0), SC_(29.0), SC_(130605.0), SC_(8.0), SC_(0.07319356182350312817220766304835611215257485779231255682504814335799593880074338894379051983160736196), SC_(0.1464421656802201905601614694529175902850102539933685754218399751881156359857057692538733657318514882), SC_(0.8535578343197798094398385305470824097149897460066314245781600248118843640142942307461266342681485118) }}, 
      {{ SC_(50688.0), SC_(29.0), SC_(256574.0), SC_(17.0), SC_(0.3928789215483463140192296666693405745755895443031111782722644015182901332877079987963084811457291734e-5), SC_(0.9999992508840481764996986808601384568044747451892036238000025693754554322925006929044584642638635631), SC_(0.7491159518235003013191398615431955252548107963761999974306245445677074993070955415357361364368970654e-6) }}, 
      {{ SC_(50688.0), SC_(29.0), SC_(523360.0), SC_(17.0), SC_(0.8853910429342197877304136728622455356640612898483081654238678085635582058727751707951213955482970187e-10), SC_(0.9999999999932574029431453705557273443855468339250614487210771550117426604824773728107705037943348028), SC_(0.674259705685462944427265561445316607493855127892284498825733951752262718922949620566519716251283436e-11) }}, 
      {{ SC_(50688.0), SC_(29.0), SC_(1030167.0), SC_(20.0), SC_(0.4384460259872419930077684553799998983870220864241829914521533737380749398491655935481598674172698609e-19), SC_(0.9999999999999999999990093897562582602299731986723134671762559749188101790866846944987984875897354053), SC_(0.9906102437417397700268013276865328237440250811898209133153055012015124102645946864202026324517218983e-21) }}, 
      {{ SC_(50688.0), SC_(29.0), SC_(2063277.0), SC_(17.0), SC_(0.1660807861530478932545759977592988229578559564056526699073021997622846355075868082539022133418129445e-19), SC_(0.9999999999999999999997171222154582965352521561081697112266126288566017110287274136403416821024982875), SC_(0.2828777845417034647478438918302887733873711433982889712725863596583178975017125114098616661676965677e-21) }}, 
      {{ SC_(50688.0), SC_(29.0), SC_(2427690.0), SC_(22.0), SC_(0.1448597056350805209220829495480514970009615456230753820524019997828031239023587129832918764538449747e-30), SC_(0.9999999999999999999999999999999990552348032395308793763489142949177303740736305649150239693616185025), SC_(0.9447651967604691206236510857050822696259263694350849760306383814974971036844993837588733148154674306e-33) }}, 
      {{ SC_(50688.0), SC_(36.0), SC_(130605.0), SC_(15.0), SC_(0.1259484206249360348513010611713824499965443119101663801704861268095564673629356869370144249420033985), SC_(0.7023808083582244039447940504223402789477689228163365391422787591578053034264459385203304846777355377), SC_(0.2976191916417755960552059495776597210522310771836634608577212408421946965735540614796695153222644623) }}, 
      {{ SC_(50688.0), SC_(36.0), SC_(256574.0), SC_(24.0), SC_(0.1110823095009622278140138219900695363896754933509284568456603676005576135308412145652936525502616523e-8), SC_(0.9999999998537736746015429390784732417903884954941886303576423656189332828508303431485054492164607769), SC_(0.146226325398457060921526758209611504505811369642357634381066717149169656851494550783539223077692803e-9) }}, 
      {{ SC_(50688.0), SC_(36.0), SC_(523360.0), SC_(35.0), SC_(0.1049899050616898046021961745132676608217162698908825130864342356982859979148857869491814755312503403e-33), SC_(0.9999999999999999999999999999999999996874709887447336235677733991470860916706632001576573692065091096), SC_(0.3125290112552663764322266008529139083293367998423426307934908903836093178850077394372520124076129808e-36) }}, 
      {{ SC_(50688.0), SC_(36.0), SC_(1030167.0), SC_(21.0), SC_(0.8858731423829874722346452575387430708984499379563715955742634595638771877534040913193643686473953601e-18), SC_(0.999999999999999999967743240681702903304120918518178406516818875862738247276042741459271428968619409), SC_(0.3225675931829709669587908148182159348318112413726175272395725854072857103138059104452415490967935802e-19) }}, 
      {{ SC_(50688.0), SC_(36.0), SC_(2063277.0), SC_(27.0), SC_(0.2588630094581956354927274083523033572568904816761478016524318017432586401178076557684425484133292401e-35), SC_(0.9999999999999999999999999999999999999789089687376409982308546375964617380708175234252957737347305661), SC_(0.2109103126235900176914536240353826192918247657470422626526943386505878767143311656900134775597742464e-37) }}, 
      {{ SC_(50688.0), SC_(36.0), SC_(2427690.0), SC_(17.0), SC_(0.1564158937845907441774880788365562972313769184299102194693841209138378177884592651756894959697516243e-18), SC_(0.9999999999999999999964079970815350325147324129986534372162325882775683189785725189407766574084699117), SC_(0.3592002918464967485267587001346562783767411722431681021427481059223342591530088341099175048576735897e-20) }}, 
      {{ SC_(50688.0), SC_(126.0), SC_(130605.0), SC_(30.0), SC_(0.0001387944958451400808585901637273360084101465449300987830220010599565630499681561656093624729942940619), SC_(0.000261877701902292343829694954664116943503382088413562856209856814206690669744639518201397673358250001), SC_(0.99973812229809770765617030504533588305649661791158643714379014318579330933025536048179860232664175) }}, 
      {{ SC_(50688.0), SC_(126.0), SC_(256574.0), SC_(59.0), SC_(0.5090770180515041500516062291517475747021034604670994067800680540487601865174302199855115883793674385e-11), SC_(0.9999999999981019590766620914933351940868744841198432673325858444041255904515101487059763890313002419), SC_(0.1898040923337908506664805913125515880156732667414155595874409548489851294023610968699758074114095477e-11) }}, 
      {{ SC_(50688.0), SC_(126.0), SC_(523360.0), SC_(29.0), SC_(0.5622561180081454407109700694699974600963467784560832735256714104287084983934791659121400909853534377e-5), SC_(0.9999971100176595310307770440762403990351816570476502042568514918299705345047730147181391733329455674), SC_(0.2889982340468969222955923759600964818342952349795743148508170029465495226985281860826667054432571477e-5) }}, 
      {{ SC_(50688.0), SC_(126.0), SC_(1030167.0), SC_(29.0), SC_(0.2430282031472564929384099583556501086227785194618714844485471055018366406972460097737635824717173569e-11), SC_(0.9999999999995167300257939856011842817479807036060753069955313653747534730526856051338217857617061828), SC_(0.4832699742060143988157182520192963939246930044686346252465269473143948661782142382938171823307171486e-12) }}, 
      {{ SC_(50688.0), SC_(126.0), SC_(2063277.0), SC_(7.0), SC_(0.02362699916547517426299574304268617757887557349152041552832568456711121825928989430936364128992208509), SC_(0.9870668486827021314708130821636693593340444258037735627333123563999492695720444765296056669701056146), SC_(0.01293315131729786852918691783633064066595557419622643726668764360005073042795552347039433302989438544) }}, 
      {{ SC_(50688.0), SC_(126.0), SC_(2427690.0), SC_(83.0), SC_(0.129424852799356234617791259661500453618668862158133716737257015907538713721765392805891089029906018e-105), SC_(1.0), SC_(0.1425507213811858904147779926564279615129837872327818586744171055137236455184362092392277930289842699e-107) }}, 
      {{ SC_(50688.0), SC_(244.0), SC_(130605.0), SC_(22.0), SC_(0.4081907272247252429240167241130521118065700884166238649865332650987969147497685124679841475390563238e-25), SC_(0.4823748925689423145905173669329529626934228942883958453972373434877467599871860345038036748751641664e-25), SC_(0.9999999999999999999999999517625107431057685409482633067047037306577105711604154602762656512253240013) }}, 
      {{ SC_(50688.0), SC_(244.0), SC_(256574.0), SC_(157.0), SC_(0.6311377940553899302938229917144039596020698158478927411465458817027317787642431855163857794926275339e-51), SC_(0.9999999999999999999999999999999999999999999999999999016441281617296648500227771361604726713907218321), SC_(0.9835587183827033514997722286383952732860927816785971891326525874164303229912688523934906879493472245e-52) }}, 
      {{ SC_(50688.0), SC_(244.0), SC_(523360.0), SC_(55.0), SC_(0.1611398155089557237532005991213957890467760071667644169180403185378083641160441429413478005634083083e-8), SC_(0.9999999991043152888023419080048876156695691120327732052125502732745681234587508911937337193433057921), SC_(0.8956847111976580919951123843304308879672267947874497267254318765412491088062662806566942079402339213e-9) }}, 
      {{ SC_(50688.0), SC_(244.0), SC_(1030167.0), SC_(43.0), SC_(0.3268082722727454190737883347579826403264881410285643211737821318954579283484134510313054943121559353e-12), SC_(0.9999999999998999788582775576056187791514379654812421585831742314636988810582564081768299995358692406), SC_(0.1000211417224423943812208485620345187578414168257685363011189417435918231700004641307594268117568485e-12) }}, 
      {{ SC_(50688.0), SC_(244.0), SC_(2063277.0), SC_(49.0), SC_(0.9185667814154646621113888593604746805207170436872234271880683418505628247859248981674362827789658369e-29), SC_(0.9999999999999999999999999999990033875316607142079609775578687759337118037391128430824563105848779537), SC_(0.9966124683392857920390224421312240662881962608871569175436894151220463323598971854104029783423517539e-30) }}, 
      {{ SC_(50688.0), SC_(244.0), SC_(2427690.0), SC_(18.0), SC_(0.3721920863227773236539244121937994205449502198356711572704473080160434273999337158336900936997000468e-5), SC_(0.9999987644016630718116109122771042938539564507570212951759110850104874713067055917455143601039120508), SC_(0.1235598336928188389087722895706146043549242978704824088914989512528693294408254485639896087949202581e-5) }}, 
      {{ SC_(50688.0), SC_(312.0), SC_(130605.0), SC_(64.0), SC_(0.1863467989281252475688400811720170663630099492050205287420245659584848638772797031107463290686710106e-11), SC_(0.3102421156740312627521540514634585135649732739482336536454599142511167346271048688884066090001098319e-11), SC_(0.9999999999968975788432596873724784594853654148643502672605176634635454008574888326537289513111159339) }}, 
      {{ SC_(50688.0), SC_(312.0), SC_(256574.0), SC_(96.0), SC_(0.1146531366108868019964889567904154860795373220971914269106747526819277133621885908289048704791415159e-5), SC_(0.9999986606386213211687177403053375564930921692026979311881118617994930405993266697911200669959243233), SC_(0.1339361378678831282259694662443506907830797302068811888138200506959400673330208879933004075676710816e-5) }}, 
      {{ SC_(50688.0), SC_(312.0), SC_(523360.0), SC_(185.0), SC_(0.8437829993353056188064151058596627950254047793893780262092590956338303722028115195456193202962707386e-103), SC_(1.0), SC_(0.6634631530392767075661358209748960365858961481473867486304479720393779051471487047779906643854214406e-104) }}, 
      {{ SC_(50688.0), SC_(312.0), SC_(1030167.0), SC_(56.0), SC_(0.4703450930888031207766512405035230794080870543865565284003629730044892675131042471092948858499063446e-16), SC_(0.9999999999999999858887822176118831884162508469915974630141851008268684834014327997772496266736936527), SC_(0.141112177823881168115837491530084025369858148991731315165985672002227503733263063473160381474442426e-16) }}, 
      {{ SC_(50688.0), SC_(312.0), SC_(2063277.0), SC_(137.0), SC_(0.1218547347135289074971894895001704338551002402371255526964107510057323150333950708167167680596869209e-130), SC_(1.0), SC_(0.4007587004152288701417164130815267886103044651951954288599286359661630360383308034024294287671036356e-132) }}, 
      {{ SC_(50688.0), SC_(312.0), SC_(2427690.0), SC_(192.0), SC_(0.1208208470822887396815143837753680796957203158493039960190496662392581440626327661828534277915697643e-234), SC_(1.0), SC_(0.1617001995277928286830468772117034174042878579244268353945422521212084911452496493817622879637153686e-236) }}, 
      {{ SC_(50688.0), SC_(835.0), SC_(130605.0), SC_(721.0), SC_(0.2267532605293643719720841325012631356836415961781563208021348698047136410175147934019910363642765811e-178), SC_(1.0), SC_(0.2484570966400773628205309687729155611920663644553179182669426966334335459357553242232541749926225647e-179) }}, 
      {{ SC_(50688.0), SC_(835.0), SC_(256574.0), SC_(8.0), SC_(0.8665052124246840701051498253673093111320627564833462637429216441524433084767242366235673241153533351e-66), SC_(0.9015710038844603939325355380910700965247054723374243306068187707540814207954023355350480849134786603e-66), SC_(0.9999999999999999999999999999999999999999999999999999999999999999990984289961155396060674644619089299) }}, 
      {{ SC_(50688.0), SC_(835.0), SC_(523360.0), SC_(809.0), SC_(0.1859042591825835827813526766350758676631525063184102762464638224971605606051708997786385628594982962e-774), SC_(1.0), SC_(0.631790940364326310241333846000480080375272364515628797823663447947946649210060275294311198602968346e-777) }}, 
      {{ SC_(50688.0), SC_(835.0), SC_(1030167.0), SC_(176.0), SC_(0.3561446975730348443345791512087258604108261252130485894283476123998246071864208938892243958883519266e-59), SC_(0.9999999999999999999999999999999999999999999999999999999999991547558792654047987329719663117945542579), SC_(0.8452441207345952012670280336882054457421217462722064495329566662811253018223963512396418973523418772e-60) }}, 
      {{ SC_(50688.0), SC_(835.0), SC_(2063277.0), SC_(704.0), SC_(0.2914405790587010256004944425158507790475444281763417986300480845818728490818906427498233696121135309e-980), SC_(1.0), SC_(0.1351222336790418628853266341039949871706597413451011602275906251664948226889910395115932552814051411e-982) }}, 
      {{ SC_(50688.0), SC_(835.0), SC_(2427690.0), SC_(54.0), SC_(0.5610828584183052995253463840717331764488132628873057452894684724697099689893368523507602390049598617e-12), SC_(0.9999999999997593513322365911571194242047632486627868867585213351262895128174352301060894319581810041), SC_(0.2406486677634088428805757952367513372131132414786648737104871825647698939105680418189958557949188322e-12) }}, 
      {{ SC_(50688.0), SC_(1339.0), SC_(130605.0), SC_(10.0), SC_(0.1761883761629274082408176792810414844498463367247005769872576733400741106091940560973970423202387997e-264), SC_(0.1782643701814165566385865693557760598580551793454340774414384699589626446637309417919944412082873586e-264), SC_(1.0) }}, 
      {{ SC_(50688.0), SC_(1339.0), SC_(256574.0), SC_(904.0), SC_(0.3426053846781284578257162900743300008431664963377792340186833483752695816875538689363648447039554554e-315), SC_(1.0), SC_(0.4514109479691319728213064961932984759495038716335415818430528851964542785430316550068972717559346066e-316) }}, 
      {{ SC_(50688.0), SC_(1339.0), SC_(523360.0), SC_(540.0), SC_(0.6701940135134178997673867737968644555490441058185752676360214362943374319057135054532331584824295497e-193), SC_(1.0), SC_(0.1246892159457303282710817379897730381641937087698361476270835496786631388700170617593019908026711202e-193) }}, 
      {{ SC_(50688.0), SC_(1339.0), SC_(1030167.0), SC_(265.0), SC_(0.25397058485005452333643108333479112288965993567076258486145894778536056811294021833345299508208273e-82), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999933371265461839084), SC_(0.6662873453816091641171487682280140674203238438171282979452153376872292350427257913550974763616755557e-83) }}, 
      {{ SC_(50688.0), SC_(1339.0), SC_(2063277.0), SC_(589.0), SC_(0.4554043870838746494878734017251437425694403171408324534775615784234176891092113498774693546873742209e-560), SC_(1.0), SC_(0.1488563753309414675247132976219096838186775374273659126445460863321900676458192134929253908718522006e-561) }}, 
      {{ SC_(50688.0), SC_(1339.0), SC_(2427690.0), SC_(1233.0), SC_(0.2274099244615176720565783840461605734183540766176723553780844467627817909491842573820404504853697591e-1919), SC_(1.0), SC_(0.4071635295708463171557116956598442326096836048762636050416215263862154880736630328654729855400141188e-1922) }}, 
      {{ SC_(50688.0), SC_(2247.0), SC_(130605.0), SC_(1843.0), SC_(0.3712754956045638835642552802136706654722437288495307433042225580220224047095745757784013770031009036e-392), SC_(1.0), SC_(0.5770735764761529073756603675933720444202293440970003980620948112296203345541524775817778537118022664e-393) }}, 
      {{ SC_(50688.0), SC_(2247.0), SC_(256574.0), SC_(579.0), SC_(0.6240433929880838427351228611622496023106977050532788684606445113988890944008769621056663430258536371e-12), SC_(0.9999999999985309959941877313867908174828620158264911064860567088899929955407021211042372103860338516), SC_(0.1469004005812268613209182517137984173508893513943291110007004459297878895762789613966148376640239257e-11) }}, 
      {{ SC_(50688.0), SC_(2247.0), SC_(523360.0), SC_(128.0), SC_(0.1800059909566142633260570893763704573630142700199029565727074155242458483294896247577830562180086999e-11), SC_(0.4056001347830390897132477754602568509912027397712361753174300878339979115982970968582383416988825253e-11), SC_(0.9999999999959439986521696091028675222453974314900879726022876382468256991216600208840170290314176166) }}, 
      {{ SC_(50688.0), SC_(2247.0), SC_(1030167.0), SC_(1929.0), SC_(0.1136930856812777225324182939933607132142805397684336282192271049438282518309220705439739738718925019e-2148), SC_(1.0), SC_(0.9405216133650580240750587310948263523328665764326709731207146532997497642766399959805035901220376451e-2151) }}, 
      {{ SC_(50688.0), SC_(2247.0), SC_(2063277.0), SC_(1173.0), SC_(0.2760338454238488944078662658925132812500697445456866362834795987795357890374229294296190843680787752e-1231), SC_(1.0), SC_(0.6358944773273525474245072822012563616215011419541016779133352348951301482177773017321526688146420849e-1233) }}, 
      {{ SC_(50688.0), SC_(2247.0), SC_(2427690.0), SC_(721.0), SC_(0.1463458494789646680547915433468309849576787104140199003078461786129789745299429086665758947729413336e-616), SC_(1.0), SC_(0.6808272015011699448629235377829659254791698899156146639723167222989895704614003005493401462716089444e-618) }}, 
      {{ SC_(50688.0), SC_(6337.0), SC_(130605.0), SC_(3960.0), SC_(0.2497493189235217859158737196689966331064916885139271576222591618957630432230624975995086255270938898e-332), SC_(1.0), SC_(0.1413946631942133264330327091054308780289213196440348455555338773472344404334633254790183156034541357e-332) }}, 
      {{ SC_(50688.0), SC_(6337.0), SC_(256574.0), SC_(4257.0), SC_(0.4434741681154088796039267574522822499947535596435063542623680692911293451987879412803055887262549873e-1507), SC_(1.0), SC_(0.5552752279629776116597907302530098094428980747376535012274876603004117003768816851579517863372816956e-1508) }}, 
      {{ SC_(50688.0), SC_(6337.0), SC_(523360.0), SC_(1305.0), SC_(0.3537735708449225524542920994258980963477682677844021867347790519362553170140640451208229458833729909e-150), SC_(1.0), SC_(0.2424089890997157903722090475554067680925048971757603376769648866198870822400941580103710515096243734e-150) }}, 
      {{ SC_(50688.0), SC_(6337.0), SC_(1030167.0), SC_(2426.0), SC_(0.8413889707953685607398579410145940612732705208469574410338257506096646089873367403993195419749938159e-1450), SC_(1.0), SC_(0.7288092213979607846274503112549837277404656767972073506786853056546181045633557768632125468111176175e-1451) }}, 
      {{ SC_(50688.0), SC_(6337.0), SC_(2063277.0), SC_(1917.0), SC_(0.5693062903650310255551999349604138748544039873271059887370419033457596754804951608078003958684501485e-1462), SC_(1.0), SC_(0.3374993002333740318156175539338186388812948303133438337716503987322545925630335180383611623700040546e-1463) }}, 
      {{ SC_(50688.0), SC_(6337.0), SC_(2427690.0), SC_(2545.0), SC_(0.9736934715805270406375226118159039151260698119631787834265533092089163830169563294724537814203662646e-2485), SC_(1.0), SC_(0.3033497048729743576393110181130406106727109611749605741359053387152229150380508505252449925339178692e-2486) }}, 
      {{ SC_(50688.0), SC_(10473.0), SC_(130605.0), SC_(5592.0), SC_(0.2785191513785134033986022411189184153603464538929775812052509249224069205639313396930574138293815467e-217), SC_(1.0), SC_(0.306894457100004213585926772356829751085951883384625694936596193286828242206665984403922851752125969e-217) }}, 
      {{ SC_(50688.0), SC_(10473.0), SC_(256574.0), SC_(3581.0), SC_(0.4371876976865122387900351475941039463271912507913014836367940914258376648337855692689559010840515797e-274), SC_(1.0), SC_(0.3654364313610882513864038087654891914933527977295139602246869799118571480131288719735830622130231546e-274) }}, 
      {{ SC_(50688.0), SC_(10473.0), SC_(523360.0), SC_(10329.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.9187213071868954797061141103738131449813225440710356644695429524728836679723953800941852053708477683e-10596)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1095144975439045128508551829904143672040284883421282653889175492346878852177494188486150532189350013e-10598)) }}, 
      {{ SC_(50688.0), SC_(10473.0), SC_(1030167.0), SC_(6695.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.8574428784197600013935801365268519236314495886889813386792426869831463095080122135215061173109542542e-6049)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2238227904168495477814894519049047112063658171092890490751937705304305038962977508185697075131167679e-6050)) }}, 
      {{ SC_(50688.0), SC_(10473.0), SC_(2063277.0), SC_(985.0), SC_(0.1038893043305132924971058993134930857459402698808777611090194898741609560450885963341197438722536372e-273), SC_(1.0), SC_(0.3257076303535239915873637404375881493075625880240821173439000846029753528518053237212793221095937461e-274) }}, 
      {{ SC_(50688.0), SC_(10473.0), SC_(2427690.0), SC_(9617.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.8685563497510674603433198239849290641129017747115633411292255415976852726026459668605036465182552509e-15296)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1338186671384293216373520269261752072046305605495429364997640157280935158290476905572242417247615517e-15298)) }}, 
      {{ SC_(50688.0), SC_(19470.0), SC_(130605.0), SC_(3906.0), SC_(0.1136448073361652765729372360861900261319235847896468264628805135461850604997462244218295378951256123e-797), SC_(0.1735378415073763363528046464370220003081861918334199870180535753913441955644566502426869568935064481e-797), SC_(1.0) }}, 
      {{ SC_(50688.0), SC_(19470.0), SC_(256574.0), SC_(7224.0), SC_(0.5756580306206841958399288117878792482130802504134133610464063192136401354466291393461256814192079598e-751), SC_(1.0), SC_(0.3533985870884177165609809919092198032909933787985312831230484797240014965791527954221111108741869478e-751) }}, 
      {{ SC_(50688.0), SC_(19470.0), SC_(523360.0), SC_(2382.0), SC_(0.3182045701079864978526847142019869559022999170714136808929653595476183463307682305669805497406358151e-32), SC_(0.9999999999999999999999999999999899711442113659553897251233070776072449995001393135072963883114289883), SC_(0.1002885578863404461027487669292239275500049986068649270361168857101168143887929671776145224825639961e-31) }}, 
      {{ SC_(50688.0), SC_(19470.0), SC_(1030167.0), SC_(5364.0), SC_(0.2114498134883001603226056389526279755252205603431069039950465242128791378540856389747338586240121859e-2441), SC_(1.0), SC_(0.2977655275872109800018448227737716845657463418141362594831149991408648202210951634956881692997961538e-2442) }}, 
      {{ SC_(50688.0), SC_(19470.0), SC_(2063277.0), SC_(11441.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1509853903270870936802635484938647844481142951185798601047363029719142289630141961763250751903331965e-13349)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2103236900158731356196841216053575703186145954391727879329116757248008141335707263652220608455613207e-13351)) }}, 
      {{ SC_(50688.0), SC_(19470.0), SC_(2427690.0), SC_(4866.0), SC_(0.3883884429092439964632911166840613140287259038053965706100313039934673720792472188444024568957229689e-3648), SC_(1.0), SC_(0.2400108941518520625449479920600319411084357100075119164256874162248980585743583088336218754327682661e-3649) }}, 
      {{ SC_(50688.0), SC_(50688.0), SC_(130605.0), SC_(46223.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.3443067269148505778480030700985314157768169093651821148169166762598418380322455240566124656494015149e-23845)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1979396386808494407850496257706113428034344394210735947592885012110960512901150591517716644829855898e-23847)) }}, 
      {{ SC_(50688.0), SC_(50688.0), SC_(256574.0), SC_(16273.0), SC_(0.1159720744568197975123418471084877540416304150721431728754470723580088383687225811875372757237866643e-1207), SC_(1.0), SC_(0.8550568670375097548114032966650537099884052933018818114404413426121714496576958238165121760482736096e-1208) }}, 
      {{ SC_(50688.0), SC_(50688.0), SC_(523360.0), SC_(20674.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.419480940082394086752609733598960520616618506545738091176401487278666947944642453478421082042933211e-8877)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.4579732894756637004550162011941316363474520104725206428826622002243174193914412371046171447709486282e-8878)) }}, 
      {{ SC_(50688.0), SC_(50688.0), SC_(1030167.0), SC_(17049.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2334869537804768144778554432539282382440254266411758900236601125068549941671954741570430522816337625e-10099)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.176196755959116478043089022272457369305761946598086294101723970172516853039302801164206072470106248e-10100)) }}, 
      {{ SC_(50688.0), SC_(50688.0), SC_(2063277.0), SC_(47693.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.1309571810813476255934290861530654028023516893569609835983309435748925670963664516791458127563337275e-88623))), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.1225720081608688720708171718316726630515550015657569958938378905276985438282384848240219585917089981e-88627))) }}, 
      {{ SC_(50688.0), SC_(50688.0), SC_(2427690.0), SC_(38180.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.120786417308213648360438112200887363983275073758493529667892959852615387107808026075588249453542258e-60732))), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.209682060473765074456490562707219747653261712065270648841731318453704790197552697278749376201478259e-60735))) }}, 
      {{ SC_(130605.0), SC_(3.0), SC_(256574.0), SC_(3.0), SC_(0.1318975042672631916351931594641949123343709616065456587677049240545315611688183642468941875234380504), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(130605.0), SC_(3.0), SC_(523360.0), SC_(1.0), SC_(0.4216230122650608141283913203772314662195951416703022601007813938539587944543746161100036926484732075), SC_(0.8442553845227319852968460152003464313233932368847177969264827957340656353733675391109427513550824493), SC_(0.1557446154772680147031539847996535686766067631152822030735172042659343646266324608890572486449175507) }}, 
      {{ SC_(130605.0), SC_(3.0), SC_(1030167.0), SC_(2.0), SC_(0.04210629233596505946733790089798324254604568138083350534616786146070031274138959244722459105693253904), SC_(0.997962264562103911065750987009611601562300614400719091328622314263169889049803913054144016428282539), SC_(0.002037735437896088934249012990388398437699385599280908671377685736830110950196086945855983571717460979) }}, 
      {{ SC_(130605.0), SC_(3.0), SC_(2063277.0), SC_(2.0), SC_(0.01125961942855772744015631318434084023358598160698574485197675202235515831399247052946615540342241901), SC_(0.9997463718492277487890915211391595906673891500203143352424514317062277587321961755606089317674349669), SC_(0.0002536281507722512109084788608404093326108499796856647575485682937722412678038244393910682325650330967) }}, 
      {{ SC_(130605.0), SC_(3.0), SC_(2427690.0), SC_(1.0), SC_(0.1444960081355932247657942552948969948039297795851699290971243354867533025405404003470485198339893498), SC_(0.9916287719555921822449233476868877902436026606102478261664291347686270162088915340094014827159779789), SC_(0.008371228044407817755076652313112209756397339389752173833570865231372983791108465990598517284022021104) }}, 
      {{ SC_(130605.0), SC_(4.0), SC_(256574.0), SC_(2.0), SC_(0.3747580965076081054119804271003901389218490882305659062865471644366021088270991346895535718472315441), SC_(0.6738288243313366853529273166861279739795728317767874136842593870699069174529152943134942508517382776), SC_(0.3261711756686633146470726833138720260204271682232125863157406129300930825470847056865057491482617224) }}, 
      {{ SC_(130605.0), SC_(4.0), SC_(523360.0), SC_(4.0), SC_(0.003878127955740012803480724279404446351245153433294704393591067139972404765475410364470926583948232644), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(130605.0), SC_(4.0), SC_(1030167.0), SC_(1.0), SC_(0.3376631324608786281606885440229728710059385291068656394183115221706588340007709404490037009541767298), SC_(0.9190878669147194418156037960668483981090951029456217125577336242514431520330182581637480762311392535), SC_(0.08091213308528055818439620393315160189090489705437828744226637574855684796698174183625192376886074654) }}, 
      {{ SC_(130605.0), SC_(4.0), SC_(2063277.0), SC_(2.0), SC_(0.02109379553138370536292740756515440608962731334602650592099232705670428548003061956674395480505862941), SC_(0.9990336501863618740303989117373959534786168250863418433509708432122205828091380771425715400086662898), SC_(0.000966349813638125969601088262604046521383174913658156649029156787779417190861922857428459991333710197) }}, 
      {{ SC_(130605.0), SC_(4.0), SC_(2427690.0), SC_(2.0), SC_(0.01554710854120899236788910013402446617654783745428593836009405389741037882416569698665248227933746758), SC_(0.9994023262261966784288678977539000233318765793373907953464761617173287274303398455066255684768118985), SC_(0.0005976737738033215711321022460999766681234206626092046535238382826712725696601544933744315231881015344) }}, 
      {{ SC_(130605.0), SC_(15.0), SC_(256574.0), SC_(3.0), SC_(0.01177078755849811366676412770865313864347032966249704275533133709627321776750182141632050057530459809), SC_(0.0147746236531830851702900386538399505094323350793431319748345689510146280710294355871065477218837393), SC_(0.9852253763468169148297099613461600494905676649206568680251654310489853719289705644128934522781162607) }}, 
      {{ SC_(130605.0), SC_(15.0), SC_(523360.0), SC_(13.0), SC_(0.860456533202643972879340187445211692580024519690114258320221628516574591685506641421023639967460578e-6), SC_(0.9999999582219116208503069681747470077791702515209799231412133090551544886884092154305173678154738273), SC_(0.4177808837914969303182525299222082974847902007685878669094484551131159078456948263218452617270295371e-7) }}, 
      {{ SC_(130605.0), SC_(15.0), SC_(1030167.0), SC_(13.0), SC_(0.1749439171492812191573682940799402257691166257101827559368883223578198849007731796319125630194269269e-9), SC_(0.9999999999963367234572553938678540208666361862340098748195011023228095597563917243204391549753468451), SC_(0.3663276542744606132145979133363813765990125180498897677190440243608275679560845024653154931414500087e-11) }}, 
      {{ SC_(130605.0), SC_(15.0), SC_(2063277.0), SC_(2.0), SC_(0.1798055577963848591814337565981257845971545706080468361132481334268536886597471786353640151741292424), SC_(0.9348904853985450731745560952235334755889757406447682566961684215912058271562046932113158311852330896), SC_(0.06510951460145492682544390477646652441102425935523174330383157840879417284379530678868416881476691037) }}, 
      {{ SC_(130605.0), SC_(15.0), SC_(2427690.0), SC_(6.0), SC_(0.7375987170742357267595439265101641200570654415269850267355161556583030771858888449704791153961049044e-4), SC_(0.9999942876888026561794532452501108077219817537201748229043104177264168108933988142301343495545818131), SC_(0.5712311197343820546754749889192278018246279825177095689582273583189106601185769865650445418186890584e-5) }}, 
      {{ SC_(130605.0), SC_(29.0), SC_(256574.0), SC_(1.0), SC_(0.3295779417990237417238485212451621550250245499736773588685645769516973095235686393492468513704681571e-7), SC_(0.3405368546484052933770812106558851872176471107216644851609956613047211576517645440865591467249651018e-7), SC_(0.9999999659463145351594706622918789344114812782352889278335514839004338695278842348235455913440853275) }}, 
      {{ SC_(130605.0), SC_(29.0), SC_(523360.0), SC_(26.0), SC_(0.326682705780807338874725164323113052222982441690986856319178199033269176224146154756663633234607065e-12), SC_(0.9999999999999876420658934249060333143385949128453293165765235519200697275762296887041318624447400157), SC_(0.1235793410657509396668566140508715467068342347644807993027242377031129586813755525998428385918575824e-13) }}, 
      {{ SC_(130605.0), SC_(29.0), SC_(1030167.0), SC_(17.0), SC_(0.575690261852457271257056550075553553597608724211602521228246526767251401910458100310147617990144997e-8), SC_(0.9999999993923981600181539192236893280884058395811472380889742347594235929919641788958059299083900642), SC_(0.6076018399818460807763106719115941604188527619110257652405764070080358211041940700916099358259128029e-9) }}, 
      {{ SC_(130605.0), SC_(29.0), SC_(2063277.0), SC_(23.0), SC_(0.8665796433590857092906103631484825501588359205738729812939062896502887989896417068955531332956619319e-22), SC_(0.9999999999999999999999985162362691158158930531527057289884274671636622377815417356673339060650920804), SC_(0.1483763730884184106946847294271011572532836337762218458264332666093934907919627748539612831767448875e-23) }}, 
      {{ SC_(130605.0), SC_(29.0), SC_(2427690.0), SC_(23.0), SC_(0.2185116398568241182796644002863714808934600258955645080902071296725238053469550139123773040860836439e-23), SC_(0.9999999999999999999999999685895244369725311069292052101466596426942719736720491483749914446869548254), SC_(0.3141047556302746889307079478985334035730572802632795085162500855531304517458346021592252799714815796e-25) }}, 
      {{ SC_(130605.0), SC_(36.0), SC_(256574.0), SC_(2.0), SC_(0.5101512222601927369726693600808362189672162819317495913203431944250500501743269999901193191985427187e-8), SC_(0.5390134653923981476366978792174395166490035711914990956075358877145242035327232840223352858803106508e-8), SC_(0.9999999946098653460760185236330212078256048335099642880850090439246411228547579646727671597766471412) }}, 
      {{ SC_(130605.0), SC_(36.0), SC_(523360.0), SC_(10.0), SC_(0.136493108464999074061740791027989338870863918509665918237363774779637520100217835650826999621912944), SC_(0.7272696041808074705430257532969418591781290977105104627544912703338577672179305791382171510271199986), SC_(0.2727303958191925294569742467030581408218709022894895372455087296661422327820694208617828489728800014) }}, 
      {{ SC_(130605.0), SC_(36.0), SC_(1030167.0), SC_(31.0), SC_(0.2987315840702217744259202361645366829213733193492154541199627915130443077273020807777005658852535016e-22), SC_(0.9999999999999999999999993103951710020420081226067754399613243526739916862610668450154356919029388715), SC_(0.6896048289979579918773932245600386756473260083137389331549845643080970611284611878471007366581005581e-24) }}, 
      {{ SC_(130605.0), SC_(36.0), SC_(2063277.0), SC_(4.0), SC_(0.1166761778854893763399269474252383526675785194059032679974297800074162887116674894763295757468874662), SC_(0.9252488714678591774192605770890874441700163526999830676964124434746162552233775148416688987654771897), SC_(0.07475112853214082258073942291091255582998364730001693230358755652538374477662248515833110123452281033) }}, 
      {{ SC_(130605.0), SC_(36.0), SC_(2427690.0), SC_(23.0), SC_(0.7218352750669080483564560298487177393862925659366350614071409593948511094934059806430680287813639088e-20), SC_(0.999999999999999999999771517174425772075460381219809390385471325676515243545165854553985376621315997), SC_(0.2284828255742279245396187801906096145286743234847564548341454460146233786840030021240533853412194416e-21) }}, 
      {{ SC_(130605.0), SC_(126.0), SC_(256574.0), SC_(2.0), SC_(0.9707375528817508185391408790684080253218403476481107506237841506485461972798383737895958089696769048e-35), SC_(0.9858178466005984890604024034038276803158486832198690169477304185381333834804732743364853096475136121e-35), SC_(0.9999999999999999999999999999999999901418215339940151093959759659617231968415131678013098305226958146) }}, 
      {{ SC_(130605.0), SC_(126.0), SC_(523360.0), SC_(13.0), SC_(0.2022892240769376560545043209102707470963609787612930030068991475329179133314412672111653157002734107e-4), SC_(0.3016574784880889158485537137743238809966933213256521531974871435028039756059711409225942088906436973e-4), SC_(0.9999698342521511911084151446286225676119003306678674347846802512856497196024394028859077405791109356) }}, 
      {{ SC_(130605.0), SC_(126.0), SC_(1030167.0), SC_(22.0), SC_(0.02854554882608713712964270546332056093361882459284458770014589486457761646849359389237423308213247939), SC_(0.9546283730267259104330949442093933690658933743310895405269929124049127968345256630034414233355647741), SC_(0.0453716269732740895669050557906066309341066256689104594730070875950872031654743369965585766644352259) }}, 
      {{ SC_(130605.0), SC_(126.0), SC_(2063277.0), SC_(32.0), SC_(0.7815475019873548308886820119578427046175092505342109242838539735641542354037469106181270268269716151e-11), SC_(0.9999999999981584560464463285346553308897401090202955161980387140383475984902508387018497777559181212), SC_(0.184154395355367146534466911025989097970448380196128596165240150974916129815022224408187884947082889e-11) }}, 
      {{ SC_(130605.0), SC_(126.0), SC_(2427690.0), SC_(123.0), SC_(0.2000977400579375486451775772042143714031769471510556204224694719831244142560733079686336611437751968e-150), SC_(1.0), SC_(0.2752392563116136217827423080787966744827209037593138361635936694983492467610694640458227327255264656e-153) }}, 
      {{ SC_(130605.0), SC_(244.0), SC_(256574.0), SC_(124.0), SC_(0.05104063660656530446811408814241145139083077358011364119038499706906751980515200351609432412428969492), SC_(0.5149462790998946728905516206286694647392786753447349540162459983938881303304520090834355099038377837), SC_(0.4850537209001053271094483793713305352607213246552650459837540016061118696695479909165644900961622163) }}, 
      {{ SC_(130605.0), SC_(244.0), SC_(523360.0), SC_(64.0), SC_(0.0522277270978473035028656367669750588078473613184992246190994091567368986465543013319929249631654059), SC_(0.7063642668141795750506609502358155465274532231904029967168091017845423244675038032894081999936358272), SC_(0.2936357331858204249493390497641844534725467768095970032831908982154576755324961967105918000063641728) }}, 
      {{ SC_(130605.0), SC_(244.0), SC_(1030167.0), SC_(218.0), SC_(0.5432564385652312356727218479900347427825647513777862009118326000274409733746554353448002269663051129e-162), SC_(1.0), SC_(0.9505105923980418517707771558724016996998549930244685258668048631795434919869202232289632729707110142e-164) }}, 
      {{ SC_(130605.0), SC_(244.0), SC_(2063277.0), SC_(178.0), SC_(0.2218570677286885161092862099850581935384639591899682985132469436943719144842426413840951227491980773e-154), SC_(1.0), SC_(0.5658450085616388058631456946003242023397830538438638230473286316365930911151373390181898508317590385e-156) }}, 
      {{ SC_(130605.0), SC_(244.0), SC_(2427690.0), SC_(148.0), SC_(0.36338559700079100728804439878839562523787224942236442316408805338824545699751759005557540138743277e-120), SC_(1.0), SC_(0.1379303923559262485793235032631383187290879323211213557544255414528619499610336630198441069501236385e-121) }}, 
      {{ SC_(130605.0), SC_(312.0), SC_(256574.0), SC_(34.0), SC_(0.4070828779083801791251466237664116781291246232988869994218547465737628266444566164398720351961141649e-50), SC_(0.4609186186484011890120790550722847748678386492638360192668516368190783173046993197734664470649985513e-50), SC_(0.9999999999999999999999999999999999999999999999999953908138135159881098792094492771522513216135073616) }}, 
      {{ SC_(130605.0), SC_(312.0), SC_(523360.0), SC_(243.0), SC_(0.1497031339777434101014147653888797347188855379009498546193767874227150294038826138779358935156514054e-84), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999845228175722851), SC_(0.154771824277148518435572937304854824114968838013645339680613097305215362609537887142838868718088163e-85) }}, 
      {{ SC_(130605.0), SC_(312.0), SC_(1030167.0), SC_(108.0), SC_(0.1541837555151689367149495623729623035706776252924568844558956036647161305546430896283335598733395883e-22), SC_(0.9999999999999999999999942921399853117751140585568772165473081216419814137151453477513123653581792463), SC_(0.5707860014688224885941443122783452691878358018586284854652248687634641820753698149767728277828905439e-23) }}, 
      {{ SC_(130605.0), SC_(312.0), SC_(2063277.0), SC_(196.0), SC_(0.6483635296003181707626613332531454292754942722131782193223517455584205038207820117749443887535837959e-150), SC_(1.0), SC_(0.2681262853256353755131830106256955281932393253554913697608277811891873043298798499956624918613310047e-151) }}, 
      {{ SC_(130605.0), SC_(312.0), SC_(2427690.0), SC_(85.0), SC_(0.5223919432108174170140396521430107244584130926004171759301360782975828338890795723009705603858145093e-35), SC_(0.9999999999999999999999999999999999990811862991672884679047070486473155805063496269755111609722978645), SC_(0.918813700832711532095292951352684419493650373024488839027702135481325877860385148833569961636684632e-36) }}, 
      {{ SC_(130605.0), SC_(835.0), SC_(256574.0), SC_(515.0), SC_(0.8259501201266134345498696861190937573867071199017969334099012555358386951649387959904083127775499844e-10), SC_(0.9999999998553530021927490445742515475582317658908296975781786787012918065000622548357382335094378504), SC_(0.1446469978072509554257484524417682341091703024218213212987081934999377451642617664905621496067374374e-9) }}, 
      {{ SC_(130605.0), SC_(835.0), SC_(523360.0), SC_(126.0), SC_(0.1172961885672999698424958193863180182014653470035113006857520530705011183599112937783983885165130666e-11), SC_(0.2483943265653271302607390517836703824110003179445931635690535785392897557322415803501574977650248105e-11), SC_(0.999999999997516056734346728697392609482163296175889996820554068364309464214607102442677584196498425) }}, 
      {{ SC_(130605.0), SC_(835.0), SC_(1030167.0), SC_(832.0), SC_(0.349122314710285994999978832815222795474472893299064714820529713564977377882136516425742699398108619e-739), SC_(1.0), SC_(0.1814505608083100304514815153842899267822888192965890434340130441521014453098708919286283938049553678e-742) }}, 
      {{ SC_(130605.0), SC_(835.0), SC_(2063277.0), SC_(686.0), SC_(0.2887156274290628417371478159129399954195969539944213052901612988777310768750176041130767477000558668e-658), SC_(1.0), SC_(0.4271430014323078730028706892524046013944460646835085890917207804675764422990000377036765109655305984e-660) }}, 
      {{ SC_(130605.0), SC_(835.0), SC_(2427690.0), SC_(356.0), SC_(0.2170295151827578356784743832965719222504562691838663550762180262785067702136185064817160188495487665e-217), SC_(1.0), SC_(0.1786724372115607188823190006788290960980282602032196000398694107163214145969277614417537409759750792e-218) }}, 
      {{ SC_(130605.0), SC_(1339.0), SC_(256574.0), SC_(434.0), SC_(0.4080660892337007206802463729518322193198862378543253869619591526600870996444912765158534664881937293e-42), SC_(0.7541501988930351039459775478071101027131925947719617246165079296740473261303300046647512107497642853e-42), SC_(0.9999999999999999999999999999999999999999992458498011069648960540224521928898972868074052280382753835) }}, 
      {{ SC_(130605.0), SC_(1339.0), SC_(523360.0), SC_(688.0), SC_(0.9956450437022096565038383873547740861257321472787080015698485819752266435468766862717159501681701759e-95), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999954715), SC_(0.4528473718472350581119133978860735648085423394343860468187350109661507418012891845245854748768929137e-95) }}, 
      {{ SC_(130605.0), SC_(1339.0), SC_(1030167.0), SC_(398.0), SC_(0.5604586796820348430207927476351510828677415709376647655939405430468482018512445092738034679640426579e-60), SC_(0.9999999999999999999999999999999999999999999999999999999999997098678120372405263689299693830582517185), SC_(0.2901321879627594736310700306169417482814878409453778340998421435476571096625433841862639105926855923e-60) }}, 
      {{ SC_(130605.0), SC_(1339.0), SC_(2063277.0), SC_(1294.0), SC_(0.2732067008260373059192832775708771993665294358054679396235364475724567661938685132526964668154210805e-1470), SC_(1.0), SC_(0.6366619668293959477685069468566376408735160122947666146647487534043956046629684538705587588217682009e-1473) }}, 
      {{ SC_(130605.0), SC_(1339.0), SC_(2427690.0), SC_(845.0), SC_(0.6321067242737170007416203192501248887871764653868989704442782811388677046012997228171155833686719192e-704), SC_(1.0), SC_(0.215637805251654425195381179267032027613524921559842306166981087591793540580787785249881350821568348e-705) }}, 
      {{ SC_(130605.0), SC_(2247.0), SC_(256574.0), SC_(181.0), SC_(0.2044464670793775695543386497521156535391359709254184349156931640966684178921140729350236956275085189e-422), SC_(0.222986039238997669452294377987635006720595446219207620296549892340103626339740831575978542296976587e-422), SC_(1.0) }}, 
      {{ SC_(130605.0), SC_(2247.0), SC_(523360.0), SC_(431.0), SC_(0.1230661418669888147710512493170597173757721737380825927197929408778459448861320303783716320502515812e-10), SC_(0.4207775574578381239276524280938274846043920842040103390536148331215770203470802370365480347179234714e-10), SC_(0.9999999999579222442542161876072347571906172515395607915795989660946385166878422979652919762963451965) }}, 
      {{ SC_(130605.0), SC_(2247.0), SC_(1030167.0), SC_(1774.0), SC_(0.1726321135708010248628419397688195241382100034107144226807143367312485522353097737488340404687499145e-1122), SC_(1.0), SC_(0.6852695099832511653324808310723898215976768406610272265182457826766516506032572937879354402646990871e-1124) }}, 
      {{ SC_(130605.0), SC_(2247.0), SC_(2063277.0), SC_(2177.0), SC_(0.2175177341458988808953435160270807250264159532504948254044503662697521336624071932956370920577410825e-2484), SC_(1.0), SC_(0.4655504172248272149814253189540957874545430095547913568220834194990609749223541023960753505213882913e-2487) }}, 
      {{ SC_(130605.0), SC_(2247.0), SC_(2427690.0), SC_(516.0), SC_(0.2308632100407423371740054877426332541317542327513091376120186323191384816235363548447453993077693322e-172), SC_(1.0), SC_(0.5402832222499920211638403144013958416148197223312263126599285033912345642678440685935183098120330847e-173) }}, 
      {{ SC_(130605.0), SC_(6337.0), SC_(256574.0), SC_(1898.0), SC_(0.8633959243704150081281023797028162458094343319294846716955624230462562015828028477235550187621605632e-256), SC_(0.1447261533581584912075219284820401987795322413475478649778288617468024139432477366182888171855167382e-255), SC_(1.0) }}, 
      {{ SC_(130605.0), SC_(6337.0), SC_(523360.0), SC_(5365.0), SC_(0.613225020526329264238722036386541879206321094874253268972241142410061123637380501466518595395455423e-2210), SC_(1.0), SC_(0.3768791899517699091712208023977213974244934669050805898655464805027384044384744706931158053967943374e-2211) }}, 
      {{ SC_(130605.0), SC_(6337.0), SC_(1030167.0), SC_(5325.0), SC_(0.2466821511801947270395064835895561883245992819363616427365600517804842186527237039070899712798955284e-3668), SC_(1.0), SC_(0.6712777951272505491428674629863809465964152037944825575396664814301256668386587480920784055742567152e-3670) }}, 
      {{ SC_(130605.0), SC_(6337.0), SC_(2063277.0), SC_(576.0), SC_(0.3105330348299433522540108501069769571108046358629562196092439973586019494639386804844380614999041403e-17), SC_(0.9999999999999999936617268968266694775279068797745741046024632578935150731972320555981283740667878579), SC_(0.6338273103173330522472093120225425895397536742106484926802767944401871625933212142072746139524122932e-17) }}, 
      {{ SC_(130605.0), SC_(6337.0), SC_(2427690.0), SC_(1380.0), SC_(0.7816700888056712221266610032167065061418705075661864271099668491276693820722216133959783960517839259e-432), SC_(1.0), SC_(0.1982542569009174155561185379631127729895562241806365854384051213271236944756360059169223963092291741e-432) }}, 
      {{ SC_(130605.0), SC_(10473.0), SC_(256574.0), SC_(9695.0), SC_(0.9010075195065183696085738294172718645653890882341668685002209116809800088404664787003445646452643756e-1949), SC_(1.0), SC_(0.7567922871092420696956951600623934041336682428877490936244462135547460150932955676530717400600193842e-1950) }}, 
      {{ SC_(130605.0), SC_(10473.0), SC_(523360.0), SC_(10362.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.4358181214402002142607028072285009146901462250972882740881941862990899600484915552561538579757361619e-6132)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1434221835904815536631732832211112454992463375757505890764816985377288700273399142514139526182330432e-6134)) }}, 
      {{ SC_(130605.0), SC_(10473.0), SC_(1030167.0), SC_(1979.0), SC_(0.4855739499186646028057493146772010616292494033916647213349727143563569094513971392036526925431792965e-73), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999212383571058995411318656697), SC_(0.7876164289410045886813433034454488091130852603959739886859204450577736954715304440720621812385767485e-73) }}, 
      {{ SC_(130605.0), SC_(10473.0), SC_(2063277.0), SC_(5572.0), SC_(0.9274015087480661302944714669931034523352083521541004712368967078983147037008464833664008128246162656e-3720), SC_(1.0), SC_(0.5609541342704704625409806913869139703492939900003586162630208054028259988016182089636238703721119295e-3721) }}, 
      {{ SC_(130605.0), SC_(10473.0), SC_(2427690.0), SC_(5104.0), SC_(0.1700406517017278519181240473072077937041512299257677529283610553821780194769650579193813526179993394e-3494), SC_(1.0), SC_(0.1039173309733529357281114408961811600848964509715159418226666105610219837742993441101748687236273164e-3495) }}, 
      {{ SC_(130605.0), SC_(19470.0), SC_(256574.0), SC_(10089.0), SC_(0.000174790483627644275435507129155792663752936871659735039799762136902527990644290655643774042964670713), SC_(0.9961355092029389790348501344172074167559675168521610122609560314072250280228586299925941592576779667), SC_(0.003864490797061020965149865582792583244032483147838987739043968592774971977141370007405840742322033325) }}, 
      {{ SC_(130605.0), SC_(19470.0), SC_(523360.0), SC_(350.0), SC_(0.3566079648473868300876322756512620436348984100404299645509136431389431339383341185604640475208017062e-1881), SC_(0.3763661747947054005018366656906212340526385448744136198734977983667239326618646880833011946875647892e-1881), SC_(1.0) }}, 
      {{ SC_(130605.0), SC_(19470.0), SC_(1030167.0), SC_(16274.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1891982296575014153940172351948672145660904570370911206537659970288097849667182575611827626527664464e-11393)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.4860636218353270329245707189202395533178127407655964794416236603150300021881840879216331656564269457e-11395)) }}, 
      {{ SC_(130605.0), SC_(19470.0), SC_(2063277.0), SC_(6669.0), SC_(0.397112776821126134679975572482007415527581505488093091842744872370352726216170089366277141961471404e-2978), SC_(1.0), SC_(0.5615428413027271723889996891344585191828217305674581514553535957569749241798888081373373741233565738e-2979) }}, 
      {{ SC_(130605.0), SC_(19470.0), SC_(2427690.0), SC_(10398.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2079998308467482609802675113132241873441120503208421513681677138622678474699758975364149179041280737e-7734)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.9991176594322045092533789485590933465443097566195525589819363682849633068917129104183596717462808967e-7736)) }}, 
      {{ SC_(130605.0), SC_(50688.0), SC_(256574.0), SC_(33241.0), SC_(0.6160804224902240107927962303003852396014614029399295734562749139976094335309527073405837948679083209e-1202), SC_(1.0), SC_(0.5481701927107839927340757940540170226366775518127728179520578765748097875738108378582148928746097884e-1202) }}, 
      {{ SC_(130605.0), SC_(50688.0), SC_(523360.0), SC_(31042.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.5253313366296628408030516121270390031355190807644964268090615630096156765699368821101831599862986853e-7329)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1067405858798952203893287763457911947829821148239824768874288447067638519751293529045266232482025549e-7329)) }}, 
      {{ SC_(130605.0), SC_(50688.0), SC_(1030167.0), SC_(48315.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1994379620635970325397947203410189793755856240121120416939477428898457813830278945497175242006406462e-43241)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.9024790611895907614711865488287974673664710383020932546462505225716512649840888088642725978700055325e-43244)) }}, 
      {{ SC_(130605.0), SC_(50688.0), SC_(2063277.0), SC_(32630.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1040590703284616190250472979390531174000092363859537279532049560221941776132680159074277411326678942e-26992)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.3032689239184277124472228382684589931088425584027083451589554965043149878308244959065900177659722502e-26994)) }}, 
      {{ SC_(130605.0), SC_(50688.0), SC_(2427690.0), SC_(35943.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.6787435089954051830424836633007623633519814846725202616479080730024695574291877420641003997994183706e-34870)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1174819588629171374511582070918672034166022099647335499758314898800389954551210949783404548159850413e-34871)) }}, 
      {{ SC_(130605.0), SC_(130605.0), SC_(256574.0), SC_(107525.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.702962804677217809085202299484679286300091504638722394962297797667930891339333557987618068698922493e-24713)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.3555869147498304266943878872008882070591980635808844636948823168610339127169867026457252083194985519e-24714)) }}, 
      {{ SC_(130605.0), SC_(130605.0), SC_(523360.0), SC_(30520.0), SC_(0.1430021141435178534443296134780103423621148674445332279100658147537067977289471932510313028433844343e-53), SC_(0.1315394088731268261012403446954602956549988571248988918599386383120193830800282516037750090027323923e-52), SC_(0.9999999999999999999999999999999999999999999999999999868460591126873173898759655304539704345001142875) }}, 
      {{ SC_(130605.0), SC_(130605.0), SC_(1030167.0), SC_(4770.0), SC_(0.9417885095491879442619554460240114259395554060088296595547012348152701051275143893307614342441098101e-3094), SC_(0.1227980829827546272846162220139579335497410008872854370038145300849111392722961106203200018702444418e-3093), SC_(1.0) }}, 
      {{ SC_(130605.0), SC_(130605.0), SC_(2063277.0), SC_(35153.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2654305085637607049857032534333766653893506725153242322492061425346160256633151314115694683386879564e-13287)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.4359359778447423964026678530157261774937353224287863707125675307638110952657243948052706448125036789e-13288)) }}, 
      {{ SC_(130605.0), SC_(130605.0), SC_(2427690.0), SC_(33018.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.5061199150478078401438977938647024840797039371488870016080982752508502891145010029803428952584010014e-13531)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.7638184273912717024779981684672764232263741109194441221400782341853654408023225549889960353517437412e-13532)) }}, 
      {{ SC_(256574.0), SC_(3.0), SC_(523360.0), SC_(1.0), SC_(0.382172340490051187123089355789959866885542771397552835121541046006140105490759499929733947348004665), SC_(0.5146324568506304818625488888357460768771925393975901675156589306680077432914807764805589743178588157), SC_(0.4853675431493695181374511111642539231228074606024098324843410693319922567085192235194410256821411843) }}, 
      {{ SC_(256574.0), SC_(3.0), SC_(1030167.0), SC_(3.0), SC_(0.01544938586379190890138718499797314131326287002615501011066223142969630053737591870820938512881354308), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(256574.0), SC_(3.0), SC_(2063277.0), SC_(2.0), SC_(0.04062184438020781349502957668506429434668449418220458824421838410664715106902984021032327838692883614), SC_(0.9980770815021766759443312434216285472987503509539537681594603357151994029670500507530423695874745503), SC_(0.001922918497823324055668756578371452701249649046046231840539664284800597032949949246957630412525449716) }}, 
      {{ SC_(256574.0), SC_(3.0), SC_(2427690.0), SC_(1.0), SC_(0.2535832734967810266580773893830023063578972003016723688438138599249578992537026570346522384950685642), SC_(0.9688521566191164177625606095233746347646721426000152814927547563471843360759653574950188723653286281), SC_(0.03114784338088358223743939047662536523532785739998471850724524365281566392403464250498112763467137186) }}, 
      {{ SC_(256574.0), SC_(4.0), SC_(523360.0), SC_(2.0), SC_(0.3747159354572649385934740732734916048755414200470589810230460309006928730682680875978799658346348568), SC_(0.701990424579262951159285925472491879314963249421119658027181946118950265333727982791068508740018215), SC_(0.298009575420737048840714074527508120685036750578880341972818053881049734666272017208931491259981785) }}, 
      {{ SC_(256574.0), SC_(4.0), SC_(1030167.0), SC_(0.0), SC_(0.3179938723396245431118217073593903788800991502062123586763875255456177774096615505175931586845674988), SC_(0.3179938723396245431118217073593903788800991502062123586763875255456177774096615505175931586845674988), SC_(0.6820061276603754568881782926406096211199008497937876413236124744543822225903384494824068413154325012) }}, 
      {{ SC_(256574.0), SC_(4.0), SC_(2063277.0), SC_(1.0), SC_(0.3339668245290964665622437830185495878953259483185469321661316415934729263174665504174654306969799181), SC_(0.9218847954426716789161902495151680492851056910312913473685196825341380665790759097863045248885921793), SC_(0.07811520455732832108380975048483195071489430896870865263148031746586193342092409021369547511140782067) }}, 
      {{ SC_(256574.0), SC_(4.0), SC_(2427690.0), SC_(1.0), SC_(0.3023773631744620795633731658558881598635077323316474231974539741886645894880283778272550487996993467), SC_(0.9420519055031819507770130945322884483044057415470784800470313770636832588732924221227148676115279049), SC_(0.05794809449681804922298690546771155169559425845292151995296862293631674112670757787728513238847209512) }}, 
      {{ SC_(256574.0), SC_(15.0), SC_(523360.0), SC_(1.0), SC_(0.000588189805526851915840171134500768258075095447381954485595131455239317293313295472303344993406509478), SC_(0.0006289610374261634437145242474150513238425307974665249570201873607680934366408278696461019759485288945), SC_(0.9993710389625738365562854757525849486761574692025334750429798126392319065633591721303538980240514711) }}, 
      {{ SC_(256574.0), SC_(15.0), SC_(1030167.0), SC_(0.0), SC_(0.01361628967093004844231483797858035983225906194655185479332121779084391944341206700037852910573558009), SC_(0.01361628967093004844231483797858035983225906194655185479332121779084391944341206700037852910573558009), SC_(0.9863837103290699515576851620214196401677409380534481452066787822091560805565879329996214708942644199) }}, 
      {{ SC_(256574.0), SC_(15.0), SC_(2063277.0), SC_(6.0), SC_(0.00560126145582116381216471326637369933635899426668845915180852676409696020372803475643869919018883173), SC_(0.9988145678737490811306984927546098119597820280464537494853359193180413701596303243133615440835735369), SC_(0.001185432126250918869301507245390188040217971953546250514664080681958629840369675686638455916426463052) }}, 
      {{ SC_(256574.0), SC_(15.0), SC_(2427690.0), SC_(1.0), SC_(0.3318703351832104651380924788537190220610797858922284194217892873834907995679868518079175972286780402), SC_(0.5190871091501592095632856932932873535456558913719182050491938738229771704716781559239162334059933177), SC_(0.4809128908498407904367143067067126464543441086280817949508061261770228295283218440760837665940066823) }}, 
      {{ SC_(256574.0), SC_(29.0), SC_(523360.0), SC_(18.0), SC_(0.05590313966305962512622358070216228210044323863294439446816953811640782909728468850292436026319907391), SC_(0.9447662304983185044620043110742785912186604835294708627610015662495824566251403205266961094301831699), SC_(0.05523376950168149553799568892572140878133951647052913723899843375041754337485967947330389056981683006) }}, 
      {{ SC_(256574.0), SC_(29.0), SC_(1030167.0), SC_(16.0), SC_(0.0003591757484504225871622844502817123434329299036625145211919948665485516438343046666547101785435581239), SC_(0.9998841557714372459493526298173677153553175534976261531860510159666044810961150117184272759761724226), SC_(0.0001158442285627540506473701826322846446824465023738468139489840333955189038849882815727240238275773775) }}, 
      {{ SC_(256574.0), SC_(29.0), SC_(2063277.0), SC_(16.0), SC_(0.3946973355423779243884572072443682581868668509130191599500436678023124992288548519408050786683351414e-7), SC_(0.999999995272281239673807707847214655095840783884918007581958003437638614467159725090989064218605138), SC_(0.4727718760326192292152785344904159216115081992418041996562361385532840274909010935781394862037165775e-8) }}, 
      {{ SC_(256574.0), SC_(29.0), SC_(2427690.0), SC_(29.0), SC_(0.4965333594649081734778177073337930845378039325824069109044688823724167208189665628002488846925790613e-28), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(256574.0), SC_(36.0), SC_(523360.0), SC_(1.0), SC_(0.1009152027999769356618448570114225174830788764530274266828981308463954308824611353370867696014116748e-8), SC_(0.1038295917246034726415090276960608206584600284980429776540160322122356116645408331925357967477868343e-8), SC_(0.9999999989617040827539652735849097230393917934153997150195702234598396778776438833545916680746420325) }}, 
      {{ SC_(256574.0), SC_(36.0), SC_(1030167.0), SC_(7.0), SC_(0.1225307295518271417868943679490353523346166581127933445043449793198058711086388066519829332561831898), SC_(0.2941278810628954000834839121076594800569202372819725245814694397196294376936416719387550006475779793), SC_(0.7058721189371045999165160878923405199430797627180274754185305602803705623063583280612449993524220207) }}, 
      {{ SC_(256574.0), SC_(36.0), SC_(2063277.0), SC_(4.0), SC_(0.2010532666495645102414316047056624581785851341093047171915303596581107032674455977579392130957413384), SC_(0.5305709017655043848075751845984028209859016354575212042794638598791561661933202941042108531173710472), SC_(0.4694290982344956151924248154015971790140983645424787957205361401208438338066797058957891468826289528) }}, 
      {{ SC_(256574.0), SC_(36.0), SC_(2427690.0), SC_(4.0), SC_(0.2060187289646267836025771935674502833980012866402909792537526321049020332837077294396713528141462358), SC_(0.6693221148531482620032455071066873886395577443672800367628948447528137705482223762243118496315571565), SC_(0.3306778851468517379967544928933126113604422556327199632371051552471862294517776237756881503684428435) }}, 
      {{ SC_(256574.0), SC_(126.0), SC_(523360.0), SC_(96.0), SC_(0.2842247949104309026185762436921312733797702110356868569323225752172330280657326759547673453267880964e-9), SC_(0.9999999998826529517075709555990714382094541250489159663421429693732281143966989189186345445223642171), SC_(0.1173470482924290444009285617905458749510840336578570306267718856033010810813654554776357828872872059e-9) }}, 
      {{ SC_(256574.0), SC_(126.0), SC_(1030167.0), SC_(52.0), SC_(0.2244551572239445180081071877353488354929197771442971173139742336961856520313525539903728485983594901e-4), SC_(0.9999815094880215196641946298235036559552420076630981588874367475627986723202631102720142414589083872), SC_(0.1849051197848033580537017649634404475799233690184111256325243720132767973688972798575854109161283777e-4) }}, 
      {{ SC_(256574.0), SC_(126.0), SC_(2063277.0), SC_(46.0), SC_(0.330725931575696088841726152069670485103991724925592392397374302006758591997194944706948376094376866e-11), SC_(0.9999999999989599607849916950581833592587512652918463096800358766245840686930103992140772162809676917), SC_(0.1040039215008304941816640741248734708153690319964123375415931306989600785922783719032308310156139929e-11) }}, 
      {{ SC_(256574.0), SC_(126.0), SC_(2427690.0), SC_(1.0), SC_(0.1149405539441450399483586736916366127475322003318360386737876935880649905669753035745959247273708281e-4), SC_(0.1226593242753182051400502425263364834103410016520224193051017393978770551186665165580687326966240292e-4), SC_(0.9999877340675724681794859949757473663516589658998347977580694898260602122944881333483441931267303376) }}, 
      {{ SC_(256574.0), SC_(244.0), SC_(523360.0), SC_(37.0), SC_(0.8004878023626385833176132667492801384178500706537366399541933596282966982102789698162484673083392132e-28), SC_(0.9804421643313285588424949513362915963583597614946498564363713146713156534962536950280553266777413978e-28), SC_(0.9999999999999999999999999999019557835668671441157505048663708403641640238505350143563628685328684347) }}, 
      {{ SC_(256574.0), SC_(244.0), SC_(1030167.0), SC_(166.0), SC_(0.1626323223641225800792270898153395235985914573614392860817641687767901045937936962280007133016995132e-44), SC_(0.9999999999999999999999999999999999999999999997032741610783371983478159438761234857914413605750387451), SC_(0.296725838921662801652184056123876514208558639424961254871987303013611781778293219057274686911168019e-45) }}, 
      {{ SC_(256574.0), SC_(244.0), SC_(2063277.0), SC_(205.0), SC_(0.3389161037498427165696051539769330933344139088954146282550847554060960997190298315467190682112709314e-142), SC_(1.0), SC_(0.9348263969338046600567037299497460428967000200292626524748733584534069780294032562624449054332927928e-144) }}, 
      {{ SC_(256574.0), SC_(244.0), SC_(2427690.0), SC_(1.0), SC_(0.4196160580991229109100028905714718572305104386288950167112206024454254457875385462767179456598440691e-10), SC_(0.4341667634223341937536565143089428419398968382487155793216198009077823907396855951288143260740527375e-10), SC_(0.9999999999565833236577665806246343485691057158060103161751284420678380199092217609260314404871185674) }}, 
      {{ SC_(256574.0), SC_(312.0), SC_(523360.0), SC_(76.0), SC_(0.2223004554821876305609602599600125211108368467631237306178379928790891211276973411474774943647575132e-18), SC_(0.3320096004874412760173174809899606860830521972842963417269826208327735862729894898803504490103716284e-18), SC_(0.9999999999999999996679903995125587239826825190100393139169478027157036582730173791672264137270105101) }}, 
      {{ SC_(256574.0), SC_(312.0), SC_(1030167.0), SC_(251.0), SC_(0.3619371163362650226426091537527327870146289842990659646284279558110395183361842276276023843049364116e-93), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999684971), SC_(0.3150293787612904261621635527339526668621234352141617135120615231383679835973479186065131312311167741e-94) }}, 
      {{ SC_(256574.0), SC_(312.0), SC_(2063277.0), SC_(226.0), SC_(0.763363763183763472130510943317484478032484860815483973610552160129177017136333230391619352433912552e-131), SC_(1.0), SC_(0.4332610062512872324113812566986548193461118474634109554783383889941453202684641966485300891262431921e-132) }}, 
      {{ SC_(256574.0), SC_(312.0), SC_(2427690.0), SC_(238.0), SC_(0.1095419148505346683771983698840242473882741902049317534099158122599908147485995053004173557453354271e-162), SC_(1.0), SC_(0.415363531213548333274488255321387112620023900961723556151008330402149644321683328743528254396655048e-164) }}, 
      {{ SC_(256574.0), SC_(835.0), SC_(523360.0), SC_(564.0), SC_(0.1174479951158821425082407289769637060330921377443161753803028410323426067073920964109194498856047389e-26), SC_(0.9999999999999999999999999990050133687133005987331293383812555441246117125014178039180219350435016996), SC_(0.9949866312866994012668706616187444558753882874985821960819780649564983004226775093699329855082449355e-27) }}, 
      {{ SC_(256574.0), SC_(835.0), SC_(1030167.0), SC_(153.0), SC_(0.1136810142591100039768093061754403491741287304759478007794794546811298193851549485365036687537103759e-5), SC_(0.3393450885512750598781595486559629898220508956898383837673454342087010423108150533229853845351481892e-5), SC_(0.9999966065491144872494012184045134403701017794910431016161623265456579129895768918494667701461546485) }}, 
      {{ SC_(256574.0), SC_(835.0), SC_(2063277.0), SC_(8.0), SC_(0.6427116594545142228410552085462657143554086421559461070238559428869799808654935762952206212649370091e-36), SC_(0.689155545663159481710826750246870251332491426209488766679417494571355674359794708361296353081831696e-36), SC_(0.9999999999999999999999999999999999993108444543368405182891732497531297486675085737905112333205825054) }}, 
      {{ SC_(256574.0), SC_(835.0), SC_(2427690.0), SC_(223.0), SC_(0.3885693268071425996493431406023615818033289303842805986819477862613113169118312664148153001028539844e-38), SC_(0.9999999999999999999999999999999999999981565953636322670756517459424239305792005820351968833865404742), SC_(0.1843404636367732924348254057576069420799417964803116613459525841655102674714996364210737994074605482e-38) }}, 
      {{ SC_(256574.0), SC_(1339.0), SC_(523360.0), SC_(13.0), SC_(0.1196626714438347141763116887605223353067949456135831759542711428376238025187256546481846308576986143e-361), SC_(0.1208870456056572170221308841496296388140660711634520056935573994525018264601712962603952729315564277e-361), SC_(1.0) }}, 
      {{ SC_(256574.0), SC_(1339.0), SC_(1030167.0), SC_(1304.0), SC_(0.3920556217166054629966751367583498899442999151537291994932614297411868877961316052498833465693173685e-723), SC_(1.0), SC_(0.3499916469546278169800612296950563975173777916948145571117116482670180286990517162279041970984635512e-725) }}, 
      {{ SC_(256574.0), SC_(1339.0), SC_(2063277.0), SC_(1288.0), SC_(0.4110577794899245260490952314497018583993653334580083830481047646596737589120788200745132252088752132e-1077), SC_(1.0), SC_(0.23107726093824244616646458885685498183705950766284032304501653963569145751235737794434651726086335e-1079) }}, 
      {{ SC_(256574.0), SC_(1339.0), SC_(2427690.0), SC_(789.0), SC_(0.9671769569378534334155810064865828938012631358516331445069486980599307832912358611366371633204892153e-405), SC_(1.0), SC_(0.8641524842342279244611019881791940625144041810055182054073341412110696863589104298234430271375370483e-406) }}, 
      {{ SC_(256574.0), SC_(2247.0), SC_(523360.0), SC_(2166.0), SC_(0.8384750351491916066119903234157385122452003225465067972453544923129943227351724927015870470538514936e-546), SC_(1.0), SC_(0.3098623498066663432394070775563741916153100894127324636122465720724804182340506865520961637654424271e-547) }}, 
      {{ SC_(256574.0), SC_(2247.0), SC_(1030167.0), SC_(682.0), SC_(0.6982812022351542210774346271410313015553225861812596389025954435747762109566406891615111953073828603e-9), SC_(0.9999999978514177714699178108228259900484530243724791335570880665610973855320970101460539767968155504), SC_(0.2148582228530082189177174009951546975627520866442911933438902614467902989853946023203184449600431437e-8) }}, 
      {{ SC_(256574.0), SC_(2247.0), SC_(2063277.0), SC_(1590.0), SC_(0.8056532502082031273257646875160739623595347159361184240290844494568130281382601594423816983102938287e-891), SC_(1.0), SC_(0.4987166189415629678327301405520070350247684875316107512535182020508625015009865574036733240330713467e-892) }}, 
      {{ SC_(256574.0), SC_(2247.0), SC_(2427690.0), SC_(1939.0), SC_(0.1737240598038600929998113901774709640559616166945961987021900672644663792073552494626461511999517478e-1521), SC_(1.0), SC_(0.3296384597785712783595324503767938179973588306111217051587907122446679367823357919152694181320192729e-1523) }}, 
      {{ SC_(256574.0), SC_(6337.0), SC_(523360.0), SC_(1537.0), SC_(0.1243856823434895087992209548578721505310015544564598389794368937139697691944099803988273490635962551e-361), SC_(0.1852973316657187608348253332916235173510102841351284645435399365995689330495406416864278802959825479e-361), SC_(1.0) }}, 
      {{ SC_(256574.0), SC_(6337.0), SC_(1030167.0), SC_(2650.0), SC_(0.7591114989610214370125901974741561495970820139759909059818099755720563086291161053346710262727855541e-191), SC_(1.0), SC_(0.6426188718510596900268174402717745416999777683305311560614457970062213836358157113176569701941425447e-191) }}, 
      {{ SC_(256574.0), SC_(6337.0), SC_(2063277.0), SC_(5777.0), SC_(0.5111460636156566936653064376514511514012171509347400946884615181625977935419881669149127589345448808e-4466), SC_(1.0), SC_(0.6972653867741635518876246524459023298979982199633107945798032765518381196387482907319277169579007574e-4468) }}, 
      {{ SC_(256574.0), SC_(6337.0), SC_(2427690.0), SC_(4163.0), SC_(0.4775865628497100257247065894889092728668503971947261389474862826391430740328240540353324720115735504e-2412), SC_(1.0), SC_(0.3089319601251403300894486957161179673811550343215818345218778851509678286025438552549656135263530112e-2413) }}, 
      {{ SC_(256574.0), SC_(10473.0), SC_(523360.0), SC_(3289.0), SC_(0.1157853223971441246859914362749020934021242586126649246523750879213606108424171533960704418310242607e-297), SC_(0.2180462546322371891909372299405236361137916910419407936965771928148473855236337641848671713410904756e-297), SC_(1.0) }}, 
      {{ SC_(256574.0), SC_(10473.0), SC_(1030167.0), SC_(5815.0), SC_(0.1300614123765302046362228258290449289319529473231846807772645945949501492360047173718065053205509129e-978), SC_(1.0), SC_(0.4596956420178308670137349082907283345065329793952660308447593264217819711900714119893623063080871349e-979) }}, 
      {{ SC_(256574.0), SC_(10473.0), SC_(2063277.0), SC_(2128.0), SC_(0.2929529353527264180437732293863192365260349503987251583892764603353264175952524950228967093043204535e-114), SC_(1.0), SC_(0.3641561230584934357556577203844249980967637824179930273329198491839258841340750786664771339572321456e-114) }}, 
      {{ SC_(256574.0), SC_(10473.0), SC_(2427690.0), SC_(7132.0), SC_(0.1762802857167715702944350766276762843734717549493005650729936424670745104584774636110287609134805361e-4311), SC_(1.0), SC_(0.1004182970952673170098105320143028922179551184569151855044870178210352454408622179638215252545743057e-4312) }}, 
      {{ SC_(256574.0), SC_(19470.0), SC_(523360.0), SC_(19170.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.7375103207505451650905379236392846039350838051089357599057555474086958984966458177143537319486913221e-5511)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1042635452940707942036559406146062718070332579363734667056557696364271363930311365443277885268950621e-5512)) }}, 
      {{ SC_(256574.0), SC_(19470.0), SC_(1030167.0), SC_(6572.0), SC_(0.9324064690323706528953087078643009562365899214590166877774594873370905397010088738537668752932348073e-171), SC_(1.0), SC_(0.1691309716646518507539687993732964421722940503488161289529319802721908884726858077842181378632628344e-170) }}, 
      {{ SC_(256574.0), SC_(19470.0), SC_(2063277.0), SC_(15718.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2890525603803659279886060985989240760680681948409119563077815127951958399903569112507143525583292503e-10479)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.9520438717034452581024595918158094022318799921011703022491944711550177306638806056888785202320806419e-10481)) }}, 
      {{ SC_(256574.0), SC_(19470.0), SC_(2427690.0), SC_(14537.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.7504638451904357843378803472047245055120393500344539131039321865721081915367569182961641975573182509e-9794)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2957355756794734479260262734286098207917884629353862639632153707545998137221471484159785716070325381e-9795)) }}, 
      {{ SC_(256574.0), SC_(50688.0), SC_(523360.0), SC_(6326.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1357862977927616163789549999405276179058823667815139835387072159343071254755410624856944269632514699e-7287)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1554931323078782942054238511437138796380057117122633860840576399842543865940890488564030819521634092e-7287)), SC_(1.0) }}, 
      {{ SC_(256574.0), SC_(50688.0), SC_(1030167.0), SC_(6310.0), SC_(0.1149002575024124443168222438025746253892598432618083533605560802026894083926922174099684959263013247e-1106), SC_(0.1961552426693423116362530494765425848951471406019180362162431514604727219079028194998043215334430715e-1106), SC_(1.0) }}, 
      {{ SC_(256574.0), SC_(50688.0), SC_(2063277.0), SC_(24893.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2167728332155688698784828289535305308876893618166959548541718453338911313787253057914364428896163945e-9121)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.3377312682333670732715262112053897458207117910793810114998391492542450756723149488974534330578373019e-9122)) }}, 
      {{ SC_(256574.0), SC_(50688.0), SC_(2427690.0), SC_(49876.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.939771868295522649969739363755674289706385562940080146461433251587736459388429374311627517050620968e-48937)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1459374306447027130310499337443942187799772811342221685262211564144410918522532540240456123808966141e-48939)) }}, 
      {{ SC_(256574.0), SC_(130605.0), SC_(523360.0), SC_(108109.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.380068876167343746496891771390913808859951423278299411666084532597250196912526173570752444754212673e-18344)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.5502136155981017612779621728118426456003071948185639823277392547768160991496437529561217466038061415e-18345)) }}, 
      {{ SC_(256574.0), SC_(130605.0), SC_(1030167.0), SC_(15134.0), SC_(0.7138071525363310394909470945246556766851300637050863354207903744133018976804281676899991790539333264e-3545), SC_(0.111052446853269022678067948980421390989079662581499999081674014694128643223915780033415160736340671e-3544), SC_(1.0) }}, 
      {{ SC_(256574.0), SC_(130605.0), SC_(2063277.0), SC_(114923.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.1091155860812198420585092490730199274410467339065103479572415374819629124655254836122837715807952565e-95691))), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.1190442185036060431822103738786383011652003265280955983394102615088291115551242146332538950958784808e-95693))) }}, 
      {{ SC_(256574.0), SC_(130605.0), SC_(2427690.0), SC_(86341.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.4351918607759444833007377098194281964556961060681600419173181712555128847394408683633258279062408488e-55908))), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.1862135222876926042140041013878011367547838248621245536434387004167419723638160290955108126723169178e-55909))) }}, 
      {{ SC_(256574.0), SC_(256574.0), SC_(523360.0), SC_(191235.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2567064294672115366530812620981896694097027448163812364904581069029160517112833231344629820290434178e-29783)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.319930916955301709346819217068565913027157560244606948910239971746512550945334439924193346294366608e-29784)) }}, 
      {{ SC_(256574.0), SC_(256574.0), SC_(1030167.0), SC_(216596.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1860483194531661879415385468592456729406944866779188927379106917525705482813558479848531797773651936e-134569)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1890326145468109200746679441100704757722060386641966119575178062661940084784804380559738681541133882e-134571)) }}, 
      {{ SC_(256574.0), SC_(256574.0), SC_(2063277.0), SC_(155763.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.3453055765165744849840318804351070055295336764385814618399578383176606571194383816587269003651324153e-92932))), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.1373208589161415994536462468230026679486266680717725996210741107579477516780905607665231784141162776e-92933))) }}, 
      {{ SC_(256574.0), SC_(256574.0), SC_(2427690.0), SC_(11903.0), SC_(0.1178504324444308714376491499144127460920345421405350453261473106532576027645208376526392914047076695e-2807), SC_(0.191011225059239862710222856385796878752021926982540358970735918254630313349449358582104886474098247e-2807), SC_(1.0) }}, 
      {{ SC_(523360.0), SC_(3.0), SC_(1030167.0), SC_(3.0), SC_(0.1311225704829263947430339808893622411623741488724524578541357943764509880668391955042309306655325139), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(523360.0), SC_(3.0), SC_(2063277.0), SC_(1.0), SC_(0.4238811918826285471591681894295345680511966669655030656059070653924513462553601314860547330678006347), SC_(0.8396186101020428057947857900775153870926203621977094839237764596932619513639042164227127213690987942), SC_(0.1603813898979571942052142099224846129073796378022905160762235403067380486360957835772872786309012058) }}, 
      {{ SC_(523360.0), SC_(3.0), SC_(2427690.0), SC_(1.0), SC_(0.3979484525154665371647545827776472132966956403670185768328976297454976100967167383560933639652505078), SC_(0.8806145463972262944929689190610158075102833654694616067313985198003557087802960538104473779554731805), SC_(0.1193854536027737055070310809389841924897166345305383932686014801996442912197039461895526220445268195) }}, 
      {{ SC_(523360.0), SC_(4.0), SC_(1030167.0), SC_(2.0), SC_(0.3748071103449826371962696924202834443258692101721286291346713850332482094079242936029801544540260096), SC_(0.675353379233602786997350590637321832373161876650859327043178615153910187364887671834188598723383203), SC_(0.324646620766397213002649409362678167626838123349140672956821384846089812635112328165811401276616797) }}, 
      {{ SC_(523360.0), SC_(4.0), SC_(2063277.0), SC_(3.0), SC_(0.04872226960425709632824793866160328980229698894358563946146929348371972092024281310321272082115479965), SC_(0.995860305968880923263548805482029110507082403590169445900065363095905907747356902605330477456949478), SC_(0.004139694031119076736451194517970889492917596409830554099934636904094092252643097394669522543050521972) }}, 
      {{ SC_(523360.0), SC_(4.0), SC_(2427690.0), SC_(4.0), SC_(0.002159858420556979857493965260107498611977268415088509261731770272355286631248977418978844107346243933), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(523360.0), SC_(15.0), SC_(1030167.0), SC_(12.0), SC_(0.01601466847612233680318145849532675540979846349538193566175192688625473926881918336290328377731356464), SC_(0.9955819331150181736928748669134599235824917725913282032897156311663972071051235326381877115792107136), SC_(0.004418066884981826307125133086540076417508227408671796710284368833602792894876467361812288420789286398) }}, 
      {{ SC_(523360.0), SC_(15.0), SC_(2063277.0), SC_(15.0), SC_(0.1157656771095570081908158745982313209290868631159748942451978911246424976594993843699314010480507422e-8), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(523360.0), SC_(15.0), SC_(2427690.0), SC_(0.0), SC_(0.02619567140112104398606476685020473380984957574291217248181926152643925366998573551039509150779258432), SC_(0.02619567140112104398606476685020473380984957574291217248181926152643925366998573551039509150779258432), SC_(0.9738043285988789560139352331497952661901504242570878275181807384735607463300142644896049084922074157) }}, 
      {{ SC_(523360.0), SC_(29.0), SC_(1030167.0), SC_(23.0), SC_(0.00115826150229716572270878687199973434167141634001292055027032666916774237158461736467657686243054488), SC_(0.9996282117817450381887821767991188894227757707858977824215113939049129817459361306027327745115728915), SC_(0.0003717882182549618112178232008811105772242292141022175784886060950870182540638693972672254884271084574) }}, 
      {{ SC_(523360.0), SC_(29.0), SC_(2063277.0), SC_(6.0), SC_(0.151281684146878552399576136277877456538411986149852104858555473998672662902644951151519162446123275), SC_(0.369625479487675050797423521094954675488883006235181340401575850994510540824101566999413430198912406), SC_(0.630374520512324949202576478905045324511116993764818659598424149005489459175898433000586569801087594) }}, 
      {{ SC_(523360.0), SC_(29.0), SC_(2427690.0), SC_(10.0), SC_(0.04307061229358353686351602864591479961254908003924778571209873803462114192744931043865141028247279055), SC_(0.9668055268769895343020681337001352831141020831245293507618893950157754605235068087234581288906629589), SC_(0.03319447312301046569793186629986471688589791687547064923811060498422453947649319127654187110933704108) }}, 
      {{ SC_(523360.0), SC_(36.0), SC_(1030167.0), SC_(16.0), SC_(0.09926127432961854577988288755375269170125977398176006238151498950446435097106496781526614505537111216), SC_(0.2755412821226538377318400643474533528875763542470766787711662169510266275855323457547922009175616117), SC_(0.7244587178773461622681599356525466471124236457529233212288337830489733724144676542452077990824383883) }}, 
      {{ SC_(523360.0), SC_(36.0), SC_(2063277.0), SC_(28.0), SC_(0.6067457780704224466183347049915793760480091714646374616706974343235197336999099418700618625321059373e-10), SC_(0.9999999999938293476015957325816891856260120684189266414808935277205115867225201195586214592409629899), SC_(0.6170652398404267418310814373987931581073358519106472279488413277479880441378540759037010133665554585e-11) }}, 
      {{ SC_(523360.0), SC_(36.0), SC_(2427690.0), SC_(15.0), SC_(0.003430104414953634113119379360047650272487102262466985042181455471420846909669044786307542776277101709), SC_(0.9982076046827411980213712591250848590703637521199251499374731105658682769919111221077162302620788933), SC_(0.001792395317258801978628740874915140929636247880074850062526889434131723008088877892283769737921106705) }}, 
      {{ SC_(523360.0), SC_(126.0), SC_(1030167.0), SC_(87.0), SC_(0.1378690607121171756264206702645595570536351263320902449280152793612427350166858207257128166231130178e-4), SC_(0.9999889460770490680886183206335002042224825215718382023661784785208186153492238268088072123657310123), SC_(0.1105392295093191138167936649979577751747842816179763382152147918138465077617319119278763426898768402e-4) }}, 
      {{ SC_(523360.0), SC_(126.0), SC_(2063277.0), SC_(21.0), SC_(0.006033095646203472314200687504468263010216878788914999847667739809432114607001923489208965787992449538), SC_(0.01334320493297145291499282210695998619517788969357774710315182566473194925440342581815420392497537158), SC_(0.9866567950670285470850071778930400138048221103064222528968481743352680507455965741818457960750246284) }}, 
      {{ SC_(523360.0), SC_(126.0), SC_(2427690.0), SC_(97.0), SC_(0.5555789547018849576300472618254864505397736086927148077876686139899662004216793694649073361031451972e-39), SC_(0.9999999999999999999999999999999999999999510335781615102419762797624664440548305639846447986860981497), SC_(0.4896642183848975802372023753355594516943601535520131390185031114469385738478975609467051714865087823e-40) }}, 
      {{ SC_(523360.0), SC_(244.0), SC_(1030167.0), SC_(179.0), SC_(0.32528513874722719813211644957066787958018559451046602443662026946092956123042428777787637250926734e-12), SC_(0.9999999999998102641993201167927395872392603074485765512355484108109988121253654463156450043192649853), SC_(0.1897358006798832072604127607396925514234487644515891890011878746345536843549956807350146508492116296e-12) }}, 
      {{ SC_(523360.0), SC_(244.0), SC_(2063277.0), SC_(7.0), SC_(0.485676903043570029267993397689773643138692929000592621811561031648443202953525584342622874405282039e-21), SC_(0.5310051349169810896635487578184801148890528642860566457538346912403589766096096776734044074512190123e-21), SC_(0.9999999999999999999994689948650830189103364512421815198851109471357139433542461653087596410233903903) }}, 
      {{ SC_(523360.0), SC_(244.0), SC_(2427690.0), SC_(115.0), SC_(0.5558352507104097494401429280208308066228878812775345073223731056513762030220408098230251574240495185e-18), SC_(0.9999999999999999997578474174188258325280308550441379873055048705436358343149492609680570179104312105), SC_(0.2421525825811741674719691449558620126944951294563641656850507390319429820895687894953023475996447197e-18) }}, 
      {{ SC_(523360.0), SC_(312.0), SC_(1030167.0), SC_(149.0), SC_(0.02530942714690769707010741121036889295829698719874590472850446795209509437547210888981064773896295632), SC_(0.1538437456126160275886059663724327235320521619013638584353904366078587671584517435924486859946346322), SC_(0.8461562543873839724113940336275672764679478380986361415646095633921412328415482564075513140053653678) }}, 
      {{ SC_(523360.0), SC_(312.0), SC_(2063277.0), SC_(211.0), SC_(0.2831636717259170679717450096334959732324123712319787706911132036391810117149195584471647845615480624e-54), SC_(0.9999999999999999999999999999999999999999999999999999999454973552402450669280056716333612975255136889), SC_(0.5450264475975493307199432836663870247448631108770676290147310910393213590008288901104486538661308178e-55) }}, 
      {{ SC_(523360.0), SC_(312.0), SC_(2427690.0), SC_(312.0), SC_(0.1132110332991838673705779792058776219077598858652602080121796320133155042427205185277367663257058631e-207), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(523360.0), SC_(835.0), SC_(1030167.0), SC_(824.0), SC_(0.437482772444479411155912300308350803576453311850361129216447572702681674655345417753267379929159251e-221), SC_(1.0), SC_(0.6090179065133802329468862456766183014488924250074348725788981377221143805902799658638903715332324116e-223) }}, 
      {{ SC_(523360.0), SC_(835.0), SC_(2063277.0), SC_(731.0), SC_(0.1179510768455946433965545577541516590797664078861775376479424393520351754144497782422877836184718224e-313), SC_(1.0), SC_(0.5972560216147886617193536823512675441931507323172530274245898596018551640506495014334936000954507395e-315) }}, 
      {{ SC_(523360.0), SC_(835.0), SC_(2427690.0), SC_(195.0), SC_(0.01494348876510982662317207910035622624276899360963005043588355527198901385026367966737562409364505714), SC_(0.9029672188350310622975129550121162225419468798088727683763091862499883937467196919884494970807493904), SC_(0.09703278116496893770248704498788377745805312019112723162369081375001160625328030801155050291925060958) }}, 
      {{ SC_(523360.0), SC_(1339.0), SC_(1030167.0), SC_(957.0), SC_(0.7165271087146401329199981802698488632736784423893979293665816854428627458452281202260188904118099995e-53), SC_(0.9999999999999999999999999999999999999999999999999999950148672920409381584956672432372443517421094708), SC_(0.4985132707959061841504332756762755648257890529195224039807920862921691818354385614954939406069862785e-53) }}, 
      {{ SC_(523360.0), SC_(1339.0), SC_(2063277.0), SC_(649.0), SC_(0.5947192661765856998988455820947382518774573918545262781771063872328261927039252152210394674509777602e-73), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999665632340270214188569047632), SC_(0.3343676597297858114309523678759616857798448192016998398580712919369631871502728699080364295539874278e-73) }}, 
      {{ SC_(523360.0), SC_(1339.0), SC_(2427690.0), SC_(306.0), SC_(0.01348845406262362735049814200008740606571675896897553221568417660981546972092072175881210142982883995), SC_(0.8816799974921884971640420149546900792911044909409317277350988857413138178020593908498840893305586579), SC_(0.1183200025078115028359579850453099207088955090590682722649011142586861821979406091501159106694413421) }}, 
      {{ SC_(523360.0), SC_(2247.0), SC_(1030167.0), SC_(1469.0), SC_(0.9005906282881814238159844047899345946591532504247568465224033299396058867712968715344926118338534249e-44), SC_(0.9999999999999999999999999999999999999999999892316291345080764643576424969183882011119319889210857701), SC_(0.1076837086549192353564235750308161179888806801107891422987625069681527119060204079137478703532408821e-43) }}, 
      {{ SC_(523360.0), SC_(2247.0), SC_(2063277.0), SC_(21.0), SC_(0.1318449015756670586189664535725156917743143874248528205199870168500355460932947854639692712871082473e-244), SC_(0.1355967042578187371259813997141762662470006942314792360955097151862145014186255763978860890047889396e-244), SC_(1.0) }}, 
      {{ SC_(523360.0), SC_(2247.0), SC_(2427690.0), SC_(1245.0), SC_(0.19891094146424387195625370040800224911094579152203627453382576314631192502713436505095598933537148e-266), SC_(1.0), SC_(0.5626205341954819491880902396331639091765259574827615679475342920201375579872876857250075187252646976e-267) }}, 
      {{ SC_(523360.0), SC_(6337.0), SC_(1030167.0), SC_(63.0), SC_(0.2017087743820453900961022409695460915006698670108242463320217436804903939125048829413015333994923913e-1807), SC_(0.2036642743472304681903758634351151558903387869364915136962447292997383690068823020110753695456675161e-1807), SC_(1.0) }}, 
      {{ SC_(523360.0), SC_(6337.0), SC_(2063277.0), SC_(5623.0), SC_(0.2870347860356555402476286321076996004692195008566434705905019732108535931685580451984148571892190006e-2482), SC_(1.0), SC_(0.1280330541159334004803447858629102856349417211741874907409332976479729266084091639099637894154480909e-2483) }}, 
      {{ SC_(523360.0), SC_(6337.0), SC_(2427690.0), SC_(3318.0), SC_(0.1245168376422949080631623473227067573580786032317995122235586485904815404677068128308401773311635476e-628), SC_(1.0), SC_(0.4122767007001072282163750642952259193303030928486701203148667852246913122390172153841840209252505644e-629) }}, 
      {{ SC_(523360.0), SC_(10473.0), SC_(1030167.0), SC_(4350.0), SC_(0.4403889484526627932615333602857473405694600629268949609264480524911229062492158241645636156345942474e-81), SC_(0.139650410479122231923036236186617394675402502480781536452215655393512713881124902145971480607820359e-80), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999986034958952087776808) }}, 
      {{ SC_(523360.0), SC_(10473.0), SC_(2063277.0), SC_(8862.0), SC_(0.5221288852532758849627399469006723323664781815657917069780326880376074910286319963529173242551252257e-3555), SC_(1.0), SC_(0.3379480603889418561657400711575949720561735223041804166187716211306338656187314636424512090159442327e-3556) }}, 
      {{ SC_(523360.0), SC_(10473.0), SC_(2427690.0), SC_(4430.0), SC_(0.3597908336329484534343516693669419436595338233660258722657946396240247975675210757441856115916975611e-495), SC_(1.0), SC_(0.2137925598936836262336929537199556335999383546551954691647491973615059415371548290969892146414485432e-495) }}, 
      {{ SC_(523360.0), SC_(19470.0), SC_(1030167.0), SC_(17439.0), SC_(0.3159893492662585553879043828657181989027256364099246381475152992208189310576362459708316291198612989e-2977), SC_(1.0), SC_(0.4175272706416225814304282370530219334810412601456394959365600575501752736344406563729668584853498279e-2978) }}, 
      {{ SC_(523360.0), SC_(19470.0), SC_(2063277.0), SC_(16775.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.3396337712174239782143647096518443791476993144287446519078431545738119504954379499022026575735051058e-7017)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1898489398925541176581252936128224114475346866654202700661034014637128213809816651042904659199546936e-7018)) }}, 
      {{ SC_(523360.0), SC_(19470.0), SC_(2427690.0), SC_(18766.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.4428721730117563103516722406057399620957530207179290064162086228737111088344305205856502690928142465e-11380)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.4447847918064110531980907645162029514200612240274677437277866576994217162838500858497747814907586878e-11382)) }}, 
      {{ SC_(523360.0), SC_(50688.0), SC_(1030167.0), SC_(35031.0), SC_(0.8807553857058812305591507082111255425559616226009505470412626900343613477819885303135235735765590249e-1596), SC_(1.0), SC_(0.7042835136767917487646955668739392739196573423192320805562062046766998461210868515344182936696530596e-1596) }}, 
      {{ SC_(523360.0), SC_(50688.0), SC_(2063277.0), SC_(40390.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.5512810850640612482121824477320727788243570780726923478802081675416080644982984708052709714413378599e-14699)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.4826384064070090213251183046818265010961410330456206671381325201311841352327197562284956869652959342e-14700)) }}, 
      {{ SC_(523360.0), SC_(50688.0), SC_(2427690.0), SC_(26147.0), SC_(0.105586192990463225512212479670816405098790899400429145868624562315829289290648510158376176674546486e-4892), SC_(1.0), SC_(0.3486617364924695555233312667189745754083880297668310408107453537648784029853610763352353361952518754e-4893) }}, 
      {{ SC_(523360.0), SC_(130605.0), SC_(1030167.0), SC_(40724.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.4875802199873827688960639397130628684554401476153910784014229757545288616635746225034830634517048657e-5106)), SC_(BOOST_MATH_SMALL_CONSTANT(0.801131600491382529036474286137294050391805587531879923151584380984583300035419206071470944653468136e-5106)), SC_(1.0) }}, 
      {{ SC_(523360.0), SC_(130605.0), SC_(2063277.0), SC_(76257.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.9430435009212016388585819318750223506467146496314121072391958158941654757127312876842238770242093614e-14951)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2575069480012123648411433415569562930624486918719235351289073034715821873532564937772003131462261793e-14951)) }}, 
      {{ SC_(523360.0), SC_(130605.0), SC_(2427690.0), SC_(113263.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.2740341666821778796776070001594123851885690988549772864057706425455147358523483367213984902443874176e-59329))), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.9432469788984580885980713626066055000824868936176571264265903570551731700777380126439122050197158113e-59331))) }}, 
      {{ SC_(523360.0), SC_(256574.0), SC_(1030167.0), SC_(9490.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.5848209706806700518464961486182982569424029529360785599218672205063598751976170051194824847410865714e-78019))), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.5963983856881557829849034132531271764107019850565560391483353039032213859029424078721144591841227578e-78019))), SC_(1.0) }}, 
      {{ SC_(523360.0), SC_(256574.0), SC_(2063277.0), SC_(19065.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2313249468208391476705261898962464152781418963333517468972384564129448875620300693654824300787010278e-13366)), SC_(BOOST_MATH_SMALL_CONSTANT(0.2918208582768986510174875388339704793576613190735329800165115832280031383531519009272933643939892067e-13366)), SC_(1.0) }}, 
      {{ SC_(523360.0), SC_(256574.0), SC_(2427690.0), SC_(222243.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.4750709460758428890090679131977197377800220463329784249326442942392772015047885822957282174976768245e-126129)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1211846183950113815634083271742757498094633363557022078835443890322461397949604501518736709098609175e-126130)) }}, 
      {{ SC_(523360.0), SC_(523360.0), SC_(1030167.0), SC_(241837.0), SC_(0.8203380924245702478022465695199141660464054381987079466873088211651636517976521955923552177625432037e-1957), SC_(0.262421221835750628594445612212717253102802734436617338014363711761843807875439393899886560993371945e-1956), SC_(1.0) }}, 
      {{ SC_(523360.0), SC_(523360.0), SC_(2063277.0), SC_(523107.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.2742551593647870935991747987630161823706074307930336949174057663247271068158586841593189399664693022e-505441))), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.2179607450351241061498653708982090434961861952733968698527652133203658826854572334030813375770150445e-505448))) }}, 
      {{ SC_(523360.0), SC_(523360.0), SC_(2427690.0), SC_(167943.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1307946563918413330125153523922735903409190292526504710160778136694032012335292411255481967652548299e-8882)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1234722830039163388584167446719687036074162098393983448101614882075922399922053025138276803059112893e-8882)) }}, 
      {{ SC_(1030167.0), SC_(3.0), SC_(2063277.0), SC_(3.0), SC_(0.1244656916965216824099312755150835353423991461986367293816333372160600060220044706699343470897903001), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(1030167.0), SC_(3.0), SC_(2427690.0), SC_(3.0), SC_(0.07640864267566021793429573486699017988253230757571319285279826824346982475334890136616710969299857399), SC_(1.0), SC_(0.0) }}, 
      {{ SC_(1030167.0), SC_(4.0), SC_(2063277.0), SC_(0.0), SC_(0.06285717434308834230571845459483623049940337324206162841082941414154386912241034830653446755935633627), SC_(0.06285717434308834230571845459483623049940337324206162841082941414154386912241034830653446755935633627), SC_(0.9371428256569116576942815454051637695005966267579383715891705858584561308775896516934655324406436637) }}, 
      {{ SC_(1030167.0), SC_(4.0), SC_(2427690.0), SC_(2.0), SC_(0.35802377665530429958538747951605973048066042464482055683041591500835316017239274241921285946081521), SC_(0.7916350933520690221841493798304308008781964872646429629260712554263029069667968209925908162623127498), SC_(0.2083649066479309778158506201695691991218035127353570370739287445736970930332031790074091837376872502) }}, 
      {{ SC_(1030167.0), SC_(15.0), SC_(2063277.0), SC_(7.0), SC_(0.196658595298442828773531158763541083896862049507894004804486835947707966639573367570484198958770475), SC_(0.5022408910398159059906303650403592401941493836921202429729696065252897451587130810543406349398338649), SC_(0.4977591089601840940093696349596407598058506163078797570270303934747102548412869189456593650601661351) }}, 
      {{ SC_(1030167.0), SC_(15.0), SC_(2427690.0), SC_(0.0), SC_(0.0002526225846719109315941957816788703227438846036735211108689548296788906492348413067843057003296837073), SC_(0.0002526225846719109315941957816788703227438846036735211108689548296788906492348413067843057003296837073), SC_(0.9997473774153280890684058042183211296772561153963264788891310451703211093507651586932156942996703163) }}, 
      {{ SC_(1030167.0), SC_(29.0), SC_(2063277.0), SC_(17.0), SC_(0.09597402403587093663322518158958835037940790491437720483353543625035650197314099611511886418478999356), SC_(0.8691837002845165093082740718587147930601879452821946981866457488215632284118300092309796668590722835), SC_(0.1308162997154834906917259281412852069398120547178053018133542511784367715881699907690203331409277165) }}, 
      {{ SC_(1030167.0), SC_(29.0), SC_(2427690.0), SC_(18.0), SC_(0.01583855213730406556761448184393930279575422562342840704298946361986033301120837530374341773135363038), SC_(0.9896940741570035330978463294562011501459048397175643393628612230810747371329691750395656959341614969), SC_(0.01030592584299646690215367054379884985409516028243566063713877691892526286703082496043430406583850314) }}, 
      {{ SC_(1030167.0), SC_(36.0), SC_(2063277.0), SC_(14.0), SC_(0.05587497210911513977466206385331105389149190118935879122181967673885381606278892832479813350987311111), SC_(0.1232326197199444213797323982639155118398977849643556562835342602097970295438231835861008483230259862), SC_(0.8767673802800555786202676017360844881601022150356443437164657397902029704561768164138991516769740138) }}, 
      {{ SC_(1030167.0), SC_(36.0), SC_(2427690.0), SC_(0.0), SC_(0.2322113113993755632339900377906429783574660750821549218170291048316956963115989940421732683361359516e-8), SC_(0.2322113113993755632339900377906429783574660750821549218170291048316956963115989940421732683361359516e-8), SC_(0.9999999976778868860062443676600996220935702164253392491784507818297089516830430368840100595782673166) }}, 
      {{ SC_(1030167.0), SC_(126.0), SC_(2063277.0), SC_(122.0), SC_(0.9908487164341572552033022252975767324449647801505303953834350581457984703224868143023437559183792028e-31), SC_(0.9999999999999999999999999999999967085354976012270813361604600694046783184570342021164418861007946372), SC_(0.3291464502398772918663839539930595321681542965797883558113899205362799621182923711165372630090104803e-32) }}, 
      {{ SC_(1030167.0), SC_(126.0), SC_(2427690.0), SC_(61.0), SC_(0.02848746415554044087412348179773979620341162445054129999526362638813950704816835355775928547871609795), SC_(0.925651000351588329831897643183475482648921108677540365389385960338959704452014771461321827190259475), SC_(0.07434899964841167016810235681652451735107889132245963461061403966104029554798522853867817280974052497) }}, 
      {{ SC_(1030167.0), SC_(244.0), SC_(2063277.0), SC_(59.0), SC_(0.1037531633848293360055273590080467450853558478144475704007595157701954873200811018430286840564861516e-15), SC_(0.1514392069764122550348458356557492179646011661182204394965441962904286246997185986085570222085840646e-15), SC_(0.9999999999999998485607930235877449651541643442507820353988338817795605034558037095713753002814013914) }}, 
      {{ SC_(1030167.0), SC_(244.0), SC_(2427690.0), SC_(183.0), SC_(0.3972645762272010579088971093675322426761116514833102246244825790295787322347862528480511877273845124e-24), SC_(0.9999999999999999999999998727085698041306000750404030206452853972299987735024527546151426947963590718), SC_(0.1272914301958693999249595969793547146027700012264975472453848573052036409281539267790072877959187805e-24) }}, 
      {{ SC_(1030167.0), SC_(312.0), SC_(2063277.0), SC_(250.0), SC_(0.1877129937300571996078598048202246198575350945264416452854606104086329937172539975904493404055006519e-27), SC_(0.9999999999999999999999999999391911870790073260117018919491841970153594697909289055007183330998145443), SC_(0.6080881292099267398829810805081580298464053020907109449928166690018545566315519909046241317142332226e-28) }}, 
      {{ SC_(1030167.0), SC_(312.0), SC_(2427690.0), SC_(85.0), SC_(0.9442775356025797914756086289114649603626142710746299499514786909744909637539297025600346117063334875e-8), SC_(0.1880791258867914252394611786992764323270236273296148112486779720739178824900343612314198234453533597e-7), SC_(0.9999999811920874113208574760538821300723567672976372670385188751322027926082117509965638768580176555) }}, 
      {{ SC_(1030167.0), SC_(835.0), SC_(2063277.0), SC_(345.0), SC_(0.1095135840388330070988356818181707146178897954450088888459634343418898040311572144145807671182278794e-6), SC_(0.3613155288259284857002798143244805017250812214710273559640688705681182688319606083790681555631056611e-6), SC_(0.9999996386844711740715142997201856755194982749187785289726440359311294318817311680393916209318444369) }}, 
      {{ SC_(1030167.0), SC_(835.0), SC_(2427690.0), SC_(75.0), SC_(0.1046238645057460941139299386571980701305131866225570041282934333682829546551558872981191254587975016e-101), SC_(0.1207202054612315267590830370498685692470803322934001094995077404493640244334318306118723989094100375e-101), SC_(1.0) }}, 
      {{ SC_(1030167.0), SC_(1339.0), SC_(2063277.0), SC_(457.0), SC_(0.6317110163314153332924849215621845737640198799498533922097164252345754956893980014166503084473007248e-31), SC_(0.1307872343740078021032883312168678251005125892768709590730100016987515506415408447073915257440322418e-30), SC_(0.9999999999999999999999999999998692127656259921978967116687831321748994874107231290409269899983012484) }}, 
      {{ SC_(1030167.0), SC_(1339.0), SC_(2427690.0), SC_(872.0), SC_(0.5595062128255891996571541098115753606885641289976189602903197652899818110008637388181759035373233103e-62), SC_(0.9999999999999999999999999999999999999999999999999999999999999963731689240138793552755909237309705223), SC_(0.362683107598612064472440907626902947774690080466895421429706207439896347441513854754322571741747828e-62) }}, 
      {{ SC_(1030167.0), SC_(2247.0), SC_(2063277.0), SC_(191.0), SC_(0.4504557861310102041512561637162314449752870028491692355147048769931918817905963629492904287864828929e-393), SC_(0.4965868941261775893726684314110180069673115758613205690701846757259630334251257473519674352788301231e-393), SC_(1.0) }}, 
      {{ SC_(1030167.0), SC_(2247.0), SC_(2427690.0), SC_(1143.0), SC_(0.1517557804312310196796278509678807976210744752970350521104744327147050581317007710865762267439758725e-15), SC_(0.9999999999999996318305490543951899530582388270526772755590997161486420143381726459519796954196006507), SC_(0.3681694509456048100469417611729473227244409002838513579856618273540480203045803993493217995408447005e-15) }}, 
      {{ SC_(1030167.0), SC_(6337.0), SC_(2063277.0), SC_(454.0), SC_(0.4025422160819852297568951968523274596062246125438904788756962198164406817266817833667333487098811031e-1199), SC_(0.436103336876351429519087945530031646475456673813534761357883347838764593638289935338391583046698877e-1199), SC_(1.0) }}, 
      {{ SC_(1030167.0), SC_(6337.0), SC_(2427690.0), SC_(3237.0), SC_(0.1998166273103297961784253705763905907278331516667620744588693045942543327518672320522462390121057999e-43), SC_(0.9999999999999999999999999999999999999999999524730441601129242156027593234048677021216477272047549735), SC_(0.4752695583988707578439724067659513229787835227279524502651221127946129470404914059241899485939245177e-43) }}, 
      {{ SC_(1030167.0), SC_(10473.0), SC_(2063277.0), SC_(9877.0), SC_(0.7783725693103413705570710389260868973240616725731925865900828253752567827898934667073187007389470159e-2176), SC_(1.0), SC_(0.4934433456851754059627122114623322636843600746350737771039776009297673897244589085180450216278534745e-2177) }}, 
      {{ SC_(1030167.0), SC_(10473.0), SC_(2427690.0), SC_(5712.0), SC_(0.7355901010579335219765238522179016937705926659452295729977036156048032907611269656358611739668634818e-137), SC_(1.0), SC_(0.1163249001626992207066540272519157169051103416567797715789509742964335364566244129318021762330807649e-136) }}, 
      {{ SC_(1030167.0), SC_(19470.0), SC_(2063277.0), SC_(6846.0), SC_(0.6703080713107374656044787470489971833315841258162916573058643493102267089053779105352055684607339629e-380), SC_(0.1459126867347770655865859989875429623027864182357521093362522814183914369575106484463985221090338746e-379), SC_(1.0) }}, 
      {{ SC_(1030167.0), SC_(19470.0), SC_(2427690.0), SC_(2833.0), SC_(0.8785288357918805501451553139735155116781962715299419647419967431421184416853195710404807906416977552e-1550), SC_(0.1139234820978152677581944812918196842184586175178446208622563077041369083565215813619803609808418003e-1549), SC_(1.0) }}, 
      {{ SC_(1030167.0), SC_(50688.0), SC_(2063277.0), SC_(5958.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2696611800809340133866864913059483733762650252007098931107252423414951968838899485622090902801604347e-7429)), SC_(BOOST_MATH_SMALL_CONSTANT(0.3094335971442905044072386934961293807150112770244272987590834754277833101226687685341807913602359489e-7429)), SC_(1.0) }}, 
      {{ SC_(1030167.0), SC_(50688.0), SC_(2427690.0), SC_(24749.0), SC_(0.2578716269345720961744344112334709803169389018972677518401353907891401845167717494934082857214768696e-188), SC_(1.0), SC_(0.8538547595672537381757380908369587958654029695913527955575657852406906964195281915375545945375373932e-188) }}, 
      {{ SC_(1030167.0), SC_(130605.0), SC_(2063277.0), SC_(67199.0), SC_(0.1772402217747576023975265826925769595264611577464025377584499804202175059831312745179381288679219898e-30), SC_(0.9999999999999999999999999999973844048905181626720565455251696667915520055031995673391485820685310697), SC_(0.2615595109481837327943454474830333208447994496800432660851417931468930325870724472627377999209154375e-29) }}, 
      {{ SC_(1030167.0), SC_(130605.0), SC_(2427690.0), SC_(62807.0), SC_(0.2526562134449195027792279400361520142369933233947774941848233866437381584491456912781842143198296159e-391), SC_(1.0), SC_(0.9235445258826835146504359095658972972561150774551460899132768721999586312051548667127893915560202981e-391) }}, 
      {{ SC_(1030167.0), SC_(256574.0), SC_(2063277.0), SC_(136078.0), SC_(0.1889505875800464975393622983597902398805285201058519859012948813401757384027515978291586034505061829e-248), SC_(1.0), SC_(0.1236113837302074642637204443211773020459272585535378891152669651196365415708839777030544349579933748e-247) }}, 
      {{ SC_(1030167.0), SC_(256574.0), SC_(2427690.0), SC_(5059.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.3415687552349317027106561182030892561608054053847049256991933370024960969305479793930443943170209826e-55782))), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.3494259919719804048098668133719877462120862735795090904931820959068567376960513319071259582269982684e-55782))), SC_(1.0) }}, 
      {{ SC_(1030167.0), SC_(523360.0), SC_(2063277.0), SC_(45322.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.6406250319059851000414186122521980525283948930917260704720124702812431881419266715502486311348930843e-116984)), SC_(BOOST_MATH_SMALL_CONSTANT(0.6767892889836179660205690345292677556531677014893649920196102930641077389045148072153989233371368326e-116984)), SC_(1.0) }}, 
      {{ SC_(1030167.0), SC_(523360.0), SC_(2427690.0), SC_(169882.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2359533635629512164764734112351286744012027902065592462710641731769499440473362833287635226506536775e-6029)), SC_(BOOST_MATH_SMALL_CONSTANT(0.5661726060614987628669304125055108672612592607173491522003446602490067211732156035758926889094610648e-6029)), SC_(1.0) }}, 
      {{ SC_(1030167.0), SC_(1030167.0), SC_(2063277.0), SC_(744478.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.4511153571077027519604414144322801206679870058587253174456021218360208321437627577138707488632852896e-92404))), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.7754310234985811873988039144864472895479722845395841523576919087158739737428332572815461903769407882e-92405))) }}, 
      {{ SC_(1030167.0), SC_(1030167.0), SC_(2427690.0), SC_(572726.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1391919893786702038962612009846824397331628724453809213678113652788484674273410824482758277274826774e-27643)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.8848627313045931655152816475946061877553473103461211294820092561884413448622321591917114894334786741e-27644)) }}, 
      {{ SC_(2063277.0), SC_(3.0), SC_(2427690.0), SC_(1.0), SC_(0.05744948917837785396631837850087687638865986911538300396398836885344514018919283261725123608911631573), SC_(0.06083168584917255775414716520408138122920687784053330869080901476158912618517300547284053088480152357), SC_(0.9391683141508274422458528347959186187707931221594666913091909852384108738148269945271594691151984764) }}, 
      {{ SC_(2063277.0), SC_(4.0), SC_(2427690.0), SC_(2.0), SC_(0.09765192319603535795200082936537967044984677193469420307214403317599152054043820712170776297045732308), SC_(0.1096576474471902367301475798867712164541302638078804102268810313495852909563466728647636960006874216), SC_(0.8903423525528097632698524201132287835458697361921195897731189686504147090436533271352363039993125784) }}, 
      {{ SC_(2063277.0), SC_(15.0), SC_(2427690.0), SC_(2.0), SC_(0.1489538545802902607664120997954020858865667522818151389900602349430345082934769865095821871577947918e-8), SC_(0.1527562590656629047323044385006577628342277802825044663380264946841620738937005774513717697678843875e-8), SC_(0.9999999984724374093433709526769556149934223716577221971749553366197350531583792610629942254862823023) }}, 
      {{ SC_(2063277.0), SC_(29.0), SC_(2427690.0), SC_(24.0), SC_(0.1825580820948670496065127391210869986226421373788908976816528717196305923822458800333980579115728127), SC_(0.445163736077329563124004070889775468206373091875399633746378366762360683651027004054511129031081457), SC_(0.554836263922670436875995929110224531793626908124600366253621633237639316348972995945488870968918543) }}, 
      {{ SC_(2063277.0), SC_(36.0), SC_(2427690.0), SC_(22.0), SC_(0.0003125643546548426465134199665900176038001607706081738565500117820653374268332937528261593867942722811), SC_(0.0004170661129387665482411517580309840599293201092352328271804108145419950379407776296795046335742746907), SC_(0.9995829338870612334517588482419690159400706798907647671728195891854580049620592223703204953664257253) }}, 
      {{ SC_(2063277.0), SC_(126.0), SC_(2427690.0), SC_(124.0), SC_(0.3090497262600759339310995264132131683837693477210209596697565157782818504892226262835886329947677904e-6), SC_(0.9999999707466493421791804803401295750261251967731062983856754109793651076882563380203078160781201427), SC_(0.292533506578208195196598704249738748032268937016143245890206348923117436619796921839218798573098886e-7) }}, 
      {{ SC_(2063277.0), SC_(244.0), SC_(2427690.0), SC_(125.0), SC_(0.1926311146754487317839352173396317360254859601590752007913400851592802919026180964385042186799388985e-34), SC_(0.2358551776787649570027910244313940189611854169940576794125495099425455366841057480399695284027407998e-34), SC_(0.9999999999999999999999999999999999764144822321235042997208975568605981038814583005942320587450490057) }}, 
      {{ SC_(2063277.0), SC_(312.0), SC_(2427690.0), SC_(101.0), SC_(0.1166767818366514624165565698899735105639350733982911242849414658751117357600131962830133143705241353e-96), SC_(0.1273746118350149699556320311421523675800002438203319168937701298695872308610721640141197137021741127e-96), SC_(0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999998726) }}, 
      {{ SC_(2063277.0), SC_(835.0), SC_(2427690.0), SC_(537.0), SC_(0.23461228902101219097178707917291860335053529413516261545028998077215105088793120601212977276059809e-48), SC_(0.3431363619828340409481381658562477455080489826352272059292470590381196707245019036327290686732838148e-48), SC_(0.9999999999999999999999999999999999999999999999996568636380171659590518618341437522544919510173647728) }}, 
      {{ SC_(2063277.0), SC_(1339.0), SC_(2427690.0), SC_(567.0), SC_(0.3041470601326637639494336714081772092631985361508198839012668100830373463893945362825999488268208953e-281), SC_(0.3492944674692955483087920207427729775582252986994579321749324087059134559172244801668433526825047348e-281), SC_(1.0) }}, 
      {{ SC_(2063277.0), SC_(2247.0), SC_(2427690.0), SC_(146.0), SC_(0.1961583257344876361407986442912971748133704876860571439720756997039603833526484722848050981525197114e-1509), SC_(0.1985803181231377171100024006050801391647985792237330316683697442131384730223214433005701459145186371e-1509), SC_(1.0) }}, 
      {{ SC_(2063277.0), SC_(6337.0), SC_(2427690.0), SC_(2672.0), SC_(0.1946697310930234468246720701513688516379049429450611162377788936941304610494217178093823793465460629e-1340), SC_(0.2231398150887527500500636624540547473831434192427597288446010950080238974412696796973001269796604522e-1340), SC_(1.0) }}, 
      {{ SC_(2063277.0), SC_(10473.0), SC_(2427690.0), SC_(9239.0), SC_(0.1551193531816254902127180217675278330953801636526937883589391307214311968656400971435645306065954152e-21), SC_(0.9999999999999999999995265520566596472139336012063899453012696720276036981041380189756120978583403695), SC_(0.4734479433403527860663987936100546987303279723963018958619810243879021416596305465302368046704094033e-21) }}, 
      {{ SC_(2063277.0), SC_(19470.0), SC_(2427690.0), SC_(4675.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.623040705399711425127124917791866020596913429898404691576374003232002649354732173377846476674429555e-7957)), SC_(BOOST_MATH_SMALL_CONSTANT(0.6583688419938623576817522468445990251506727431116697161171189880925188638737939276886488942322787167e-7957)), SC_(1.0) }}, 
      {{ SC_(2063277.0), SC_(50688.0), SC_(2427690.0), SC_(5656.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.1529278237073002921981596930779124386741258366470694934804851463595902054455594437519411007451134623e-30822)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1559684068913597863769291907119127621669934794968537447893450088285543334777687079420401191985208386e-30822)), SC_(1.0) }}, 
      {{ SC_(2063277.0), SC_(130605.0), SC_(2427690.0), SC_(12086.0), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.1838031979064376860156110323884379948298364325044049860781553255686817375515358349062016312896522764e-88900))), SC_(BOOST_MATH_SMALL_CONSTANT(BOOST_MATH_SMALL_CONSTANT(0.1860779122972254559882711932578481205298684299140770720149987268252855087660161273279636415996449002e-88900))), SC_(1.0) }}, 
      {{ SC_(2063277.0), SC_(256574.0), SC_(2427690.0), SC_(208651.0), SC_(0.1043358350305396213816825473194597727628397567524572489210649347280772703074417268374663807425040052e-624), SC_(0.4058279349421142862579906719998452318972757308871573552913945099588747110076803516651018133973772923e-624), SC_(1.0) }}, 
      {{ SC_(2063277.0), SC_(523360.0), SC_(2427690.0), SC_(184261.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.3757927138352356631892501916344494185815670042854429196331040880186979716874474145827399077949946912e-240005)), SC_(BOOST_MATH_SMALL_CONSTANT(0.3785639581119621756070451029910607902592003937852821432380999689590450613028232909193510596494914717e-240005)), SC_(1.0) }}, 
      {{ SC_(2063277.0), SC_(1030167.0), SC_(2427690.0), SC_(803033.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2014503510496423731073796011823145616941176229174944683082735797595277609595578046438978094454227689e-14930)), SC_(BOOST_MATH_SMALL_CONSTANT(0.3276248348930073080804548929222879527457119577454409744322412672836109490789223127331688301365927403e-14930)), SC_(1.0) }}, 
      {{ SC_(2063277.0), SC_(2063277.0), SC_(2427690.0), SC_(1949025.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.9948928329918925300825475902876870461866169772968706503745565572554925906532956518816712676968759027e-155653)), SC_(1.0), SC_(BOOST_MATH_SMALL_CONSTANT(0.2736845628398119894621780530003341353062573210278622168826610191467448846343071724458397259050505966e-155654)) }}
   }};
#undef SC_

