/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CSiteSurveyTab.h
    \author Romain BONDUE
    \date 29/07/2005 */
#ifndef __CSITESURVEYTAB_H__
#define __CSITESURVEYTAB_H__

#include <string>
#include <vector>
#include <stdexcept>

extern "C"{
#include <gtk/gtk.h>
}

#include "CSelectableRowList.h"
#include "Exceptions.h"



namespace nsWireless
{
    class CCell;
    class CMacAddress;

} // namespace nsWireless



namespace nsGUI
{
    class CGtkGUI;

    typedef std::vector<nsWireless::CCell> CellVec_t;


    class CSiteSurveyTab : protected CSelectableRowList
    {
      public :
        CSiteSurveyTab (CGtkGUI*) throw();
        ~CSiteSurveyTab () throw();
        operator ::GtkWidget* () throw();

        /** \return The current associated cell, 0 if none.*/
        const nsWireless::CCell* AddCells (const CellVec_t&,
                                    const nsWireless::CMacAddress&) throw();
        void SetSelected (unsigned, bool) throw();
        int GetSelectedRow () const throw();
        void ScanningStarted () throw();
        void ScanningStopped () throw();


      protected :
        static const unsigned NbColumn = 11;
        enum {ButtonPos, SSIDPos, APMacPos, ModePos, LinkQPos, SignalLPos,
              NoiseLPos, ChannelPos, RatePos, EncryptPos, AuthPos};
        void RowSelectedCallBack () throw();
        void RowUnselectedCallBack () throw();

        static const char* const ScanButtonLabel;


      private :
        ::GtkBox* const m_pVBox;
        ::GtkWidget* const m_pScanButton;
        ::GtkWidget* const m_pAddProfileButton;
        ::GtkWidget* const m_pConnectButton;
        bool m_IsScanning;

        static const char* ColumnTitle [NbColumn];
        static const ::GType TabType [NbColumn];

        static void ScanButtonCallBack (::GtkButton*, CSiteSurveyTab*) throw();
        static void AddProfileButtonCallBack (::GtkButton*, CSiteSurveyTab*)
                                                                    throw();
        static void ConnectButtonCallBack (::GtkButton*, CSiteSurveyTab*)
                                                                    throw();

    }; // CSiteSurveyTab

} // namespace nsGUI

#include "private/CSiteSurveyTab.hxx"

#endif // __CSITESURVEYTAB_H__
