// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv64 -target-feature +zknd -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg \
// RUN:     | FileCheck %s  -check-prefix=RV64ZKND-ZKNE
// RUN: %clang_cc1 -triple riscv64 -target-feature +zkne -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg \
// RUN:     | FileCheck %s  -check-prefix=RV64ZKND-ZKNE

#include <stdint.h>

// RV64ZKND-ZKNE-LABEL: @aes64ks1i(
// RV64ZKND-ZKNE-NEXT:  entry:
// RV64ZKND-ZKNE-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.aes64ks1i(i64 [[RS1:%.*]], i32 0)
// RV64ZKND-ZKNE-NEXT:    ret i64 [[TMP0]]
//
uint64_t aes64ks1i(uint64_t rs1) {
  return __builtin_riscv_aes64ks1i(rs1, 0);
}

// RV64ZKND-ZKNE-LABEL: @aes64ks2(
// RV64ZKND-ZKNE-NEXT:  entry:
// RV64ZKND-ZKNE-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.aes64ks2(i64 [[RS1:%.*]], i64 [[RS2:%.*]])
// RV64ZKND-ZKNE-NEXT:    ret i64 [[TMP0]]
//
uint64_t aes64ks2(uint64_t rs1, uint64_t rs2) {
  return __builtin_riscv_aes64ks2(rs1, rs2);
}
