# Changelog

## [1.3.0](https://github.com/parallaxsecond/parsec/tree/1.3.0) (2023-10-25)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/1.3.0-rc2...1.3.0)

## [1.3.0-rc2](https://github.com/parallaxsecond/parsec/tree/1.3.0-rc2) (2023-10-19)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/1.3.0-rc1...1.3.0-rc2)

**Merged pull requests:**

- e2e\_tests/wrong\_permitted\_algorithm: Change used sha for hw compatibi… [\#723](https://github.com/parallaxsecond/parsec/pull/723) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))

## [1.3.0-rc1](https://github.com/parallaxsecond/parsec/tree/1.3.0-rc1) (2023-10-17)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/1.2.0...1.3.0-rc1)

**Closed issues:**

- Update cryptoki version to `0.4.1`  [\#668](https://github.com/parallaxsecond/parsec/issues/668)
- `ansi_term` is unmaintained [\#629](https://github.com/parallaxsecond/parsec/issues/629)

**Merged pull requests:**

- Bump psa-crypto and interface crates [\#718](https://github.com/parallaxsecond/parsec/pull/718) ([gowthamsk-arm](https://github.com/gowthamsk-arm))
- Update toml, env\_logger and bindgen crates [\#716](https://github.com/parallaxsecond/parsec/pull/716) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Bump various crates [\#714](https://github.com/parallaxsecond/parsec/pull/714) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Update picky crates [\#711](https://github.com/parallaxsecond/parsec/pull/711) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Cargo.toml: Remove uuid crate [\#710](https://github.com/parallaxsecond/parsec/pull/710) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Bump sd-notify to 0.4.1 [\#708](https://github.com/parallaxsecond/parsec/pull/708) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- fuzz: Bump bumpalo to 3.14.0 [\#706](https://github.com/parallaxsecond/parsec/pull/706) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Update the tss-esapi crate to version 7.3.0 [\#702](https://github.com/parallaxsecond/parsec/pull/702) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Fix cargo-tarpaulin version to 0.26.1 [\#701](https://github.com/parallaxsecond/parsec/pull/701) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Add a Security Vulnerability Reporting section in the README [\#700](https://github.com/parallaxsecond/parsec/pull/700) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Update maintainers list [\#699](https://github.com/parallaxsecond/parsec/pull/699) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- ci: Fix coverage builds, nightly issues [\#698](https://github.com/parallaxsecond/parsec/pull/698) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Update cryptoki and cryptoki-sys crates [\#697](https://github.com/parallaxsecond/parsec/pull/697) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Use arrays instead of vec! when possible [\#696](https://github.com/parallaxsecond/parsec/pull/696) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Make wrong\_permitted\_algorithm test use a non-deprecated Hash [\#695](https://github.com/parallaxsecond/parsec/pull/695) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Fix coverage builds for different providers [\#694](https://github.com/parallaxsecond/parsec/pull/694) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Update MSRV to Rust 1.66.0 [\#692](https://github.com/parallaxsecond/parsec/pull/692) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Bump ASN1 crates dependencies [\#691](https://github.com/parallaxsecond/parsec/pull/691) ([anta5010](https://github.com/anta5010))
- Minor fixes to changelog [\#690](https://github.com/parallaxsecond/parsec/pull/690) ([gowthamsk-arm](https://github.com/gowthamsk-arm))
- Upgrade proc-macro2 package [\#688](https://github.com/parallaxsecond/parsec/pull/688) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Update CONTRIBUTORS.md [\#687](https://github.com/parallaxsecond/parsec/pull/687) ([Firstyear](https://github.com/Firstyear))
- Disable the optional features for the 'structopt' crate [\#686](https://github.com/parallaxsecond/parsec/pull/686) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Upgrade enumflags2 crate [\#685](https://github.com/parallaxsecond/parsec/pull/685) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Remove unmaintained 'users' crate [\#684](https://github.com/parallaxsecond/parsec/pull/684) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Fix compilation issues [\#682](https://github.com/parallaxsecond/parsec/pull/682) ([tgonzalezorlandoarm](https://github.com/tgonzalezorlandoarm))
- Bump base64 dependency to 0.21.0 [\#679](https://github.com/parallaxsecond/parsec/pull/679) ([ema](https://github.com/ema))

## [1.2.0](https://github.com/parallaxsecond/parsec/tree/1.2.0) (2023-04-05)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/1.2.0-rc1...1.2.0)

**Closed issues:**

- Parsec 1.1 fails to build with meta-security master branch [\#663](https://github.com/parallaxsecond/parsec/issues/663)

## [1.2.0-rc1](https://github.com/parallaxsecond/parsec/tree/1.2.0-rc1) (2023-03-21)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/1.1.0...1.2.0-rc1)

**Closed issues:**

- Parsec fails to compile for arm32  [\#647](https://github.com/parallaxsecond/parsec/issues/647)

**Merged pull requests:**

- Update crates [\#671](https://github.com/parallaxsecond/parsec/pull/671) ([gowthamsk-arm](https://github.com/gowthamsk-arm))
- Update rusqlite to fix security issue [\#662](https://github.com/parallaxsecond/parsec/pull/662) ([gowthamsk-arm](https://github.com/gowthamsk-arm))
- Update MSRV to 1.58 [\#661](https://github.com/parallaxsecond/parsec/pull/661) ([gowthamsk-arm](https://github.com/gowthamsk-arm))
- Remove dependency on crate "version" [\#657](https://github.com/parallaxsecond/parsec/pull/657) ([ema](https://github.com/ema))
- Update TPM TCTI configuration docs [\#656](https://github.com/parallaxsecond/parsec/pull/656) ([paulhowardarm](https://github.com/paulhowardarm))
- Add support for a Quickstart Docker image [\#654](https://github.com/parallaxsecond/parsec/pull/654) ([dennisgove](https://github.com/dennisgove))
- Update to remove const\_err [\#653](https://github.com/parallaxsecond/parsec/pull/653) ([marcsvll](https://github.com/marcsvll))
- Fix Clippy warnings for rustc version 1.65 [\#652](https://github.com/parallaxsecond/parsec/pull/652) ([mohamedasaker-arm](https://github.com/mohamedasaker-arm))
- Bump sd-notify to 0.3.0 [\#651](https://github.com/parallaxsecond/parsec/pull/651) ([stevecapperarm](https://github.com/stevecapperarm))

## [1.1.0](https://github.com/parallaxsecond/parsec/tree/1.1.0) (2022-09-29)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/1.1.0-rc2...1.1.0)

## [1.1.0-rc2](https://github.com/parallaxsecond/parsec/tree/1.1.0-rc2) (2022-09-13)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/1.1.0-rc1...1.1.0-rc2)

**Merged pull requests:**

- Update change log for release candidate 1.1.0-rc2 [\#639](https://github.com/parallaxsecond/parsec/pull/639) ([mohamedasaker-arm](https://github.com/mohamedasaker-arm))
- Release candidate prep 1.1.0 rc2 [\#638](https://github.com/parallaxsecond/parsec/pull/638) ([mohamedasaker-arm](https://github.com/mohamedasaker-arm))

## [1.1.0-rc1](https://github.com/parallaxsecond/parsec/tree/1.1.0-rc1) (2022-09-07)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/1.0.0...1.1.0-rc1)

**Implemented enhancements:**

- Update PKCS11 dependency [\#604](https://github.com/parallaxsecond/parsec/issues/604)
- Allow binary PIN values for PKCS11 providers [\#603](https://github.com/parallaxsecond/parsec/issues/603)
- Implement get\_random in the PKCS11 provider [\#594](https://github.com/parallaxsecond/parsec/issues/594)
- Implement get\_random in TPM provider [\#593](https://github.com/parallaxsecond/parsec/issues/593)
- Create script for Quickstart package [\#534](https://github.com/parallaxsecond/parsec/issues/534)
- Recognise a PKCS11 hardware token with its serial number instead of slot number [\#481](https://github.com/parallaxsecond/parsec/issues/481)
- Implement configurable exclusion of deprecated primitives [\#119](https://github.com/parallaxsecond/parsec/issues/119)

**Fixed bugs:**

- RSA padding oracle issue [\#619](https://github.com/parallaxsecond/parsec/issues/619)
- PKCS11 provider serial\_number configuration [\#615](https://github.com/parallaxsecond/parsec/issues/615)
- Export of public EC key fails with PKCS\#11 back-end on NXP Layerscape [\#599](https://github.com/parallaxsecond/parsec/issues/599)
- Wrong permissions on KIM files [\#598](https://github.com/parallaxsecond/parsec/issues/598)
- Send back PsaErrorInvalidPadding when needed [\#620](https://github.com/parallaxsecond/parsec/pull/620) ([ionut-arm](https://github.com/ionut-arm))

**Security fixes:**

- Update Spiffe dependency [\#602](https://github.com/parallaxsecond/parsec/issues/602)

**Closed issues:**

- Add key persistence tests for TS provider [\#568](https://github.com/parallaxsecond/parsec/issues/568)
- Create stability tests for SQLite KIM [\#519](https://github.com/parallaxsecond/parsec/issues/519)
- Change default socket path for E2E tests [\#463](https://github.com/parallaxsecond/parsec/issues/463)

**Merged pull requests:**

- Update Change log and service version no. [\#637](https://github.com/parallaxsecond/parsec/pull/637) ([mohamedasaker-arm](https://github.com/mohamedasaker-arm))
- Update maintainers list [\#636](https://github.com/parallaxsecond/parsec/pull/636) ([mohamedasaker-arm](https://github.com/mohamedasaker-arm))
- Fix spiffy issue [\#635](https://github.com/parallaxsecond/parsec/pull/635) ([gowthamsk-arm](https://github.com/gowthamsk-arm))
- Add sqlite stability tests [\#634](https://github.com/parallaxsecond/parsec/pull/634) ([gowthamsk-arm](https://github.com/gowthamsk-arm))
- Feature/119 implement configurable exclusion of deprecated primitives [\#633](https://github.com/parallaxsecond/parsec/pull/633) ([mohamedasaker-arm](https://github.com/mohamedasaker-arm))
- Feature/603 allow binary pin values for pkcs11 [\#631](https://github.com/parallaxsecond/parsec/pull/631) ([mohamedasaker-arm](https://github.com/mohamedasaker-arm))
- Add `Eq` to the types with `PartialEq` [\#630](https://github.com/parallaxsecond/parsec/pull/630) ([ionut-arm](https://github.com/ionut-arm))
- build and share docker image across jobs [\#628](https://github.com/parallaxsecond/parsec/pull/628) ([mohamedasaker-arm](https://github.com/mohamedasaker-arm))
- Kim file permissions [\#627](https://github.com/parallaxsecond/parsec/pull/627) ([gowthamsk-arm](https://github.com/gowthamsk-arm))
- Testing/568 add key persistence tests for ts provider [\#625](https://github.com/parallaxsecond/parsec/pull/625) ([mohamedasaker-arm](https://github.com/mohamedasaker-arm))
- Fix problem reported by Clippy \(rust 1.62\) [\#624](https://github.com/parallaxsecond/parsec/pull/624) ([mohamedasaker-arm](https://github.com/mohamedasaker-arm))
- Validate hash sign operation before execution. [\#623](https://github.com/parallaxsecond/parsec/pull/623) ([gowthamsk-arm](https://github.com/gowthamsk-arm))
- Fix Hugues' email address [\#622](https://github.com/parallaxsecond/parsec/pull/622) ([hug-dev](https://github.com/hug-dev))
- Compare trimmed token serial numbers \(PKCS11 provider\) [\#621](https://github.com/parallaxsecond/parsec/pull/621) ([mohamedasaker-arm](https://github.com/mohamedasaker-arm))
- Added some context to error messages. [\#618](https://github.com/parallaxsecond/parsec/pull/618) ([fredrik-jansson-se](https://github.com/fredrik-jansson-se))
- Implement get\_random in the PKCS11 provider [\#613](https://github.com/parallaxsecond/parsec/pull/613) ([gowthamsk-arm](https://github.com/gowthamsk-arm))
- Add a script to create the Quickstart package [\#612](https://github.com/parallaxsecond/parsec/pull/612) ([mohamedasaker-arm](https://github.com/mohamedasaker-arm))
- Change default socket path for E2E tests [\#610](https://github.com/parallaxsecond/parsec/pull/610) ([gowthamsk-arm](https://github.com/gowthamsk-arm))
- Fix `cargo-audit` TOML config [\#609](https://github.com/parallaxsecond/parsec/pull/609) ([ionut-arm](https://github.com/ionut-arm))
- Recognise a PKCS11 hardware token with its serial number instead of slot number [\#608](https://github.com/parallaxsecond/parsec/pull/608) ([mohamedasaker-arm](https://github.com/mohamedasaker-arm))
- Bump version of cryptoki [\#605](https://github.com/parallaxsecond/parsec/pull/605) ([ionut-arm](https://github.com/ionut-arm))
- Fix issue \#599 - allow EC\_POINT public key data to omit ASN.1 structure wrapping [\#600](https://github.com/parallaxsecond/parsec/pull/600) ([paulhowardarm](https://github.com/paulhowardarm))
- Add generate random support into TPM provider [\#595](https://github.com/parallaxsecond/parsec/pull/595) ([anta5010](https://github.com/anta5010))

## [1.0.0](https://github.com/parallaxsecond/parsec/tree/1.0.0) (2022-03-30)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/1.0.0-rc3...1.0.0)

**Security fixes:**

- RUSTSEC-2022-0013 [\#587](https://github.com/parallaxsecond/parsec/issues/587)

**Merged pull requests:**

- Update Changelog file to include 1.0.0 [\#596](https://github.com/parallaxsecond/parsec/pull/596) ([ionut-arm](https://github.com/ionut-arm))

## [1.0.0-rc3](https://github.com/parallaxsecond/parsec/tree/1.0.0-rc3) (2022-03-21)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/1.0.0-rc2...1.0.0-rc3)

**Fixed bugs:**

- Cargo audit failing [\#544](https://github.com/parallaxsecond/parsec/issues/544)

**Merged pull requests:**

- Prepare for Release Candidate 3 [\#592](https://github.com/parallaxsecond/parsec/pull/592) ([ionut-arm](https://github.com/ionut-arm))

## [1.0.0-rc2](https://github.com/parallaxsecond/parsec/tree/1.0.0-rc2) (2022-03-02)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/1.0.0-rc1...1.0.0-rc2)

**Implemented enhancements:**

- Updates for Release Candidate 2 [\#584](https://github.com/parallaxsecond/parsec/pull/584) ([ionut-arm](https://github.com/ionut-arm))

**Closed issues:**

- Update the Parsec Book to include SQLiteKeyInfoManager [\#532](https://github.com/parallaxsecond/parsec/issues/532)

## [1.0.0-rc1](https://github.com/parallaxsecond/parsec/tree/1.0.0-rc1) (2022-02-16)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/0.8.1...1.0.0-rc1)

**Implemented enhancements:**

- `parsec.service` hardening [\#569](https://github.com/parallaxsecond/parsec/issues/569)
- Implement `CryptoCanDo` for the Trusted Services and Mbed Crypto providers [\#543](https://github.com/parallaxsecond/parsec/issues/543)
- Implement CryptoCanDo for TPM provider [\#542](https://github.com/parallaxsecond/parsec/issues/542)
- Refactor the PKCS11 CryptoCanDo implementation [\#541](https://github.com/parallaxsecond/parsec/issues/541)
- Implement ActivateCredential key attestation [\#539](https://github.com/parallaxsecond/parsec/issues/539)
- Making the SQLiteKIM the default [\#531](https://github.com/parallaxsecond/parsec/issues/531)
- Create a new KeyInfoManager based on SQLite [\#424](https://github.com/parallaxsecond/parsec/issues/424)
- Add support for other cryptographic services in the Trusted Service provider [\#341](https://github.com/parallaxsecond/parsec/issues/341)
- Add system emulation tests for TS provider [\#304](https://github.com/parallaxsecond/parsec/issues/304)
- Add support for importing ECC public key in the TPM provider [\#170](https://github.com/parallaxsecond/parsec/issues/170)
- Add asymmetric encryption to TS provider [\#580](https://github.com/parallaxsecond/parsec/pull/580) ([ionut-arm](https://github.com/ionut-arm))
- Change dependency revision for TSS crate [\#579](https://github.com/parallaxsecond/parsec/pull/579) ([ionut-arm](https://github.com/ionut-arm))
- Add systemd hardening options [\#572](https://github.com/parallaxsecond/parsec/pull/572) ([ionut-arm](https://github.com/ionut-arm))
- Make SQLite KIM default [\#570](https://github.com/parallaxsecond/parsec/pull/570) ([ionut-arm](https://github.com/ionut-arm))
- Feature sqlite kim [\#566](https://github.com/parallaxsecond/parsec/pull/566) ([ionut-arm](https://github.com/ionut-arm))
- Add error handling to ActivateCredential [\#562](https://github.com/parallaxsecond/parsec/pull/562) ([ionut-arm](https://github.com/ionut-arm))
- Add ActivateCredential tests and fixes [\#560](https://github.com/parallaxsecond/parsec/pull/560) ([ionut-arm](https://github.com/ionut-arm))
- Activate credential [\#558](https://github.com/parallaxsecond/parsec/pull/558) ([ionut-arm](https://github.com/ionut-arm))
- Expand support for importing public keys for TPM [\#540](https://github.com/parallaxsecond/parsec/pull/540) ([ionut-arm](https://github.com/ionut-arm))
- \[CryptoAuthLib provider\] PsaAeadEncrypt and PsaAeadDecrypt implemented [\#536](https://github.com/parallaxsecond/parsec/pull/536) ([TomaszPawelecGL](https://github.com/TomaszPawelecGL))

**Fixed bugs:**

- Disable test from old E2E suite [\#574](https://github.com/parallaxsecond/parsec/issues/574)
- Errors in validating ECC key bits in PKCS11 provider [\#545](https://github.com/parallaxsecond/parsec/issues/545)
- UnixDomainSocket connection returns error from server [\#528](https://github.com/parallaxsecond/parsec/issues/528)
- Fuzz Testing & Nightly Cargo udeps are failing due to prost-derive [\#514](https://github.com/parallaxsecond/parsec/issues/514)
- TPM Provider does not persist generated keys accross reboot [\#504](https://github.com/parallaxsecond/parsec/issues/504)
- Issue with PKCS11 backend with Nitrokey HSM [\#380](https://github.com/parallaxsecond/parsec/issues/380)
- Skip flakey test [\#577](https://github.com/parallaxsecond/parsec/pull/577) ([ionut-arm](https://github.com/ionut-arm))
- Fix codecov build [\#573](https://github.com/parallaxsecond/parsec/pull/573) ([ionut-arm](https://github.com/ionut-arm))
- Fix handling of `bits` in PKCS11 imports [\#546](https://github.com/parallaxsecond/parsec/pull/546) ([ionut-arm](https://github.com/ionut-arm))

**Closed issues:**

- Align with stable TSS crate [\#567](https://github.com/parallaxsecond/parsec/issues/567)
- Stable 0.8.1 release depends on tss-esapi alpha  [\#527](https://github.com/parallaxsecond/parsec/issues/527)
- Create E2E tests for SQLite KIM [\#516](https://github.com/parallaxsecond/parsec/issues/516)
- Switch to dynamic key names in tests [\#453](https://github.com/parallaxsecond/parsec/issues/453)
- Add capabilities discovery operations [\#426](https://github.com/parallaxsecond/parsec/issues/426)

**Merged pull requests:**

- Update Changelog and service version no. [\#583](https://github.com/parallaxsecond/parsec/pull/583) ([ionut-arm](https://github.com/ionut-arm))
- Bump bindgen dependency version [\#582](https://github.com/parallaxsecond/parsec/pull/582) ([ionut-arm](https://github.com/ionut-arm))
- Bump SQLite dependency [\#581](https://github.com/parallaxsecond/parsec/pull/581) ([ionut-arm](https://github.com/ionut-arm))
- \[CryptoAuthLib provider\] PsaRawKeyAgreement operation implementation [\#578](https://github.com/parallaxsecond/parsec/pull/578) ([akazimierskigl](https://github.com/akazimierskigl))
- Implement can-do-crypto for TS and mbed-crypto providers [\#565](https://github.com/parallaxsecond/parsec/pull/565) ([anta5010](https://github.com/anta5010))
- Add error message if submodule not initialised [\#564](https://github.com/parallaxsecond/parsec/pull/564) ([ionut-arm](https://github.com/ionut-arm))
- \[CryptoAuthLib provider\] PsaCipherEncrypt and PsaCipherDecrypt implementation [\#563](https://github.com/parallaxsecond/parsec/pull/563) ([akazimierskigl](https://github.com/akazimierskigl))
- Add clippy and fmt checkt to e2e\_tests [\#561](https://github.com/parallaxsecond/parsec/pull/561) ([ionut-arm](https://github.com/ionut-arm))
- Re-factor e2e tests to use common key attributes functions [\#556](https://github.com/parallaxsecond/parsec/pull/556) ([anta5010](https://github.com/anta5010))
- Merge can-do-crypto branch into main [\#555](https://github.com/parallaxsecond/parsec/pull/555) ([anta5010](https://github.com/anta5010))
- Merge main branch changes into can-do crypto [\#554](https://github.com/parallaxsecond/parsec/pull/554) ([anta5010](https://github.com/anta5010))
- Jn9e9/issue453 [\#552](https://github.com/parallaxsecond/parsec/pull/552) ([jn9e9](https://github.com/jn9e9))
- e2e CanDoCrypto tests for Hashes, ECC curves and Crypto algorithms [\#551](https://github.com/parallaxsecond/parsec/pull/551) ([anta5010](https://github.com/anta5010))
- Implement CanDoCrypto trait and use it for PKCS11 and TPM providers [\#550](https://github.com/parallaxsecond/parsec/pull/550) ([anta5010](https://github.com/anta5010))
- Use ec\_params for can-do-crypto checks instead of hard-coded values [\#549](https://github.com/parallaxsecond/parsec/pull/549) ([anta5010](https://github.com/anta5010))
- Small refactor of PKCS11 CryptoCanDo [\#548](https://github.com/parallaxsecond/parsec/pull/548) ([anta5010](https://github.com/anta5010))
- Merge origin/main into can-do-crypto  [\#547](https://github.com/parallaxsecond/parsec/pull/547) ([anta5010](https://github.com/anta5010))
- Increase the MSRV to 1.53.0 [\#535](https://github.com/parallaxsecond/parsec/pull/535) ([hug-dev](https://github.com/hug-dev))
- Update the CHANGELOG file with 0.8.1 [\#533](https://github.com/parallaxsecond/parsec/pull/533) ([hug-dev](https://github.com/hug-dev))
- Added the CanDoCrypto operation as well as fixing some of the other test scripts. [\#522](https://github.com/parallaxsecond/parsec/pull/522) ([Kakemone](https://github.com/Kakemone))

## [0.8.1](https://github.com/parallaxsecond/parsec/tree/0.8.1) (2021-09-17)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/0.8.0...0.8.1)

**Implemented enhancements:**

- Add Unit Tests to SQLiteKeyInfoManager [\#510](https://github.com/parallaxsecond/parsec/issues/510)
-  Change KeyTriple to Include Auth ID, Provider Name & Provider UUID [\#488](https://github.com/parallaxsecond/parsec/issues/488)
- Update provider to use new version fo TransKeyCtx [\#515](https://github.com/parallaxsecond/parsec/pull/515) ([ionut-arm](https://github.com/ionut-arm))

**Fixed bugs:**

- Decide and implement a new serialization format for KeyInfo [\#509](https://github.com/parallaxsecond/parsec/issues/509)
- Memory leak in TS context [\#501](https://github.com/parallaxsecond/parsec/issues/501)
- Disable broken workflows [\#525](https://github.com/parallaxsecond/parsec/pull/525) ([ionut-arm](https://github.com/ionut-arm))

**Closed issues:**

- Make a Parsec Ockam Vault: investigation issue [\#506](https://github.com/parallaxsecond/parsec/issues/506)
- Add Basic SQLiteKeyInfoManager Storage/Retrieval Functionality [\#503](https://github.com/parallaxsecond/parsec/issues/503)
- Add config tests for multiple provider names [\#496](https://github.com/parallaxsecond/parsec/issues/496)

**Merged pull requests:**

- Bump version for release [\#526](https://github.com/parallaxsecond/parsec/pull/526) ([ionut-arm](https://github.com/ionut-arm))
- Use as\_ptr for TS service name [\#524](https://github.com/parallaxsecond/parsec/pull/524) ([anta5010](https://github.com/anta5010))
- Lower Hash algorithm [\#499](https://github.com/parallaxsecond/parsec/pull/499) ([hug-dev](https://github.com/hug-dev))
- Update CHANGELOG [\#498](https://github.com/parallaxsecond/parsec/pull/498) ([hug-dev](https://github.com/hug-dev))

## [0.8.0](https://github.com/parallaxsecond/parsec/tree/0.8.0) (2021-08-05)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/0.7.2...0.8.0)

**Implemented enhancements:**

- Add Provider Name Config Option [\#487](https://github.com/parallaxsecond/parsec/issues/487)
- Add PKCS11 provider export-attributes switch [\#462](https://github.com/parallaxsecond/parsec/issues/462)
- Refactor the all-providers workflow [\#455](https://github.com/parallaxsecond/parsec/issues/455)
- Adjust linking for TS provider [\#427](https://github.com/parallaxsecond/parsec/issues/427)
- Allow providers to be optional or conditional depending on platform feature availability [\#401](https://github.com/parallaxsecond/parsec/issues/401)
- Add cross-compilation tests for the TPM provider [\#382](https://github.com/parallaxsecond/parsec/issues/382)
- Make the slot\_number field optional [\#375](https://github.com/parallaxsecond/parsec/issues/375)
- Design workflow and associated APIs for key attestation in Parsec [\#370](https://github.com/parallaxsecond/parsec/issues/370)
- Implement error handling for TS caller errors [\#332](https://github.com/parallaxsecond/parsec/issues/332)
- Add release-build tests to CI [\#163](https://github.com/parallaxsecond/parsec/issues/163)
- Add the possibility of changing key store location of Mbed Crypto provider [\#53](https://github.com/parallaxsecond/parsec/issues/53)
- Add TS provider to all-providers [\#482](https://github.com/parallaxsecond/parsec/pull/482) ([ionut-arm](https://github.com/ionut-arm))
- Adjust TS provider linking [\#474](https://github.com/parallaxsecond/parsec/pull/474) ([ionut-arm](https://github.com/ionut-arm))
- Add cargo-audit config [\#473](https://github.com/parallaxsecond/parsec/pull/473) ([ionut-arm](https://github.com/ionut-arm))
- Update dependency on Trusted Services [\#467](https://github.com/parallaxsecond/parsec/pull/467) ([ionut-arm](https://github.com/ionut-arm))
- Add import and export support for ECC for PKCS11 [\#452](https://github.com/parallaxsecond/parsec/pull/452) ([ionut-arm](https://github.com/ionut-arm))
- Add a SPIFFE based authenticator [\#449](https://github.com/parallaxsecond/parsec/pull/449) ([hug-dev](https://github.com/hug-dev))
- Add ECC functionality to PKCS11 prov [\#446](https://github.com/parallaxsecond/parsec/pull/446) ([ionut-arm](https://github.com/ionut-arm))
- Enable coverage testing for TS provider [\#434](https://github.com/parallaxsecond/parsec/pull/434) ([ionut-arm](https://github.com/ionut-arm))
- Create SECURITY.md [\#414](https://github.com/parallaxsecond/parsec/pull/414) ([ionut-arm](https://github.com/ionut-arm))
- Add TPM provider cross-compilation [\#403](https://github.com/parallaxsecond/parsec/pull/403) ([ionut-arm](https://github.com/ionut-arm))
- Added Option\<Slot\> to PKCS 11 Provider constructor [\#402](https://github.com/parallaxsecond/parsec/pull/402) ([Sven-bg](https://github.com/Sven-bg))

**Fixed bugs:**

- If a response is an error, log it before sending it [\#417](https://github.com/parallaxsecond/parsec/issues/417)
- Fix ingress/egress trace logs [\#416](https://github.com/parallaxsecond/parsec/issues/416)
- Make `KeyInfo` a private type [\#400](https://github.com/parallaxsecond/parsec/issues/400)
- Unable to build 0.7.2 for i686 \(and ppc64/ppc64le\) [\#379](https://github.com/parallaxsecond/parsec/issues/379)
- Unable to build 0.7.2 for armv7 [\#378](https://github.com/parallaxsecond/parsec/issues/378)
- Document clearly how Mbed Crypto provider keys are stored [\#373](https://github.com/parallaxsecond/parsec/issues/373)
- Fix code coverage reports [\#495](https://github.com/parallaxsecond/parsec/pull/495) ([ionut-arm](https://github.com/ionut-arm))
- Modify the git submodule command [\#490](https://github.com/parallaxsecond/parsec/pull/490) ([hug-dev](https://github.com/hug-dev))
- Do not login if no user pin was entered [\#489](https://github.com/parallaxsecond/parsec/pull/489) ([hug-dev](https://github.com/hug-dev))
- Fix git command and use Arm machine [\#485](https://github.com/parallaxsecond/parsec/pull/485) ([ionut-arm](https://github.com/ionut-arm))
- Fix CircleCI config format. [\#484](https://github.com/parallaxsecond/parsec/pull/484) ([ionut-arm](https://github.com/ionut-arm))
- Add submodule initialisation to CircleCI [\#483](https://github.com/parallaxsecond/parsec/pull/483) ([ionut-arm](https://github.com/ionut-arm))
- Make cross-compilation run on release version [\#454](https://github.com/parallaxsecond/parsec/pull/454) ([ionut-arm](https://github.com/ionut-arm))
- Bump picky crate versions [\#443](https://github.com/parallaxsecond/parsec/pull/443) ([ionut-arm](https://github.com/ionut-arm))
- Remove the TS coverage computation [\#436](https://github.com/parallaxsecond/parsec/pull/436) ([ionut-arm](https://github.com/ionut-arm))
- Fix nightly workflow [\#435](https://github.com/parallaxsecond/parsec/pull/435) ([ionut-arm](https://github.com/ionut-arm))
- Fix ServiceConfig import in fuzz\_service [\#433](https://github.com/parallaxsecond/parsec/pull/433) ([ionut-arm](https://github.com/ionut-arm))
- Fix Contributing link [\#415](https://github.com/parallaxsecond/parsec/pull/415) ([ionut-arm](https://github.com/ionut-arm))
- Fix ownership of ibmtpm folder [\#385](https://github.com/parallaxsecond/parsec/pull/385) ([ionut-arm](https://github.com/ionut-arm))
- Fix CircleCI config [\#384](https://github.com/parallaxsecond/parsec/pull/384) ([ionut-arm](https://github.com/ionut-arm))
- Implement a few fixes [\#374](https://github.com/parallaxsecond/parsec/pull/374) ([ionut-arm](https://github.com/ionut-arm))

**Security fixes:**

- Resurrect fuzz testing framework [\#422](https://github.com/parallaxsecond/parsec/issues/422)
- Set up Github security policy [\#398](https://github.com/parallaxsecond/parsec/issues/398)
- Investigate testing of Cryptoauthlib provider [\#315](https://github.com/parallaxsecond/parsec/issues/315)
- rust-spiffe: make sure that the claims returned by the validation operation are as expected [\#290](https://github.com/parallaxsecond/parsec/issues/290)
- rust-spiffe: provide a local validation of the JWT-SVID [\#289](https://github.com/parallaxsecond/parsec/issues/289)
- Revive the fuzz testing framework [\#429](https://github.com/parallaxsecond/parsec/pull/429) ([ionut-arm](https://github.com/ionut-arm))

**Closed issues:**

- NXP PKCS\#11 Parsec integration testing. [\#456](https://github.com/parallaxsecond/parsec/issues/456)
- Split the build tests on a different CI workflow [\#447](https://github.com/parallaxsecond/parsec/issues/447)
- Support ECC signing keys in the PKCS\#11 provider [\#421](https://github.com/parallaxsecond/parsec/issues/421)
- Stability: Communication with backends [\#412](https://github.com/parallaxsecond/parsec/issues/412)
- Adopt CII Best Practices Badge from the LF [\#411](https://github.com/parallaxsecond/parsec/issues/411)
- Unable to build parsec 0.7.2 with rust 1.43.1. Parsec 0.6.0 builds fine. [\#409](https://github.com/parallaxsecond/parsec/issues/409)
- Stability: Build toolchain [\#408](https://github.com/parallaxsecond/parsec/issues/408)
- Stability: Environment variables [\#405](https://github.com/parallaxsecond/parsec/issues/405)
- Stability: Dynamic libraries dependencies [\#397](https://github.com/parallaxsecond/parsec/issues/397)
- Stability: systemd communication [\#396](https://github.com/parallaxsecond/parsec/issues/396)
- Stability: OS signals [\#395](https://github.com/parallaxsecond/parsec/issues/395)
- Stability: Persistent state \(key mappings\) [\#394](https://github.com/parallaxsecond/parsec/issues/394)
- Stability: Configuration file [\#393](https://github.com/parallaxsecond/parsec/issues/393)
- Stability: CLI invocation [\#392](https://github.com/parallaxsecond/parsec/issues/392)
- Stability: Authenticators [\#391](https://github.com/parallaxsecond/parsec/issues/391)
- Stability: Communication with clients \(listeners endpoint\) [\#390](https://github.com/parallaxsecond/parsec/issues/390)
- Stability: Communication with clients \(operation contracts\) [\#389](https://github.com/parallaxsecond/parsec/issues/389)
- Stability: Communication with clients \(requests/responses\) [\#388](https://github.com/parallaxsecond/parsec/issues/388)
- Setup environment stability test [\#386](https://github.com/parallaxsecond/parsec/issues/386)
- Archive for 0.7.0 contains .cargo/ folder [\#377](https://github.com/parallaxsecond/parsec/issues/377)
- Add more Fixed Common header tests [\#351](https://github.com/parallaxsecond/parsec/issues/351)

**Merged pull requests:**

- Switch imports to crates.io [\#497](https://github.com/parallaxsecond/parsec/pull/497) ([ionut-arm](https://github.com/ionut-arm))
- Add the Class attribute when generating key pairs [\#493](https://github.com/parallaxsecond/parsec/pull/493) ([hug-dev](https://github.com/hug-dev))
- Add tests checking absence of slot\_number [\#492](https://github.com/parallaxsecond/parsec/pull/492) ([hug-dev](https://github.com/hug-dev))
- Split out the all-providers cargo check into its own CI job. [\#472](https://github.com/parallaxsecond/parsec/pull/472) ([MattDavis00](https://github.com/MattDavis00))
- Make KeyInfo a private type Fix \#400 [\#469](https://github.com/parallaxsecond/parsec/pull/469) ([Kakemone](https://github.com/Kakemone))
- Added psa\_export\_key & psa\_generate\_random to TS Provider [\#468](https://github.com/parallaxsecond/parsec/pull/468) ([MattDavis00](https://github.com/MattDavis00))
- Add a allow\_export flag to restrict exporting [\#466](https://github.com/parallaxsecond/parsec/pull/466) ([hug-dev](https://github.com/hug-dev))
- Added missing ingress logs to providers. \#416 [\#465](https://github.com/parallaxsecond/parsec/pull/465) ([MattDavis00](https://github.com/MattDavis00))
- \#417 Added additional error logging to front end handle\_request function. [\#464](https://github.com/parallaxsecond/parsec/pull/464) ([MattDavis00](https://github.com/MattDavis00))
- Update the TS revision used [\#461](https://github.com/parallaxsecond/parsec/pull/461) ([ionut-arm](https://github.com/ionut-arm))
- Add a way to allow providers to fail instantiation [\#451](https://github.com/parallaxsecond/parsec/pull/451) ([hug-dev](https://github.com/hug-dev))
- Randomly select the shutdown signal [\#448](https://github.com/parallaxsecond/parsec/pull/448) ([hug-dev](https://github.com/hug-dev))
- Execute e2e tests with an old version of client [\#445](https://github.com/parallaxsecond/parsec/pull/445) ([hug-dev](https://github.com/hug-dev))
- \[CryptoAuthLib provider\] Implementation of export key operation [\#442](https://github.com/parallaxsecond/parsec/pull/442) ([TomaszPawelecGL](https://github.com/TomaszPawelecGL))
- Move CLI log into its own file [\#441](https://github.com/parallaxsecond/parsec/pull/441) ([hug-dev](https://github.com/hug-dev))
- Add various tests checking contracts [\#440](https://github.com/parallaxsecond/parsec/pull/440) ([hug-dev](https://github.com/hug-dev))
- Isolate config logic and add e2e config tests [\#432](https://github.com/parallaxsecond/parsec/pull/432) ([hug-dev](https://github.com/hug-dev))
- \[CryptoAuthLib provider\] Implementation of psa\_export\_public\_key operation. [\#431](https://github.com/parallaxsecond/parsec/pull/431) ([RobertDrazkowskiGL](https://github.com/RobertDrazkowskiGL))
- \[CryptoAuthLib provider\] Support for psa\_sign\_message and psa\_verify\_message. [\#425](https://github.com/parallaxsecond/parsec/pull/425) ([RobertDrazkowskiGL](https://github.com/RobertDrazkowskiGL))
- Replace persistence tests with key mappings tests [\#420](https://github.com/parallaxsecond/parsec/pull/420) ([hug-dev](https://github.com/hug-dev))
- Add Codecov and cii badges [\#419](https://github.com/parallaxsecond/parsec/pull/419) ([ionut-arm](https://github.com/ionut-arm))
- CryptoAuthentication Library provider - support for PsaSignHash and PsaVerifyHash operations. [\#413](https://github.com/parallaxsecond/parsec/pull/413) ([RobertDrazkowskiGL](https://github.com/RobertDrazkowskiGL))
- Make it compile for Rust 1.43.1 [\#410](https://github.com/parallaxsecond/parsec/pull/410) ([hug-dev](https://github.com/hug-dev))
- PSA\_IMPORT\_KEY introduction. [\#399](https://github.com/parallaxsecond/parsec/pull/399) ([RobertDrazkowskiGL](https://github.com/RobertDrazkowskiGL))
- CryptoAuthLib provider testability improvements: [\#387](https://github.com/parallaxsecond/parsec/pull/387) ([RobertDrazkowskiGL](https://github.com/RobertDrazkowskiGL))
- Add CircleCI config [\#383](https://github.com/parallaxsecond/parsec/pull/383) ([ionut-arm](https://github.com/ionut-arm))
- Import newest versions of cryptoki and tss-esapi [\#381](https://github.com/parallaxsecond/parsec/pull/381) ([hug-dev](https://github.com/hug-dev))
- Update CHANGELOG [\#367](https://github.com/parallaxsecond/parsec/pull/367) ([hug-dev](https://github.com/hug-dev))
- Implementation of PsaGenerateKey and PsaDestroyKey operations [\#354](https://github.com/parallaxsecond/parsec/pull/354) ([RobertDrazkowskiGL](https://github.com/RobertDrazkowskiGL))

## [0.7.2](https://github.com/parallaxsecond/parsec/tree/0.7.2) (2021-03-25)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/0.7.1...0.7.2)

**Merged pull requests:**

- Prepare for 0.7.2 [\#368](https://github.com/parallaxsecond/parsec/pull/368) ([hug-dev](https://github.com/hug-dev))

## [0.7.1](https://github.com/parallaxsecond/parsec/tree/0.7.1) (2021-03-25)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/0.7.0...0.7.1)

**Closed issues:**

- Investigate calculating test coverage [\#342](https://github.com/parallaxsecond/parsec/issues/342)

**Merged pull requests:**

- Update tss-esapi dependency [\#366](https://github.com/parallaxsecond/parsec/pull/366) ([hug-dev](https://github.com/hug-dev))
- Add quickstart reference [\#365](https://github.com/parallaxsecond/parsec/pull/365) ([hug-dev](https://github.com/hug-dev))
- Update CHANGELOG [\#364](https://github.com/parallaxsecond/parsec/pull/364) ([hug-dev](https://github.com/hug-dev))

## [0.7.0](https://github.com/parallaxsecond/parsec/tree/0.7.0) (2021-03-23)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/0.6.0...0.7.0)

**Implemented enhancements:**

- Stop the duplication of key ID conversions [\#331](https://github.com/parallaxsecond/parsec/issues/331)
- Add key management operations support [\#267](https://github.com/parallaxsecond/parsec/issues/267)
- Enable TS context initialization  [\#266](https://github.com/parallaxsecond/parsec/issues/266)
- Create the Trusted Service bindings [\#265](https://github.com/parallaxsecond/parsec/issues/265)
- Improve import key support in TPM provider [\#251](https://github.com/parallaxsecond/parsec/issues/251)
- Investigate and define the work required for SPIFFE-based client identity management [\#232](https://github.com/parallaxsecond/parsec/issues/232)
- Make existence of key info consistent with existence of key [\#149](https://github.com/parallaxsecond/parsec/issues/149)
- Extract Docker images into own repo [\#124](https://github.com/parallaxsecond/parsec/issues/124)
- Add version structures for better handling of versions [\#43](https://github.com/parallaxsecond/parsec/issues/43)
- Rearrange modules for a more structured feel [\#32](https://github.com/parallaxsecond/parsec/issues/32)
- Change CI to use published Docker image [\#357](https://github.com/parallaxsecond/parsec/pull/357) ([ionut-arm](https://github.com/ionut-arm))
- Improve coverage script [\#348](https://github.com/parallaxsecond/parsec/pull/348) ([ionut-arm](https://github.com/ionut-arm))
- Add coverage checking in nightly run [\#347](https://github.com/parallaxsecond/parsec/pull/347) ([ionut-arm](https://github.com/ionut-arm))
- Trusted service provider [\#330](https://github.com/parallaxsecond/parsec/pull/330) ([ionut-arm](https://github.com/ionut-arm))
- Add admin configuration [\#316](https://github.com/parallaxsecond/parsec/pull/316) ([ionut-arm](https://github.com/ionut-arm))
- Add new parsec provider using ATECCx08 cryptochip via CryptoAuthentication Library [\#303](https://github.com/parallaxsecond/parsec/pull/303) ([RobertDrazkowskiGL](https://github.com/RobertDrazkowskiGL))
- Improve error handling in builder [\#298](https://github.com/parallaxsecond/parsec/pull/298) ([ionut-arm](https://github.com/ionut-arm))
- Add Changelog file \(\#278\)  [\#280](https://github.com/parallaxsecond/parsec/pull/280) ([ionut-arm](https://github.com/ionut-arm))
- Remove PKCS11 single thread lock \(\#264\) [\#277](https://github.com/parallaxsecond/parsec/pull/277) ([ionut-arm](https://github.com/ionut-arm))

**Fixed bugs:**

- Move the spiffe related features in its own branch [\#327](https://github.com/parallaxsecond/parsec/issues/327)
- Resolve default implementation issue for `list_keys` in `Provide` [\#312](https://github.com/parallaxsecond/parsec/issues/312)
- ListKeys should only be callable on the Core provider [\#310](https://github.com/parallaxsecond/parsec/issues/310)
- Service should not start if some components weren't built successfully [\#297](https://github.com/parallaxsecond/parsec/issues/297)
- No changelog for the releases [\#278](https://github.com/parallaxsecond/parsec/issues/278)
- PKCS11 multi-threading [\#264](https://github.com/parallaxsecond/parsec/issues/264)
- Fix ImportKey to allow importing private key [\#126](https://github.com/parallaxsecond/parsec/issues/126)
- PKCS 11 provider stress tests sometimes fail [\#116](https://github.com/parallaxsecond/parsec/issues/116)
- Update docker registry for TPM2 images [\#356](https://github.com/parallaxsecond/parsec/pull/356) ([ionut-arm](https://github.com/ionut-arm))
- Run the Codecov script outside container [\#353](https://github.com/parallaxsecond/parsec/pull/353) ([ionut-arm](https://github.com/ionut-arm))
- Fix code coverage docker command [\#352](https://github.com/parallaxsecond/parsec/pull/352) ([ionut-arm](https://github.com/ionut-arm))
- Remove the spiffe-based authenticator [\#328](https://github.com/parallaxsecond/parsec/pull/328) ([hug-dev](https://github.com/hug-dev))

**Security fixes:**

- Add a test for admin operations [\#309](https://github.com/parallaxsecond/parsec/issues/309)
- Implement admin logic [\#308](https://github.com/parallaxsecond/parsec/issues/308)
- Investigate admin role and admin-level operations [\#292](https://github.com/parallaxsecond/parsec/issues/292)
- Add failure-counter mechanism [\#176](https://github.com/parallaxsecond/parsec/issues/176)

**Closed issues:**

- Implement ListClients and DeleteClient in the core provider [\#311](https://github.com/parallaxsecond/parsec/issues/311)
- Correct lint issues found after the toolchain upgrade to version 1.49.0 [\#305](https://github.com/parallaxsecond/parsec/issues/305)
- Investigate cross-compilation to Linux on Aarch64 [\#300](https://github.com/parallaxsecond/parsec/issues/300)
- Investigate adding ListClients and DeleteClient operations [\#293](https://github.com/parallaxsecond/parsec/issues/293)
- Consume the new, safer Rust PKCS\#11 interface into Parsec when it is available [\#272](https://github.com/parallaxsecond/parsec/issues/272)
- Add a SPIFFE JWT-SVID multitenancy test [\#269](https://github.com/parallaxsecond/parsec/issues/269)
- Add a JWT-SVID Authenticator [\#268](https://github.com/parallaxsecond/parsec/issues/268)
- Investigate and define the work required for compatibility with Arm Firmware Framework for Armv8-A \(FF-A\) [\#247](https://github.com/parallaxsecond/parsec/issues/247)

**Merged pull requests:**

- Prepare for 0.7.0 release [\#363](https://github.com/parallaxsecond/parsec/pull/363) ([hug-dev](https://github.com/hug-dev))
- Update to latest TSS crate version [\#362](https://github.com/parallaxsecond/parsec/pull/362) ([ionut-arm](https://github.com/ionut-arm))
- Enable code coverage for PKCS11, disable for TS [\#361](https://github.com/parallaxsecond/parsec/pull/361) ([ionut-arm](https://github.com/ionut-arm))
- Add Edmund to Contributors list [\#359](https://github.com/parallaxsecond/parsec/pull/359) ([ionut-arm](https://github.com/ionut-arm))
- Add myself to contributors, re. rust-cryptoki [\#358](https://github.com/parallaxsecond/parsec/pull/358) ([nickray](https://github.com/nickray))
- Add some cross-compilation tests [\#355](https://github.com/parallaxsecond/parsec/pull/355) ([hug-dev](https://github.com/hug-dev))
- Upgrade all dependencies to their latest version [\#345](https://github.com/parallaxsecond/parsec/pull/345) ([hug-dev](https://github.com/hug-dev))
- Create KeyInfoManagerClient [\#343](https://github.com/parallaxsecond/parsec/pull/343) ([ionut-arm](https://github.com/ionut-arm))
- Parsec PsaHashCompare operation implementation for CryptoAuthLib provider [\#333](https://github.com/parallaxsecond/parsec/pull/333) ([akazimierskigl](https://github.com/akazimierskigl))
- Parsec PsaGenerateRandom operation implementation for CryptoAuthLib provider [\#325](https://github.com/parallaxsecond/parsec/pull/325) ([RobertDrazkowskiGL](https://github.com/RobertDrazkowskiGL))
- Add consistency in key creation/deletion [\#324](https://github.com/parallaxsecond/parsec/pull/324) ([hug-dev](https://github.com/hug-dev))
- Make the authenticators their own features [\#322](https://github.com/parallaxsecond/parsec/pull/322) ([puiterwijk](https://github.com/puiterwijk))
- Improve mandatory Provide methods [\#321](https://github.com/parallaxsecond/parsec/pull/321) ([ionut-arm](https://github.com/ionut-arm))
- Use newest TSS crate [\#320](https://github.com/parallaxsecond/parsec/pull/320) ([ionut-arm](https://github.com/ionut-arm))
- Add ListClients and DeleteClient operations [\#318](https://github.com/parallaxsecond/parsec/pull/318) ([hug-dev](https://github.com/hug-dev))
- Added support for PsaHashCompute to CryptoAuthLib provider. [\#317](https://github.com/parallaxsecond/parsec/pull/317) ([RobertDrazkowskiGL](https://github.com/RobertDrazkowskiGL))
- Update service dependencies [\#314](https://github.com/parallaxsecond/parsec/pull/314) ([ionut-arm](https://github.com/ionut-arm))
- Add a test checking ListKeys provider target [\#313](https://github.com/parallaxsecond/parsec/pull/313) ([hug-dev](https://github.com/hug-dev))
- Fix lint warning [\#306](https://github.com/parallaxsecond/parsec/pull/306) ([ionut-arm](https://github.com/ionut-arm))
- Return correct key provider id in list\_keys [\#302](https://github.com/parallaxsecond/parsec/pull/302) ([jn9e9](https://github.com/jn9e9))
- Use the new abstraction on the PKCS11 interface [\#301](https://github.com/parallaxsecond/parsec/pull/301) ([hug-dev](https://github.com/hug-dev))
- Switch Travis CI build to cron-only [\#299](https://github.com/parallaxsecond/parsec/pull/299) ([ionut-arm](https://github.com/ionut-arm))
- Add a JWT-SVID authenticator [\#283](https://github.com/parallaxsecond/parsec/pull/283) ([hug-dev](https://github.com/hug-dev))
- Add Patrick to the contributor list [\#281](https://github.com/parallaxsecond/parsec/pull/281) ([puiterwijk](https://github.com/puiterwijk))

## [0.6.0](https://github.com/parallaxsecond/parsec/tree/0.6.0) (2020-10-20)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/0.5.0...0.6.0)

**Implemented enhancements:**

- Add multitenancy testing infrastructure 👩‍🔧 [\#245](https://github.com/parallaxsecond/parsec/issues/245)
- Delete "Provider" suffix out of provider names [\#134](https://github.com/parallaxsecond/parsec/issues/134)
- Improve error message on service startup [\#260](https://github.com/parallaxsecond/parsec/pull/260) ([ionut-arm](https://github.com/ionut-arm))

**Fixed bugs:**

- Limit key imports in TPM provider [\#255](https://github.com/parallaxsecond/parsec/pull/255) ([ionut-arm](https://github.com/ionut-arm))

**Closed issues:**

- Add authenticator configuration [\#270](https://github.com/parallaxsecond/parsec/issues/270)
- Assemble a PR checklist for code reviewers [\#258](https://github.com/parallaxsecond/parsec/issues/258)
- Adjust README disclaimer wording [\#231](https://github.com/parallaxsecond/parsec/issues/231)

**Merged pull requests:**

- Add multitenancy tests [\#276](https://github.com/parallaxsecond/parsec/pull/276) ([hug-dev](https://github.com/hug-dev))
- Put config tests in all\_providers [\#275](https://github.com/parallaxsecond/parsec/pull/275) ([hug-dev](https://github.com/hug-dev))
- Remove warnings about parsec and parsec-clients [\#274](https://github.com/parallaxsecond/parsec/pull/274) ([hug-dev](https://github.com/hug-dev))
- Add authentication configuration [\#273](https://github.com/parallaxsecond/parsec/pull/273) ([hug-dev](https://github.com/hug-dev))
- Refactored provider names [\#263](https://github.com/parallaxsecond/parsec/pull/263) ([Swell61](https://github.com/Swell61))
- Add list keys [\#261](https://github.com/parallaxsecond/parsec/pull/261) ([joechrisellis](https://github.com/joechrisellis))

## [0.5.0](https://github.com/parallaxsecond/parsec/tree/0.5.0) (2020-10-02)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/0.4.0...0.5.0)

**Implemented enhancements:**

- Creating a build-time configuration file [\#256](https://github.com/parallaxsecond/parsec/issues/256)
- Merge integration tests in E2E test suite [\#228](https://github.com/parallaxsecond/parsec/issues/228)
- Support dbus-parsec with NXP secureobj library [\#223](https://github.com/parallaxsecond/parsec/issues/223)
- Verify which dependencies can/should be updated [\#158](https://github.com/parallaxsecond/parsec/issues/158)
- Add more test cases [\#151](https://github.com/parallaxsecond/parsec/issues/151)
- Test Parsec installation as a systemd daemon [\#49](https://github.com/parallaxsecond/parsec/issues/49)
- Improve E2E testing [\#253](https://github.com/parallaxsecond/parsec/pull/253) ([ionut-arm](https://github.com/ionut-arm))
- Upgrade and clean dependencies [\#246](https://github.com/parallaxsecond/parsec/pull/246) ([hug-dev](https://github.com/hug-dev))
- Import private key support for TPM provider [\#243](https://github.com/parallaxsecond/parsec/pull/243) ([joechrisellis](https://github.com/joechrisellis))
- Allow software operations in PKCS11 provider [\#241](https://github.com/parallaxsecond/parsec/pull/241) ([ionut-arm](https://github.com/ionut-arm))
- Improve key metadata handling [\#240](https://github.com/parallaxsecond/parsec/pull/240) ([ionut-arm](https://github.com/ionut-arm))
- Add support for `psa_generate_random` operation for MbedCrypto provider [\#208](https://github.com/parallaxsecond/parsec/pull/208) ([joechrisellis](https://github.com/joechrisellis))

**Fixed bugs:**

- Memory cleanup of sensitive data [\#122](https://github.com/parallaxsecond/parsec/issues/122)
- Fix attribute conversion in PKCS11 provider [\#254](https://github.com/parallaxsecond/parsec/pull/254) ([ionut-arm](https://github.com/ionut-arm))
- Fix sign attribute in PKCS11 [\#252](https://github.com/parallaxsecond/parsec/pull/252) ([ionut-arm](https://github.com/ionut-arm))
- Add Uuid from the interface directly [\#242](https://github.com/parallaxsecond/parsec/pull/242) ([hug-dev](https://github.com/hug-dev))
- Add `buffer_size_limit` config option for providers [\#233](https://github.com/parallaxsecond/parsec/pull/233) ([joechrisellis](https://github.com/joechrisellis))

**Security fixes:**

- Add memory zeroizing when needed [\#239](https://github.com/parallaxsecond/parsec/pull/239) ([hug-dev](https://github.com/hug-dev))

**Closed issues:**

- Implement ListAuthenticators [\#216](https://github.com/parallaxsecond/parsec/issues/216)
- Better error message when file not found [\#210](https://github.com/parallaxsecond/parsec/issues/210)
- Implement an authenticator based on the domain socket peer credential [\#200](https://github.com/parallaxsecond/parsec/issues/200)

**Merged pull requests:**

- Add Unix peer credentials authenticator [\#214](https://github.com/parallaxsecond/parsec/pull/214) ([joechrisellis](https://github.com/joechrisellis))

## [0.4.0](https://github.com/parallaxsecond/parsec/tree/0.4.0) (2020-09-01)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/0.3.0...0.4.0)

**Implemented enhancements:**

- Implement asymmetric encrypt/decrypt in the PKCS\#11 provider [\#224](https://github.com/parallaxsecond/parsec/issues/224)
- Implement asymmetric encrypting/decrypting for TPM provider [\#217](https://github.com/parallaxsecond/parsec/issues/217)
- Create a Parsec Command Line Interface Client [\#202](https://github.com/parallaxsecond/parsec/issues/202)
- Create a mechanism for the listener to pass system-level data to the authenticator [\#199](https://github.com/parallaxsecond/parsec/issues/199)
- Auto create `/tmp/parsec` with correct permissions on startup [\#195](https://github.com/parallaxsecond/parsec/issues/195)
- Update attribute handling in PKCS11 provider [\#227](https://github.com/parallaxsecond/parsec/pull/227) ([ionut-arm](https://github.com/ionut-arm))
- Add asymmetric encryption support to TPM provider [\#225](https://github.com/parallaxsecond/parsec/pull/225) ([ionut-arm](https://github.com/ionut-arm))
- Improve error message when config file is not found [\#211](https://github.com/parallaxsecond/parsec/pull/211) ([ionut-arm](https://github.com/ionut-arm))

**Fixed bugs:**

- Update Adam Parco email address in maintainers files [\#230](https://github.com/parallaxsecond/parsec/issues/230)
- Update email address [\#235](https://github.com/parallaxsecond/parsec/pull/235) ([hug-dev](https://github.com/hug-dev))
- Bugfix: fix off-by-one error \(default body length limit\) [\#234](https://github.com/parallaxsecond/parsec/pull/234) ([joechrisellis](https://github.com/joechrisellis))
- Fix clippy errors [\#206](https://github.com/parallaxsecond/parsec/pull/206) ([ionut-arm](https://github.com/ionut-arm))

**Closed issues:**

- Add an option to pass a path to a build-config file  [\#174](https://github.com/parallaxsecond/parsec/issues/174)

**Merged pull requests:**

- Add missing\_docs lint and missing docs [\#236](https://github.com/parallaxsecond/parsec/pull/236) ([hug-dev](https://github.com/hug-dev))
- Added aead encrypt decrypt, hash compute compare and raw key agreement [\#229](https://github.com/parallaxsecond/parsec/pull/229) ([sbailey-arm](https://github.com/sbailey-arm))
- Fix test and enable Travis [\#221](https://github.com/parallaxsecond/parsec/pull/221) ([ionut-arm](https://github.com/ionut-arm))
- Add implementation for ListAuthenticators operation [\#220](https://github.com/parallaxsecond/parsec/pull/220) ([joechrisellis](https://github.com/joechrisellis))
- Add check to prevent the Parsec service from running as root [\#219](https://github.com/parallaxsecond/parsec/pull/219) ([joechrisellis](https://github.com/joechrisellis))
- CoreProvider can query the other providers [\#215](https://github.com/parallaxsecond/parsec/pull/215) ([ionut-arm](https://github.com/ionut-arm))
- Rebase on new tss\_esapi [\#213](https://github.com/parallaxsecond/parsec/pull/213) ([puiterwijk](https://github.com/puiterwijk))
- Add Asymmetric Encrypt/Decrypt to mbed supported opcodes [\#212](https://github.com/parallaxsecond/parsec/pull/212) ([puiterwijk](https://github.com/puiterwijk))
- Create `Connection` abstraction for client communication [\#207](https://github.com/parallaxsecond/parsec/pull/207) ([joechrisellis](https://github.com/joechrisellis))
- Added user and group checks. Auto create socket dir. [\#205](https://github.com/parallaxsecond/parsec/pull/205) ([sbailey-arm](https://github.com/sbailey-arm))

## [0.3.0](https://github.com/parallaxsecond/parsec/tree/0.3.0) (2020-07-16)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/0.2.0...0.3.0)

**Implemented enhancements:**

- Create a Mbed Crypto Secure Element driver calling Parsec Rust Client [\#128](https://github.com/parallaxsecond/parsec/issues/128)
- Threat model of Parsec [\#89](https://github.com/parallaxsecond/parsec/issues/89)
- Precise the providers' order importance [\#203](https://github.com/parallaxsecond/parsec/pull/203) ([hug-dev](https://github.com/hug-dev))
- Keep list\_providers order; add cfg tests [\#197](https://github.com/parallaxsecond/parsec/pull/197) ([ionut-arm](https://github.com/ionut-arm))

**Merged pull requests:**

- Added PsaExportKey [\#204](https://github.com/parallaxsecond/parsec/pull/204) ([sbailey-arm](https://github.com/sbailey-arm))
- Migrated uses of a locally declared RsaPublic key to new create picky-asn1-x509 [\#201](https://github.com/parallaxsecond/parsec/pull/201) ([sbailey-arm](https://github.com/sbailey-arm))
- Added asymmetric encrypt and decrypt to Mbed Crypto provider [\#196](https://github.com/parallaxsecond/parsec/pull/196) ([sbailey-arm](https://github.com/sbailey-arm))

## [0.2.0](https://github.com/parallaxsecond/parsec/tree/0.2.0) (2020-07-02)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/0.1.2...0.2.0)

**Implemented enhancements:**

- Further simplification of the Mbed Crypto provider [\#187](https://github.com/parallaxsecond/parsec/issues/187)
- Create config "service" [\#181](https://github.com/parallaxsecond/parsec/issues/181)
- Use psa-crypto crate in the Mbed Crypto Provider [\#177](https://github.com/parallaxsecond/parsec/issues/177)
- Have a real integration test example [\#161](https://github.com/parallaxsecond/parsec/issues/161)
- Separate provider code into modules [\#133](https://github.com/parallaxsecond/parsec/issues/133)
- Update with PSA Crypto 1.0.0 interface [\#129](https://github.com/parallaxsecond/parsec/issues/129)
- Create a Parsec Rust Client [\#127](https://github.com/parallaxsecond/parsec/issues/127)
- TPM provider should establish most-secure primitives for itself [\#121](https://github.com/parallaxsecond/parsec/issues/121)
- Improvements for tests/ci.sh [\#108](https://github.com/parallaxsecond/parsec/issues/108)
- Split out ProviderConfig [\#103](https://github.com/parallaxsecond/parsec/issues/103)
- Check clippy::pedantic lints [\#100](https://github.com/parallaxsecond/parsec/issues/100)
- Modify configuration to have provider-specific table [\#70](https://github.com/parallaxsecond/parsec/issues/70)
- Create a PSA Crypto Rust wrapper crate [\#62](https://github.com/parallaxsecond/parsec/issues/62)
- Add TCTI configuration functionality [\#194](https://github.com/parallaxsecond/parsec/pull/194) ([ionut-arm](https://github.com/ionut-arm))
- Updated Parsec to use latest parsec-interface \(0.17.0\) [\#193](https://github.com/parallaxsecond/parsec/pull/193) ([sbailey-arm](https://github.com/sbailey-arm))
- Modify socket path [\#192](https://github.com/parallaxsecond/parsec/pull/192) ([hug-dev](https://github.com/hug-dev))
- Changed local\_ids for Atomic counter and removed key\_slot\_semaphore. [\#191](https://github.com/parallaxsecond/parsec/pull/191) ([sbailey-arm](https://github.com/sbailey-arm))
- Removed duplicate macros for sign output size and export pub key size. [\#190](https://github.com/parallaxsecond/parsec/pull/190) ([sbailey-arm](https://github.com/sbailey-arm))
- Move Parsec over to psa-crypto  [\#186](https://github.com/parallaxsecond/parsec/pull/186) ([sbailey-arm](https://github.com/sbailey-arm))
- Add trace logging on Provide method calls [\#185](https://github.com/parallaxsecond/parsec/pull/185) ([hug-dev](https://github.com/hug-dev))
- Update fuzz target [\#184](https://github.com/parallaxsecond/parsec/pull/184) ([ionut-arm](https://github.com/ionut-arm))
- Improve log security [\#183](https://github.com/parallaxsecond/parsec/pull/183) ([ionut-arm](https://github.com/ionut-arm))
- Add GlobalConfig [\#182](https://github.com/parallaxsecond/parsec/pull/182) ([ionut-arm](https://github.com/ionut-arm))
- Add community repo link [\#180](https://github.com/parallaxsecond/parsec/pull/180) ([hug-dev](https://github.com/hug-dev))
- Use crates.io version of the interface [\#179](https://github.com/parallaxsecond/parsec/pull/179) ([hug-dev](https://github.com/hug-dev))
- Import the newest Parsec interface [\#178](https://github.com/parallaxsecond/parsec/pull/178) ([hug-dev](https://github.com/hug-dev))
- Improve handling of list\_opcodes [\#173](https://github.com/parallaxsecond/parsec/pull/173) ([ionut-arm](https://github.com/ionut-arm))
- Add default context cipher selection for TPM provider [\#172](https://github.com/parallaxsecond/parsec/pull/172) ([ionut-arm](https://github.com/ionut-arm))
- Add ECDSA support for TPM provider [\#171](https://github.com/parallaxsecond/parsec/pull/171) ([ionut-arm](https://github.com/ionut-arm))
- Improve TPM provider [\#168](https://github.com/parallaxsecond/parsec/pull/168) ([ionut-arm](https://github.com/ionut-arm))
- Improve digest handling in PKCS11 provider [\#167](https://github.com/parallaxsecond/parsec/pull/167) ([ionut-arm](https://github.com/ionut-arm))
- Split provider code into separate modules [\#165](https://github.com/parallaxsecond/parsec/pull/165) ([ionut-arm](https://github.com/ionut-arm))
- Add integration test [\#162](https://github.com/parallaxsecond/parsec/pull/162) ([ionut-arm](https://github.com/ionut-arm))
- Move end to end tests to own crate [\#160](https://github.com/parallaxsecond/parsec/pull/160) ([ionut-arm](https://github.com/ionut-arm))
- Move test client back in the Parsec repo [\#150](https://github.com/parallaxsecond/parsec/pull/150) ([ionut-arm](https://github.com/ionut-arm))
- Remove stress test on Travis CI for PKCS 11 [\#145](https://github.com/parallaxsecond/parsec/pull/145) ([hug-dev](https://github.com/hug-dev))
- Add tests checking if key attributes are respected [\#135](https://github.com/parallaxsecond/parsec/pull/135) ([hug-dev](https://github.com/hug-dev))
- Add Contributors file [\#132](https://github.com/parallaxsecond/parsec/pull/132) ([ionut-arm](https://github.com/ionut-arm))
- Update with the latest interface [\#131](https://github.com/parallaxsecond/parsec/pull/131) ([hug-dev](https://github.com/hug-dev))
- Improvments for tests/ci.sh [\#117](https://github.com/parallaxsecond/parsec/pull/117) ([anta5010](https://github.com/anta5010))

**Fixed bugs:**

- Integration tests should be isolated in their crate [\#155](https://github.com/parallaxsecond/parsec/issues/155)
- Key should be deleted from the KIM if generation/import fails [\#139](https://github.com/parallaxsecond/parsec/issues/139)
- Fixed PKCS\#11 provieder failing failed\_created\_key\_should\_be\_removed test [\#188](https://github.com/parallaxsecond/parsec/pull/188) ([sbailey-arm](https://github.com/sbailey-arm))
- Replace calendar iframe with URL [\#166](https://github.com/parallaxsecond/parsec/pull/166) ([ionut-arm](https://github.com/ionut-arm))
- Fix clippy errors [\#157](https://github.com/parallaxsecond/parsec/pull/157) ([ionut-arm](https://github.com/ionut-arm))
- Allow PKCS11 tests to fail on Travis [\#154](https://github.com/parallaxsecond/parsec/pull/154) ([ionut-arm](https://github.com/ionut-arm))

**Security fixes:**

- Implement mitigation 4 of TM [\#189](https://github.com/parallaxsecond/parsec/pull/189) ([hug-dev](https://github.com/hug-dev))

**Closed issues:**

- Allow TPM owner hierarchy auth to be non-string [\#120](https://github.com/parallaxsecond/parsec/issues/120)

**Merged pull requests:**

- Update partners file with web links and logos [\#159](https://github.com/parallaxsecond/parsec/pull/159) ([paulhowardarm](https://github.com/paulhowardarm))
- Update CONTRIBUTORS.md [\#143](https://github.com/parallaxsecond/parsec/pull/143) ([Superhepper](https://github.com/Superhepper))
- A few more README updates including fixes for broken doc links [\#141](https://github.com/parallaxsecond/parsec/pull/141) ([paulhowardarm](https://github.com/paulhowardarm))
- README enhancements, PARTNERS file and new visual style for the project [\#136](https://github.com/parallaxsecond/parsec/pull/136) ([paulhowardarm](https://github.com/paulhowardarm))

## [0.1.2](https://github.com/parallaxsecond/parsec/tree/0.1.2) (2020-02-27)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/0.1.1...0.1.2)

**Implemented enhancements:**

- Modify configuration to have provider-specific structs [\#114](https://github.com/parallaxsecond/parsec/pull/114) ([anta5010](https://github.com/anta5010))
- Improve code documentation [\#113](https://github.com/parallaxsecond/parsec/pull/113) ([ionut-arm](https://github.com/ionut-arm))

## [0.1.1](https://github.com/parallaxsecond/parsec/tree/0.1.1) (2020-02-21)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/0.1.0...0.1.1)

**Implemented enhancements:**

- Check for more Clippy lints [\#91](https://github.com/parallaxsecond/parsec/issues/91)
- Switch to picky-asn1-der for ASN.1-DER parsing [\#84](https://github.com/parallaxsecond/parsec/issues/84)
- Have all the providers dynamically loadable [\#79](https://github.com/parallaxsecond/parsec/issues/79)
- Pass config.toml path as command-line argument [\#78](https://github.com/parallaxsecond/parsec/issues/78)
- Convert Key ID Manager String errors to ResponseStatus in the KIM itself [\#77](https://github.com/parallaxsecond/parsec/issues/77)
- Test strategy for our providers on the CI [\#69](https://github.com/parallaxsecond/parsec/issues/69)
- Add a PKCS 11 Provider [\#66](https://github.com/parallaxsecond/parsec/issues/66)
- Add a Trusted Platform Module Provider [\#65](https://github.com/parallaxsecond/parsec/issues/65)
- Assess the contents of unsafe blocks in Mbed Provider [\#63](https://github.com/parallaxsecond/parsec/issues/63)
- Drop key handles implicitly [\#57](https://github.com/parallaxsecond/parsec/issues/57)
- Add cross-compilation to Aarch64 logic and investigate CI testing [\#55](https://github.com/parallaxsecond/parsec/issues/55)
- Add fuzz tests [\#54](https://github.com/parallaxsecond/parsec/issues/54)
- Update to Mbed Crypto v2.0.0 [\#38](https://github.com/parallaxsecond/parsec/issues/38)
- Improve logging message structure [\#36](https://github.com/parallaxsecond/parsec/issues/36)
- Make PARSEC a daemon [\#35](https://github.com/parallaxsecond/parsec/issues/35)
- Improve builders for service components [\#31](https://github.com/parallaxsecond/parsec/issues/31)
- Implement a thread pool [\#29](https://github.com/parallaxsecond/parsec/issues/29)
- Use dynamically-sized buffers in Mbed provider [\#27](https://github.com/parallaxsecond/parsec/issues/27)
- Implement configuration [\#26](https://github.com/parallaxsecond/parsec/issues/26)
- Prepare for upload to crates io [\#109](https://github.com/parallaxsecond/parsec/pull/109) ([ionut-arm](https://github.com/ionut-arm))
- Add cargo clippy lints to the CI [\#99](https://github.com/parallaxsecond/parsec/pull/99) ([hug-dev](https://github.com/hug-dev))
- Implement fuzz testing [\#97](https://github.com/parallaxsecond/parsec/pull/97) ([ionut-arm](https://github.com/ionut-arm))
- Add body length limit [\#96](https://github.com/parallaxsecond/parsec/pull/96) ([ionut-arm](https://github.com/ionut-arm))
- Ensure the safety of unsafe blocks [\#93](https://github.com/parallaxsecond/parsec/pull/93) ([hug-dev](https://github.com/hug-dev))
- Replace most panicking behaviours with Result [\#92](https://github.com/parallaxsecond/parsec/pull/92) ([hug-dev](https://github.com/hug-dev))
- Modify Travis CI test script [\#90](https://github.com/parallaxsecond/parsec/pull/90) ([hug-dev](https://github.com/hug-dev))
- Deny compilation for some rustc lints [\#87](https://github.com/parallaxsecond/parsec/pull/87) ([hug-dev](https://github.com/hug-dev))
- Switch crates to use picky-asn1-der [\#85](https://github.com/parallaxsecond/parsec/pull/85) ([hug-dev](https://github.com/hug-dev))
- Modify tests directory structure [\#83](https://github.com/parallaxsecond/parsec/pull/83) ([hug-dev](https://github.com/hug-dev))
- Allow optional providers and key ID managers [\#82](https://github.com/parallaxsecond/parsec/pull/82) ([hug-dev](https://github.com/hug-dev))
- Add a command-line option to select configuration [\#81](https://github.com/parallaxsecond/parsec/pull/81) ([hug-dev](https://github.com/hug-dev))
- Add a TPM provider [\#75](https://github.com/parallaxsecond/parsec/pull/75) ([hug-dev](https://github.com/hug-dev))
- Add SIGHUP signal handling to reload configuration [\#71](https://github.com/parallaxsecond/parsec/pull/71) ([hug-dev](https://github.com/hug-dev))
- Add a PKCS 11 provider [\#68](https://github.com/parallaxsecond/parsec/pull/68) ([hug-dev](https://github.com/hug-dev))
- Simplify the README.md file [\#67](https://github.com/parallaxsecond/parsec/pull/67) ([hug-dev](https://github.com/hug-dev))
- Add cross compilation tests to the CI with cross [\#64](https://github.com/parallaxsecond/parsec/pull/64) ([hug-dev](https://github.com/hug-dev))
- Add cross-compilation logic for Mbed Crypto [\#61](https://github.com/parallaxsecond/parsec/pull/61) ([hug-dev](https://github.com/hug-dev))
- Make key slot release implicit [\#59](https://github.com/parallaxsecond/parsec/pull/59) ([ionut-arm](https://github.com/ionut-arm))
- Make buffers dynamically sized in Mbed Provider [\#58](https://github.com/parallaxsecond/parsec/pull/58) ([ionut-arm](https://github.com/ionut-arm))
- Upgrade dependency on Mbed Crypto to v2.0.0 [\#56](https://github.com/parallaxsecond/parsec/pull/56) ([ionut-arm](https://github.com/ionut-arm))
- Add provider configuration [\#51](https://github.com/parallaxsecond/parsec/pull/51) ([ionut-arm](https://github.com/ionut-arm))
- Improve handling of systemd activation [\#50](https://github.com/parallaxsecond/parsec/pull/50) ([lnicola](https://github.com/lnicola))
- Replace println calls with log crate [\#48](https://github.com/parallaxsecond/parsec/pull/48) ([hug-dev](https://github.com/hug-dev))
- Add a compile-time option for a daemon binary [\#46](https://github.com/parallaxsecond/parsec/pull/46) ([hug-dev](https://github.com/hug-dev))
- Add service builder and configuration [\#44](https://github.com/parallaxsecond/parsec/pull/44) ([ionut-arm](https://github.com/ionut-arm))
- Add stress test to the suite [\#42](https://github.com/parallaxsecond/parsec/pull/42) ([ionut-arm](https://github.com/ionut-arm))
- Add SIGTERM handler for a graceful shutdown [\#39](https://github.com/parallaxsecond/parsec/pull/39) ([hug-dev](https://github.com/hug-dev))
- Add a GitHub Actions workflow for CI [\#34](https://github.com/parallaxsecond/parsec/pull/34) ([hug-dev](https://github.com/hug-dev))
- Add and improve component builders [\#33](https://github.com/parallaxsecond/parsec/pull/33) ([ionut-arm](https://github.com/ionut-arm))

**Fixed bugs:**

- TPM provider must support Owner Hierarchy authentication [\#102](https://github.com/parallaxsecond/parsec/issues/102)
- Audit our use of panicking [\#74](https://github.com/parallaxsecond/parsec/issues/74)
- Audit our use of unsafe code [\#73](https://github.com/parallaxsecond/parsec/issues/73)
- Review response codes returned by providers [\#72](https://github.com/parallaxsecond/parsec/issues/72)
- Warning during compilation about `llvm-config --prefix` [\#60](https://github.com/parallaxsecond/parsec/issues/60)
- Key handle manipulation is not thread-safe in Mbed Crypto [\#40](https://github.com/parallaxsecond/parsec/issues/40)
- Add owner hierarchy auth param [\#104](https://github.com/parallaxsecond/parsec/pull/104) ([ionut-arm](https://github.com/ionut-arm))
- Add a verify-only integration test [\#88](https://github.com/parallaxsecond/parsec/pull/88) ([hug-dev](https://github.com/hug-dev))
- Add sign to ASN.1 Integer types for RSAPublicKey [\#86](https://github.com/parallaxsecond/parsec/pull/86) ([hug-dev](https://github.com/hug-dev))
- Make sure Cargo features work [\#76](https://github.com/parallaxsecond/parsec/pull/76) ([hug-dev](https://github.com/hug-dev))
- Make UnixStreams block on read/write [\#47](https://github.com/parallaxsecond/parsec/pull/47) ([ionut-arm](https://github.com/ionut-arm))
- Keep key ID within bounds for Mbed provider [\#45](https://github.com/parallaxsecond/parsec/pull/45) ([ionut-arm](https://github.com/ionut-arm))
- Add locking around key handle operations in mbed provider [\#41](https://github.com/parallaxsecond/parsec/pull/41) ([ionut-arm](https://github.com/ionut-arm))
- Use new version of test client to fix CI [\#37](https://github.com/parallaxsecond/parsec/pull/37) ([hug-dev](https://github.com/hug-dev))

**Closed issues:**

- Deny compilation if there is any warning [\#80](https://github.com/parallaxsecond/parsec/issues/80)

**Merged pull requests:**

- Remove references to key lifetime [\#52](https://github.com/parallaxsecond/parsec/pull/52) ([hug-dev](https://github.com/hug-dev))
- Use thread pool instead of new thread per request [\#30](https://github.com/parallaxsecond/parsec/pull/30) ([ionut-arm](https://github.com/ionut-arm))
- Add the integration tests in the parsec repository [\#28](https://github.com/parallaxsecond/parsec/pull/28) ([hug-dev](https://github.com/hug-dev))

## [0.1.0](https://github.com/parallaxsecond/parsec/tree/0.1.0) (2019-10-09)

[Full Changelog](https://github.com/parallaxsecond/parsec/compare/047e395ee5edbad82d52738e275f756e7bd0480b...0.1.0)

**Closed issues:**

- Building/running PARSEC [\#4](https://github.com/parallaxsecond/parsec/issues/4)
- Add Jenkins, CI/CD, unit testing, and code coverage [\#3](https://github.com/parallaxsecond/parsec/issues/3)
- Implement stubbed server API for client testing [\#2](https://github.com/parallaxsecond/parsec/issues/2)
- Create PASL golang client API [\#1](https://github.com/parallaxsecond/parsec/issues/1)

**Merged pull requests:**

- Add versioning requirement on the interface [\#25](https://github.com/parallaxsecond/parsec/pull/25) ([hug-dev](https://github.com/hug-dev))
- Fixed Ionut's email address [\#24](https://github.com/parallaxsecond/parsec/pull/24) ([robdimond-arm](https://github.com/robdimond-arm))
- Remove Go client from PARSEC service [\#22](https://github.com/parallaxsecond/parsec/pull/22) ([hug-dev](https://github.com/hug-dev))
- Add documentation updates [\#21](https://github.com/parallaxsecond/parsec/pull/21) ([hug-dev](https://github.com/hug-dev))
- Docs: Update documentation to reflect the source code state [\#20](https://github.com/parallaxsecond/parsec/pull/20) ([ionut-arm](https://github.com/ionut-arm))
- Add support for ListProviders operation update [\#19](https://github.com/parallaxsecond/parsec/pull/19) ([hug-dev](https://github.com/hug-dev))
- Add a MAINTAINERS file [\#18](https://github.com/parallaxsecond/parsec/pull/18) ([hug-dev](https://github.com/hug-dev))
- Merge Integration into Master [\#17](https://github.com/parallaxsecond/parsec/pull/17) ([ionut-arm](https://github.com/ionut-arm))
- Update conn and key interfaces for initialization [\#16](https://github.com/parallaxsecond/parsec/pull/16) ([jamesonhyde-docker](https://github.com/jamesonhyde-docker))
- Update response to handle a mis-aligned header and response test [\#15](https://github.com/parallaxsecond/parsec/pull/15) ([jamesonhyde-docker](https://github.com/jamesonhyde-docker))
- Various improvements of the service internals [\#14](https://github.com/parallaxsecond/parsec/pull/14) ([hug-dev](https://github.com/hug-dev))
- Go client implementations [\#12](https://github.com/parallaxsecond/parsec/pull/12) ([jamesonhyde-docker](https://github.com/jamesonhyde-docker))
- update logo from plasma to parsec [\#11](https://github.com/parallaxsecond/parsec/pull/11) ([adamparco](https://github.com/adamparco))
- Initial go client interface for signing keys [\#10](https://github.com/parallaxsecond/parsec/pull/10) ([jamesonhyde-docker](https://github.com/jamesonhyde-docker))
- Provide minimal software solution based on Mbed Crypto [\#9](https://github.com/parallaxsecond/parsec/pull/9) ([hug-dev](https://github.com/hug-dev))
- Add API landing page [\#8](https://github.com/parallaxsecond/parsec/pull/8) ([ionut-arm](https://github.com/ionut-arm))
- Adding doc fragments. [\#7](https://github.com/parallaxsecond/parsec/pull/7) ([ionut-arm](https://github.com/ionut-arm))
- update name from PASL to PLASMA [\#6](https://github.com/parallaxsecond/parsec/pull/6) ([adamparco](https://github.com/adamparco))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
