% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RequestRegistry.R
\name{RequestRegistry}
\alias{RequestRegistry}
\title{RequestRegistry}
\description{
keeps track of HTTP requests
}
\examples{
x <- RequestRegistry$new()
x$register_request(request = "GET http://scottchamberlain.info")
x$register_request(request = "GET http://scottchamberlain.info")
x$register_request(request = "POST https://httpbin.org/post")
# print method to list requests
x

# hashes, and number of times each requested
x$request_signatures$hash

# reset the request registry
x$reset()
}
\seealso{
\code{\link[=stub_registry]{stub_registry()}} and \link{StubRegistry}

Other request-registry: 
\code{\link{HashCounter}},
\code{\link{request_registry}()}
}
\concept{request-registry}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{request_signatures}}{a HashCounter object}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-print}{\code{RequestRegistry$print()}}
\item \href{#method-reset}{\code{RequestRegistry$reset()}}
\item \href{#method-register_request}{\code{RequestRegistry$register_request()}}
\item \href{#method-clone}{\code{RequestRegistry$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
print method for the \code{RequestRegistry} class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestRegistry$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\subsection{Method \code{reset()}}{
Reset the registry to no registered requests
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestRegistry$reset()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
nothing returned; ressets registry to no requests
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-register_request"></a>}}
\subsection{Method \code{register_request()}}{
Register a request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestRegistry$register_request(request)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{a character string of the request, serialized from
\link{CrulAdapter} or another adapter}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing returned; registers the request
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RequestRegistry$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
