% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot.R
\name{check_pivot_spec}
\alias{check_pivot_spec}
\title{Check assumptions about a pivot \code{spec}}
\usage{
check_pivot_spec(spec)
}
\arguments{
\item{spec}{A specification data frame. This is useful for more complex
pivots because it gives you greater control on how metadata stored in the
columns become column names in the result.

Must be a data frame containing character \code{.name} and \code{.value} columns.
Additional columns in \code{spec} should be named to match columns in the
long format of the dataset and contain values corresponding to columns
pivoted from the wide format.
The special \code{.seq} variable is used to disambiguate rows internally;
it is automatically removed after pivotting.}
}
\description{
\code{check_pivot_spec()} is a developer facing helper function for validating
the pivot spec used in \code{\link[=pivot_longer_spec]{pivot_longer_spec()}} or \code{\link[=pivot_wider_spec]{pivot_wider_spec()}}. It is
only useful if you are extending \code{\link[=pivot_longer]{pivot_longer()}} or \code{\link[=pivot_wider]{pivot_wider()}} with
new S3 methods.

\code{check_pivot_spec()} makes the following assertions:
\itemize{
\item \code{spec} must be a data frame.
\item \code{spec} must have a character column named \code{.name}.
\item \code{spec} must have a character column named \code{.value}.
\item The \code{.name} column must be unique.
\item The \code{.name} and \code{.value} columns must be the first two columns in the data
frame, and will be reordered if that is not true.
}
}
\examples{
# A valid spec
spec <- tibble(.name = "a", .value = "b", foo = 1)
check_pivot_spec(spec)

spec <- tibble(.name = "a")
try(check_pivot_spec(spec))

# `.name` and `.value` are forced to be the first two columns
spec <- tibble(foo = 1, .value = "b", .name = "a")
check_pivot_spec(spec)
}
\keyword{internal}
