% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adasyn_impl.R
\name{adasyn}
\alias{adasyn}
\title{Adaptive Synthetic Algorithm}
\usage{
adasyn(df, var, k = 5, over_ratio = 1)
}
\arguments{
\item{df}{data.frame or tibble. Must have 1 factor variable and remaining
numeric variables.}

\item{var}{Character, name of variable containing factor variable.}

\item{k}{An integer. Number of nearest neighbor that are used
to generate the new examples of the minority class.}

\item{over_ratio}{A numeric value for the ratio of the
majority-to-minority frequencies. The default value (1) means
that all other levels are sampled up to have the same
frequency as the most occurring level. A value of 0.5 would mean
that the minority levels will have (at most) (approximately)
half as many rows than the majority level.}
}
\value{
A data.frame or tibble, depending on type of \code{df}.
}
\description{
Generates synthetic positive instances using ADASYN algorithm.
}
\details{
All columns used in this function must be numeric with no missing data.
}
\examples{
circle_numeric <- circle_example[, c("x", "y", "class")]

res <- adasyn(circle_numeric, var = "class")

res <- adasyn(circle_numeric, var = "class", k = 10)

res <- adasyn(circle_numeric, var = "class", over_ratio = 0.8)
}
\references{
Chawla, N. V., Bowyer, K. W., Hall, L. O., and Kegelmeyer,
W. P. (2002). Smote: Synthetic minority over-sampling technique.
Journal of Artificial Intelligence Research, 16:321-357.
}
\seealso{
\code{\link[=step_adasyn]{step_adasyn()}} for step function of this method

Other Direct Implementations: 
\code{\link{bsmote}()},
\code{\link{nearmiss}()},
\code{\link{smotenc}()},
\code{\link{smote}()},
\code{\link{tomek}()}
}
\concept{Direct Implementations}
