% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{stri_rand_strings}
\alias{stri_rand_strings}
\title{Generate Random Strings}
\usage{
stri_rand_strings(n, length, pattern = "[A-Za-z0-9]")
}
\arguments{
\item{n}{single integer, number of observations}

\item{length}{integer vector, desired string lengths}

\item{pattern}{character vector specifying character classes to draw
elements from, see \link{stringi-search-charclass}}
}
\value{
Returns a character vector.
}
\description{
Generates (pseudo)random strings of desired lengths.
}
\details{
Vectorized over \code{length} and \code{pattern}.
If length of \code{length} or \code{pattern} is greater than \code{n},
then redundant elements are ignored. Otherwise,
these vectors are recycled if necessary.

This operation may result in non-Unicode-normalized
strings and may give peculiar outputs for bidirectional strings.

Sampling of code points from the set specified by \code{pattern}
is always done with replacement and each code point appears with equal
probability.
}
\examples{
stri_rand_strings(5, 10) # 5 strings of length 10
stri_rand_strings(5, sample(1:10, 5, replace=TRUE)) # 5 strings of random lengths
stri_rand_strings(10, 5, "[\\\\p{script=latin}&\\\\p{Ll}]") # small letters from the Latin script

# generate n random passwords of length in [8, 14]
# consisting of at least one digit, small and big ASCII letter:
n <- 10
stri_rand_shuffle(stri_paste(
   stri_rand_strings(n, 1, '[0-9]'),
   stri_rand_strings(n, 1, '[a-z]'),
   stri_rand_strings(n, 1, '[A-Z]'),
   stri_rand_strings(n, sample(5:11, 5, replace=TRUE), '[a-zA-Z0-9]')
))

}
\seealso{
Other random: 
\code{\link{stri_rand_lipsum}()},
\code{\link{stri_rand_shuffle}()}
}
\concept{random}
