% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazyDateCoding.R
\name{lazyDateCoding}
\alias{lazyDateCoding}
\title{Efficient coding of date variables}
\usage{
lazyDateCoding(data, format, pattern, varnames, testlength = 10)
}
\arguments{
\item{data}{Data frame in which to search for date variables.}

\item{format}{passed to as.Date}

\item{pattern}{match date variables}

\item{varnames}{variable names}

\item{testlength}{how many rows of data should be evaluated to guess the format.}
}
\value{
R-code one line for each variable.
}
\description{
This function eases the process of generating date variables.
All variables in a data.frame which match a regular expression
are included
}
\details{
The code needs to be copy-and-pasted from the R-output
buffer into the R-code buffer. This can be customized
for the really efficiently working people, e.g., in emacs.
}
\examples{
d <- data.frame(x0="190101",x1=c("12/8/2019"),x2="12-8-2019",x3="20190812",stringsAsFactors=FALSE)
lazyDateCoding(d,pattern="x")
lazyDateCoding(d,pattern="3")

}
\author{
Thomas Alexander Gerds
}
