% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_R2BIN.R
\name{write_R2BIN}
\alias{write_R2BIN}
\title{Export Risoe.BINfileData into Risø BIN/BINX-file}
\usage{
write_R2BIN(
  object,
  file,
  version,
  compatibility.mode = FALSE,
  txtProgressBar = TRUE
)
}
\arguments{
\item{object}{\linkS4class{Risoe.BINfileData} (\strong{required}):
input object to be stored in a bin file.}

\item{file}{\link{character} (\strong{required}):
file name and path of the output file
\itemize{
\item \verb{[WIN]}: \code{write_R2BIN(object, "C:/Desktop/test.bin")}
\item \verb{[MAC/LINUX]}: \code{write_R2BIN("/User/test/Desktop/test.bin")}
}}

\item{version}{\link{character} (\emph{optional}):
version number for the output file. If no value is provided the highest
version number from the \linkS4class{Risoe.BINfileData} is taken automatically.

\strong{Note:}
This argument can be used to convert BIN-file versions.}

\item{compatibility.mode}{\link{logical} (\emph{with default}):
this option recalculates the position values if necessary and set the max.
value to 48. The old position number is appended as comment (e.g., 'OP: 70).
This option accounts for potential compatibility problems with the Analyst software.
It further limits the maximum number of points per curve to 9,999. If a curve contains more
data the curve data got binned using the smallest possible bin width.}

\item{txtProgressBar}{\link{logical} (\emph{with default}):
enables or disables \link{txtProgressBar}.}
}
\value{
Write a binary file.
}
\description{
Exports a \code{Risoe.BINfileData} object in a \verb{*.bin} or \verb{*.binx} file that can be
opened by the Analyst software or other Risø software.
}
\details{
The structure of the exported binary data follows the data structure
published in the Appendices of the \emph{Analyst} manual p. 42.

If
\code{LTYPE}, \code{DTYPE} and \code{LIGHTSOURCE} are not of type
\link{character}, no transformation into numeric values is done.
}
\note{
The function just roughly checks the data structures. The validity of
the output data depends on the user.

The validity of the file path is not further checked. BIN-file conversions
using the argument \code{version} may be a lossy conversion, depending on the
chosen input and output data (e.g., conversion from version 08 to 07 to 06 to 05 to 04 or 03).

\strong{Warning}

Although the coding was done carefully it seems that the BIN/BINX-files
produced by Risø DA 15/20 TL/OSL readers slightly differ on the byte level.
No obvious differences are observed in the METADATA, however, the
BIN/BINX-file may not fully compatible, at least not similar to the once
directly produced by the Risø readers!

ROI definitions (introduced in BIN-file version 8) are not supported!
There are furthermore ignored by the function \link{read_BIN2R}.
}
\section{Function version}{
 0.5.2
}

\examples{
##load exampled dataset
file <- system.file("extdata/BINfile_V8.binx", package = "Luminescence")
temp <- read_BIN2R(file)

##create temporary file path
##(for usage replace by own path)
temp_file <- tempfile(pattern = "output", fileext = ".binx")

##export to temporary file path
write_R2BIN(temp, file = temp_file)

} 

\section{How to cite}{
Kreutzer, S., 2023. write_R2BIN(): Export Risoe.BINfileData into Risø BIN/BINX-file. Function version 0.5.2. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2023. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.23. https://CRAN.R-project.org/package=Luminescence
}

\references{
DTU Nutech, 2016. The Sequence Editor, Users Manual, February, 2016.
\url{https://www.fysik.dtu.dk}
}
\seealso{
\link{read_BIN2R}, \linkS4class{Risoe.BINfileData}, \link{writeBin}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{IO}
