% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gh_whoami.R
\name{gh_whoami}
\alias{gh_whoami}
\title{Info on current GitHub user and token}
\usage{
gh_whoami(.token = NULL, .api_url = NULL, .send_headers = NULL)
}
\arguments{
\item{.token}{Authentication token. Defaults to \code{GITHUB_PAT} or
\code{GITHUB_TOKEN} environment variables, in this order if any is set.
See \code{\link[=gh_token]{gh_token()}} if you need more flexibility, e.g. different tokens
for different GitHub Enterprise deployments.}

\item{.api_url}{Github API url (default: \url{https://api.github.com}). Used
if \code{endpoint} just contains a path. Defaults to \code{GITHUB_API_URL}
environment variable if set.}

\item{.send_headers}{Named character vector of header field values
(except \code{Authorization}, which is handled via \code{.token}). This can be
used to override or augment the default \code{User-Agent} header:
\code{"https://github.com/r-lib/gh"}.}
}
\value{
A \code{gh_response} object, which is also a \code{list}.
}
\description{
Reports wallet name, GitHub login, and GitHub URL for the current
authenticated user, the first bit of the token, and the associated scopes.
}
\details{
Get a personal access token for the GitHub API from
\url{https://github.com/settings/tokens} and select the scopes necessary for your
planned tasks. The \code{repo} scope, for example, is one many are likely to need.

On macOS and Windows it is best to store the token in the git credential
store, where most GitHub clients, including gh, can access it. You can
use the gitcreds package to add your token to the credential store:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gitcreds::gitcreds_set()
}\if{html}{\out{</div>}}

See \url{https://gh.r-lib.org/articles/managing-personal-access-tokens.html}
and \url{https://usethis.r-lib.org/articles/articles/git-credentials.html}
for more about managing GitHub (and generic git) credentials.

On other systems, including Linux, the git credential store is
typically not as convenient, and you might want to store your token in
the \code{GITHUB_PAT} environment variable, which you can set in your
\code{.Renviron} file.
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
gh_whoami()
\dontshow{\}) # examplesIf}
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## explicit token + use with GitHub Enterprise
gh_whoami(
  .token = "8c70fd8419398999c9ac5bacf3192882193cadf2",
  .api_url = "https://github.foobar.edu/api/v3"
)
\dontshow{\}) # examplesIf}
}
