% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decor.R
\name{parse_cpp_function}
\alias{parse_cpp_function}
\title{Parse a C++ function}
\usage{
parse_cpp_function(context, is_attribute = FALSE)
}
\arguments{
\item{context}{The function context, as obtained by the `context` column from [cpp_decorations()]}

\item{is_attribute}{If `TRUE` the decorations are C++11 attributes, if `FALSE` they are comments.}
}
\value{
A tibble with the following fields:
- name - The name of the function
- return_type - The return type of the function
- args - A list column containing a tibble of the functions arguments
  - type - The type of the argument
  - name - The name of the argument
  - default - The default value of the argument (if any).
}
\description{
Parses a C++ function returning a tibble with the function name and return
type and a list column with the arguments of the function.
}
\examples{
# Setup
context <- "int fun(int x) { return x + 1; }"

# Parse the function
parse_cpp_function(context)
}
