% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_lines.R
\name{read_lines}
\alias{read_lines}
\title{Read text lines from a file}
\usage{
read_lines(path, n = -1)
}
\arguments{
\item{path}{A character string of the path to the file to read.}

\item{n}{integer. The number of lines to read. A negative number means read
all the lines in the file.}
}
\value{
A UTF-8 encoded character vector of the lines in the file.
}
\description{
The file is assumed to be UTF-8 and the resulting text has its encoding set
as such.
}
\details{
Both '\\r\\n' and '\\n' are treated as a newline.
}
\examples{
authors_file <- file.path(R.home("doc"), "AUTHORS")
data <- read_lines(authors_file)
}
