\name{write.fasta}
\alias{write.fasta}
\title{ Write FASTA Formated Sequences }
\description{
  Write aligned or un-aligned sequences to a FASTA format file.
}
\usage{
write.fasta(alignment=NULL, ids=NULL, seqs=alignment$ali, file, append = FALSE)
}
\arguments{
  \item{alignment}{  an alignment list object with \code{id} and \code{ali}
    components, similar to that generated by \code{\link{read.fasta}}. }
  \item{ids}{ a vector of sequence names to serve as sequence identifers }
  \item{seqs}{ an sequence or alignment character matrix or vector with a row per sequence }
  \item{file}{ name of output file.  }
  \item{append}{ logical, if TRUE output will be appended to
    \code{file}; otherwise, it will overwrite the contents of
    \code{file}. }
}
\value{
  Called for its effect.
}
\references{
  Grant, B.J. et al. (2006) \emph{Bioinformatics} \bold{22}, 2695--2696.
 }
\author{ Barry Grant }
\note{
  For a description of FASTA format see:
  \url{http://www.ncbi.nlm.nih.gov/BLAST/blastcgihelp.shtml}.
}
\seealso{ \code{\link{read.fasta}}, \code{\link{read.fasta.pdb}} }
\examples{
\donttest{
# PDB server connection required - testing excluded

## Read a PDB file
pdb <- read.pdb("1bg2")

## Extract sequence from PDB file
s <- aa321(pdb$seqres)                   # SEQRES
a <- aa321(pdb$atom[pdb$calpha,"resid"]) # ATOM

## Write simple fasta file
#write.fasta( seqs=seqbind(s,a), file="eg.fa")
#write.fasta( ids=c("seqres","atom"), seqs=seqbind(s,a), file="eg.fa" )

outfile1 = file.path(tempdir(), "eg.fa")
write.fasta(list( id=c("seqres"),ali=s ), file = outfile1)
write.fasta(list( id=c("atom"),ali=a ), file = outfile1, append=TRUE)

## Align seqres and atom records
#seqaln(seqbind(s,a))

## Read alignment
aln<-read.fasta(system.file("examples/kif1a.fa",package="bio3d"))

## Cut all but positions 130 to 245
aln$ali=aln$ali[,130:245]

outfile2 = file.path(tempdir(), "eg2.fa")
write.fasta(aln, file = outfile2)

invisible( cat("\nSee the output files:", outfile1, outfile2, sep="\n") )
}
}
\keyword{ IO }
