% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hist_qvalue.R
\name{hist.qvalue}
\alias{hist,}
\alias{hist.qvalue}
\title{Histogram of p-values}
\usage{
\method{hist}{qvalue}(x, ...)
}
\arguments{
\item{x}{A q-value object.}

\item{...}{Additional arguments, currently unused.}
}
\value{
Nothing of interest.
}
\description{
Histogram of p-values
}
\details{
This function allows one to view a histogram of the p-values along with
line plots of the q-values and local FDR values versus p-values. The \eqn{\pi_0}{pi_0}
estimate is also displayed.
}
\examples{
# import data
data(hedenfalk)
p <- hedenfalk$p

# make histogram
qobj <- qvalue(p)
hist(qobj)
}
\author{
Andrew J. Bass
}
\references{
Storey JD. (2002) A direct approach to false discovery rates. Journal
of the Royal Statistical Society, Series B, 64: 479-498. \cr
\url{http://onlinelibrary.wiley.com/doi/10.1111/1467-9868.00346/abstract}

Storey JD and Tibshirani R. (2003) Statistical significance for
genome-wide experiments. Proceedings of the National Academy of Sciences,
100: 9440-9445. \cr
\url{http://www.pnas.org/content/100/16/9440.full}

Storey JD. (2003) The positive false discovery rate: A Bayesian
interpretation and the q-value. Annals of Statistics, 31: 2013-2035. \cr
\url{http://projecteuclid.org/DPubS/Repository/1.0/Disseminate?view=body&id=pdf_1&handle=euclid.aos/1074290335}

conservative point estimation, and simultaneous conservative
consistency of false discovery rates: A unified approach. Journal of
the Royal Statistical Society, Series B, 66: 187-205. \cr
\url{http://onlinelibrary.wiley.com/doi/10.1111/j.1467-9868.2004.00439.x/abstract}

Storey JD. (2011) False discovery rates. In \emph{International Encyclopedia of Statistical Science}. \cr
\url{http://genomine.org/papers/Storey_FDR_2011.pdf} \cr
\url{http://www.springer.com/statistics/book/978-3-642-04897-5}
}
\seealso{
\code{\link{qvalue}}, \code{\link{plot.qvalue}}, \code{\link{summary.qvalue}}
}
\keyword{histogram}

