% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAttributeField.R
\name{getAttributeField}
\alias{getAttributeField}
\title{extract a specific field of the "attributes" column of a data frame created 
from a GTF/GFF file}
\usage{
getAttributeField(x, field, attrsep = "; ")
}
\arguments{
\item{x}{vector representing the "attributes" column of GTF/GFF file}

\item{field}{name of the field you want to extract from the "attributes" 
column}

\item{attrsep}{separator for the fields in the attributes column.  Defaults
to '; ', the separator for GTF files outputted by Cufflinks.}
}
\value{
vector of nucleotide positions included in the transcript
}
\description{
extract a specific field of the "attributes" column of a data frame created 
from a GTF/GFF file
}
\examples{
gtfPath = system.file('extdata', 'annot.gtf.gz', package='ballgown')
gffdata = gffRead(gtfPath)
gffdata$transcriptID = getAttributeField(gffdata$attributes, 
  field = "transcript_id")
}
\seealso{
\code{\link{gffRead}} for creating a data frame from a GTF/GFF file,
  and \url{http://useast.ensembl.org/info/website/upload/gff.html} for
  specifics of the GFF/GTF file format.
}
\author{
Wolfgang Huber, in the \code{davidTiling} R package (LGPL license)
}
