from typing import Any, ClassVar, Dict, List, Optional, Tuple

from typing import overload
import mrpt.pymrpt.mrpt
import mrpt.pymrpt.mrpt.config
import mrpt.pymrpt.mrpt.img
import mrpt.pymrpt.mrpt.maps
import mrpt.pymrpt.mrpt.math
import mrpt.pymrpt.mrpt.opengl
import mrpt.pymrpt.mrpt.poses
import mrpt.pymrpt.mrpt.rtti
import mrpt.pymrpt.mrpt.serialization
import mrpt.pymrpt.std.chrono
COUNT_IMU_DATA_FIELDS: TIMUDataIndex
IMU_ALTITUDE: TIMUDataIndex
IMU_MAG_X: TIMUDataIndex
IMU_MAG_Y: TIMUDataIndex
IMU_MAG_Z: TIMUDataIndex
IMU_ORI_QUAT_W: TIMUDataIndex
IMU_ORI_QUAT_X: TIMUDataIndex
IMU_ORI_QUAT_Y: TIMUDataIndex
IMU_ORI_QUAT_Z: TIMUDataIndex
IMU_PITCH: TIMUDataIndex
IMU_PITCH_VEL: TIMUDataIndex
IMU_PITCH_VEL_GLOBAL: TIMUDataIndex
IMU_PRESSURE: TIMUDataIndex
IMU_ROLL: TIMUDataIndex
IMU_ROLL_VEL: TIMUDataIndex
IMU_ROLL_VEL_GLOBAL: TIMUDataIndex
IMU_TEMPERATURE: TIMUDataIndex
IMU_WX: TIMUDataIndex
IMU_WY: TIMUDataIndex
IMU_WZ: TIMUDataIndex
IMU_X: TIMUDataIndex
IMU_X_ACC: TIMUDataIndex
IMU_X_ACC_GLOBAL: TIMUDataIndex
IMU_X_VEL: TIMUDataIndex
IMU_Y: TIMUDataIndex
IMU_YAW: TIMUDataIndex
IMU_YAW_VEL: TIMUDataIndex
IMU_YAW_VEL_GLOBAL: TIMUDataIndex
IMU_Y_ACC: TIMUDataIndex
IMU_Y_ACC_GLOBAL: TIMUDataIndex
IMU_Y_VEL: TIMUDataIndex
IMU_Z: TIMUDataIndex
IMU_Z_ACC: TIMUDataIndex
IMU_Z_ACC_GLOBAL: TIMUDataIndex
IMU_Z_VEL: TIMUDataIndex

class CAction(mrpt.pymrpt.mrpt.serialization.CSerializable):
    timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CAction) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CAction: ...
    def getDescriptionAsTextValue(self) -> str: ...

class CActionCollection(mrpt.pymrpt.mrpt.serialization.CSerializable):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a: CAction) -> None: ...
    @overload
    def __init__(self, arg0: CActionCollection) -> None: ...
    @overload
    def __init__(self, arg0: CActionCollection) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CActionCollection: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def eraseByIndex(self, index: int) -> None: ...
    @overload
    def eraseByIndex(size_t) -> void: ...
    def get(self, index: int) -> CAction: ...
    def getBestMovementEstimation(self) -> CActionRobotMovement2D: ...
    @overload
    def getFirstMovementEstimation(self, out_pose_increment: mrpt.pymrpt.mrpt.poses.CPose3DPDFGaussian) -> bool: ...
    @overload
    def getFirstMovementEstimation(classmrpt) -> bool: ...
    @overload
    def getFirstMovementEstimationMean(self, out_pose_increment: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    @overload
    def getFirstMovementEstimationMean(classmrpt) -> bool: ...
    def getMovementEstimationByType(self, method: CActionRobotMovement2D.TEstimationMethod) -> CActionRobotMovement2D: ...
    @overload
    def insert(self, action: CAction) -> None: ...
    @overload
    def insert(constclassmrpt) -> void: ...
    @overload
    def insertPtr(self, action: CAction) -> None: ...
    @overload
    def insertPtr(constclassstd) -> void: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class CActionRobotMovement2D(CAction):
    class TDrawSampleMotionModel:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        mmGaussian: ClassVar[CActionRobotMovement2D.TDrawSampleMotionModel] = ...
        mmThrun: ClassVar[CActionRobotMovement2D.TDrawSampleMotionModel] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class TEstimationMethod:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        emOdometry: ClassVar[CActionRobotMovement2D.TEstimationMethod] = ...
        emScan2DMatching: ClassVar[CActionRobotMovement2D.TEstimationMethod] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class TMotionModelOptions:
        class TOptions_GaussianModel:
            a1: float
            a2: float
            a3: float
            a4: float
            minStdPHI: float
            minStdXY: float
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, a1_: float, a2_: float, a3_: float, a4_: float, minStdXY_: float, minStdPHI_: float) -> None: ...
            @overload
            def __init__(self, arg0: CActionRobotMovement2D.TMotionModelOptions.TOptions_GaussianModel) -> None: ...
            def assign(self) -> CActionRobotMovement2D.TMotionModelOptions.TOptions_GaussianModel: ...
    
        class TOptions_ThrunModel:
            additional_std_XY: float
            additional_std_phi: float
            alfa1_rot_rot: float
            alfa2_rot_trans: float
            alfa3_trans_trans: float
            alfa4_trans_rot: float
            nParticlesCount: int
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CActionRobotMovement2D.TMotionModelOptions.TOptions_ThrunModel) -> None: ...
            def assign(self) -> CActionRobotMovement2D.TMotionModelOptions.TOptions_ThrunModel: ...
        gaussianModel: Any
        modelSelection: CActionRobotMovement2D.TDrawSampleMotionModel
        thrunModel: Any
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CActionRobotMovement2D.TMotionModelOptions) -> None: ...
        def assign(self) -> CActionRobotMovement2D.TMotionModelOptions: ...
    emOdometry: ClassVar[CActionRobotMovement2D.TEstimationMethod] = ...
    emScan2DMatching: ClassVar[CActionRobotMovement2D.TEstimationMethod] = ...
    mmGaussian: ClassVar[CActionRobotMovement2D.TDrawSampleMotionModel] = ...
    mmThrun: ClassVar[CActionRobotMovement2D.TDrawSampleMotionModel] = ...
    encoderLeftTicks: int
    encoderRightTicks: int
    estimationMethod: CActionRobotMovement2D.TEstimationMethod
    hasEncodersInfo: bool
    hasVelocities: bool
    motionModelConfiguration: Any
    poseChange: Any
    rawOdometryIncrementReading: mrpt.pymrpt.mrpt.poses.CPose2D
    velocityLocal: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CActionRobotMovement2D) -> None: ...
    @overload
    def __init__(self, arg0: CActionRobotMovement2D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CActionRobotMovement2D: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def computeFromEncoders(self, K_left: float, K_right: float, D: float) -> None: ...
    @overload
    def computeFromOdometry(self, odometryIncrement: mrpt.pymrpt.mrpt.poses.CPose2D, options) -> None: ...
    @overload
    def computeFromOdometry(constclassmrpt, conststructmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outSample: mrpt.pymrpt.mrpt.poses.CPose2D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    @overload
    def fastDrawSingleSample(self, outSample: mrpt.pymrpt.mrpt.poses.CPose2D) -> None: ...
    @overload
    def fastDrawSingleSample(classmrpt) -> void: ...
    @overload
    def prepareFastDrawSingleSamples(self) -> None: ...
    @overload
    def prepareFastDrawSingleSamples() -> void: ...
    @overload
    def velocityAng(self) -> float: ...
    @overload
    def velocityAng() -> double: ...
    @overload
    def velocityLin(self) -> float: ...
    @overload
    def velocityLin() -> double: ...

class CActionRobotMovement3D(CAction):
    class TDrawSampleMotionModel:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        mm6DOF: ClassVar[CActionRobotMovement3D.TDrawSampleMotionModel] = ...
        mmGaussian: ClassVar[CActionRobotMovement3D.TDrawSampleMotionModel] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class TEstimationMethod:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        emOdometry: ClassVar[CActionRobotMovement3D.TEstimationMethod] = ...
        emVisualOdometry: ClassVar[CActionRobotMovement3D.TEstimationMethod] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class TMotionModelOptions:
        class TOptions_6DOFModel:
            a1: float
            a10: float
            a2: float
            a3: float
            a4: float
            a5: float
            a6: float
            a7: float
            a8: float
            a9: float
            additional_std_XYZ: float
            additional_std_angle: float
            nParticlesCount: int
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CActionRobotMovement3D.TMotionModelOptions.TOptions_6DOFModel) -> None: ...
            def assign(self) -> CActionRobotMovement3D.TMotionModelOptions.TOptions_6DOFModel: ...
        mm6DOFModel: Any
        modelSelection: CActionRobotMovement3D.TDrawSampleMotionModel
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CActionRobotMovement3D.TMotionModelOptions) -> None: ...
        def assign(self) -> CActionRobotMovement3D.TMotionModelOptions: ...
    emOdometry: ClassVar[CActionRobotMovement3D.TEstimationMethod] = ...
    emVisualOdometry: ClassVar[CActionRobotMovement3D.TEstimationMethod] = ...
    mm6DOF: ClassVar[CActionRobotMovement3D.TDrawSampleMotionModel] = ...
    mmGaussian: ClassVar[CActionRobotMovement3D.TDrawSampleMotionModel] = ...
    estimationMethod: CActionRobotMovement3D.TEstimationMethod
    hasVelocities: List[bool]
    motionModelConfiguration: Any
    poseChange: mrpt.pymrpt.mrpt.poses.CPose3DPDFGaussian
    rawOdometryIncrementReading: mrpt.pymrpt.mrpt.poses.CPose3D
    velocities: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CActionRobotMovement3D) -> None: ...
    @overload
    def __init__(self, arg0: CActionRobotMovement3D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CActionRobotMovement3D: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def computeFromOdometry(self, odometryIncrement: mrpt.pymrpt.mrpt.poses.CPose3D, options) -> None: ...
    @overload
    def computeFromOdometry(constclassmrpt, conststructmrpt) -> void: ...
    @overload
    def computeFromOdometry_model6DOF(self, odometryIncrement: mrpt.pymrpt.mrpt.poses.CPose3D, o) -> None: ...
    @overload
    def computeFromOdometry_model6DOF(constclassmrpt, conststructmrpt) -> void: ...

class CObservation(mrpt.pymrpt.mrpt.serialization.CSerializable, mrpt.pymrpt.mrpt.Stringifyable):
    sensorLabel: str
    timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservation) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self) -> CObservation: ...
    def exportTxtDataRow(self) -> str: ...
    def exportTxtHeader(self) -> str: ...
    def exportTxtSupported(self) -> bool: ...
    def getOriginalReceivedTimeStamp(self) -> mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t: ...
    def getSensorPose(self, *args, **kwargs) -> Any: ...
    def getTimeStamp(self) -> mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t: ...
    @overload
    def load(self) -> None: ...
    @overload
    def load() -> Any: ...
    @overload
    def load() -> Any: ...
    @overload
    def load() -> void: ...
    def sensorPose(self) -> mrpt.pymrpt.mrpt.math.TPose3D: ...
    def setSensorPose(self, *args, **kwargs) -> Any: ...
    @overload
    def unload(self) -> None: ...
    @overload
    def unload() -> void: ...

class CObservation2DRangeScan(CObservation):
    aperture: float
    beamAperture: float
    deltaPitch: float
    maxRange: float
    rightToLeft: bool
    sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D
    stdError: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservation2DRangeScan) -> None: ...
    @overload
    def __init__(self, arg0: CObservation2DRangeScan) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservation2DRangeScan: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def exportTxtDataRow(self) -> str: ...
    def exportTxtHeader(self) -> str: ...
    @overload
    def exportTxtSupported(self) -> bool: ...
    @overload
    def exportTxtSupported() -> bool: ...
    @overload
    def getScanAngle(self, idx: int) -> float: ...
    @overload
    def getScanAngle(size_t) -> float: ...
    def getScanIntensity(self, i: int) -> int: ...
    @overload
    def getScanProperties(self, p: T2DScanProperties) -> None: ...
    @overload
    def getScanProperties(structmrpt) -> void: ...
    def getScanRange(self, i: int) -> float: ...
    @overload
    def getScanRangeValidity(self, i: int) -> bool: ...
    @overload
    def getScanRangeValidity(size_t) -> bool: ...
    @overload
    def getScanSize(self) -> int: ...
    @overload
    def getScanSize() -> size_t: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def hasIntensity(self) -> bool: ...
    @overload
    def hasIntensity() -> bool: ...
    @overload
    def isPlanarScan(self) -> bool: ...
    @overload
    def isPlanarScan(self, tolerance: float) -> bool: ...
    @overload
    def isPlanarScan(constdouble) -> bool: ...
    def loadFromVectors(self, nRays: int, scanRanges: float, scanValidity: str) -> None: ...
    def resizeScan(self, len: int) -> None: ...
    @overload
    def resizeScanAndAssign(self, len: int, rangeVal: float, rangeValidity: bool) -> None: ...
    @overload
    def resizeScanAndAssign(self, len: int, rangeVal: float, rangeValidity: bool, rangeIntensity: int) -> None: ...
    @overload
    def resizeScanAndAssign(size_t, constfloat, constbool, constint) -> void: ...
    @overload
    def setScanHasIntensity(self, setHasIntensityFlag: bool) -> None: ...
    @overload
    def setScanHasIntensity(bool) -> void: ...
    @overload
    def setScanIntensity(self, i: int, val: int) -> None: ...
    @overload
    def setScanIntensity(size_t, constint) -> void: ...
    @overload
    def setScanRange(self, i: int, val: float) -> None: ...
    @overload
    def setScanRange(size_t, constfloat) -> void: ...
    @overload
    def setScanRangeValidity(self, i: int, val: bool) -> None: ...
    @overload
    def setScanRangeValidity(size_t, constbool) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...
    @overload
    def truncateByDistanceAndAngle(self, min_distance: float, max_angle: float) -> None: ...
    @overload
    def truncateByDistanceAndAngle(self, min_distance: float, max_angle: float, min_height: float) -> None: ...
    @overload
    def truncateByDistanceAndAngle(self, min_distance: float, max_angle: float, min_height: float, max_height: float) -> None: ...
    @overload
    def truncateByDistanceAndAngle(self, min_distance: float, max_angle: float, min_height: float, max_height: float, h: float) -> None: ...

class CObservation2DRangeScanWithUncertainty:
    class TEvalParams:
        max_prediction_std_dev: float
        min_ray_log_lik: float
        prob_lost_ray: float
        prob_outliers: float
        def __init__(self) -> None: ...
    rangeScan: CObservation2DRangeScan
    rangesCovar: mrpt.pymrpt.mrpt.math.CMatrixDynamic_double_t
    rangesMean: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservation2DRangeScanWithUncertainty) -> None: ...
    def assign(self) -> CObservation2DRangeScanWithUncertainty: ...
    @overload
    def evaluateScanLikelihood(self, otherScan: CObservation2DRangeScan, params) -> float: ...
    @overload
    def evaluateScanLikelihood(constclassmrpt, conststructmrpt) -> double: ...

class CObservation3DRangeScan(CObservation):
    class TIntensityChannelID:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        CH_IR: ClassVar[CObservation3DRangeScan.TIntensityChannelID] = ...
        CH_VISIBLE: ClassVar[CObservation3DRangeScan.TIntensityChannelID] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class unproject_LUT_t:
        Kxs: List[float]
        Kxs_rot: List[float]
        Kys: List[float]
        Kys_rot: List[float]
        Kzs: List[float]
        Kzs_rot: List[float]
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CObservation3DRangeScan.unproject_LUT_t) -> None: ...
        def assign(self) -> CObservation3DRangeScan.unproject_LUT_t: ...
    CH_IR: ClassVar[CObservation3DRangeScan.TIntensityChannelID] = ...
    CH_VISIBLE: ClassVar[CObservation3DRangeScan.TIntensityChannelID] = ...
    cameraParams: mrpt.pymrpt.mrpt.img.TCamera
    cameraParamsIntensity: mrpt.pymrpt.mrpt.img.TCamera
    confidenceImage: mrpt.pymrpt.mrpt.img.CImage
    hasConfidenceImage: bool
    hasIntensityImage: bool
    hasPoints3D: bool
    hasRangeImage: bool
    intensityImage: mrpt.pymrpt.mrpt.img.CImage
    intensityImageChannel: CObservation3DRangeScan.TIntensityChannelID
    maxRange: float
    pixelLabels: TPixelLabelInfoBase
    points3D_idxs_x: List[int]
    points3D_idxs_y: List[int]
    points3D_x: List[float]
    points3D_y: List[float]
    points3D_z: List[float]
    rangeImage: mrpt.pymrpt.mrpt.math.CMatrixDynamic_unsigned_short_t
    rangeImageOtherLayers: Dict[str,mrpt.pymrpt.mrpt.math.CMatrixDynamic_unsigned_short_t]
    rangeUnits: float
    range_is_depth: bool
    relativePoseIntensityWRTDepth: mrpt.pymrpt.mrpt.poses.CPose3D
    sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D
    stdError: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservation3DRangeScan) -> None: ...
    @overload
    def __init__(self, arg0: CObservation3DRangeScan) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def EXTERNALS_AS_TEXT(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservation3DRangeScan: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def convertTo2DScan(self, out_scan2d: CObservation2DRangeScan, scanParams: T3DPointsTo2DScanParams) -> None: ...
    @overload
    def convertTo2DScan(self, out_scan2d: CObservation2DRangeScan, scanParams: T3DPointsTo2DScanParams, filterParams: TRangeImageFilterParams) -> None: ...
    @overload
    def doDepthAndIntensityCamerasCoincide(self) -> bool: ...
    @overload
    def doDepthAndIntensityCamerasCoincide() -> bool: ...
    @overload
    def getScanSize(self) -> int: ...
    @overload
    def getScanSize() -> size_t: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    def getZoneAsObs(self, obs: CObservation3DRangeScan, r1: int, r2: int, c1: int, c2: int) -> None: ...
    def get_unproj_lut(self, *args, **kwargs) -> Any: ...
    def hasPixelLabels(self) -> bool: ...
    def load_impl(self) -> None: ...
    def points3D_convertToExternalStorage(self, fileName: str, use_this_base_dir: str) -> None: ...
    def points3D_getExternalStorageFile(self) -> str: ...
    @overload
    def points3D_getExternalStorageFileAbsolutePath(self, out_path: str) -> None: ...
    @overload
    def points3D_getExternalStorageFileAbsolutePath(std) -> void: ...
    @overload
    def points3D_getExternalStorageFileAbsolutePath(self) -> str: ...
    def points3D_isExternallyStored(self) -> bool: ...
    @overload
    def points3D_overrideExternalStoredFlag(self, isExternal: bool) -> None: ...
    @overload
    def points3D_overrideExternalStoredFlag(bool) -> void: ...
    def rangeImage_convertToExternalStorage(self, fileName: str, use_this_base_dir: str) -> None: ...
    @overload
    def rangeImage_forceResetExternalStorage(self) -> None: ...
    @overload
    def rangeImage_forceResetExternalStorage() -> void: ...
    def rangeImage_getExternalStorageFile(self, rangeImageLayer: str) -> str: ...
    @overload
    def rangeImage_getExternalStorageFileAbsolutePath(self, out_path: str, rangeImageLayer: str) -> None: ...
    @overload
    def rangeImage_getExternalStorageFileAbsolutePath(std, conststd) -> void: ...
    @overload
    def rangeImage_getExternalStorageFileAbsolutePath(self, rangeImageLayer: str) -> str: ...
    def rangeImage_isExternallyStored(self) -> bool: ...
    def rangeImage_setSize(self, HEIGHT: int, WIDTH: int) -> None: ...
    def recoverCameraCalibrationParameters(self, *args, **kwargs) -> Any: ...
    @overload
    def resizePoints3DVectors(self, nPoints: int) -> None: ...
    @overload
    def resizePoints3DVectors(size_t) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...
    @overload
    def swap(self, o: CObservation3DRangeScan) -> None: ...
    @overload
    def swap(classmrpt) -> void: ...
    @overload
    def undistort(self) -> None: ...
    @overload
    def undistort() -> void: ...
    @overload
    def unload(self) -> None: ...
    @overload
    def unload() -> void: ...

class CObservation3DScene(CObservation, mrpt.pymrpt.mrpt.opengl.Visualizable):
    scene: mrpt.pymrpt.mrpt.opengl.Scene
    sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservation3DScene) -> None: ...
    @overload
    def __init__(self, arg0: CObservation3DScene) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservation3DScene: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def getVisualizationInto(self, o: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservation6DFeatures(CObservation):
    class TMeasurement:
        id: int
        inf_matrix: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_6UL_6UL_t
        pose: mrpt.pymrpt.mrpt.poses.CPose3D
        def __init__(self) -> None: ...
    maxSensorDistance: float
    minSensorDistance: float
    sensedFeatures: Any
    sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservation6DFeatures) -> None: ...
    @overload
    def __init__(self, arg0: CObservation6DFeatures) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservation6DFeatures: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationBatteryState(CObservation):
    voltageMainRobotBattery: float
    voltageMainRobotBatteryIsValid: bool
    voltageMainRobotComputer: float
    voltageMainRobotComputerIsValid: bool
    voltageOtherBatteries: Any
    voltageOtherBatteriesValid: List[bool]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservationBatteryState) -> None: ...
    @overload
    def __init__(self, arg0: CObservationBatteryState) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationBatteryState: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def exportTxtDataRow(self) -> str: ...
    def exportTxtHeader(self) -> str: ...
    @overload
    def exportTxtSupported(self) -> bool: ...
    @overload
    def exportTxtSupported() -> bool: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationBeaconRanges(CObservation):
    class TMeasurement:
        beaconID: int
        sensedDistance: float
        sensorLocationOnRobot: mrpt.pymrpt.mrpt.poses.CPoint3D
        def __init__(self) -> None: ...
    auxEstimatePose: mrpt.pymrpt.mrpt.poses.CPose2D
    maxSensorDistance: float
    minSensorDistance: float
    sensedData: Any
    stdError: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservationBeaconRanges) -> None: ...
    @overload
    def __init__(self, arg0: CObservationBeaconRanges) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationBeaconRanges: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def debugPrintOut(self) -> None: ...
    @overload
    def debugPrintOut() -> void: ...
    def exportTxtDataRow(self) -> str: ...
    def exportTxtHeader(self) -> str: ...
    @overload
    def exportTxtSupported(self) -> bool: ...
    @overload
    def exportTxtSupported() -> bool: ...
    @overload
    def getSensedRangeByBeaconID(self, beaconID: int) -> float: ...
    @overload
    def getSensedRangeByBeaconID(int32_t) -> float: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationBearingRange(CObservation):
    class TMeasurement:
        covariance: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t
        landmarkID: int
        pitch: float
        range: float
        yaw: float
        def __init__(self) -> None: ...
    fieldOfView_pitch: float
    fieldOfView_yaw: float
    maxSensorDistance: float
    minSensorDistance: float
    sensedData: Any
    sensorLocationOnRobot: mrpt.pymrpt.mrpt.poses.CPose3D
    sensor_std_pitch: float
    sensor_std_range: float
    sensor_std_yaw: float
    validCovariances: bool
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservationBearingRange) -> None: ...
    @overload
    def __init__(self, arg0: CObservationBearingRange) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationBearingRange: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def debugPrintOut(self) -> None: ...
    @overload
    def debugPrintOut() -> void: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationCANBusJ1939(CObservation):
    m_data: List[int]
    m_data_length: int
    m_pdu_format: int
    m_pdu_spec: int
    m_pgn: int
    m_priority: int
    m_raw_frame: List[str]
    m_src_address: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservationCANBusJ1939) -> None: ...
    @overload
    def __init__(self, arg0: CObservationCANBusJ1939) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationCANBusJ1939: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getSensorPose(self) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationComment(CObservation):
    text: str
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservationComment) -> None: ...
    @overload
    def __init__(self, arg0: CObservationComment) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationComment: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getSensorPose(self) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationGPS(CObservation):
    has_satellite_timestamp: bool
    messages: Dict[gnss.gnss_message_type_t,gnss.gnss_message_ptr]
    originalReceivedTimestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t
    sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservationGPS) -> None: ...
    @overload
    def __init__(self, arg0: CObservationGPS) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GPS_time_to_UTC(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationGPS: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def getMsgByType(self, type_id: gnss.gnss_message_type_t) -> gnss.gnss_message: ...
    def getOriginalReceivedTimeStamp(self) -> mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def hasMsgType(self, type_id: gnss.gnss_message_type_t) -> bool: ...
    @overload
    def hasMsgType(constenummrpt) -> bool: ...
    @overload
    def has_GGA_datum(self) -> bool: ...
    @overload
    def has_GGA_datum() -> bool: ...
    @overload
    def has_RMC_datum(self) -> bool: ...
    @overload
    def has_RMC_datum() -> bool: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...
    @overload
    def swap(self, o: CObservationGPS) -> None: ...
    @overload
    def swap(classmrpt) -> void: ...

class CObservationGasSensors(CObservation):
    class CMOSmodel:
        a_decay: float
        a_rise: float
        b_decay: float
        b_rise: float
        decimate_value: int
        save_maplog: bool
        winNoise_size: int
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CObservationGasSensors.CMOSmodel) -> None: ...
        def assign(self) -> CObservationGasSensors.CMOSmodel: ...
        def get_GasDistribution_estimation(self, reading: float, timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> bool: ...

    class TObservationENose:
        eNosePoseOnTheRobot: mrpt.pymrpt.mrpt.math.TPose3D
        hasTemperature: bool
        isActive: bool
        readingsVoltage: List[float]
        sensorTypes: List[int]
        temperature: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CObservationGasSensors.TObservationENose) -> None: ...
        def assign(self) -> CObservationGasSensors.TObservationENose: ...
    m_readings: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservationGasSensors) -> None: ...
    @overload
    def __init__(self, arg0: CObservationGasSensors) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationGasSensors: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationIMU(CObservation):
    dataIsPresent: List[bool[31]]
    rawMeasurements: List[float[31]]
    sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationIMU: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def exportTxtDataRow(self) -> str: ...
    def exportTxtHeader(self) -> str: ...
    @overload
    def exportTxtSupported(self) -> bool: ...
    @overload
    def exportTxtSupported() -> bool: ...
    @overload
    def get(self, idx: TIMUDataIndex) -> float: ...
    @overload
    def get() -> Any: ...
    @overload
    def get(enummrpt) -> double: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def has(self, idx: TIMUDataIndex) -> bool: ...
    @overload
    def has(enummrpt) -> bool: ...
    @overload
    def set(self, idx: TIMUDataIndex, value: float) -> None: ...
    @overload
    def set() -> Any: ...
    @overload
    def set(enummrpt, double) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationImage(CObservation):
    cameraParams: mrpt.pymrpt.mrpt.img.TCamera
    cameraPose: mrpt.pymrpt.mrpt.poses.CPose3D
    image: mrpt.pymrpt.mrpt.img.CImage
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationImage: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def getUndistortedImage(self, out_img: mrpt.pymrpt.mrpt.img.CImage) -> None: ...
    @overload
    def getUndistortedImage(classmrpt) -> void: ...
    @overload
    def load_impl(self) -> None: ...
    @overload
    def load_impl() -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...
    def unload(self, *args, **kwargs) -> Any: ...

class CObservationOdometry(CObservation):
    encoderLeftTicks: int
    encoderRightTicks: int
    hasEncodersInfo: bool
    hasVelocities: bool
    odometry: mrpt.pymrpt.mrpt.poses.CPose2D
    velocityLocal: Any
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationOdometry: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def exportTxtDataRow(self) -> str: ...
    def exportTxtHeader(self) -> str: ...
    @overload
    def exportTxtSupported(self) -> bool: ...
    @overload
    def exportTxtSupported() -> bool: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationPointCloud(CObservation):
    class ExternalStorageFormat:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        KittiBinFile: ClassVar[CObservationPointCloud.ExternalStorageFormat] = ...
        MRPT_Serialization: ClassVar[CObservationPointCloud.ExternalStorageFormat] = ...
        None: ClassVar[CObservationPointCloud.ExternalStorageFormat] = ...
        PlainTextFile: ClassVar[CObservationPointCloud.ExternalStorageFormat] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        def __setstate__(self, state: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    pointcloud: mrpt.pymrpt.mrpt.maps.CPointsMap
    sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, o: CObservation3DRangeScan) -> None: ...
    @overload
    def __init__(self, arg0: CObservationPointCloud) -> None: ...
    @overload
    def __init__(self, arg0: CObservationPointCloud) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationPointCloud: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def getExternalStorageFile(self) -> str: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    def isExternallyStored(self) -> bool: ...
    def load_impl(self) -> None: ...
    @overload
    def overrideExternalStorageFormatFlag(self, fmt: CObservationPointCloud.ExternalStorageFormat) -> None: ...
    @overload
    def overrideExternalStorageFormatFlag(constenummrpt) -> void: ...
    @overload
    def setAsExternalStorage(self, fileName: str, fmt: CObservationPointCloud.ExternalStorageFormat) -> None: ...
    @overload
    def setAsExternalStorage(conststd, constenummrpt) -> void: ...
    @overload
    def setSensorPose(self, p: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...
    @overload
    def unload(self) -> None: ...
    @overload
    def unload() -> void: ...

class CObservationRFID(CObservation):
    class TTagReading:
        antennaPort: str
        epc: str
        power: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CObservationRFID.TTagReading) -> None: ...
        def assign(self) -> CObservationRFID.TTagReading: ...
    sensorPoseOnRobot: mrpt.pymrpt.mrpt.poses.CPose3D
    tag_readings: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservationRFID) -> None: ...
    @overload
    def __init__(self, arg0: CObservationRFID) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationRFID: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getNtags(self) -> int: ...
    @overload
    def getNtags() -> uint32_t: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    def setSensorPose(self, *args, **kwargs) -> Any: ...

class CObservationRGBD360(CObservation):
    hasIntensityImage: bool
    hasRangeImage: bool
    maxRange: float
    rangeUnits: float
    sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D
    stdError: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservationRGBD360) -> None: ...
    @overload
    def __init__(self, arg0: CObservationRGBD360) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationRGBD360: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    def rangeImage_setSize(self, HEIGHT: int, WIDTH: int, sensor_id: int) -> None: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationRange(CObservation):
    class TMeasurement:
        sensedDistance: float
        sensorID: int
        sensorNoiseStdDeviation: float
        sensorPose: mrpt.pymrpt.mrpt.math.TPose3D
        def __init__(self) -> None: ...
    maxSensorDistance: float
    minSensorDistance: float
    sensedData: Any
    sensorConeAperture: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservationRange) -> None: ...
    @overload
    def __init__(self, arg0: CObservationRange) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationRange: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationRawDAQ(CObservation):
    AIN_16bits: List[int]
    AIN_32bits: List[int]
    AIN_8bits: List[int]
    AIN_channel_count: int
    AIN_double: List[float]
    AIN_float: List[float]
    AIN_interleaved: bool
    AOUT_16bits: List[int]
    AOUT_8bits: List[int]
    AOUT_double: List[float]
    AOUT_float: List[float]
    CNTRIN_32bits: List[int]
    CNTRIN_double: List[float]
    DIN: List[int]
    DOUT: List[int]
    sample_rate: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservationRawDAQ) -> None: ...
    @overload
    def __init__(self, arg0: CObservationRawDAQ) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationRawDAQ: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getSensorPose(self) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationReflectivity(CObservation):
    channel: int
    reflectivityLevel: float
    sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D
    sensorStdNoise: float
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationReflectivity: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def exportTxtDataRow(self) -> str: ...
    def exportTxtHeader(self) -> str: ...
    @overload
    def exportTxtSupported(self) -> bool: ...
    @overload
    def exportTxtSupported() -> bool: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationRobotPose(CObservation):
    pose: mrpt.pymrpt.mrpt.poses.CPose3DPDFGaussian
    sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationRobotPose: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def exportTxtDataRow(self) -> str: ...
    def exportTxtHeader(self) -> str: ...
    @overload
    def exportTxtSupported(self) -> bool: ...
    @overload
    def exportTxtSupported() -> bool: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationRotatingScan(CObservation):
    class ExternalStorageFormat:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        MRPT_Serialization: ClassVar[CObservationRotatingScan.ExternalStorageFormat] = ...
        None: ClassVar[CObservationRotatingScan.ExternalStorageFormat] = ...
        PlainTextFile: ClassVar[CObservationRotatingScan.ExternalStorageFormat] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        def __setstate__(self, state: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    azimuthSpan: float
    columnCount: int
    has_satellite_timestamp: bool
    intensityImage: mrpt.pymrpt.mrpt.math.CMatrixDynamic_unsigned_char_t
    lidarModel: str
    maxRange: float
    minRange: float
    organizedPoints: mrpt.pymrpt.mrpt.math.CMatrixDynamic_mrpt_math_TPoint3D_float_t
    originalReceivedTimestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t
    rangeImage: mrpt.pymrpt.mrpt.math.CMatrixDynamic_unsigned_short_t
    rangeOtherLayers: Dict[str,mrpt.pymrpt.mrpt.math.CMatrixDynamic_unsigned_short_t]
    rangeResolution: float
    rowCount: int
    sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D
    startAzimuth: float
    sweepDuration: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservationRotatingScan) -> None: ...
    @overload
    def __init__(self, arg0: CObservationRotatingScan) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationRotatingScan: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def fromGeneric(self, o: CObservation) -> bool: ...
    @overload
    def fromGeneric(constclassmrpt) -> bool: ...
    @overload
    def fromScan2D(self, o: CObservation2DRangeScan) -> None: ...
    @overload
    def fromScan2D(constclassmrpt) -> void: ...
    def fromVelodyne(self, o: CObservationVelodyneScan) -> None: ...
    def getExternalStorageFile(self) -> str: ...
    def getOriginalReceivedTimeStamp(self) -> mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    def isExternallyStored(self) -> bool: ...
    @overload
    def loadFromTextFile(self, filename: str) -> bool: ...
    @overload
    def loadFromTextFile(conststd) -> bool: ...
    def load_impl(self) -> None: ...
    @overload
    def overrideExternalStorageFormatFlag(self, fmt: CObservationRotatingScan.ExternalStorageFormat) -> None: ...
    @overload
    def overrideExternalStorageFormatFlag(constenummrpt) -> void: ...
    def saveToTextFile(self, *args, **kwargs) -> Any: ...
    @overload
    def setAsExternalStorage(self, fileName: str, fmt: CObservationRotatingScan.ExternalStorageFormat) -> None: ...
    @overload
    def setAsExternalStorage(conststd, constenummrpt) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...
    @overload
    def unload(self) -> None: ...
    @overload
    def unload() -> void: ...

class CObservationSkeleton(CObservation):
    class TSkeletonJoint:
        conf: float
        x: float
        y: float
        z: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CObservationSkeleton.TSkeletonJoint) -> None: ...
        def assign(self) -> CObservationSkeleton.TSkeletonJoint: ...
    head: Any
    left_elbow: Any
    left_foot: Any
    left_hand: Any
    left_hip: Any
    left_knee: Any
    left_shoulder: Any
    neck: Any
    right_elbow: Any
    right_foot: Any
    right_hand: Any
    right_hip: Any
    right_knee: Any
    right_shoulder: Any
    sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D
    torso: Any
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationSkeleton: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationStereoImages(CObservation):
    cameraPose: mrpt.pymrpt.mrpt.poses.CPose3DQuat
    hasImageDisparity: bool
    hasImageRight: bool
    imageDisparity: mrpt.pymrpt.mrpt.img.CImage
    imageLeft: mrpt.pymrpt.mrpt.img.CImage
    imageRight: mrpt.pymrpt.mrpt.img.CImage
    leftCamera: mrpt.pymrpt.mrpt.img.TCamera
    rightCamera: mrpt.pymrpt.mrpt.img.TCamera
    rightCameraPose: mrpt.pymrpt.mrpt.poses.CPose3DQuat
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservationStereoImages) -> None: ...
    @overload
    def __init__(self, arg0: CObservationStereoImages) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def areImagesRectified(self) -> bool: ...
    @overload
    def areImagesRectified() -> bool: ...
    def assign(self) -> CObservationStereoImages: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    def getStereoCameraParams(self, *args, **kwargs) -> Any: ...
    @overload
    def load_impl(self) -> None: ...
    @overload
    def load_impl() -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...
    @overload
    def setStereoCameraParams(self, in_params: mrpt.pymrpt.mrpt.img.TStereoCamera) -> None: ...
    @overload
    def setStereoCameraParams(constclassmrpt) -> void: ...
    @overload
    def swap(self, o: CObservationStereoImages) -> None: ...
    @overload
    def swap(classmrpt) -> void: ...

class CObservationStereoImagesFeatures(CObservation):
    cameraLeft: mrpt.pymrpt.mrpt.img.TCamera
    cameraPoseOnRobot: mrpt.pymrpt.mrpt.poses.CPose3DQuat
    cameraRight: mrpt.pymrpt.mrpt.img.TCamera
    rightCameraPose: mrpt.pymrpt.mrpt.poses.CPose3DQuat
    theFeatures: List[TStereoImageFeatures]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, cLeft: mrpt.pymrpt.mrpt.img.TCamera, cRight: mrpt.pymrpt.mrpt.img.TCamera, rCPose: mrpt.pymrpt.mrpt.poses.CPose3DQuat, cPORobot: mrpt.pymrpt.mrpt.poses.CPose3DQuat) -> None: ...
    @overload
    def __init__(self, arg0: CObservationStereoImagesFeatures) -> None: ...
    @overload
    def __init__(self, arg0: CObservationStereoImagesFeatures) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationStereoImagesFeatures: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3DQuat) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def saveFeaturesToTextFile(self, filename: str) -> None: ...
    @overload
    def saveFeaturesToTextFile(conststd) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3DQuat) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationVelodyneScan(CObservation):
    class PointCloudStorageWrapper:
        def __init__(self) -> None: ...
        def add_point(self, pt_x: float, pt_y: float, pt_z: float, pt_intensity: int, tim: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, azimuth: float, laser_id: int) -> None: ...
        def assign(self) -> CObservationVelodyneScan.PointCloudStorageWrapper: ...
        @overload
        def reserve(self, n: int) -> None: ...
        @overload
        def reserve(std) -> void: ...
        @overload
        def resizeLaserCount(self, n: int) -> None: ...
        @overload
        def resizeLaserCount(std) -> void: ...

    class TGeneratePointCloudParameters:
        ROI_x_max: float
        ROI_x_min: float
        ROI_y_max: float
        ROI_y_min: float
        ROI_z_max: float
        ROI_z_min: float
        dualKeepLast: bool
        dualKeepStrongest: bool
        filterByROI: bool
        filterBynROI: bool
        filterOutIsolatedPoints: bool
        generatePerPointAzimuth: bool
        generatePerPointTimestamp: bool
        generatePointsForLaserID: bool
        isolatedPointsFilterDistance: float
        maxAzimuth_deg: float
        maxDistance: float
        minAzimuth_deg: float
        minDistance: float
        nROI_x_max: float
        nROI_x_min: float
        nROI_y_max: float
        nROI_y_min: float
        nROI_z_max: float
        nROI_z_min: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CObservationVelodyneScan.TGeneratePointCloudParameters) -> None: ...

    class TGeneratePointCloudSE3Results:
        num_correctly_inserted_points: int
        num_points: int
        def __init__(self) -> None: ...

    class TPointCloud:
        azimuth: List[float]
        intensity: List[int]
        laser_id: List[int]
        pointsForLaserID: List[List[int]]
        timestamp: List[mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t]
        x: List[float]
        y: List[float]
        z: List[float]
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CObservationVelodyneScan.TPointCloud) -> None: ...
        def assign(self) -> CObservationVelodyneScan.TPointCloud: ...
        @overload
        def clear(self) -> None: ...
        @overload
        def clear() -> void: ...
        @overload
        def clear_deep(self) -> None: ...
        @overload
        def clear_deep() -> void: ...
        @overload
        def reserve(self, n: int) -> None: ...
        @overload
        def reserve(std) -> void: ...
        def size(self) -> int: ...

    class TVelodynePositionPacket:
        def __init__(self) -> None: ...
        @overload
        def gps_timestamp(self) -> int: ...
        @overload
        def gps_timestamp() -> uint32_t: ...
        @overload
        def unused2(self) -> int: ...
        @overload
        def unused2() -> uint32_t: ...

    class TVelodyneRawPacket:
        laser_return_mode: int
        velodyne_model_ID: int
        def __init__(self) -> None: ...
        @overload
        def gps_timestamp(self) -> int: ...
        @overload
        def gps_timestamp() -> uint32_t: ...

    class laser_return_t:
        def __init__(self) -> None: ...
        @overload
        def distance(self) -> int: ...
        @overload
        def distance() -> uint16_t: ...
        @overload
        def intensity(self) -> int: ...
        @overload
        def intensity() -> uint8_t: ...

    class raw_block_t:
        def __init__(self) -> None: ...
        @overload
        def header(self) -> int: ...
        @overload
        def header() -> uint16_t: ...
        @overload
        def rotation(self) -> int: ...
        @overload
        def rotation() -> uint16_t: ...
    calibration: VelodyneCalibration
    has_satellite_timestamp: bool
    maxRange: float
    minRange: float
    originalReceivedTimestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t
    point_cloud: Any
    scan_packets: Any
    sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CObservationVelodyneScan) -> None: ...
    @overload
    def __init__(self, arg0: CObservationVelodyneScan) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationVelodyneScan: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def generatePointCloud(self) -> None: ...
    @overload
    def generatePointCloud(self, params) -> None: ...
    @overload
    def generatePointCloud(conststructmrpt) -> void: ...
    @overload
    def generatePointCloud(self, dest) -> None: ...
    @overload
    def generatePointCloud(self, dest, params) -> None: ...
    @overload
    def generatePointCloud(structmrpt, conststructmrpt) -> void: ...
    def getOriginalReceivedTimeStamp(self) -> mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationWindSensor(CObservation):
    direction: float
    sensorPoseOnRobot: mrpt.pymrpt.mrpt.poses.CPose3D
    speed: float
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationWindSensor: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def exportTxtDataRow(self) -> str: ...
    def exportTxtHeader(self) -> str: ...
    @overload
    def exportTxtSupported(self) -> bool: ...
    @overload
    def exportTxtSupported() -> bool: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CObservationWirelessPower(CObservation):
    power: float
    sensorPoseOnRobot: mrpt.pymrpt.mrpt.poses.CPose3D
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CObservationWirelessPower: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def exportTxtDataRow(self) -> str: ...
    def exportTxtHeader(self) -> str: ...
    @overload
    def exportTxtSupported(self) -> bool: ...
    @overload
    def exportTxtSupported() -> bool: ...
    @overload
    def getSensorPose(self, out_sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getSensorPose(classmrpt) -> void: ...
    @overload
    def setSensorPose(self, newSensorPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setSensorPose(constclassmrpt) -> void: ...

class CRawlog(mrpt.pymrpt.mrpt.serialization.CSerializable):
    class TEntryType:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        etActionCollection: ClassVar[CRawlog.TEntryType] = ...
        etObservation: ClassVar[CRawlog.TEntryType] = ...
        etOther: ClassVar[CRawlog.TEntryType] = ...
        etSensoryFrame: ClassVar[CRawlog.TEntryType] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class const_iterator:
        def __init__(self) -> None: ...
        def dereference(self) -> mrpt.pymrpt.mrpt.serialization.CSerializable: ...
        def getType(self) -> CRawlog.TEntryType: ...

    class iterator:
        def __init__(self) -> None: ...
        def dereference(self) -> mrpt.pymrpt.mrpt.serialization.CSerializable: ...
        def getType(self) -> CRawlog.TEntryType: ...
    etActionCollection: ClassVar[CRawlog.TEntryType] = ...
    etObservation: ClassVar[CRawlog.TEntryType] = ...
    etOther: ClassVar[CRawlog.TEntryType] = ...
    etSensoryFrame: ClassVar[CRawlog.TEntryType] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CRawlog) -> None: ...
    @overload
    def __init__(self, arg0: CRawlog) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def ReadFromArchive(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CRawlog: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def detectImagesDirectory(self, *args, **kwargs) -> Any: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    def getActionObservationPair(self, action: CActionCollection, observations: CSensoryFrame, rawlogEntry: int) -> bool: ...
    def getActionObservationPairOrObservation(self, *args, **kwargs) -> Any: ...
    def getAsAction(self, index: int) -> CActionCollection: ...
    def getAsGeneric(self, index: int) -> mrpt.pymrpt.mrpt.serialization.CSerializable: ...
    def getAsObservation(self, index: int) -> CObservation: ...
    def getAsObservations(self, index: int) -> CSensoryFrame: ...
    @overload
    def getCommentText(self, t: str) -> None: ...
    @overload
    def getCommentText(std) -> void: ...
    @overload
    def getCommentText(self) -> str: ...
    @overload
    def getCommentTextAsConfigFile(self, memCfg: mrpt.pymrpt.mrpt.config.CConfigFileMemory) -> None: ...
    @overload
    def getCommentTextAsConfigFile(classmrpt) -> void: ...
    def getType(self, index: int) -> CRawlog.TEntryType: ...
    @overload
    def insert(self, action: CAction) -> None: ...
    @overload
    def insert(classmrpt) -> void: ...
    @overload
    def insert(self, action: CActionCollection) -> None: ...
    @overload
    def insert(classmrpt) -> void: ...
    @overload
    def insert(self, observations: CSensoryFrame) -> None: ...
    @overload
    def insert(classmrpt) -> void: ...
    @overload
    def insert(self, obj: mrpt.pymrpt.mrpt.serialization.CSerializable) -> None: ...
    @overload
    def insert(constclassstd) -> void: ...
    def loadFromRawLogFile(self, *args, **kwargs) -> Any: ...
    def readActionObservationPair(self, *args, **kwargs) -> Any: ...
    @overload
    def remove(self, index: int) -> None: ...
    @overload
    def remove(size_t) -> void: ...
    @overload
    def remove(self, first_index: int, last_index: int) -> None: ...
    def saveToRawLogFile(self, *args, **kwargs) -> Any: ...
    @overload
    def setCommentText(self, t: str) -> None: ...
    @overload
    def setCommentText(conststd) -> void: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...
    @overload
    def swap(self, obj: CRawlog) -> None: ...
    @overload
    def swap(classmrpt) -> void: ...

class CSensoryFrame(mrpt.pymrpt.mrpt.serialization.CSerializable):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CSensoryFrame) -> None: ...
    @overload
    def __init__(self, arg0: CSensoryFrame) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CSensoryFrame: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    @overload
    def eraseByIndex(self, idx: int) -> None: ...
    @overload
    def eraseByIndex(size_t) -> void: ...
    @overload
    def eraseByLabel(self, label: str) -> None: ...
    @overload
    def eraseByLabel(conststd) -> void: ...
    def getObservationByIndex(self, idx: int) -> CObservation: ...
    @overload
    def getObservationBySensorLabel(self, label: str) -> CObservation: ...
    @overload
    def getObservationBySensorLabel(self, label: str, idx: int) -> CObservation: ...
    @overload
    def insert(self, obs: CObservation) -> None: ...
    @overload
    def insert(constclassstd) -> void: ...
    @overload
    def push_back(self, obs: CObservation) -> None: ...
    @overload
    def push_back(constclassstd) -> void: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...
    @overload
    def swap(self, sf: CSensoryFrame) -> None: ...
    @overload
    def swap(classmrpt) -> void: ...
    @overload
    def __iadd__(self, sf: CSensoryFrame) -> None: ...
    @overload
    def __iadd__(self, obs: CObservation) -> None: ...

class CSinCosLookUpTableFor2DScans:
    class TSinCosValues:
        ccos: Any
        csin: Any
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CSinCosLookUpTableFor2DScans.TSinCosValues) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CSinCosLookUpTableFor2DScans) -> None: ...
    def assign(self) -> CSinCosLookUpTableFor2DScans: ...
    def getSinCosForScan(self, *args, **kwargs) -> Any: ...

class T2DScanProperties:
    aperture: float
    nRays: int
    rightToLeft: bool
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: T2DScanProperties) -> None: ...
    def assign(self) -> T2DScanProperties: ...

class T3DPointsProjectionParams:
    MAKE_ORGANIZED: bool
    USE_SSE2: bool
    decimation: int
    layer: str
    onlyPointsWithIntensityColor: bool
    robotPoseInTheWorld: Optional[mrpt.pymrpt.mrpt.poses.CPose3D]
    takeIntoAccountSensorPoseOnRobot: bool
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: T3DPointsProjectionParams) -> None: ...
    def assign(self) -> T3DPointsProjectionParams: ...

class T3DPointsTo2DScanParams:
    angle_inf: float
    angle_sup: float
    oversampling_ratio: float
    sensorLabel: str
    use_origin_sensor_pose: bool
    z_max: float
    z_min: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: T3DPointsTo2DScanParams) -> None: ...
    def assign(self) -> T3DPointsTo2DScanParams: ...

class TIMUDataIndex:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    COUNT_IMU_DATA_FIELDS: ClassVar[TIMUDataIndex] = ...
    IMU_ALTITUDE: ClassVar[TIMUDataIndex] = ...
    IMU_MAG_X: ClassVar[TIMUDataIndex] = ...
    IMU_MAG_Y: ClassVar[TIMUDataIndex] = ...
    IMU_MAG_Z: ClassVar[TIMUDataIndex] = ...
    IMU_ORI_QUAT_W: ClassVar[TIMUDataIndex] = ...
    IMU_ORI_QUAT_X: ClassVar[TIMUDataIndex] = ...
    IMU_ORI_QUAT_Y: ClassVar[TIMUDataIndex] = ...
    IMU_ORI_QUAT_Z: ClassVar[TIMUDataIndex] = ...
    IMU_PITCH: ClassVar[TIMUDataIndex] = ...
    IMU_PITCH_VEL: ClassVar[TIMUDataIndex] = ...
    IMU_PITCH_VEL_GLOBAL: ClassVar[TIMUDataIndex] = ...
    IMU_PRESSURE: ClassVar[TIMUDataIndex] = ...
    IMU_ROLL: ClassVar[TIMUDataIndex] = ...
    IMU_ROLL_VEL: ClassVar[TIMUDataIndex] = ...
    IMU_ROLL_VEL_GLOBAL: ClassVar[TIMUDataIndex] = ...
    IMU_TEMPERATURE: ClassVar[TIMUDataIndex] = ...
    IMU_WX: ClassVar[TIMUDataIndex] = ...
    IMU_WY: ClassVar[TIMUDataIndex] = ...
    IMU_WZ: ClassVar[TIMUDataIndex] = ...
    IMU_X: ClassVar[TIMUDataIndex] = ...
    IMU_X_ACC: ClassVar[TIMUDataIndex] = ...
    IMU_X_ACC_GLOBAL: ClassVar[TIMUDataIndex] = ...
    IMU_X_VEL: ClassVar[TIMUDataIndex] = ...
    IMU_Y: ClassVar[TIMUDataIndex] = ...
    IMU_YAW: ClassVar[TIMUDataIndex] = ...
    IMU_YAW_VEL: ClassVar[TIMUDataIndex] = ...
    IMU_YAW_VEL_GLOBAL: ClassVar[TIMUDataIndex] = ...
    IMU_Y_ACC: ClassVar[TIMUDataIndex] = ...
    IMU_Y_ACC_GLOBAL: ClassVar[TIMUDataIndex] = ...
    IMU_Y_VEL: ClassVar[TIMUDataIndex] = ...
    IMU_Z: ClassVar[TIMUDataIndex] = ...
    IMU_Z_ACC: ClassVar[TIMUDataIndex] = ...
    IMU_Z_ACC_GLOBAL: ClassVar[TIMUDataIndex] = ...
    IMU_Z_VEL: ClassVar[TIMUDataIndex] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TPixelLabelInfoBase:
    pixelLabelNames: Dict[int,str]
    def __init__(self, *args, **kwargs) -> None: ...
    def checkLabel(self, row: int, col: int, label_idx: int) -> bool: ...
    @overload
    def checkLabelNameExistence(self, name: str) -> int: ...
    @overload
    def checkLabelNameExistence(conststd) -> int: ...
    def getLabelName(self, label_idx: int) -> str: ...
    def getLabels(self, row: int, col: int, labels: int) -> None: ...
    def readAndBuildFromStream(self, *args, **kwargs) -> Any: ...
    def setLabel(self, row: int, col: int, label_idx: int) -> None: ...
    @overload
    def setLabelName(self, label_idx: int, name: str) -> None: ...
    @overload
    def setLabelName(unsignedint, conststd) -> void: ...
    def setSize(self, NROWS: int, NCOLS: int) -> None: ...
    def unsetAll(self, row: int, col: int, label_idx: int) -> None: ...
    def unsetLabel(self, *args, **kwargs) -> Any: ...
    @overload
    def writeToStream(self, out: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
    @overload
    def writeToStream(classmrpt) -> void: ...
    @property
    def BITFIELD_BYTES(self) -> int: ...

class TRangeImageFilter:
    fp: TRangeImageFilterParams
    @overload
    def __init__(self, filter_params: TRangeImageFilterParams) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TRangeImageFilter) -> None: ...
    def do_range_filter(self, r: int, c: int, D: float) -> bool: ...

class TRangeImageFilterParams:
    mark_invalid_ranges: bool
    rangeCheckBetween: bool
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TRangeImageFilterParams) -> None: ...

class TStereoImageFeatures:
    ID: int
    pixels: Tuple[mrpt.pymrpt.mrpt.img.TPixelCoordf,mrpt.pymrpt.mrpt.img.TPixelCoordf]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TStereoImageFeatures) -> None: ...
    def assign(self) -> TStereoImageFeatures: ...

class VelodyneCalibration:
    class PerLaserCalib:
        azimuthCorrection: float
        cosVertCorrection: float
        cosVertOffsetCorrection: float
        distanceCorrection: float
        horizontalOffsetCorrection: float
        sinVertCorrection: float
        sinVertOffsetCorrection: float
        verticalCorrection: float
        verticalOffsetCorrection: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: VelodyneCalibration.PerLaserCalib) -> None: ...
        def assign(self) -> VelodyneCalibration.PerLaserCalib: ...
    laser_corrections: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VelodyneCalibration) -> None: ...
    def LoadDefaultCalibration(self, *args, **kwargs) -> Any: ...
    def assign(self) -> VelodyneCalibration: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    @overload
    def loadFromXMLFile(self, velodyne_calibration_xml_filename: str) -> bool: ...
    @overload
    def loadFromXMLFile(conststd) -> bool: ...
    @overload
    def loadFromXMLText(self, xml_file_contents: str) -> bool: ...
    @overload
    def loadFromXMLText(conststd) -> bool: ...
    @overload
    def loadFromYAMLFile(self, velodyne_calib_yaml_filename: str) -> bool: ...
    @overload
    def loadFromYAMLFile(conststd) -> bool: ...
    @overload
    def loadFromYAMLText(self, yaml_file_contents: str) -> bool: ...
    @overload
    def loadFromYAMLText(conststd) -> bool: ...

class VisualizationParameters:
    axisLimits: float
    axisTickFrequency: float
    axisTickTextSize: float
    colorFromRGBimage: bool
    colorMap: mrpt.pymrpt.mrpt.img.TColormap
    colorizeByAxis: int
    drawSensorPose: bool
    invertColorMapping: bool
    onlyPointsWithColor: bool
    pointSize: float
    points2DscansColor: mrpt.pymrpt.mrpt.img.TColor
    sensorPoseScale: float
    showAxis: bool
    showPointsIn2Dscans: bool
    showSurfaceIn2Dscans: bool
    surface2DscansColor: mrpt.pymrpt.mrpt.img.TColor
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VisualizationParameters) -> None: ...
    def assign(self) -> VisualizationParameters: ...
    @overload
    def load_from_ini_file(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def load_from_ini_file(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def load_from_ini_file(constclassmrpt, conststd) -> void: ...
    @overload
    def save_to_ini_file(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def save_to_ini_file(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def save_to_ini_file(classmrpt, conststd) -> void: ...

def format_externals_filename(*args, **kwargs) -> Any: ...
@overload
def obs2Dscan_to_viz(obs: CObservation2DRangeScan, p: VisualizationParameters, out: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
@overload
def obs2Dscan_to_viz(constclassstd, conststructmrpt, classmrpt) -> void: ...
@overload
def obs3Dscan_to_viz(obs: CObservation3DRangeScan, p: VisualizationParameters, out: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
@overload
def obs3Dscan_to_viz(constclassstd, conststructmrpt, classmrpt) -> void: ...
@overload
def obsPointCloud_to_viz(obs: CObservationPointCloud, p: VisualizationParameters, out: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
@overload
def obsPointCloud_to_viz(constclassstd, conststructmrpt, classmrpt) -> void: ...
@overload
def obsRotatingScan_to_viz(obs: CObservationRotatingScan, p: VisualizationParameters, out: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
@overload
def obsRotatingScan_to_viz(constclassstd, conststructmrpt, classmrpt) -> void: ...
@overload
def obsVelodyne_to_viz(obs: CObservationVelodyneScan, p: VisualizationParameters, out: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
@overload
def obsVelodyne_to_viz(constclassstd, conststructmrpt, classmrpt) -> void: ...
def obs_to_viz(*args, **kwargs) -> Any: ...
@overload
def recolorize3Dpc(pnts: mrpt.pymrpt.mrpt.opengl.CPointCloudColoured, p: VisualizationParameters) -> None: ...
@overload
def recolorize3Dpc(constclassstd, conststructmrpt) -> void: ...
