from typing import Any, ClassVar, Dict, List, Optional

from typing import overload
import mrpt.pymrpt.mrpt.config
import mrpt.pymrpt.mrpt.graphs
import mrpt.pymrpt.mrpt.img
import mrpt.pymrpt.mrpt.kinematics
import mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd
import mrpt.pymrpt.mrpt.maps
import mrpt.pymrpt.mrpt.math
import mrpt.pymrpt.mrpt.opengl
import mrpt.pymrpt.mrpt.poses
import mrpt.pymrpt.mrpt.rtti
import mrpt.pymrpt.mrpt.serialization
import mrpt.pymrpt.mrpt.system
import mrpt.pymrpt.std.chrono
COLL_BEH_BACK_AWAY: PTG_collision_behavior_t
COLL_BEH_STOP: PTG_collision_behavior_t

class CAbstractHolonomicReactiveMethod(mrpt.pymrpt.mrpt.serialization.CSerializable):
    class NavInput:
        maxObstacleDist: float
        maxRobotSpeed: float
        obstacles: List[float]
        targets: Any
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CAbstractHolonomicReactiveMethod.NavInput) -> None: ...
        def assign(self) -> CAbstractHolonomicReactiveMethod.NavInput: ...

    class NavOutput:
        desiredDirection: float
        desiredSpeed: float
        logRecord: CHolonomicLogFileRecord
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CAbstractHolonomicReactiveMethod.NavOutput) -> None: ...
        def assign(self) -> CAbstractHolonomicReactiveMethod.NavOutput: ...
    @overload
    def __init__(self, defaultCfgSectionName: str) -> None: ...
    @overload
    def __init__(self, arg0: CAbstractHolonomicReactiveMethod) -> None: ...
    def Factory(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CAbstractHolonomicReactiveMethod: ...
    @overload
    def enableApproachTargetSlowDown(self, enable: bool) -> None: ...
    @overload
    def enableApproachTargetSlowDown(bool) -> void: ...
    def getAssociatedPTG(self) -> CParameterizedTrajectoryGenerator: ...
    def getConfigFileSectionName(self) -> str: ...
    @overload
    def getTargetApproachSlowDownDistance(self) -> float: ...
    @overload
    def getTargetApproachSlowDownDistance() -> double: ...
    @overload
    def initialize(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def initialize(constclassmrpt) -> void: ...
    @overload
    def navigate(self, ni, no) -> None: ...
    @overload
    def navigate(conststructmrpt, structmrpt) -> void: ...
    @overload
    def saveConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def saveConfigFile(classmrpt) -> void: ...
    @overload
    def setAssociatedPTG(self, ptg: CParameterizedTrajectoryGenerator) -> None: ...
    @overload
    def setAssociatedPTG(classmrpt) -> void: ...
    @overload
    def setConfigFileSectionName(self, sectName: str) -> None: ...
    @overload
    def setConfigFileSectionName(conststd) -> void: ...
    @overload
    def setTargetApproachSlowDownDistance(self, dist: float) -> None: ...
    @overload
    def setTargetApproachSlowDownDistance(constdouble) -> void: ...

class CAbstractNavigator:
    class TAbstractNavigatorParams(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        alarm_seems_not_approaching_target_timeout: float
        dist_check_target_is_blocked: float
        dist_to_target_for_sending_event: float
        hysteresis_check_target_is_blocked: int
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CAbstractNavigator.TAbstractNavigatorParams) -> None: ...
        @overload
        def __init__(self, arg0: CAbstractNavigator.TAbstractNavigatorParams) -> None: ...
        def assign(self) -> CAbstractNavigator.TAbstractNavigatorParams: ...
        @overload
        def loadFromConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def saveToConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
        @overload
        def saveToConfigFile(classmrpt, conststd) -> void: ...

    class TErrorCode:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        ERR_CANNOT_REACH_TARGET: ClassVar[CAbstractNavigator.TErrorCode] = ...
        ERR_EMERGENCY_STOP: ClassVar[CAbstractNavigator.TErrorCode] = ...
        ERR_NONE: ClassVar[CAbstractNavigator.TErrorCode] = ...
        ERR_OTHER: ClassVar[CAbstractNavigator.TErrorCode] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class TErrorReason:
        error_code: CAbstractNavigator.TErrorCode
        error_msg: str
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CAbstractNavigator.TErrorReason) -> None: ...
        def assign(self) -> CAbstractNavigator.TErrorReason: ...

    class TNavigationParams(CAbstractNavigator.TNavigationParamsBase):
        target: CAbstractNavigator.TargetInfo
        def __init__(self) -> None: ...
        def getAsText(self) -> str: ...

    class TNavigationParamsBase:
        @overload
        def __init__(self, arg0: CAbstractNavigator.TNavigationParamsBase) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def assign(self) -> CAbstractNavigator.TNavigationParamsBase: ...
        def getAsText(self) -> str: ...

    class TState:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        IDLE: ClassVar[CAbstractNavigator.TState] = ...
        NAVIGATING: ClassVar[CAbstractNavigator.TState] = ...
        NAV_ERROR: ClassVar[CAbstractNavigator.TState] = ...
        SUSPENDED: ClassVar[CAbstractNavigator.TState] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class TargetInfo:
        __hash__: ClassVar[None] = ...
        targetAllowedDistance: float
        targetDesiredRelSpeed: float
        targetIsIntermediaryWaypoint: bool
        targetIsRelative: bool
        target_coords: mrpt.pymrpt.mrpt.math.TPose2D
        target_frame_id: str
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CAbstractNavigator.TargetInfo) -> None: ...
        def assign(self) -> CAbstractNavigator.TargetInfo: ...
        def getAsText(self) -> str: ...
        def __eq__(self, o: CAbstractNavigator.TargetInfo) -> bool: ...
        def __ne__(self, o: CAbstractNavigator.TargetInfo) -> bool: ...
    ERR_CANNOT_REACH_TARGET: ClassVar[CAbstractNavigator.TErrorCode] = ...
    ERR_EMERGENCY_STOP: ClassVar[CAbstractNavigator.TErrorCode] = ...
    ERR_NONE: ClassVar[CAbstractNavigator.TErrorCode] = ...
    ERR_OTHER: ClassVar[CAbstractNavigator.TErrorCode] = ...
    IDLE: ClassVar[CAbstractNavigator.TState] = ...
    NAVIGATING: ClassVar[CAbstractNavigator.TState] = ...
    NAV_ERROR: ClassVar[CAbstractNavigator.TState] = ...
    SUSPENDED: ClassVar[CAbstractNavigator.TState] = ...
    m_navProfiler: mrpt.pymrpt.mrpt.system.CTimeLogger
    params_abstract_navigator: Any
    def __init__(self, robot_interface_impl: CRobot2NavInterface) -> None: ...
    @overload
    def cancel(self) -> None: ...
    @overload
    def cancel() -> void: ...
    @overload
    def enableRethrowNavExceptions(self, enable: bool) -> None: ...
    @overload
    def enableRethrowNavExceptions(constbool) -> void: ...
    def getCurrentState(self) -> CAbstractNavigator.TState: ...
    def getDelaysTimeLogger(self) -> mrpt.pymrpt.mrpt.system.CTimeLogger: ...
    def getErrorReason(self, *args, **kwargs) -> Any: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def isRethrowNavExceptionsEnabled(self) -> bool: ...
    @overload
    def isRethrowNavExceptionsEnabled() -> bool: ...
    @overload
    def loadConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def loadConfigFile(constclassmrpt) -> void: ...
    @overload
    def navigationStep(self) -> None: ...
    @overload
    def navigationStep() -> void: ...
    @overload
    def resetNavError(self) -> None: ...
    @overload
    def resetNavError() -> void: ...
    @overload
    def resume(self) -> None: ...
    @overload
    def resume() -> void: ...
    @overload
    def saveConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def saveConfigFile(classmrpt) -> void: ...
    @overload
    def suspend(self) -> None: ...
    @overload
    def suspend() -> void: ...

class CAbstractPTGBasedReactive(CWaypointsNavigator):
    class TAbstractPTGNavigatorParams(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        enable_obstacle_filtering: bool
        evaluate_clearance: bool
        holonomic_method: str
        max_dist_for_timebased_path_prediction: float
        max_distance_predicted_actual_path: float
        min_normalized_free_space_for_ptg_continuation: float
        motion_decider_method: str
        ptg_cache_files_directory: str
        ref_distance: float
        robot_absolute_speed_limits: mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd.TVelCmdParams
        secure_distance_end: float
        secure_distance_start: float
        speedfilter_tau: float
        use_delays_model: bool
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CAbstractPTGBasedReactive.TAbstractPTGNavigatorParams) -> None: ...
        @overload
        def __init__(self, arg0: CAbstractPTGBasedReactive.TAbstractPTGNavigatorParams) -> None: ...
        def assign(self) -> CAbstractPTGBasedReactive.TAbstractPTGNavigatorParams: ...
        @overload
        def loadFromConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def saveToConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
        @overload
        def saveToConfigFile(classmrpt, conststd) -> void: ...

    class TNavigationParamsPTG(CWaypointsNavigator.TNavigationParamsWaypoints):
        restrict_PTG_indices: List[int]
        @overload
        def __init__(self, arg0: CAbstractPTGBasedReactive.TNavigationParamsPTG) -> None: ...
        @overload
        def __init__(self, arg0: CAbstractPTGBasedReactive.TNavigationParamsPTG) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def assign(self) -> CAbstractPTGBasedReactive.TNavigationParamsPTG: ...
        def getAsText(self) -> str: ...
    params_abstract_ptg_navigator: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def changeCurrentRobotSpeedLimits(self) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd.TVelCmdParams: ...
    @overload
    def enableKeepLogRecords(self) -> None: ...
    @overload
    def enableKeepLogRecords(self, enable: bool) -> None: ...
    @overload
    def enableKeepLogRecords(bool) -> void: ...
    @overload
    def enableLogFile(self, enable: bool) -> None: ...
    @overload
    def enableLogFile(bool) -> void: ...
    def enableTimeLog(self, *args, **kwargs) -> Any: ...
    def getCurrentRobotSpeedLimits(self) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd.TVelCmdParams: ...
    @overload
    def getLastLogRecord(self, o: CLogFileRecord) -> None: ...
    @overload
    def getLastLogRecord(classmrpt) -> void: ...
    def getLogFileDirectory(self) -> str: ...
    def getPTG(self, i: int) -> CParameterizedTrajectoryGenerator: ...
    @overload
    def getPTG_count(self) -> int: ...
    @overload
    def getPTG_count() -> size_t: ...
    @overload
    def getTargetApproachSlowDownDistance(self) -> float: ...
    @overload
    def getTargetApproachSlowDownDistance() -> double: ...
    def getTimeLogger(self) -> mrpt.pymrpt.mrpt.system.CTimeLogger: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def loadConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def loadConfigFile(constclassmrpt) -> void: ...
    @overload
    def saveConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def saveConfigFile(classmrpt) -> void: ...
    @overload
    def setHolonomicMethod(self, method: str, cfgBase: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def setHolonomicMethod(conststd, constclassmrpt) -> void: ...
    @overload
    def setLogFileDirectory(self, sDir: str) -> None: ...
    @overload
    def setLogFileDirectory(conststd) -> void: ...
    @overload
    def setTargetApproachSlowDownDistance(self, dist: float) -> None: ...
    @overload
    def setTargetApproachSlowDownDistance(constdouble) -> void: ...

class CHolonomicFullEval(CAbstractHolonomicReactiveMethod):
    class TOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        HYSTERESIS_SECTOR_COUNT: float
        LOG_SCORE_MATRIX: bool
        OBSTACLE_SLOW_DOWN_DISTANCE: float
        PHASE_FACTORS: List[List[int]]
        PHASE_THRESHOLDS: List[float]
        TARGET_SLOW_APPROACHING_DISTANCE: float
        TOO_CLOSE_OBSTACLE: float
        clearance_threshold_ratio: float
        factorNormalizeOrNot: List[int]
        factorWeights: List[float]
        gap_width_ratio_threshold: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CHolonomicFullEval.TOptions) -> None: ...
        @overload
        def __init__(self, arg0: CHolonomicFullEval.TOptions) -> None: ...
        def assign(self) -> CHolonomicFullEval.TOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def saveToConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def saveToConfigFile(classmrpt, conststd) -> void: ...
    options: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, INI_FILE: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def __init__(self, arg0: CHolonomicFullEval) -> None: ...
    @overload
    def __init__(self, arg0: CHolonomicFullEval) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CHolonomicFullEval: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getTargetApproachSlowDownDistance(self) -> float: ...
    @overload
    def getTargetApproachSlowDownDistance() -> double: ...
    @overload
    def initialize(self, INI_FILE: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def initialize(constclassmrpt) -> void: ...
    @overload
    def navigate(self, ni: CAbstractHolonomicReactiveMethod.NavInput, no: CAbstractHolonomicReactiveMethod.NavOutput) -> None: ...
    @overload
    def navigate(conststructmrpt, structmrpt) -> void: ...
    @overload
    def saveConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def saveConfigFile(classmrpt) -> void: ...
    @overload
    def setTargetApproachSlowDownDistance(self, dist: float) -> None: ...
    @overload
    def setTargetApproachSlowDownDistance(constdouble) -> void: ...

class CHolonomicLogFileRecord(mrpt.pymrpt.mrpt.serialization.CSerializable):
    dirs_eval: List[List[float]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CHolonomicLogFileRecord) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CHolonomicLogFileRecord: ...
    def getDirectionScores(self) -> mrpt.pymrpt.mrpt.math.CMatrixD: ...

class CHolonomicND(CAbstractHolonomicReactiveMethod):
    class TGap:
        end: int
        ini: int
        maxDistance: float
        minDistance: float
        representative_sector: int
        def __init__(self) -> None: ...

    class TOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        MAX_SECTOR_DIST_FOR_D2_PERCENT: float
        RISK_EVALUATION_DISTANCE: float
        RISK_EVALUATION_SECTORS_PERCENT: float
        TARGET_SLOW_APPROACHING_DISTANCE: float
        TOO_CLOSE_OBSTACLE: float
        WIDE_GAP_SIZE_PERCENT: float
        factorWeights: List[float]
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CHolonomicND.TOptions) -> None: ...
        @overload
        def __init__(self, arg0: CHolonomicND.TOptions) -> None: ...
        def assign(self) -> CHolonomicND.TOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def saveToConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def saveToConfigFile(classmrpt, conststd) -> void: ...

    class TSituations:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        SITUATION_NO_WAY_FOUND: ClassVar[CHolonomicND.TSituations] = ...
        SITUATION_SMALL_GAP: ClassVar[CHolonomicND.TSituations] = ...
        SITUATION_TARGET_DIRECTLY: ClassVar[CHolonomicND.TSituations] = ...
        SITUATION_WIDE_GAP: ClassVar[CHolonomicND.TSituations] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    SITUATION_NO_WAY_FOUND: ClassVar[CHolonomicND.TSituations] = ...
    SITUATION_SMALL_GAP: ClassVar[CHolonomicND.TSituations] = ...
    SITUATION_TARGET_DIRECTLY: ClassVar[CHolonomicND.TSituations] = ...
    SITUATION_WIDE_GAP: ClassVar[CHolonomicND.TSituations] = ...
    options: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, INI_FILE: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def __init__(self, arg0: CHolonomicND) -> None: ...
    @overload
    def __init__(self, arg0: CHolonomicND) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CHolonomicND: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getTargetApproachSlowDownDistance(self) -> float: ...
    @overload
    def getTargetApproachSlowDownDistance() -> double: ...
    @overload
    def initialize(self, INI_FILE: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def initialize(constclassmrpt) -> void: ...
    @overload
    def navigate(self, ni: CAbstractHolonomicReactiveMethod.NavInput, no: CAbstractHolonomicReactiveMethod.NavOutput) -> None: ...
    @overload
    def navigate(conststructmrpt, structmrpt) -> void: ...
    @overload
    def saveConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def saveConfigFile(classmrpt) -> void: ...
    @overload
    def setTargetApproachSlowDownDistance(self, dist: float) -> None: ...
    @overload
    def setTargetApproachSlowDownDistance(constdouble) -> void: ...

class CHolonomicVFF(CAbstractHolonomicReactiveMethod):
    class TOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        TARGET_ATTRACTIVE_FORCE: float
        TARGET_SLOW_APPROACHING_DISTANCE: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CHolonomicVFF.TOptions) -> None: ...
        @overload
        def __init__(self, arg0: CHolonomicVFF.TOptions) -> None: ...
        def assign(self) -> CHolonomicVFF.TOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def saveToConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def saveToConfigFile(classmrpt, conststd) -> void: ...
    options: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, INI_FILE: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def __init__(self, arg0: CHolonomicVFF) -> None: ...
    @overload
    def __init__(self, arg0: CHolonomicVFF) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CHolonomicVFF: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getTargetApproachSlowDownDistance(self) -> float: ...
    @overload
    def getTargetApproachSlowDownDistance() -> double: ...
    @overload
    def initialize(self, INI_FILE: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def initialize(constclassmrpt) -> void: ...
    @overload
    def navigate(self, ni: CAbstractHolonomicReactiveMethod.NavInput, no: CAbstractHolonomicReactiveMethod.NavOutput) -> None: ...
    @overload
    def navigate(conststructmrpt, structmrpt) -> void: ...
    @overload
    def saveConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def saveConfigFile(classmrpt) -> void: ...
    @overload
    def setTargetApproachSlowDownDistance(self, dist: float) -> None: ...
    @overload
    def setTargetApproachSlowDownDistance(constdouble) -> void: ...

class CLogFileRecord(mrpt.pymrpt.mrpt.serialization.CSerializable):
    class TInfoPerPTG:
        HLFR: CHolonomicLogFileRecord
        PTG_desc: str
        TP_Obstacles: Any
        TP_Robot: Any
        TP_Targets: Any
        clearance: ClearanceDiagram
        desiredDirection: float
        desiredSpeed: float
        evalFactors: Dict[str,float]
        evaluation: float
        ptg: CParameterizedTrajectoryGenerator
        timeForHolonomicMethod: float
        timeForTPObsTransformation: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CLogFileRecord.TInfoPerPTG) -> None: ...
        def assign(self) -> CLogFileRecord.TInfoPerPTG: ...
    WS_Obstacles: mrpt.pymrpt.mrpt.maps.CSimplePointsMap
    WS_Obstacles_original: mrpt.pymrpt.mrpt.maps.CSimplePointsMap
    WS_targets_relative: List[mrpt.pymrpt.mrpt.math.TPose2D]
    additional_debug_msgs: Dict[str,str]
    cmd_vel: mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd
    cmd_vel_original: mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd
    cur_vel: Any
    cur_vel_local: Any
    infoPerPTG: Any
    nPTGs: int
    nSelectedPTG: int
    navDynState: CParameterizedTrajectoryGenerator.TNavDynamicState
    ptg_index_NOP: int
    ptg_last_k_NOP: int
    ptg_last_navDynState: CParameterizedTrajectoryGenerator.TNavDynamicState
    relPoseSense: mrpt.pymrpt.mrpt.math.TPose2D
    relPoseVelCmd: mrpt.pymrpt.mrpt.math.TPose2D
    rel_cur_pose_wrt_last_vel_cmd_NOP: mrpt.pymrpt.mrpt.math.TPose2D
    rel_pose_PTG_origin_wrt_sense_NOP: mrpt.pymrpt.mrpt.math.TPose2D
    robotPoseLocalization: mrpt.pymrpt.mrpt.math.TPose2D
    robotPoseOdometry: mrpt.pymrpt.mrpt.math.TPose2D
    robotShape_radius: float
    robotShape_x: Any
    robotShape_y: Any
    timestamps: Dict[str,mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t]
    values: Dict[str,float]
    visuals: List[mrpt.pymrpt.mrpt.opengl.CSetOfObjects]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CLogFileRecord) -> None: ...
    @overload
    def __init__(self, arg0: CLogFileRecord) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CLogFileRecord: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...

class CLogFileRecord_FullEval(CHolonomicLogFileRecord):
    dirs_scores: mrpt.pymrpt.mrpt.math.CMatrixD
    evaluation: float
    selectedSector: int
    selectedTarget: int
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CLogFileRecord_FullEval: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def getDirectionScores(self) -> mrpt.pymrpt.mrpt.math.CMatrixD: ...

class CLogFileRecord_ND(CHolonomicLogFileRecord):
    evaluation: float
    gaps_end: List[int]
    gaps_eval: List[float]
    gaps_ini: List[int]
    riskEvaluation: float
    selectedSector: int
    situation: CHolonomicND.TSituations
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CLogFileRecord_ND) -> None: ...
    @overload
    def __init__(self, arg0: CLogFileRecord_ND) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CLogFileRecord_ND: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...

class CLogFileRecord_VFF(CHolonomicLogFileRecord):
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CLogFileRecord_VFF: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...

class CMultiObjMotionOpt_Scalarization(CMultiObjectiveMotionOptimizerBase):
    class TParams(CMultiObjectiveMotionOptimizerBase.TParamsBase):
        scalar_score_formula: str
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CMultiObjMotionOpt_Scalarization.TParams) -> None: ...
        @overload
        def __init__(self, arg0: CMultiObjMotionOpt_Scalarization.TParams) -> None: ...
        def assign(self) -> CMultiObjMotionOpt_Scalarization.TParams: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def saveToConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def saveToConfigFile(classmrpt, conststd) -> void: ...
    parameters: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CMultiObjMotionOpt_Scalarization) -> None: ...
    @overload
    def __init__(self, arg0: CMultiObjMotionOpt_Scalarization) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def loadConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def loadConfigFile(constclassmrpt) -> void: ...
    @overload
    def saveConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def saveConfigFile(classmrpt) -> void: ...

class CMultiObjectiveMotionOptimizerBase(mrpt.pymrpt.mrpt.rtti.CObject):
    class TParamsBase(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        formula_score: Dict[str,str]
        movement_assert: List[str]
        scores_to_normalize: List[str]
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CMultiObjectiveMotionOptimizerBase.TParamsBase) -> None: ...
        @overload
        def __init__(self, arg0: CMultiObjectiveMotionOptimizerBase.TParamsBase) -> None: ...
        def assign(self) -> CMultiObjectiveMotionOptimizerBase.TParamsBase: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def saveToConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def saveToConfigFile(classmrpt, conststd) -> void: ...

    class TResultInfo:
        final_evaluation: List[float]
        log_entries: List[str]
        score_values: List[Dict[str,float]]
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CMultiObjectiveMotionOptimizerBase.TResultInfo) -> None: ...
        def assign(self) -> CMultiObjectiveMotionOptimizerBase.TResultInfo: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Factory(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def loadConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def loadConfigFile(constclassmrpt) -> void: ...
    @overload
    def saveConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def saveConfigFile(classmrpt) -> void: ...

class CNavigatorManualSequence(CAbstractNavigator):
    class TVelCmd:
        cmd_vel: mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CNavigatorManualSequence.TVelCmd) -> None: ...
        def assign(self) -> CNavigatorManualSequence.TVelCmd: ...
    programmed_orders: Any
    def __init__(self, react_iterf_impl: CRobot2NavInterface) -> None: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    def loadConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def navigationStep(self) -> None: ...
    @overload
    def navigationStep() -> void: ...
    @overload
    def saveConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def saveConfigFile(classmrpt) -> void: ...

class CPTG_DiffDrive_C(CPTG_DiffDrive_CollisionGridBased):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def PTG_IsIntoDomain(self, x: float, y: float) -> bool: ...
    def assign(self) -> CPTG_DiffDrive_C: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def getDescription(self) -> str: ...
    @overload
    def inverseMap_WS2TP(self, x: float, y: float, out_k: int, out_d: float) -> bool: ...
    @overload
    def inverseMap_WS2TP(self, x: float, y: float, out_k: int, out_d: float, tolerance_dist: float) -> bool: ...
    @overload
    def loadDefaultParams(self) -> None: ...
    @overload
    def loadDefaultParams() -> void: ...
    @overload
    def loadFromConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    def ptgDiffDriveSteeringFunction(self, alpha: float, t: float, x: float, y: float, phi: float, v: float, w: float) -> None: ...
    @overload
    def saveToConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    @overload
    def saveToConfigFile(classmrpt, conststd) -> void: ...

class CPTG_DiffDrive_CC(CPTG_DiffDrive_CollisionGridBased):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def PTG_IsIntoDomain(self, x: float, y: float) -> bool: ...
    def assign(self) -> CPTG_DiffDrive_CC: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def getDescription(self) -> str: ...
    @overload
    def loadDefaultParams(self) -> None: ...
    @overload
    def loadDefaultParams() -> void: ...
    @overload
    def loadFromConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    def ptgDiffDriveSteeringFunction(self, alpha: float, t: float, x: float, y: float, phi: float, v: float, w: float) -> None: ...
    @overload
    def saveToConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    @overload
    def saveToConfigFile(classmrpt, conststd) -> void: ...

class CPTG_DiffDrive_CCS(CPTG_DiffDrive_CollisionGridBased):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def PTG_IsIntoDomain(self, x: float, y: float) -> bool: ...
    def assign(self) -> CPTG_DiffDrive_CCS: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def getDescription(self) -> str: ...
    @overload
    def loadDefaultParams(self) -> None: ...
    @overload
    def loadDefaultParams() -> void: ...
    @overload
    def loadFromConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    def ptgDiffDriveSteeringFunction(self, alpha: float, t: float, x: float, y: float, phi: float, v: float, w: float) -> None: ...
    @overload
    def saveToConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    @overload
    def saveToConfigFile(classmrpt, conststd) -> void: ...

class CPTG_DiffDrive_CS(CPTG_DiffDrive_CollisionGridBased):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def PTG_IsIntoDomain(self, x: float, y: float) -> bool: ...
    def assign(self) -> CPTG_DiffDrive_CS: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def getDescription(self) -> str: ...
    @overload
    def loadDefaultParams(self) -> None: ...
    @overload
    def loadDefaultParams() -> void: ...
    @overload
    def loadFromConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    def ptgDiffDriveSteeringFunction(self, alpha: float, t: float, x: float, y: float, phi: float, v: float, w: float) -> None: ...
    @overload
    def saveToConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    @overload
    def saveToConfigFile(classmrpt, conststd) -> void: ...

class CPTG_DiffDrive_CollisionGridBased(CPTG_RobotShape_Polygonal):
    def __init__(self, *args, **kwargs) -> None: ...
    def assign(self) -> CPTG_DiffDrive_CollisionGridBased: ...
    @overload
    def directionToMotionCommand(self, k: int) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd: ...
    @overload
    def directionToMotionCommand() -> Any: ...
    @overload
    def getMaxAngVel(self) -> float: ...
    @overload
    def getMaxAngVel() -> double: ...
    @overload
    def getMaxLinVel(self) -> float: ...
    @overload
    def getMaxLinVel() -> double: ...
    @overload
    def getMax_V(self) -> float: ...
    @overload
    def getMax_V() -> double: ...
    @overload
    def getMax_W(self) -> float: ...
    @overload
    def getMax_W() -> double: ...
    @overload
    def getPathDist(self, k: int, step: int) -> float: ...
    @overload
    def getPathDist(uint16_t, uint32_t) -> double: ...
    def getPathPose(self, k: int, step: int) -> mrpt.pymrpt.mrpt.math.TPose2D: ...
    @overload
    def getPathStepCount(self, k: int) -> int: ...
    @overload
    def getPathStepCount(uint16_t) -> size_t: ...
    @overload
    def getPathStepDuration(self) -> float: ...
    @overload
    def getPathStepDuration() -> double: ...
    def getPathStepForDist(self, k: int, dist: float, out_step: int) -> bool: ...
    def getSupportedKinematicVelocityCommand(self) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd: ...
    @overload
    def inverseMap_WS2TP(self, x: float, y: float, out_k: int, out_d: float) -> bool: ...
    @overload
    def inverseMap_WS2TP(self, x: float, y: float, out_k: int, out_d: float, tolerance_dist: float) -> bool: ...
    @overload
    def inverseMap_WS2TP() -> Any: ...
    @overload
    def onNewNavDynamicState(self) -> None: ...
    @overload
    def onNewNavDynamicState() -> void: ...
    def ptgDiffDriveSteeringFunction(self, alpha: float, t: float, x: float, y: float, phi: float, v: float, w: float) -> None: ...
    @overload
    def setRefDistance(self, refDist: float) -> None: ...
    @overload
    def setRefDistance(constdouble) -> void: ...
    def updateTPObstacleSingle(self, ox: float, oy: float, k: int, tp_obstacle_k: float) -> None: ...

class CPTG_DiffDrive_alpha(CPTG_DiffDrive_CollisionGridBased):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPTG_DiffDrive_alpha: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def getDescription(self) -> str: ...
    @overload
    def loadDefaultParams(self) -> None: ...
    @overload
    def loadDefaultParams() -> void: ...
    @overload
    def loadFromConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    def ptgDiffDriveSteeringFunction(self, alpha: float, t: float, x: float, y: float, phi: float, v: float, w: float) -> None: ...
    @overload
    def saveToConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    @overload
    def saveToConfigFile(classmrpt, conststd) -> void: ...

class CPTG_Holo_Blend(CPTG_RobotShape_Circular):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    @overload
    def __init__(self, arg0: CPTG_Holo_Blend) -> None: ...
    @overload
    def __init__(self, arg0: CPTG_Holo_Blend) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def PTG_IsIntoDomain(self, x: float, y: float) -> bool: ...
    def assign(self) -> CPTG_Holo_Blend: ...
    def calc_trans_distance_t_below_Tramp(self, *args, **kwargs) -> Any: ...
    def calc_trans_distance_t_below_Tramp_abc(self, *args, **kwargs) -> Any: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def directionToMotionCommand(self, k: int) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd: ...
    def getDescription(self) -> str: ...
    @overload
    def getMaxAngVel(self) -> float: ...
    @overload
    def getMaxAngVel() -> double: ...
    @overload
    def getMaxLinVel(self) -> float: ...
    @overload
    def getMaxLinVel() -> double: ...
    @overload
    def getPathDist(self, k: int, step: int) -> float: ...
    @overload
    def getPathDist(uint16_t, uint32_t) -> double: ...
    def getPathPose(self, k: int, step: int) -> mrpt.pymrpt.mrpt.math.TPose2D: ...
    @overload
    def getPathStepCount(self, k: int) -> int: ...
    @overload
    def getPathStepCount(uint16_t) -> size_t: ...
    @overload
    def getPathStepDuration(self) -> float: ...
    @overload
    def getPathStepDuration() -> double: ...
    def getPathStepForDist(self, k: int, dist: float, out_step: int) -> bool: ...
    def getSupportedKinematicVelocityCommand(self) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd: ...
    @overload
    def inverseMap_WS2TP(self, x: float, y: float, out_k: int, out_d: float) -> bool: ...
    @overload
    def inverseMap_WS2TP(self, x: float, y: float, out_k: int, out_d: float, tolerance_dist: float) -> bool: ...
    @overload
    def loadDefaultParams(self) -> None: ...
    @overload
    def loadDefaultParams() -> void: ...
    @overload
    def loadFromConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    @overload
    def maxTimeInVelCmdNOP(self, path_k: int) -> float: ...
    @overload
    def maxTimeInVelCmdNOP(int) -> double: ...
    @overload
    def onNewNavDynamicState(self) -> None: ...
    @overload
    def onNewNavDynamicState() -> void: ...
    @overload
    def saveToConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    @overload
    def saveToConfigFile(classmrpt, conststd) -> void: ...
    @overload
    def supportVelCmdNOP(self) -> bool: ...
    @overload
    def supportVelCmdNOP() -> bool: ...
    def updateTPObstacleSingle(self, ox: float, oy: float, k: int, tp_obstacle_k: float) -> None: ...

class CPTG_RobotShape_Circular(CParameterizedTrajectoryGenerator):
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def add_robotShape_to_setOfLines(self, gl_shape: mrpt.pymrpt.mrpt.opengl.CSetOfLines) -> None: ...
    @overload
    def add_robotShape_to_setOfLines(self, gl_shape: mrpt.pymrpt.mrpt.opengl.CSetOfLines, origin: mrpt.pymrpt.mrpt.poses.CPose2D) -> None: ...
    @overload
    def add_robotShape_to_setOfLines(classmrpt, constclassmrpt) -> void: ...
    def assign(self) -> CPTG_RobotShape_Circular: ...
    def evalClearanceToRobotShape(self, ox: float, oy: float) -> float: ...
    @overload
    def getMaxRobotRadius(self) -> float: ...
    @overload
    def getMaxRobotRadius() -> double: ...
    @overload
    def getRobotShapeRadius(self) -> float: ...
    @overload
    def getRobotShapeRadius() -> double: ...
    def isPointInsideRobotShape(self, x: float, y: float) -> bool: ...
    def setRobotShapeRadius(self, robot_radius: float) -> None: ...
    def static_add_robotShape_to_setOfLines(self, *args, **kwargs) -> Any: ...

class CPTG_RobotShape_Polygonal(CParameterizedTrajectoryGenerator):
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def add_robotShape_to_setOfLines(self, gl_shape: mrpt.pymrpt.mrpt.opengl.CSetOfLines) -> None: ...
    @overload
    def add_robotShape_to_setOfLines(self, gl_shape: mrpt.pymrpt.mrpt.opengl.CSetOfLines, origin: mrpt.pymrpt.mrpt.poses.CPose2D) -> None: ...
    @overload
    def add_robotShape_to_setOfLines(classmrpt, constclassmrpt) -> void: ...
    def assign(self) -> CPTG_RobotShape_Polygonal: ...
    def evalClearanceToRobotShape(self, ox: float, oy: float) -> float: ...
    @overload
    def getMaxRobotRadius(self) -> float: ...
    @overload
    def getMaxRobotRadius() -> double: ...
    def getRobotShape(self) -> mrpt.pymrpt.mrpt.math.CPolygon: ...
    def isPointInsideRobotShape(self, x: float, y: float) -> bool: ...
    def setRobotShape(self, robotShape: mrpt.pymrpt.mrpt.math.CPolygon) -> None: ...
    def static_add_robotShape_to_setOfLines(self, *args, **kwargs) -> Any: ...

class CParameterizedTrajectoryGenerator(mrpt.pymrpt.mrpt.serialization.CSerializable, mrpt.pymrpt.mrpt.config.CLoadableOptions):
    class TNavDynamicState:
        __hash__: ClassVar[None] = ...
        curVelLocal: Any
        relTarget: mrpt.pymrpt.mrpt.math.TPose2D
        targetRelSpeed: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CParameterizedTrajectoryGenerator.TNavDynamicState) -> None: ...
        def assign(self) -> CParameterizedTrajectoryGenerator.TNavDynamicState: ...
        @overload
        def readFromStream(self, in: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def readFromStream(classmrpt) -> void: ...
        @overload
        def writeToStream(self, out: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def writeToStream(classmrpt) -> void: ...
        def __eq__(self, o: CParameterizedTrajectoryGenerator.TNavDynamicState) -> bool: ...
        def __ne__(self, o: CParameterizedTrajectoryGenerator.TNavDynamicState) -> bool: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Alpha2index(self, *args, **kwargs) -> Any: ...
    def COLLISION_BEHAVIOR(self, *args, **kwargs) -> Any: ...
    def CreatePTG(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def Index2alpha(self, *args, **kwargs) -> Any: ...
    def OUTPUT_DEBUG_PATH_PREFIX(self, *args, **kwargs) -> Any: ...
    def PTG_IsIntoDomain(self, x: float, y: float) -> bool: ...
    @overload
    def add_robotShape_to_setOfLines(self, gl_shape: mrpt.pymrpt.mrpt.opengl.CSetOfLines) -> None: ...
    @overload
    def add_robotShape_to_setOfLines(self, gl_shape: mrpt.pymrpt.mrpt.opengl.CSetOfLines, origin: mrpt.pymrpt.mrpt.poses.CPose2D) -> None: ...
    @overload
    def add_robotShape_to_setOfLines(classmrpt, constclassmrpt) -> void: ...
    @overload
    def alpha2index(self, alpha: float) -> int: ...
    @overload
    def alpha2index(double) -> uint16_t: ...
    def assign(self) -> CParameterizedTrajectoryGenerator: ...
    @overload
    def debugDumpInFiles(self, ptg_name: str) -> bool: ...
    @overload
    def debugDumpInFiles(conststd) -> bool: ...
    @overload
    def deinitialize(self) -> None: ...
    @overload
    def deinitialize() -> void: ...
    def directionToMotionCommand(self, k: int) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd: ...
    @overload
    def evalClearanceSingleObstacle(self, ox: float, oy: float, k: int, inout_realdist2clearance: Dict[float,float]) -> None: ...
    @overload
    def evalClearanceSingleObstacle(self, ox: float, oy: float, k: int, inout_realdist2clearance: Dict[float,float], treat_as_obstacle: bool) -> None: ...
    def evalClearanceToRobotShape(self, ox: float, oy: float) -> float: ...
    @overload
    def evalPathRelativePriority(self, k: int, target_distance: float) -> float: ...
    @overload
    def evalPathRelativePriority(uint16_t, double) -> double: ...
    @overload
    def getActualUnloopedPathLength(self, k: int) -> float: ...
    @overload
    def getActualUnloopedPathLength(uint16_t) -> double: ...
    @overload
    def getAlphaValuesCount(self) -> int: ...
    @overload
    def getAlphaValuesCount() -> uint16_t: ...
    @overload
    def getClearanceDecimatedPaths(self) -> int: ...
    @overload
    def getClearanceDecimatedPaths() -> unsignedint: ...
    @overload
    def getClearanceStepCount(self) -> int: ...
    @overload
    def getClearanceStepCount() -> unsignedint: ...
    def getCurrentNavDynamicState(self, *args, **kwargs) -> Any: ...
    def getDescription(self) -> str: ...
    @overload
    def getMaxAngVel(self) -> float: ...
    @overload
    def getMaxAngVel() -> double: ...
    @overload
    def getMaxLinVel(self) -> float: ...
    @overload
    def getMaxLinVel() -> double: ...
    @overload
    def getMaxRobotRadius(self) -> float: ...
    @overload
    def getMaxRobotRadius() -> double: ...
    @overload
    def getPathCount(self) -> int: ...
    @overload
    def getPathCount() -> uint16_t: ...
    @overload
    def getPathDist(self, k: int, step: int) -> float: ...
    @overload
    def getPathDist(uint16_t, uint32_t) -> double: ...
    def getPathPose(self, k: int, step: int) -> mrpt.pymrpt.mrpt.math.TPose2D: ...
    @overload
    def getPathStepCount(self, k: int) -> int: ...
    @overload
    def getPathStepCount(uint16_t) -> size_t: ...
    @overload
    def getPathStepDuration(self) -> float: ...
    @overload
    def getPathStepDuration() -> double: ...
    def getPathStepForDist(self, k: int, dist: float, out_step: int) -> bool: ...
    def getPathTwist(self, *args, **kwargs) -> Any: ...
    @overload
    def getRefDistance(self) -> float: ...
    @overload
    def getRefDistance() -> double: ...
    @overload
    def getScorePriority(self) -> float: ...
    @overload
    def getScorePriority() -> double: ...
    def getSupportedKinematicVelocityCommand(self) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd: ...
    @overload
    def index2alpha(self, k: int) -> float: ...
    @overload
    def index2alpha(uint16_t) -> double: ...
    @overload
    def initClearanceDiagram(self, cd: ClearanceDiagram) -> None: ...
    @overload
    def initClearanceDiagram(classmrpt) -> void: ...
    def initTPObstacleSingle(self, k: int, TP_Obstacle_k: float) -> None: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize(self, cacheFilename: str) -> None: ...
    @overload
    def initialize(self, cacheFilename: str, verbose: bool) -> None: ...
    @overload
    def initialize(conststd, constbool) -> void: ...
    @overload
    def inverseMap_WS2TP(self, x: float, y: float, out_k: int, out_normalized_d: float) -> bool: ...
    @overload
    def inverseMap_WS2TP(self, x: float, y: float, out_k: int, out_normalized_d: float, tolerance_dist: float) -> bool: ...
    @overload
    def isBijectiveAt(self, k: int, step: int) -> bool: ...
    @overload
    def isBijectiveAt(uint16_t, uint32_t) -> bool: ...
    @overload
    def isInitialized(self) -> bool: ...
    @overload
    def isInitialized() -> bool: ...
    def isPointInsideRobotShape(self, x: float, y: float) -> bool: ...
    @overload
    def loadDefaultParams(self) -> None: ...
    @overload
    def loadDefaultParams() -> void: ...
    def loadFromConfigFile(self, *args, **kwargs) -> Any: ...
    @overload
    def maxTimeInVelCmdNOP(self, path_k: int) -> float: ...
    @overload
    def maxTimeInVelCmdNOP(int) -> double: ...
    @overload
    def renderPathAsSimpleLine(self, k: int, gl_obj: mrpt.pymrpt.mrpt.opengl.CSetOfLines) -> None: ...
    @overload
    def renderPathAsSimpleLine(self, k: int, gl_obj: mrpt.pymrpt.mrpt.opengl.CSetOfLines, decimate_distance: float) -> None: ...
    @overload
    def renderPathAsSimpleLine(self, k: int, gl_obj: mrpt.pymrpt.mrpt.opengl.CSetOfLines, decimate_distance: float, max_path_distance: float) -> None: ...
    @overload
    def saveToConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSection: str) -> None: ...
    @overload
    def saveToConfigFile(classmrpt, conststd) -> void: ...
    @overload
    def setClearanceDecimatedPaths(self, num: int) -> None: ...
    @overload
    def setClearanceDecimatedPaths(constunsignedint) -> void: ...
    @overload
    def setClearanceStepCount(self, res: int) -> None: ...
    @overload
    def setClearanceStepCount(constunsignedint) -> void: ...
    @overload
    def setRefDistance(self, refDist: float) -> None: ...
    @overload
    def setRefDistance(constdouble) -> void: ...
    @overload
    def setScorePriorty(self, prior: float) -> None: ...
    @overload
    def setScorePriorty(double) -> void: ...
    @overload
    def supportSpeedAtTarget(self) -> bool: ...
    @overload
    def supportSpeedAtTarget() -> bool: ...
    @overload
    def supportVelCmdNOP(self) -> bool: ...
    @overload
    def supportVelCmdNOP() -> bool: ...
    def updateClearance(self, ox: float, oy: float, cd: ClearanceDiagram) -> None: ...
    @overload
    def updateNavDynamicState(self, newState) -> None: ...
    @overload
    def updateNavDynamicState(self, newState, force_update: bool) -> None: ...
    @overload
    def updateNavDynamicState(conststructmrpt, constbool) -> void: ...
    def updateTPObstacleSingle(self, ox: float, oy: float, k: int, tp_obstacle_k: float) -> None: ...

class CReactiveNavigationSystem(CAbstractPTGBasedReactive):
    class TReactiveNavigatorParams(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        max_obstacles_height: float
        min_obstacles_height: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CReactiveNavigationSystem.TReactiveNavigatorParams) -> None: ...
        @overload
        def __init__(self, arg0: CReactiveNavigationSystem.TReactiveNavigatorParams) -> None: ...
        def assign(self) -> CReactiveNavigationSystem.TReactiveNavigatorParams: ...
        @overload
        def loadFromConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def saveToConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
        @overload
        def saveToConfigFile(classmrpt, conststd) -> void: ...
    params_reactive_nav: Any
    @overload
    def __init__(self, arg0: CRobot2NavInterface) -> None: ...
    @overload
    def __init__(self, arg0: CRobot2NavInterface, arg1: bool) -> None: ...
    @overload
    def __init__(self, arg0: CRobot2NavInterface, arg1: bool, arg2: bool) -> None: ...
    @overload
    def __init__(self, react_iterf_impl: CRobot2NavInterface, enableConsoleOutput: bool, enableLogFile: bool, logFileDirectory: str) -> None: ...
    @overload
    def changeRobotCircularShapeRadius(self, R: float) -> None: ...
    @overload
    def changeRobotCircularShapeRadius(constdouble) -> void: ...
    @overload
    def changeRobotShape(self, shape: mrpt.pymrpt.mrpt.math.CPolygon) -> None: ...
    @overload
    def changeRobotShape(constclassmrpt) -> void: ...
    @overload
    def checkCollisionWithLatestObstacles(self, relative_robot_pose: mrpt.pymrpt.mrpt.math.TPose2D) -> bool: ...
    @overload
    def checkCollisionWithLatestObstacles(conststructmrpt) -> bool: ...
    def getPTG(self, i: int) -> CParameterizedTrajectoryGenerator: ...
    @overload
    def getPTG_count(self) -> int: ...
    @overload
    def getPTG_count() -> size_t: ...
    @overload
    def loadConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def loadConfigFile(constclassmrpt) -> void: ...
    @overload
    def saveConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def saveConfigFile(classmrpt) -> void: ...

class CReactiveNavigationSystem3D(CAbstractPTGBasedReactive):
    @overload
    def __init__(self, arg0: CRobot2NavInterface) -> None: ...
    @overload
    def __init__(self, arg0: CRobot2NavInterface, arg1: bool) -> None: ...
    @overload
    def __init__(self, arg0: CRobot2NavInterface, arg1: bool, arg2: bool) -> None: ...
    @overload
    def __init__(self, react_iterf_impl: CRobot2NavInterface, enableConsoleOutput: bool, enableLogFile: bool, logFileDirectory: str) -> None: ...
    @overload
    def changeRobotShape(self, robotShape: TRobotShape) -> None: ...
    @overload
    def changeRobotShape(structmrpt) -> void: ...
    @overload
    def checkCollisionWithLatestObstacles(self, relative_robot_pose: mrpt.pymrpt.mrpt.math.TPose2D) -> bool: ...
    @overload
    def checkCollisionWithLatestObstacles(conststructmrpt) -> bool: ...
    def getPTG(self, i: int) -> CParameterizedTrajectoryGenerator: ...
    @overload
    def getPTG_count(self) -> int: ...
    @overload
    def getPTG_count() -> size_t: ...
    @overload
    def loadConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def loadConfigFile(constclassmrpt) -> void: ...
    @overload
    def saveConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def saveConfigFile(classmrpt) -> void: ...

class CRobot2NavInterface:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CRobot2NavInterface) -> None: ...
    def assign(self) -> CRobot2NavInterface: ...
    @overload
    def changeSpeeds(self, vel_cmd: mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd) -> bool: ...
    @overload
    def changeSpeeds(constclassmrpt) -> bool: ...
    @overload
    def changeSpeedsNOP(self) -> bool: ...
    @overload
    def changeSpeedsNOP() -> bool: ...
    def getAlignCmd(self, relative_heading_radians: float) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd: ...
    def getCurrentPoseAndSpeeds(self, curPose: mrpt.pymrpt.mrpt.math.TPose2D, curVelGlobal, timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, curOdometry: mrpt.pymrpt.mrpt.math.TPose2D, frame_id: str) -> bool: ...
    def getEmergencyStopCmd(self) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd: ...
    @overload
    def getNavigationTime(self) -> float: ...
    @overload
    def getNavigationTime() -> double: ...
    def getStopCmd(self) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd: ...
    @overload
    def resetNavigationTimer(self) -> None: ...
    @overload
    def resetNavigationTimer() -> void: ...
    @overload
    def sendApparentCollisionEvent(self) -> None: ...
    @overload
    def sendApparentCollisionEvent() -> void: ...
    @overload
    def sendCannotGetCloserToBlockedTargetEvent(self) -> None: ...
    @overload
    def sendCannotGetCloserToBlockedTargetEvent() -> void: ...
    @overload
    def sendNavigationEndDueToErrorEvent(self) -> None: ...
    @overload
    def sendNavigationEndDueToErrorEvent() -> void: ...
    @overload
    def sendNavigationEndEvent(self) -> None: ...
    @overload
    def sendNavigationEndEvent() -> void: ...
    def sendNavigationStartEvent(self) -> None: ...
    @overload
    def sendNewWaypointTargetEvent(self, waypoint_index: int) -> None: ...
    @overload
    def sendNewWaypointTargetEvent(int) -> void: ...
    @overload
    def sendWaySeemsBlockedEvent(self) -> None: ...
    @overload
    def sendWaySeemsBlockedEvent() -> void: ...
    @overload
    def sendWaypointReachedEvent(self, waypoint_index: int, reached_nSkipped: bool) -> None: ...
    @overload
    def sendWaypointReachedEvent(int, bool) -> void: ...
    @overload
    def senseObstacles(self, obstacles: mrpt.pymrpt.mrpt.maps.CSimplePointsMap, timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t) -> bool: ...
    @overload
    def senseObstacles(classmrpt, mrpt) -> bool: ...
    @overload
    def startWatchdog(self, T_ms: float) -> bool: ...
    @overload
    def startWatchdog(float) -> bool: ...
    @overload
    def stop(self) -> bool: ...
    @overload
    def stop(self, isEmergencyStop: bool) -> bool: ...
    @overload
    def stop(bool) -> bool: ...
    @overload
    def stopWatchdog(self) -> bool: ...
    @overload
    def stopWatchdog() -> bool: ...

class CRobot2NavInterfaceForSimulator_DiffDriven(CRobot2NavInterface):
    @overload
    def __init__(self, simul: mrpt.pymrpt.mrpt.kinematics.CVehicleSimul_DiffDriven) -> None: ...
    @overload
    def __init__(self, arg0: CRobot2NavInterfaceForSimulator_DiffDriven) -> None: ...
    @overload
    def changeSpeeds(self, vel_cmd: mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd) -> bool: ...
    @overload
    def changeSpeeds(constclassmrpt) -> bool: ...
    def getCurrentPoseAndSpeeds(self, curPose: mrpt.pymrpt.mrpt.math.TPose2D, curVel, timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, curOdometry: mrpt.pymrpt.mrpt.math.TPose2D, frame_id: str) -> bool: ...
    def getEmergencyStopCmd(self) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd: ...
    @overload
    def getNavigationTime(self) -> float: ...
    @overload
    def getNavigationTime() -> Any: ...
    @overload
    def getNavigationTime() -> double: ...
    def getStopCmd(self) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd: ...
    @overload
    def resetNavigationTimer(self) -> None: ...
    @overload
    def resetNavigationTimer() -> Any: ...
    @overload
    def resetNavigationTimer() -> void: ...
    @overload
    def stop(self, isEmergencyStop: bool) -> bool: ...
    @overload
    def stop(bool) -> bool: ...

class CRobot2NavInterfaceForSimulator_Holo(CRobot2NavInterface):
    @overload
    def __init__(self, simul: mrpt.pymrpt.mrpt.kinematics.CVehicleSimul_Holo) -> None: ...
    @overload
    def __init__(self, arg0: CRobot2NavInterfaceForSimulator_Holo) -> None: ...
    @overload
    def changeSpeeds(self, vel_cmd: mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd) -> bool: ...
    @overload
    def changeSpeeds(constclassmrpt) -> bool: ...
    def getAlignCmd(self, relative_heading_radians: float) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd: ...
    def getCurrentPoseAndSpeeds(self, curPose: mrpt.pymrpt.mrpt.math.TPose2D, curVel, timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, curOdometry: mrpt.pymrpt.mrpt.math.TPose2D, frame_id: str) -> bool: ...
    def getEmergencyStopCmd(self) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd: ...
    @overload
    def getNavigationTime(self) -> float: ...
    @overload
    def getNavigationTime() -> Any: ...
    @overload
    def getNavigationTime() -> double: ...
    def getStopCmd(self) -> mrpt.pymrpt.mrpt.kinematics.CVehicleVelCmd: ...
    @overload
    def resetNavigationTimer(self) -> None: ...
    @overload
    def resetNavigationTimer() -> Any: ...
    @overload
    def resetNavigationTimer() -> void: ...
    @overload
    def stop(self, isEmergencyStop: bool) -> bool: ...
    @overload
    def stop(bool) -> bool: ...

class CWaypointsNavigator(CAbstractNavigator):
    class TNavigationParamsWaypoints:
        multiple_targets: List[CAbstractNavigator.TargetInfo]
        @overload
        def __init__(self, arg0: CWaypointsNavigator.TNavigationParamsWaypoints) -> None: ...
        @overload
        def __init__(self, arg0: CWaypointsNavigator.TNavigationParamsWaypoints) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def assign(self) -> CWaypointsNavigator.TNavigationParamsWaypoints: ...
        def getAsText(self) -> str: ...

    class TWaypointsNavigatorParams(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        max_distance_to_allow_skip_waypoint: float
        min_timesteps_confirm_skip_waypoints: int
        multitarget_look_ahead: int
        waypoint_angle_tolerance: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CWaypointsNavigator.TWaypointsNavigatorParams) -> None: ...
        @overload
        def __init__(self, arg0: CWaypointsNavigator.TWaypointsNavigatorParams) -> None: ...
        def assign(self) -> CWaypointsNavigator.TWaypointsNavigatorParams: ...
        @overload
        def loadFromConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def saveToConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
        @overload
        def saveToConfigFile(classmrpt, conststd) -> void: ...
    params_waypoints_navigator: Any
    def __init__(self, robot_interface_impl: CRobot2NavInterface) -> None: ...
    def beginWaypointsAccess(self) -> TWaypointStatusSequence: ...
    @overload
    def cancel(self) -> None: ...
    @overload
    def cancel() -> void: ...
    @overload
    def endWaypointsAccess(self) -> None: ...
    @overload
    def endWaypointsAccess() -> void: ...
    @overload
    def getWaypointNavStatus(self, out_nav_status: TWaypointStatusSequence) -> None: ...
    @overload
    def getWaypointNavStatus(structmrpt) -> void: ...
    @overload
    def getWaypointNavStatus(self) -> TWaypointStatusSequence: ...
    @overload
    def isRelativePointReachable(self, wp_local_wrt_robot) -> bool: ...
    @overload
    def isRelativePointReachable(conststructmrpt) -> bool: ...
    @overload
    def loadConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def loadConfigFile(constclassmrpt) -> void: ...
    @overload
    def navigateWaypoints(self, nav_request: TWaypointSequence) -> None: ...
    @overload
    def navigateWaypoints(conststructmrpt) -> void: ...
    @overload
    def navigationStep(self) -> None: ...
    @overload
    def navigationStep() -> void: ...
    @overload
    def saveConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def saveConfigFile(classmrpt) -> void: ...

class ClearanceDiagram:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: ClearanceDiagram) -> None: ...
    def assign(self) -> ClearanceDiagram: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def decimated_k_to_real_k(self, k: int) -> int: ...
    @overload
    def decimated_k_to_real_k(size_t) -> size_t: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    @overload
    def getClearance(self, k: int, TPS_query_distance: float, integrate_over_path: bool) -> float: ...
    @overload
    def getClearance(uint16_t, double, bool) -> double: ...
    @overload
    def get_actual_num_paths(self) -> int: ...
    @overload
    def get_actual_num_paths() -> size_t: ...
    @overload
    def get_decimated_num_paths(self) -> int: ...
    @overload
    def get_decimated_num_paths() -> size_t: ...
    def get_path_clearance(self, actual_k: int) -> Dict[float,float]: ...
    def get_path_clearance_decimated(self, decim_k: int) -> Dict[float,float]: ...
    @overload
    def readFromStream(self, in: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
    @overload
    def readFromStream(classmrpt) -> void: ...
    @overload
    def real_k_to_decimated_k(self, k: int) -> int: ...
    @overload
    def real_k_to_decimated_k(size_t) -> size_t: ...
    def renderAs3DObject(self, mesh, min_x: float, max_x: float, min_y: float, max_y: float, cell_res: float, integrate_over_path: bool) -> None: ...
    def resize(self, actual_num_paths: int, decimated_num_paths: int) -> None: ...
    @overload
    def writeToStream(self, out: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
    @overload
    def writeToStream(classmrpt) -> void: ...

class PTG_collision_behavior_t:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    COLL_BEH_BACK_AWAY: ClassVar[PTG_collision_behavior_t] = ...
    COLL_BEH_STOP: ClassVar[PTG_collision_behavior_t] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class PlannerRRT_SE2_TPS(PlannerTPS_VirtualBase):
    class TPlannerInput(TPlannerInputTempl_mrpt_math_TPose2D_mrpt_math_TPose2D_t):
        def __init__(self) -> None: ...

    class TPlannerResult(TPlannerResultTempl_mrpt_nav_TMoveTree_mrpt_nav_TNodeSE2_TP_mrpt_nav_TMoveEdgeSE2_TP_t):
        def __init__(self) -> None: ...
    def __init__(self) -> None: ...
    @overload
    def initialize(self) -> None: ...
    @overload
    def initialize() -> void: ...
    @overload
    def loadConfig(self, cfgSource: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def loadConfig(self, cfgSource: mrpt.pymrpt.mrpt.config.CConfigFileBase, sSectionName: str) -> None: ...
    @overload
    def loadConfig(constclassmrpt, conststd) -> void: ...
    @overload
    def solve(self, pi, result) -> None: ...
    @overload
    def solve(conststructmrpt, structmrpt) -> void: ...

class PlannerSimple2D:
    minStepInReturnedPath: float
    occupancyThreshold: float
    robotRadius: float
    def __init__(self) -> None: ...
    def assign(self) -> PlannerSimple2D: ...

class PlannerTPS_VirtualBase:
    class TRenderPlannedPathOptions:
        color_goal: mrpt.pymrpt.mrpt.img.TColor
        color_ground_xy_grid: mrpt.pymrpt.mrpt.img.TColor
        color_last_edge: mrpt.pymrpt.mrpt.img.TColor
        color_local_obstacles: mrpt.pymrpt.mrpt.img.TColor
        color_normal_edge: mrpt.pymrpt.mrpt.img.TColor
        color_obstacles: mrpt.pymrpt.mrpt.img.TColor
        color_optimal_edge: mrpt.pymrpt.mrpt.img.TColor
        color_start: mrpt.pymrpt.mrpt.img.TColor
        color_vehicle: mrpt.pymrpt.mrpt.img.TColor
        draw_obstacles: bool
        draw_shape_decimation: int
        ground_xy_grid_frequency: float
        highlight_last_added_edge: bool
        highlight_path_to_node_id: int
        log_msg: str
        log_msg_position: Any
        log_msg_scale: float
        point_size_local_obstacles: int
        point_size_obstacles: int
        vehicle_line_width: float
        vehicle_shape_z: float
        width_last_edge: float
        width_normal_edge: float
        width_optimal_edge: float
        xyzcorners_scale: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: PlannerTPS_VirtualBase.TRenderPlannedPathOptions) -> None: ...
        def assign(self) -> PlannerTPS_VirtualBase.TRenderPlannedPathOptions: ...
    end_criteria: RRTEndCriteria
    params: RRTAlgorithmParams
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: PlannerTPS_VirtualBase) -> None: ...
    def assign(self) -> PlannerTPS_VirtualBase: ...
    def getProfiler(self) -> mrpt.pymrpt.mrpt.system.CTimeLogger: ...

class PoseDistanceMetric_mrpt_nav_TNodeSE2_TP_t:
    def __init__(self, ptg: CParameterizedTrajectoryGenerator) -> None: ...
    def cannotBeNearerThan(self, a: TNodeSE2_TP, b: TNodeSE2_TP, d: float) -> bool: ...
    def distance(self, src: TNodeSE2_TP, dst: TNodeSE2_TP) -> float: ...

class PoseDistanceMetric_mrpt_nav_TNodeSE2_t:
    def __init__(self) -> None: ...
    def cannotBeNearerThan(self, a: TNodeSE2, b: TNodeSE2, d: float) -> bool: ...
    def distance(self, a: TNodeSE2, b: TNodeSE2) -> float: ...

class RRTAlgorithmParams:
    goalBias: float
    maxLength: float
    minAngBetweenNewNodes: float
    minDistanceBetweenNewNodes: float
    ptg_cache_files_directory: str
    ptg_verbose: bool
    robot_shape: mrpt.pymrpt.mrpt.math.TPolygon2D
    robot_shape_circular_radius: float
    save_3d_log_freq: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: RRTAlgorithmParams) -> None: ...
    def assign(self) -> RRTAlgorithmParams: ...

class RRTEndCriteria:
    acceptedAngToTarget: float
    acceptedDistToTarget: float
    maxComputationTime: float
    minComputationTime: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: RRTEndCriteria) -> None: ...
    def assign(self) -> RRTEndCriteria: ...

class TCPoint:
    dist: float
    phi: float
    t: float
    v: float
    w: float
    x: float
    y: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x_: float, y_: float, phi_: float, t_: float, dist_: float, v_: float, w_: float) -> None: ...

class TCandidateMovementPTG:
    direction: float
    props: Dict[str,float]
    speed: float
    starting_robot_dir: float
    starting_robot_dist: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TCandidateMovementPTG) -> None: ...
    def assign(self) -> TCandidateMovementPTG: ...

class TMoveEdgeSE2_TP:
    cost: float
    end_state: mrpt.pymrpt.mrpt.math.TPose2D
    parent_id: int
    ptg_K: int
    ptg_dist: float
    ptg_index: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, parent_id_: int, end_pose_: mrpt.pymrpt.mrpt.math.TPose2D) -> None: ...

class TMoveTree_mrpt_nav_TNodeSE2_TP_mrpt_nav_TMoveEdgeSE2_TP_mrpt_containers_map_traits_map_as_vector_t(mrpt.pymrpt.mrpt.graphs.CDirectedTree_mrpt_nav_TMoveEdgeSE2_TP_t):
    edges_to_children: Any
    root: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TMoveTree_mrpt_nav_TNodeSE2_TP_mrpt_nav_TMoveEdgeSE2_TP_mrpt_containers_map_traits_map_as_vector_t) -> None: ...
    @overload
    def assign(self) -> TMoveTree_mrpt_nav_TNodeSE2_TP_mrpt_nav_TMoveEdgeSE2_TP_mrpt_containers_map_traits_map_as_vector_t: ...
    @overload
    def assign(self) -> mrpt.pymrpt.mrpt.graphs.CDirectedTree_mrpt_nav_TMoveEdgeSE2_TP_t: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def getAsTextDescription(self) -> str: ...
    def getNextFreeNodeID(self) -> int: ...
    @overload
    def insertNode(self, node_id: int, node_data) -> None: ...
    @overload
    def insertNode(constunsignedlong, conststructmrpt) -> void: ...
    def insertNodeAndEdge(self, parent_id: int, new_child_id: int, new_child_node_data, new_edge_data) -> None: ...

class TNodeSE2:
    state: mrpt.pymrpt.mrpt.math.TPose2D
    @overload
    def __init__(self, state_: mrpt.pymrpt.mrpt.math.TPose2D) -> None: ...
    @overload
    def __init__(self) -> None: ...

class TNodeSE2_TP:
    state: mrpt.pymrpt.mrpt.math.TPose2D
    @overload
    def __init__(self, state_: mrpt.pymrpt.mrpt.math.TPose2D) -> None: ...
    @overload
    def __init__(self) -> None: ...

class TPlannerInputTempl_mrpt_math_TPose2D_mrpt_math_TPose2D_t:
    goal_pose: mrpt.pymrpt.mrpt.math.TPose2D
    obstacles_points: mrpt.pymrpt.mrpt.maps.CSimplePointsMap
    start_pose: mrpt.pymrpt.mrpt.math.TPose2D
    world_bbox_max: mrpt.pymrpt.mrpt.math.TPose2D
    world_bbox_min: mrpt.pymrpt.mrpt.math.TPose2D
    @overload
    def __init__(self, arg0: TPlannerInputTempl_mrpt_math_TPose2D_mrpt_math_TPose2D_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> TPlannerInputTempl_mrpt_math_TPose2D_mrpt_math_TPose2D_t: ...

class TPlannerResultTempl_mrpt_nav_TMoveTree_mrpt_nav_TNodeSE2_TP_mrpt_nav_TMoveEdgeSE2_TP_t:
    acceptable_goal_node_ids: Set[int]
    best_goal_node_id: int
    computation_time: float
    goal_distance: float
    move_tree: Any
    path_cost: float
    success: bool
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TPlannerResultTempl_mrpt_nav_TMoveTree_mrpt_nav_TNodeSE2_TP_mrpt_nav_TMoveEdgeSE2_TP_t) -> None: ...
    def assign(self) -> TPlannerResultTempl_mrpt_nav_TMoveTree_mrpt_nav_TNodeSE2_TP_mrpt_nav_TMoveEdgeSE2_TP_t: ...

class TRobotShape:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TRobotShape) -> None: ...
    def assign(self) -> TRobotShape: ...
    @overload
    def getHeight(self, level: int) -> float: ...
    @overload
    def getHeight(size_t) -> double: ...
    @overload
    def getRadius(self, level: int) -> float: ...
    @overload
    def getRadius(size_t) -> double: ...
    def polygon(self, level: int) -> mrpt.pymrpt.mrpt.math.CPolygon: ...
    @overload
    def resize(self, num_levels: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def setHeight(self, level: int, h: float) -> None: ...
    @overload
    def setHeight(size_t, double) -> void: ...
    @overload
    def setRadius(self, level: int, r: float) -> None: ...
    @overload
    def setRadius(size_t, double) -> void: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class TWaypoint:
    allow_skip: bool
    allowed_distance: float
    speed_ratio: float
    target: Any
    target_frame_id: str
    target_heading: Optional[float]
    user_data: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TWaypoint) -> None: ...
    def assign(self) -> TWaypoint: ...
    def getAsText(self) -> str: ...
    @overload
    def isValid(self) -> bool: ...
    @overload
    def isValid() -> bool: ...

class TWaypointSequence:
    waypoints: List[TWaypoint]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TWaypointSequence) -> None: ...
    def assign(self) -> TWaypointSequence: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    @overload
    def getAsOpenglVisualization(self, obj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getAsOpenglVisualization(self, obj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects, params: TWaypointsRenderingParams) -> None: ...
    @overload
    def getAsOpenglVisualization(classmrpt, conststructmrpt) -> void: ...
    def getAsText(self) -> str: ...
    @overload
    def load(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
    @overload
    def load(constclassmrpt, conststd) -> void: ...
    @overload
    def save(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
    @overload
    def save(classmrpt, conststd) -> void: ...

class TWaypointStatus(TWaypoint):
    counter_seen_reachable: int
    reached: bool
    skipped: bool
    timestamp_reach: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t
    user_status_data: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TWaypointStatus) -> None: ...
    @overload
    def assign(self, wp: TWaypoint) -> TWaypointStatus: ...
    @overload
    def assign(self) -> TWaypointStatus: ...
    def getAsText(self) -> str: ...

class TWaypointStatusSequence:
    final_goal_reached: bool
    last_robot_pose: mrpt.pymrpt.mrpt.math.TPose2D
    timestamp_nav_started: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t
    waypoint_index_current_goal: int
    waypoints: List[TWaypointStatus]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TWaypointStatusSequence) -> None: ...
    def assign(self) -> TWaypointStatusSequence: ...
    @overload
    def getAsOpenglVisualization(self, obj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getAsOpenglVisualization(self, obj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects, params: TWaypointsRenderingParams) -> None: ...
    @overload
    def getAsOpenglVisualization(classmrpt, conststructmrpt) -> void: ...
    def getAsText(self) -> str: ...

class TWaypointsRenderingParams:
    color_current_goal: mrpt.pymrpt.mrpt.img.TColor
    color_reached: mrpt.pymrpt.mrpt.img.TColor
    color_regular: mrpt.pymrpt.mrpt.img.TColor
    heading_arrow_len: float
    inner_radius: float
    inner_radius_non_skippable: float
    inner_radius_reached: float
    outer_radius: float
    outer_radius_non_skippable: float
    outer_radius_reached: float
    show_labels: bool
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TWaypointsRenderingParams) -> None: ...
    def assign(self) -> TWaypointsRenderingParams: ...

def collision_free_dist_arc_circ_robot(arc_radius: float, robot_radius: float, obstacle, out_col_dist: float) -> bool: ...
def collision_free_dist_segment_circ_robot(p_start, p_end, robot_radius: float, obstacle, out_col_dist: float) -> bool: ...
