from typing import Any, ClassVar, List, Optional, Tuple

from typing import overload
import mrpt.pymrpt.mrpt
import mrpt.pymrpt.mrpt.bayes
import mrpt.pymrpt.mrpt.bayes.CParticleFilter
import mrpt.pymrpt.mrpt.config
import mrpt.pymrpt.mrpt.containers
import mrpt.pymrpt.mrpt.img
import mrpt.pymrpt.mrpt.math
import mrpt.pymrpt.mrpt.obs
import mrpt.pymrpt.mrpt.opengl
import mrpt.pymrpt.mrpt.poses
import mrpt.pymrpt.mrpt.rtti
import mrpt.pymrpt.mrpt.serialization
import mrpt.pymrpt.mrpt.slam
import mrpt.pymrpt.mrpt.slam.CICP
import mrpt.pymrpt.mrpt.system
import mrpt.pymrpt.mrpt.tfest
import mrpt.pymrpt.mrpt.vision
import mrpt.pymrpt.mrpt.vision.CFeatureExtraction
import mrpt.pymrpt.std.chrono

class CBeacon(mrpt.pymrpt.mrpt.poses.CPointPDF):
    class TTypePDF:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        pdfGauss: ClassVar[CBeacon.TTypePDF] = ...
        pdfMonteCarlo: ClassVar[CBeacon.TTypePDF] = ...
        pdfSOG: ClassVar[CBeacon.TTypePDF] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    pdfGauss: ClassVar[CBeacon.TTypePDF] = ...
    pdfMonteCarlo: ClassVar[CBeacon.TTypePDF] = ...
    pdfSOG: ClassVar[CBeacon.TTypePDF] = ...
    m_ID: int
    m_locationGauss: mrpt.pymrpt.mrpt.poses.CPointPDFGaussian
    m_locationMC: mrpt.pymrpt.mrpt.poses.CPointPDFParticles
    m_locationSOG: mrpt.pymrpt.mrpt.poses.CPointPDFSOG
    m_typePDF: CBeacon.TTypePDF
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CBeacon) -> None: ...
    @overload
    def __init__(self, arg0: CBeacon) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CBeacon: ...
    @overload
    def bayesianFusion(self, p1: mrpt.pymrpt.mrpt.poses.CPointPDF, p2: mrpt.pymrpt.mrpt.poses.CPointPDF) -> None: ...
    @overload
    def bayesianFusion(self, p1: mrpt.pymrpt.mrpt.poses.CPointPDF, p2: mrpt.pymrpt.mrpt.poses.CPointPDF, minMahalanobisDistToDrop: float) -> None: ...
    @overload
    def changeCoordinatesReference(self, newReferenceBase: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def copyFrom(self, o: mrpt.pymrpt.mrpt.poses.CPointPDF) -> None: ...
    @overload
    def copyFrom(constclassmrpt) -> void: ...
    @overload
    def drawSingleSample(self, outSample: mrpt.pymrpt.mrpt.poses.CPoint3D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    def generateObservationModelDistribution(self, *args, **kwargs) -> Any: ...
    def generateRingSOG(self, *args, **kwargs) -> Any: ...
    @overload
    def getAsMatlabDrawCommands(self, out_Str: List[str]) -> None: ...
    @overload
    def getAsMatlabDrawCommands(classstd) -> void: ...
    def getCovarianceAndMean(self) -> Tuple[mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t,mrpt.pymrpt.mrpt.poses.CPoint3D]: ...
    @overload
    def getMean(self, mean_point: mrpt.pymrpt.mrpt.poses.CPoint3D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    @overload
    def getVisualizationInto(self, o: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...

class CBeaconMap(CMetricMap):
    class TInsertionOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        MC_afterResamplingNoise: float
        MC_maxStdToGauss: float
        MC_numSamplesPerMeter: int
        MC_performResampling: bool
        MC_thresholdNegligible: float
        SOG_maxDistBetweenGaussians: float
        SOG_separationConstant: float
        SOG_thresholdNegligible: float
        insertAsMonteCarlo: bool
        maxElevation_deg: float
        minElevation_deg: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CBeaconMap.TInsertionOptions) -> None: ...
        @overload
        def __init__(self, arg0: CBeaconMap.TInsertionOptions) -> None: ...
        def assign(self) -> CBeaconMap.TInsertionOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TLikelihoodOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        rangeStd: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CBeaconMap.TLikelihoodOptions) -> None: ...
        @overload
        def __init__(self, arg0: CBeaconMap.TLikelihoodOptions) -> None: ...
        def assign(self) -> CBeaconMap.TLikelihoodOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TMapDefinition(CBeaconMap.TMapDefinitionBase):
        insertionOpts: CBeaconMap.TInsertionOptions
        likelihoodOpts: CBeaconMap.TLikelihoodOptions
        def __init__(self) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...
    insertionOptions: Any
    likelihoodOptions: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CBeaconMap) -> None: ...
    @overload
    def __init__(self, arg0: CBeaconMap) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self) -> CBeaconMap: ...
    @overload
    def changeCoordinatesReference(self, newOrg: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def changeCoordinatesReference(self, newOrg: mrpt.pymrpt.mrpt.poses.CPose3D, otherMap: CBeaconMap) -> None: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def compute3DMatchingRatio(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose3D, params: TMatchingRatioParams) -> float: ...
    def determineMatching2D(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose2D, correspondences: mrpt.pymrpt.mrpt.tfest.TMatchingPairListTempl_float_t, params: TMatchingParams, extraResults: TMatchingExtraResults) -> None: ...
    def get(self, i: int) -> CBeacon: ...
    def getBeaconByID(self, id: int) -> CBeacon: ...
    @overload
    def getVisualizationInto(self, outObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    @overload
    def push_back(self, m: CBeacon) -> None: ...
    @overload
    def push_back(constclassmrpt) -> void: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    def saveToMATLABScript3D(self, *args, **kwargs) -> Any: ...
    @overload
    def saveToTextFile(self, fil: str) -> None: ...
    @overload
    def saveToTextFile(conststd) -> void: ...
    def simulateBeaconReadings(self, in_robotPose: mrpt.pymrpt.mrpt.poses.CPose3D, in_sensorLocationOnRobot: mrpt.pymrpt.mrpt.poses.CPoint3D, out_Observations) -> None: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...
    def __getitem__(self, i: int) -> CBeacon: ...

class CColouredOctoMap(COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t):
    class TColourUpdate:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        AVERAGE: ClassVar[CColouredOctoMap.TColourUpdate] = ...
        INTEGRATE: ClassVar[CColouredOctoMap.TColourUpdate] = ...
        SET: ClassVar[CColouredOctoMap.TColourUpdate] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class TMapDefinition(CColouredOctoMap.TMapDefinitionBase):
        insertionOpts: COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t.TInsertionOptions
        likelihoodOpts: COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t.TLikelihoodOptions
        resolution: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CColouredOctoMap.TMapDefinition) -> None: ...
        @overload
        def __init__(self, arg0: CColouredOctoMap.TMapDefinition) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...
    AVERAGE: ClassVar[CColouredOctoMap.TColourUpdate] = ...
    INTEGRATE: ClassVar[CColouredOctoMap.TColourUpdate] = ...
    SET: ClassVar[CColouredOctoMap.TColourUpdate] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, resolution: float) -> None: ...
    @overload
    def __init__(self, arg0: CColouredOctoMap) -> None: ...
    @overload
    def __init__(self, arg0: CColouredOctoMap) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CColouredOctoMap: ...
    @overload
    def calcNumNodes(self) -> int: ...
    @overload
    def calcNumNodes() -> size_t: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getAsOctoMapVoxels(self, gl_obj: mrpt.pymrpt.mrpt.opengl.COctoMapVoxels) -> None: ...
    @overload
    def getAsOctoMapVoxels(classmrpt) -> void: ...
    @overload
    def getClampingThresMax(self) -> float: ...
    @overload
    def getClampingThresMax() -> double: ...
    @overload
    def getClampingThresMaxLog(self) -> float: ...
    @overload
    def getClampingThresMaxLog() -> float: ...
    @overload
    def getClampingThresMin(self) -> float: ...
    @overload
    def getClampingThresMin() -> double: ...
    @overload
    def getClampingThresMinLog(self) -> float: ...
    @overload
    def getClampingThresMinLog() -> float: ...
    def getMetricMax(self, x: float, y: float, z: float) -> None: ...
    def getMetricMin(self, x: float, y: float, z: float) -> None: ...
    def getMetricSize(self, x: float, y: float, z: float) -> None: ...
    @overload
    def getNumLeafNodes(self) -> int: ...
    @overload
    def getNumLeafNodes() -> size_t: ...
    @overload
    def getOccupancyThres(self) -> float: ...
    @overload
    def getOccupancyThres() -> double: ...
    @overload
    def getOccupancyThresLog(self) -> float: ...
    @overload
    def getOccupancyThresLog() -> float: ...
    def getPointColour(self, x: float, y: float, z: float, r: int, g: int, b: int) -> bool: ...
    @overload
    def getProbHit(self) -> float: ...
    @overload
    def getProbHit() -> double: ...
    @overload
    def getProbHitLog(self) -> float: ...
    @overload
    def getProbHitLog() -> float: ...
    @overload
    def getProbMiss(self) -> float: ...
    @overload
    def getProbMiss() -> double: ...
    @overload
    def getProbMissLog(self) -> float: ...
    @overload
    def getProbMissLog() -> float: ...
    @overload
    def getResolution(self) -> float: ...
    @overload
    def getResolution() -> double: ...
    @overload
    def getTreeDepth(self) -> int: ...
    @overload
    def getTreeDepth() -> unsignedint: ...
    def getVoxelColourMethod(self) -> CColouredOctoMap.TColourUpdate: ...
    def insertRay(self, end_x: float, end_y: float, end_z: float, sensor_x: float, sensor_y: float, sensor_z: float) -> None: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    def isPointWithinOctoMap(self, x: float, y: float, z: float) -> bool: ...
    @overload
    def memoryFullGrid(self) -> int: ...
    @overload
    def memoryFullGrid() -> size_t: ...
    @overload
    def memoryUsage(self) -> int: ...
    @overload
    def memoryUsage() -> size_t: ...
    @overload
    def memoryUsageNode(self) -> int: ...
    @overload
    def memoryUsageNode() -> size_t: ...
    @overload
    def setClampingThresMax(self, thresProb: float) -> None: ...
    @overload
    def setClampingThresMax(double) -> void: ...
    @overload
    def setClampingThresMin(self, thresProb: float) -> None: ...
    @overload
    def setClampingThresMin(double) -> void: ...
    @overload
    def setOccupancyThres(self, prob: float) -> None: ...
    @overload
    def setOccupancyThres(double) -> void: ...
    @overload
    def setProbHit(self, prob: float) -> None: ...
    @overload
    def setProbHit(double) -> void: ...
    @overload
    def setProbMiss(self, prob: float) -> None: ...
    @overload
    def setProbMiss(double) -> void: ...
    @overload
    def setVoxelColourMethod(self, new_method: CColouredOctoMap.TColourUpdate) -> None: ...
    @overload
    def setVoxelColourMethod(enummrpt) -> void: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...
    def updateVoxel(self, x: float, y: float, z: float, occupied: bool) -> None: ...
    def updateVoxelColour(self, x: float, y: float, z: float, r: int, g: int, b: int) -> None: ...
    @overload
    def volume(self) -> float: ...
    @overload
    def volume() -> double: ...

class CColouredPointsMap(CPointsMap):
    class TColourOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        d_max: float
        scheme: CColouredPointsMap.TColouringMethod
        z_max: float
        z_min: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CColouredPointsMap.TColourOptions) -> None: ...
        @overload
        def __init__(self, arg0: CColouredPointsMap.TColourOptions) -> None: ...
        def assign(self) -> CColouredPointsMap.TColourOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TColouringMethod:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        cmFromHeightRelativeToSensor: ClassVar[CColouredPointsMap.TColouringMethod] = ...
        cmFromHeightRelativeToSensorGray: ClassVar[CColouredPointsMap.TColouringMethod] = ...
        cmFromHeightRelativeToSensorJet: ClassVar[CColouredPointsMap.TColouringMethod] = ...
        cmFromIntensityImage: ClassVar[CColouredPointsMap.TColouringMethod] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class TMapDefinition(CColouredPointsMap.TMapDefinitionBase):
        colourOpts: CColouredPointsMap.TColourOptions
        insertionOpts: CPointsMap.TInsertionOptions
        likelihoodOpts: CPointsMap.TLikelihoodOptions
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CColouredPointsMap.TMapDefinition) -> None: ...
        @overload
        def __init__(self, arg0: CColouredPointsMap.TMapDefinition) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...
    cmFromHeightRelativeToSensor: ClassVar[CColouredPointsMap.TColouringMethod] = ...
    cmFromHeightRelativeToSensorGray: ClassVar[CColouredPointsMap.TColouringMethod] = ...
    cmFromHeightRelativeToSensorJet: ClassVar[CColouredPointsMap.TColouringMethod] = ...
    cmFromIntensityImage: ClassVar[CColouredPointsMap.TColouringMethod] = ...
    colorScheme: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, o: CPointsMap) -> None: ...
    @overload
    def __init__(self, arg0: CColouredPointsMap) -> None: ...
    @overload
    def __init__(self, arg0: CColouredPointsMap) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def assign(self, o: CPointsMap) -> CColouredPointsMap: ...
    @overload
    def assign(self, o: CColouredPointsMap) -> CColouredPointsMap: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def colourFromObservation(self, obs: mrpt.pymrpt.mrpt.obs.CObservationImage, robotPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    def getPointColor(self, index: int, R: float, G: float, B: float) -> None: ...
    def getPointColor_fast(self, index: int, R: float, G: float, B: float) -> None: ...
    def getPointRGB(self, index: int, x: float, y: float, z: float, R: float, G: float, B: float) -> None: ...
    @overload
    def getVisualizationInto(self, outObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def hasColorPoints(self) -> bool: ...
    @overload
    def hasColorPoints() -> bool: ...
    @overload
    def insertPointFast(self, x: float, y: float) -> None: ...
    @overload
    def insertPointFast(self, x: float, y: float, z: float) -> None: ...
    @overload
    def insertPointField_color_B(self, v: float) -> None: ...
    @overload
    def insertPointField_color_B(float) -> void: ...
    @overload
    def insertPointField_color_G(self, v: float) -> None: ...
    @overload
    def insertPointField_color_G(float) -> void: ...
    @overload
    def insertPointField_color_R(self, v: float) -> None: ...
    @overload
    def insertPointField_color_R(float) -> void: ...
    def insertPointRGB(self, x: float, y: float, z: float, R: float, G: float, B: float) -> None: ...
    def reserve(self, newLength: int) -> None: ...
    @overload
    def resetPointsMinDist(self) -> None: ...
    @overload
    def resetPointsMinDist(self, defValue: float) -> None: ...
    @overload
    def resetPointsMinDist(float) -> void: ...
    @overload
    def resize(self, newLength: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def save3D_and_colour_to_text_file(self, file: str) -> bool: ...
    @overload
    def save3D_and_colour_to_text_file(conststd) -> bool: ...
    def setPointColor(self, index: int, R: float, G: float, B: float) -> None: ...
    def setPointColor_fast(self, index: int, R: float, G: float, B: float) -> None: ...
    def setPointRGB(self, index: int, x: float, y: float, z: float, R: float, G: float, B: float) -> None: ...
    @overload
    def setSize(self, newLength: int) -> None: ...
    @overload
    def setSize(size_t) -> void: ...

class CGasConcentrationGridMap2D(CRandomFieldGridMap2D):
    class TGaussianCell:
        cx: int
        cy: int
        value: float
        def __init__(self) -> None: ...

    class TGaussianWindTable:
        max_r: float
        phi_count: int
        phi_inc: float
        r_count: int
        r_inc: float
        resolution: float
        std_phi: float
        std_r: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CGasConcentrationGridMap2D.TGaussianWindTable) -> None: ...
        def assign(self) -> CGasConcentrationGridMap2D.TGaussianWindTable: ...

    class TInsertionOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions, CRandomFieldGridMap2D.TInsertionOptionsCommon):
        advectionFreq: float
        default_wind_direction: float
        default_wind_speed: float
        enose_id: int
        gasSensorLabel: str
        gasSensorType: int
        std_windNoise_mod: float
        std_windNoise_phi: float
        useWindInformation: bool
        windSensorLabel: str
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CGasConcentrationGridMap2D.TInsertionOptions) -> None: ...
        @overload
        def __init__(self, arg0: CGasConcentrationGridMap2D.TInsertionOptions) -> None: ...
        def assign(self) -> CGasConcentrationGridMap2D.TInsertionOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TMapDefinition(CGasConcentrationGridMap2D.TMapDefinitionBase):
        insertionOpts: CGasConcentrationGridMap2D.TInsertionOptions
        mapType: CRandomFieldGridMap2D.TMapRepresentation
        max_x: float
        max_y: float
        min_x: float
        min_y: float
        resolution: float
        def __init__(self) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...
    LUT: Any
    insertionOptions: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation, arg1: float, arg2: float, arg3: float, arg4: float) -> None: ...
    @overload
    def __init__(self, mapType: CRandomFieldGridMap2D.TMapRepresentation, x_min: float, x_max: float, y_min: float, y_max: float, resolution: float) -> None: ...
    @overload
    def __init__(self, arg0: CGasConcentrationGridMap2D) -> None: ...
    @overload
    def __init__(self, arg0: CGasConcentrationGridMap2D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CGasConcentrationGridMap2D: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def getAs3DObject(self, meanObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects, varObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(self, outObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def getWindAs3DObject(self, windObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getWindAs3DObject(classstd) -> void: ...
    @overload
    def increaseUncertainty(self, STD_increase_value: float) -> None: ...
    @overload
    def increaseUncertainty(constdouble) -> void: ...
    @overload
    def simulateAdvection(self, STD_increase_value: float) -> bool: ...
    @overload
    def simulateAdvection(double) -> bool: ...

class CHeightGridMap2D(CMetricMap, mrpt.pymrpt.mrpt.containers.CDynamicGrid_mrpt_maps_THeightGridmapCell_t, CHeightGridMap2D_Base):
    class TInsertionOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        colorMap: mrpt.pymrpt.mrpt.img.TColormap
        filterByHeight: bool
        z_max: float
        z_min: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CHeightGridMap2D.TInsertionOptions) -> None: ...
        @overload
        def __init__(self, arg0: CHeightGridMap2D.TInsertionOptions) -> None: ...
        def assign(self) -> CHeightGridMap2D.TInsertionOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TMapDefinition(CHeightGridMap2D.TMapDefinitionBase):
        insertionOpts: CHeightGridMap2D.TInsertionOptions
        mapType: CHeightGridMap2D.TMapRepresentation
        max_x: float
        max_y: float
        min_x: float
        min_y: float
        resolution: float
        def __init__(self) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...

    class TMapRepresentation:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        mrSimpleAverage: ClassVar[CHeightGridMap2D.TMapRepresentation] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    mrSimpleAverage: ClassVar[CHeightGridMap2D.TMapRepresentation] = ...
    insertionOptions: Any
    m_mapType: CHeightGridMap2D.TMapRepresentation
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0) -> None: ...
    @overload
    def __init__(self, arg0, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, arg0, arg1: float, arg2: float, arg3: float, arg4: float) -> None: ...
    @overload
    def __init__(self, mapType, x_min: float, x_max: float, y_min: float, y_max: float, resolution: float) -> None: ...
    @overload
    def __init__(self, arg0: CHeightGridMap2D) -> None: ...
    @overload
    def __init__(self, arg0: CHeightGridMap2D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self) -> CHeightGridMap2D: ...
    @overload
    def cell2float(self, c: THeightGridmapCell) -> float: ...
    @overload
    def cell2float(conststructmrpt) -> float: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> Any: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def compute3DMatchingRatio(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose3D, params: TMatchingRatioParams) -> float: ...
    @overload
    def countObservedCells(self) -> int: ...
    @overload
    def countObservedCells() -> size_t: ...
    @overload
    def dem_get_resolution(self) -> float: ...
    @overload
    def dem_get_resolution() -> double: ...
    @overload
    def dem_get_size_x(self) -> int: ...
    @overload
    def dem_get_size_x() -> size_t: ...
    @overload
    def dem_get_size_y(self) -> int: ...
    @overload
    def dem_get_size_y() -> size_t: ...
    def dem_get_z(self, x: float, y: float, z_out: float) -> bool: ...
    def dem_get_z_by_cell(self, cx: int, cy: int, z_out: float) -> bool: ...
    @overload
    def dem_update_map(self) -> None: ...
    @overload
    def dem_update_map() -> void: ...
    def getMapType(self) -> CHeightGridMap2D.TMapRepresentation: ...
    @overload
    def getVisualizationInto(self, outObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def insertIndividualPoint(self, x: float, y: float, z: float) -> bool: ...
    @overload
    def insertIndividualPoint(self, x: float, y: float, z: float, params: CHeightGridMap2D_Base.TPointInsertParams) -> bool: ...
    @overload
    def internal_clear(self) -> None: ...
    @overload
    def internal_clear() -> void: ...
    def internal_computeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...

class CHeightGridMap2D_Base:
    class TPointInsertParams:
        pt_z_std: float
        update_map_after_insertion: bool
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CHeightGridMap2D_Base.TPointInsertParams) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CHeightGridMap2D_Base) -> None: ...
    def assign(self) -> CHeightGridMap2D_Base: ...
    @overload
    def dem_get_resolution(self) -> float: ...
    @overload
    def dem_get_resolution() -> double: ...
    @overload
    def dem_get_size_x(self) -> int: ...
    @overload
    def dem_get_size_x() -> size_t: ...
    @overload
    def dem_get_size_y(self) -> int: ...
    @overload
    def dem_get_size_y() -> size_t: ...
    def dem_get_z(self, x: float, y: float, z_out: float) -> bool: ...
    def dem_get_z_by_cell(self, cx: int, cy: int, z_out: float) -> bool: ...
    @overload
    def dem_update_map(self) -> None: ...
    @overload
    def dem_update_map() -> void: ...
    def getMinMaxHeight(self, z_min: float, z_max: float) -> bool: ...
    @overload
    def insertIndividualPoint(self, x: float, y: float, z: float) -> bool: ...
    @overload
    def insertIndividualPoint(self, x: float, y: float, z: float, params) -> bool: ...
    def intersectLine3D(self, r1: mrpt.pymrpt.mrpt.math.TLine3D, obj: mrpt.pymrpt.mrpt.math.TObject3D) -> bool: ...

class CHeightGridMap2D_MRF(CRandomFieldGridMap2D, CHeightGridMap2D_Base):
    class TInsertionOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions, CRandomFieldGridMap2D.TInsertionOptionsCommon):
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CHeightGridMap2D_MRF.TInsertionOptions) -> None: ...
        @overload
        def __init__(self, arg0: CHeightGridMap2D_MRF.TInsertionOptions) -> None: ...
        def assign(self) -> CHeightGridMap2D_MRF.TInsertionOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TMapDefinition(CHeightGridMap2D_MRF.TMapDefinitionBase):
        insertionOpts: CHeightGridMap2D_MRF.TInsertionOptions
        mapType: CRandomFieldGridMap2D.TMapRepresentation
        max_x: float
        max_y: float
        min_x: float
        min_y: float
        resolution: float
        run_map_estimation_at_ctor: bool
        def __init__(self) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...
    insertionOptions: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation, arg1: float, arg2: float, arg3: float, arg4: float) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float) -> None: ...
    @overload
    def __init__(self, mapType: CRandomFieldGridMap2D.TMapRepresentation, x_min: float, x_max: float, y_min: float, y_max: float, resolution: float, run_first_map_estimation_now: bool) -> None: ...
    @overload
    def __init__(self, arg0: CHeightGridMap2D_MRF) -> None: ...
    @overload
    def __init__(self, arg0: CHeightGridMap2D_MRF) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CHeightGridMap2D_MRF: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def dem_get_resolution(self) -> float: ...
    @overload
    def dem_get_resolution() -> double: ...
    @overload
    def dem_get_size_x(self) -> int: ...
    @overload
    def dem_get_size_x() -> size_t: ...
    @overload
    def dem_get_size_y(self) -> int: ...
    @overload
    def dem_get_size_y() -> size_t: ...
    def dem_get_z(self, x: float, y: float, z_out: float) -> bool: ...
    def dem_get_z_by_cell(self, cx: int, cy: int, z_out: float) -> bool: ...
    @overload
    def dem_update_map(self) -> None: ...
    @overload
    def dem_update_map() -> void: ...
    def getAs3DObject(self, meanObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects, varObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    def getCommonInsertOptions(self) -> CRandomFieldGridMap2D.TInsertionOptionsCommon: ...
    @overload
    def getVisualizationInto(self, outObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def insertIndividualPoint(self, x: float, y: float, z: float) -> bool: ...
    @overload
    def insertIndividualPoint(self, x: float, y: float, z: float, params: CHeightGridMap2D_Base.TPointInsertParams) -> bool: ...
    @overload
    def internal_clear(self) -> None: ...
    @overload
    def internal_clear() -> void: ...
    def internal_computeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...

class CLandmark(mrpt.pymrpt.mrpt.serialization.CSerializable):
    ID: int
    features: Any
    normal: Any
    pose_cov_11: float
    pose_cov_12: float
    pose_cov_13: float
    pose_cov_22: float
    pose_cov_23: float
    pose_cov_33: float
    pose_mean: Any
    seenTimesCount: int
    timestampLastSeen: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CLandmark) -> None: ...
    @overload
    def __init__(self, arg0: CLandmark) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CLandmark: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def createOneFeature(self) -> None: ...
    @overload
    def createOneFeature() -> void: ...
    @overload
    def getPose(self, p: mrpt.pymrpt.mrpt.poses.CPointPDFGaussian) -> None: ...
    @overload
    def getPose(classmrpt) -> void: ...
    @overload
    def getPose(self, p: mrpt.pymrpt.mrpt.poses.CPoint3D, COV: mrpt.pymrpt.mrpt.math.CMatrixDynamic_double_t) -> None: ...
    def getType(self) -> mrpt.pymrpt.mrpt.vision.TKeyPointMethod: ...
    @overload
    def setPose(self, p: mrpt.pymrpt.mrpt.poses.CPointPDFGaussian) -> None: ...
    @overload
    def setPose(constclassmrpt) -> void: ...

class CLandmarksMap(CMetricMap):
    class TCustomSequenceLandmarks:
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CLandmarksMap.TCustomSequenceLandmarks) -> None: ...
        def assign(self) -> CLandmarksMap.TCustomSequenceLandmarks: ...
        @overload
        def clear(self) -> None: ...
        @overload
        def clear() -> void: ...
        @overload
        def erase(self, indx: int) -> None: ...
        @overload
        def erase(unsignedint) -> void: ...
        def get(self, indx: int) -> CLandmark: ...
        def getByBeaconID(self, ID: int) -> CLandmark: ...
        def getByID(self, ID: int) -> CLandmark: ...
        @overload
        def getLargestDistanceFromOrigin(self) -> float: ...
        @overload
        def getLargestDistanceFromOrigin() -> float: ...
        @overload
        def hasBeenModified(self, indx: int) -> None: ...
        @overload
        def hasBeenModified(unsignedint) -> void: ...
        @overload
        def hasBeenModifiedAll(self) -> None: ...
        @overload
        def hasBeenModifiedAll() -> void: ...
        @overload
        def isToBeModified(self, indx: int) -> None: ...
        @overload
        def isToBeModified(unsignedint) -> void: ...
        @overload
        def push_back(self, lm: CLandmark) -> None: ...
        @overload
        def push_back(constclassmrpt) -> void: ...
        @overload
        def size(self) -> int: ...
        @overload
        def size() -> size_t: ...

    class TFuseOptions:
        ellapsedTime: float
        minTimesSeen: int
        def __init__(self) -> None: ...
        def assign(self) -> CLandmarksMap.TFuseOptions: ...

    class TInsertionOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        PLOT_IMAGES: bool
        SIFTLikelihoodMethod: int
        SIFTMatching3DMethod: int
        SIFT_feat_options: mrpt.pymrpt.mrpt.vision.CFeatureExtraction.TOptions
        SIFTsLoadDistanceOfTheMean: float
        SIFTsLoadEllipsoidWidth: float
        SIFTs_epipolar_TH: float
        SIFTs_numberOfKLTKeypoints: int
        SIFTs_stdDisparity: float
        SIFTs_stdXY: float
        SIFTs_stereo_maxDepth: float
        SiftCorrRatioThreshold: float
        SiftEDDThreshold: float
        SiftLikelihoodThreshold: float
        insert_Landmarks_from_range_scans: bool
        insert_SIFTs_from_monocular_images: bool
        insert_SIFTs_from_stereo_images: bool
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CLandmarksMap.TInsertionOptions) -> None: ...
        @overload
        def __init__(self, arg0: CLandmarksMap.TInsertionOptions) -> None: ...
        def assign(self) -> CLandmarksMap.TInsertionOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TInsertionResults:
        nSiftL: int
        nSiftR: int
        def __init__(self) -> None: ...
        def assign(self) -> CLandmarksMap.TInsertionResults: ...

    class TLikelihoodOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        class TGPSOrigin:
            altitude: float
            ang: float
            latitude: float
            longitude: float
            min_sat: int
            x_shift: float
            y_shift: float
            @overload
            def __init__(self) -> None: ...
            @overload
            def __init__(self, arg0: CLandmarksMap.TLikelihoodOptions.TGPSOrigin) -> None: ...
            def assign(self) -> CLandmarksMap.TLikelihoodOptions.TGPSOrigin: ...
        GPSOrigin: Any
        GPS_sigma: float
        SIFT_feat_options: mrpt.pymrpt.mrpt.vision.CFeatureExtraction.TOptions
        SIFTnullCorrespondenceDistance: float
        SIFTs_decimation: int
        SIFTs_mahaDist_std: float
        SIFTs_sigma_descriptor_dist: float
        SIFTs_sigma_euclidean_dist: float
        beaconRangesStd: float
        beaconRangesUseObservationStd: bool
        extRobotPoseStd: float
        rangeScan2D_decimation: int
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CLandmarksMap.TLikelihoodOptions) -> None: ...
        @overload
        def __init__(self, arg0: CLandmarksMap.TLikelihoodOptions) -> None: ...
        def assign(self) -> CLandmarksMap.TLikelihoodOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TMapDefinition(CLandmarksMap.TMapDefinitionBase):
        initialBeacons: Any
        insertionOpts: CLandmarksMap.TInsertionOptions
        likelihoodOpts: CLandmarksMap.TLikelihoodOptions
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CLandmarksMap.TMapDefinition) -> None: ...
        @overload
        def __init__(self, arg0: CLandmarksMap.TMapDefinition) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...
    fuseOptions: Any
    insertionOptions: Any
    insertionResults: Any
    landmarks: Any
    likelihoodOptions: Any
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self) -> CLandmarksMap: ...
    @overload
    def auxParticleFilterCleanUp(self) -> None: ...
    @overload
    def auxParticleFilterCleanUp() -> void: ...
    @overload
    def changeCoordinatesReference(self, newOrg: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def changeCoordinatesReference(self, newOrg: mrpt.pymrpt.mrpt.poses.CPose3D, otherMap: CLandmarksMap) -> None: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def compute3DMatchingRatio(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose3D, params: TMatchingRatioParams) -> float: ...
    def computeLikelihood_RSLC_2007(self, *args, **kwargs) -> Any: ...
    @overload
    def computeMatchingWith2D(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose2D, maxDistForCorrespondence: float, maxAngularDistForCorrespondence: float, angularDistPivotPoint: mrpt.pymrpt.mrpt.poses.CPose2D, correspondences: mrpt.pymrpt.mrpt.tfest.TMatchingPairListTempl_float_t, correspondencesRatio: float) -> None: ...
    @overload
    def computeMatchingWith2D(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose2D, maxDistForCorrespondence: float, maxAngularDistForCorrespondence: float, angularDistPivotPoint: mrpt.pymrpt.mrpt.poses.CPose2D, correspondences: mrpt.pymrpt.mrpt.tfest.TMatchingPairListTempl_float_t, correspondencesRatio: float, sumSqrDist: float) -> None: ...
    @overload
    def computeMatchingWith2D(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose2D, maxDistForCorrespondence: float, maxAngularDistForCorrespondence: float, angularDistPivotPoint: mrpt.pymrpt.mrpt.poses.CPose2D, correspondences: mrpt.pymrpt.mrpt.tfest.TMatchingPairListTempl_float_t, correspondencesRatio: float, sumSqrDist: float, onlyKeepTheClosest: bool) -> None: ...
    @overload
    def computeMatchingWith2D(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose2D, maxDistForCorrespondence: float, maxAngularDistForCorrespondence: float, angularDistPivotPoint: mrpt.pymrpt.mrpt.poses.CPose2D, correspondences: mrpt.pymrpt.mrpt.tfest.TMatchingPairListTempl_float_t, correspondencesRatio: float, sumSqrDist: float, onlyKeepTheClosest: bool, onlyUniqueRobust: bool) -> None: ...
    @overload
    def fuseWith(self, other: CLandmarksMap) -> None: ...
    @overload
    def fuseWith(self, other: CLandmarksMap, justInsertAllOfThem: bool) -> None: ...
    @overload
    def fuseWith(classmrpt, bool) -> void: ...
    @overload
    def getMapMaxID(self) -> int: ...
    @overload
    def getMapMaxID() -> long: ...
    @overload
    def getVisualizationInto(self, outObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    def internal_computeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    @overload
    def loadSiftFeaturesFromImageObservation(self, obs: mrpt.pymrpt.mrpt.obs.CObservationImage) -> None: ...
    @overload
    def loadSiftFeaturesFromImageObservation(self, obs: mrpt.pymrpt.mrpt.obs.CObservationImage, feat_options: mrpt.pymrpt.mrpt.vision.CFeatureExtraction.TOptions) -> None: ...
    @overload
    def loadSiftFeaturesFromImageObservation(constclassmrpt, conststructmrpt) -> void: ...
    @overload
    def loadSiftFeaturesFromStereoImageObservation(self, obs: mrpt.pymrpt.mrpt.obs.CObservationStereoImages, fID: int) -> None: ...
    @overload
    def loadSiftFeaturesFromStereoImageObservation(self, obs: mrpt.pymrpt.mrpt.obs.CObservationStereoImages, fID: int, feat_options: mrpt.pymrpt.mrpt.vision.CFeatureExtraction.TOptions) -> None: ...
    @overload
    def loadSiftFeaturesFromStereoImageObservation(constclassmrpt, long, conststructmrpt) -> void: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    def saveToMATLABScript2D(self, *args, **kwargs) -> Any: ...
    def saveToMATLABScript3D(self, *args, **kwargs) -> Any: ...
    def saveToTextFile(self, *args, **kwargs) -> Any: ...
    def simulateBeaconReadings(self, in_robotPose: mrpt.pymrpt.mrpt.poses.CPose3D, in_sensorLocationOnRobot: mrpt.pymrpt.mrpt.poses.CPoint3D, out_Observations: mrpt.pymrpt.mrpt.obs.CObservationBeaconRanges) -> None: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class CLogOddsGridMap2D_signed_char_t:
    @overload
    def __init__(self, arg0: CLogOddsGridMap2D_signed_char_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> CLogOddsGridMap2D_signed_char_t: ...
    def updateCell_fast_free(self, *args, **kwargs) -> Any: ...
    @overload
    def updateCell_fast_occupied(self, x: int, y: int, logodd_obs: int, thres: int, mapArray: int, _size_x: int) -> None: ...
    @overload
    def updateCell_fast_occupied(self, theCell: int, logodd_obs: int, thres: int) -> None: ...

class CLogOddsGridMap3D_signed_char_t:
    m_grid: mrpt.pymrpt.mrpt.containers.CDynamicGrid3D_signed_char_double_t
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CLogOddsGridMap3D_signed_char_t) -> None: ...
    def assign(self) -> CLogOddsGridMap3D_signed_char_t: ...
    @overload
    def updateCell_fast_free(self, theCell: int, logodd_obs: int, thres: int) -> None: ...
    @overload
    def updateCell_fast_free(self, x: int, y: int, z: int, logodd_obs: int, thres: int) -> None: ...
    @overload
    def updateCell_fast_occupied(self, theCell: int, logodd_obs: int, thres: int) -> None: ...
    @overload
    def updateCell_fast_occupied(self, x: int, y: int, z: int, logodd_obs: int, thres: int) -> None: ...

class CLogOddsGridMapLUT_signed_char_t:
    logoddsTable: List[float]
    logoddsTable_255: List[int]
    p2lTable: List[int]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CLogOddsGridMapLUT_signed_char_t) -> None: ...
    def assign(self) -> CLogOddsGridMapLUT_signed_char_t: ...
    @overload
    def l2p(self, l: int) -> float: ...
    @overload
    def l2p(constsignedchar) -> float: ...
    @overload
    def l2p_255(self, l: int) -> int: ...
    @overload
    def l2p_255(constsignedchar) -> uint8_t: ...
    @overload
    def p2l(self, p: float) -> int: ...
    @overload
    def p2l(constfloat) -> signedchar: ...

class CMetricMap(mrpt.pymrpt.mrpt.serialization.CSerializable, mrpt.pymrpt.mrpt.system.CObservable, mrpt.pymrpt.mrpt.Stringifyable, mrpt.pymrpt.mrpt.opengl.Visualizable):
    genericMapParams: TMapGenericParams
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CMetricMap: ...
    @overload
    def auxParticleFilterCleanUp(self) -> None: ...
    @overload
    def auxParticleFilterCleanUp() -> void: ...
    def boundingBox(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def canComputeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation) -> bool: ...
    @overload
    def canComputeObservationLikelihood(constclassmrpt) -> bool: ...
    @overload
    def canComputeObservationsLikelihood(self, sf) -> bool: ...
    @overload
    def canComputeObservationsLikelihood(constclassmrpt) -> bool: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def compute3DMatchingRatio(self, *args, **kwargs) -> Any: ...
    def computeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    def computeObservationsLikelihood(self, sf, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    def determineMatching2D(self, *args, **kwargs) -> Any: ...
    def determineMatching3D(self, *args, **kwargs) -> Any: ...
    def getAsSimplePointsMap(self, *args, **kwargs) -> Any: ...
    @overload
    def insertObs(self, obs: mrpt.pymrpt.mrpt.obs.CObservation) -> bool: ...
    @overload
    def insertObs(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, robotPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    @overload
    def insertObs(self, sf) -> bool: ...
    @overload
    def insertObs(self, sf, robotPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    @overload
    def loadFromSimpleMap(self, Map) -> None: ...
    @overload
    def loadFromSimpleMap(constclassmrpt) -> void: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    def squareDistanceToClosestCorrespondence(self, x0: float, y0: float) -> float: ...

class CMultiMetricMap(CMetricMap):
    maps: List[CMetricMap]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, initializers: TSetOfMetricMapInitializers) -> None: ...
    @overload
    def __init__(self, arg0: CMultiMetricMap) -> None: ...
    @overload
    def __init__(self, arg0: CMultiMetricMap) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self, o: CMultiMetricMap) -> CMultiMetricMap: ...
    @overload
    def auxParticleFilterCleanUp(self) -> None: ...
    @overload
    def auxParticleFilterCleanUp() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def compute3DMatchingRatio(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose3D, params: TMatchingRatioParams) -> float: ...
    def determineMatching2D(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose2D, correspondences: mrpt.pymrpt.mrpt.tfest.TMatchingPairListTempl_float_t, params: TMatchingParams, extraResults: TMatchingExtraResults) -> None: ...
    def getAsSimplePointsMap(self, *args, **kwargs) -> Any: ...
    @overload
    def getVisualizationInto(self, outObj) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> Any: ...
    @overload
    def isEmpty() -> bool: ...
    def mapByIndex(self, idx: int) -> CMetricMap: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    @overload
    def setListOfMaps(self, init: TSetOfMetricMapInitializers) -> None: ...
    @overload
    def setListOfMaps(constclassmrpt) -> void: ...

class CMultiMetricMapPDF(mrpt.pymrpt.mrpt.serialization.CSerializable, mrpt.pymrpt.mrpt.bayes.CParticleFilterData_mrpt_maps_CRBPFParticleData_mrpt_bayes_particle_storage_mode_POINTER_t, mrpt.pymrpt.mrpt.bayes.CParticleFilterDataImpl_mrpt_maps_CMultiMetricMapPDF_std_deque_mrpt_bayes_CProbabilityParticle_mrpt_maps_CRBPFParticleData_mrpt_bayes_particle_storage_mode_POINTER_t, mrpt.pymrpt.mrpt.slam.PF_implementation_mrpt_maps_CRBPFParticleData_mrpt_maps_CMultiMetricMapPDF_mrpt_bayes_particle_storage_mode_POINTER_t):
    class TPredictionParams(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        ICPGlobalAlign_MinQuality: float
        KLD_params: mrpt.pymrpt.mrpt.slam.TKLDParams
        icp_params: mrpt.pymrpt.mrpt.slam.CICP.TConfigParams
        pfOptimalProposal_mapSelection: int
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CMultiMetricMapPDF.TPredictionParams) -> None: ...
        @overload
        def __init__(self, arg0: CMultiMetricMapPDF.TPredictionParams) -> None: ...
        def assign(self) -> CMultiMetricMapPDF.TPredictionParams: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    options: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, opts: mrpt.pymrpt.mrpt.bayes.CParticleFilter.TParticleFilterOptions, mapsInitializers: TSetOfMetricMapInitializers, predictionOptions) -> None: ...
    @overload
    def __init__(self, arg0: CMultiMetricMapPDF) -> None: ...
    @overload
    def __init__(self, arg0: CMultiMetricMapPDF) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def PF_SLAM_computeObservationLikelihoodForParticle(self, PF_options: mrpt.pymrpt.mrpt.bayes.CParticleFilter.TParticleFilterOptions, particleIndexForMap: int, observation: mrpt.pymrpt.mrpt.obs.CSensoryFrame, x: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    @overload
    def PF_SLAM_implementation_custom_update_particle_with_new_pose(self, particleData: CRBPFParticleData, newPose: mrpt.pymrpt.mrpt.math.TPose3D) -> None: ...
    @overload
    def PF_SLAM_implementation_custom_update_particle_with_new_pose(classmrpt, conststructmrpt) -> void: ...
    @overload
    def PF_SLAM_implementation_doWeHaveValidObservations(self, particles, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def PF_SLAM_implementation_doWeHaveValidObservations(constclassstd, mrpt, constclassmrpt) -> bool: ...
    @overload
    def PF_SLAM_implementation_skipRobotMovement(self) -> bool: ...
    @overload
    def PF_SLAM_implementation_skipRobotMovement() -> bool: ...
    def assign(self) -> CMultiMetricMapPDF: ...
    @overload
    def clear(self, initialPose: mrpt.pymrpt.mrpt.poses.CPose2D) -> None: ...
    @overload
    def clear(constclassmrpt) -> void: ...
    @overload
    def clear(self, initialPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def clear(constclassmrpt) -> void: ...
    @overload
    def clear(self, prevMap: CSimpleMap, currentPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def getAveragedMetricMapEstimation(self) -> CMultiMetricMap: ...
    @overload
    def getCurrentEntropyOfPaths(self) -> float: ...
    @overload
    def getCurrentEntropyOfPaths() -> double: ...
    @overload
    def getCurrentJointEntropy(self) -> float: ...
    @overload
    def getCurrentJointEntropy() -> double: ...
    def getCurrentMostLikelyMetricMap(self) -> CMultiMetricMap: ...
    @overload
    def getEstimatedPosePDF(self, out_estimation: mrpt.pymrpt.mrpt.poses.CPose3DPDFParticles) -> None: ...
    @overload
    def getEstimatedPosePDF(classmrpt) -> void: ...
    @overload
    def getEstimatedPosePDFAtTime(self, timeStep: int, out_estimation: mrpt.pymrpt.mrpt.poses.CPose3DPDFParticles) -> None: ...
    @overload
    def getEstimatedPosePDFAtTime(size_t, classmrpt) -> void: ...
    def getLastPose(self, i: int, pose_is_valid: bool) -> mrpt.pymrpt.mrpt.math.TPose3D: ...
    @overload
    def getNumberOfObservationsInSimplemap(self) -> int: ...
    @overload
    def getNumberOfObservationsInSimplemap() -> size_t: ...
    @overload
    def getPath(self, i: int, out_path: List[mrpt.pymrpt.mrpt.math.TPose3D]) -> None: ...
    @overload
    def getPath(size_t, classstd) -> void: ...
    @overload
    def insertObservation(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def insertObservation(classmrpt) -> bool: ...
    @overload
    def saveCurrentPathEstimationToTextFile(self, fil: str) -> None: ...
    @overload
    def saveCurrentPathEstimationToTextFile(conststd) -> void: ...
    @overload
    def updateSensoryFrameSequence(self) -> None: ...
    @overload
    def updateSensoryFrameSequence() -> void: ...

class COccupancyGridMap2D(CMetricMap, CLogOddsGridMap2D_signed_char_t, NearestNeighborsCapable):
    class TCriticalPointsList:
        clearance: List[int]
        x: List[int]
        x_basis1: List[int]
        x_basis2: List[int]
        y: List[int]
        y_basis1: List[int]
        y_basis2: List[int]
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: COccupancyGridMap2D.TCriticalPointsList) -> None: ...
        def assign(self) -> COccupancyGridMap2D.TCriticalPointsList: ...

    class TEntropyInfo:
        H: float
        I: float
        effectiveMappedArea: float
        effectiveMappedCells: int
        mean_H: float
        mean_I: float
        def __init__(self) -> None: ...

    class TInsertionOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        CFD_features_gaussian_size: float
        CFD_features_median_size: float
        considerInvalidRangesAsFreeSpace: bool
        decimation: int
        horizontalTolerance: float
        mapAltitude: float
        maxDistanceInsertion: float
        maxFreenessInvalidRanges: float
        maxFreenessUpdateCertainty: float
        maxOccupancyUpdateCertainty: float
        useMapAltitude: bool
        wideningBeamsWithDistance: bool
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: COccupancyGridMap2D.TInsertionOptions) -> None: ...
        @overload
        def __init__(self, arg0: COccupancyGridMap2D.TInsertionOptions) -> None: ...
        def assign(self) -> COccupancyGridMap2D.TInsertionOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TLaserSimulUncertaintyMethod:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        sumMonteCarlo: ClassVar[COccupancyGridMap2D.TLaserSimulUncertaintyMethod] = ...
        sumUnscented: ClassVar[COccupancyGridMap2D.TLaserSimulUncertaintyMethod] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class TLaserSimulUncertaintyParams:
        MC_samples: int
        UT_alpha: float
        UT_beta: float
        UT_kappa: float
        angleNoiseStd: float
        aperture: float
        decimation: int
        maxRange: float
        method: COccupancyGridMap2D.TLaserSimulUncertaintyMethod
        nRays: int
        rangeNoiseStd: float
        rightToLeft: bool
        robotPose: mrpt.pymrpt.mrpt.poses.CPosePDFGaussian
        sensorPose: mrpt.pymrpt.mrpt.poses.CPose3D
        threshold: float
        def __init__(self) -> None: ...

    class TLaserSimulUncertaintyResult:
        scanWithUncert: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScanWithUncertainty
        def __init__(self) -> None: ...

    class TLikelihoodMethod:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        lmCellsDifference: ClassVar[COccupancyGridMap2D.TLikelihoodMethod] = ...
        lmConsensus: ClassVar[COccupancyGridMap2D.TLikelihoodMethod] = ...
        lmConsensusOWA: ClassVar[COccupancyGridMap2D.TLikelihoodMethod] = ...
        lmLikelihoodField_II: ClassVar[COccupancyGridMap2D.TLikelihoodMethod] = ...
        lmLikelihoodField_Thrun: ClassVar[COccupancyGridMap2D.TLikelihoodMethod] = ...
        lmMeanInformation: ClassVar[COccupancyGridMap2D.TLikelihoodMethod] = ...
        lmRayTracing: ClassVar[COccupancyGridMap2D.TLikelihoodMethod] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class TLikelihoodOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        LF_alternateAverageMethod: bool
        LF_decimation: int
        LF_maxCorrsDistance: float
        LF_maxRange: float
        LF_stdHit: float
        LF_useSquareDist: bool
        LF_zHit: float
        LF_zRandom: float
        MI_exponent: float
        MI_ratio_max_distance: float
        MI_skip_rays: int
        OWA_weights: List[float]
        consensus_pow: float
        consensus_takeEachRange: int
        enableLikelihoodCache: bool
        likelihoodMethod: COccupancyGridMap2D.TLikelihoodMethod
        rayTracing_decimation: int
        rayTracing_stdHit: float
        rayTracing_useDistanceFilter: bool
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: COccupancyGridMap2D.TLikelihoodOptions) -> None: ...
        @overload
        def __init__(self, arg0: COccupancyGridMap2D.TLikelihoodOptions) -> None: ...
        def assign(self) -> COccupancyGridMap2D.TLikelihoodOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TLikelihoodOutput:
        OWA_individualLikValues: List[float]
        OWA_pairList: Any
        @overload
        def __init__(self, arg0: COccupancyGridMap2D.TLikelihoodOutput) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def assign(self) -> COccupancyGridMap2D.TLikelihoodOutput: ...

    class TMapDefinition(COccupancyGridMap2D.TMapDefinitionBase):
        insertionOpts: COccupancyGridMap2D.TInsertionOptions
        likelihoodOpts: COccupancyGridMap2D.TLikelihoodOptions
        max_x: float
        max_y: float
        min_x: float
        min_y: float
        resolution: float
        def __init__(self) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...

    class TUpdateCellsInfoChangeOnly:
        I_change: float
        cellsUpdated: int
        enabled: bool
        laserRaysSkip: int
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: COccupancyGridMap2D.TUpdateCellsInfoChangeOnly) -> None: ...
        def assign(self) -> COccupancyGridMap2D.TUpdateCellsInfoChangeOnly: ...
    lmCellsDifference: ClassVar[COccupancyGridMap2D.TLikelihoodMethod] = ...
    lmConsensus: ClassVar[COccupancyGridMap2D.TLikelihoodMethod] = ...
    lmConsensusOWA: ClassVar[COccupancyGridMap2D.TLikelihoodMethod] = ...
    lmLikelihoodField_II: ClassVar[COccupancyGridMap2D.TLikelihoodMethod] = ...
    lmLikelihoodField_Thrun: ClassVar[COccupancyGridMap2D.TLikelihoodMethod] = ...
    lmMeanInformation: ClassVar[COccupancyGridMap2D.TLikelihoodMethod] = ...
    lmRayTracing: ClassVar[COccupancyGridMap2D.TLikelihoodMethod] = ...
    sumMonteCarlo: ClassVar[COccupancyGridMap2D.TLaserSimulUncertaintyMethod] = ...
    sumUnscented: ClassVar[COccupancyGridMap2D.TLaserSimulUncertaintyMethod] = ...
    CriticalPointsList: Any
    insertionOptions: Any
    likelihoodOptions: Any
    likelihoodOutputs: Any
    updateInfoChangeOnly: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, min_x: float, max_x: float, min_y: float, max_y: float, resolution: float) -> None: ...
    @overload
    def __init__(self, arg0: COccupancyGridMap2D) -> None: ...
    @overload
    def __init__(self, arg0: COccupancyGridMap2D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def FromROSMapServerYAML(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self) -> COccupancyGridMap2D: ...
    def boundingBox(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def buildVoronoiDiagram(self, threshold: float, robot_size: float) -> None: ...
    @overload
    def buildVoronoiDiagram(self, threshold: float, robot_size: float, x1: int) -> None: ...
    @overload
    def buildVoronoiDiagram(self, threshold: float, robot_size: float, x1: int, x2: int) -> None: ...
    @overload
    def buildVoronoiDiagram(self, threshold: float, robot_size: float, x1: int, x2: int, y1: int) -> None: ...
    @overload
    def buildVoronoiDiagram(self, threshold: float, robot_size: float, x1: int, x2: int, y1: int, y2: int) -> None: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def compute3DMatchingRatio(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose3D, params: TMatchingRatioParams) -> float: ...
    def computeClearance(self, *args, **kwargs) -> Any: ...
    def computeEntropy(self, *args, **kwargs) -> Any: ...
    @overload
    def computeLikelihoodField_II(self, pm: CPointsMap) -> float: ...
    @overload
    def computeLikelihoodField_II(self, pm: CPointsMap, relativePose: mrpt.pymrpt.mrpt.poses.CPose2D) -> float: ...
    @overload
    def computeLikelihoodField_Thrun(self, pm: CPointsMap) -> float: ...
    @overload
    def computeLikelihoodField_Thrun(self, pm: CPointsMap, relativePose: mrpt.pymrpt.mrpt.poses.CPose2D) -> float: ...
    def computePathCost(self, x1: float, y1: float, x2: float, y2: float) -> float: ...
    @overload
    def copyMapContentFrom(self, otherMap: COccupancyGridMap2D) -> None: ...
    @overload
    def copyMapContentFrom(constclassmrpt) -> void: ...
    def determineMatching2D(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose2D, correspondences: mrpt.pymrpt.mrpt.tfest.TMatchingPairListTempl_float_t, params: TMatchingParams, extraResults: TMatchingExtraResults) -> None: ...
    @overload
    def fill(self) -> None: ...
    @overload
    def fill(self, default_value: float) -> None: ...
    @overload
    def fill(float) -> void: ...
    def findCriticalPoints(self, *args, **kwargs) -> Any: ...
    @overload
    def getArea(self) -> float: ...
    @overload
    def getArea() -> double: ...
    @overload
    def getAsImage(self, img: mrpt.pymrpt.mrpt.img.CImage) -> None: ...
    @overload
    def getAsImage(self, img: mrpt.pymrpt.mrpt.img.CImage, verticalFlip: bool) -> None: ...
    @overload
    def getAsImage(self, img: mrpt.pymrpt.mrpt.img.CImage, verticalFlip: bool, forceRGB: bool) -> None: ...
    @overload
    def getAsImage(self, img: mrpt.pymrpt.mrpt.img.CImage, verticalFlip: bool, forceRGB: bool, tricolor: bool) -> None: ...
    @overload
    def getAsImageFiltered(self, img: mrpt.pymrpt.mrpt.img.CImage) -> None: ...
    @overload
    def getAsImageFiltered(self, img: mrpt.pymrpt.mrpt.img.CImage, verticalFlip: bool) -> None: ...
    @overload
    def getAsImageFiltered(self, img: mrpt.pymrpt.mrpt.img.CImage, verticalFlip: bool, forceRGB: bool) -> None: ...
    @overload
    def getAsPointCloud(self, pm) -> None: ...
    @overload
    def getAsPointCloud(self, pm, occup_threshold: float) -> None: ...
    @overload
    def getAsPointCloud(classmrpt, constfloat) -> void: ...
    def getBasisCell(self, x: int, y: int) -> int: ...
    def getBasisMap(self) -> mrpt.pymrpt.mrpt.containers.CDynamicGrid_unsigned_char_t: ...
    def getCell(self, x: int, y: int) -> float: ...
    def getPos(self, x: float, y: float) -> float: ...
    @overload
    def getResolution(self) -> float: ...
    @overload
    def getResolution() -> float: ...
    def getRow(self, cy: int) -> int: ...
    @overload
    def getSizeX(self) -> int: ...
    @overload
    def getSizeX() -> unsignedint: ...
    @overload
    def getSizeY(self) -> int: ...
    @overload
    def getSizeY() -> unsignedint: ...
    @overload
    def getVisualizationInto(self, outObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    def getVoroniClearance(self, cx: int, cy: int) -> int: ...
    def getVoronoiDiagram(self) -> mrpt.pymrpt.mrpt.containers.CDynamicGrid_unsigned_short_t: ...
    @overload
    def getXMax(self) -> float: ...
    @overload
    def getXMax() -> float: ...
    @overload
    def getXMin(self) -> float: ...
    @overload
    def getXMin() -> float: ...
    @overload
    def getYMax(self) -> float: ...
    @overload
    def getYMax() -> float: ...
    @overload
    def getYMin(self) -> float: ...
    @overload
    def getYMin() -> float: ...
    @overload
    def idx2x(self, cx: int) -> float: ...
    @overload
    def idx2x(size_t) -> float: ...
    @overload
    def idx2y(self, cy: int) -> float: ...
    @overload
    def idx2y(size_t) -> float: ...
    def isEmpty(self, *args, **kwargs) -> Any: ...
    @overload
    def isStaticCell(self, cx: int, cy: int) -> bool: ...
    @overload
    def isStaticCell(self, cx: int, cy: int, threshold: float) -> bool: ...
    @overload
    def isStaticPos(self, x: float, y: float) -> bool: ...
    @overload
    def isStaticPos(self, x: float, y: float, threshold: float) -> bool: ...
    def l2p(self, *args, **kwargs) -> Any: ...
    def l2p_255(self, *args, **kwargs) -> Any: ...
    @overload
    def laserScanSimulator(self, inout_Scan: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScan, robotPose: mrpt.pymrpt.mrpt.poses.CPose2D) -> None: ...
    @overload
    def laserScanSimulator(self, inout_Scan: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScan, robotPose: mrpt.pymrpt.mrpt.poses.CPose2D, threshold: float) -> None: ...
    @overload
    def laserScanSimulator(self, inout_Scan: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScan, robotPose: mrpt.pymrpt.mrpt.poses.CPose2D, threshold: float, N: int) -> None: ...
    @overload
    def laserScanSimulator(self, inout_Scan: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScan, robotPose: mrpt.pymrpt.mrpt.poses.CPose2D, threshold: float, N: int, noiseStd: float) -> None: ...
    @overload
    def laserScanSimulator(self, inout_Scan: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScan, robotPose: mrpt.pymrpt.mrpt.poses.CPose2D, threshold: float, N: int, noiseStd: float, decimation: int) -> None: ...
    @overload
    def laserScanSimulator(self, inout_Scan: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScan, robotPose: mrpt.pymrpt.mrpt.poses.CPose2D, threshold: float, N: int, noiseStd: float, decimation: int, angleNoiseStd: float) -> None: ...
    def laserScanSimulatorWithUncertainty(self, *args, **kwargs) -> Any: ...
    @overload
    def loadFromBitmap(self, img: mrpt.pymrpt.mrpt.img.CImage, resolution: float) -> bool: ...
    @overload
    def loadFromBitmap(self, img: mrpt.pymrpt.mrpt.img.CImage, resolution: float, origin) -> bool: ...
    @overload
    def loadFromBitmap(constclassmrpt, float, conststructmrpt) -> bool: ...
    @overload
    def loadFromBitmapFile(self, file: str, resolution: float) -> bool: ...
    @overload
    def loadFromBitmapFile(self, file: str, resolution: float, origin) -> bool: ...
    @overload
    def loadFromBitmapFile(conststd, float, conststructmrpt) -> bool: ...
    def loadFromROSMapServerYAML(self, yamlFilePath: str) -> bool: ...
    def nn_has_indices_or_ids(self) -> bool: ...
    @overload
    def nn_index_count(self) -> int: ...
    @overload
    def nn_index_count() -> size_t: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrID: int) -> bool: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrID: int) -> bool: ...
    def p2l(self, *args, **kwargs) -> Any: ...
    @overload
    def resizeGrid(self, new_x_min: float, new_x_max: float, new_y_min: float, new_y_max: float) -> None: ...
    @overload
    def resizeGrid(self, new_x_min: float, new_x_max: float, new_y_min: float, new_y_max: float, new_cells_default_value: float) -> None: ...
    @overload
    def resizeGrid(self, new_x_min: float, new_x_max: float, new_y_min: float, new_y_max: float, new_cells_default_value: float, additionalMargin: bool) -> None: ...
    @overload
    def saveAsBitmapFile(self, file: str) -> bool: ...
    @overload
    def saveAsBitmapFile(conststd) -> bool: ...
    def saveAsBitmapTwoMapsWithCorrespondences(self, *args, **kwargs) -> Any: ...
    def saveAsEMFTwoMapsWithCorrespondences(self, *args, **kwargs) -> Any: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    def setBasisCell(self, x: int, y: int, value: int) -> None: ...
    def setCell(self, x: int, y: int, value: float) -> None: ...
    def setPos(self, x: float, y: float, value: float) -> None: ...
    @overload
    def setSize(self, x_min: float, x_max: float, y_min: float, y_max: float, resolution: float) -> None: ...
    @overload
    def setSize(self, x_min: float, x_max: float, y_min: float, y_max: float, resolution: float, default_value: float) -> None: ...
    @overload
    def simulateScanRay(self, x: float, y: float, angle_direction: float, out_range: float, out_valid: bool, max_range_meters: float) -> None: ...
    @overload
    def simulateScanRay(self, x: float, y: float, angle_direction: float, out_range: float, out_valid: bool, max_range_meters: float, threshold_free: float) -> None: ...
    @overload
    def simulateScanRay(self, x: float, y: float, angle_direction: float, out_range: float, out_valid: bool, max_range_meters: float, threshold_free: float, noiseStd: float) -> None: ...
    @overload
    def simulateScanRay(self, x: float, y: float, angle_direction: float, out_range: float, out_valid: bool, max_range_meters: float, threshold_free: float, noiseStd: float, angleNoiseStd: float) -> None: ...
    def sonarSimulator(self, *args, **kwargs) -> Any: ...
    @overload
    def subSample(self, downRatio: int) -> None: ...
    @overload
    def subSample(int) -> void: ...
    def updateCell(self, x: int, y: int, v: float) -> None: ...
    @overload
    def x2idx(self, x: float) -> int: ...
    @overload
    def x2idx(float) -> int: ...
    @overload
    def x2idx(self, x: float) -> int: ...
    @overload
    def x2idx(double) -> int: ...
    @overload
    def x2idx(self, x: float, xmin: float) -> int: ...
    @overload
    def y2idx(self, y: float) -> int: ...
    @overload
    def y2idx(float) -> int: ...
    @overload
    def y2idx(self, y: float) -> int: ...
    @overload
    def y2idx(double) -> int: ...
    @overload
    def y2idx(self, y: float, ymin: float) -> int: ...

class COccupancyGridMap3D(CMetricMap, CLogOddsGridMap3D_signed_char_t, NearestNeighborsCapable):
    class TInsertionOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        decimation: int
        decimation_3d_range: int
        maxDistanceInsertion: float
        maxFreenessUpdateCertainty: float
        maxOccupancyUpdateCertainty: float
        raytraceEmptyCells: bool
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: COccupancyGridMap3D.TInsertionOptions) -> None: ...
        @overload
        def __init__(self, arg0: COccupancyGridMap3D.TInsertionOptions) -> None: ...
        def assign(self) -> COccupancyGridMap3D.TInsertionOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def saveToConfigFile(self, target: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def saveToConfigFile(classmrpt, conststd) -> void: ...

    class TLikelihoodMethod:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        lmLikelihoodField_Thrun: ClassVar[COccupancyGridMap3D.TLikelihoodMethod] = ...
        lmRayTracing: ClassVar[COccupancyGridMap3D.TLikelihoodMethod] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class TLikelihoodOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        LF_decimation: int
        LF_maxCorrsDistance: float
        LF_maxRange: float
        LF_stdHit: float
        LF_useSquareDist: bool
        LF_zHit: float
        LF_zRandom: float
        likelihoodMethod: COccupancyGridMap3D.TLikelihoodMethod
        rayTracing_decimation: int
        rayTracing_stdHit: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: COccupancyGridMap3D.TLikelihoodOptions) -> None: ...
        @overload
        def __init__(self, arg0: COccupancyGridMap3D.TLikelihoodOptions) -> None: ...
        def assign(self) -> COccupancyGridMap3D.TLikelihoodOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def saveToConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
        @overload
        def saveToConfigFile(classmrpt, conststd) -> void: ...

    class TMapDefinition(COccupancyGridMap3D.TMapDefinitionBase):
        insertionOpts: COccupancyGridMap3D.TInsertionOptions
        likelihoodOpts: COccupancyGridMap3D.TLikelihoodOptions
        max_x: float
        max_y: float
        max_z: float
        min_x: float
        min_y: float
        min_z: float
        resolution: float
        def __init__(self) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...

    class TRenderingOptions:
        generateFreeVoxels: bool
        generateGridLines: bool
        generateOccupiedVoxels: bool
        visibleFreeVoxels: bool
        visibleOccupiedVoxels: bool
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: COccupancyGridMap3D.TRenderingOptions) -> None: ...
        def assign(self) -> COccupancyGridMap3D.TRenderingOptions: ...
        @overload
        def readFromStream(self, in: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def readFromStream(classmrpt) -> void: ...
        @overload
        def writeToStream(self, out: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def writeToStream(classmrpt) -> void: ...
    lmLikelihoodField_Thrun: ClassVar[COccupancyGridMap3D.TLikelihoodMethod] = ...
    lmRayTracing: ClassVar[COccupancyGridMap3D.TLikelihoodMethod] = ...
    insertionOptions: Any
    likelihoodOptions: Any
    renderingOptions: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0) -> None: ...
    @overload
    def __init__(self, arg0, arg1) -> None: ...
    @overload
    def __init__(self, corner_min, corner_max, resolution: float) -> None: ...
    @overload
    def __init__(self, arg0: COccupancyGridMap3D) -> None: ...
    @overload
    def __init__(self, arg0: COccupancyGridMap3D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self) -> COccupancyGridMap3D: ...
    def boundingBox(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def compute3DMatchingRatio(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose3D, params: TMatchingRatioParams) -> float: ...
    def determineMatching2D(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose2D, correspondences: mrpt.pymrpt.mrpt.tfest.TMatchingPairListTempl_float_t, params: TMatchingParams, extraResults: TMatchingExtraResults) -> None: ...
    @overload
    def fill(self) -> None: ...
    @overload
    def fill(self, default_value: float) -> None: ...
    @overload
    def fill(float) -> void: ...
    @overload
    def getAsOctoMapVoxels(self, gl_obj: mrpt.pymrpt.mrpt.opengl.COctoMapVoxels) -> None: ...
    @overload
    def getAsOctoMapVoxels(classmrpt) -> void: ...
    def getCellFreeness(self, cx: int, cy: int, cz: int) -> float: ...
    def getFreenessByPos(self, x: float, y: float, z: float) -> float: ...
    @overload
    def getVisualizationInto(self, outObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def insertRay(self, sensor, end) -> None: ...
    @overload
    def insertRay(self, sensor, end, endIsOccupied: bool) -> None: ...
    def isEmpty(self, *args, **kwargs) -> Any: ...
    def l2p(self, *args, **kwargs) -> Any: ...
    def l2p_255(self, *args, **kwargs) -> Any: ...
    def nn_has_indices_or_ids(self) -> bool: ...
    @overload
    def nn_index_count(self) -> int: ...
    @overload
    def nn_index_count() -> size_t: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrID: int) -> bool: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrID: int) -> bool: ...
    def p2l(self, *args, **kwargs) -> Any: ...
    @overload
    def resizeGrid(self, corner_min, corner_max) -> None: ...
    @overload
    def resizeGrid(self, corner_min, corner_max, new_voxels_default_value: float) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(self, f: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    def setCellFreeness(self, cx: int, cy: int, cz: int, value: float) -> None: ...
    def setFreenessByPos(self, x: float, y: float, z: float, value: float) -> None: ...
    @overload
    def setSize(self, corner_min, corner_max, resolution: float) -> None: ...
    @overload
    def setSize(self, corner_min, corner_max, resolution: float, default_value: float) -> None: ...
    def updateCell(self, cx_idx: int, cy_idx: int, cz_idx: int, v: float) -> None: ...

class COctoMap(COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t):
    class TMapDefinition(COctoMap.TMapDefinitionBase):
        insertionOpts: COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t.TInsertionOptions
        likelihoodOpts: COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t.TLikelihoodOptions
        resolution: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: COctoMap.TMapDefinition) -> None: ...
        @overload
        def __init__(self, arg0: COctoMap.TMapDefinition) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, resolution: float) -> None: ...
    @overload
    def __init__(self, arg0: COctoMap) -> None: ...
    @overload
    def __init__(self, arg0: COctoMap) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> COctoMap: ...
    @overload
    def calcNumNodes(self) -> int: ...
    @overload
    def calcNumNodes() -> size_t: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getAsOctoMapVoxels(self, gl_obj: mrpt.pymrpt.mrpt.opengl.COctoMapVoxels) -> None: ...
    @overload
    def getAsOctoMapVoxels(classmrpt) -> void: ...
    @overload
    def getClampingThresMax(self) -> float: ...
    @overload
    def getClampingThresMax() -> double: ...
    @overload
    def getClampingThresMaxLog(self) -> float: ...
    @overload
    def getClampingThresMaxLog() -> float: ...
    @overload
    def getClampingThresMin(self) -> float: ...
    @overload
    def getClampingThresMin() -> double: ...
    @overload
    def getClampingThresMinLog(self) -> float: ...
    @overload
    def getClampingThresMinLog() -> float: ...
    def getMetricMax(self, x: float, y: float, z: float) -> None: ...
    def getMetricMin(self, x: float, y: float, z: float) -> None: ...
    def getMetricSize(self, x: float, y: float, z: float) -> None: ...
    @overload
    def getNumLeafNodes(self) -> int: ...
    @overload
    def getNumLeafNodes() -> size_t: ...
    @overload
    def getOccupancyThres(self) -> float: ...
    @overload
    def getOccupancyThres() -> double: ...
    @overload
    def getOccupancyThresLog(self) -> float: ...
    @overload
    def getOccupancyThresLog() -> float: ...
    @overload
    def getProbHit(self) -> float: ...
    @overload
    def getProbHit() -> double: ...
    @overload
    def getProbHitLog(self) -> float: ...
    @overload
    def getProbHitLog() -> float: ...
    @overload
    def getProbMiss(self) -> float: ...
    @overload
    def getProbMiss() -> double: ...
    @overload
    def getProbMissLog(self) -> float: ...
    @overload
    def getProbMissLog() -> float: ...
    @overload
    def getResolution(self) -> float: ...
    @overload
    def getResolution() -> double: ...
    @overload
    def getTreeDepth(self) -> int: ...
    @overload
    def getTreeDepth() -> unsignedint: ...
    def insertRay(self, end_x: float, end_y: float, end_z: float, sensor_x: float, sensor_y: float, sensor_z: float) -> None: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    def isPointWithinOctoMap(self, x: float, y: float, z: float) -> bool: ...
    @overload
    def memoryFullGrid(self) -> int: ...
    @overload
    def memoryFullGrid() -> size_t: ...
    @overload
    def memoryUsage(self) -> int: ...
    @overload
    def memoryUsage() -> size_t: ...
    @overload
    def memoryUsageNode(self) -> int: ...
    @overload
    def memoryUsageNode() -> size_t: ...
    @overload
    def setClampingThresMax(self, thresProb: float) -> None: ...
    @overload
    def setClampingThresMax(double) -> void: ...
    @overload
    def setClampingThresMin(self, thresProb: float) -> None: ...
    @overload
    def setClampingThresMin(double) -> void: ...
    @overload
    def setOccupancyThres(self, prob: float) -> None: ...
    @overload
    def setOccupancyThres(double) -> void: ...
    @overload
    def setProbHit(self, prob: float) -> None: ...
    @overload
    def setProbHit(double) -> void: ...
    @overload
    def setProbMiss(self, prob: float) -> None: ...
    @overload
    def setProbMiss(double) -> void: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...
    def updateVoxel(self, x: float, y: float, z: float, occupied: bool) -> None: ...
    @overload
    def volume(self) -> float: ...
    @overload
    def volume() -> double: ...

class COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t(CMetricMap):
    class TInsertionOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        maxrange: float
        pruning: bool
        @overload
        def __init__(self, parent: COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t) -> None: ...
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t.TInsertionOptions) -> None: ...
        @overload
        def __init__(self, arg0: COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t.TInsertionOptions) -> None: ...
        def assign(self, o: COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t.TInsertionOptions) -> COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t.TInsertionOptions: ...
        @overload
        def getClampingThresMax(self) -> float: ...
        @overload
        def getClampingThresMax() -> double: ...
        @overload
        def getClampingThresMaxLog(self) -> float: ...
        @overload
        def getClampingThresMaxLog() -> float: ...
        @overload
        def getClampingThresMin(self) -> float: ...
        @overload
        def getClampingThresMin() -> double: ...
        @overload
        def getClampingThresMinLog(self) -> float: ...
        @overload
        def getClampingThresMinLog() -> float: ...
        @overload
        def getOccupancyThres(self) -> float: ...
        @overload
        def getOccupancyThres() -> double: ...
        @overload
        def getOccupancyThresLog(self) -> float: ...
        @overload
        def getOccupancyThresLog() -> float: ...
        @overload
        def getProbHit(self) -> float: ...
        @overload
        def getProbHit() -> double: ...
        @overload
        def getProbHitLog(self) -> float: ...
        @overload
        def getProbHitLog() -> float: ...
        @overload
        def getProbMiss(self) -> float: ...
        @overload
        def getProbMiss() -> double: ...
        @overload
        def getProbMissLog(self) -> float: ...
        @overload
        def getProbMissLog() -> float: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def setClampingThresMax(self, thresProb: float) -> None: ...
        @overload
        def setClampingThresMax(double) -> void: ...
        @overload
        def setClampingThresMin(self, thresProb: float) -> None: ...
        @overload
        def setClampingThresMin(double) -> void: ...
        @overload
        def setOccupancyThres(self, prob: float) -> None: ...
        @overload
        def setOccupancyThres(double) -> void: ...
        @overload
        def setProbHit(self, prob: float) -> None: ...
        @overload
        def setProbHit(double) -> void: ...
        @overload
        def setProbMiss(self, prob: float) -> None: ...
        @overload
        def setProbMiss(double) -> void: ...

    class TLikelihoodOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        decimation: int
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t.TLikelihoodOptions) -> None: ...
        @overload
        def __init__(self, arg0: COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t.TLikelihoodOptions) -> None: ...
        def assign(self) -> COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t.TLikelihoodOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def readFromStream(self, in: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def readFromStream(classmrpt) -> void: ...
        @overload
        def writeToStream(self, out: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def writeToStream(classmrpt) -> void: ...

    class TRenderingOptions:
        generateFreeVoxels: bool
        generateGridLines: bool
        generateOccupiedVoxels: bool
        visibleFreeVoxels: bool
        visibleOccupiedVoxels: bool
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t.TRenderingOptions) -> None: ...
        def assign(self) -> COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t.TRenderingOptions: ...
        @overload
        def readFromStream(self, in: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def readFromStream(classmrpt) -> void: ...
        @overload
        def writeToStream(self, out: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def writeToStream(classmrpt) -> void: ...
    genericMapParams: TMapGenericParams
    insertionOptions: Any
    likelihoodOptions: Any
    renderingOptions: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    @overload
    def assign(self) -> COctoMapBase_octomap_ColorOcTree_octomap_ColorOcTreeNode_t: ...
    @overload
    def assign(self) -> CMetricMap: ...
    @overload
    def auxParticleFilterCleanUp(self) -> None: ...
    @overload
    def auxParticleFilterCleanUp() -> void: ...
    def boundingBox(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def canComputeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation) -> bool: ...
    @overload
    def canComputeObservationLikelihood(constclassmrpt) -> bool: ...
    @overload
    def canComputeObservationsLikelihood(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def canComputeObservationsLikelihood(constclassmrpt) -> bool: ...
    @overload
    def castRay(self, origin, direction, end) -> bool: ...
    @overload
    def castRay(self, origin, direction, end, ignoreUnknownCells: bool) -> bool: ...
    @overload
    def castRay(self, origin, direction, end, ignoreUnknownCells: bool, maxRange: float) -> bool: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def compute3DMatchingRatio(self, *args, **kwargs) -> Any: ...
    def computeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    def computeObservationsLikelihood(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    def determineMatching2D(self, *args, **kwargs) -> Any: ...
    def determineMatching3D(self, *args, **kwargs) -> Any: ...
    @overload
    def getAsOctoMapVoxels(self, gl_obj: mrpt.pymrpt.mrpt.opengl.COctoMapVoxels) -> None: ...
    @overload
    def getAsOctoMapVoxels(classmrpt) -> void: ...
    def getAsSimplePointsMap(self, *args, **kwargs) -> Any: ...
    @overload
    def getClampingThresMax(self) -> float: ...
    @overload
    def getClampingThresMax() -> double: ...
    @overload
    def getClampingThresMaxLog(self) -> float: ...
    @overload
    def getClampingThresMaxLog() -> float: ...
    @overload
    def getClampingThresMin(self) -> float: ...
    @overload
    def getClampingThresMin() -> double: ...
    @overload
    def getClampingThresMinLog(self) -> float: ...
    @overload
    def getClampingThresMinLog() -> float: ...
    @overload
    def getOccupancyThres(self) -> float: ...
    @overload
    def getOccupancyThres() -> double: ...
    @overload
    def getOccupancyThresLog(self) -> float: ...
    @overload
    def getOccupancyThresLog() -> float: ...
    def getPointOccupancy(self, x: float, y: float, z: float, prob_occupancy: float) -> bool: ...
    @overload
    def getProbHit(self) -> float: ...
    @overload
    def getProbHit() -> double: ...
    @overload
    def getProbHitLog(self) -> float: ...
    @overload
    def getProbHitLog() -> float: ...
    @overload
    def getProbMiss(self) -> float: ...
    @overload
    def getProbMiss() -> double: ...
    @overload
    def getProbMissLog(self) -> float: ...
    @overload
    def getProbMissLog() -> float: ...
    @overload
    def getVisualizationInto(self, o: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def insertObs(self, obs: mrpt.pymrpt.mrpt.obs.CObservation) -> bool: ...
    @overload
    def insertObs(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, robotPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    @overload
    def insertObs(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def insertObs(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame, robotPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    def insertPointCloud(self, ptMap: CPointsMap, sensor_x: float, sensor_y: float, sensor_z: float) -> None: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    @overload
    def loadFromSimpleMap(self, Map: CSimpleMap) -> None: ...
    @overload
    def loadFromSimpleMap(constclassmrpt) -> void: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    @overload
    def setClampingThresMax(self, thresProb: float) -> None: ...
    @overload
    def setClampingThresMax(double) -> void: ...
    @overload
    def setClampingThresMin(self, thresProb: float) -> None: ...
    @overload
    def setClampingThresMin(double) -> void: ...
    @overload
    def setOccupancyThres(self, prob: float) -> None: ...
    @overload
    def setOccupancyThres(double) -> void: ...
    @overload
    def setProbHit(self, prob: float) -> None: ...
    @overload
    def setProbHit(double) -> void: ...
    @overload
    def setProbMiss(self, prob: float) -> None: ...
    @overload
    def setProbMiss(double) -> void: ...
    def squareDistanceToClosestCorrespondence(self, x0: float, y0: float) -> float: ...

class COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t(CMetricMap):
    class TInsertionOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        maxrange: float
        pruning: bool
        @overload
        def __init__(self, parent: COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t) -> None: ...
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t.TInsertionOptions) -> None: ...
        @overload
        def __init__(self, arg0: COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t.TInsertionOptions) -> None: ...
        def assign(self, o: COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t.TInsertionOptions) -> COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t.TInsertionOptions: ...
        @overload
        def getClampingThresMax(self) -> float: ...
        @overload
        def getClampingThresMax() -> double: ...
        @overload
        def getClampingThresMaxLog(self) -> float: ...
        @overload
        def getClampingThresMaxLog() -> float: ...
        @overload
        def getClampingThresMin(self) -> float: ...
        @overload
        def getClampingThresMin() -> double: ...
        @overload
        def getClampingThresMinLog(self) -> float: ...
        @overload
        def getClampingThresMinLog() -> float: ...
        @overload
        def getOccupancyThres(self) -> float: ...
        @overload
        def getOccupancyThres() -> double: ...
        @overload
        def getOccupancyThresLog(self) -> float: ...
        @overload
        def getOccupancyThresLog() -> float: ...
        @overload
        def getProbHit(self) -> float: ...
        @overload
        def getProbHit() -> double: ...
        @overload
        def getProbHitLog(self) -> float: ...
        @overload
        def getProbHitLog() -> float: ...
        @overload
        def getProbMiss(self) -> float: ...
        @overload
        def getProbMiss() -> double: ...
        @overload
        def getProbMissLog(self) -> float: ...
        @overload
        def getProbMissLog() -> float: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def setClampingThresMax(self, thresProb: float) -> None: ...
        @overload
        def setClampingThresMax(double) -> void: ...
        @overload
        def setClampingThresMin(self, thresProb: float) -> None: ...
        @overload
        def setClampingThresMin(double) -> void: ...
        @overload
        def setOccupancyThres(self, prob: float) -> None: ...
        @overload
        def setOccupancyThres(double) -> void: ...
        @overload
        def setProbHit(self, prob: float) -> None: ...
        @overload
        def setProbHit(double) -> void: ...
        @overload
        def setProbMiss(self, prob: float) -> None: ...
        @overload
        def setProbMiss(double) -> void: ...

    class TLikelihoodOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        decimation: int
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t.TLikelihoodOptions) -> None: ...
        @overload
        def __init__(self, arg0: COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t.TLikelihoodOptions) -> None: ...
        def assign(self) -> COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t.TLikelihoodOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def readFromStream(self, in: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def readFromStream(classmrpt) -> void: ...
        @overload
        def writeToStream(self, out: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def writeToStream(classmrpt) -> void: ...

    class TRenderingOptions:
        generateFreeVoxels: bool
        generateGridLines: bool
        generateOccupiedVoxels: bool
        visibleFreeVoxels: bool
        visibleOccupiedVoxels: bool
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t.TRenderingOptions) -> None: ...
        def assign(self) -> COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t.TRenderingOptions: ...
        @overload
        def readFromStream(self, in: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def readFromStream(classmrpt) -> void: ...
        @overload
        def writeToStream(self, out: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def writeToStream(classmrpt) -> void: ...
    genericMapParams: TMapGenericParams
    insertionOptions: Any
    likelihoodOptions: Any
    renderingOptions: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    @overload
    def assign(self) -> COctoMapBase_octomap_OcTree_octomap_OcTreeNode_t: ...
    @overload
    def assign(self) -> CMetricMap: ...
    @overload
    def auxParticleFilterCleanUp(self) -> None: ...
    @overload
    def auxParticleFilterCleanUp() -> void: ...
    def boundingBox(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def canComputeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation) -> bool: ...
    @overload
    def canComputeObservationLikelihood(constclassmrpt) -> bool: ...
    @overload
    def canComputeObservationsLikelihood(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def canComputeObservationsLikelihood(constclassmrpt) -> bool: ...
    @overload
    def castRay(self, origin, direction, end) -> bool: ...
    @overload
    def castRay(self, origin, direction, end, ignoreUnknownCells: bool) -> bool: ...
    @overload
    def castRay(self, origin, direction, end, ignoreUnknownCells: bool, maxRange: float) -> bool: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def compute3DMatchingRatio(self, *args, **kwargs) -> Any: ...
    def computeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    def computeObservationsLikelihood(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    def determineMatching2D(self, *args, **kwargs) -> Any: ...
    def determineMatching3D(self, *args, **kwargs) -> Any: ...
    @overload
    def getAsOctoMapVoxels(self, gl_obj: mrpt.pymrpt.mrpt.opengl.COctoMapVoxels) -> None: ...
    @overload
    def getAsOctoMapVoxels(classmrpt) -> void: ...
    def getAsSimplePointsMap(self, *args, **kwargs) -> Any: ...
    @overload
    def getClampingThresMax(self) -> float: ...
    @overload
    def getClampingThresMax() -> double: ...
    @overload
    def getClampingThresMaxLog(self) -> float: ...
    @overload
    def getClampingThresMaxLog() -> float: ...
    @overload
    def getClampingThresMin(self) -> float: ...
    @overload
    def getClampingThresMin() -> double: ...
    @overload
    def getClampingThresMinLog(self) -> float: ...
    @overload
    def getClampingThresMinLog() -> float: ...
    @overload
    def getOccupancyThres(self) -> float: ...
    @overload
    def getOccupancyThres() -> double: ...
    @overload
    def getOccupancyThresLog(self) -> float: ...
    @overload
    def getOccupancyThresLog() -> float: ...
    def getPointOccupancy(self, x: float, y: float, z: float, prob_occupancy: float) -> bool: ...
    @overload
    def getProbHit(self) -> float: ...
    @overload
    def getProbHit() -> double: ...
    @overload
    def getProbHitLog(self) -> float: ...
    @overload
    def getProbHitLog() -> float: ...
    @overload
    def getProbMiss(self) -> float: ...
    @overload
    def getProbMiss() -> double: ...
    @overload
    def getProbMissLog(self) -> float: ...
    @overload
    def getProbMissLog() -> float: ...
    @overload
    def getVisualizationInto(self, o: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def insertObs(self, obs: mrpt.pymrpt.mrpt.obs.CObservation) -> bool: ...
    @overload
    def insertObs(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, robotPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    @overload
    def insertObs(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def insertObs(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame, robotPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    def insertPointCloud(self, ptMap: CPointsMap, sensor_x: float, sensor_y: float, sensor_z: float) -> None: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    @overload
    def loadFromSimpleMap(self, Map: CSimpleMap) -> None: ...
    @overload
    def loadFromSimpleMap(constclassmrpt) -> void: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    @overload
    def setClampingThresMax(self, thresProb: float) -> None: ...
    @overload
    def setClampingThresMax(double) -> void: ...
    @overload
    def setClampingThresMin(self, thresProb: float) -> None: ...
    @overload
    def setClampingThresMin(double) -> void: ...
    @overload
    def setOccupancyThres(self, prob: float) -> None: ...
    @overload
    def setOccupancyThres(double) -> void: ...
    @overload
    def setProbHit(self, prob: float) -> None: ...
    @overload
    def setProbHit(double) -> void: ...
    @overload
    def setProbMiss(self, prob: float) -> None: ...
    @overload
    def setProbMiss(double) -> void: ...
    def squareDistanceToClosestCorrespondence(self, x0: float, y0: float) -> float: ...

class CPointCloudFilterBase:
    class TExtraFilterParams:
        do_not_delete: bool
        def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPointCloudFilterBase) -> None: ...
    def assign(self) -> CPointCloudFilterBase: ...
    @overload
    def filter(self, inout_pointcloud: CPointsMap, pc_timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, pc_reference_pose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def filter(self, inout_pointcloud: CPointsMap, pc_timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, pc_reference_pose: mrpt.pymrpt.mrpt.poses.CPose3D, params) -> None: ...
    @overload
    def filter(classmrpt, constmrpt, constclassmrpt, structmrpt) -> void: ...

class CPointCloudFilterByDistance(CPointCloudFilterBase):
    class TOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        angle_tolerance: float
        max_deletion_ratio: float
        min_dist: float
        previous_keyframes: int
        too_old_seconds: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CPointCloudFilterByDistance.TOptions) -> None: ...
        @overload
        def __init__(self, arg0: CPointCloudFilterByDistance.TOptions) -> None: ...
        def assign(self) -> CPointCloudFilterByDistance.TOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def saveToConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def saveToConfigFile(classmrpt, conststd) -> void: ...
    options: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPointCloudFilterByDistance) -> None: ...
    @overload
    def __init__(self, arg0: CPointCloudFilterByDistance) -> None: ...
    def assign(self) -> CPointCloudFilterByDistance: ...
    @overload
    def filter(self, inout_pointcloud: CPointsMap, pc_timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, pc_reference_pose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def filter(self, inout_pointcloud: CPointsMap, pc_timestamp: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t, pc_reference_pose: mrpt.pymrpt.mrpt.poses.CPose3D, params: CPointCloudFilterBase.TExtraFilterParams) -> None: ...
    @overload
    def filter(classmrpt, constmrpt, constclassmrpt, structmrpt) -> void: ...

class CPointsMap(CMetricMap, mrpt.pymrpt.mrpt.opengl.PLY_Importer, mrpt.pymrpt.mrpt.opengl.PLY_Exporter, NearestNeighborsCapable):
    class TInsertionOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        addToExistingPointsMap: bool
        also_interpolate: bool
        disableDeletion: bool
        fuseWithExisting: bool
        horizontalTolerance: float
        insertInvalidPoints: bool
        isPlanarMap: bool
        maxDistForInterpolatePoints: float
        minDistBetweenLaserPoints: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CPointsMap.TInsertionOptions) -> None: ...
        @overload
        def __init__(self, arg0: CPointsMap.TInsertionOptions) -> None: ...
        def assign(self) -> CPointsMap.TInsertionOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def readFromStream(self, in: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def readFromStream(classmrpt) -> void: ...
        @overload
        def writeToStream(self, out: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def writeToStream(classmrpt) -> void: ...

    class TLikelihoodOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        decimation: int
        max_corr_distance: float
        sigma_dist: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CPointsMap.TLikelihoodOptions) -> None: ...
        @overload
        def __init__(self, arg0: CPointsMap.TLikelihoodOptions) -> None: ...
        def assign(self) -> CPointsMap.TLikelihoodOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def readFromStream(self, in: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def readFromStream(classmrpt) -> void: ...
        @overload
        def writeToStream(self, out: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def writeToStream(classmrpt) -> void: ...

    class TRenderOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        color: mrpt.pymrpt.mrpt.img.TColorf
        colormap: mrpt.pymrpt.mrpt.img.TColormap
        point_size: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CPointsMap.TRenderOptions) -> None: ...
        @overload
        def __init__(self, arg0: CPointsMap.TRenderOptions) -> None: ...
        def assign(self) -> CPointsMap.TRenderOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
        @overload
        def readFromStream(self, in: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def readFromStream(classmrpt) -> void: ...
        @overload
        def writeToStream(self, out: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
        @overload
        def writeToStream(classmrpt) -> void: ...
    insertionOptions: Any
    likelihoodOptions: Any
    renderOptions: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self, o: CPointsMap) -> CPointsMap: ...
    def boundingBox(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def changeCoordinatesReference(self, b: mrpt.pymrpt.mrpt.poses.CPose2D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def changeCoordinatesReference(self, b: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def changeCoordinatesReference(constclassmrpt) -> void: ...
    @overload
    def changeCoordinatesReference(self, other: CPointsMap, b: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def clipOutOfRange(self, point, maxRange: float) -> None: ...
    @overload
    def clipOutOfRange(conststructmrpt, float) -> void: ...
    def clipOutOfRangeInZ(self, zMin: float, zMax: float) -> None: ...
    def compute3DDistanceToMesh(self, *args, **kwargs) -> Any: ...
    def compute3DMatchingRatio(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose3D, params: TMatchingRatioParams) -> float: ...
    def determineMatching2D(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose2D, correspondences: mrpt.pymrpt.mrpt.tfest.TMatchingPairListTempl_float_t, params: TMatchingParams, extraResults: TMatchingExtraResults) -> None: ...
    def determineMatching3D(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose3D, correspondences: mrpt.pymrpt.mrpt.tfest.TMatchingPairListTempl_float_t, params: TMatchingParams, extraResults: TMatchingExtraResults) -> None: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    @overload
    def enableFilterByHeight(self) -> None: ...
    @overload
    def enableFilterByHeight(self, enable: bool) -> None: ...
    @overload
    def enableFilterByHeight(bool) -> void: ...
    def extractCylinder(self, center, radius: float, zmin: float, zmax: float, outMap: CPointsMap) -> None: ...
    @overload
    def extractPoints(self, corner1, corner2, outMap: CPointsMap) -> None: ...
    @overload
    def extractPoints(self, corner1, corner2, outMap: CPointsMap, R: float) -> None: ...
    @overload
    def extractPoints(self, corner1, corner2, outMap: CPointsMap, R: float, G: float) -> None: ...
    @overload
    def extractPoints(self, corner1, corner2, outMap: CPointsMap, R: float, G: float, B: float) -> None: ...
    def getHeightFilterLevels(self, _z_min: float, _z_max: float) -> None: ...
    @overload
    def getLargestDistanceFromOrigin(self) -> float: ...
    @overload
    def getLargestDistanceFromOrigin() -> float: ...
    def getLargestDistanceFromOriginNoRecompute(self, output_is_valid: bool) -> float: ...
    @overload
    def getPoint(self, index: int, x: float, y: float, z: float) -> None: ...
    @overload
    def getPoint(self, index: int, x: float, y: float) -> None: ...
    @overload
    def getPoint(self, index: int, x: float, y: float, z: float) -> None: ...
    @overload
    def getPoint(self, index: int, x: float, y: float) -> None: ...
    @overload
    def getPoint(self, index: int, p) -> None: ...
    @overload
    def getPoint(size_t, structmrpt) -> void: ...
    @overload
    def getPoint(self, index: int, p) -> None: ...
    @overload
    def getPoint(size_t, structmrpt) -> void: ...
    def getPointFast(self, index: int, x: float, y: float, z: float) -> None: ...
    def getPointRGB(self, index: int, x: float, y: float, z: float, R: float, G: float, B: float) -> None: ...
    @overload
    def getPointWeight(self, index: int) -> int: ...
    @overload
    def getPointWeight(size_t) -> unsignedint: ...
    @overload
    def getVisualizationInto(self, outObj) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def hasColorPoints(self) -> bool: ...
    @overload
    def hasColorPoints() -> bool: ...
    @overload
    def hasField_Intensity(self) -> bool: ...
    @overload
    def hasField_Intensity() -> bool: ...
    @overload
    def hasField_Ring(self) -> bool: ...
    @overload
    def hasField_Ring() -> bool: ...
    @overload
    def hasField_Timestamp(self) -> bool: ...
    @overload
    def hasField_Timestamp() -> bool: ...
    @overload
    def hasField_color_B(self) -> bool: ...
    @overload
    def hasField_color_B() -> bool: ...
    @overload
    def hasField_color_G(self) -> bool: ...
    @overload
    def hasField_color_G() -> bool: ...
    @overload
    def hasField_color_R(self) -> bool: ...
    @overload
    def hasField_color_R() -> bool: ...
    @overload
    def insertAnotherMap(self, otherMap: CPointsMap, otherPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def insertAnotherMap(self, otherMap: CPointsMap, otherPose: mrpt.pymrpt.mrpt.poses.CPose3D, filterOutPointsAtZero: bool) -> None: ...
    @overload
    def insertPoint(self, x: float, y: float) -> None: ...
    @overload
    def insertPoint(self, x: float, y: float, z: float) -> None: ...
    @overload
    def insertPoint(self, p) -> None: ...
    @overload
    def insertPoint(conststructmrpt) -> void: ...
    @overload
    def insertPointFast(self, x: float, y: float) -> None: ...
    @overload
    def insertPointFast(self, x: float, y: float, z: float) -> None: ...
    @overload
    def insertPointField_Intensity(self, i: float) -> None: ...
    @overload
    def insertPointField_Intensity(float) -> void: ...
    @overload
    def insertPointField_Ring(self, r: int) -> None: ...
    @overload
    def insertPointField_Ring(uint16_t) -> void: ...
    @overload
    def insertPointField_Timestamp(self, t: float) -> None: ...
    @overload
    def insertPointField_Timestamp(float) -> void: ...
    @overload
    def insertPointField_color_B(self, v: float) -> None: ...
    @overload
    def insertPointField_color_B(float) -> void: ...
    @overload
    def insertPointField_color_G(self, v: float) -> None: ...
    @overload
    def insertPointField_color_G(float) -> void: ...
    @overload
    def insertPointField_color_R(self, v: float) -> None: ...
    @overload
    def insertPointField_color_R(float) -> void: ...
    @overload
    def insertPointFrom(self, source: CPointsMap, sourcePointIndex: int) -> None: ...
    @overload
    def insertPointFrom(constclassmrpt, size_t) -> void: ...
    def insertPointRGB(self, x: float, y: float, z: float, R: float, G: float, B: float) -> None: ...
    def internal_computeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    def internal_computeObservationLikelihoodPointCloud3D(self, pc_in_map: mrpt.pymrpt.mrpt.poses.CPose3D, xs: float, ys: float, zs: float, num_pts: int) -> float: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    @overload
    def isFilterByHeightEnabled(self) -> bool: ...
    @overload
    def isFilterByHeightEnabled() -> bool: ...
    def kdtree_distance(self, p1: float, idx_p2: int, size: int) -> float: ...
    @overload
    def kdtree_get_point_count(self) -> int: ...
    @overload
    def kdtree_get_point_count() -> size_t: ...
    @overload
    def kdtree_get_pt(self, idx: int, dim: int) -> float: ...
    @overload
    def kdtree_get_pt(size_t, int) -> float: ...
    @overload
    def load2D_from_text_file(self, file: str) -> bool: ...
    @overload
    def load2D_from_text_file(conststd) -> bool: ...
    @overload
    def load2Dor3D_from_text_file(self, file: str, is_3D: bool) -> bool: ...
    @overload
    def load2Dor3D_from_text_file(conststd, constbool) -> bool: ...
    @overload
    def load3D_from_text_file(self, file: str) -> bool: ...
    @overload
    def load3D_from_text_file(conststd) -> bool: ...
    @overload
    def mark_as_modified(self) -> None: ...
    @overload
    def mark_as_modified() -> void: ...
    @overload
    def nn_has_indices_or_ids(self) -> bool: ...
    @overload
    def nn_has_indices_or_ids() -> bool: ...
    @overload
    def nn_index_count(self) -> int: ...
    @overload
    def nn_index_count() -> size_t: ...
    def nn_prepare_for_2d_queries(self) -> None: ...
    @overload
    def nn_prepare_for_3d_queries(self) -> None: ...
    @overload
    def nn_prepare_for_3d_queries() -> void: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrID: int) -> bool: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrID: int) -> bool: ...
    @overload
    def reserve(self, newLength: int) -> None: ...
    @overload
    def reserve(size_t) -> void: ...
    @overload
    def resize(self, newLength: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def save2D_to_text_file(self, file: str) -> bool: ...
    @overload
    def save2D_to_text_file(conststd) -> bool: ...
    @overload
    def save3D_to_text_file(self, file: str) -> bool: ...
    @overload
    def save3D_to_text_file(conststd) -> bool: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    def setHeightFilterLevels(self, _z_min: float, _z_max: float) -> None: ...
    @overload
    def setPoint(self, index: int, x: float, y: float, z: float) -> None: ...
    @overload
    def setPoint(self, index: int, p) -> None: ...
    @overload
    def setPoint(size_t, conststructmrpt) -> void: ...
    @overload
    def setPoint(self, index: int, p) -> None: ...
    @overload
    def setPoint(size_t, conststructmrpt) -> void: ...
    @overload
    def setPoint(self, index: int, x: float, y: float) -> None: ...
    def setPointFast(self, index: int, x: float, y: float, z: float) -> None: ...
    def setPointRGB(self, index: int, x: float, y: float, z: float, R: float, G: float, B: float) -> None: ...
    @overload
    def setPointWeight(self, index: int, w: int) -> None: ...
    @overload
    def setPointWeight(size_t, unsignedlong) -> void: ...
    @overload
    def setSize(self, newLength: int) -> None: ...
    @overload
    def setSize(size_t) -> void: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...
    def squareDistanceToClosestCorrespondence(self, x0: float, y0: float) -> float: ...
    @overload
    def squareDistanceToClosestCorrespondenceT(self, p0) -> float: ...
    @overload
    def squareDistanceToClosestCorrespondenceT(conststructmrpt) -> float: ...
    def __iadd__(self, anotherMap: CPointsMap) -> None: ...

class CPointsMapXYZI(CPointsMap):
    class TMapDefinition(CPointsMapXYZI.TMapDefinitionBase):
        insertionOpts: CPointsMap.TInsertionOptions
        likelihoodOpts: CPointsMap.TLikelihoodOptions
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CPointsMapXYZI.TMapDefinition) -> None: ...
        @overload
        def __init__(self, arg0: CPointsMapXYZI.TMapDefinition) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, o: CPointsMap) -> None: ...
    @overload
    def __init__(self, arg0: CPointsMapXYZI) -> None: ...
    @overload
    def __init__(self, arg0: CPointsMapXYZI) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def assign(self, o: CPointsMap) -> CPointsMapXYZI: ...
    @overload
    def assign(self, o: CPointsMapXYZI) -> CPointsMapXYZI: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getPointIntensity(self, index: int) -> float: ...
    @overload
    def getPointIntensity(size_t) -> float: ...
    @overload
    def getPointIntensity_fast(self, index: int) -> float: ...
    @overload
    def getPointIntensity_fast(size_t) -> float: ...
    def getPointRGB(self, index: int, x: float, y: float, z: float, R_intensity: float, G_intensity: float, B_intensity: float) -> None: ...
    @overload
    def getVisualizationInto(self, outObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def hasColorPoints(self) -> bool: ...
    @overload
    def hasColorPoints() -> bool: ...
    @overload
    def insertPointFast(self, x: float, y: float) -> None: ...
    @overload
    def insertPointFast(self, x: float, y: float, z: float) -> None: ...
    @overload
    def insertPointField_Intensity(self, i: float) -> None: ...
    @overload
    def insertPointField_Intensity(float) -> void: ...
    def insertPointRGB(self, x: float, y: float, z: float, R_intensity: float, G_ignored: float, B_ignored: float) -> None: ...
    @overload
    def loadFromKittiVelodyneFile(self, filename: str) -> bool: ...
    @overload
    def loadFromKittiVelodyneFile(conststd) -> bool: ...
    @overload
    def loadXYZI_from_text_file(self, file: str) -> bool: ...
    @overload
    def loadXYZI_from_text_file(conststd) -> bool: ...
    def reserve(self, newLength: int) -> None: ...
    @overload
    def resize(self, newLength: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    @overload
    def saveToKittiVelodyneFile(self, filename: str) -> bool: ...
    @overload
    def saveToKittiVelodyneFile(conststd) -> bool: ...
    @overload
    def saveXYZI_to_text_file(self, file: str) -> bool: ...
    @overload
    def saveXYZI_to_text_file(conststd) -> bool: ...
    def setPointColor_fast(self, index: int, R: float, G: float, B: float) -> None: ...
    @overload
    def setPointIntensity(self, index: int, intensity: float) -> None: ...
    @overload
    def setPointIntensity(size_t, float) -> void: ...
    def setPointRGB(self, index: int, x: float, y: float, z: float, R_intensity: float, G_ignored: float, B_ignored: float) -> None: ...
    @overload
    def setSize(self, newLength: int) -> None: ...
    @overload
    def setSize(size_t) -> void: ...

class CRBPFParticleData(mrpt.pymrpt.mrpt.serialization.CSerializable):
    mapTillNow: CMultiMetricMap
    robotPath: List[mrpt.pymrpt.mrpt.math.TPose3D]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, mapsInit: TSetOfMetricMapInitializers) -> None: ...
    @overload
    def __init__(self, arg0: CRBPFParticleData) -> None: ...
    @overload
    def __init__(self, arg0: CRBPFParticleData) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CRBPFParticleData: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...

class CRandomFieldGridMap2D(CMetricMap, mrpt.pymrpt.mrpt.containers.CDynamicGrid_mrpt_maps_TRandomFieldCell_t):
    class ConnectivityDescriptor:
        def __init__(self) -> None: ...
        def assign(self) -> CRandomFieldGridMap2D.ConnectivityDescriptor: ...
        def getEdgeInformation(self, parent: CRandomFieldGridMap2D, icx: int, icy: int, jcx: int, jcy: int, out_edge_information: float) -> bool: ...

    class TGridInterpolationMethod:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        gimBilinear: ClassVar[CRandomFieldGridMap2D.TGridInterpolationMethod] = ...
        gimNearest: ClassVar[CRandomFieldGridMap2D.TGridInterpolationMethod] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class TInsertionOptionsCommon:
        GMRF_gridmap_image_cx: int
        GMRF_gridmap_image_cy: int
        GMRF_gridmap_image_file: str
        GMRF_gridmap_image_res: float
        GMRF_lambdaObs: float
        GMRF_lambdaObsLoss: float
        GMRF_lambdaPrior: float
        GMRF_saturate_max: float
        GMRF_saturate_min: float
        GMRF_simplemap_file: str
        GMRF_skip_variance: bool
        GMRF_use_occupancy_information: bool
        KF_W_size: int
        KF_covSigma: float
        KF_defaultCellMeanValue: float
        KF_initialCellStd: float
        KF_observationModelNoise: float
        R_max: float
        R_min: float
        cutoffRadius: float
        dm_sigma_omega: float
        sigma: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CRandomFieldGridMap2D.TInsertionOptionsCommon) -> None: ...
        def assign(self) -> CRandomFieldGridMap2D.TInsertionOptionsCommon: ...
        @overload
        def internal_loadFromConfigFile_common(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def internal_loadFromConfigFile_common(constclassmrpt, conststd) -> void: ...

    class TMapRepresentation:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        mrAchim: ClassVar[CRandomFieldGridMap2D.TMapRepresentation] = ...
        mrGMRF_SD: ClassVar[CRandomFieldGridMap2D.TMapRepresentation] = ...
        mrKalmanApproximate: ClassVar[CRandomFieldGridMap2D.TMapRepresentation] = ...
        mrKalmanFilter: ClassVar[CRandomFieldGridMap2D.TMapRepresentation] = ...
        mrKernelDM: ClassVar[CRandomFieldGridMap2D.TMapRepresentation] = ...
        mrKernelDMV: ClassVar[CRandomFieldGridMap2D.TMapRepresentation] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    gimBilinear: ClassVar[CRandomFieldGridMap2D.TGridInterpolationMethod] = ...
    gimNearest: ClassVar[CRandomFieldGridMap2D.TGridInterpolationMethod] = ...
    mrAchim: ClassVar[CRandomFieldGridMap2D.TMapRepresentation] = ...
    mrGMRF_SD: ClassVar[CRandomFieldGridMap2D.TMapRepresentation] = ...
    mrKalmanApproximate: ClassVar[CRandomFieldGridMap2D.TMapRepresentation] = ...
    mrKalmanFilter: ClassVar[CRandomFieldGridMap2D.TMapRepresentation] = ...
    mrKernelDM: ClassVar[CRandomFieldGridMap2D.TMapRepresentation] = ...
    mrKernelDMV: ClassVar[CRandomFieldGridMap2D.TMapRepresentation] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self) -> CRandomFieldGridMap2D: ...
    @overload
    def cell2float(self, c: TRandomFieldCell) -> float: ...
    @overload
    def cell2float(conststructmrpt) -> float: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> Any: ...
    @overload
    def clear() -> void: ...
    def compute3DMatchingRatio(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose3D, params: TMatchingRatioParams) -> float: ...
    @overload
    def enableProfiler(self) -> None: ...
    @overload
    def enableProfiler(self, enable: bool) -> None: ...
    @overload
    def enableProfiler(bool) -> void: ...
    @overload
    def enableVerbose(self, enable_verbose: bool) -> None: ...
    @overload
    def enableVerbose(bool) -> void: ...
    def getAs3DObject(self, meanObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects, varObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getAsBitmapFile(self, out_img: mrpt.pymrpt.mrpt.img.CImage) -> None: ...
    @overload
    def getAsBitmapFile(classmrpt) -> void: ...
    @overload
    def getAsMatrix(self, out_mat: mrpt.pymrpt.mrpt.math.CMatrixDynamic_double_t) -> None: ...
    @overload
    def getAsMatrix(classmrpt) -> void: ...
    def getMapType(self) -> CRandomFieldGridMap2D.TMapRepresentation: ...
    def getMeanAndCov(self, out_means, out_cov: mrpt.pymrpt.mrpt.math.CMatrixDynamic_double_t) -> None: ...
    def getMeanAndSTD(self, out_means, out_STD) -> None: ...
    @overload
    def getVisualizationInto(self, outObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def insertIndividualReading(self, sensorReading: float, point) -> None: ...
    @overload
    def insertIndividualReading(self, sensorReading: float, point, update_map: bool) -> None: ...
    @overload
    def insertIndividualReading(self, sensorReading: float, point, update_map: bool, time_invariant: bool) -> None: ...
    @overload
    def insertIndividualReading(self, sensorReading: float, point, update_map: bool, time_invariant: bool, reading_stddev: float) -> None: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    @overload
    def isEnabledVerbose(self) -> bool: ...
    @overload
    def isEnabledVerbose() -> bool: ...
    @overload
    def isProfilerEnabled(self) -> bool: ...
    @overload
    def isProfilerEnabled() -> bool: ...
    @overload
    def predictMeasurement(self, x: float, y: float, out_predict_response: float, out_predict_response_variance: float, do_sensor_normalization: bool) -> None: ...
    @overload
    def predictMeasurement(self, x: float, y: float, out_predict_response: float, out_predict_response_variance: float, do_sensor_normalization: bool, interp_method: CRandomFieldGridMap2D.TGridInterpolationMethod) -> None: ...
    @overload
    def resize(self, new_x_min: float, new_x_max: float, new_y_min: float, new_y_max: float, defaultValueNewCells: TRandomFieldCell) -> None: ...
    @overload
    def resize(self, new_x_min: float, new_x_max: float, new_y_min: float, new_y_max: float, defaultValueNewCells: TRandomFieldCell, additionalMarginMeters: float) -> None: ...
    @overload
    def saveAsBitmapFile(self, filName: str) -> None: ...
    @overload
    def saveAsBitmapFile(conststd) -> void: ...
    @overload
    def saveAsMatlab3DGraph(self, filName: str) -> None: ...
    @overload
    def saveAsMatlab3DGraph(conststd) -> void: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    @overload
    def setCellsConnectivity(self, new_connectivity_descriptor) -> None: ...
    @overload
    def setCellsConnectivity(constclassstd) -> void: ...
    def setMeanAndSTD(self, out_means, out_STD) -> None: ...
    @overload
    def setSize(self, x_min: float, x_max: float, y_min: float, y_max: float, resolution: float) -> None: ...
    @overload
    def setSize(self, x_min: float, x_max: float, y_min: float, y_max: float, resolution: float, fill_value: TRandomFieldCell) -> None: ...
    @overload
    def updateMapEstimation(self) -> None: ...
    @overload
    def updateMapEstimation() -> void: ...

class CRandomFieldGridMap3D(mrpt.pymrpt.mrpt.containers.CDynamicGrid3D_mrpt_maps_TRandomFieldVoxel_double_t, mrpt.pymrpt.mrpt.serialization.CSerializable):
    class ConnectivityDescriptor:
        def __init__(self) -> None: ...
        def assign(self) -> CRandomFieldGridMap3D.ConnectivityDescriptor: ...
        def getEdgeInformation(self, parent: CRandomFieldGridMap3D, icx: int, icy: int, icz: int, jcx: int, jcy: int, jcz: int, out_edge_information: float) -> bool: ...

    class TInsertionOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        GMRF_lambdaPrior: float
        GMRF_skip_variance: bool
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CRandomFieldGridMap3D.TInsertionOptions) -> None: ...
        @overload
        def __init__(self, arg0: CRandomFieldGridMap3D.TInsertionOptions) -> None: ...
        def assign(self) -> CRandomFieldGridMap3D.TInsertionOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TVoxelInterpolationMethod:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        gimBilinear: ClassVar[CRandomFieldGridMap3D.TVoxelInterpolationMethod] = ...
        gimNearest: ClassVar[CRandomFieldGridMap3D.TVoxelInterpolationMethod] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    gimBilinear: ClassVar[CRandomFieldGridMap3D.TVoxelInterpolationMethod] = ...
    gimNearest: ClassVar[CRandomFieldGridMap3D.TVoxelInterpolationMethod] = ...
    insertionOptions: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float, arg6: float) -> None: ...
    @overload
    def __init__(self, x_min: float, x_max: float, y_min: float, y_max: float, z_min: float, z_max: float, voxel_size: float, call_initialize_now: bool) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap3D) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap3D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CRandomFieldGridMap3D: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def insertIndividualReading(self, sensorReading: float, sensorVariance: float, point, method: CRandomFieldGridMap3D.TVoxelInterpolationMethod, update_map: bool) -> bool: ...
    @overload
    def resize(self, new_x_min: float, new_x_max: float, new_y_min: float, new_y_max: float, new_z_min: float, new_z_max: float, defaultValueNewvoxels: TRandomFieldVoxel) -> None: ...
    @overload
    def resize(self, new_x_min: float, new_x_max: float, new_y_min: float, new_y_max: float, new_z_min: float, new_z_max: float, defaultValueNewvoxels: TRandomFieldVoxel, additionalMarginMeters: float) -> None: ...
    @overload
    def saveAsCSV(self, filName_mean: str) -> bool: ...
    @overload
    def saveAsCSV(self, filName_mean: str, filName_stddev: str) -> bool: ...
    @overload
    def setSize(self, x_min: float, x_max: float, y_min: float, y_max: float, z_min: float, z_max: float, resolution_xy: float) -> None: ...
    @overload
    def setSize(self, x_min: float, x_max: float, y_min: float, y_max: float, z_min: float, z_max: float, resolution_xy: float, resolution_z: float) -> None: ...
    @overload
    def setSize(self, x_min: float, x_max: float, y_min: float, y_max: float, z_min: float, z_max: float, resolution_xy: float, resolution_z: float, fill_value: TRandomFieldVoxel) -> None: ...
    @overload
    def setVoxelsConnectivity(self, new_connectivity_descriptor) -> None: ...
    @overload
    def setVoxelsConnectivity(constclassstd) -> void: ...
    @overload
    def updateMapEstimation(self) -> None: ...
    @overload
    def updateMapEstimation() -> void: ...

class CReflectivityGridMap2D(CMetricMap, mrpt.pymrpt.mrpt.containers.CDynamicGrid_signed_char_t, CLogOddsGridMap2D_signed_char_t):
    class TInsertionOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
        channel: int
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CReflectivityGridMap2D.TInsertionOptions) -> None: ...
        @overload
        def __init__(self, arg0: CReflectivityGridMap2D.TInsertionOptions) -> None: ...
        def assign(self) -> CReflectivityGridMap2D.TInsertionOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TMapDefinition(CReflectivityGridMap2D.TMapDefinitionBase):
        insertionOpts: CReflectivityGridMap2D.TInsertionOptions
        max_x: float
        max_y: float
        min_x: float
        min_y: float
        resolution: float
        def __init__(self) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...
    insertionOptions: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, x_min: float, x_max: float, y_min: float, y_max: float, resolution: float) -> None: ...
    @overload
    def __init__(self, arg0: CReflectivityGridMap2D) -> None: ...
    @overload
    def __init__(self, arg0: CReflectivityGridMap2D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self) -> CReflectivityGridMap2D: ...
    def cell2float(self, c: int) -> float: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> Any: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def compute3DMatchingRatio(self, otherMap: CMetricMap, otherMapPose: mrpt.pymrpt.mrpt.poses.CPose3D, params: TMatchingRatioParams) -> float: ...
    @overload
    def getAsImage(self, img: mrpt.pymrpt.mrpt.img.CImage) -> None: ...
    @overload
    def getAsImage(self, img: mrpt.pymrpt.mrpt.img.CImage, verticalFlip: bool) -> None: ...
    @overload
    def getAsImage(self, img: mrpt.pymrpt.mrpt.img.CImage, verticalFlip: bool, forceRGB: bool) -> None: ...
    @overload
    def getVisualizationInto(self, outObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...

class CSimpleMap(mrpt.pymrpt.mrpt.serialization.CSerializable):
    class Keyframe:
        localTwist: Optional[mrpt.pymrpt.mrpt.math.TTwist3D]
        pose: mrpt.pymrpt.mrpt.poses.CPose3DPDF
        sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CSimpleMap.Keyframe) -> None: ...
        def assign(self) -> CSimpleMap.Keyframe: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CSimpleMap) -> None: ...
    @overload
    def __init__(self, arg0: CSimpleMap) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CSimpleMap: ...
    @overload
    def changeCoordinatesOrigin(self, newOrigin: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def changeCoordinatesOrigin(constclassmrpt) -> void: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    def get(self, *args, **kwargs) -> Any: ...
    @overload
    def insert(self, kf) -> None: ...
    @overload
    def insert(conststructmrpt) -> void: ...
    @overload
    def loadFromFile(self, filName: str) -> bool: ...
    @overload
    def loadFromFile(conststd) -> bool: ...
    def makeDeepCopy(self) -> CSimpleMap: ...
    @overload
    def remove(self, index: int) -> None: ...
    @overload
    def remove(size_t) -> void: ...
    @overload
    def saveToFile(self, filName: str) -> bool: ...
    @overload
    def saveToFile(conststd) -> bool: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class CSimplePointsMap(CPointsMap):
    class TMapDefinition(CSimplePointsMap.TMapDefinitionBase):
        insertionOpts: CPointsMap.TInsertionOptions
        likelihoodOpts: CPointsMap.TLikelihoodOptions
        renderOpts: CPointsMap.TRenderOptions
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CSimplePointsMap.TMapDefinition) -> None: ...
        @overload
        def __init__(self, arg0: CSimplePointsMap.TMapDefinition) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, o: CPointsMap) -> None: ...
    @overload
    def __init__(self, arg0: CSimplePointsMap) -> None: ...
    @overload
    def __init__(self, arg0: CSimplePointsMap) -> None: ...
    def Create(self, *args, **kwargs) -> Any: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def assign(self, o: CPointsMap) -> CSimplePointsMap: ...
    @overload
    def assign(self, o: CSimplePointsMap) -> CSimplePointsMap: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def getAsSimplePointsMap(self) -> CSimplePointsMap: ...
    @overload
    def insertPointFast(self, x: float, y: float) -> None: ...
    @overload
    def insertPointFast(self, x: float, y: float, z: float) -> None: ...
    def reserve(self, newLength: int) -> None: ...
    @overload
    def resize(self, newLength: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def setSize(self, newLength: int) -> None: ...
    @overload
    def setSize(size_t) -> void: ...

class CVoxelMap(CVoxelMapOccupancyBase_mrpt_maps_VoxelNodeOccupancy_signed_char_t):
    class TMapDefinition(CVoxelMap.TMapDefinitionBase):
        inner_bits: int
        insertionOpts: TVoxelMap_InsertionOptions
        leaf_bits: int
        likelihoodOpts: TVoxelMap_LikelihoodOptions
        resolution: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CVoxelMap.TMapDefinition) -> None: ...
        @overload
        def __init__(self, arg0: CVoxelMap.TMapDefinition) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: int) -> None: ...
    @overload
    def __init__(self, resolution: float, inner_bits: int, leaf_bits: int) -> None: ...
    @overload
    def __init__(self, arg0: CVoxelMap) -> None: ...
    @overload
    def __init__(self, arg0: CVoxelMap) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CVoxelMap: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...

class CVoxelMapBase_mrpt_maps_VoxelNodeOccRGB_t(CMetricMap):
    genericMapParams: TMapGenericParams
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    @overload
    def assign(self, o: CVoxelMapBase_mrpt_maps_VoxelNodeOccRGB_t) -> CVoxelMapBase_mrpt_maps_VoxelNodeOccRGB_t: ...
    @overload
    def assign(self) -> CMetricMap: ...
    @overload
    def auxParticleFilterCleanUp(self) -> None: ...
    @overload
    def auxParticleFilterCleanUp() -> void: ...
    def boundingBox(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def canComputeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation) -> bool: ...
    @overload
    def canComputeObservationLikelihood(constclassmrpt) -> bool: ...
    @overload
    def canComputeObservationsLikelihood(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def canComputeObservationsLikelihood(constclassmrpt) -> bool: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def compute3DMatchingRatio(self, *args, **kwargs) -> Any: ...
    def computeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    def computeObservationsLikelihood(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    def determineMatching2D(self, *args, **kwargs) -> Any: ...
    def determineMatching3D(self, *args, **kwargs) -> Any: ...
    @overload
    def getAsOctoMapVoxels(self, gl_obj: mrpt.pymrpt.mrpt.opengl.COctoMapVoxels) -> None: ...
    @overload
    def getAsOctoMapVoxels(classmrpt) -> void: ...
    def getAsSimplePointsMap(self) -> CSimplePointsMap: ...
    @overload
    def getVisualizationInto(self, o: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def insertObs(self, obs: mrpt.pymrpt.mrpt.obs.CObservation) -> bool: ...
    @overload
    def insertObs(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, robotPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    @overload
    def insertObs(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def insertObs(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame, robotPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    @overload
    def loadFromSimpleMap(self, Map: CSimpleMap) -> None: ...
    @overload
    def loadFromSimpleMap(constclassmrpt) -> void: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    def squareDistanceToClosestCorrespondence(self, x0: float, y0: float) -> float: ...

class CVoxelMapBase_mrpt_maps_VoxelNodeOccupancy_t(CMetricMap):
    genericMapParams: TMapGenericParams
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    @overload
    def assign(self, o: CVoxelMapBase_mrpt_maps_VoxelNodeOccupancy_t) -> CVoxelMapBase_mrpt_maps_VoxelNodeOccupancy_t: ...
    @overload
    def assign(self) -> CMetricMap: ...
    @overload
    def auxParticleFilterCleanUp(self) -> None: ...
    @overload
    def auxParticleFilterCleanUp() -> void: ...
    def boundingBox(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def canComputeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation) -> bool: ...
    @overload
    def canComputeObservationLikelihood(constclassmrpt) -> bool: ...
    @overload
    def canComputeObservationsLikelihood(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def canComputeObservationsLikelihood(constclassmrpt) -> bool: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def compute3DMatchingRatio(self, *args, **kwargs) -> Any: ...
    def computeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    def computeObservationsLikelihood(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    def determineMatching2D(self, *args, **kwargs) -> Any: ...
    def determineMatching3D(self, *args, **kwargs) -> Any: ...
    @overload
    def getAsOctoMapVoxels(self, gl_obj: mrpt.pymrpt.mrpt.opengl.COctoMapVoxels) -> None: ...
    @overload
    def getAsOctoMapVoxels(classmrpt) -> void: ...
    def getAsSimplePointsMap(self) -> CSimplePointsMap: ...
    @overload
    def getVisualizationInto(self, o: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    @overload
    def insertObs(self, obs: mrpt.pymrpt.mrpt.obs.CObservation) -> bool: ...
    @overload
    def insertObs(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, robotPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    @overload
    def insertObs(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def insertObs(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame, robotPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    @overload
    def loadFromSimpleMap(self, Map: CSimpleMap) -> None: ...
    @overload
    def loadFromSimpleMap(constclassmrpt) -> void: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    def squareDistanceToClosestCorrespondence(self, x0: float, y0: float) -> float: ...

class CVoxelMapOccupancyBase_mrpt_maps_VoxelNodeOccRGB_signed_char_t(CVoxelMapBase_mrpt_maps_VoxelNodeOccRGB_t, NearestNeighborsCapable):
    genericMapParams: TMapGenericParams
    insertionOptions: TVoxelMap_InsertionOptions
    likelihoodOptions: TVoxelMap_LikelihoodOptions
    renderingOptions: TVoxelMap_RenderingOptions
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    @overload
    def assign(self) -> CVoxelMapOccupancyBase_mrpt_maps_VoxelNodeOccRGB_signed_char_t: ...
    @overload
    def assign(self, o: CVoxelMapBase_mrpt_maps_VoxelNodeOccRGB_t) -> CVoxelMapBase_mrpt_maps_VoxelNodeOccRGB_t: ...
    @overload
    def assign(self) -> CMetricMap: ...
    @overload
    def assign(self) -> NearestNeighborsCapable: ...
    @overload
    def auxParticleFilterCleanUp(self) -> None: ...
    @overload
    def auxParticleFilterCleanUp() -> void: ...
    @overload
    def boundingBox(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def boundingBox(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def canComputeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation) -> bool: ...
    @overload
    def canComputeObservationLikelihood(constclassmrpt) -> bool: ...
    @overload
    def canComputeObservationsLikelihood(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def canComputeObservationsLikelihood(constclassmrpt) -> bool: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def compute3DMatchingRatio(self, *args, **kwargs) -> Any: ...
    def computeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    def computeObservationsLikelihood(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    def determineMatching2D(self, *args, **kwargs) -> Any: ...
    def determineMatching3D(self, *args, **kwargs) -> Any: ...
    @overload
    def getAsOctoMapVoxels(self, gl_obj: mrpt.pymrpt.mrpt.opengl.COctoMapVoxels) -> None: ...
    @overload
    def getAsOctoMapVoxels(classmrpt) -> void: ...
    @overload
    def getAsOctoMapVoxels(self, gl_obj: mrpt.pymrpt.mrpt.opengl.COctoMapVoxels) -> None: ...
    @overload
    def getAsOctoMapVoxels(classmrpt) -> void: ...
    def getAsSimplePointsMap(self) -> CSimplePointsMap: ...
    def getOccupiedVoxels(self) -> CSimplePointsMap: ...
    def getPointOccupancy(self, x: float, y: float, z: float, prob_occupancy: float) -> bool: ...
    @overload
    def getVisualizationInto(self, o: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    def get_logodd_lut(self, *args, **kwargs) -> Any: ...
    @overload
    def insertObs(self, obs: mrpt.pymrpt.mrpt.obs.CObservation) -> bool: ...
    @overload
    def insertObs(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, robotPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    @overload
    def insertObs(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def insertObs(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame, robotPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    def l2p(self, *args, **kwargs) -> Any: ...
    def l2p_255(self, *args, **kwargs) -> Any: ...
    @overload
    def loadFromSimpleMap(self, Map: CSimpleMap) -> None: ...
    @overload
    def loadFromSimpleMap(constclassmrpt) -> void: ...
    @overload
    def nn_has_indices_or_ids(self) -> bool: ...
    @overload
    def nn_has_indices_or_ids() -> bool: ...
    @overload
    def nn_has_indices_or_ids(self) -> bool: ...
    @overload
    def nn_has_indices_or_ids() -> bool: ...
    @overload
    def nn_index_count(self) -> int: ...
    @overload
    def nn_index_count() -> size_t: ...
    @overload
    def nn_index_count(self) -> int: ...
    @overload
    def nn_index_count() -> size_t: ...
    @overload
    def nn_prepare_for_2d_queries(self) -> None: ...
    @overload
    def nn_prepare_for_2d_queries() -> void: ...
    @overload
    def nn_prepare_for_2d_queries(self) -> None: ...
    @overload
    def nn_prepare_for_2d_queries() -> void: ...
    @overload
    def nn_prepare_for_3d_queries(self) -> None: ...
    @overload
    def nn_prepare_for_3d_queries() -> void: ...
    @overload
    def nn_prepare_for_3d_queries(self) -> None: ...
    @overload
    def nn_prepare_for_3d_queries() -> void: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrID: int) -> bool: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrID: int) -> bool: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrIDOrID: int) -> bool: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrIDOrID: int) -> bool: ...
    def p2l(self, *args, **kwargs) -> Any: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    def squareDistanceToClosestCorrespondence(self, x0: float, y0: float) -> float: ...
    def updateCell_fast_free(self, theCell, logodd_obs: int, thres: int) -> None: ...
    def updateCell_fast_occupied(self, theCell, logodd_obs: int, thres: int) -> None: ...
    def updateVoxel(self, x: float, y: float, z: float, occupied: bool) -> None: ...

class CVoxelMapOccupancyBase_mrpt_maps_VoxelNodeOccupancy_signed_char_t(CVoxelMapBase_mrpt_maps_VoxelNodeOccupancy_t, NearestNeighborsCapable):
    genericMapParams: TMapGenericParams
    insertionOptions: TVoxelMap_InsertionOptions
    likelihoodOptions: TVoxelMap_LikelihoodOptions
    renderingOptions: TVoxelMap_RenderingOptions
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    @overload
    def assign(self) -> CVoxelMapOccupancyBase_mrpt_maps_VoxelNodeOccupancy_signed_char_t: ...
    @overload
    def assign(self, o: CVoxelMapBase_mrpt_maps_VoxelNodeOccupancy_t) -> CVoxelMapBase_mrpt_maps_VoxelNodeOccupancy_t: ...
    @overload
    def assign(self) -> CMetricMap: ...
    @overload
    def assign(self) -> NearestNeighborsCapable: ...
    @overload
    def auxParticleFilterCleanUp(self) -> None: ...
    @overload
    def auxParticleFilterCleanUp() -> void: ...
    @overload
    def boundingBox(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def boundingBox(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def canComputeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation) -> bool: ...
    @overload
    def canComputeObservationLikelihood(constclassmrpt) -> bool: ...
    @overload
    def canComputeObservationsLikelihood(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def canComputeObservationsLikelihood(constclassmrpt) -> bool: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def compute3DMatchingRatio(self, *args, **kwargs) -> Any: ...
    def computeObservationLikelihood(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    def computeObservationsLikelihood(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame, takenFrom: mrpt.pymrpt.mrpt.poses.CPose3D) -> float: ...
    def determineMatching2D(self, *args, **kwargs) -> Any: ...
    def determineMatching3D(self, *args, **kwargs) -> Any: ...
    @overload
    def getAsOctoMapVoxels(self, gl_obj: mrpt.pymrpt.mrpt.opengl.COctoMapVoxels) -> None: ...
    @overload
    def getAsOctoMapVoxels(classmrpt) -> void: ...
    @overload
    def getAsOctoMapVoxels(self, gl_obj: mrpt.pymrpt.mrpt.opengl.COctoMapVoxels) -> None: ...
    @overload
    def getAsOctoMapVoxels(classmrpt) -> void: ...
    def getAsSimplePointsMap(self) -> CSimplePointsMap: ...
    def getOccupiedVoxels(self) -> CSimplePointsMap: ...
    def getPointOccupancy(self, x: float, y: float, z: float, prob_occupancy: float) -> bool: ...
    @overload
    def getVisualizationInto(self, o: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...
    def get_logodd_lut(self, *args, **kwargs) -> Any: ...
    @overload
    def insertObs(self, obs: mrpt.pymrpt.mrpt.obs.CObservation) -> bool: ...
    @overload
    def insertObs(self, obs: mrpt.pymrpt.mrpt.obs.CObservation, robotPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    @overload
    def insertObs(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame) -> bool: ...
    @overload
    def insertObs(self, sf: mrpt.pymrpt.mrpt.obs.CSensoryFrame, robotPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> bool: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    def l2p(self, *args, **kwargs) -> Any: ...
    def l2p_255(self, *args, **kwargs) -> Any: ...
    @overload
    def loadFromSimpleMap(self, Map: CSimpleMap) -> None: ...
    @overload
    def loadFromSimpleMap(constclassmrpt) -> void: ...
    @overload
    def nn_has_indices_or_ids(self) -> bool: ...
    @overload
    def nn_has_indices_or_ids() -> bool: ...
    @overload
    def nn_has_indices_or_ids(self) -> bool: ...
    @overload
    def nn_has_indices_or_ids() -> bool: ...
    @overload
    def nn_index_count(self) -> int: ...
    @overload
    def nn_index_count() -> size_t: ...
    @overload
    def nn_index_count(self) -> int: ...
    @overload
    def nn_index_count() -> size_t: ...
    @overload
    def nn_prepare_for_2d_queries(self) -> None: ...
    @overload
    def nn_prepare_for_2d_queries() -> void: ...
    @overload
    def nn_prepare_for_2d_queries(self) -> None: ...
    @overload
    def nn_prepare_for_2d_queries() -> void: ...
    @overload
    def nn_prepare_for_3d_queries(self) -> None: ...
    @overload
    def nn_prepare_for_3d_queries() -> void: ...
    @overload
    def nn_prepare_for_3d_queries(self) -> None: ...
    @overload
    def nn_prepare_for_3d_queries() -> void: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrID: int) -> bool: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrID: int) -> bool: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrIDOrID: int) -> bool: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrIDOrID: int) -> bool: ...
    def p2l(self, *args, **kwargs) -> Any: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    @overload
    def saveMetricMapRepresentationToFile(self, filNamePrefix: str) -> None: ...
    @overload
    def saveMetricMapRepresentationToFile(conststd) -> void: ...
    def squareDistanceToClosestCorrespondence(self, x0: float, y0: float) -> float: ...
    def updateCell_fast_free(self, theCell, logodd_obs: int, thres: int) -> None: ...
    def updateCell_fast_occupied(self, theCell, logodd_obs: int, thres: int) -> None: ...
    def updateVoxel(self, x: float, y: float, z: float, occupied: bool) -> None: ...

class CVoxelMapRGB(CVoxelMapOccupancyBase_mrpt_maps_VoxelNodeOccRGB_signed_char_t):
    class TMapDefinition(CVoxelMapRGB.TMapDefinitionBase):
        inner_bits: int
        insertionOpts: TVoxelMap_InsertionOptions
        leaf_bits: int
        likelihoodOpts: TVoxelMap_LikelihoodOptions
        resolution: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CVoxelMapRGB.TMapDefinition) -> None: ...
        @overload
        def __init__(self, arg0: CVoxelMapRGB.TMapDefinition) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: int) -> None: ...
    @overload
    def __init__(self, resolution: float, inner_bits: int, leaf_bits: int) -> None: ...
    @overload
    def __init__(self, arg0: CVoxelMapRGB) -> None: ...
    @overload
    def __init__(self, arg0: CVoxelMapRGB) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CVoxelMapRGB: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...

class CWeightedPointsMap(CPointsMap):
    class TMapDefinition(CWeightedPointsMap.TMapDefinitionBase):
        insertionOpts: CPointsMap.TInsertionOptions
        likelihoodOpts: CPointsMap.TLikelihoodOptions
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CWeightedPointsMap.TMapDefinition) -> None: ...
        @overload
        def __init__(self, arg0: CWeightedPointsMap.TMapDefinition) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, o: CPointsMap) -> None: ...
    @overload
    def __init__(self, arg0: CWeightedPointsMap) -> None: ...
    @overload
    def __init__(self, arg0: CWeightedPointsMap) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def assign(self, o: CPointsMap) -> CWeightedPointsMap: ...
    @overload
    def assign(self, o: CWeightedPointsMap) -> CWeightedPointsMap: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getPointWeight(self, index: int) -> int: ...
    @overload
    def getPointWeight(size_t) -> unsignedint: ...
    @overload
    def insertPointFast(self, x: float, y: float) -> None: ...
    @overload
    def insertPointFast(self, x: float, y: float, z: float) -> None: ...
    def reserve(self, newLength: int) -> None: ...
    @overload
    def resize(self, newLength: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def setPointWeight(self, index: int, w: int) -> None: ...
    @overload
    def setPointWeight(size_t, uint64_t) -> void: ...
    @overload
    def setSize(self, newLength: int) -> None: ...
    @overload
    def setSize(size_t) -> void: ...

class CWirelessPowerGridMap2D(CRandomFieldGridMap2D):
    class TInsertionOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions, CRandomFieldGridMap2D.TInsertionOptionsCommon):
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CWirelessPowerGridMap2D.TInsertionOptions) -> None: ...
        @overload
        def __init__(self, arg0: CWirelessPowerGridMap2D.TInsertionOptions) -> None: ...
        def assign(self) -> CWirelessPowerGridMap2D.TInsertionOptions: ...
        @overload
        def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
        @overload
        def loadFromConfigFile(constclassmrpt, conststd) -> void: ...

    class TMapDefinition(CWirelessPowerGridMap2D.TMapDefinitionBase):
        insertionOpts: CWirelessPowerGridMap2D.TInsertionOptions
        mapType: CRandomFieldGridMap2D.TMapRepresentation
        max_x: float
        max_y: float
        min_x: float
        min_y: float
        resolution: float
        def __init__(self) -> None: ...

    class TMapDefinitionBase:
        def __init__(self, *args, **kwargs) -> None: ...
    insertionOptions: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, arg0: CRandomFieldGridMap2D.TMapRepresentation, arg1: float, arg2: float, arg3: float, arg4: float) -> None: ...
    @overload
    def __init__(self, mapType: CRandomFieldGridMap2D.TMapRepresentation, x_min: float, x_max: float, y_min: float, y_max: float, resolution: float) -> None: ...
    @overload
    def __init__(self, arg0: CWirelessPowerGridMap2D) -> None: ...
    @overload
    def __init__(self, arg0: CWirelessPowerGridMap2D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CWirelessPowerGridMap2D: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getVisualizationInto(self, outObj: mrpt.pymrpt.mrpt.opengl.CSetOfObjects) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...

class NearestNeighborsCapable:
    def __init__(self, *args, **kwargs) -> None: ...
    def assign(self) -> NearestNeighborsCapable: ...
    @overload
    def nn_has_indices_or_ids(self) -> bool: ...
    @overload
    def nn_has_indices_or_ids() -> bool: ...
    @overload
    def nn_index_count(self) -> int: ...
    @overload
    def nn_index_count() -> size_t: ...
    @overload
    def nn_prepare_for_2d_queries(self) -> None: ...
    @overload
    def nn_prepare_for_2d_queries() -> void: ...
    @overload
    def nn_prepare_for_3d_queries(self) -> None: ...
    @overload
    def nn_prepare_for_3d_queries() -> void: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrIDOrID: int) -> bool: ...
    @overload
    def nn_single_search(self, query, result, out_dist_sqr: float, resultIndexOrIDOrID: int) -> bool: ...

class OccGridCellTraits:
    def __init__(self) -> None: ...

class THeightGridmapCell:
    h: float
    u: float
    v: float
    var: float
    w: int
    def __init__(self) -> None: ...

class TMapGenericParams(mrpt.pymrpt.mrpt.config.CLoadableOptions, mrpt.pymrpt.mrpt.serialization.CSerializable):
    enableObservationInsertion: bool
    enableObservationLikelihood: bool
    enableSaveAs3DObject: bool
    @overload
    def __init__(self, arg0: TMapGenericParams) -> None: ...
    @overload
    def __init__(self, arg0: TMapGenericParams) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> TMapGenericParams: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def loadFromConfigFile(self, source, sectionNamePrefix: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    @overload
    def saveToConfigFile(self, target, section: str) -> None: ...
    @overload
    def saveToConfigFile(classmrpt, conststd) -> void: ...

class TMatchingExtraResults:
    correspondencesRatio: float
    sumSqrDist: float
    def __init__(self) -> None: ...

class TMatchingParams:
    angularDistPivotPoint: Any
    decimation_other_map_points: int
    maxAngularDistForCorrespondence: float
    maxDistForCorrespondence: float
    offset_other_map_points: int
    onlyKeepTheClosest: bool
    onlyUniqueRobust: bool
    def __init__(self) -> None: ...

class TMatchingRatioParams:
    maxDistForCorr: float
    maxMahaDistForCorr: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TMatchingRatioParams) -> None: ...
    def assign(self) -> TMatchingRatioParams: ...

class TRandomFieldCell:
    dmv_var_mean: float
    last_updated: mrpt.pymrpt.std.chrono.time_point_mrpt_Clock_std_chrono_duration_long_std_ratio_1_10000000_t
    param1_: float
    param2_: float
    updated_std: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, kfmean_dm_mean: float) -> None: ...
    @overload
    def __init__(self, kfmean_dm_mean: float, kfstd_dmmeanw: float) -> None: ...
    def dm_mean(self) -> float: ...
    def dm_mean_w(self) -> float: ...
    def gmrf_mean(self) -> float: ...
    def gmrf_std(self) -> float: ...
    def kf_mean(self) -> float: ...
    def kf_std(self) -> float: ...

class TRandomFieldVoxel:
    mean_value: float
    stddev_value: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, _mean_value: float) -> None: ...
    @overload
    def __init__(self, _mean_value: float, _stddev_value: float) -> None: ...

class TSetOfMetricMapInitializers(mrpt.pymrpt.mrpt.config.CLoadableOptions):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TSetOfMetricMapInitializers) -> None: ...
    @overload
    def __init__(self, arg0: TSetOfMetricMapInitializers) -> None: ...
    def assign(self) -> TSetOfMetricMapInitializers: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def loadFromConfigFile(self, *args, **kwargs) -> Any: ...
    @overload
    def saveToConfigFile(self, target, section: str) -> None: ...
    @overload
    def saveToConfigFile(classmrpt, conststd) -> void: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class TVoxelMap_InsertionOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
    clamp_max: float
    clamp_min: float
    decimation: int
    max_range: float
    prob_hit: float
    prob_miss: float
    ray_trace_free_space: bool
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TVoxelMap_InsertionOptions) -> None: ...
    @overload
    def __init__(self, arg0: TVoxelMap_InsertionOptions) -> None: ...
    def assign(self) -> TVoxelMap_InsertionOptions: ...
    @overload
    def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    @overload
    def readFromStream(self, in: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
    @overload
    def readFromStream(classmrpt) -> void: ...
    @overload
    def saveToConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
    @overload
    def saveToConfigFile(classmrpt, conststd) -> void: ...
    @overload
    def writeToStream(self, out: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
    @overload
    def writeToStream(classmrpt) -> void: ...

class TVoxelMap_LikelihoodOptions(mrpt.pymrpt.mrpt.config.CLoadableOptions):
    decimate_up_to: int
    occupiedThreshold: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TVoxelMap_LikelihoodOptions) -> None: ...
    @overload
    def __init__(self, arg0: TVoxelMap_LikelihoodOptions) -> None: ...
    def assign(self) -> TVoxelMap_LikelihoodOptions: ...
    @overload
    def loadFromConfigFile(self, source: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    @overload
    def readFromStream(self, in: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
    @overload
    def readFromStream(classmrpt) -> void: ...
    @overload
    def saveToConfigFile(self, c: mrpt.pymrpt.mrpt.config.CConfigFileBase, s: str) -> None: ...
    @overload
    def saveToConfigFile(classmrpt, conststd) -> void: ...
    @overload
    def writeToStream(self, out: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
    @overload
    def writeToStream(classmrpt) -> void: ...

class TVoxelMap_RenderingOptions:
    freeThreshold: float
    generateFreeVoxels: bool
    generateOccupiedVoxels: bool
    occupiedThreshold: float
    visibleFreeVoxels: bool
    visibleOccupiedVoxels: bool
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TVoxelMap_RenderingOptions) -> None: ...
    def assign(self) -> TVoxelMap_RenderingOptions: ...
    @overload
    def readFromStream(self, in: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
    @overload
    def readFromStream(classmrpt) -> void: ...
    @overload
    def writeToStream(self, out: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
    @overload
    def writeToStream(classmrpt) -> void: ...

class VoxelNodeOccRGB:
    class TColor:
        B: int
        G: int
        R: int
        def __init__(self) -> None: ...
    color: Any
    numColObs: int
    occupancy: int
    def __init__(self) -> None: ...
    def occupancyRef(self) -> int: ...

class VoxelNodeOccupancy:
    occupancy: int
    def __init__(self) -> None: ...
    def occupancyRef(self) -> int: ...

class mrptEventMetricMapClear(mrpt.pymrpt.mrpt.system.mrptEvent):
    def __init__(self, smap) -> None: ...
    def assign(self) -> mrptEventMetricMapClear: ...

class mrptEventMetricMapInsert(mrpt.pymrpt.mrpt.system.mrptEvent):
    @overload
    def __init__(self, arg0: mrptEventMetricMapInsert) -> None: ...
    @overload
    def __init__(self, arg0: mrptEventMetricMapInsert) -> None: ...
    @property
    def inserted_robotPose(self) -> Optional[mrpt.pymrpt.mrpt.poses.CPose3D]: ...
