#include <iterator>
#include <memory>
#include <mrpt/math/CMatrixDynamic.h>
#include <mrpt/math/CMatrixFixed.h>
#include <mrpt/math/MatrixBase.h>
#include <mrpt/math/TPoint2D.h>
#include <mrpt/math/TPoint3D.h>
#include <mrpt/math/TPose2D.h>
#include <mrpt/math/TPose3D.h>
#include <mrpt/math/matrix_size_t.h>
#include <sstream> // __str__
#include <string>
#include <vector>

#include <functional>
#include <pybind11/pybind11.h>
#include <string>
#include <pybind11/stl.h>


#ifndef BINDER_PYBIND11_TYPE_CASTER
	#define BINDER_PYBIND11_TYPE_CASTER
	PYBIND11_DECLARE_HOLDER_TYPE(T, std::shared_ptr<T>)
	PYBIND11_DECLARE_HOLDER_TYPE(T, T*)
	PYBIND11_MAKE_OPAQUE(std::shared_ptr<void>)
#endif

void bind_mrpt_math_MatrixBase(std::function< pybind11::module &(std::string const &namespace_) > &M)
{
	{ // mrpt::math::MatrixBase file:mrpt/math/MatrixBase.h line:23
		pybind11::class_<mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>, std::shared_ptr<mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>>, mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>> cl(M("mrpt::math"), "MatrixBase_mrpt_math_TPoint3D_float_mrpt_math_CMatrixDynamic_mrpt_math_TPoint3D_float_t", "");
		cl.def( pybind11::init( [](){ return new mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>(); } ) );
		cl.def( pybind11::init( [](mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >> const &o){ return new mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>(o); } ) );
		cl.def("mbDerived", (class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > & (mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)()) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::mbDerived, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::mbDerived() --> class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > &", pybind11::return_value_policy::automatic);
		cl.def("setDiagonal", (void (mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(const unsigned long, const struct mrpt::math::TPoint3D_<float>)) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setDiagonal, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setDiagonal(const unsigned long, const struct mrpt::math::TPoint3D_<float>) --> void", pybind11::arg("N"), pybind11::arg("value"));
		cl.def("setDiagonal", (void (mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(const struct mrpt::math::TPoint3D_<float>)) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setDiagonal, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setDiagonal(const struct mrpt::math::TPoint3D_<float>) --> void", pybind11::arg("value"));
		cl.def("setIdentity", (void (mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)()) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setIdentity, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setIdentity() --> void");
		cl.def("setIdentity", (void (mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(const unsigned long)) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setIdentity, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setIdentity(const unsigned long) --> void", pybind11::arg("N"));
		cl.def_static("Identity", (class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > (*)()) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::Identity, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::Identity() --> class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> >");
		cl.def_static("Identity", (class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > (*)(const unsigned long)) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::Identity, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::Identity(const unsigned long) --> class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> >", pybind11::arg("N"));
		cl.def("matProductOf_AB", (void (mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(const class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > &, const class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > &)) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::matProductOf_AB, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::matProductOf_AB(const class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > &, const class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > &) --> void", pybind11::arg("A"), pybind11::arg("B"));
		cl.def("det", (struct mrpt::math::TPoint3D_<float> (mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)() const) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::det, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::det() const --> struct mrpt::math::TPoint3D_<float>");
		cl.def("inverse", (class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > (mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)() const) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::inverse, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::inverse() const --> class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> >");
		cl.def("inverse_LLt", (class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > (mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)() const) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::inverse_LLt, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::inverse_LLt() const --> class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> >");
		cl.def("rank", [](mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >> const &o) -> int { return o.rank(); }, "");
		cl.def("rank", (int (mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(struct mrpt::math::TPoint3D_<float>) const) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::rank, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::rank(struct mrpt::math::TPoint3D_<float>) const --> int", pybind11::arg("threshold"));
		cl.def("chol", (bool (mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > &) const) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::chol, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::chol(class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > &) const --> bool", pybind11::arg("U"));
		cl.def("maximumDiagonal", (struct mrpt::math::TPoint3D_<float> (mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)() const) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::maximumDiagonal, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::maximumDiagonal() const --> struct mrpt::math::TPoint3D_<float>");
		cl.def("minimumDiagonal", (struct mrpt::math::TPoint3D_<float> (mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)() const) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::minimumDiagonal, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::minimumDiagonal() const --> struct mrpt::math::TPoint3D_<float>");
		cl.def("trace", (struct mrpt::math::TPoint3D_<float> (mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)() const) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::trace, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::trace() const --> struct mrpt::math::TPoint3D_<float>");
		cl.def("assign", (class mrpt::math::MatrixBase<struct mrpt::math::TPoint3D_<float>, class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > > & (mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(const class mrpt::math::MatrixBase<struct mrpt::math::TPoint3D_<float>, class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > > &)) &mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator=, "C++: mrpt::math::MatrixBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator=(const class mrpt::math::MatrixBase<struct mrpt::math::TPoint3D_<float>, class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > > &) --> class mrpt::math::MatrixBase<struct mrpt::math::TPoint3D_<float>, class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > > &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("fill", (void (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(const struct mrpt::math::TPoint3D_<float> &)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::fill, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::fill(const struct mrpt::math::TPoint3D_<float> &) --> void", pybind11::arg("val"));
		cl.def("setConstant", (void (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(const struct mrpt::math::TPoint3D_<float>)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setConstant, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setConstant(const struct mrpt::math::TPoint3D_<float>) --> void", pybind11::arg("value"));
		cl.def("setConstant", (void (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(size_t, size_t, const struct mrpt::math::TPoint3D_<float>)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setConstant, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setConstant(size_t, size_t, const struct mrpt::math::TPoint3D_<float>) --> void", pybind11::arg("nrows"), pybind11::arg("ncols"), pybind11::arg("value"));
		cl.def("setConstant", (void (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(size_t, const struct mrpt::math::TPoint3D_<float>)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setConstant, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setConstant(size_t, const struct mrpt::math::TPoint3D_<float>) --> void", pybind11::arg("nrows"), pybind11::arg("value"));
		cl.def_static("Constant", (class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > (*)(const struct mrpt::math::TPoint3D_<float>)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::Constant, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::Constant(const struct mrpt::math::TPoint3D_<float>) --> class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> >", pybind11::arg("value"));
		cl.def_static("Constant", (class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > (*)(size_t, size_t, const struct mrpt::math::TPoint3D_<float>)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::Constant, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::Constant(size_t, size_t, const struct mrpt::math::TPoint3D_<float>) --> class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> >", pybind11::arg("nrows"), pybind11::arg("ncols"), pybind11::arg("value"));
		cl.def("assign", (void (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(const unsigned long, const struct mrpt::math::TPoint3D_<float>)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::assign, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::assign(const unsigned long, const struct mrpt::math::TPoint3D_<float>) --> void", pybind11::arg("N"), pybind11::arg("value"));
		cl.def("setZero", (void (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)()) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setZero, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setZero() --> void");
		cl.def("setZero", (void (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(size_t, size_t)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setZero, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setZero(size_t, size_t) --> void", pybind11::arg("nrows"), pybind11::arg("ncols"));
		cl.def("setZero", (void (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(size_t)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setZero, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::setZero(size_t) --> void", pybind11::arg("nrows"));
		cl.def_static("Zero", (class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > (*)()) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::Zero, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::Zero() --> class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> >");
		cl.def_static("Zero", (class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > (*)(size_t, size_t)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::Zero, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::Zero(size_t, size_t) --> class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> >", pybind11::arg("nrows"), pybind11::arg("ncols"));
		cl.def("coeffRef", (struct mrpt::math::TPoint3D_<float> & (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(int, int)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::coeffRef, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::coeffRef(int, int) --> struct mrpt::math::TPoint3D_<float> &", pybind11::return_value_policy::automatic, pybind11::arg("r"), pybind11::arg("c"));
		cl.def("coeff", (const struct mrpt::math::TPoint3D_<float> & (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(int, int) const) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::coeff, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::coeff(int, int) const --> const struct mrpt::math::TPoint3D_<float> &", pybind11::return_value_policy::automatic, pybind11::arg("r"), pybind11::arg("c"));
		cl.def("isSquare", (bool (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)() const) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::isSquare, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::isSquare() const --> bool");
		cl.def("empty", (bool (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)() const) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::empty, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::empty() const --> bool");
		cl.def("norm_inf", (struct mrpt::math::TPoint3D_<float> (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)() const) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::norm_inf, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::norm_inf() const --> struct mrpt::math::TPoint3D_<float>");
		cl.def("norm", (struct mrpt::math::TPoint3D_<float> (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)() const) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::norm, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::norm() const --> struct mrpt::math::TPoint3D_<float>");
		cl.def("__iadd__", (void (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(struct mrpt::math::TPoint3D_<float>)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator+=, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator+=(struct mrpt::math::TPoint3D_<float>) --> void", pybind11::arg("s"));
		cl.def("__isub__", (void (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(struct mrpt::math::TPoint3D_<float>)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator-=, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator-=(struct mrpt::math::TPoint3D_<float>) --> void", pybind11::arg("s"));
		cl.def("__imul__", (void (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(struct mrpt::math::TPoint3D_<float>)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator*=, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator*=(struct mrpt::math::TPoint3D_<float>) --> void", pybind11::arg("s"));
		cl.def("__add__", (class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(const class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > &) const) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator+, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator+(const class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > &) const --> class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> >", pybind11::arg("m2"));
		cl.def("__iadd__", (void (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(const class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > &)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator+=, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator+=(const class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > &) --> void", pybind11::arg("m2"));
		cl.def("__isub__", (void (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(const class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > &)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator-=, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator-=(const class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > &) --> void", pybind11::arg("m2"));
		cl.def("sum", (struct mrpt::math::TPoint3D_<float> (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)() const) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::sum, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::sum() const --> struct mrpt::math::TPoint3D_<float>");
		cl.def("sum_abs", (struct mrpt::math::TPoint3D_<float> (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)() const) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::sum_abs, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::sum_abs() const --> struct mrpt::math::TPoint3D_<float>");
		cl.def("asString", (std::string (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)() const) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::asString, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::asString() const --> std::string");
		cl.def("inMatlabFormat", [](mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >> const &o) -> std::string { return o.inMatlabFormat(); }, "");
		cl.def("inMatlabFormat", (std::string (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(const unsigned long) const) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::inMatlabFormat, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::inMatlabFormat(const unsigned long) const --> std::string", pybind11::arg("decimal_digits"));
		cl.def("saveToTextFile", [](mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >> const &o, const std::string & a0) -> void { return o.saveToTextFile(a0); }, "", pybind11::arg("file"));
		cl.def("saveToTextFile", [](mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >> const &o, const std::string & a0, enum mrpt::math::TMatrixTextFileFormat const & a1) -> void { return o.saveToTextFile(a0, a1); }, "", pybind11::arg("file"), pybind11::arg("fileFormat"));
		cl.def("saveToTextFile", [](mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >> const &o, const std::string & a0, enum mrpt::math::TMatrixTextFileFormat const & a1, bool const & a2) -> void { return o.saveToTextFile(a0, a1, a2); }, "", pybind11::arg("file"), pybind11::arg("fileFormat"), pybind11::arg("appendMRPTHeader"));
		cl.def("saveToTextFile", (void (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(const std::string &, enum mrpt::math::TMatrixTextFileFormat, bool, const std::string &) const) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::saveToTextFile, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::saveToTextFile(const std::string &, enum mrpt::math::TMatrixTextFileFormat, bool, const std::string &) const --> void", pybind11::arg("file"), pybind11::arg("fileFormat"), pybind11::arg("appendMRPTHeader"), pybind11::arg("userHeader"));
		cl.def("loadFromTextFile", (void (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(const std::string &)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::loadFromTextFile, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::loadFromTextFile(const std::string &) --> void", pybind11::arg("file"));
		cl.def("assign", (class mrpt::math::MatrixVectorBase<struct mrpt::math::TPoint3D_<float>, class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > > & (mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>,mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float> >>::*)(const class mrpt::math::MatrixVectorBase<struct mrpt::math::TPoint3D_<float>, class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > > &)) &mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator=, "C++: mrpt::math::MatrixVectorBase<mrpt::math::TPoint3D_<float>, mrpt::math::CMatrixDynamic<mrpt::math::TPoint3D_<float>>>::operator=(const class mrpt::math::MatrixVectorBase<struct mrpt::math::TPoint3D_<float>, class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > > &) --> class mrpt::math::MatrixVectorBase<struct mrpt::math::TPoint3D_<float>, class mrpt::math::CMatrixDynamic<struct mrpt::math::TPoint3D_<float> > > &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
}
