# Check for the libpcap library 
# ==============================

OPTION(DISABLE_PCAP "Disable using the PCAP library" "OFF")
MARK_AS_ADVANCED(DISABLE_PCAP)

SET(CMAKE_MRPT_HAS_LIBPCAP 0)
SET(CMAKE_MRPT_HAS_LIBPCAP_SYSTEM 0)

IF (NOT DISABLE_PCAP)
	FIND_PACKAGE(PCAP QUIET)
	IF(PCAP_FOUND)
		SET(CMAKE_MRPT_HAS_LIBPCAP 1)
		SET(CMAKE_MRPT_HAS_LIBPCAP_SYSTEM 1)

		IF ($ENV{VERBOSE})
			MESSAGE(STATUS "Found libpcap:")
			MESSAGE(STATUS "  PCAP_INCLUDE_DIR :${PCAP_INCLUDE_DIR}")
			MESSAGE(STATUS "  PCAP_LIBRARY     :${PCAP_LIBRARY}")
		ENDIF()

	ENDIF()
ENDIF()

