/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2023 Intel Corporation
 */

#ifndef __INTEL_VDSC_REGS_H__
#define __INTEL_VDSC_REGS_H__

#include "intel_display_reg_defs.h"

/* Display Stream Splitter Control */
#define DSS_CTL1				_MMIO(0x67400)
#define  SPLITTER_ENABLE			(1 << 31)
#define  JOINER_ENABLE				(1 << 30)
#define  DUAL_LINK_MODE_INTERLEAVE		(1 << 24)
#define  DUAL_LINK_MODE_FRONTBACK		(0 << 24)
#define  OVERLAP_PIXELS_MASK			(0xf << 16)
#define  OVERLAP_PIXELS(pixels)			((pixels) << 16)
#define  LEFT_DL_BUF_TARGET_DEPTH_MASK		(0xfff << 0)
#define  LEFT_DL_BUF_TARGET_DEPTH(pixels)	((pixels) << 0)
#define  MAX_DL_BUFFER_TARGET_DEPTH		0x5a0

#define DSS_CTL2				_MMIO(0x67404)
#define  LEFT_BRANCH_VDSC_ENABLE		(1 << 31)
#define  RIGHT_BRANCH_VDSC_ENABLE		(1 << 15)
#define  RIGHT_DL_BUF_TARGET_DEPTH_MASK		(0xfff << 0)
#define  RIGHT_DL_BUF_TARGET_DEPTH(pixels)	((pixels) << 0)

#define _ICL_PIPE_DSS_CTL1_PB			0x78200
#define _ICL_PIPE_DSS_CTL1_PC			0x78400
#define ICL_PIPE_DSS_CTL1(pipe)			_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_PIPE_DSS_CTL1_PB, \
							   _ICL_PIPE_DSS_CTL1_PC)
#define  BIG_JOINER_ENABLE			(1 << 29)
#define  PRIMARY_BIG_JOINER_ENABLE		(1 << 28)
#define  VGA_CENTERING_ENABLE			(1 << 27)
#define  SPLITTER_CONFIGURATION_MASK		REG_GENMASK(26, 25)
#define  SPLITTER_CONFIGURATION_2_SEGMENT	REG_FIELD_PREP(SPLITTER_CONFIGURATION_MASK, 0)
#define  SPLITTER_CONFIGURATION_4_SEGMENT	REG_FIELD_PREP(SPLITTER_CONFIGURATION_MASK, 1)
#define  UNCOMPRESSED_JOINER_PRIMARY		(1 << 21)
#define  UNCOMPRESSED_JOINER_SECONDARY		(1 << 20)

#define _ICL_PIPE_DSS_CTL2_PB			0x78204
#define _ICL_PIPE_DSS_CTL2_PC			0x78404
#define ICL_PIPE_DSS_CTL2(pipe)			_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_PIPE_DSS_CTL2_PB, \
							   _ICL_PIPE_DSS_CTL2_PC)

/* Icelake Display Stream Compression Registers */
#define DSCA_PICTURE_PARAMETER_SET_0		_MMIO(0x6B200)
#define DSCC_PICTURE_PARAMETER_SET_0		_MMIO(0x6BA00)
#define _DSCA_PPS_0				0x6B200
#define _DSCC_PPS_0				0x6BA00
#define DSCA_PPS(pps)				_MMIO(_DSCA_PPS_0 + ((pps) < 12 ? (pps) : (pps) + 12) * 4)
#define DSCC_PPS(pps)				_MMIO(_DSCC_PPS_0 + ((pps) < 12 ? (pps) : (pps) + 12) * 4)
#define _ICL_DSC0_PICTURE_PARAMETER_SET_0_PB	0x78270
#define _ICL_DSC1_PICTURE_PARAMETER_SET_0_PB	0x78370
#define _ICL_DSC0_PICTURE_PARAMETER_SET_0_PC	0x78470
#define _ICL_DSC1_PICTURE_PARAMETER_SET_0_PC	0x78570
#define ICL_DSC0_PICTURE_PARAMETER_SET_0(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_0_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_0_PC)
#define ICL_DSC1_PICTURE_PARAMETER_SET_0(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_0_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_0_PC)
#define _ICL_DSC0_PPS_0(pipe)			_PICK_EVEN((pipe) - PIPE_B, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_0_PB, \
							   _ICL_DSC0_PICTURE_PARAMETER_SET_0_PC)
#define _ICL_DSC1_PPS_0(pipe)			_PICK_EVEN((pipe) - PIPE_B, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_0_PB, \
							   _ICL_DSC1_PICTURE_PARAMETER_SET_0_PC)
#define  ICL_DSC0_PPS(pipe, pps)		_MMIO(_ICL_DSC0_PPS_0(pipe) + ((pps) * 4))
#define  ICL_DSC1_PPS(pipe, pps)		_MMIO(_ICL_DSC1_PPS_0(pipe) + ((pps) * 4))

/* PPS 0 */
#define   DSC_PPS0_NATIVE_422_ENABLE		REG_BIT(23)
#define   DSC_PPS0_NATIVE_420_ENABLE		REG_BIT(22)
#define   DSC_PPS0_ALT_ICH_SEL			REG_BIT(20)
#define   DSC_PPS0_VBR_ENABLE			REG_BIT(19)
#define   DSC_PPS0_422_ENABLE			REG_BIT(18)
#define   DSC_PPS0_COLOR_SPACE_CONVERSION	REG_BIT(17)
#define   DSC_PPS0_BLOCK_PREDICTION		REG_BIT(16)
#define   DSC_PPS0_LINE_BUF_DEPTH_MASK		REG_GENMASK(15, 12)
#define   DSC_PPS0_LINE_BUF_DEPTH(depth)	REG_FIELD_PREP(DSC_PPS0_LINE_BUF_DEPTH_MASK, depth)
#define   DSC_PPS0_BPC_MASK			REG_GENMASK(11, 8)
#define   DSC_PPS0_BPC(bpc)			REG_FIELD_PREP(DSC_PPS0_BPC_MASK, bpc)
#define   DSC_PPS0_VER_MINOR_MASK		REG_GENMASK(7, 4)
#define   DSC_PPS0_VER_MINOR(minor)		REG_FIELD_PREP(DSC_PPS0_VER_MINOR_MASK, minor)
#define   DSC_PPS0_VER_MAJOR_MASK		REG_GENMASK(3, 0)
#define   DSC_PPS0_VER_MAJOR(major)		REG_FIELD_PREP(DSC_PPS0_VER_MAJOR_MASK, major)

/* PPS 1 */
#define   DSC_PPS1_BPP_MASK			REG_GENMASK(9, 0)
#define   DSC_PPS1_BPP(bpp)			REG_FIELD_PREP(DSC_PPS1_BPP_MASK, bpp)

/* PPS 2 */
#define   DSC_PPS2_PIC_WIDTH_MASK		REG_GENMASK(31, 16)
#define   DSC_PPS2_PIC_HEIGHT_MASK		REG_GENMASK(15, 0)
#define   DSC_PPS2_PIC_WIDTH(pic_width)		REG_FIELD_PREP(DSC_PPS2_PIC_WIDTH_MASK, pic_width)
#define   DSC_PPS2_PIC_HEIGHT(pic_height)	REG_FIELD_PREP(DSC_PPS2_PIC_HEIGHT_MASK, pic_height)

/* PPS 3 */
#define   DSC_PPS3_SLICE_WIDTH_MASK		REG_GENMASK(31, 16)
#define   DSC_PPS3_SLICE_HEIGHT_MASK		REG_GENMASK(15, 0)
#define   DSC_PPS3_SLICE_WIDTH(slice_width)	REG_FIELD_PREP(DSC_PPS3_SLICE_WIDTH_MASK, slice_width)
#define   DSC_PPS3_SLICE_HEIGHT(slice_height)	REG_FIELD_PREP(DSC_PPS3_SLICE_HEIGHT_MASK, slice_height)

/* PPS 4 */
#define   DSC_PPS4_INITIAL_DEC_DELAY_MASK	REG_GENMASK(31, 16)
#define   DSC_PPS4_INITIAL_XMIT_DELAY_MASK	REG_GENMASK(9, 0)
#define   DSC_PPS4_INITIAL_DEC_DELAY(dec_delay)	REG_FIELD_PREP(DSC_PPS4_INITIAL_DEC_DELAY_MASK, \
							       dec_delay)
#define   DSC_PPS4_INITIAL_XMIT_DELAY(xmit_delay)	REG_FIELD_PREP(DSC_PPS4_INITIAL_XMIT_DELAY_MASK, \
								       xmit_delay)

/* PPS 5 */
#define   DSC_PPS5_SCALE_DEC_INT_MASK		REG_GENMASK(27, 16)
#define   DSC_PPS5_SCALE_INC_INT_MASK		REG_GENMASK(15, 0)
#define   DSC_PPS5_SCALE_DEC_INT(scale_dec)	REG_FIELD_PREP(DSC_PPS5_SCALE_DEC_INT_MASK, scale_dec)
#define   DSC_PPS5_SCALE_INC_INT(scale_inc)	REG_FIELD_PREP(DSC_PPS5_SCALE_INC_INT_MASK, scale_inc)

/* PPS 6 */
#define   DSC_PPS6_FLATNESS_MAX_QP_MASK		REG_GENMASK(28, 24)
#define   DSC_PPS6_FLATNESS_MIN_QP_MASK		REG_GENMASK(20, 16)
#define   DSC_PPS6_FIRST_LINE_BPG_OFFSET_MASK	REG_GENMASK(12, 8)
#define   DSC_PPS6_INITIAL_SCALE_VALUE_MASK	REG_GENMASK(5, 0)
#define   DSC_PPS6_FLATNESS_MAX_QP(max_qp)	REG_FIELD_PREP(DSC_PPS6_FLATNESS_MAX_QP_MASK, max_qp)
#define   DSC_PPS6_FLATNESS_MIN_QP(min_qp)	REG_FIELD_PREP(DSC_PPS6_FLATNESS_MIN_QP_MASK, min_qp)
#define   DSC_PPS6_FIRST_LINE_BPG_OFFSET(offset)	REG_FIELD_PREP(DSC_PPS6_FIRST_LINE_BPG_OFFSET_MASK, \
								       offset)
#define   DSC_PPS6_INITIAL_SCALE_VALUE(value)	REG_FIELD_PREP(DSC_PPS6_INITIAL_SCALE_VALUE_MASK, \
							       value)

/* PPS 7 */
#define   DSC_PPS7_NFL_BPG_OFFSET_MASK		REG_GENMASK(31, 16)
#define   DSC_PPS7_SLICE_BPG_OFFSET_MASK	REG_GENMASK(15, 0)
#define   DSC_PPS7_NFL_BPG_OFFSET(bpg_offset)	REG_FIELD_PREP(DSC_PPS7_NFL_BPG_OFFSET_MASK, bpg_offset)
#define   DSC_PPS7_SLICE_BPG_OFFSET(bpg_offset)	REG_FIELD_PREP(DSC_PPS7_SLICE_BPG_OFFSET_MASK, \
							       bpg_offset)
/* PPS 8 */
#define   DSC_PPS8_INITIAL_OFFSET_MASK		REG_GENMASK(31, 16)
#define   DSC_PPS8_FINAL_OFFSET_MASK		REG_GENMASK(15, 0)
#define   DSC_PPS8_INITIAL_OFFSET(initial_offset)	REG_FIELD_PREP(DSC_PPS8_INITIAL_OFFSET_MASK, \
								       initial_offset)
#define   DSC_PPS8_FINAL_OFFSET(final_offset)	REG_FIELD_PREP(DSC_PPS8_FINAL_OFFSET_MASK, \
							       final_offset)

/* PPS 9 */
#define   DSC_PPS9_RC_EDGE_FACTOR_MASK		REG_GENMASK(19, 16)
#define   DSC_PPS9_RC_MODEL_SIZE_MASK		REG_GENMASK(15, 0)
#define   DSC_PPS9_RC_EDGE_FACTOR(rc_edge_fact)	REG_FIELD_PREP(DSC_PPS9_RC_EDGE_FACTOR_MASK, \
							       rc_edge_fact)
#define   DSC_PPS9_RC_MODEL_SIZE(rc_model_size)	REG_FIELD_PREP(DSC_PPS9_RC_MODEL_SIZE_MASK, \
							       rc_model_size)

/* PPS 10 */
#define   DSC_PPS10_RC_TGT_OFF_LOW_MASK		REG_GENMASK(23, 20)
#define   DSC_PPS10_RC_TGT_OFF_HIGH_MASK	REG_GENMASK(19, 16)
#define   DSC_PPS10_RC_QUANT_INC_LIMIT1_MASK	REG_GENMASK(12, 8)
#define   DSC_PPS10_RC_QUANT_INC_LIMIT0_MASK	REG_GENMASK(4, 0)
#define   DSC_PPS10_RC_TARGET_OFF_LOW(rc_tgt_off_low)	REG_FIELD_PREP(DSC_PPS10_RC_TGT_OFF_LOW_MASK, \
								       rc_tgt_off_low)
#define   DSC_PPS10_RC_TARGET_OFF_HIGH(rc_tgt_off_high)	REG_FIELD_PREP(DSC_PPS10_RC_TGT_OFF_HIGH_MASK, \
								       rc_tgt_off_high)
#define   DSC_PPS10_RC_QUANT_INC_LIMIT1(lim)	REG_FIELD_PREP(DSC_PPS10_RC_QUANT_INC_LIMIT1_MASK, lim)
#define   DSC_PPS10_RC_QUANT_INC_LIMIT0(lim)	REG_FIELD_PREP(DSC_PPS10_RC_QUANT_INC_LIMIT0_MASK, lim)

/* PPS 16 */
#define   DSC_PPS16_SLICE_ROW_PR_FRME_MASK	REG_GENMASK(31, 20)
#define   DSC_PPS16_SLICE_PER_LINE_MASK		REG_GENMASK(18, 16)
#define   DSC_PPS16_SLICE_CHUNK_SIZE_MASK	REG_GENMASK(15, 0)
#define   DSC_PPS16_SLICE_ROW_PER_FRAME(slice_row_per_frame)	REG_FIELD_PREP(DSC_PPS16_SLICE_ROW_PR_FRME_MASK, \
									       slice_row_per_frame)
#define   DSC_PPS16_SLICE_PER_LINE(slice_per_line)		REG_FIELD_PREP(DSC_PPS16_SLICE_PER_LINE_MASK, \
									       slice_per_line)
#define   DSC_PPS16_SLICE_CHUNK_SIZE(slice_chunk_size)		REG_FIELD_PREP(DSC_PPS16_SLICE_CHUNK_SIZE_MASK, \
									       slice_chunk_size)

/* PPS 17 (MTL+) */
#define   DSC_PPS17_SL_BPG_OFFSET_MASK		REG_GENMASK(31, 27)
#define   DSC_PPS17_SL_BPG_OFFSET(offset)	REG_FIELD_PREP(DSC_PPS17_SL_BPG_OFFSET_MASK, offset)

/* PPS 18 (MTL+) */
#define   DSC_PPS18_NSL_BPG_OFFSET_MASK		REG_GENMASK(31, 16)
#define   DSC_PPS18_SL_OFFSET_ADJ_MASK		REG_GENMASK(15, 0)
#define   DSC_PPS18_NSL_BPG_OFFSET(offset)	REG_FIELD_PREP(DSC_PPS18_NSL_BPG_OFFSET_MASK, offset)
#define   DSC_PPS18_SL_OFFSET_ADJ(offset)	REG_FIELD_PREP(DSC_PPS18_SL_OFFSET_ADJ_MASK, offset)

/* Icelake Rate Control Buffer Threshold Registers */
#define DSCA_RC_BUF_THRESH_0			_MMIO(0x6B230)
#define DSCA_RC_BUF_THRESH_0_UDW		_MMIO(0x6B230 + 4)
#define DSCC_RC_BUF_THRESH_0			_MMIO(0x6BA30)
#define DSCC_RC_BUF_THRESH_0_UDW		_MMIO(0x6BA30 + 4)
#define _ICL_DSC0_RC_BUF_THRESH_0_PB		(0x78254)
#define _ICL_DSC0_RC_BUF_THRESH_0_UDW_PB	(0x78254 + 4)
#define _ICL_DSC1_RC_BUF_THRESH_0_PB		(0x78354)
#define _ICL_DSC1_RC_BUF_THRESH_0_UDW_PB	(0x78354 + 4)
#define _ICL_DSC0_RC_BUF_THRESH_0_PC		(0x78454)
#define _ICL_DSC0_RC_BUF_THRESH_0_UDW_PC	(0x78454 + 4)
#define _ICL_DSC1_RC_BUF_THRESH_0_PC		(0x78554)
#define _ICL_DSC1_RC_BUF_THRESH_0_UDW_PC	(0x78554 + 4)
#define ICL_DSC0_RC_BUF_THRESH_0(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC0_RC_BUF_THRESH_0_PB, \
						_ICL_DSC0_RC_BUF_THRESH_0_PC)
#define ICL_DSC0_RC_BUF_THRESH_0_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC0_RC_BUF_THRESH_0_UDW_PB, \
						_ICL_DSC0_RC_BUF_THRESH_0_UDW_PC)
#define ICL_DSC1_RC_BUF_THRESH_0(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC1_RC_BUF_THRESH_0_PB, \
						_ICL_DSC1_RC_BUF_THRESH_0_PC)
#define ICL_DSC1_RC_BUF_THRESH_0_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC1_RC_BUF_THRESH_0_UDW_PB, \
						_ICL_DSC1_RC_BUF_THRESH_0_UDW_PC)

#define DSCA_RC_BUF_THRESH_1			_MMIO(0x6B238)
#define DSCA_RC_BUF_THRESH_1_UDW		_MMIO(0x6B238 + 4)
#define DSCC_RC_BUF_THRESH_1			_MMIO(0x6BA38)
#define DSCC_RC_BUF_THRESH_1_UDW		_MMIO(0x6BA38 + 4)
#define _ICL_DSC0_RC_BUF_THRESH_1_PB		(0x7825C)
#define _ICL_DSC0_RC_BUF_THRESH_1_UDW_PB	(0x7825C + 4)
#define _ICL_DSC1_RC_BUF_THRESH_1_PB		(0x7835C)
#define _ICL_DSC1_RC_BUF_THRESH_1_UDW_PB	(0x7835C + 4)
#define _ICL_DSC0_RC_BUF_THRESH_1_PC		(0x7845C)
#define _ICL_DSC0_RC_BUF_THRESH_1_UDW_PC	(0x7845C + 4)
#define _ICL_DSC1_RC_BUF_THRESH_1_PC		(0x7855C)
#define _ICL_DSC1_RC_BUF_THRESH_1_UDW_PC	(0x7855C + 4)
#define ICL_DSC0_RC_BUF_THRESH_1(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC0_RC_BUF_THRESH_1_PB, \
						_ICL_DSC0_RC_BUF_THRESH_1_PC)
#define ICL_DSC0_RC_BUF_THRESH_1_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC0_RC_BUF_THRESH_1_UDW_PB, \
						_ICL_DSC0_RC_BUF_THRESH_1_UDW_PC)
#define ICL_DSC1_RC_BUF_THRESH_1(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC1_RC_BUF_THRESH_1_PB, \
						_ICL_DSC1_RC_BUF_THRESH_1_PC)
#define ICL_DSC1_RC_BUF_THRESH_1_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
						_ICL_DSC1_RC_BUF_THRESH_1_UDW_PB, \
						_ICL_DSC1_RC_BUF_THRESH_1_UDW_PC)

/* Icelake DSC Rate Control Range Parameter Registers */
#define DSCA_RC_RANGE_PARAMETERS_0		_MMIO(0x6B240)
#define DSCA_RC_RANGE_PARAMETERS_0_UDW		_MMIO(0x6B240 + 4)
#define DSCC_RC_RANGE_PARAMETERS_0		_MMIO(0x6BA40)
#define DSCC_RC_RANGE_PARAMETERS_0_UDW		_MMIO(0x6BA40 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_0_PB	(0x78208)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_0_UDW_PB	(0x78208 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_0_PB	(0x78308)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_0_UDW_PB	(0x78308 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_0_PC	(0x78408)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_0_UDW_PC	(0x78408 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_0_PC	(0x78508)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_0_UDW_PC	(0x78508 + 4)
#define ICL_DSC0_RC_RANGE_PARAMETERS_0(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_0_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_0_PC)
#define ICL_DSC0_RC_RANGE_PARAMETERS_0_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_0_UDW_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_0_UDW_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_0(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_0_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_0_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_0_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_0_UDW_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_0_UDW_PC)
#define RC_BPG_OFFSET_SHIFT			10
#define RC_MAX_QP_SHIFT				5
#define RC_MIN_QP_SHIFT				0

#define DSCA_RC_RANGE_PARAMETERS_1		_MMIO(0x6B248)
#define DSCA_RC_RANGE_PARAMETERS_1_UDW		_MMIO(0x6B248 + 4)
#define DSCC_RC_RANGE_PARAMETERS_1		_MMIO(0x6BA48)
#define DSCC_RC_RANGE_PARAMETERS_1_UDW		_MMIO(0x6BA48 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_1_PB	(0x78210)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_1_UDW_PB	(0x78210 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_1_PB	(0x78310)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_1_UDW_PB	(0x78310 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_1_PC	(0x78410)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_1_UDW_PC	(0x78410 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_1_PC	(0x78510)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_1_UDW_PC	(0x78510 + 4)
#define ICL_DSC0_RC_RANGE_PARAMETERS_1(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_1_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_1_PC)
#define ICL_DSC0_RC_RANGE_PARAMETERS_1_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_1_UDW_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_1_UDW_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_1(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_1_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_1_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_1_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_1_UDW_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_1_UDW_PC)

#define DSCA_RC_RANGE_PARAMETERS_2		_MMIO(0x6B250)
#define DSCA_RC_RANGE_PARAMETERS_2_UDW		_MMIO(0x6B250 + 4)
#define DSCC_RC_RANGE_PARAMETERS_2		_MMIO(0x6BA50)
#define DSCC_RC_RANGE_PARAMETERS_2_UDW		_MMIO(0x6BA50 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_2_PB	(0x78218)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_2_UDW_PB	(0x78218 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_2_PB	(0x78318)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_2_UDW_PB	(0x78318 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_2_PC	(0x78418)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_2_UDW_PC	(0x78418 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_2_PC	(0x78518)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_2_UDW_PC	(0x78518 + 4)
#define ICL_DSC0_RC_RANGE_PARAMETERS_2(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_2_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_2_PC)
#define ICL_DSC0_RC_RANGE_PARAMETERS_2_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_2_UDW_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_2_UDW_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_2(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_2_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_2_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_2_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_2_UDW_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_2_UDW_PC)

#define DSCA_RC_RANGE_PARAMETERS_3		_MMIO(0x6B258)
#define DSCA_RC_RANGE_PARAMETERS_3_UDW		_MMIO(0x6B258 + 4)
#define DSCC_RC_RANGE_PARAMETERS_3		_MMIO(0x6BA58)
#define DSCC_RC_RANGE_PARAMETERS_3_UDW		_MMIO(0x6BA58 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_3_PB	(0x78220)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_3_UDW_PB	(0x78220 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_3_PB	(0x78320)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_3_UDW_PB	(0x78320 + 4)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_3_PC	(0x78420)
#define _ICL_DSC0_RC_RANGE_PARAMETERS_3_UDW_PC	(0x78420 + 4)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_3_PC	(0x78520)
#define _ICL_DSC1_RC_RANGE_PARAMETERS_3_UDW_PC	(0x78520 + 4)
#define ICL_DSC0_RC_RANGE_PARAMETERS_3(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_3_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_3_PC)
#define ICL_DSC0_RC_RANGE_PARAMETERS_3_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_3_UDW_PB, \
							_ICL_DSC0_RC_RANGE_PARAMETERS_3_UDW_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_3(pipe)		_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_3_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_3_PC)
#define ICL_DSC1_RC_RANGE_PARAMETERS_3_UDW(pipe)	_MMIO_PIPE((pipe) - PIPE_B, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_3_UDW_PB, \
							_ICL_DSC1_RC_RANGE_PARAMETERS_3_UDW_PC)

#endif /* __INTEL_VDSC_REGS_H__ */
