//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.1.5-b01-fcs
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a>
// Any modifications to this file will be lost upon recompilation of the source schema.
// Generated on: 2018.02.02 at 02:42:15 PM MEZ
//
/**************************************************************************************
  	This file is part of GNU DataExplorer.

    GNU DataExplorer is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    DataExplorer is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU DataExplorer.  If not, see <https://www.gnu.org/licenses/>.

    Copyright (c) 2017,2018,2019 Thomas Eickert
****************************************************************************************/

package gde.histo.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.stream.IntStream;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.sun.istack.Nullable;

import gde.GDE;
import gde.log.Logger;

/**
 * aggregated history recordset data related to measurements, settlements and
 * 				scores.
 * 				No localization required.
 *
 *
 * <p>Java class for histoVault complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="histoVault">
 *   &lt;complexContent>
 *     &lt;restriction base="{https://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="vaultName" type="{https://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="vaultDirectory" type="{https://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="vaultReaderSettings" type="{https://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="vaultCreated_ms" type="{https://www.w3.org/2001/XMLSchema}long"/>
 *         &lt;element name="vaultDataExplorerVersion" type="{https://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="vaultDeviceKey" type="{https://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="vaultDeviceName" type="{https://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="vaultChannelNumber" type="{https://www.w3.org/2001/XMLSchema}int"/>
 *         &lt;element name="vaultObjectKey" type="{https://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="vaultSamplingTimespan_ms" type="{https://www.w3.org/2001/XMLSchema}long"/>
 *         &lt;element name="logLinkPath" type="{https://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="logFilePath" type="{https://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="logFileLastModified" type="{https://www.w3.org/2001/XMLSchema}long"/>
 *         &lt;element name="logFileLength" type="{https://www.w3.org/2001/XMLSchema}long"/>
 *         &lt;element name="logObjectDirectory" type="{https://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="logFileVersion" type="{https://www.w3.org/2001/XMLSchema}int"/>
 *         &lt;element name="logRecordSetSize" type="{https://www.w3.org/2001/XMLSchema}int"/>
 *         &lt;element name="logRecordSetOrdinal" type="{https://www.w3.org/2001/XMLSchema}int"/>
 *         &lt;element name="logRecordsetBaseName" type="{https://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="logDeviceName" type="{https://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="logChannelNumber" type="{https://www.w3.org/2001/XMLSchema}int"/>
 *         &lt;element name="logObjectKey" type="{https://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="logStartTimestamp_ms" type="{https://www.w3.org/2001/XMLSchema}long"/>
 *         &lt;element name="measurements" type="{}compartmentsType"/>
 *         &lt;element name="settlements" type="{}compartmentsType"/>
 *         &lt;element name="scores" type="{}pointsType"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */

/**
 * Suitable for history persistence and xml serialization.
 * The object has two stages:
 *  - truss: does not hold measurement, settlement or score points
 *  - vault: the number of points conform to the device xml for settlements and scores, but only a subset of measurements is required
 * Find the constructors and non-xsd code a good way down for simplified merging with JAXB generated class.
 * @author Thomas Eickert
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "histoVault", propOrder = {
    "vaultName",
    "vaultDirectory",
    "vaultReaderSettings",
    "vaultCreated_ms",
    "vaultDataExplorerVersion",
    "vaultDeviceKey",
    "vaultDeviceName",
    "vaultChannelNumber",
    "vaultObjectKey",
    "vaultSamplingTimespan_ms",
    "logLinkPath",
    "logFilePath",
    "logFileLastModified",
    "logFileLength",
    "logObjectDirectory",
    "logFileVersion",
    "logRecordSetSize",
    "logRecordSetOrdinal",
    "logRecordsetBaseName",
    "logDeviceName",
    "logChannelNumber",
    "logObjectKey",
    "logStartTimestamp_ms",
    "measurements",
    "settlements",
    "scores"
})
public class HistoVault {
	private static JAXBContext									jaxbContext;

	@XmlElement(required = true)
	protected String														vaultName;
	@XmlElement(required = true)
	protected String														vaultDirectory;
  @XmlElement(required = true)
  protected String 														vaultReaderSettings;
	@XmlElement(required = true)
	protected long															vaultCreated_ms;
	@XmlElement(required = true)
	protected String														vaultDataExplorerVersion;
	@XmlElement(required = true)
	protected String														vaultDeviceKey;
	@XmlElement(required = true)
	protected String														vaultDeviceName;
	protected int																vaultChannelNumber;
	@XmlElement(required = true)
	protected String														vaultObjectKey;
	@XmlElement(required = true)
	protected long															vaultSamplingTimespan_ms;
  @Deprecated // replaced by loadLinkPath -> remains in the vault for information purposes only
	@XmlElement(required = true)
	protected String 														logLinkPath;
	@XmlElement(required = true)
	protected String														logFilePath;
	protected long															logFileLastModified;
	protected long															logFileLength;
  @Deprecated // replaced by loadObjectDirectory -> remains in the vault for information purposes only
	@XmlElement(required = true)
	protected String														logObjectDirectory;
	protected int																logFileVersion;
	protected int																logRecordSetSize;
	protected int																logRecordSetOrdinal;
	@XmlElement(required = true)
	protected String														logRecordsetBaseName;
	@XmlElement(required = true)
	protected String														logDeviceName;
	protected int																logChannelNumber;
	@XmlElement(required = true)
	protected String														logObjectKey;
	@XmlElement(required = true)
	protected long															logStartTimestamp_ms;
	@XmlElement(required = true)
	@XmlJavaTypeAdapter(CompartmentsTypeAdapter.class)
	protected HashMap<Integer, CompartmentType>	measurements;
	@XmlElement(required = true)
	@XmlJavaTypeAdapter(CompartmentsTypeAdapter.class)
	protected HashMap<Integer, CompartmentType>	settlements;
	@XmlElement(required = true)
	@XmlJavaTypeAdapter(PointsTypeAdapter.class)
	protected HashMap<Integer, PointType>				scores;

	public HistoVault() {
		}

	/**
	 * Shallow copy.
	 * @param histoVault
	 */
	public HistoVault(HistoVault histoVault) {
		this.vaultName = histoVault.vaultName;
		this.vaultDirectory = histoVault.vaultDirectory;
		this.vaultCreated_ms = histoVault.vaultCreated_ms;

		this.vaultReaderSettings = histoVault.vaultReaderSettings;

		this.vaultDataExplorerVersion = histoVault.vaultDataExplorerVersion;
		this.vaultDeviceKey = histoVault.vaultDeviceKey;
		this.vaultDeviceName = histoVault.vaultDeviceName;
		this.vaultChannelNumber = histoVault.vaultChannelNumber;
		this.vaultObjectKey = histoVault.vaultObjectKey;
		this.vaultSamplingTimespan_ms = histoVault.vaultSamplingTimespan_ms;

		this.logLinkPath = histoVault.logLinkPath;
		this.logFilePath = histoVault.logFilePath;
		this.logFileLastModified = histoVault.logFileLastModified;
		this.logFileLength = histoVault.logFileLength;
		this.logFileVersion = histoVault.logFileVersion;

		this.logObjectDirectory = histoVault.logObjectDirectory;
		this.logRecordSetSize = histoVault.logRecordSetSize;
		this.logRecordSetOrdinal = histoVault.logRecordSetOrdinal;
		this.logRecordsetBaseName = histoVault.logRecordsetBaseName;
		this.logDeviceName = histoVault.logDeviceName;
		this.logChannelNumber = histoVault.logChannelNumber;
		this.logObjectKey = histoVault.logObjectKey;
		this.logStartTimestamp_ms = histoVault.logStartTimestamp_ms;

		this.measurements = histoVault.measurements;
		this.settlements = histoVault.settlements;
		this.scores = histoVault.scores;
}

	/**
	   * Gets the value of the vaultName property.
	   *
	   * @return
	   *     possible object is
	   *     {@link String }
	   *
	   */
	public String getVaultName() {
		return vaultName;
	}

	/**
	   * Sets the value of the vaultName property.
	   *
	   * @param value
	   *     allowed object is
	   *     {@link String }
	   *
	   */
	public void setVaultName(String value) {
		this.vaultName = value;
	}

	/**
	* Gets the value of the vaultDirectory property.
	*
	* @return
	*     possible object is
	*     {@link String }
	*
	*/
	public String getVaultDirectory() {
		return vaultDirectory;
	}

	/**
	 * Sets the value of the vaultDirectory property.
	 *
	 * @param value
	 *     allowed object is
	 *     {@link String }
	 *
	 */
	public void setVaultDirectory(String value) {
		this.vaultDirectory = value;
	}

		/**
		 * Vault measurement values may depend on device settings modifiable by the user.
		 * Consequently we create different vaults for different settings.</br>
		 * Pls note that OSD files are created without preserving the device reader settings.</br>
		 * A non-empty string indicates that the file reader delivers different measurement values based on device settings.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getVaultReaderSettings() {
        return vaultReaderSettings;
    }

    /**
     * Sets the value of the vaultReaderSettings property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setVaultReaderSettings(String value) {
        this.vaultReaderSettings = value;
    }

  	/**
  	 * Gets the value of the vaultCreatedMs property.
  	 *
  	 */
  	public long getVaultCreated_ms() {
  		return vaultCreated_ms;
  	}

    /**
	   * Sets the value of the vaultCreatedMs property.
	   *
	   */
	public void setVaultCreated_ms(long value) {
		this.vaultCreated_ms = value;
	}

	/**
	 * Gets the value of the vaultDataExplorerVersion property.
	*
	 * @return
	 *     possible object is
	 *     {@link String }
	 *
	*/
	public String getVaultDataExplorerVersion() {
		return vaultDataExplorerVersion;
	}

	/**
	 * Sets the value of the vaultDataExplorerVersion property.
	 *
	 * @param value
	 *     allowed object is
	 *     {@link String }
	 *
	 */
	public void setVaultDataExplorerVersion(String value) {
		this.vaultDataExplorerVersion = value;
	}

	/**
	   * Gets the value of the vaultDeviceKey property.
	 *
	 * @return
	 *     possible object is
	   *     {@link String }
	 *
	 */
	public String getVaultDeviceKey() {
		return vaultDeviceKey;
	}

	/**
	 * Sets the value of the vaultDeviceKey property.
	 *
	 * @param value
	 *     allowed object is
	 *     {@link String }
	 *
	 */
	public void setVaultDeviceKey(String value) {
		this.vaultDeviceKey = value;
	}

	/**
	   * Gets the value of the vaultDeviceName property.
	   *
	   * @return
	   *     possible object is
	   *     {@link String }
	   *
	   */
	public String getVaultDeviceName() {
		return vaultDeviceName;
	}

	/**
	 * Sets the value of the vaultDeviceName property.
	 *
	 * @param value
	 *     allowed object is
	 *     {@link String }
	 *
	 */
	public void setVaultDeviceName(String value) {
		this.vaultDeviceName = value;
	}

	/**
	 * @return the channel number which was active during vault creation.
	 */
	public int getVaultChannelNumber() {
		return vaultChannelNumber;
	}

	/**
	   * Sets the value of the vaultChannelNumber property.
	   *
	   */
	public void setVaultChannelNumber(int value) {
		this.vaultChannelNumber = value;
	}

	/**
	 * Gets the value of the vaultObjectKey property.
	*
	* @return
	*     possible object is
	*     {@link String }
	*
	*/
	public String getVaultObjectKey() {
		return vaultObjectKey;
	}

	/**
	 * Sets the value of the vaultObjectKey property.
	 *
	 * @param value
	 *     allowed object is
	 *     {@link String }
	 *
	 */
	public void setVaultObjectKey(String value) {
		this.vaultObjectKey = value;
	}

	/**
	 * Gets the value of the vaultSamplingTimespanMs property.
	 *
	 */
	public long getVaultSamplingTimespan_ms() {
		return vaultSamplingTimespan_ms;
	}

	/**
	 * Sets the value of the vaultSamplingTimespanMs property.
	 *
	 */
	public void setVaultSamplingTimespan_ms(long value) {
		this.vaultSamplingTimespan_ms = value;
	}

	/**
     * Gets the value of the logLinkPath property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
  @Deprecated // replaced by loadLinkPath -> remains in the vault for information purposes only
    public String getLogLinkPath() {
        return logLinkPath;
    }

    /**
     * Sets the value of the logLinkPath property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
  @Deprecated // replaced by loadFilePath -> remains in the vault for information purposes only
    public void setLogLinkPath(String value) {
        this.logLinkPath = value;
    }

    /**
	 * Gets the value of the logFilePath property.
	 * Check out the LoadFilePath property of the ExtendedVault supporting multiple copies of the file.
	 * @return
	 *     possible object is
	 *     {@link String }
	 *
	 */
	public String getLogFilePath() {
		return logFilePath;
	}

	/**
	 * Sets the value of the logFilePath property.
	 *
	 * @param value
	 *     allowed object is
	 *     {@link String }
	 *
	 */
  public void setLogFilePath(String value) {
		this.logFilePath = value;
	}

	/**
	 * Gets the value of the logFileLastModified property.
	 *
	 */
	public long getLogFileLastModified() {
		return logFileLastModified;
	}

	/**
	 * Sets the value of the logFileLastModified property.
	 *
	 */
	public void setLogFileLastModified(long value) {
		this.logFileLastModified = value;
	}

	/**
	 * Gets the value of the logFileLength property.
	 *
	 */
	public long getLogFileLength() {
		return logFileLength;
	}

	/**
	 * Sets the value of the logFileLength property.
	 *
	 */
	public void setLogFileLength(long value) {
		this.logFileLength = value;
	}

	/**
	 * Gets the value of the logObjectDirectory property.
	 *
	 * @return
	 *     possible object is
	 *     {@link String }
	 *
	 */
  @Deprecated // replaced by loadObjectDirectory -> remains in the vault for information purposes only
	public String getLogObjectDirectory() {
		return logObjectDirectory;
	}

	/**
	   * Sets the value of the logObjectDirectory property.
	   *
	   * @param value
	   *     allowed object is
	   *     {@link String }
	   *
	   */
  @Deprecated // replaced by loadObjectDirectory -> remains in the vault for information purposes only
	public void setLogObjectDirectory(String value) {
		this.logObjectDirectory = value;
	}

	/**
	* Gets the value of the logFileVersion property.
	*
	*/
	public int getLogFileVersion() {
		return logFileVersion;
	}

	/**
	 * Sets the value of the logFileVersion property.
	 *
	 */
	public void setLogFileVersion(int value) {
		this.logFileVersion = value;
	}

	/**
	 * Gets the value of the logRecordSetSize property.
	 *
	 */
	public int getLogRecordSetSize() {
		return logRecordSetSize;
	}

	/**
	   * Sets the value of the logRecordSetSize property.
	   *
	   */
	public void setLogRecordSetSize(int value) {
		this.logRecordSetSize = value;
	}

	/**
	 * Gets the value of the logRecordSetOrdinal property.
	*
	*/
	public int getLogRecordSetOrdinal() {
		return logRecordSetOrdinal;
	}

	/**
	   * Sets the value of the logRecordSetOrdinal property.
	   *
	   */
	public void setLogRecordSetOrdinal(int value) {
		this.logRecordSetOrdinal = value;
	}

	/**
	 * Gets the value of the logRecordsetBaseName property.
	*
	* @return
	*     possible object is
	*     {@link String }
	*
	*/
	public String getLogRecordsetBaseName() {
		return logRecordsetBaseName;
	}

	/**
	 * Sets the value of the logRecordsetBaseName property.
	 *
	 * @param value
	 *     allowed object is
	 *     {@link String }
	 *
	 */
	public void setLogRecordsetBaseName(String value) {
		this.logRecordsetBaseName = value;
	}

	/**
	 * Gets the value of the logDeviceName property.
	 *
	 * @return
	 *     possible object is
	 *     {@link String }
	 *
	 */
	public String getLogDeviceName() {
		return logDeviceName;
	}

	/**
	   * Sets the value of the logDeviceName property.
	   *
	   * @param value
	   *     allowed object is
	   *     {@link String }
	   *
	   */
	public void setLogDeviceName(String value) {
		this.logDeviceName = value;
	}

	/**
	* Gets the value of the logChannelNumber property.
	*
	*/
	public int getLogChannelNumber() {
		return logChannelNumber;
	}

	/**
	 * Sets the value of the logChannelNumber property.
	 *
	 */
	public void setLogChannelNumber(int value) {
		this.logChannelNumber = value;
	}

	/**
	 * Gets the value of the logObjectKey property.
	 *
	 * @return
	 *     possible object is
	 *     {@link String }
	 *
	 */
	public String getLogObjectKey() {
		return logObjectKey;
	}

	/**
	 * Sets the value of the logObjectKey property.
	 *
	 * @param value
	 *     allowed object is
	 *     {@link String }
	 *
	 */
	public void setLogObjectKey(String value) {
		this.logObjectKey = value;
	}

	/**
	 * Gets the value of the logStartTimestampMs property.
	 *
	 */
	public long getLogStartTimestamp_ms() {
		return logStartTimestamp_ms;
	}

	/**
	 * Sets the value of the logStartTimestampMs property.
	 *
	 */
	public void setLogStartTimestamp_ms(long value) {
		this.logStartTimestamp_ms = value;
	}

	/**
	 * Gets the value of the measurements property.
	 *
	 * @return
	 *     possible object is
	 *     {@link CompartmentsType }
	 *
	 */
	public HashMap<Integer, CompartmentType> getMeasurements() {
		if (this.measurements == null) this.measurements = new HashMap<Integer, CompartmentType>();
		return measurements;
	}

	/**
	 * Sets the value of the measurements property.
	 *
	 * @param value
	 *     allowed object is
	 *     {@link CompartmentsType }
	 *
	 */
	public void setMeasurements(HashMap<Integer, CompartmentType> value) {
		this.measurements = value;
	}

	/**
	 * Gets the value of the settlements property.
	 *
	 * @return
	 *     possible object is
	 *     {@link CompartmentsType }
	 *
	 */
	public HashMap<Integer, CompartmentType> getSettlements() {
		if (this.settlements == null) this.settlements = new HashMap<Integer, CompartmentType>();
		return settlements;
	}

	/**
	 * Sets the value of the settlements property.
	 *
	 * @param value
	 *     allowed object is
	 *     {@link CompartmentsType }
	 *
	 */
	public void setSettlements(HashMap<Integer, CompartmentType> value) {
		this.settlements = value;
	}

	/**
	 * Gets the value of the scores property.
	 *
	 * @return
	 *     possible object is
	 *     {@link PointsType }
	 *
	 */
	public HashMap<Integer, PointType> getScores() {
		if (this.scores == null) this.scores = new HashMap<Integer, PointType>();
		return scores;
	}

	/**
	 * Sets the value of the scores property.
	 *
	 * @param value
	 *     allowed object is
	 *     {@link PointsType }
	 *
	 */
	public void setScores(HashMap<Integer, PointType> value) {
		this.scores = value;
	}

	/* non JAXB members : start */

	/**
	 * @param measurementOrdinal may specify an ordinal which is not present in the vault (earlier osd file - measurements added in the
	 *          meantime)
	 * @return empty in case of unavailable measurement
	 */
	public HashMap<Integer, PointType> getMeasurementPoints(int measurementOrdinal) {
		return this.getMeasurements().containsKey(measurementOrdinal) ? new HashMap<Integer, PointType>()
				: this.getMeasurements().get(measurementOrdinal).getTrails();
	}

	/**
	 * @param measurementOrdinal may specify an ordinal which is not present in the vault (earlier osd file - measurements added in the
	 *          meantime)
	 * @param trailOrdinal
	 * @return the point value
	 */
	@Nullable // ordinal which is not present in the vault (earlier osd file - entries added in the meantime)
	public Integer getMeasurementPoint(int measurementOrdinal, int trailOrdinal) {
		if (this.getMeasurements().containsKey(measurementOrdinal)) {
			return this.getMeasurements().get(measurementOrdinal).getTrails().containsKey(trailOrdinal)
					? this.getMeasurements().get(measurementOrdinal).getTrails().get(trailOrdinal).value : null;
		} else {
			return null;
		}
	}

	/**
	 * @param measurementOrdinal may specify an ordinal which is not present in the vault (earlier osd file - entries added in the meantime)
	 * @return the points
	 */
	public IntStream getMeasurementOutliers(int measurementOrdinal) {
		if (this.getMeasurements().containsKey(measurementOrdinal)) {
			String points = this.getMeasurements().get(measurementOrdinal).getOutlierPoints();
			if (points != null) return Arrays.stream(points.split(GDE.STRING_CSV_SEPARATOR)).mapToInt(Integer::parseInt);
		}
		return IntStream.empty();
	}

	/**
	 * @param measurementOrdinal may specify an ordinal which is not present in the vault (earlier osd file - entries added in the meantime)
	 * @return the points
	 */
	public IntStream getMeasurementScraps(int measurementOrdinal) {
		if (this.getMeasurements().containsKey(measurementOrdinal)) {
			String points = this.getMeasurements().get(measurementOrdinal).getScrappedPoints();
			if (points != null) return Arrays.stream(points.split(GDE.STRING_CSV_SEPARATOR)).mapToInt(Integer::parseInt);
		}
		return IntStream.empty();
	}

	/**
	 * @param measurementOrdinal may specify an ordinal which is not present in the vault (earlier osd file - entries added in the meantime)
	 * @return false if the measurement does not exist or has no outliers
	 */
	public boolean hasMeasurementOutliers(int measurementOrdinal) {
		if (this.getMeasurements().containsKey(measurementOrdinal)) {
			return this.getMeasurements().get(measurementOrdinal).getOutlierPoints() != null;
		} else {
			return false;
		}
	}

	/**
	 * @param measurementOrdinal may specify an ordinal which is not present in the vault (earlier osd file - entries added in the meantime)
	 * @return the cache data type
	 */
	@Nullable // ordinal which is not present in the vault (earlier osd file - entries added in the meantime)
	public DataTypes getMeasurementDataType(int measurementOrdinal) {
		if (this.getMeasurements().containsKey(measurementOrdinal)) {
			return this.getMeasurements().get(measurementOrdinal).dataType;
		} else {
			return null;
		}
	}

	/**
	 * @param measurementOrdinal may specify an ordinal which is not present in the vault (earlier osd file - entries added in the meantime)
	 * @return false if the measurement does not exist or has no scrapped points
	 */
	public boolean hasMeasurementScraps(int measurementOrdinal) {
		if (this.getMeasurements().containsKey(measurementOrdinal)) {
			return this.getMeasurements().get(measurementOrdinal).getScrappedPoints() != null;
		} else {
			return false;
		}
	}

	/**
	 * @param settlementId may specify an ordinal which is not present in the vault (earlier osd file - measurements added in the meantime)
	 * @return empty in case of unavailable settlementId
	 */
	public HashMap<Integer, PointType> getSettlementPoints(int settlementId) {
		return this.getSettlements().containsKey(settlementId) ? new HashMap<Integer, PointType>() : this.getSettlements().get(settlementId).getTrails();
	}

	/**
	 * @param settlementId may specify an ordinal which is not present in the vault (earlier osd file - measurements added in the meantime)
	 * @param trailOrdinal
	 * @return the point value
	 */
	@Nullable // ordinal which is not present in the vault (earlier osd file - entries added in the meantime)
	public Integer getSettlementPoint(int settlementId, int trailOrdinal) {
		if (this.getSettlements().containsKey(settlementId)) {
			return this.getSettlements().get(settlementId).getTrails().containsKey(trailOrdinal)
					? this.getSettlements().get(settlementId).getTrails().get(trailOrdinal).value : null;
		} else {
			return null;
		}
	}

	/**
	 * @param settlementId may specify an ordinal which is not present in the vault
	 * @return the points
	 */
	public IntStream getSettlementOutliers(int settlementId) {
		if (this.getMeasurements().containsKey(settlementId)) {
			String points = this.getMeasurements().get(settlementId).getOutlierPoints();
			if (points != null) return Arrays.stream(points.split(GDE.STRING_CSV_SEPARATOR)).mapToInt(Integer::parseInt);
		}
		return IntStream.empty();
	}

	/**
	 * @param settlementId may specify an ordinal which is not present in the vault
	 * @return the points
	 */
	public IntStream getSettlementScraps(int settlementId) {
		if (this.getMeasurements().containsKey(settlementId)) {
			String points = this.getMeasurements().get(settlementId).getScrappedPoints();
			if (points != null) return Arrays.stream(points.split(GDE.STRING_CSV_SEPARATOR)).mapToInt(Integer::parseInt);
		}
		return IntStream.empty();
	}

	/**
	 * @param settlementId may specify an ordinal which is not present in the vault
	 * @return false if the settlement does not exist or has no outliers
	 */
	public boolean hasSettlementOutliers(int settlementId) {
		if (this.getSettlements().containsKey(settlementId)) {
			return this.getSettlements().get(settlementId).getOutlierPoints() != null;
		} else {
			return false;
		}
	}

	/**
	 * @param settlementId may specify an ordinal which is not present in the vault
	 * @return false if the settlement does not exist or has no scrapped points
	 */
	public boolean hasSettlementScraps(int settlementId) {
		if (this.getSettlements().containsKey(settlementId)) {
			return this.getSettlements().get(settlementId).getScrappedPoints() != null;
		} else {
			return false;
		}
	}

	@Nullable // ordinal which is not present in the vault (earlier osd file - entries added in the meantime)
	public DataTypes getSettlementDataType(int settlementId) {
		if (this.getSettlements().containsKey(settlementId)) {
			return this.getSettlements().get(settlementId).dataType;
		} else {
			return null;
		}
	}

	/**
	 * @param scoreLabelOrdinal
	 * @return null in case of unavailable score
	 */
	public Integer getScorePoint(int scoreLabelOrdinal) {
		try {
			return this.getScores().get(scoreLabelOrdinal).getValue();
		}
		catch (Exception e) {
			Logger log = Logger.getLogger(HistoVault.class.getName());
			log.log(Level.WARNING, this.getLogFilePath());
			log.log(Level.SEVERE, e.getMessage(), e);
		}
		return 0;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		final String d = GDE.STRING_COMMA_BLANK;
		sb.append(this.vaultName).append(d);
		sb.append("logRecordSetOrdinal=").append(this.logRecordSetOrdinal).append(d);
		sb.append("logRecordsetBaseName=").append(this.logRecordsetBaseName).append(d);
		sb.append("logChannelNumber=").append(this.logChannelNumber).append(d);
		sb.append("logObjectKey=").append(this.logObjectKey).append(d);
		sb.append("logStartTimestampMs=").append(this.logStartTimestamp_ms).append(d);
		sb.append("vaultDirectory=").append(this.vaultDirectory);
		return sb.toString();
	}

	/**
	 * @return context singleton (creating the context is slow)
	 */
	public static JAXBContext getJaxbContext() {
		if (HistoVault.jaxbContext == null) {
			try {
				HistoVault.jaxbContext = JAXBContext.newInstance(HistoVault.class);
			}
			catch (Exception e) {
				throw new RuntimeException(e);
			}
		}
		return HistoVault.jaxbContext;
	}

	/**
	* Leverages the xml marshalling to sorted key value pairs due to TreeMap conversion.
	*/
	public static class CompartmentsTypeAdapter extends XmlAdapter<CompartmentsType, HashMap<Integer, CompartmentType>> {

		@Override
		public HashMap<Integer, CompartmentType> unmarshal(CompartmentsType values) {
			HashMap<Integer, CompartmentType> map = new HashMap<Integer, CompartmentType>();
			if (values != null) {
				for (CompartmentType value : values.compartment)
					map.put(value.id, value);
			}
			return map;
		}

		@Override
		public CompartmentsType marshal(HashMap<Integer, CompartmentType> map) {
			CompartmentsType aList = new CompartmentsType();
			aList.compartment = map == null ? new ArrayList<CompartmentType>() : new ArrayList<CompartmentType>(new TreeMap<>(map).values());
			return aList;
		}
	}

	/**
	* Leverages the xml marshalling to key value pairs.
	*/
	public static class PointsTypeAdapter extends XmlAdapter<PointsType, HashMap<Integer, PointType>> {

		@Override
		public HashMap<Integer, PointType> unmarshal(PointsType values) {
			HashMap<Integer, PointType> map = new HashMap<Integer, PointType>();
			if (values != null) {
				for (PointType value : values.point)
					map.put(value.id, value);
			}
			return map;
		}

		@Override
		public PointsType marshal(HashMap<Integer, PointType> map) {
			PointsType aList = new PointsType();
			aList.point = map == null ? new ArrayList<PointType>() : new ArrayList<PointType>(map.values());
			return aList;
		}
	}

}
