/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.util.ArrayList;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.ArrayFieldVector;
import org.apache.commons.math3.linear.DefaultFieldMatrixChangingVisitor;
import org.apache.commons.math3.linear.DefaultFieldMatrixPreservingVisitor;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.FieldMatrixChangingVisitor;
import org.apache.commons.math3.linear.FieldMatrixPreservingVisitor;
import org.apache.commons.math3.linear.FieldVector;
import org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFieldMatrix<T extends FieldElement<T>>
implements FieldMatrix<T> {
    private final Field<T> field;

    protected AbstractFieldMatrix() {
        this.field = null;
    }

    protected AbstractFieldMatrix(Field<T> field2) {
        this.field = field2;
    }

    protected AbstractFieldMatrix(Field<T> field2, int rowDimension, int columnDimension) throws NotStrictlyPositiveException {
        if (rowDimension <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DIMENSION, rowDimension);
        }
        if (columnDimension <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DIMENSION, columnDimension);
        }
        this.field = field2;
    }

    protected static <T extends FieldElement<T>> Field<T> extractField(T[][] d2) throws NoDataException, NullArgumentException {
        if (d2 == null) {
            throw new NullArgumentException();
        }
        if (d2.length == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        if (d2[0].length == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        return d2[0][0].getField();
    }

    protected static <T extends FieldElement<T>> Field<T> extractField(T[] d2) throws NoDataException {
        if (d2.length == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        return d2[0].getField();
    }

    @Deprecated
    protected static <T extends FieldElement<T>> T[][] buildArray(Field<T> field2, int rows, int columns) {
        return (FieldElement[][])MathArrays.buildArray(field2, rows, columns);
    }

    @Deprecated
    protected static <T extends FieldElement<T>> T[] buildArray(Field<T> field2, int length) {
        return (FieldElement[])MathArrays.buildArray(field2, length);
    }

    @Override
    public Field<T> getField() {
        return this.field;
    }

    @Override
    public abstract FieldMatrix<T> createMatrix(int var1, int var2) throws NotStrictlyPositiveException;

    @Override
    public abstract FieldMatrix<T> copy();

    @Override
    public FieldMatrix<T> add(FieldMatrix<T> m2) throws MatrixDimensionMismatchException {
        this.checkAdditionCompatible(m2);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldMatrix<FieldElement> out = this.createMatrix(rowCount, columnCount);
        for (int row2 = 0; row2 < rowCount; ++row2) {
            for (int col = 0; col < columnCount; ++col) {
                out.setEntry(row2, col, (FieldElement)this.getEntry(row2, col).add(m2.getEntry(row2, col)));
            }
        }
        return out;
    }

    @Override
    public FieldMatrix<T> subtract(FieldMatrix<T> m2) throws MatrixDimensionMismatchException {
        this.checkSubtractionCompatible(m2);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldMatrix<FieldElement> out = this.createMatrix(rowCount, columnCount);
        for (int row2 = 0; row2 < rowCount; ++row2) {
            for (int col = 0; col < columnCount; ++col) {
                out.setEntry(row2, col, (FieldElement)this.getEntry(row2, col).subtract(m2.getEntry(row2, col)));
            }
        }
        return out;
    }

    @Override
    public FieldMatrix<T> scalarAdd(T d2) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldMatrix<FieldElement> out = this.createMatrix(rowCount, columnCount);
        for (int row2 = 0; row2 < rowCount; ++row2) {
            for (int col = 0; col < columnCount; ++col) {
                out.setEntry(row2, col, (FieldElement)this.getEntry(row2, col).add(d2));
            }
        }
        return out;
    }

    @Override
    public FieldMatrix<T> scalarMultiply(T d2) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldMatrix<FieldElement> out = this.createMatrix(rowCount, columnCount);
        for (int row2 = 0; row2 < rowCount; ++row2) {
            for (int col = 0; col < columnCount; ++col) {
                out.setEntry(row2, col, (FieldElement)this.getEntry(row2, col).multiply(d2));
            }
        }
        return out;
    }

    @Override
    public FieldMatrix<T> multiply(FieldMatrix<T> m2) throws DimensionMismatchException {
        this.checkMultiplicationCompatible(m2);
        int nRows = this.getRowDimension();
        int nCols = m2.getColumnDimension();
        int nSum = this.getColumnDimension();
        FieldMatrix<FieldElement> out = this.createMatrix(nRows, nCols);
        for (int row2 = 0; row2 < nRows; ++row2) {
            for (int col = 0; col < nCols; ++col) {
                FieldElement sum = (FieldElement)this.field.getZero();
                for (int i2 = 0; i2 < nSum; ++i2) {
                    sum = (FieldElement)sum.add(this.getEntry(row2, i2).multiply(m2.getEntry(i2, col)));
                }
                out.setEntry(row2, col, sum);
            }
        }
        return out;
    }

    @Override
    public FieldMatrix<T> preMultiply(FieldMatrix<T> m2) throws DimensionMismatchException {
        return m2.multiply(this);
    }

    @Override
    public FieldMatrix<T> power(int p2) throws NonSquareMatrixException, NotPositiveException {
        if (p2 < 0) {
            throw new NotPositiveException(p2);
        }
        if (!this.isSquare()) {
            throw new NonSquareMatrixException(this.getRowDimension(), this.getColumnDimension());
        }
        if (p2 == 0) {
            return MatrixUtils.createFieldIdentityMatrix(this.getField(), this.getRowDimension());
        }
        if (p2 == 1) {
            return this.copy();
        }
        int power = p2 - 1;
        char[] binaryRepresentation = Integer.toBinaryString(power).toCharArray();
        ArrayList<Integer> nonZeroPositions = new ArrayList<Integer>();
        for (int i2 = 0; i2 < binaryRepresentation.length; ++i2) {
            if (binaryRepresentation[i2] != '1') continue;
            int pos = binaryRepresentation.length - i2 - 1;
            nonZeroPositions.add(pos);
        }
        ArrayList results = new ArrayList(binaryRepresentation.length);
        results.add(0, this.copy());
        for (int i3 = 1; i3 < binaryRepresentation.length; ++i3) {
            FieldMatrix s2 = (FieldMatrix)results.get(i3 - 1);
            FieldMatrix r2 = s2.multiply(s2);
            results.add(i3, r2);
        }
        FieldMatrix<T> result2 = this.copy();
        for (Integer i4 : nonZeroPositions) {
            result2 = result2.multiply((FieldMatrix)results.get(i4));
        }
        return result2;
    }

    @Override
    public T[][] getData() {
        FieldElement[][] data2 = (FieldElement[][])MathArrays.buildArray(this.field, this.getRowDimension(), this.getColumnDimension());
        for (int i2 = 0; i2 < data2.length; ++i2) {
            FieldElement[] dataI = data2[i2];
            for (int j2 = 0; j2 < dataI.length; ++j2) {
                dataI[j2] = this.getEntry(i2, j2);
            }
        }
        return data2;
    }

    @Override
    public FieldMatrix<T> getSubMatrix(int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        FieldMatrix<T> subMatrix = this.createMatrix(endRow - startRow + 1, endColumn - startColumn + 1);
        for (int i2 = startRow; i2 <= endRow; ++i2) {
            for (int j2 = startColumn; j2 <= endColumn; ++j2) {
                subMatrix.setEntry(i2 - startRow, j2 - startColumn, this.getEntry(i2, j2));
            }
        }
        return subMatrix;
    }

    @Override
    public FieldMatrix<T> getSubMatrix(final int[] selectedRows, final int[] selectedColumns) throws NoDataException, NullArgumentException, OutOfRangeException {
        this.checkSubMatrixIndex(selectedRows, selectedColumns);
        FieldMatrix<T> subMatrix = this.createMatrix(selectedRows.length, selectedColumns.length);
        subMatrix.walkInOptimizedOrder(new DefaultFieldMatrixChangingVisitor<T>((FieldElement)this.field.getZero()){

            @Override
            public T visit(int row2, int column2, T value) {
                return AbstractFieldMatrix.this.getEntry(selectedRows[row2], selectedColumns[column2]);
            }
        });
        return subMatrix;
    }

    @Override
    public void copySubMatrix(int startRow, int endRow, int startColumn, int endColumn, T[][] destination) throws MatrixDimensionMismatchException, NumberIsTooSmallException, OutOfRangeException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        int rowsCount = endRow + 1 - startRow;
        int columnsCount = endColumn + 1 - startColumn;
        if (destination.length < rowsCount || destination[0].length < columnsCount) {
            throw new MatrixDimensionMismatchException(destination.length, destination[0].length, rowsCount, columnsCount);
        }
        this.walkInOptimizedOrder(new DefaultFieldMatrixPreservingVisitor<T>((FieldElement)this.field.getZero(), (FieldElement[][])destination){
            private int startRow;
            private int startColumn;
            final /* synthetic */ FieldElement[][] val$destination;
            {
                this.val$destination = fieldElementArray;
                super(x0);
            }

            @Override
            public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
                this.startRow = startRow;
                this.startColumn = startColumn;
            }

            @Override
            public void visit(int row2, int column2, T value) {
                this.val$destination[row2 - this.startRow][column2 - this.startColumn] = value;
            }
        }, startRow, endRow, startColumn, endColumn);
    }

    @Override
    public void copySubMatrix(int[] selectedRows, int[] selectedColumns, T[][] destination) throws MatrixDimensionMismatchException, NoDataException, NullArgumentException, OutOfRangeException {
        this.checkSubMatrixIndex(selectedRows, selectedColumns);
        if (destination.length < selectedRows.length || destination[0].length < selectedColumns.length) {
            throw new MatrixDimensionMismatchException(destination.length, destination[0].length, selectedRows.length, selectedColumns.length);
        }
        for (int i2 = 0; i2 < selectedRows.length; ++i2) {
            T[] destinationI = destination[i2];
            for (int j2 = 0; j2 < selectedColumns.length; ++j2) {
                destinationI[j2] = this.getEntry(selectedRows[i2], selectedColumns[j2]);
            }
        }
    }

    @Override
    public void setSubMatrix(T[][] subMatrix, int row2, int column2) throws DimensionMismatchException, OutOfRangeException, NoDataException, NullArgumentException {
        if (subMatrix == null) {
            throw new NullArgumentException();
        }
        int nRows = subMatrix.length;
        if (nRows == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        int nCols = subMatrix[0].length;
        if (nCols == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        for (int r2 = 1; r2 < nRows; ++r2) {
            if (subMatrix[r2].length == nCols) continue;
            throw new DimensionMismatchException(nCols, subMatrix[r2].length);
        }
        this.checkRowIndex(row2);
        this.checkColumnIndex(column2);
        this.checkRowIndex(nRows + row2 - 1);
        this.checkColumnIndex(nCols + column2 - 1);
        for (int i2 = 0; i2 < nRows; ++i2) {
            for (int j2 = 0; j2 < nCols; ++j2) {
                this.setEntry(row2 + i2, column2 + j2, subMatrix[i2][j2]);
            }
        }
    }

    @Override
    public FieldMatrix<T> getRowMatrix(int row2) throws OutOfRangeException {
        this.checkRowIndex(row2);
        int nCols = this.getColumnDimension();
        FieldMatrix<T> out = this.createMatrix(1, nCols);
        for (int i2 = 0; i2 < nCols; ++i2) {
            out.setEntry(0, i2, this.getEntry(row2, i2));
        }
        return out;
    }

    @Override
    public void setRowMatrix(int row2, FieldMatrix<T> matrix) throws OutOfRangeException, MatrixDimensionMismatchException {
        this.checkRowIndex(row2);
        int nCols = this.getColumnDimension();
        if (matrix.getRowDimension() != 1 || matrix.getColumnDimension() != nCols) {
            throw new MatrixDimensionMismatchException(matrix.getRowDimension(), matrix.getColumnDimension(), 1, nCols);
        }
        for (int i2 = 0; i2 < nCols; ++i2) {
            this.setEntry(row2, i2, matrix.getEntry(0, i2));
        }
    }

    @Override
    public FieldMatrix<T> getColumnMatrix(int column2) throws OutOfRangeException {
        this.checkColumnIndex(column2);
        int nRows = this.getRowDimension();
        FieldMatrix<T> out = this.createMatrix(nRows, 1);
        for (int i2 = 0; i2 < nRows; ++i2) {
            out.setEntry(i2, 0, this.getEntry(i2, column2));
        }
        return out;
    }

    @Override
    public void setColumnMatrix(int column2, FieldMatrix<T> matrix) throws OutOfRangeException, MatrixDimensionMismatchException {
        this.checkColumnIndex(column2);
        int nRows = this.getRowDimension();
        if (matrix.getRowDimension() != nRows || matrix.getColumnDimension() != 1) {
            throw new MatrixDimensionMismatchException(matrix.getRowDimension(), matrix.getColumnDimension(), nRows, 1);
        }
        for (int i2 = 0; i2 < nRows; ++i2) {
            this.setEntry(i2, column2, matrix.getEntry(i2, 0));
        }
    }

    @Override
    public FieldVector<T> getRowVector(int row2) throws OutOfRangeException {
        return new ArrayFieldVector(this.field, this.getRow(row2), false);
    }

    @Override
    public void setRowVector(int row2, FieldVector<T> vector) throws OutOfRangeException, MatrixDimensionMismatchException {
        this.checkRowIndex(row2);
        int nCols = this.getColumnDimension();
        if (vector.getDimension() != nCols) {
            throw new MatrixDimensionMismatchException(1, vector.getDimension(), 1, nCols);
        }
        for (int i2 = 0; i2 < nCols; ++i2) {
            this.setEntry(row2, i2, vector.getEntry(i2));
        }
    }

    @Override
    public FieldVector<T> getColumnVector(int column2) throws OutOfRangeException {
        return new ArrayFieldVector(this.field, this.getColumn(column2), false);
    }

    @Override
    public void setColumnVector(int column2, FieldVector<T> vector) throws OutOfRangeException, MatrixDimensionMismatchException {
        this.checkColumnIndex(column2);
        int nRows = this.getRowDimension();
        if (vector.getDimension() != nRows) {
            throw new MatrixDimensionMismatchException(vector.getDimension(), 1, nRows, 1);
        }
        for (int i2 = 0; i2 < nRows; ++i2) {
            this.setEntry(i2, column2, vector.getEntry(i2));
        }
    }

    @Override
    public T[] getRow(int row2) throws OutOfRangeException {
        this.checkRowIndex(row2);
        int nCols = this.getColumnDimension();
        FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.field, nCols);
        for (int i2 = 0; i2 < nCols; ++i2) {
            out[i2] = this.getEntry(row2, i2);
        }
        return out;
    }

    @Override
    public void setRow(int row2, T[] array) throws OutOfRangeException, MatrixDimensionMismatchException {
        this.checkRowIndex(row2);
        int nCols = this.getColumnDimension();
        if (array.length != nCols) {
            throw new MatrixDimensionMismatchException(1, array.length, 1, nCols);
        }
        for (int i2 = 0; i2 < nCols; ++i2) {
            this.setEntry(row2, i2, array[i2]);
        }
    }

    @Override
    public T[] getColumn(int column2) throws OutOfRangeException {
        this.checkColumnIndex(column2);
        int nRows = this.getRowDimension();
        FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.field, nRows);
        for (int i2 = 0; i2 < nRows; ++i2) {
            out[i2] = this.getEntry(i2, column2);
        }
        return out;
    }

    @Override
    public void setColumn(int column2, T[] array) throws OutOfRangeException, MatrixDimensionMismatchException {
        this.checkColumnIndex(column2);
        int nRows = this.getRowDimension();
        if (array.length != nRows) {
            throw new MatrixDimensionMismatchException(array.length, 1, nRows, 1);
        }
        for (int i2 = 0; i2 < nRows; ++i2) {
            this.setEntry(i2, column2, array[i2]);
        }
    }

    @Override
    public abstract T getEntry(int var1, int var2) throws OutOfRangeException;

    @Override
    public abstract void setEntry(int var1, int var2, T var3) throws OutOfRangeException;

    @Override
    public abstract void addToEntry(int var1, int var2, T var3) throws OutOfRangeException;

    @Override
    public abstract void multiplyEntry(int var1, int var2, T var3) throws OutOfRangeException;

    @Override
    public FieldMatrix<T> transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        final FieldMatrix<T> out = this.createMatrix(nCols, nRows);
        this.walkInOptimizedOrder(new DefaultFieldMatrixPreservingVisitor<T>((FieldElement)this.field.getZero()){

            @Override
            public void visit(int row2, int column2, T value) {
                out.setEntry(column2, row2, value);
            }
        });
        return out;
    }

    @Override
    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    @Override
    public abstract int getRowDimension();

    @Override
    public abstract int getColumnDimension();

    @Override
    public T getTrace() throws NonSquareMatrixException {
        int nCols;
        int nRows = this.getRowDimension();
        if (nRows != (nCols = this.getColumnDimension())) {
            throw new NonSquareMatrixException(nRows, nCols);
        }
        FieldElement trace = (FieldElement)this.field.getZero();
        for (int i2 = 0; i2 < nRows; ++i2) {
            trace = (FieldElement)trace.add(this.getEntry(i2, i2));
        }
        return (T)trace;
    }

    @Override
    public T[] operate(T[] v2) throws DimensionMismatchException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v2.length != nCols) {
            throw new DimensionMismatchException(v2.length, nCols);
        }
        FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.field, nRows);
        for (int row2 = 0; row2 < nRows; ++row2) {
            FieldElement sum = (FieldElement)this.field.getZero();
            for (int i2 = 0; i2 < nCols; ++i2) {
                sum = (FieldElement)sum.add(this.getEntry(row2, i2).multiply(v2[i2]));
            }
            out[row2] = sum;
        }
        return out;
    }

    @Override
    public FieldVector<T> operate(FieldVector<T> v2) throws DimensionMismatchException {
        try {
            return new ArrayFieldVector(this.field, this.operate(((ArrayFieldVector)v2).getDataRef()), false);
        }
        catch (ClassCastException cce) {
            int nRows = this.getRowDimension();
            int nCols = this.getColumnDimension();
            if (v2.getDimension() != nCols) {
                throw new DimensionMismatchException(v2.getDimension(), nCols);
            }
            FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.field, nRows);
            for (int row2 = 0; row2 < nRows; ++row2) {
                FieldElement sum = (FieldElement)this.field.getZero();
                for (int i2 = 0; i2 < nCols; ++i2) {
                    sum = (FieldElement)sum.add(this.getEntry(row2, i2).multiply(v2.getEntry(i2)));
                }
                out[row2] = sum;
            }
            return new ArrayFieldVector(this.field, out, false);
        }
    }

    @Override
    public T[] preMultiply(T[] v2) throws DimensionMismatchException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v2.length != nRows) {
            throw new DimensionMismatchException(v2.length, nRows);
        }
        FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.field, nCols);
        for (int col = 0; col < nCols; ++col) {
            FieldElement sum = (FieldElement)this.field.getZero();
            for (int i2 = 0; i2 < nRows; ++i2) {
                sum = (FieldElement)sum.add(this.getEntry(i2, col).multiply(v2[i2]));
            }
            out[col] = sum;
        }
        return out;
    }

    @Override
    public FieldVector<T> preMultiply(FieldVector<T> v2) throws DimensionMismatchException {
        try {
            return new ArrayFieldVector(this.field, this.preMultiply(((ArrayFieldVector)v2).getDataRef()), false);
        }
        catch (ClassCastException cce) {
            int nRows = this.getRowDimension();
            int nCols = this.getColumnDimension();
            if (v2.getDimension() != nRows) {
                throw new DimensionMismatchException(v2.getDimension(), nRows);
            }
            FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.field, nCols);
            for (int col = 0; col < nCols; ++col) {
                FieldElement sum = (FieldElement)this.field.getZero();
                for (int i2 = 0; i2 < nRows; ++i2) {
                    sum = (FieldElement)sum.add(this.getEntry(i2, col).multiply(v2.getEntry(i2)));
                }
                out[col] = sum;
            }
            return new ArrayFieldVector(this.field, out, false);
        }
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor2) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor2.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int row2 = 0; row2 < rows; ++row2) {
            for (int column2 = 0; column2 < columns; ++column2) {
                T oldValue = this.getEntry(row2, column2);
                T newValue = visitor2.visit(row2, column2, oldValue);
                this.setEntry(row2, column2, newValue);
            }
        }
        return visitor2.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor2) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor2.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int row2 = 0; row2 < rows; ++row2) {
            for (int column2 = 0; column2 < columns; ++column2) {
                visitor2.visit(row2, column2, this.getEntry(row2, column2));
            }
        }
        return visitor2.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor2, int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor2.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int row2 = startRow; row2 <= endRow; ++row2) {
            for (int column2 = startColumn; column2 <= endColumn; ++column2) {
                T oldValue = this.getEntry(row2, column2);
                T newValue = visitor2.visit(row2, column2, oldValue);
                this.setEntry(row2, column2, newValue);
            }
        }
        return visitor2.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor2, int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor2.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int row2 = startRow; row2 <= endRow; ++row2) {
            for (int column2 = startColumn; column2 <= endColumn; ++column2) {
                visitor2.visit(row2, column2, this.getEntry(row2, column2));
            }
        }
        return visitor2.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor2) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor2.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int column2 = 0; column2 < columns; ++column2) {
            for (int row2 = 0; row2 < rows; ++row2) {
                T oldValue = this.getEntry(row2, column2);
                T newValue = visitor2.visit(row2, column2, oldValue);
                this.setEntry(row2, column2, newValue);
            }
        }
        return visitor2.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor2) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor2.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int column2 = 0; column2 < columns; ++column2) {
            for (int row2 = 0; row2 < rows; ++row2) {
                visitor2.visit(row2, column2, this.getEntry(row2, column2));
            }
        }
        return visitor2.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor2, int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor2.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int column2 = startColumn; column2 <= endColumn; ++column2) {
            for (int row2 = startRow; row2 <= endRow; ++row2) {
                T oldValue = this.getEntry(row2, column2);
                T newValue = visitor2.visit(row2, column2, oldValue);
                this.setEntry(row2, column2, newValue);
            }
        }
        return visitor2.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor2, int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor2.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int column2 = startColumn; column2 <= endColumn; ++column2) {
            for (int row2 = startRow; row2 <= endRow; ++row2) {
                visitor2.visit(row2, column2, this.getEntry(row2, column2));
            }
        }
        return visitor2.end();
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> visitor2) {
        return this.walkInRowOrder(visitor2);
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> visitor2) {
        return this.walkInRowOrder(visitor2);
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> visitor2, int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInRowOrder(visitor2, startRow, endRow, startColumn, endColumn);
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> visitor2, int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInRowOrder(visitor2, startRow, endRow, startColumn, endColumn);
    }

    public String toString() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        StringBuffer res = new StringBuffer();
        String fullClassName = this.getClass().getName();
        String shortClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        res.append(shortClassName).append("{");
        for (int i2 = 0; i2 < nRows; ++i2) {
            if (i2 > 0) {
                res.append(",");
            }
            res.append("{");
            for (int j2 = 0; j2 < nCols; ++j2) {
                if (j2 > 0) {
                    res.append(",");
                }
                res.append(this.getEntry(i2, j2));
            }
            res.append("}");
        }
        res.append("}");
        return res.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FieldMatrix)) {
            return false;
        }
        FieldMatrix m2 = (FieldMatrix)object;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (m2.getColumnDimension() != nCols || m2.getRowDimension() != nRows) {
            return false;
        }
        for (int row2 = 0; row2 < nRows; ++row2) {
            for (int col = 0; col < nCols; ++col) {
                if (this.getEntry(row2, col).equals(m2.getEntry(row2, col))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int ret = 322562;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        ret = ret * 31 + nRows;
        ret = ret * 31 + nCols;
        for (int row2 = 0; row2 < nRows; ++row2) {
            for (int col = 0; col < nCols; ++col) {
                ret = ret * 31 + (11 * (row2 + 1) + 17 * (col + 1)) * this.getEntry(row2, col).hashCode();
            }
        }
        return ret;
    }

    protected void checkRowIndex(int row2) throws OutOfRangeException {
        if (row2 < 0 || row2 >= this.getRowDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.ROW_INDEX, (Number)row2, 0, this.getRowDimension() - 1);
        }
    }

    protected void checkColumnIndex(int column2) throws OutOfRangeException {
        if (column2 < 0 || column2 >= this.getColumnDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.COLUMN_INDEX, (Number)column2, 0, this.getColumnDimension() - 1);
        }
    }

    protected void checkSubMatrixIndex(int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkRowIndex(startRow);
        this.checkRowIndex(endRow);
        if (endRow < startRow) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, (Number)endRow, startRow, true);
        }
        this.checkColumnIndex(startColumn);
        this.checkColumnIndex(endColumn);
        if (endColumn < startColumn) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_COLUMN_AFTER_FINAL_COLUMN, (Number)endColumn, startColumn, true);
        }
    }

    protected void checkSubMatrixIndex(int[] selectedRows, int[] selectedColumns) throws NoDataException, NullArgumentException, OutOfRangeException {
        if (selectedRows == null || selectedColumns == null) {
            throw new NullArgumentException();
        }
        if (selectedRows.length == 0 || selectedColumns.length == 0) {
            throw new NoDataException();
        }
        for (int row2 : selectedRows) {
            this.checkRowIndex(row2);
        }
        for (int column2 : selectedColumns) {
            this.checkColumnIndex(column2);
        }
    }

    protected void checkAdditionCompatible(FieldMatrix<T> m2) throws MatrixDimensionMismatchException {
        if (this.getRowDimension() != m2.getRowDimension() || this.getColumnDimension() != m2.getColumnDimension()) {
            throw new MatrixDimensionMismatchException(m2.getRowDimension(), m2.getColumnDimension(), this.getRowDimension(), this.getColumnDimension());
        }
    }

    protected void checkSubtractionCompatible(FieldMatrix<T> m2) throws MatrixDimensionMismatchException {
        if (this.getRowDimension() != m2.getRowDimension() || this.getColumnDimension() != m2.getColumnDimension()) {
            throw new MatrixDimensionMismatchException(m2.getRowDimension(), m2.getColumnDimension(), this.getRowDimension(), this.getColumnDimension());
        }
    }

    protected void checkMultiplicationCompatible(FieldMatrix<T> m2) throws DimensionMismatchException {
        if (this.getColumnDimension() != m2.getRowDimension()) {
            throw new DimensionMismatchException(m2.getRowDimension(), this.getColumnDimension());
        }
    }
}

