/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.MessageFactory;
import javax.faces.component.MethodBindingValidator;
import javax.faces.component.MethodBindingValueChangeListener;
import javax.faces.component.TypedCollections;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.MethodBinding;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class UIInput
extends UIOutput
implements EditableValueHolder {
    public static final String COMPONENT_TYPE = "javax.faces.Input";
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String CONVERSION_MESSAGE_ID = "javax.faces.component.UIInput.CONVERSION";
    public static final String REQUIRED_MESSAGE_ID = "javax.faces.component.UIInput.REQUIRED";
    public static final String UPDATE_MESSAGE_ID = "javax.faces.component.UIInput.UPDATE";
    private static final Validator[] EMPTY_VALIDATOR = new Validator[0];
    private static final Logger LOGGER = Logger.getLogger("javax.faces.component", "javax.faces.LogStrings");
    private Object submittedValue = null;
    private boolean localValueSet;
    private Boolean required;
    private String requiredMessage;
    private String converterMessage;
    private String validatorMessage;
    private boolean valid = true;
    private Boolean immediate;
    List<Validator> validators = null;
    private Object[] values;

    public UIInput() {
        this.setRendererType("javax.faces.Text");
    }

    @Override
    public String getFamily() {
        return "javax.faces.Input";
    }

    @Override
    public Object getSubmittedValue() {
        return this.submittedValue;
    }

    @Override
    public void setSubmittedValue(Object submittedValue) {
        this.submittedValue = submittedValue;
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        this.setLocalValueSet(true);
    }

    public void resetValue() {
        this.setValue(null);
        this.setSubmittedValue(null);
        this.setLocalValueSet(false);
        this.setValid(true);
    }

    @Override
    public boolean isLocalValueSet() {
        return this.localValueSet;
    }

    @Override
    public void setLocalValueSet(boolean localValueSet) {
        this.localValueSet = localValueSet;
    }

    @Override
    public boolean isRequired() {
        if (this.required != null) {
            return this.required;
        }
        ValueExpression ve = this.getValueExpression("required");
        if (ve != null) {
            try {
                return Boolean.TRUE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException(e);
            }
        }
        return false;
    }

    public String getRequiredMessage() {
        if (this.requiredMessage != null) {
            return this.requiredMessage;
        }
        ValueExpression ve = this.getValueExpression("requiredMessage");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException(e);
            }
        }
        return null;
    }

    public void setRequiredMessage(String message) {
        this.requiredMessage = message;
    }

    public String getConverterMessage() {
        if (this.converterMessage != null) {
            return this.converterMessage;
        }
        ValueExpression ve = this.getValueExpression("converterMessage");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException(e);
            }
        }
        return null;
    }

    public void setConverterMessage(String message) {
        this.converterMessage = message;
    }

    public String getValidatorMessage() {
        if (this.validatorMessage != null) {
            return this.validatorMessage;
        }
        ValueExpression ve = this.getValueExpression("validatorMessage");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException(e);
            }
        }
        return null;
    }

    public void setValidatorMessage(String message) {
        this.validatorMessage = message;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public boolean isImmediate() {
        if (this.immediate != null) {
            return this.immediate;
        }
        ValueExpression ve = this.getValueExpression("immediate");
        if (ve != null) {
            try {
                return Boolean.TRUE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException(e);
            }
        }
        return false;
    }

    @Override
    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    @Override
    public MethodBinding getValidator() {
        MethodBinding result = null;
        Validator[] curValidators = this.getValidators();
        if (null != curValidators) {
            for (int i = 0; i < curValidators.length; ++i) {
                if (MethodBindingValidator.class != curValidators[i].getClass()) continue;
                result = ((MethodBindingValidator)curValidators[i]).getWrapped();
                break;
            }
        }
        return result;
    }

    @Override
    public void setValidator(MethodBinding validatorBinding) {
        Validator[] curValidators = this.getValidators();
        if (null != curValidators) {
            for (int i = 0; i < curValidators.length; ++i) {
                if (null == validatorBinding) {
                    if (MethodBindingValidator.class != curValidators[i].getClass()) continue;
                    this.removeValidator(curValidators[i]);
                    return;
                }
                if (validatorBinding != curValidators[i]) continue;
                this.removeValidator(curValidators[i]);
                break;
            }
        }
        this.addValidator(new MethodBindingValidator(validatorBinding));
    }

    @Override
    public MethodBinding getValueChangeListener() {
        MethodBinding result = null;
        ValueChangeListener[] curListeners = this.getValueChangeListeners();
        if (null != curListeners) {
            for (int i = 0; i < curListeners.length; ++i) {
                if (MethodBindingValueChangeListener.class != curListeners[i].getClass()) continue;
                result = ((MethodBindingValueChangeListener)curListeners[i]).getWrapped();
                break;
            }
        }
        return result;
    }

    @Override
    public void setValueChangeListener(MethodBinding valueChangeListener) {
        ValueChangeListener[] curListeners = this.getValueChangeListeners();
        if (null != curListeners) {
            for (int i = 0; i < curListeners.length; ++i) {
                if (null == valueChangeListener) {
                    if (MethodBindingValueChangeListener.class != curListeners[i].getClass()) continue;
                    this.removeFacesListener(curListeners[i]);
                    return;
                }
                if (valueChangeListener != curListeners[i]) continue;
                this.removeFacesListener(curListeners[i]);
                break;
            }
        }
        this.addValueChangeListener(new MethodBindingValueChangeListener(valueChangeListener));
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processDecodes(context);
        if (this.isImmediate()) {
            this.executeValidate(context);
        }
    }

    @Override
    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processValidators(context);
        if (!this.isImmediate()) {
            this.executeValidate(context);
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        try {
            this.updateModel(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    @Override
    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.setValid(true);
        super.decode(context);
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueExpression ve = this.getValueExpression("value");
        if (ve != null) {
            try {
                ve.setValue(context.getELContext(), this.getLocalValue());
                this.setValue(null);
                this.setLocalValueSet(false);
            }
            catch (ELException e) {
                Throwable result;
                String messageStr = e.getMessage();
                for (result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                    messageStr = result.getMessage();
                }
                FacesMessage message = null == messageStr ? MessageFactory.getMessage(context, UPDATE_MESSAGE_ID, MessageFactory.getLabel(context, this)) : new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
                LOGGER.log(Level.SEVERE, message.getSummary(), result);
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
            catch (IllegalArgumentException e) {
                FacesMessage message = MessageFactory.getMessage(context, UPDATE_MESSAGE_ID, MessageFactory.getLabel(context, this));
                LOGGER.log(Level.SEVERE, message.getSummary(), e);
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
            catch (Exception e) {
                FacesMessage message = MessageFactory.getMessage(context, UPDATE_MESSAGE_ID, MessageFactory.getLabel(context, this));
                LOGGER.log(Level.SEVERE, message.getSummary(), e);
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object submittedValue = this.getSubmittedValue();
        if (submittedValue == null) {
            return;
        }
        Object newValue = null;
        try {
            newValue = this.getConvertedValue(context, submittedValue);
        }
        catch (ConverterException ce) {
            this.addConversionErrorMessage(context, ce, submittedValue);
            this.setValid(false);
        }
        this.validateValue(context, newValue);
        if (this.isValid()) {
            Object previous = this.getValue();
            this.setValue(newValue);
            this.setSubmittedValue(null);
            if (this.compareValues(previous, newValue)) {
                this.queueEvent(new ValueChangeEvent(this, previous, newValue));
            }
        }
    }

    protected Object getConvertedValue(FacesContext context, Object newSubmittedValue) throws ConverterException {
        Converter converter;
        Renderer renderer = this.getRenderer(context);
        Object newValue = renderer != null ? renderer.getConvertedValue(context, this, newSubmittedValue) : (newSubmittedValue instanceof String ? ((converter = this.getConverterWithType(context)) != null ? converter.getAsObject(context, this, (String)newSubmittedValue) : newSubmittedValue) : newSubmittedValue);
        return newValue;
    }

    protected void validateValue(FacesContext context, Object newValue) {
        if (this.isValid() && this.isRequired() && UIInput.isEmpty(newValue)) {
            String requiredMessageStr = this.getRequiredMessage();
            FacesMessage message = null != requiredMessageStr ? new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessageStr, requiredMessageStr) : MessageFactory.getMessage(context, REQUIRED_MESSAGE_ID, MessageFactory.getLabel(context, this));
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
        if (this.isValid() && !UIInput.isEmpty(newValue) && this.validators != null) {
            for (Validator validator : this.validators) {
                try {
                    validator.validate(context, this, newValue);
                }
                catch (ValidatorException ve) {
                    FacesMessage message;
                    this.setValid(false);
                    String validatorMessageString = this.getValidatorMessage();
                    if (null != validatorMessageString) {
                        message = new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessageString, validatorMessageString);
                        message.setSeverity(FacesMessage.SEVERITY_ERROR);
                    } else {
                        message = ve.getFacesMessage();
                    }
                    if (message == null) continue;
                    context.addMessage(this.getClientId(context), message);
                }
            }
        }
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null) {
            return value != null;
        }
        if (value == null) {
            return true;
        }
        return !previous.equals(value);
    }

    private void executeValidate(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    private static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String && ((String)value).length() < 1) {
            return true;
        }
        return value.getClass().isArray() ? 0 == Array.getLength(value) : value instanceof List && ((List)value).isEmpty();
    }

    @Override
    public void addValidator(Validator validator) {
        if (validator == null) {
            throw new NullPointerException();
        }
        if (this.validators == null) {
            this.validators = new ArrayList<Validator>();
        }
        this.validators.add(validator);
    }

    @Override
    public Validator[] getValidators() {
        if (this.validators == null) {
            return EMPTY_VALIDATOR;
        }
        return this.validators.toArray(new Validator[this.validators.size()]);
    }

    @Override
    public void removeValidator(Validator validator) {
        if (this.validators != null) {
            this.validators.remove(validator);
        }
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
        this.addFacesListener(listener);
    }

    @Override
    public ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.getFacesListeners(ValueChangeListener.class);
    }

    @Override
    public void removeValueChangeListener(ValueChangeListener listener) {
        this.removeFacesListener(listener);
    }

    @Override
    public Object saveState(FacesContext context) {
        if (this.values == null) {
            this.values = new Object[9];
        }
        this.values[0] = super.saveState(context);
        this.values[1] = this.localValueSet;
        this.values[2] = this.required;
        this.values[3] = this.requiredMessage;
        this.values[4] = this.converterMessage;
        this.values[5] = this.validatorMessage;
        this.values[6] = this.valid;
        this.values[7] = this.immediate;
        this.values[8] = UIInput.saveAttachedState(context, this.validators);
        return this.values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        this.values = (Object[])state;
        super.restoreState(context, this.values[0]);
        this.localValueSet = (Boolean)this.values[1];
        this.required = (Boolean)this.values[2];
        this.requiredMessage = (String)this.values[3];
        this.converterMessage = (String)this.values[4];
        this.validatorMessage = (String)this.values[5];
        this.valid = (Boolean)this.values[6];
        this.immediate = (Boolean)this.values[7];
        List<Validator> restoredValidators = TypedCollections.dynamicallyCastList((List)UIInput.restoreAttachedState(context, this.values[8]), Validator.class);
        if (null != restoredValidators) {
            if (null != this.validators) {
                Iterator<Validator> iter = restoredValidators.iterator();
                while (iter.hasNext()) {
                    this.validators.add(iter.next());
                }
            } else {
                this.validators = restoredValidators;
            }
        }
    }

    private Converter getConverterWithType(FacesContext context) {
        Class<?> converterType;
        Converter converter = this.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression valueExpression = this.getValueExpression("value");
        if (valueExpression == null) {
            return null;
        }
        try {
            converterType = valueExpression.getType(context.getELContext());
        }
        catch (ELException e) {
            throw new FacesException(e);
        }
        if (converterType == null || converterType == String.class || converterType == Object.class) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void addConversionErrorMessage(FacesContext context, ConverterException ce, Object value) {
        FacesMessage message;
        String converterMessageString = this.getConverterMessage();
        if (null != converterMessageString) {
            message = new FacesMessage(FacesMessage.SEVERITY_ERROR, converterMessageString, converterMessageString);
        } else {
            message = ce.getFacesMessage();
            if (message == null && (message = MessageFactory.getMessage(context, CONVERSION_MESSAGE_ID, new Object[0])).getDetail() == null) {
                message.setDetail(ce.getMessage());
            }
        }
        context.addMessage(this.getClientId(context), message);
    }
}

