/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.qrcode;

import com.itextpdf.text.pdf.qrcode.ByteMatrix;
import com.itextpdf.text.pdf.qrcode.ErrorCorrectionLevel;
import com.itextpdf.text.pdf.qrcode.Mode;

public final class QRCode {
    public static final int NUM_MASK_PATTERNS = 8;
    private Mode mode = null;
    private ErrorCorrectionLevel ecLevel = null;
    private int version = -1;
    private int matrixWidth = -1;
    private int maskPattern = -1;
    private int numTotalBytes = -1;
    private int numDataBytes = -1;
    private int numECBytes = -1;
    private int numRSBlocks = -1;
    private ByteMatrix matrix = null;

    public Mode getMode() {
        return this.mode;
    }

    public ErrorCorrectionLevel getECLevel() {
        return this.ecLevel;
    }

    public int getVersion() {
        return this.version;
    }

    public int getMatrixWidth() {
        return this.matrixWidth;
    }

    public int getMaskPattern() {
        return this.maskPattern;
    }

    public int getNumTotalBytes() {
        return this.numTotalBytes;
    }

    public int getNumDataBytes() {
        return this.numDataBytes;
    }

    public int getNumECBytes() {
        return this.numECBytes;
    }

    public int getNumRSBlocks() {
        return this.numRSBlocks;
    }

    public ByteMatrix getMatrix() {
        return this.matrix;
    }

    public int at(int x2, int y2) {
        byte value = this.matrix.get(x2, y2);
        if (value != 0 && value != 1) {
            throw new RuntimeException("Bad value");
        }
        return value;
    }

    public boolean isValid() {
        return this.mode != null && this.ecLevel != null && this.version != -1 && this.matrixWidth != -1 && this.maskPattern != -1 && this.numTotalBytes != -1 && this.numDataBytes != -1 && this.numECBytes != -1 && this.numRSBlocks != -1 && QRCode.isValidMaskPattern(this.maskPattern) && this.numTotalBytes == this.numDataBytes + this.numECBytes && this.matrix != null && this.matrixWidth == this.matrix.getWidth() && this.matrix.getWidth() == this.matrix.getHeight();
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer(200);
        result2.append("<<\n");
        result2.append(" mode: ");
        result2.append(this.mode);
        result2.append("\n ecLevel: ");
        result2.append(this.ecLevel);
        result2.append("\n version: ");
        result2.append(this.version);
        result2.append("\n matrixWidth: ");
        result2.append(this.matrixWidth);
        result2.append("\n maskPattern: ");
        result2.append(this.maskPattern);
        result2.append("\n numTotalBytes: ");
        result2.append(this.numTotalBytes);
        result2.append("\n numDataBytes: ");
        result2.append(this.numDataBytes);
        result2.append("\n numECBytes: ");
        result2.append(this.numECBytes);
        result2.append("\n numRSBlocks: ");
        result2.append(this.numRSBlocks);
        if (this.matrix == null) {
            result2.append("\n matrix: null\n");
        } else {
            result2.append("\n matrix:\n");
            result2.append(this.matrix.toString());
        }
        result2.append(">>\n");
        return result2.toString();
    }

    public void setMode(Mode value) {
        this.mode = value;
    }

    public void setECLevel(ErrorCorrectionLevel value) {
        this.ecLevel = value;
    }

    public void setVersion(int value) {
        this.version = value;
    }

    public void setMatrixWidth(int value) {
        this.matrixWidth = value;
    }

    public void setMaskPattern(int value) {
        this.maskPattern = value;
    }

    public void setNumTotalBytes(int value) {
        this.numTotalBytes = value;
    }

    public void setNumDataBytes(int value) {
        this.numDataBytes = value;
    }

    public void setNumECBytes(int value) {
        this.numECBytes = value;
    }

    public void setNumRSBlocks(int value) {
        this.numRSBlocks = value;
    }

    public void setMatrix(ByteMatrix value) {
        this.matrix = value;
    }

    public static boolean isValidMaskPattern(int maskPattern) {
        return maskPattern >= 0 && maskPattern < 8;
    }
}

