/*
 * Decompiled with CFR 0.152.
 */
package gde.tools;

import com.sun.istack.Nullable;
import gde.DataAccess;
import gde.config.ExportService;
import gde.device.InputTypes;
import gde.log.Level;
import gde.log.Logger;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExportServiceBuilder {
    private static final String $CLASS_NAME = ExportServiceBuilder.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final String DEVICE_TAG = "Device";
    private static final String DEVICE_NAME_TAG = "name";
    private static final String DEVICE_MANUFACTURER_TAG = "manufacturer";
    private static final String SERIAL_PORT_TAG = "SerialPort";
    private static final String USB_PORT_TAG = "UsbPort";
    private static final String TCP_PORT_TAG = "TcpPort";
    private static final String DATA_BLOCK_TAG = "DataBlock";
    private static final String DATA_BLOCK_FORMAT_TAG = "format";
    private static final String DATA_BLOCK_INPUT_TYPE_TAG = "inputType";
    private static final String CHANNELS_TAG = "Channels";
    private final DataAccess dataAccess;

    public ExportServiceBuilder(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public static void main(String[] args) throws IOException {
        Predicate<ExportService> deviceChecker;
        Path deviceProjectPath = Paths.get(args[0], new String[0]);
        if (args.length > 1) {
            List<String> hiddenDevices = Arrays.asList(args[1].split(","));
            deviceChecker = e -> !hiddenDevices.contains(e.getName());
        } else {
            deviceChecker = e -> true;
        }
        ExportServiceBuilder builder = new ExportServiceBuilder(DataAccess.getInstance());
        List<ExportService> services = builder.getServices(deviceProjectPath.getParent(), deviceProjectPath.getFileName().toString());
        String servicesText = services.stream().filter(deviceChecker).map(ExportService::toString).collect(Collectors.joining(", "));
        System.out.print(servicesText);
    }

    public List<ExportService> getServices(Path basePath, String projectName) {
        ArrayList<ExportService> services = new ArrayList<ExportService>();
        Path devicePropertiesPath = basePath.resolve(projectName).resolve("src/resource");
        try {
            for (String fileName : this.dataAccess.getDevicePropertyFileNames(devicePropertiesPath)) {
                ExportService service = this.getService(basePath, projectName, fileName);
                if (service == null) continue;
                services.add(service);
            }
        }
        catch (Exception e) {
            log.log(Level.INFO, "not a device project :", projectName);
        }
        return services;
    }

    @Nullable
    public ExportService getService(Path basePath, String projectName, String propertiesFileName) {
        final String[] deviceValues = new String[]{"", ""};
        final LinkedHashSet<ExportService.DataFeed> dataFeeds = new LinkedHashSet<ExportService.DataFeed>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){
                private boolean isDevice = false;
                private boolean isName = false;
                private boolean isManufacturer = false;
                private boolean existsSerialPort = false;
                private boolean existsUsbPort = false;
                private boolean existsTcpPort = false;
                private boolean isDataBlock = false;
                private String deviceName = "";
                private String deviceManufacturer = "";

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    switch (qName) {
                        case "Device": {
                            this.isDevice = true;
                            break;
                        }
                        case "name": {
                            this.isName = true;
                            break;
                        }
                        case "manufacturer": {
                            this.isManufacturer = true;
                            break;
                        }
                        case "SerialPort": {
                            this.existsSerialPort = true;
                            break;
                        }
                        case "UsbPort": {
                            this.existsUsbPort = true;
                            break;
                        }
                        case "TcpPort": {
                            this.existsTcpPort = true;
                            break;
                        }
                        case "DataBlock": {
                            this.isDataBlock = true;
                            break;
                        }
                        case "format": {
                            if (!this.isDataBlock) break;
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                String value;
                                String string = attributes.getQName(i);
                                if (!string.equals(ExportServiceBuilder.DATA_BLOCK_INPUT_TYPE_TAG)) continue;
                                if (dataFeeds.isEmpty()) {
                                    deviceValues[0] = this.deviceName;
                                    deviceValues[1] = this.deviceManufacturer;
                                }
                                if (InputTypes.fromValue(value = attributes.getValue(i)) == InputTypes.FILE_IO) {
                                    dataFeeds.add(ExportService.DataFeed.FILE);
                                } else if (InputTypes.fromValue(value) == InputTypes.SERIAL_IO) {
                                    if (this.existsSerialPort) {
                                        dataFeeds.add(ExportService.DataFeed.SERIAL_IO);
                                    } else if (this.existsUsbPort) {
                                        dataFeeds.add(ExportService.DataFeed.NATIVE_USB);
                                    } else if (this.existsTcpPort) {
                                        dataFeeds.add(ExportService.DataFeed.NATIVE_TCP);
                                    } else {
                                        dataFeeds.add(ExportService.DataFeed.NO_DATA_SOURCE);
                                    }
                                } else {
                                    dataFeeds.add(ExportService.DataFeed.NO_DATA_SOURCE);
                                }
                                log.log(Level.FINE, "dataFeed =", value);
                            }
                            break;
                        }
                        case "Channels": {
                            throw new MySAXTerminatorException("the service items do not ly beyond this xml element");
                        }
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    switch (qName) {
                        case "Device": {
                            this.isDevice = false;
                        }
                        case "DataBlock": {
                            this.isDataBlock = false;
                            break;
                        }
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.isDevice) {
                        if (this.isName) {
                            this.deviceName = new String(ch, start, length);
                            log.log(Level.FINE, "deviceName : ", this.deviceName);
                            this.isName = false;
                        }
                        if (this.isManufacturer) {
                            this.deviceManufacturer = new String(ch, start, length);
                            log.log(Level.FINE, "deviceManufacturer : ", this.deviceManufacturer);
                            this.isManufacturer = false;
                        }
                    }
                }
            };
            Path devicePropertiesPath = basePath.resolve(projectName).resolve("src/resource").resolve(propertiesFileName);
            saxParser.parse(this.dataAccess.getDeviceXmlInputStream(devicePropertiesPath.toString()), handler);
        }
        catch (MySAXTerminatorException factory) {
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        ExportService exportService = dataFeeds.isEmpty() ? null : new ExportService(deviceValues[0], deviceValues[1], dataFeeds, projectName + ".jar");
        return exportService;
    }

    public class MySAXTerminatorException
    extends SAXException {
        private static final long serialVersionUID = -3581286881580383862L;

        public MySAXTerminatorException(String message) {
            super(message);
        }
    }
}

