/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.exclusions;

import gde.DataAccess;
import gde.histo.innercache.Cache;
import gde.histo.innercache.CacheBuilder;
import gde.histo.innercache.CacheStats;
import gde.histo.utils.SecureHash;
import gde.log.Logger;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.stream.Collectors;

public final class ExclusionData
extends Properties {
    private static final String $CLASS_NAME = ExclusionData.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final long serialVersionUID = -2477509505185819765L;
    private static final Cache<String, ExclusionData> memoryCache = CacheBuilder.newBuilder().maximumSize(111L).recordStats().build();
    private final Path activeFolder;
    private final DataAccess dataAccess;

    public boolean isExcluded(String fileName) {
        boolean isExcluded;
        String exclusionValue = this.getProperty(fileName);
        boolean bl = isExcluded = exclusionValue != null && exclusionValue.isEmpty();
        if (isExcluded) {
            log.log(Level.FINE, "file excluded ", fileName);
        }
        return isExcluded;
    }

    public boolean isExcluded(String fileName, String recordsetBaseName) {
        boolean isExcluded;
        if (recordsetBaseName.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        String exclusionValue = this.getProperty(fileName);
        boolean bl = isExcluded = exclusionValue != null && (exclusionValue.isEmpty() || exclusionValue.contains(recordsetBaseName));
        if (isExcluded) {
            log.fine(() -> String.format("recordset excluded %s %s", fileName, recordsetBaseName));
        }
        return isExcluded;
    }

    public String[] getExcludedTrusses(List<Path> excludedPaths) {
        return (String[])excludedPaths.stream().map(p -> {
            String key = p.getFileName().toString();
            String property = this.getProperty(key);
            return property.isEmpty() ? key : key + " : " + property;
        }).distinct().sorted(Collections.reverseOrder()).toArray(String[]::new);
    }

    public ExclusionData(Path activeFolder, DataAccess dataAccess) {
        this.activeFolder = activeFolder;
        this.dataAccess = dataAccess;
        String fileName = SecureHash.sha1(this.activeFolder.toString());
        Properties cachedInstance = memoryCache.getIfPresent(fileName);
        log.finer(() -> {
            CacheStats stats = memoryCache.stats();
            return String.format("evictionCount=%d  hitCount=%d  missCount=%d hitRate=%f missRate=%f", stats.evictionCount(), stats.hitCount(), stats.missCount(), stats.hitRate(), stats.missRate());
        });
        if (cachedInstance == null) {
            this.load();
        } else {
            this.putAll((Map<?, ?>)cachedInstance);
        }
    }

    @Override
    public String toString() {
        return this.stringPropertyNames().stream().sorted().map(this::getProperty).map(k -> k.isEmpty() ? k : k + " : " + this.getProperty((String)k)).collect(Collectors.joining("\n"));
    }

    @Override
    public Object setProperty(String dataFileName, String recordsetBaseName) {
        if (recordsetBaseName.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return super.setProperty(dataFileName, recordsetBaseName);
    }

    public Object setProperty(String dataFileName) {
        return super.setProperty(dataFileName, "");
    }

    public Object addToProperty(String dataFileName, String recordsetBaseName) {
        if (recordsetBaseName.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        if (this.getProperty(dataFileName) == null) {
            return super.setProperty(dataFileName, recordsetBaseName);
        }
        if (this.getProperty(dataFileName).isEmpty() || this.getProperty(dataFileName).contains(recordsetBaseName)) {
            return this.getProperty(dataFileName);
        }
        return super.setProperty(dataFileName, this.getProperty(dataFileName) + " + " + recordsetBaseName);
    }

    private void load() {
        this.dataAccess.ensureExclusionDirectory();
        String fileName = SecureHash.sha1(this.activeFolder.toString());
        if (this.dataAccess.existsExclusionFile(fileName)) {
            try (InputStreamReader reader = new InputStreamReader(this.dataAccess.getExclusionsInputStream(fileName));){
                this.load(reader);
                memoryCache.put(fileName, this);
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void store() {
        if (this.size() > 0) {
            this.dataAccess.ensureExclusionDirectory();
            String fileName = SecureHash.sha1(this.activeFolder.toString());
            try (OutputStreamWriter writer = new OutputStreamWriter(this.dataAccess.getExclusionsOutputStream(fileName), "UTF-8");){
                this.store(writer, this.activeFolder.toString());
                memoryCache.put(fileName, this);
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        } else {
            this.delete();
            String fileName = SecureHash.sha1(this.activeFolder.toString());
            memoryCache.invalidate(fileName);
        }
    }

    public void delete() {
        String fileName = SecureHash.sha1(this.activeFolder.toString());
        this.dataAccess.deleteExclusionFile(fileName);
        memoryCache.invalidateAll();
    }
}

