/*
 * Decompiled with CFR 0.152.
 */
package gde.device.spektrum;

import com.monstarmike.tlmreader.Flight;
import com.monstarmike.tlmreader.IFlight;
import com.monstarmike.tlmreader.TLMReader;
import com.monstarmike.tlmreader.datablock.AirspeedBlock;
import com.monstarmike.tlmreader.datablock.AltitudeBlock;
import com.monstarmike.tlmreader.datablock.AltitudeZeroBlock;
import com.monstarmike.tlmreader.datablock.CurrentBlock;
import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.datablock.EscBlock;
import com.monstarmike.tlmreader.datablock.FlightPackBlock;
import com.monstarmike.tlmreader.datablock.GForceBlock;
import com.monstarmike.tlmreader.datablock.GPSCollectorBlock;
import com.monstarmike.tlmreader.datablock.GPSLocationBlock;
import com.monstarmike.tlmreader.datablock.GPSStatusBlock;
import com.monstarmike.tlmreader.datablock.HeaderBlock;
import com.monstarmike.tlmreader.datablock.HeaderNameBlock;
import com.monstarmike.tlmreader.datablock.JetCatBlock;
import com.monstarmike.tlmreader.datablock.PowerBoxBlock;
import com.monstarmike.tlmreader.datablock.RxBlock;
import com.monstarmike.tlmreader.datablock.ServoDataBlock;
import com.monstarmike.tlmreader.datablock.StandardBlock;
import com.monstarmike.tlmreader.datablock.TemperatureBlock;
import com.monstarmike.tlmreader.datablock.VarioBlock;
import com.monstarmike.tlmreader.datablock.VoltageBlock;
import gde.GDE;
import gde.data.Channel;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.spektrum.SpektrumAdapter;
import gde.exception.DataInconsitsentException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.menu.MenuToolBar;
import gde.utils.StringHelper;
import gde.utils.TimeLine;
import gde.utils.WaitTimer;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class TlmReader {
    static final int TIME_LIMIT_MS = 5000;
    static final Logger log = Logger.getLogger(TlmReader.class.getName());

    private static boolean mergeRawData(List<Integer> measurementRawValues, int[] points, int destPos, int length, RecordSet recordSet, boolean isResetMinMax, int zeroValueIndex) {
        int i;
        boolean isReset = isResetMinMax;
        int[] srcValues = new int[measurementRawValues.size()];
        for (i = 0; i < measurementRawValues.size(); ++i) {
            srcValues[i] = measurementRawValues.get(i) * 1000;
        }
        if (!isResetMinMax && measurementRawValues.get(zeroValueIndex) != 0) {
            i = destPos;
            int j = 0;
            while (i < destPos + length) {
                recordSet.get(i).setMinMax(srcValues[j], srcValues[j]);
                ++i;
                ++j;
            }
            isReset = true;
        }
        System.arraycopy(srcValues, 0, points, destPos, length);
        return isReset;
    }

    private static boolean mergeGPSRawData(List<Integer> measurementRawValues, int[] points, int destPos, int length, RecordSet recordSet, boolean isResetMinMax, int zeroValueIndex) {
        int i;
        boolean isReset = isResetMinMax;
        int[] srcValues = new int[measurementRawValues.size() - 1];
        for (i = 0; i < measurementRawValues.size() - 1; ++i) {
            srcValues[i] = i == 1 || i == 2 ? measurementRawValues.get(i) : measurementRawValues.get(i) * 1000;
        }
        if (!isResetMinMax && measurementRawValues.get(zeroValueIndex) != 0) {
            i = destPos;
            int j = 0;
            while (i < destPos + length) {
                recordSet.get(i).setMinMax(srcValues[j], srcValues[j]);
                ++i;
                ++j;
            }
            isReset = true;
        }
        System.arraycopy(srcValues, 0, points, destPos, length);
        return isReset;
    }

    protected static String getRecordSetExtend(String fileName) {
        Object recordSetNameExtend;
        block6: {
            recordSetNameExtend = "";
            if (fileName.contains("_")) {
                try {
                    Integer.parseInt(fileName.substring(0, fileName.lastIndexOf(95)));
                    recordSetNameExtend = " [" + fileName.substring(0, fileName.lastIndexOf(95)) + "]";
                }
                catch (Exception e) {
                    if (fileName.substring(0, fileName.lastIndexOf(95)).length() <= 8) {
                        recordSetNameExtend = " [" + fileName.substring(0, fileName.lastIndexOf(95)) + "]";
                    }
                    break block6;
                }
            }
            try {
                Integer.parseInt(fileName.substring(0, 4));
                recordSetNameExtend = " [" + fileName.substring(0, 4) + "]";
            }
            catch (Exception e) {
                if (fileName.substring(0, fileName.length()).length() > 12) break block6;
                recordSetNameExtend = " [" + fileName.substring(0, fileName.length() - 4) + "]";
            }
        }
        return recordSetNameExtend;
    }

    public static RecordSet read(String selectedImportFile) throws IOException, DataInconsitsentException {
        long startTime = System.nanoTime() / 1000000L;
        TLMReader reader = new TLMReader();
        RecordSet tmpRecordSet = null;
        MenuToolBar menuToolBar = SpektrumAdapter.application.getMenuToolBar();
        SpektrumAdapter device = (SpektrumAdapter)SpektrumAdapter.application.getActiveDevice();
        Object recordSetName = "";
        String recordSetNameExtend = TlmReader.getRecordSetExtend(new File(selectedImportFile).getName());
        Channel channel = null;
        int channelNumber = SpektrumAdapter.analyser.getActiveChannel().getNumber();
        if (new File(selectedImportFile).exists()) {
            String modelName = "???";
            int index = 0;
            List flights = new ArrayList();
            try {
                flights = reader.parseFlightDefinitions(selectedImportFile);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "found " + flights.size() + " flight sessions");
                }
            }
            catch (Exception e) {
                DataExplorer.getInstance().openMessageDialogAsync(e.getMessage());
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date().getTime());
            String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(new Date().getTime());
            channel = (Channel)SpektrumAdapter.channels.get((Object)channelNumber);
            channel.setFileDescription((String)(SpektrumAdapter.application.isObjectoriented() ? date + " " + SpektrumAdapter.application.getObjectKey() : date));
            if (log.isLoggable(Level.TIME)) {
                log.log(Level.TIME, "read flight definitions time = " + StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime)));
            }
            for (IFlight flight : flights) {
                if (flight.getDuration_ms() <= 5000L && flight.getNumberOfDataBlocks() <= 10 && flight.getHeaderBlocks().size() <= 0) continue;
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, String.format("flight.getDuration() = %d ms", flight.getDuration_ms()));
                }
                Flight currentFlight = reader.parseFlight(selectedImportFile, index);
                for (HeaderBlock header : currentFlight.getHeaderBlocks()) {
                    if (!(header instanceof HeaderNameBlock) || ((HeaderNameBlock)header).getModelName().length() <= 3) continue;
                    modelName = ((HeaderNameBlock)header).getModelName();
                }
                if (currentFlight.getDuration_ms() > 5000L) {
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, String.format("model %s flight %d duration() = %s", modelName, index, TimeLine.getFomatedTimeWithUnit((double)currentFlight.getDuration_ms())));
                    }
                    List dataBlocks = currentFlight.getDataBlocks();
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "current flight contains " + dataBlocks.size() + " DataBlocks, and " + currentFlight.getHeaderBlocks().size() + " headerBlocks");
                    }
                    currentFlight.removeRedundantDataBlocks();
                    int recordSetNumber = ((Channel)SpektrumAdapter.channels.get((Object)1)).maxSize() + 1;
                    long numberDatablocks = dataBlocks.size() + 1;
                    int progressIndicator = (int)(numberDatablocks / 5L);
                    GDE.getUiNotification().setProgress(0);
                    int indexDataBlock = 0;
                    recordSetName = recordSetNumber + device.getRecordSetStemNameReplacement() + recordSetNameExtend;
                    tmpRecordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)channelNumber, (boolean)true, (boolean)true, (boolean)true);
                    channel.put(recordSetName, (Object)tmpRecordSet);
                    tmpRecordSet = (RecordSet)channel.get(recordSetName);
                    tmpRecordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + dateTime);
                    int[] points = new int[device.getNumberOfMeasurements(channelNumber)];
                    long timeOffset = -1L;
                    int sizeSupportedDataBlockTypes = 16;
                    boolean[] isResetMinMax = new boolean[sizeSupportedDataBlockTypes];
                    Iterator iterator = dataBlocks.iterator();
                    while (iterator.hasNext()) {
                        DataBlock data = (DataBlock)iterator.next();
                        ++indexDataBlock;
                        if (data instanceof StandardBlock) {
                            isResetMinMax[0] = TlmReader.mergeRawData(((StandardBlock)data).getMeasurementValues(), points, 0, 5, tmpRecordSet, isResetMinMax[0], 2);
                        } else if (data instanceof RxBlock) {
                            isResetMinMax[1] = TlmReader.mergeRawData(((RxBlock)data).getMeasurementValues(), points, 5, 7, tmpRecordSet, isResetMinMax[1], 6);
                        } else if (data instanceof VarioBlock) {
                            TlmReader.mergeRawData(((VarioBlock)data).getMeasurementValues(), points, 12, 2, tmpRecordSet, true, -1);
                        } else if (data instanceof AltitudeBlock) {
                            TlmReader.mergeRawData(((AltitudeBlock)data).getMeasurementValues(), points, 14, 1, tmpRecordSet, true, -1);
                        } else if (data instanceof AltitudeZeroBlock) {
                            TlmReader.mergeRawData(((AltitudeZeroBlock)data).getMeasurementValues(), points, 15, 1, tmpRecordSet, true, -1);
                        } else if (data instanceof VoltageBlock) {
                            isResetMinMax[5] = TlmReader.mergeRawData(((VoltageBlock)data).getMeasurementValues(), points, 16, 1, tmpRecordSet, isResetMinMax[5], 0);
                        } else if (data instanceof CurrentBlock) {
                            TlmReader.mergeRawData(((CurrentBlock)data).getMeasurementValues(), points, 17, 1, tmpRecordSet, true, -1);
                        } else if (data instanceof TemperatureBlock) {
                            isResetMinMax[7] = TlmReader.mergeRawData(((TemperatureBlock)data).getMeasurementValues(), points, 18, 1, tmpRecordSet, isResetMinMax[7], 0);
                        } else if (data instanceof AirspeedBlock) {
                            TlmReader.mergeRawData(((AirspeedBlock)data).getMeasurementValues(), points, 19, 1, tmpRecordSet, true, -1);
                        } else if (data instanceof GPSLocationBlock) {
                            GPSCollectorBlock.getInstance().updateLocation((GPSLocationBlock)data);
                            if (GPSCollectorBlock.getInstance().isUpdated()) {
                                isResetMinMax[9] = TlmReader.mergeGPSRawData(GPSCollectorBlock.getInstance().getMeasurementValues(), points, 20, 8, tmpRecordSet, isResetMinMax[9], 1);
                            }
                        } else if (data instanceof GPSStatusBlock) {
                            GPSCollectorBlock.getInstance().updateStatus((GPSStatusBlock)data);
                            if (GPSCollectorBlock.getInstance().isUpdated()) {
                                isResetMinMax[9] = TlmReader.mergeGPSRawData(GPSCollectorBlock.getInstance().getMeasurementValues(), points, 20, 8, tmpRecordSet, isResetMinMax[9], 1);
                            }
                        } else if (data instanceof FlightPackBlock) {
                            TlmReader.mergeRawData(((FlightPackBlock)data).getMeasurementValues(), points, 29, 6, tmpRecordSet, true, -1);
                        } else if (data instanceof EscBlock) {
                            isResetMinMax[11] = TlmReader.mergeRawData(((EscBlock)data).getMeasurementValues(), points, 35, 9, tmpRecordSet, isResetMinMax[11], 1);
                        } else if (data instanceof PowerBoxBlock) {
                            isResetMinMax[12] = TlmReader.mergeRawData(((PowerBoxBlock)data).getMeasurementValues(), points, 44, 5, tmpRecordSet, isResetMinMax[12], 0);
                        } else if (data instanceof JetCatBlock) {
                            isResetMinMax[13] = TlmReader.mergeRawData(((JetCatBlock)data).getMeasurementValues(), points, 49, 7, tmpRecordSet, isResetMinMax[13], 2);
                        } else if (data instanceof GForceBlock) {
                            TlmReader.mergeRawData(((GForceBlock)data).getMeasurementValues(), points, 56, 7, tmpRecordSet, true, -1);
                        } else if (data instanceof ServoDataBlock) {
                            TlmReader.mergeRawData(((ServoDataBlock)data).getMeasurementValues(), points, 63, 20, tmpRecordSet, true, -1);
                        } else {
                            log.log(Level.WARNING, data.toString());
                        }
                        if (timeOffset == -1L) {
                            timeOffset = data.getTimestamp();
                        }
                        tmpRecordSet.addPoints(points, (double)((long)data.getTimestamp() - timeOffset) * 10.0);
                        if (indexDataBlock % progressIndicator == 0) {
                            GDE.getUiNotification().setProgress((int)((long)(indexDataBlock * 100) / numberDatablocks));
                        }
                        iterator.remove();
                    }
                    if (GDE.isWithUi() && tmpRecordSet != null) {
                        device.makeInActiveDisplayable(tmpRecordSet);
                        tmpRecordSet.descriptionAppendFilename(new File(selectedImportFile).getName());
                        channel.applyTemplate((String)recordSetName, false);
                        menuToolBar.updateChannelSelector();
                        menuToolBar.updateRecordSetSelectCombo();
                        SpektrumAdapter.channels.switchChannel(channelNumber, (String)recordSetName);
                        GDE.getUiNotification().setProgress(100);
                    }
                    if (log.isLoggable(Level.TIME)) {
                        log.log(Level.TIME, String.format("read flight %d time = %s", index, StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime))));
                    }
                    WaitTimer.delay((long)100L);
                }
                ++index;
            }
        }
        if (log.isLoggable(Level.TIME)) {
            log.log(Level.TIME, "overall read time = " + StringHelper.getFormatedTime((String)"mm:ss:SSS", (long)(System.nanoTime() / 1000000L - startTime)));
        }
        return tmpRecordSet;
    }
}

