/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.data.Channel;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTAdapter2;
import gde.device.graupner.HoTTAdapterDialog;
import gde.device.graupner.HoTTAdapterLiveGatherer;
import gde.device.graupner.HoTTAdapterSerialPort;
import gde.device.graupner.HoTTbinReader;
import gde.device.graupner.HoTTbinReader2;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;

public class HoTTAdapter2LiveGatherer
extends HoTTAdapterLiveGatherer {
    static final Logger logger = Logger.getLogger(HoTTAdapter2LiveGatherer.class.getName());

    public HoTTAdapter2LiveGatherer(DataExplorer currentApplication, HoTTAdapter useDevice, HoTTAdapterSerialPort useSerialPort, HoTTAdapterDialog useDialog) throws Exception {
        super(currentApplication, useDevice, useSerialPort, useDialog);
    }

    @Override
    public void run() {
        boolean isChannelsActive;
        int[] points;
        RecordSet recordSet;
        block93: {
            recordSet = null;
            points = null;
            HoTTAdapterLiveGatherer.recordSets.clear();
            isChannelsActive = this.serialPort.getProtocolType().equals("115200") && (this.device.getName().equals("HoTTAdapterD") || this.device.getName().startsWith("HoTTAdapter2") && this.channels.getActiveChannelNumber() == 4);
            StringBuilder sb = new StringBuilder();
            try {
                int i;
                if (!this.serialPort.isConnected()) {
                    this.serialPort.open();
                    this.isPortOpenedByLiveGatherer = true;
                }
                this.serialPort.isInterruptedByUser = false;
                long startTime = new Date().getTime();
                for (i = 0; i < HoTTAdapterLiveGatherer.isSensorType.length; ++i) {
                    HoTTAdapterLiveGatherer.isSensorType[i] = false;
                }
                WaitTimer.delay((long)1000L);
                if (this.serialPort.cleanInputStream() > 2) {
                    HoTTAdapter.IS_SLAVE_MODE = true;
                    logger.log(Level.WARNING, "HoTTAdapter2.IS_SLAVE_MODE = " + HoTTAdapter.IS_SLAVE_MODE);
                    break block93;
                }
                HoTTAdapter.IS_SLAVE_MODE = false;
                logger.log(Level.FINE, "HoTTAdapter2.IS_SLAVE_MODE = " + HoTTAdapter.IS_SLAVE_MODE);
                for (i = 0; !(i >= 3 || HoTTAdapterLiveGatherer.isSensorType[0] || HoTTAdapterLiveGatherer.isSensorType[1] || HoTTAdapterLiveGatherer.isSensorType[2] || HoTTAdapterLiveGatherer.isSensorType[3] || HoTTAdapterLiveGatherer.isSensorType[4] || HoTTAdapterLiveGatherer.isSensorType[5]); ++i) {
                    try {
                        this.detectSensorType();
                        continue;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                try {
                    this.detectSensorType();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
                boolean[] tmpSensorType = (boolean[])HoTTAdapterLiveGatherer.isSensorType.clone();
                for (int i2 = 0; i2 < HoTTAdapterLiveGatherer.isSensorType.length; ++i2) {
                    if (sb.length() == 0 && tmpSensorType[i2]) {
                        sb.append("Receiver");
                        tmpSensorType[i2] = false;
                        continue;
                    }
                    if (!tmpSensorType[i2]) continue;
                    sb.append(", ").append(tmpSensorType[0] ? "Receiver" : (tmpSensorType[1] ? "VARIO" : (tmpSensorType[2] ? "GPS" : (tmpSensorType[3] ? "GENERAL" : (tmpSensorType[4] ? "ELECTRIC" : (tmpSensorType[5] ? "AIR_ESC" : ""))))));
                    tmpSensorType[i2] = false;
                }
                if (HoTTAdapterLiveGatherer.log.isLoggable(Level.TIME)) {
                    HoTTAdapterLiveGatherer.log.log(Level.TIME, sb.toString() + ", detecting sensor type takes " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - startTime)));
                }
                HoTTbinReader2.detectedSensors = HoTTAdapter.Sensor.getSetFromDetected(sb.toString().replace(" ", ""));
                if (isChannelsActive) {
                    HoTTbinReader2.detectedSensors.add(HoTTAdapter.Sensor.CHANNEL);
                }
                this.application.setStatusMessage(HoTTbinReader2.detectedSensors.toString());
                if (!(HoTTAdapterLiveGatherer.isSensorType[1] || HoTTAdapterLiveGatherer.isSensorType[2] || HoTTAdapterLiveGatherer.isSensorType[3] || HoTTAdapterLiveGatherer.isSensorType[4] || HoTTAdapterLiveGatherer.isSensorType[5])) {
                    this.serialPort.setSensorType(this.serialPort.protocolType.ordinal() < 2 ? (byte)-128 : 52);
                    if (!HoTTAdapterLiveGatherer.isSensorType[0]) {
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGW2400"));
                    }
                }
            }
            catch (SerialPortException e) {
                this.serialPort.close();
                this.dialog.resetButtons();
                this.application.openMessageDialogAsync(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                return;
            }
            catch (ApplicationConfigurationException e) {
                this.serialPort.close();
                this.dialog.resetButtons();
                this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        HoTTAdapter2LiveGatherer.this.application.getDeviceSelectionDialog().open();
                    }
                });
                return;
            }
            catch (Throwable t) {
                this.serialPort.close();
                logger.log(Level.SEVERE, t.getMessage(), t);
                this.dialog.resetButtons();
                this.application.openMessageDialogAsync(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{t.getClass().getSimpleName() + " : " + t.getMessage()}));
                return;
            }
        }
        HoTTbinReader.setAltitudeClimbPickeParameter(this.device.pickerParameters, HoTTbinReader2.detectedSensors);
        this.channel = this.application.getActiveChannel();
        String recordSetNameExtend = " [live]";
        String recordSetKey = this.channel.getNextRecordSetNumber() + this.device.getRecordSetStemNameReplacement() + recordSetNameExtend;
        this.dialog.selectTab(this.device.getLastChannelNumber());
        this.channel = (Channel)this.channels.get((Object)this.device.getLastChannelNumber());
        recordSet = RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.device, (int)this.device.getLastChannelNumber(), (boolean)true, (boolean)true, (boolean)true);
        this.channel.put((Object)recordSetKey, (Object)recordSet);
        HoTTAdapterLiveGatherer.recordSets.put(HoTTAdapter.Sensor.RECEIVER.value(), recordSet);
        this.channel.applyTemplate(recordSetKey, true);
        points = new int[recordSet.size()];
        this.application.getMenuToolBar().updateChannelSelector();
        this.application.getMenuToolBar().updateRecordSetSelectCombo();
        this.channels.switchChannel(this.channel.getName());
        this.channel.switchRecordSet(recordSetKey);
        this.application.setStatusMessage(HoTTbinReader2.detectedSensors.toString());
        recordSet.setRecordSetDescription(recordSet.getRecordSetDescription() + String.format(" - %s Baud", this.serialPort.getProtocolType()) + String.format(" - Sensor: %s", HoTTbinReader2.detectedSensors.toString()) + (HoTTAdapter2.isAltClimbSensor(HoTTbinReader2.detectedSensors) ? String.format(" - %s = %s", Messages.getString((String)"GDE_MSGT2419"), HoTTAdapter.Sensor.fromOrdinal(this.device.pickerParameters.altitudeClimbSensorSelection).name()) : ""));
        boolean isGPSdetected = false;
        Vector<Integer> queryRing = new Vector<Integer>();
        for (int i = 1; i < HoTTAdapterLiveGatherer.isSensorType.length; ++i) {
            if (!HoTTAdapterLiveGatherer.isSensorType[i]) continue;
            queryRing.add(i);
        }
        long measurementCount = 0L;
        int lastNumberDisplayableRecords = 0;
        long startTime = System.nanoTime() / 1000000L;
        while (!this.serialPort.isInterruptedByUser) {
            block94: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "====> entry");
                }
                try {
                    RecordSet activeRecordSet;
                    switch (this.serialPort.protocolType) {
                        case TYPE_19200_V3: 
                        case TYPE_19200_V4: {
                            if (HoTTAdapter.IS_SLAVE_MODE) {
                                this.serialPort.setSensorType((byte)-128);
                                this.dataBuffer = this.serialPort.getData(false);
                                while (!this.serialPort.isInterruptedByUser && !this.checkContainsDataBegin(this.dataBuffer)) {
                                    WaitTimer.delay((long)30L);
                                    this.dataBuffer = this.serialPort.getData(false);
                                }
                                WaitTimer.delay((long)30L);
                                this.serialPort.getData(false);
                                WaitTimer.delay((long)30L);
                                if (this.checkSignature(this.dataBuffer, (byte)-128)) {
                                    recordSet.addPoints(this.device.convertDataBytes(points, this.serialPort.getData(true)), (double)(System.nanoTime() / 1000000L - startTime));
                                    break;
                                }
                                if (this.checkSignature(this.dataBuffer, (byte)-114)) {
                                    this.serialPort.setSensorType((byte)-114);
                                    recordSet.addPoints(this.device.convertDataBytes(points, this.serialPort.getData(true)), (double)(System.nanoTime() / 1000000L - startTime));
                                    break;
                                }
                                if (this.checkSignature(this.dataBuffer, (byte)-115)) {
                                    this.serialPort.setSensorType((byte)-115);
                                    recordSet.addPoints(this.device.convertDataBytes(points, this.serialPort.getData(true)), (double)(System.nanoTime() / 1000000L - startTime));
                                    break;
                                }
                                if (this.checkSignature(this.dataBuffer, (byte)-116)) {
                                    this.serialPort.setSensorType((byte)-116);
                                    recordSet.addPoints(this.device.convertDataBytes(points, this.serialPort.getData(true)), (double)(System.nanoTime() / 1000000L - startTime));
                                    break;
                                }
                                if (this.checkSignature(this.dataBuffer, (byte)-118)) {
                                    this.serialPort.setSensorType((byte)-118);
                                    recordSet.addPoints(this.device.convertDataBytes(points, this.serialPort.getData(true)), (double)(System.nanoTime() / 1000000L - startTime));
                                    break;
                                }
                                if (!this.checkSignature(this.dataBuffer, (byte)-119)) break;
                                this.serialPort.setSensorType((byte)-119);
                                recordSet.addPoints(this.device.convertDataBytes(points, this.serialPort.getData(true)), (double)(System.nanoTime() / 1000000L - startTime));
                                break;
                            }
                            if (!(!HoTTAdapterLiveGatherer.isSensorType[0] || HoTTAdapterLiveGatherer.isSensorType[1] || HoTTAdapterLiveGatherer.isSensorType[2] || HoTTAdapterLiveGatherer.isSensorType[3] || HoTTAdapterLiveGatherer.isSensorType[4] || HoTTAdapterLiveGatherer.isSensorType[5])) {
                                try {
                                    WaitTimer.delay((long)30L);
                                    this.serialPort.setSensorType((byte)-128);
                                    this.serialPort.getData(false);
                                    WaitTimer.delay((long)30L);
                                    this.device.convertDataBytes(points, this.serialPort.getData(true));
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 4) {
                                try {
                                    WaitTimer.delay((long)30L);
                                    this.serialPort.setSensorType((byte)-114);
                                    this.serialPort.getData(false);
                                    WaitTimer.delay((long)30L);
                                    this.device.convertDataBytes(points, this.serialPort.getData(true));
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 3) {
                                try {
                                    WaitTimer.delay((long)30L);
                                    this.serialPort.setSensorType((byte)-115);
                                    this.serialPort.getData(true);
                                    WaitTimer.delay((long)30L);
                                    this.device.convertDataBytes(points, this.serialPort.getData(true));
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 5) {
                                try {
                                    WaitTimer.delay((long)30L);
                                    this.serialPort.setSensorType((byte)-116);
                                    this.serialPort.getData(true);
                                    WaitTimer.delay((long)30L);
                                    this.device.convertDataBytes(points, this.serialPort.getData(true));
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 2) {
                                try {
                                    WaitTimer.delay((long)30L);
                                    this.serialPort.setSensorType((byte)-118);
                                    this.serialPort.getData(true);
                                    WaitTimer.delay((long)30L);
                                    this.dataBuffer = this.serialPort.getData(true);
                                    this.device.convertDataBytes(points, this.dataBuffer);
                                    if (!isGPSdetected) {
                                        if (!isGPSdetected) {
                                            HoTTAdapter2.updateGpsTypeDependent(points[37] / 1000, (IDevice)this.device, recordSet, -1);
                                            isGPSdetected = true;
                                        }
                                        isGPSdetected = true;
                                    }
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() <= 0 || (Integer)queryRing.firstElement() != 1) break;
                            try {
                                WaitTimer.delay((long)30L);
                                this.serialPort.setSensorType((byte)-119);
                                this.serialPort.getData(true);
                                WaitTimer.delay((long)30L);
                                this.device.convertDataBytes(points, this.serialPort.getData(true));
                            }
                            catch (TimeOutException e) {
                                this.serialPort.addTimeoutError();
                            }
                            break;
                        }
                        case TYPE_115200: {
                            if (HoTTAdapterLiveGatherer.isSensorType[0]) {
                                try {
                                    this.serialPort.setSensorType((byte)52);
                                    for (int i = 0; i < 2 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                                        Thread.sleep(30L);
                                    }
                                    this.serialPort.getDataDBM(true, this.dataBuffer);
                                    this.device.convertDataBytes(points, this.dataBuffer);
                                    Thread.sleep(30L);
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                                if (isChannelsActive) {
                                    try {
                                        this.serialPort.setSensorType((byte)64);
                                        for (int i = 0; i < 2 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                                            Thread.sleep(30L);
                                        }
                                        this.device.convertDataBytes(points, this.dataBuffer);
                                        Thread.sleep(30L);
                                    }
                                    catch (TimeOutException e) {
                                        this.serialPort.addTimeoutError();
                                    }
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 4) {
                                try {
                                    this.serialPort.setSensorType((byte)54);
                                    for (int i = 0; i < 2 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                                        Thread.sleep(30L);
                                    }
                                    this.device.convertDataBytes(points, this.dataBuffer);
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 3) {
                                try {
                                    this.serialPort.setSensorType((byte)53);
                                    for (int i = 0; i < 2 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                                        Thread.sleep(30L);
                                    }
                                    this.device.convertDataBytes(points, this.dataBuffer);
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 5) {
                                try {
                                    this.serialPort.setSensorType((byte)57);
                                    for (int i = 0; i < 2 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                                        Thread.sleep(30L);
                                    }
                                    this.device.convertDataBytes(points, this.dataBuffer);
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() > 0 && (Integer)queryRing.firstElement() == 2) {
                                try {
                                    this.serialPort.setSensorType((byte)56);
                                    for (int i = 0; i < 2 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                                        Thread.sleep(30L);
                                    }
                                    this.device.convertDataBytes(points, this.dataBuffer);
                                    if (!isGPSdetected) {
                                        HoTTAdapter2.updateGpsTypeDependent(points[37] / 1000, (IDevice)this.device, recordSet, -1);
                                        isGPSdetected = true;
                                    }
                                }
                                catch (TimeOutException e) {
                                    this.serialPort.addTimeoutError();
                                }
                            }
                            if (queryRing.size() <= 0 || (Integer)queryRing.firstElement() != 1) break;
                            try {
                                this.serialPort.setSensorType((byte)55);
                                for (int i = 0; i < 5 && !this.serialPort.isCheckSumOK(4, this.dataBuffer = this.serialPort.getData()); ++i) {
                                    Thread.sleep(30L);
                                }
                                this.device.convertDataBytes(points, this.dataBuffer);
                                break;
                            }
                            catch (TimeOutException e) {
                                this.serialPort.addTimeoutError();
                            }
                        }
                    }
                    recordSet.addPoints(points, (double)(System.nanoTime() / 1000000L - startTime));
                    if (queryRing.size() > 1) {
                        queryRing.add((Integer)queryRing.remove(0));
                    }
                    if (++measurementCount % 5L == 0L) {
                        for (RecordSet tmpRecordSet : HoTTAdapterLiveGatherer.recordSets.values()) {
                            this.device.updateVisibilityStatus(tmpRecordSet, true);
                        }
                    }
                    if ((activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet()) != null && recordSet.size() > 0 && recordSet.isChildOfActiveChannel() && recordSet.equals((Object)activeRecordSet)) {
                        this.application.updateAllTabs(false, lastNumberDisplayableRecords != recordSet.getConfiguredDisplayable());
                        lastNumberDisplayableRecords = recordSet.getConfiguredDisplayable();
                    }
                    if (this.serialPort.getTimeoutErrors() <= 2 || this.serialPort.getTimeoutErrors() % 10 != 0) break block94;
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGW0045", (Object[])new Object[]{"TimeOutException", this.serialPort.getTimeoutErrors() + "; xferErrors = " + this.serialPort.getXferErrors()}), 3);
                }
                catch (DataInconsitsentException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    Iterator<RecordSet> message = Messages.getString((String)"GDE_MSGE0028", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()});
                    for (RecordSet tmpRecordSet : HoTTAdapterLiveGatherer.recordSets.values()) {
                        this.cleanup(tmpRecordSet.getName(), (String)((Object)message));
                    }
                }
                catch (TimeOutException e) {
                    logger.log(Level.WARNING, e.getMessage());
                    this.serialPort.addTimeoutError();
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGW0045", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName(), this.serialPort.getTimeoutErrors() + "; xferErrors = " + this.serialPort.getXferErrors()}), 3);
                    WaitTimer.delay((long)30L);
                }
                catch (SerialPortException | IOException e) {
                    logger.log(Level.WARNING, e.getMessage());
                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                    for (RecordSet tmpRecordSet : HoTTAdapterLiveGatherer.recordSets.values()) {
                        this.finalizeRecordSet(tmpRecordSet);
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    this.application.openMessageDialogAsync(e.getClass().getSimpleName() + " - " + e.getMessage());
                    for (RecordSet tmpRecordSet : HoTTAdapterLiveGatherer.recordSets.values()) {
                        this.finalizeRecordSet(tmpRecordSet);
                    }
                }
            }
            WaitTimer.delay((long)30L);
        }
        for (RecordSet tmpRecordSet : HoTTAdapterLiveGatherer.recordSets.values()) {
            this.finalizeRecordSet(tmpRecordSet);
        }
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                String toolTipText = HoTTAdapter.getImportToolTip();
                HoTTAdapter2LiveGatherer.this.device.configureSerialPortMenu(2, toolTipText, toolTipText);
            }
        });
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "exit");
        }
    }
}

