/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.tab;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.menu.TabAreaContextMenu;
import gde.utils.GraphicsUtils;
import gde.utils.MathUtils;
import java.text.DecimalFormat;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class AnalogDisplay
extends Composite {
    static final Logger log = Logger.getLogger(AnalogDisplay.class.getName());
    Canvas tacho;
    CLabel textAnalogLabel;
    final int textHeight = 30;
    Image tachoImage;
    GC tachoImageGC;
    Rectangle tachoImageBounds = new Rectangle(0, 0, 0, 0);
    int[] needle = new int[]{0, 0, 0, 0, 0, 0, 0};
    int width = 0;
    int height = 0;
    int centerX;
    int centerY;
    int radius;
    int angleStart;
    int angleDelta;
    double actualValue = 0.0;
    double minValue = 0.0;
    double maxValue = 1.0;
    final DataExplorer application;
    final Channel channel;
    final String recordKey;
    final IDevice device;
    final Color backgroundColor;
    final Menu popupmenu;
    final TabAreaContextMenu contextMenu;
    RecordSet recordSet;
    Record record;

    public AnalogDisplay(Composite analogMainComposite, String currentRecordKey, IDevice currentDevice) {
        super(analogMainComposite, 2048);
        FillLayout AnalogDisplayLayout = new FillLayout(256);
        GridData analogDisplayLData = new GridData();
        analogDisplayLData.grabExcessVerticalSpace = true;
        analogDisplayLData.grabExcessHorizontalSpace = true;
        analogDisplayLData.verticalAlignment = 4;
        analogDisplayLData.horizontalAlignment = 4;
        this.setLayoutData(analogDisplayLData);
        this.setLayout((Layout)AnalogDisplayLayout);
        this.application = DataExplorer.getInstance();
        this.recordKey = currentRecordKey;
        this.device = currentDevice;
        this.channel = Channels.getInstance().getActiveChannel();
        if (this.channel != null) {
            this.recordSet = this.channel.getActiveRecordSet();
            this.record = this.recordSet != null ? this.recordSet.get(this.recordKey) : null;
        } else {
            this.recordSet = null;
            this.record = null;
        }
        this.backgroundColor = Settings.getInstance().getAnalogInnerAreaBackground();
        this.popupmenu = new Menu((Decorations)this.application.getShell(), 8);
        this.contextMenu = new TabAreaContextMenu();
        this.contextMenu.createMenu(this.popupmenu, TabAreaContextMenu.TabMenuType.SIMPLE);
    }

    public void create() {
        this.addHelpListener(new HelpListener(this){

            public void helpRequested(HelpEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "AnalogDisplay.helpRequested " + String.valueOf(evt));
                }
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_8.html");
            }
        });
        this.tacho = new Canvas((Composite)this, 0);
        this.tacho.setMenu(this.popupmenu);
        this.tacho.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                AnalogDisplay.this.recordSet = AnalogDisplay.this.channel.getActiveRecordSet();
                if (AnalogDisplay.this.recordSet != null) {
                    AnalogDisplay.this.record = AnalogDisplay.this.recordSet.get(AnalogDisplay.this.recordKey);
                    AnalogDisplay.this.tachoPaintControl(evt);
                }
            }
        });
        this.textAnalogLabel = new CLabel((Composite)this.tacho, 0x1000000);
        this.textAnalogLabel.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 2, 1));
        this.textAnalogLabel.setBackground(this.backgroundColor);
        this.textAnalogLabel.setForeground(this.application.COLOR_BLACK);
        this.textAnalogLabel.setBounds(0, 0, this.tacho.getSize().x, this.textHeight);
        this.textAnalogLabel.setMenu(this.popupmenu);
    }

    void tachoPaintControl(PaintEvent evt) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "tacho.paintControl, event=" + String.valueOf(evt));
        }
        if (this.record != null) {
            this.tachoImageBounds = ((Canvas)evt.widget).getClientArea();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "tacho redaw required for " + this.recordKey);
            }
            this.width = this.tachoImageBounds.width;
            this.height = this.tachoImageBounds.height;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "canvas size = " + this.width + " x " + this.height);
            }
            this.tachoImage = SWTResourceManager.getImage(this.width, this.height, this.recordKey);
            this.tachoImageGC = new GC((Drawable)this.tachoImage);
            this.tachoImageGC.setBackground(this.backgroundColor);
            this.tachoImageGC.fillRectangle(0, 0, this.width, this.height);
            String recordText = this.recordKey + " [ " + this.record.getUnit() + " ]";
            this.textAnalogLabel.setSize(this.width, this.textHeight);
            this.textAnalogLabel.setText(recordText);
            this.centerX = this.width / 2;
            this.centerY = (int)((double)this.height * 0.75);
            double radiusW = (double)this.width / 2.0 * 0.8;
            double radiusH = (double)this.height * 0.75 - (double)this.textHeight - 40.0;
            this.radius = (int)(radiusW < radiusH ? radiusW : radiusH);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "radius = " + this.radius + " height = " + this.height + " width = " + this.width);
            }
            this.angleStart = -20;
            this.angleDelta = 220;
            this.tachoImageGC.setForeground(SWTResourceManager.getColor(this.record.getRGB()));
            this.tachoImageGC.setLineWidth(4);
            this.tachoImageGC.drawArc(this.centerX - this.radius, this.centerY - this.radius, 2 * this.radius, 2 * this.radius, this.angleStart, this.angleDelta);
            this.tachoImageGC.setForeground(this.application.COLOR_BLACK);
            this.tachoImageGC.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            int numberTicks = 10;
            double deltaValue = (this.maxValue - this.minValue) / (double)numberTicks;
            double angleSteps = (double)this.angleDelta * 1.0 / (double)numberTicks;
            int tickRadius = this.radius + 2;
            this.tachoImageGC.setLineWidth(2);
            DecimalFormat df = this.record.getDecimalFormat();
            for (int i = 0; i <= numberTicks; ++i) {
                double angle = (double)this.angleStart + (double)i * angleSteps;
                int dxr = Double.valueOf((double)tickRadius * Math.cos(angle * Math.PI / 180.0)).intValue();
                int dyr = Double.valueOf((double)tickRadius * Math.sin(angle * Math.PI / 180.0)).intValue();
                int dxtick = Double.valueOf((double)(tickRadius + 10) * Math.cos(angle * Math.PI / 180.0)).intValue();
                int dytick = Double.valueOf((double)(tickRadius + 10) * Math.sin(angle * Math.PI / 180.0)).intValue();
                this.tachoImageGC.drawLine(this.centerX - dxtick, this.centerY - dytick, this.centerX - dxr, this.centerY - dyr);
                int dxtext = Double.valueOf((double)(this.radius + 30) * Math.cos(angle * Math.PI / 180.0)).intValue();
                int dytext = Double.valueOf((double)(this.radius + 30) * Math.sin(angle * Math.PI / 180.0)).intValue();
                String valueText = df.format(this.minValue + (double)i * deltaValue);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "value = " + valueText);
                }
                GraphicsUtils.drawTextCentered(valueText, this.centerX - dxtext, this.centerY - dytext, this.tachoImageGC, 256);
            }
            this.tachoImageGC.setBackground(this.application.COLOR_GREY);
            int knobRradius = (int)((double)this.radius * 0.1);
            this.tachoImageGC.fillArc(this.centerX - knobRradius, this.centerY - knobRradius, 2 * knobRradius, 2 * knobRradius, 0, 360);
            this.tachoImageGC.setBackground(this.application.COLOR_BLACK);
            knobRradius = Double.valueOf((double)this.radius / 10.0 * 0.2).intValue();
            this.tachoImageGC.fillArc(this.centerX - knobRradius, this.centerY - knobRradius, 2 * knobRradius, 2 * knobRradius, 0, 360);
            evt.gc.drawImage(this.tachoImage, 0, 0, this.width, this.height, 0, 0, this.width, this.height);
            if (this.record.size() > 0) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "record name = " + this.recordKey);
                }
                double tmpMinValue = this.record.isScaleSynced() ? (double)this.record.getSyncMinValue() : (double)this.record.getMinValue();
                tmpMinValue = this.device.translateValue(this.record, tmpMinValue / 1000.0);
                double tmpMaxValue = this.record.isScaleSynced() ? (double)this.record.getSyncMaxValue() : (double)this.record.getMaxValue();
                tmpMaxValue = this.device.translateValue(this.record, tmpMaxValue / 1000.0);
                double deltaScale = tmpMaxValue - tmpMinValue;
                tmpMinValue = MathUtils.roundDown(tmpMinValue, deltaScale);
                tmpMaxValue = MathUtils.roundUp(tmpMaxValue, deltaScale);
                if (tmpMinValue != this.minValue || tmpMaxValue != this.maxValue) {
                    this.minValue = tmpMinValue;
                    this.maxValue = tmpMaxValue;
                    this.tacho.redraw();
                }
                Rectangle damageBounds = this.getNeedleBounds();
                double tmpActualValue = this.device.translateValue(this.record, (double)((Integer)this.record.lastElement()).intValue() / 1000.0);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("value = %3.2f; min = %3.2f; max = %3.2f", this.actualValue, this.minValue, this.maxValue));
                }
                if (tmpActualValue != this.actualValue) {
                    this.actualValue = tmpActualValue;
                    damageBounds = this.getNeedleBounds();
                    this.redraw(damageBounds.x, damageBounds.y, damageBounds.width, damageBounds.height, true);
                }
                this.drawTachoNeedle(evt.gc, this.application.COLOR_BLACK);
            }
            this.tachoImageGC.dispose();
        }
    }

    private void drawTachoNeedle(GC gc, Color color) {
        gc.setBackground(color);
        gc.setLineWidth(1);
        gc.fillPolygon(this.needle);
    }

    private void calculateNeedle() {
        int needleRadius = this.radius - 5;
        int innerRadius = (int)((double)this.radius * 0.1) + 3;
        double angle = (double)this.angleStart + (this.actualValue - this.minValue) / (this.maxValue - this.minValue) * (double)this.angleDelta;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "angle = " + angle + " actualValue = " + this.actualValue);
        }
        int posXo = Double.valueOf((double)this.centerX - (double)needleRadius * Math.cos(angle * Math.PI / 180.0)).intValue();
        int posYo = Double.valueOf((double)this.centerY - (double)needleRadius * Math.sin(angle * Math.PI / 180.0)).intValue();
        int posXi = Double.valueOf((double)this.centerX - (double)innerRadius * Math.cos(angle * Math.PI / 180.0)).intValue();
        int posYi = Double.valueOf((double)this.centerY - (double)innerRadius * Math.sin(angle * Math.PI / 180.0)).intValue();
        int posX1 = Double.valueOf((double)this.centerX - (double)(needleRadius - 30) * Math.cos((angle - 3.0) * Math.PI / 180.0)).intValue();
        int posY1 = Double.valueOf((double)this.centerY - (double)(needleRadius - 30) * Math.sin((angle - 3.0) * Math.PI / 180.0)).intValue();
        int posX2 = Double.valueOf((double)this.centerX - (double)(needleRadius - 30) * Math.cos((angle + 3.0) * Math.PI / 180.0)).intValue();
        int posY2 = Double.valueOf((double)this.centerY - (double)(needleRadius - 30) * Math.sin((angle + 3.0) * Math.PI / 180.0)).intValue();
        this.needle = new int[]{posX1, posY1, posXo, posYo, posX2, posY2, posXi, posYi};
    }

    Rectangle getNeedleBounds() {
        int i;
        this.calculateNeedle();
        int x = this.needle[0];
        int xWidth = this.needle[0];
        int y = this.needle[1];
        int yHeight = this.needle[1];
        for (i = 0; i < this.needle.length; i += 2) {
            x = x < this.needle[i] ? x : this.needle[i];
            xWidth = xWidth > this.needle[i] ? xWidth : this.needle[i];
        }
        for (i = 1; i < this.needle.length; i += 2) {
            y = y < this.needle[i] ? y : this.needle[i];
            yHeight = yHeight > this.needle[i] ? yHeight : this.needle[i];
        }
        return new Rectangle(x, y, xWidth - x, yHeight - y);
    }

    public void checkTachoNeedlePosition() {
        if (this.record != null && this.record.size() > 0) {
            double tmpActualValue = this.device.translateValue(this.record, (double)((Integer)this.record.lastElement()).intValue() / 1000.0);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("value = %3.2f; min = %3.2f; max = %3.2f", this.actualValue, this.minValue, this.maxValue));
            }
            if (tmpActualValue != this.actualValue) {
                Rectangle damageBounds = this.getNeedleBounds();
                this.redraw(damageBounds.x, damageBounds.y, damageBounds.width, damageBounds.height, true);
            }
        }
    }
}

