/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.AirspeedBlock;
import com.monstarmike.tlmreader.datablock.AltitudeBlock;
import com.monstarmike.tlmreader.datablock.AltitudeZeroBlock;
import com.monstarmike.tlmreader.datablock.CurrentBlock;
import com.monstarmike.tlmreader.datablock.EscBlock;
import com.monstarmike.tlmreader.datablock.FlightPackBlock;
import com.monstarmike.tlmreader.datablock.FrameDataBlock;
import com.monstarmike.tlmreader.datablock.GForceBlock;
import com.monstarmike.tlmreader.datablock.GPSLocationBlock;
import com.monstarmike.tlmreader.datablock.GPSStatusBlock;
import com.monstarmike.tlmreader.datablock.HeaderRpmBlock;
import com.monstarmike.tlmreader.datablock.IBlock;
import com.monstarmike.tlmreader.datablock.JetCatBlock;
import com.monstarmike.tlmreader.datablock.PowerBoxBlock;
import com.monstarmike.tlmreader.datablock.RtcBlock;
import com.monstarmike.tlmreader.datablock.RxBlock;
import com.monstarmike.tlmreader.datablock.RxPackCapacityBlock;
import com.monstarmike.tlmreader.datablock.ServoDataBlock;
import com.monstarmike.tlmreader.datablock.StandardBlock;
import com.monstarmike.tlmreader.datablock.TemperatureBlock;
import com.monstarmike.tlmreader.datablock.VarioBlock;
import com.monstarmike.tlmreader.datablock.VoltageBlock;
import com.monstarmike.tlmreader.primitives.Ints;
import com.sun.istack.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class DataBlock
implements IBlock {
    private static int currentSeq = 0;
    protected int sequence = currentSeq++;
    protected int timestamp;
    protected List<String> measurementNames = new ArrayList<String>();
    protected List<String> measurementUnits = new ArrayList<String>();
    protected List<Double> measurementFactors = new ArrayList<Double>();
    protected List<Integer> measurementValues = new ArrayList<Integer>();

    protected DataBlock() {
    }

    public DataBlock(byte[] rawData) {
        this.decode(rawData);
    }

    protected DataBlock(DataBlock that) {
        this.timestamp = that.timestamp;
        this.sequence = that.sequence;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    private void decode(byte[] rawData) {
        this.timestamp = Ints.fromBytes(rawData[3], rawData[2], rawData[1], rawData[0]);
    }

    public static DataBlock createDataBlock(byte[] bytes, HeaderRpmBlock rpmHeaderBlock) {
        DataBlock block = null;
        short tm1100 = (short)(bytes[4] & 0xFF);
        if (tm1100 == 254 || tm1100 == 255) {
            switch (tm1100) {
                case 254: {
                    block = new StandardBlock(bytes, rpmHeaderBlock);
                    break;
                }
                case 255: {
                    block = new RxBlock(bytes);
                }
            }
        } else if (bytes[4] == 9 && bytes[5] == 6) {
            block = new ServoDataBlock(bytes);
        } else {
            switch (SensorType.fromSensorByte(bytes[4])) {
                default: {
                    break;
                }
                case VOLTAGE: {
                    block = new VoltageBlock(bytes);
                    break;
                }
                case TEMPERATURE: {
                    block = new TemperatureBlock(bytes);
                    break;
                }
                case AMPS: {
                    block = new CurrentBlock(bytes);
                    break;
                }
                case PBOX: {
                    block = new PowerBoxBlock(bytes);
                    break;
                }
                case AIRSPEED: {
                    block = new AirspeedBlock(bytes);
                    break;
                }
                case ALTITUDE: {
                    block = new AltitudeBlock(bytes);
                    break;
                }
                case GMETER: {
                    block = new GForceBlock(bytes);
                    break;
                }
                case JETCAT: {
                    block = new JetCatBlock(bytes);
                    break;
                }
                case GPS_LOC: {
                    block = new GPSLocationBlock(bytes);
                    break;
                }
                case GPS_STATS: {
                    block = new GPSStatusBlock(bytes);
                    break;
                }
                case RX_MAH: {
                    block = new RxPackCapacityBlock(bytes);
                    break;
                }
                case VARIO_S: {
                    block = new VarioBlock(bytes);
                    break;
                }
                case ESC: {
                    block = new EscBlock(bytes);
                    break;
                }
                case FLIGHT_PACK: {
                    block = new FlightPackBlock(bytes);
                    break;
                }
                case RPM: {
                    block = new StandardBlock(bytes, rpmHeaderBlock);
                    break;
                }
                case ALT_ZERO: {
                    block = new AltitudeZeroBlock(bytes);
                    break;
                }
                case RTC: {
                    block = new RtcBlock(bytes);
                    break;
                }
                case FRAMEDATA: {
                    block = new FrameDataBlock(bytes);
                    break;
                }
                case QOS: {
                    block = new RxBlock(bytes);
                }
            }
        }
        return block;
    }

    public String byte2Hex2CharString(byte[] bytes, int size) {
        StringBuffer sb = new StringBuffer().append("{");
        int i = 0;
        while (i < size) {
            sb.append(String.format(" (byte)0x%02X,", bytes[i]));
            ++i;
        }
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public int getSize() {
        return 20;
    }

    @Override
    public List<Integer> getMeasurementValues() {
        return this.measurementValues;
    }

    @Override
    public List<String> getMeasurementNames() {
        return this.measurementNames;
    }

    @Override
    public List<String> getMeasurementUnits() {
        return this.measurementUnits;
    }

    @Override
    public List<Double> getMeasurementFactors() {
        return this.measurementFactors;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append(String.format(Locale.ENGLISH, "%-18s", this.getClass().getSimpleName())).append(this.getTimestamp()).append(" - ");
        this.measurementNames = this.getMeasurementNames();
        this.measurementUnits = this.getMeasurementUnits();
        this.measurementFactors = this.getMeasurementFactors();
        this.measurementValues = this.getMeasurementValues();
        int i = 0;
        while (i < this.measurementNames.size()) {
            sb.append(this.measurementNames.get(i)).append(" = ").append(this.measurementFactors.get(i) != 1.0 ? String.format(Locale.ENGLISH, "%.1f", (double)this.measurementValues.get(i).intValue() * this.measurementFactors.get(i)) : String.format(Locale.ENGLISH, "%d", (int)((double)this.measurementValues.get(i).intValue() * this.measurementFactors.get(i)))).append(" ").append(this.measurementUnits.get(i)).append("; ");
            ++i;
        }
        return sb.toString();
    }

    public String getNamesAndUnitsAsCCV() {
        StringBuilder sb = new StringBuilder().append(String.format(Locale.ENGLISH, "%-18s, Time [ms],", this.getClass().getSimpleName()));
        this.measurementNames = this.getMeasurementNames();
        this.measurementUnits = this.getMeasurementUnits();
        int i = 0;
        while (i < this.measurementNames.size()) {
            sb.append(this.measurementNames.get(i)).append(" [").append(this.measurementUnits.get(i)).append("],");
            ++i;
        }
        return sb.toString();
    }

    public String getCorrectedValuesAsCCV() {
        StringBuilder sb = new StringBuilder().append(String.format(Locale.ENGLISH, "%-18s, %d,", this.getClass().getSimpleName(), this.getTimestamp() * 10));
        this.measurementValues = this.getMeasurementValues();
        this.measurementFactors = this.getMeasurementFactors();
        int i = 0;
        while (i < this.measurementValues.size()) {
            sb.append(String.format(Locale.ENGLISH, " %7.2f,", (double)this.measurementValues.get(i).intValue() * this.measurementFactors.get(i)));
            ++i;
        }
        return sb.toString();
    }

    public static enum SensorType {
        NODATA(0),
        VOLTAGE(1),
        TEMPERATURE(2),
        AMPS(3),
        FLITECTRL(5),
        PBOX(10),
        LAPTIMER(11),
        VTX(13),
        AIRSPEED(17),
        ALTITUDE(18),
        GMETER(20),
        JETCAT(21),
        GPS_LOC(22),
        GPS_STATS(23),
        RX_MAH(24),
        JETCAT_2(25),
        GYRO(26),
        ATTMAG(27),
        TILT(28),
        AS6X_GAIN(30),
        AS3X_LEGACYGAIN(31),
        ESC(32),
        FUEL(34),
        ALPHA6(36),
        GPS_BINARY(38),
        FLIGHT_PACK(52),
        DIGITAL_AIR(54),
        STRAIN(56),
        LIPOMON(58),
        LIPOMON_14(63),
        VARIO_S(64),
        SMARTBATT(66),
        VSPEAK(96),
        SMOKE_EL(97),
        CROSSFIRE(98),
        ALT_ZERO(123),
        RTC(124),
        FRAMEDATA(125),
        RPM(126),
        QOS(127);

        final int id;
        final String name;
        public static final SensorType[] VALUES;

        static {
            VALUES = SensorType.values();
        }

        private SensorType(int value) {
            this.id = value;
            this.name = this.name();
        }

        @Nullable
        public static SensorType fromSensorByte(byte sensorByte) {
            SensorType[] sensorTypeArray = VALUES;
            int n = VALUES.length;
            int n2 = 0;
            while (n2 < n) {
                SensorType sensor = sensorTypeArray[n2];
                if (sensor.id == sensorByte) {
                    return sensor;
                }
                ++n2;
            }
            return NODATA;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

