/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;

public final class OS2BMPFileFormat
extends FileFormat {
    static final int BMPFileHeaderSize = 14;
    static final int BMPHeaderFixedSize = 12;
    int width;
    int height;
    int bitCount;

    @Override
    boolean isFileFormat(LEDataInputStream stream) {
        try {
            byte[] header = new byte[18];
            stream.read(header);
            stream.unread(header);
            int infoHeaderSize = header[14] & 0xFF | (header[15] & 0xFF) << 8 | (header[16] & 0xFF) << 16 | (header[17] & 0xFF) << 24;
            return header[0] == 66 && header[1] == 77 && infoHeaderSize == 12;
        }
        catch (Exception exception) {
            return false;
        }
    }

    byte[] loadData(byte[] infoHeader) {
        int stride = (this.width * this.bitCount + 7) / 8;
        stride = (stride + 3) / 4 * 4;
        byte[] data2 = this.loadData(infoHeader, stride);
        this.flipScanLines(data2, stride, this.height);
        return data2;
    }

    byte[] loadData(byte[] infoHeader, int stride) {
        int dataSize = this.height * stride;
        byte[] data2 = new byte[dataSize];
        try {
            if (this.inputStream.read(data2) != dataSize) {
                SWT.error(40);
            }
        }
        catch (IOException e2) {
            SWT.error(39, e2);
        }
        return data2;
    }

    int[] loadFileHeader() {
        int[] header = new int[5];
        try {
            header[0] = this.inputStream.readShort();
            header[1] = this.inputStream.readInt();
            header[2] = this.inputStream.readShort();
            header[3] = this.inputStream.readShort();
            header[4] = this.inputStream.readInt();
        }
        catch (IOException e2) {
            SWT.error(39, e2);
        }
        if (header[0] != 19778) {
            SWT.error(40);
        }
        return header;
    }

    @Override
    ImageData[] loadFromByteStream() {
        int[] fileHeader = this.loadFileHeader();
        byte[] infoHeader = new byte[12];
        try {
            this.inputStream.read(infoHeader);
        }
        catch (Exception e2) {
            SWT.error(39, e2);
        }
        this.width = infoHeader[4] & 0xFF | (infoHeader[5] & 0xFF) << 8;
        this.height = infoHeader[6] & 0xFF | (infoHeader[7] & 0xFF) << 8;
        this.bitCount = infoHeader[10] & 0xFF | (infoHeader[11] & 0xFF) << 8;
        PaletteData palette = this.loadPalette(infoHeader);
        if (this.inputStream.getPosition() < fileHeader[4]) {
            try {
                this.inputStream.skip(fileHeader[4] - this.inputStream.getPosition());
            }
            catch (IOException e3) {
                SWT.error(39, e3);
            }
        }
        byte[] data2 = this.loadData(infoHeader);
        int type2 = 7;
        return new ImageData[]{ImageData.internal_new(this.width, this.height, this.bitCount, palette, 4, data2, 0, null, null, -1, -1, type2, 0, 0, 0, 0)};
    }

    PaletteData loadPalette(byte[] infoHeader) {
        if (this.bitCount <= 8) {
            int numColors = 1 << this.bitCount;
            byte[] buf = new byte[numColors * 3];
            try {
                if (this.inputStream.read(buf) != buf.length) {
                    SWT.error(40);
                }
            }
            catch (IOException e2) {
                SWT.error(39, e2);
            }
            return this.paletteFromBytes(buf, numColors);
        }
        if (this.bitCount == 16) {
            return new PaletteData(31744, 992, 31);
        }
        if (this.bitCount == 24) {
            return new PaletteData(255, 65280, 0xFF0000);
        }
        return new PaletteData(65280, 0xFF0000, -16777216);
    }

    PaletteData paletteFromBytes(byte[] bytes, int numColors) {
        int bytesOffset = 0;
        RGB[] colors = new RGB[numColors];
        int i2 = 0;
        while (i2 < numColors) {
            colors[i2] = new RGB(bytes[bytesOffset + 2] & 0xFF, bytes[bytesOffset + 1] & 0xFF, bytes[bytesOffset] & 0xFF);
            bytesOffset += 3;
            ++i2;
        }
        return new PaletteData(colors);
    }

    static byte[] paletteToBytes(PaletteData pal) {
        int n2 = pal.colors == null ? 0 : (pal.colors.length < 256 ? pal.colors.length : 256);
        byte[] bytes = new byte[n2 * 3];
        int offset = 0;
        int i2 = 0;
        while (i2 < n2) {
            RGB col = pal.colors[i2];
            bytes[offset] = (byte)col.blue;
            bytes[offset + 1] = (byte)col.green;
            bytes[offset + 2] = (byte)col.red;
            offset += 3;
            ++i2;
        }
        return bytes;
    }

    int unloadData(ImageData image, OutputStream out) {
        int bmpBpl = 0;
        try {
            int bpl = (image.width * image.depth + 7) / 8;
            bmpBpl = (bpl + 3) / 4 * 4;
            int linesPerBuf = 32678 / bmpBpl;
            byte[] buf = new byte[linesPerBuf * bmpBpl];
            byte[] data2 = image.data;
            int imageBpl = image.bytesPerLine;
            int dataIndex = imageBpl * (image.height - 1);
            if (image.depth == 16) {
                int y2 = 0;
                while (y2 < image.height) {
                    int count = image.height - y2;
                    if (linesPerBuf < count) {
                        count = linesPerBuf;
                    }
                    int bufOffset = 0;
                    int i2 = 0;
                    while (i2 < count) {
                        int wIndex = 0;
                        while (wIndex < bpl) {
                            buf[bufOffset + wIndex + 1] = data2[dataIndex + wIndex + 1];
                            buf[bufOffset + wIndex] = data2[dataIndex + wIndex];
                            wIndex += 2;
                        }
                        bufOffset += bmpBpl;
                        dataIndex -= imageBpl;
                        ++i2;
                    }
                    out.write(buf, 0, bufOffset);
                    y2 += linesPerBuf;
                }
            } else {
                int y3 = 0;
                while (y3 < image.height) {
                    int tmp = image.height - y3;
                    int count = tmp < linesPerBuf ? tmp : linesPerBuf;
                    int bufOffset = 0;
                    int i3 = 0;
                    while (i3 < count) {
                        System.arraycopy(data2, dataIndex, buf, bufOffset, bpl);
                        bufOffset += bmpBpl;
                        dataIndex -= imageBpl;
                        ++i3;
                    }
                    out.write(buf, 0, bufOffset);
                    y3 += linesPerBuf;
                }
            }
        }
        catch (IOException e2) {
            SWT.error(39, e2);
        }
        return bmpBpl * image.height;
    }

    @Override
    void unloadIntoByteStream(ImageLoader loader2) {
        byte[] rgbs;
        int numCols;
        ImageData image = loader2.data[0];
        if (image.depth != 1 && image.depth != 4 && image.depth != 8 && image.depth != 16 && image.depth != 24 && image.depth != 32) {
            SWT.error(38);
        }
        PaletteData pal = image.palette;
        if (image.depth == 16 || image.depth == 24 || image.depth == 32) {
            if (!pal.isDirect) {
                SWT.error(40);
            }
            numCols = 0;
            rgbs = null;
        } else {
            if (pal.isDirect) {
                SWT.error(40);
            }
            numCols = pal.colors.length;
            rgbs = OS2BMPFileFormat.paletteToBytes(pal);
        }
        int headersSize = 26;
        int[] fileHeader = new int[]{19778, 0, 0, 0, headersSize};
        if (rgbs != null) {
            fileHeader[4] = fileHeader[4] + rgbs.length;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.unloadData(image, out);
        byte[] data2 = out.toByteArray();
        fileHeader[1] = fileHeader[4] + data2.length;
        try {
            this.outputStream.writeShort(fileHeader[0]);
            this.outputStream.writeInt(fileHeader[1]);
            this.outputStream.writeShort(fileHeader[2]);
            this.outputStream.writeShort(fileHeader[3]);
            this.outputStream.writeInt(fileHeader[4]);
        }
        catch (IOException e2) {
            SWT.error(39, e2);
        }
        try {
            this.outputStream.writeInt(12);
            this.outputStream.writeShort(image.width);
            this.outputStream.writeShort(image.height);
            this.outputStream.writeShort(1);
            this.outputStream.writeShort((short)image.depth);
        }
        catch (IOException e3) {
            SWT.error(39, e3);
        }
        if (numCols > 0) {
            try {
                this.outputStream.write(rgbs);
            }
            catch (IOException e4) {
                SWT.error(39, e4);
            }
        }
        try {
            this.outputStream.write(data2);
        }
        catch (IOException e5) {
            SWT.error(39, e5);
        }
    }

    void flipScanLines(byte[] data2, int stride, int height) {
        int i1 = 0;
        int i2 = (height - 1) * stride;
        int i3 = 0;
        while (i3 < height / 2) {
            int index = 0;
            while (index < stride) {
                byte b2 = data2[index + i1];
                data2[index + i1] = data2[index + i2];
                data2[index + i2] = b2;
                ++index;
            }
            i1 += stride;
            i2 -= stride;
            ++i3;
        }
    }
}

