/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.simple.extend.XhtmlCssOnlyNamespaceHandler;

public class XhtmlNamespaceHandler
extends XhtmlCssOnlyNamespaceHandler {
    @Override
    public boolean isImageElement(Element e2) {
        return e2 != null && e2.getNodeName().equalsIgnoreCase("img");
    }

    @Override
    public boolean isFormElement(Element e2) {
        return e2 != null && e2.getNodeName().equalsIgnoreCase("form");
    }

    @Override
    public String getImageSourceURI(Element e2) {
        String uri = null;
        if (e2 != null) {
            uri = e2.getAttribute("src");
        }
        return uri;
    }

    @Override
    public String getNonCssStyling(Element e2) {
        if (e2.getNodeName().equals("table")) {
            return this.applyTableStyles(e2);
        }
        if (e2.getNodeName().equals("td") || e2.getNodeName().equals("th")) {
            return this.applyTableCellStyles(e2);
        }
        if (e2.getNodeName().equals("tr")) {
            return this.applyTableRowStyles(e2);
        }
        if (e2.getNodeName().equals("img")) {
            return this.applyImgStyles(e2);
        }
        if (e2.getNodeName().equals("p") || e2.getNodeName().equals("div")) {
            return this.applyBlockAlign(e2);
        }
        return "";
    }

    private String applyBlockAlign(Element e2) {
        StringBuffer style = new StringBuffer();
        this.applyTextAlign(e2, style);
        return style.toString();
    }

    private String applyImgStyles(Element e2) {
        StringBuffer style = new StringBuffer();
        this.applyFloatingAlign(e2, style);
        return style.toString();
    }

    private String applyTableCellStyles(Element e2) {
        String s2;
        StringBuffer style = new StringBuffer();
        Element table = this.findTable(e2);
        if (table != null) {
            s2 = this.getAttribute(table, "cellpadding");
            if (s2 != null) {
                style.append("padding: ");
                style.append(this.convertToLength(s2));
                style.append(";");
            }
            if ((s2 = this.getAttribute(table, "border")) != null && !s2.equals("0")) {
                style.append("border: 1px outset black;");
            }
        }
        if ((s2 = this.getAttribute(e2, "width")) != null) {
            style.append("width: ");
            style.append(this.convertToLength(s2));
            style.append(";");
        }
        if ((s2 = this.getAttribute(e2, "height")) != null) {
            style.append("height: ");
            style.append(this.convertToLength(s2));
            style.append(";");
        }
        this.applyTableContentAlign(e2, style);
        s2 = this.getAttribute(e2, "bgcolor");
        if (s2 != null) {
            s2 = s2.toLowerCase();
            style.append("background-color: ");
            if (this.looksLikeAMangledColor(s2)) {
                style.append('#');
                style.append(s2);
            } else {
                style.append(s2);
            }
            style.append(';');
        }
        if ((s2 = this.getAttribute(e2, "background")) != null) {
            style.append("background-image: url(");
            style.append(s2);
            style.append(");");
        }
        return style.toString();
    }

    private String applyTableStyles(Element e2) {
        StringBuffer style = new StringBuffer();
        String s2 = this.getAttribute(e2, "width");
        if (s2 != null) {
            style.append("width: ");
            style.append(this.convertToLength(s2));
            style.append(";");
        }
        if ((s2 = this.getAttribute(e2, "border")) != null) {
            style.append("border: ");
            style.append(this.convertToLength(s2));
            style.append(" inset black;");
        }
        if ((s2 = this.getAttribute(e2, "cellspacing")) != null) {
            style.append("border-collapse: separate; border-spacing: ");
            style.append(this.convertToLength(s2));
            style.append(";");
        }
        if ((s2 = this.getAttribute(e2, "bgcolor")) != null) {
            s2 = s2.toLowerCase();
            style.append("background-color: ");
            if (this.looksLikeAMangledColor(s2)) {
                style.append('#');
                style.append(s2);
            } else {
                style.append(s2);
            }
            style.append(';');
        }
        if ((s2 = this.getAttribute(e2, "background")) != null) {
            style.append("background-image: url(");
            style.append(s2);
            style.append(");");
        }
        this.applyFloatingAlign(e2, style);
        return style.toString();
    }

    private String applyTableRowStyles(Element e2) {
        StringBuffer style = new StringBuffer();
        this.applyTableContentAlign(e2, style);
        return style.toString();
    }

    private void applyFloatingAlign(Element e2, StringBuffer style) {
        String s2 = this.getAttribute(e2, "align");
        if (s2 != null) {
            if ((s2 = s2.toLowerCase().trim()).equals("left")) {
                style.append("float: left;");
            } else if (s2.equals("right")) {
                style.append("float: right;");
            } else if (s2.equals("center")) {
                style.append("margin-left: auto; margin-right: auto;");
            }
        }
    }

    private void applyTextAlign(Element e2, StringBuffer style) {
        String s2 = this.getAttribute(e2, "align");
        if (s2 != null && ((s2 = s2.toLowerCase().trim()).equals("left") || s2.equals("right") || s2.equals("center") || s2.equals("justify"))) {
            style.append("text-align: ");
            style.append(s2);
            style.append(";");
        }
    }

    private void applyTableContentAlign(Element e2, StringBuffer style) {
        String s2 = this.getAttribute(e2, "align");
        if (s2 != null) {
            style.append("text-align: ");
            style.append(s2.toLowerCase());
            style.append(";");
        }
        if ((s2 = this.getAttribute(e2, "valign")) != null) {
            style.append("vertical-align: ");
            style.append(s2.toLowerCase());
            style.append(";");
        }
    }

    private boolean looksLikeAMangledColor(String s2) {
        if (s2.length() != 6) {
            return false;
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            boolean valid2;
            char c2 = s2.charAt(i2);
            boolean bl = valid2 = c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f';
            if (valid2) continue;
            return false;
        }
        return true;
    }

    private Element findTable(Element cell) {
        Element next;
        Node n2 = cell.getParentNode();
        if (n2.getNodeType() == 1 && (next = (Element)n2).getNodeName().equals("tr") && (n2 = next.getParentNode()).getNodeType() == 1) {
            next = (Element)n2;
            String name = next.getNodeName();
            if (name.equals("table")) {
                return next;
            }
            if ((name.equals("tbody") || name.equals("tfoot") || name.equals("thead")) && (n2 = next.getParentNode()).getNodeType() == 1 && (next = (Element)n2).getNodeName().equals("table")) {
                return next;
            }
        }
        return null;
    }
}

