/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.util.concurrent.Future;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.ContentResponseHandler;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;

public class Async {
    private Executor executor;
    private java.util.concurrent.Executor concurrentExec;

    public static Async newInstance() {
        return new Async();
    }

    Async() {
    }

    public Async use(Executor executor) {
        this.executor = executor;
        return this;
    }

    public Async use(java.util.concurrent.Executor concurrentExec) {
        this.concurrentExec = concurrentExec;
        return this;
    }

    public <T> Future<T> execute(Request request, ResponseHandler<T> handler, FutureCallback<T> callback) {
        BasicFuture<T> future = new BasicFuture<T>(callback);
        ExecRunnable<T> runnable = new ExecRunnable<T>(future, request, this.executor != null ? this.executor : Executor.newInstance(), handler);
        if (this.concurrentExec != null) {
            this.concurrentExec.execute(runnable);
        } else {
            Thread t2 = new Thread(runnable);
            t2.setDaemon(true);
            t2.start();
        }
        return future;
    }

    public <T> Future<T> execute(Request request, ResponseHandler<T> handler) {
        return this.execute(request, handler, null);
    }

    public Future<Content> execute(Request request, FutureCallback<Content> callback) {
        return this.execute(request, new ContentResponseHandler(), callback);
    }

    public Future<Content> execute(Request request) {
        return this.execute(request, new ContentResponseHandler(), null);
    }

    static class ExecRunnable<T>
    implements Runnable {
        private final BasicFuture<T> future;
        private final Request request;
        private final Executor executor;
        private final ResponseHandler<T> handler;

        ExecRunnable(BasicFuture<T> future, Request request, Executor executor, ResponseHandler<T> handler) {
            this.future = future;
            this.request = request;
            this.executor = executor;
            this.handler = handler;
        }

        @Override
        public void run() {
            try {
                Response response = this.executor.execute(this.request);
                T result2 = response.handleResponse(this.handler);
                this.future.completed(result2);
            }
            catch (Exception ex) {
                this.future.failed(ex);
            }
        }
    }
}

