/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.analysis.solvers.UnivariateSolver;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.events.EventHandler;
import org.apache.commons.math3.ode.nonstiff.AdaptiveStepsizeIntegrator;
import org.apache.commons.math3.ode.nonstiff.GraggBulirschStoerStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.util.FastMath;

public class GraggBulirschStoerIntegrator
extends AdaptiveStepsizeIntegrator {
    private static final String METHOD_NAME = "Gragg-Bulirsch-Stoer";
    private int maxOrder;
    private int[] sequence;
    private int[] costPerStep;
    private double[] costPerTimeUnit;
    private double[] optimalStep;
    private double[][] coeff;
    private boolean performTest;
    private int maxChecks;
    private int maxIter;
    private double stabilityReduction;
    private double stepControl1;
    private double stepControl2;
    private double stepControl3;
    private double stepControl4;
    private double orderControl1;
    private double orderControl2;
    private boolean useInterpolationError;
    private int mudif;

    public GraggBulirschStoerIntegrator(double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(METHOD_NAME, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.setStabilityCheck(true, -1, -1, -1.0);
        this.setControlFactors(-1.0, -1.0, -1.0, -1.0);
        this.setOrderControl(-1, -1.0, -1.0);
        this.setInterpolationControl(true, -1);
    }

    public GraggBulirschStoerIntegrator(double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(METHOD_NAME, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.setStabilityCheck(true, -1, -1, -1.0);
        this.setControlFactors(-1.0, -1.0, -1.0, -1.0);
        this.setOrderControl(-1, -1.0, -1.0);
        this.setInterpolationControl(true, -1);
    }

    public void setStabilityCheck(boolean performStabilityCheck, int maxNumIter, int maxNumChecks, double stepsizeReductionFactor) {
        this.performTest = performStabilityCheck;
        this.maxIter = maxNumIter <= 0 ? 2 : maxNumIter;
        this.maxChecks = maxNumChecks <= 0 ? 1 : maxNumChecks;
        this.stabilityReduction = stepsizeReductionFactor < 1.0E-4 || stepsizeReductionFactor > 0.9999 ? 0.5 : stepsizeReductionFactor;
    }

    public void setControlFactors(double control1, double control2, double control3, double control4) {
        this.stepControl1 = control1 < 1.0E-4 || control1 > 0.9999 ? 0.65 : control1;
        this.stepControl2 = control2 < 1.0E-4 || control2 > 0.9999 ? 0.94 : control2;
        this.stepControl3 = control3 < 1.0E-4 || control3 > 0.9999 ? 0.02 : control3;
        this.stepControl4 = control4 < 1.0001 || control4 > 999.9 ? 4.0 : control4;
    }

    public void setOrderControl(int maximalOrder, double control1, double control2) {
        if (maximalOrder <= 6 || maximalOrder % 2 != 0) {
            this.maxOrder = 18;
        }
        this.orderControl1 = control1 < 1.0E-4 || control1 > 0.9999 ? 0.8 : control1;
        this.orderControl2 = control2 < 1.0E-4 || control2 > 0.9999 ? 0.9 : control2;
        this.initializeArrays();
    }

    public void addStepHandler(StepHandler handler) {
        super.addStepHandler(handler);
        this.initializeArrays();
    }

    public void addEventHandler(EventHandler function, double maxCheckInterval, double convergence, int maxIterationCount, UnivariateSolver solver) {
        super.addEventHandler(function, maxCheckInterval, convergence, maxIterationCount, solver);
        this.initializeArrays();
    }

    private void initializeArrays() {
        int k2;
        int size = this.maxOrder / 2;
        if (this.sequence == null || this.sequence.length != size) {
            this.sequence = new int[size];
            this.costPerStep = new int[size];
            this.coeff = new double[size][];
            this.costPerTimeUnit = new double[size];
            this.optimalStep = new double[size];
        }
        for (k2 = 0; k2 < size; ++k2) {
            this.sequence[k2] = 4 * k2 + 2;
        }
        this.costPerStep[0] = this.sequence[0] + 1;
        for (k2 = 1; k2 < size; ++k2) {
            this.costPerStep[k2] = this.costPerStep[k2 - 1] + this.sequence[k2];
        }
        for (k2 = 0; k2 < size; ++k2) {
            this.coeff[k2] = k2 > 0 ? new double[k2] : null;
            for (int l2 = 0; l2 < k2; ++l2) {
                double ratio = (double)this.sequence[k2] / (double)this.sequence[k2 - l2 - 1];
                this.coeff[k2][l2] = 1.0 / (ratio * ratio - 1.0);
            }
        }
    }

    public void setInterpolationControl(boolean useInterpolationErrorForControl, int mudifControlParameter) {
        this.useInterpolationError = useInterpolationErrorForControl;
        this.mudif = mudifControlParameter <= 0 || mudifControlParameter >= 7 ? 4 : mudifControlParameter;
    }

    private void rescale(double[] y1, double[] y2, double[] scale2) {
        if (this.vecAbsoluteTolerance == null) {
            for (int i2 = 0; i2 < scale2.length; ++i2) {
                double yi = FastMath.max(FastMath.abs(y1[i2]), FastMath.abs(y2[i2]));
                scale2[i2] = this.scalAbsoluteTolerance + this.scalRelativeTolerance * yi;
            }
        } else {
            for (int i3 = 0; i3 < scale2.length; ++i3) {
                double yi = FastMath.max(FastMath.abs(y1[i3]), FastMath.abs(y2[i3]));
                scale2[i3] = this.vecAbsoluteTolerance[i3] + this.vecRelativeTolerance[i3] * yi;
            }
        }
    }

    private boolean tryStep(double t0, double[] y0, double step, int k2, double[] scale2, double[][] f2, double[] yMiddle, double[] yEnd, double[] yTmp) throws MaxCountExceededException, DimensionMismatchException {
        int i2;
        int n2 = this.sequence[k2];
        double subStep = step / (double)n2;
        double subStep2 = 2.0 * subStep;
        double t2 = t0 + subStep;
        for (i2 = 0; i2 < y0.length; ++i2) {
            yTmp[i2] = y0[i2];
            yEnd[i2] = y0[i2] + subStep * f2[0][i2];
        }
        this.computeDerivatives(t2, yEnd, f2[1]);
        for (int j2 = 1; j2 < n2; ++j2) {
            if (2 * j2 == n2) {
                System.arraycopy(yEnd, 0, yMiddle, 0, y0.length);
            }
            t2 += subStep;
            for (int i3 = 0; i3 < y0.length; ++i3) {
                double middle = yEnd[i3];
                yEnd[i3] = yTmp[i3] + subStep2 * f2[j2][i3];
                yTmp[i3] = middle;
            }
            this.computeDerivatives(t2, yEnd, f2[j2 + 1]);
            if (!this.performTest || j2 > this.maxChecks || k2 >= this.maxIter) continue;
            double initialNorm = 0.0;
            for (int l2 = 0; l2 < scale2.length; ++l2) {
                double ratio = f2[0][l2] / scale2[l2];
                initialNorm += ratio * ratio;
            }
            double deltaNorm = 0.0;
            for (int l3 = 0; l3 < scale2.length; ++l3) {
                double ratio = (f2[j2 + 1][l3] - f2[0][l3]) / scale2[l3];
                deltaNorm += ratio * ratio;
            }
            if (!(deltaNorm > 4.0 * FastMath.max(1.0E-15, initialNorm))) continue;
            return false;
        }
        for (i2 = 0; i2 < y0.length; ++i2) {
            yEnd[i2] = 0.5 * (yTmp[i2] + yEnd[i2] + subStep * f2[n2][i2]);
        }
        return true;
    }

    private void extrapolate(int offset, int k2, double[][] diag, double[] last) {
        for (int j2 = 1; j2 < k2; ++j2) {
            for (int i2 = 0; i2 < last.length; ++i2) {
                diag[k2 - j2 - 1][i2] = diag[k2 - j2][i2] + this.coeff[k2 + offset][j2 - 1] * (diag[k2 - j2][i2] - diag[k2 - j2 - 1][i2]);
            }
        }
        for (int i3 = 0; i3 < last.length; ++i3) {
            last[i3] = diag[0][i3] + this.coeff[k2 + offset][k2 - 1] * (diag[0][i3] - last[i3]);
        }
    }

    public void integrate(ExpandableStatefulODE equations, double t2) throws NumberIsTooSmallException, DimensionMismatchException, MaxCountExceededException, NoBracketingException {
        this.sanityChecks(equations, t2);
        this.setEquations(equations);
        boolean forward = t2 > equations.getTime();
        double[] y0 = equations.getCompleteState();
        double[] y2 = (double[])y0.clone();
        double[] yDot0 = new double[y2.length];
        double[] y1 = new double[y2.length];
        double[] yTmp = new double[y2.length];
        double[] yTmpDot = new double[y2.length];
        double[][] diagonal = new double[this.sequence.length - 1][];
        double[][] y1Diag = new double[this.sequence.length - 1][];
        for (int k2 = 0; k2 < this.sequence.length - 1; ++k2) {
            diagonal[k2] = new double[y2.length];
            y1Diag[k2] = new double[y2.length];
        }
        double[][][] fk = new double[this.sequence.length][][];
        for (int k3 = 0; k3 < this.sequence.length; ++k3) {
            fk[k3] = new double[this.sequence[k3] + 1][];
            fk[k3][0] = yDot0;
            for (int l2 = 0; l2 < this.sequence[k3]; ++l2) {
                fk[k3][l2 + 1] = new double[y0.length];
            }
        }
        if (y2 != y0) {
            System.arraycopy(y0, 0, y2, 0, y0.length);
        }
        double[] yDot1 = new double[y0.length];
        double[][] yMidDots = new double[1 + 2 * this.sequence.length][y0.length];
        double[] scale2 = new double[this.mainSetDimension];
        this.rescale(y2, y2, scale2);
        double tol = this.vecRelativeTolerance == null ? this.scalRelativeTolerance : this.vecRelativeTolerance[0];
        double log10R = FastMath.log10(FastMath.max(1.0E-10, tol));
        int targetIter = FastMath.max(1, FastMath.min(this.sequence.length - 2, (int)FastMath.floor(0.5 - 0.6 * log10R)));
        GraggBulirschStoerStepInterpolator interpolator = new GraggBulirschStoerStepInterpolator(y2, yDot0, y1, yDot1, yMidDots, forward, equations.getPrimaryMapper(), equations.getSecondaryMappers());
        interpolator.storeTime(equations.getTime());
        this.stepStart = equations.getTime();
        double hNew = 0.0;
        double maxError = Double.MAX_VALUE;
        boolean previousRejected = false;
        boolean firstTime = true;
        boolean newStep = true;
        boolean firstStepAlreadyComputed = false;
        this.initIntegration(equations.getTime(), y0, t2);
        this.costPerTimeUnit[0] = 0.0;
        this.isLastStep = false;
        do {
            boolean reject = false;
            if (newStep) {
                interpolator.shift();
                if (!firstStepAlreadyComputed) {
                    this.computeDerivatives(this.stepStart, y2, yDot0);
                }
                if (firstTime) {
                    hNew = this.initializeStep(forward, 2 * targetIter + 1, scale2, this.stepStart, y2, yDot0, yTmp, yTmpDot);
                }
                newStep = false;
            }
            this.stepSize = hNew;
            if (forward && this.stepStart + this.stepSize > t2 || !forward && this.stepStart + this.stepSize < t2) {
                this.stepSize = t2 - this.stepStart;
            }
            double nextT = this.stepStart + this.stepSize;
            this.isLastStep = forward ? nextT >= t2 : nextT <= t2;
            int k4 = -1;
            boolean loop = true;
            block9: while (loop) {
                if (!this.tryStep(this.stepStart, y2, this.stepSize, k4, scale2, fk[++k4], k4 == 0 ? yMidDots[0] : diagonal[k4 - 1], k4 == 0 ? y1 : y1Diag[k4 - 1], yTmp)) {
                    hNew = FastMath.abs(this.filterStep(this.stepSize * this.stabilityReduction, forward, false));
                    reject = true;
                    loop = false;
                    continue;
                }
                if (k4 <= 0) continue;
                this.extrapolate(0, k4, y1Diag, y1);
                this.rescale(y2, y1, scale2);
                double error2 = 0.0;
                for (int j2 = 0; j2 < this.mainSetDimension; ++j2) {
                    double e2 = FastMath.abs(y1[j2] - y1Diag[0][j2]) / scale2[j2];
                    error2 += e2 * e2;
                }
                if ((error2 = FastMath.sqrt(error2 / (double)this.mainSetDimension)) > 1.0E15 || k4 > 1 && error2 > maxError) {
                    hNew = FastMath.abs(this.filterStep(this.stepSize * this.stabilityReduction, forward, false));
                    reject = true;
                    loop = false;
                    continue;
                }
                maxError = FastMath.max(4.0 * error2, 1.0);
                double exp = 1.0 / (double)(2 * k4 + 1);
                double fac = this.stepControl2 / FastMath.pow(error2 / this.stepControl1, exp);
                double pow = FastMath.pow(this.stepControl3, exp);
                fac = FastMath.max(pow / this.stepControl4, FastMath.min(1.0 / pow, fac));
                this.optimalStep[k4] = FastMath.abs(this.filterStep(this.stepSize * fac, forward, true));
                this.costPerTimeUnit[k4] = (double)this.costPerStep[k4] / this.optimalStep[k4];
                switch (k4 - targetIter) {
                    case -1: {
                        if (targetIter <= 1 || previousRejected) continue block9;
                        if (error2 <= 1.0) {
                            loop = false;
                            break;
                        }
                        double ratio = (double)this.sequence[targetIter] * (double)this.sequence[targetIter + 1] / (double)(this.sequence[0] * this.sequence[0]);
                        if (!(error2 > ratio * ratio)) continue block9;
                        reject = true;
                        loop = false;
                        targetIter = k4;
                        if (targetIter > 1 && this.costPerTimeUnit[targetIter - 1] < this.orderControl1 * this.costPerTimeUnit[targetIter]) {
                            --targetIter;
                        }
                        hNew = this.optimalStep[targetIter];
                        break;
                    }
                    case 0: {
                        if (error2 <= 1.0) {
                            loop = false;
                            break;
                        }
                        double ratio = (double)this.sequence[k4 + 1] / (double)this.sequence[0];
                        if (!(error2 > ratio * ratio)) continue block9;
                        reject = true;
                        loop = false;
                        if (targetIter > 1 && this.costPerTimeUnit[targetIter - 1] < this.orderControl1 * this.costPerTimeUnit[targetIter]) {
                            --targetIter;
                        }
                        hNew = this.optimalStep[targetIter];
                        break;
                    }
                    case 1: {
                        if (error2 > 1.0) {
                            reject = true;
                            if (targetIter > 1 && this.costPerTimeUnit[targetIter - 1] < this.orderControl1 * this.costPerTimeUnit[targetIter]) {
                                --targetIter;
                            }
                            hNew = this.optimalStep[targetIter];
                        }
                        loop = false;
                        break;
                    }
                    default: {
                        if (!firstTime && !this.isLastStep || !(error2 <= 1.0)) continue block9;
                        loop = false;
                    }
                }
            }
            if (!reject) {
                this.computeDerivatives(this.stepStart + this.stepSize, y1, yDot1);
            }
            double hInt = this.getMaxStep();
            if (!reject) {
                for (int j3 = 1; j3 <= k4; ++j3) {
                    this.extrapolate(0, j3, diagonal, yMidDots[0]);
                }
                int mu = 2 * k4 - this.mudif + 3;
                for (int l3 = 0; l3 < mu; ++l3) {
                    int j4;
                    int i2;
                    int l2 = l3 / 2;
                    double factor = FastMath.pow(0.5 * (double)this.sequence[l2], l3);
                    int middleIndex = fk[l2].length / 2;
                    for (i2 = 0; i2 < y0.length; ++i2) {
                        yMidDots[l3 + 1][i2] = factor * fk[l2][middleIndex + l3][i2];
                    }
                    for (j4 = 1; j4 <= k4 - l2; ++j4) {
                        factor = FastMath.pow(0.5 * (double)this.sequence[j4 + l2], l3);
                        middleIndex = fk[l2 + j4].length / 2;
                        for (int i3 = 0; i3 < y0.length; ++i3) {
                            diagonal[j4 - 1][i3] = factor * fk[l2 + j4][middleIndex + l3][i3];
                        }
                        this.extrapolate(l2, j4, diagonal, yMidDots[l3 + 1]);
                    }
                    i2 = 0;
                    while (i2 < y0.length) {
                        double[] dArray = yMidDots[l3 + 1];
                        int n2 = i2++;
                        dArray[n2] = dArray[n2] * this.stepSize;
                    }
                    for (j4 = (l3 + 1) / 2; j4 <= k4; ++j4) {
                        for (int m2 = fk[j4].length - 1; m2 >= 2 * (l3 + 1); --m2) {
                            for (int i4 = 0; i4 < y0.length; ++i4) {
                                double[] dArray = fk[j4][m2];
                                int n3 = i4;
                                dArray[n3] = dArray[n3] - fk[j4][m2 - 2][i4];
                            }
                        }
                    }
                }
                if (mu >= 0) {
                    GraggBulirschStoerStepInterpolator gbsInterpolator = interpolator;
                    gbsInterpolator.computeCoefficients(mu, this.stepSize);
                    if (this.useInterpolationError) {
                        double interpError = gbsInterpolator.estimateError(scale2);
                        hInt = FastMath.abs(this.stepSize / FastMath.max(FastMath.pow(interpError, 1.0 / (double)(mu + 4)), 0.01));
                        if (interpError > 10.0) {
                            hNew = hInt;
                            reject = true;
                        }
                    }
                }
            }
            if (!reject) {
                int optimalIter;
                interpolator.storeTime(this.stepStart + this.stepSize);
                this.stepStart = this.acceptStep(interpolator, y1, yDot1, t2);
                interpolator.storeTime(this.stepStart);
                System.arraycopy(y1, 0, y2, 0, y0.length);
                System.arraycopy(yDot1, 0, yDot0, 0, y0.length);
                firstStepAlreadyComputed = true;
                if (k4 == 1) {
                    optimalIter = 2;
                    if (previousRejected) {
                        optimalIter = 1;
                    }
                } else if (k4 <= targetIter) {
                    optimalIter = k4;
                    if (this.costPerTimeUnit[k4 - 1] < this.orderControl1 * this.costPerTimeUnit[k4]) {
                        optimalIter = k4 - 1;
                    } else if (this.costPerTimeUnit[k4] < this.orderControl2 * this.costPerTimeUnit[k4 - 1]) {
                        optimalIter = FastMath.min(k4 + 1, this.sequence.length - 2);
                    }
                } else {
                    optimalIter = k4 - 1;
                    if (k4 > 2 && this.costPerTimeUnit[k4 - 2] < this.orderControl1 * this.costPerTimeUnit[k4 - 1]) {
                        optimalIter = k4 - 2;
                    }
                    if (this.costPerTimeUnit[k4] < this.orderControl2 * this.costPerTimeUnit[optimalIter]) {
                        optimalIter = FastMath.min(k4, this.sequence.length - 2);
                    }
                }
                if (previousRejected) {
                    targetIter = FastMath.min(optimalIter, k4);
                    hNew = FastMath.min(FastMath.abs(this.stepSize), this.optimalStep[targetIter]);
                } else {
                    hNew = optimalIter <= k4 ? this.optimalStep[optimalIter] : (k4 < targetIter && this.costPerTimeUnit[k4] < this.orderControl2 * this.costPerTimeUnit[k4 - 1] ? this.filterStep(this.optimalStep[k4] * (double)this.costPerStep[optimalIter + 1] / (double)this.costPerStep[k4], forward, false) : this.filterStep(this.optimalStep[k4] * (double)this.costPerStep[optimalIter] / (double)this.costPerStep[k4], forward, false));
                    targetIter = optimalIter;
                }
                newStep = true;
            }
            hNew = FastMath.min(hNew, hInt);
            if (!forward) {
                hNew = -hNew;
            }
            firstTime = false;
            if (reject) {
                this.isLastStep = false;
                previousRejected = true;
                continue;
            }
            previousRejected = false;
        } while (!this.isLastStep);
        equations.setTime(this.stepStart);
        equations.setCompleteState(y2);
        this.resetInternalState();
    }
}

