/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import java.util.Arrays;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.MathArrays;

public class StepFunction
implements UnivariateFunction {
    private final double[] abscissa;
    private final double[] ordinate;

    public StepFunction(double[] x2, double[] y2) throws NullArgumentException, NoDataException, DimensionMismatchException, NonMonotonicSequenceException {
        if (x2 == null || y2 == null) {
            throw new NullArgumentException();
        }
        if (x2.length == 0 || y2.length == 0) {
            throw new NoDataException();
        }
        if (y2.length != x2.length) {
            throw new DimensionMismatchException(y2.length, x2.length);
        }
        MathArrays.checkOrder(x2);
        this.abscissa = MathArrays.copyOf(x2);
        this.ordinate = MathArrays.copyOf(y2);
    }

    public double value(double x2) {
        int index = Arrays.binarySearch(this.abscissa, x2);
        double fx = 0.0;
        fx = index < -1 ? this.ordinate[-index - 2] : (index >= 0 ? this.ordinate[index] : this.ordinate[0]);
        return fx;
    }
}

