/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.security;

import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.security.CertificateUtil;
import com.itextpdf.text.pdf.security.CertificateVerifier;
import com.itextpdf.text.pdf.security.RootStoreVerifier;
import com.itextpdf.text.pdf.security.VerificationException;
import com.itextpdf.text.pdf.security.VerificationOK;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRLVerifier
extends RootStoreVerifier {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CRLVerifier.class);
    List<X509CRL> crls;

    public CRLVerifier(CertificateVerifier verifier, List<X509CRL> crls) {
        super(verifier);
        this.crls = crls;
    }

    @Override
    public List<VerificationOK> verify(X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException, IOException {
        ArrayList<VerificationOK> result2 = new ArrayList<VerificationOK>();
        int validCrlsFound = 0;
        if (this.crls != null) {
            for (X509CRL crl : this.crls) {
                if (!this.verify(crl, signCert, issuerCert, signDate)) continue;
                ++validCrlsFound;
            }
        }
        boolean online = false;
        if (this.onlineCheckingAllowed && validCrlsFound == 0 && this.verify(this.getCRL(signCert, issuerCert), signCert, issuerCert, signDate)) {
            ++validCrlsFound;
            online = true;
        }
        LOGGER.info("Valid CRLs found: " + validCrlsFound);
        if (validCrlsFound > 0) {
            result2.add(new VerificationOK(signCert, this.getClass(), "Valid CRLs found: " + validCrlsFound + (online ? " (online)" : "")));
        }
        if (this.verifier != null) {
            result2.addAll(this.verifier.verify(signCert, issuerCert, signDate));
        }
        return result2;
    }

    public boolean verify(X509CRL crl, X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException {
        if (crl == null || signDate == null) {
            return false;
        }
        if (crl.getIssuerX500Principal().equals(signCert.getIssuerX500Principal()) && signDate.after(crl.getThisUpdate()) && signDate.before(crl.getNextUpdate())) {
            if (this.isSignatureValid(crl, issuerCert) && crl.isRevoked(signCert)) {
                throw new VerificationException(signCert, "The certificate has been revoked.");
            }
            return true;
        }
        return false;
    }

    public X509CRL getCRL(X509Certificate signCert, X509Certificate issuerCert) {
        if (issuerCert == null) {
            issuerCert = signCert;
        }
        try {
            String crlurl = CertificateUtil.getCRLURL(signCert);
            if (crlurl == null) {
                return null;
            }
            LOGGER.info("Getting CRL from " + crlurl);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (X509CRL)cf.generateCRL(new URL(crlurl).openStream());
        }
        catch (IOException e2) {
            return null;
        }
        catch (GeneralSecurityException e3) {
            return null;
        }
    }

    public boolean isSignatureValid(X509CRL crl, X509Certificate crlIssuer) {
        if (crlIssuer != null) {
            try {
                crl.verify(crlIssuer.getPublicKey());
                return true;
            }
            catch (GeneralSecurityException e2) {
                LOGGER.warn("CRL not issued by the same authority as the certificate that is being checked");
            }
        }
        if (this.rootStore == null) {
            return false;
        }
        try {
            Enumeration<String> aliases = this.rootStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                try {
                    if (!this.rootStore.isCertificateEntry(alias)) continue;
                    X509Certificate anchor = (X509Certificate)this.rootStore.getCertificate(alias);
                    crl.verify(anchor.getPublicKey());
                    return true;
                }
                catch (GeneralSecurityException e3) {
                }
            }
        }
        catch (GeneralSecurityException e4) {
            return false;
        }
        return false;
    }
}

