/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser.clipper;

import com.itextpdf.text.pdf.parser.clipper.Clipper;
import com.itextpdf.text.pdf.parser.clipper.ClipperBase;
import com.itextpdf.text.pdf.parser.clipper.Edge;
import com.itextpdf.text.pdf.parser.clipper.Path;
import com.itextpdf.text.pdf.parser.clipper.Paths;
import com.itextpdf.text.pdf.parser.clipper.Point;
import com.itextpdf.text.pdf.parser.clipper.PolyNode;
import com.itextpdf.text.pdf.parser.clipper.PolyTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

public class DefaultClipper
extends ClipperBase {
    protected final List<Path.OutRec> polyOuts;
    private Clipper.ClipType clipType;
    private ClipperBase.Scanbeam scanbeam = null;
    private Path.Maxima maxima = null;
    private Edge activeEdges = null;
    private Edge sortedEdges = null;
    private final List<IntersectNode> intersectList = new ArrayList<IntersectNode>();
    private final Comparator<IntersectNode> intersectNodeComparer = new Comparator<IntersectNode>(){

        @Override
        public int compare(IntersectNode o1, IntersectNode o2) {
            long i2 = o2.getPt().getY() - o1.getPt().getY();
            if (i2 > 0L) {
                return 1;
            }
            if (i2 < 0L) {
                return -1;
            }
            return 0;
        }
    };
    private Clipper.PolyFillType clipFillType;
    private Clipper.PolyFillType subjFillType;
    private final List<Path.Join> joins;
    private final List<Path.Join> ghostJoins;
    private boolean usingPolyTree = false;
    public Clipper.ZFillCallback zFillFunction;
    private final boolean reverseSolution;
    private final boolean strictlySimple;
    private static final Logger LOGGER = Logger.getLogger(DefaultClipper.class.getName());

    private static void getHorzDirection(Edge HorzEdge, Clipper.Direction[] Dir, long[] Left2, long[] Right2) {
        if (HorzEdge.getBot().getX() < HorzEdge.getTop().getX()) {
            Left2[0] = HorzEdge.getBot().getX();
            Right2[0] = HorzEdge.getTop().getX();
            Dir[0] = Clipper.Direction.LEFT_TO_RIGHT;
        } else {
            Left2[0] = HorzEdge.getTop().getX();
            Right2[0] = HorzEdge.getBot().getX();
            Dir[0] = Clipper.Direction.RIGHT_TO_LEFT;
        }
    }

    private static boolean getOverlap(long a1, long a2, long b1, long b2, long[] Left2, long[] Right2) {
        if (a1 < a2) {
            if (b1 < b2) {
                Left2[0] = Math.max(a1, b1);
                Right2[0] = Math.min(a2, b2);
            } else {
                Left2[0] = Math.max(a1, b2);
                Right2[0] = Math.min(a2, b1);
            }
        } else if (b1 < b2) {
            Left2[0] = Math.max(a2, b1);
            Right2[0] = Math.min(a1, b2);
        } else {
            Left2[0] = Math.max(a2, b2);
            Right2[0] = Math.min(a1, b1);
        }
        return Left2[0] < Right2[0];
    }

    private static boolean isParam1RightOfParam2(Path.OutRec outRec1, Path.OutRec outRec2) {
        do {
            if ((outRec1 = outRec1.firstLeft) != outRec2) continue;
            return true;
        } while (outRec1 != null);
        return false;
    }

    private static int isPointInPolygon(Point.LongPoint pt, Path.OutPt op) {
        int result2 = 0;
        Path.OutPt startOp = op;
        long ptx = pt.getX();
        long pty = pt.getY();
        long poly0x = op.getPt().getX();
        long poly0y = op.getPt().getY();
        do {
            op = op.next;
            long poly1x = op.getPt().getX();
            long poly1y = op.getPt().getY();
            if (poly1y == pty && (poly1x == ptx || poly0y == pty && poly1x > ptx == poly0x < ptx)) {
                return -1;
            }
            if (poly0y < pty != poly1y < pty) {
                double d2;
                if (poly0x >= ptx) {
                    if (poly1x > ptx) {
                        result2 = 1 - result2;
                    } else {
                        d2 = (double)(poly0x - ptx) * (double)(poly1y - pty) - (double)(poly1x - ptx) * (double)(poly0y - pty);
                        if (d2 == 0.0) {
                            return -1;
                        }
                        if (d2 > 0.0 == poly1y > poly0y) {
                            result2 = 1 - result2;
                        }
                    }
                } else if (poly1x > ptx) {
                    d2 = (double)(poly0x - ptx) * (double)(poly1y - pty) - (double)(poly1x - ptx) * (double)(poly0y - pty);
                    if (d2 == 0.0) {
                        return -1;
                    }
                    if (d2 > 0.0 == poly1y > poly0y) {
                        result2 = 1 - result2;
                    }
                }
            }
            poly0x = poly1x;
            poly0y = poly1y;
        } while (startOp != op);
        return result2;
    }

    private static boolean joinHorz(Path.OutPt op1, Path.OutPt op1b, Path.OutPt op2, Path.OutPt op2b, Point.LongPoint Pt, boolean DiscardLeft) {
        Clipper.Direction Dir2;
        Clipper.Direction Dir1 = op1.getPt().getX() > op1b.getPt().getX() ? Clipper.Direction.RIGHT_TO_LEFT : Clipper.Direction.LEFT_TO_RIGHT;
        Clipper.Direction direction = Dir2 = op2.getPt().getX() > op2b.getPt().getX() ? Clipper.Direction.RIGHT_TO_LEFT : Clipper.Direction.LEFT_TO_RIGHT;
        if (Dir1 == Dir2) {
            return false;
        }
        if (Dir1 == Clipper.Direction.LEFT_TO_RIGHT) {
            while (op1.next.getPt().getX() <= Pt.getX() && op1.next.getPt().getX() >= op1.getPt().getX() && op1.next.getPt().getY() == Pt.getY()) {
                op1 = op1.next;
            }
            if (DiscardLeft && op1.getPt().getX() != Pt.getX()) {
                op1 = op1.next;
            }
            if (!(op1b = op1.duplicate(!DiscardLeft)).getPt().equals(Pt)) {
                op1 = op1b;
                op1.setPt(Pt);
                op1b = op1.duplicate(!DiscardLeft);
            }
        } else {
            while (op1.next.getPt().getX() >= Pt.getX() && op1.next.getPt().getX() <= op1.getPt().getX() && op1.next.getPt().getY() == Pt.getY()) {
                op1 = op1.next;
            }
            if (!DiscardLeft && op1.getPt().getX() != Pt.getX()) {
                op1 = op1.next;
            }
            if (!(op1b = op1.duplicate(DiscardLeft)).getPt().equals(Pt)) {
                op1 = op1b;
                op1.setPt(Pt);
                op1b = op1.duplicate(DiscardLeft);
            }
        }
        if (Dir2 == Clipper.Direction.LEFT_TO_RIGHT) {
            while (op2.next.getPt().getX() <= Pt.getX() && op2.next.getPt().getX() >= op2.getPt().getX() && op2.next.getPt().getY() == Pt.getY()) {
                op2 = op2.next;
            }
            if (DiscardLeft && op2.getPt().getX() != Pt.getX()) {
                op2 = op2.next;
            }
            if (!(op2b = op2.duplicate(!DiscardLeft)).getPt().equals(Pt)) {
                op2 = op2b;
                op2.setPt(Pt);
                op2b = op2.duplicate(!DiscardLeft);
            }
        } else {
            while (op2.next.getPt().getX() >= Pt.getX() && op2.next.getPt().getX() <= op2.getPt().getX() && op2.next.getPt().getY() == Pt.getY()) {
                op2 = op2.next;
            }
            if (!DiscardLeft && op2.getPt().getX() != Pt.getX()) {
                op2 = op2.next;
            }
            if (!(op2b = op2.duplicate(DiscardLeft)).getPt().equals(Pt)) {
                op2 = op2b;
                op2.setPt(Pt);
                op2b = op2.duplicate(DiscardLeft);
            }
        }
        if (Dir1 == Clipper.Direction.LEFT_TO_RIGHT == DiscardLeft) {
            op1.prev = op2;
            op2.next = op1;
            op1b.next = op2b;
            op2b.prev = op1b;
        } else {
            op1.next = op2;
            op2.prev = op1;
            op1b.prev = op2b;
            op2b.next = op1b;
        }
        return true;
    }

    private boolean joinPoints(Path.Join j2, Path.OutRec outRec1, Path.OutRec outRec2) {
        boolean Reverse2;
        boolean Reverse1;
        boolean isHorizontal;
        Path.OutPt op1 = j2.outPt1;
        Path.OutPt op2 = j2.outPt2;
        boolean bl = isHorizontal = j2.outPt1.getPt().getY() == j2.getOffPt().getY();
        if (isHorizontal && j2.getOffPt().equals(j2.outPt1.getPt()) && j2.getOffPt().equals(j2.outPt2.getPt())) {
            boolean reverse2;
            if (outRec1 != outRec2) {
                return false;
            }
            Path.OutPt op1b = j2.outPt1.next;
            while (op1b != op1 && op1b.getPt().equals(j2.getOffPt())) {
                op1b = op1b.next;
            }
            boolean reverse1 = op1b.getPt().getY() > j2.getOffPt().getY();
            Path.OutPt op2b = j2.outPt2.next;
            while (op2b != op2 && op2b.getPt().equals(j2.getOffPt())) {
                op2b = op2b.next;
            }
            boolean bl2 = reverse2 = op2b.getPt().getY() > j2.getOffPt().getY();
            if (reverse1 == reverse2) {
                return false;
            }
            if (reverse1) {
                op1b = op1.duplicate(false);
                op2b = op2.duplicate(true);
                op1.prev = op2;
                op2.next = op1;
                op1b.next = op2b;
                op2b.prev = op1b;
                j2.outPt1 = op1;
                j2.outPt2 = op1b;
                return true;
            }
            op1b = op1.duplicate(true);
            op2b = op2.duplicate(false);
            op1.next = op2;
            op2.prev = op1;
            op1b.prev = op2b;
            op2b.next = op1b;
            j2.outPt1 = op1;
            j2.outPt2 = op1b;
            return true;
        }
        if (isHorizontal) {
            boolean DiscardLeftSide;
            Point.LongPoint Pt;
            Path.OutPt op1b = op1;
            while (op1.prev.getPt().getY() == op1.getPt().getY() && op1.prev != op1b && op1.prev != op2) {
                op1 = op1.prev;
            }
            while (op1b.next.getPt().getY() == op1b.getPt().getY() && op1b.next != op1 && op1b.next != op2) {
                op1b = op1b.next;
            }
            if (op1b.next == op1 || op1b.next == op2) {
                return false;
            }
            Path.OutPt op2b = op2;
            while (op2.prev.getPt().getY() == op2.getPt().getY() && op2.prev != op2b && op2.prev != op1b) {
                op2 = op2.prev;
            }
            while (op2b.next.getPt().getY() == op2b.getPt().getY() && op2b.next != op2 && op2b.next != op1) {
                op2b = op2b.next;
            }
            if (op2b.next == op2 || op2b.next == op1) {
                return false;
            }
            long[] LeftV = new long[1];
            long[] RightV = new long[1];
            if (!DefaultClipper.getOverlap(op1.getPt().getX(), op1b.getPt().getX(), op2.getPt().getX(), op2b.getPt().getX(), LeftV, RightV)) {
                return false;
            }
            long Left2 = LeftV[0];
            long Right2 = RightV[0];
            if (op1.getPt().getX() >= Left2 && op1.getPt().getX() <= Right2) {
                Pt = new Point.LongPoint(op1.getPt());
                DiscardLeftSide = op1.getPt().getX() > op1b.getPt().getX();
            } else if (op2.getPt().getX() >= Left2 && op2.getPt().getX() <= Right2) {
                Pt = new Point.LongPoint(op2.getPt());
                DiscardLeftSide = op2.getPt().getX() > op2b.getPt().getX();
            } else if (op1b.getPt().getX() >= Left2 && op1b.getPt().getX() <= Right2) {
                Pt = new Point.LongPoint(op1b.getPt());
                DiscardLeftSide = op1b.getPt().getX() > op1.getPt().getX();
            } else {
                Pt = new Point.LongPoint(op2b.getPt());
                DiscardLeftSide = op2b.getPt().getX() > op2.getPt().getX();
            }
            j2.outPt1 = op1;
            j2.outPt2 = op2;
            return DefaultClipper.joinHorz(op1, op1b, op2, op2b, Pt, DiscardLeftSide);
        }
        Path.OutPt op1b = op1.next;
        while (op1b.getPt().equals(op1.getPt()) && op1b != op1) {
            op1b = op1b.next;
        }
        boolean bl3 = Reverse1 = op1b.getPt().getY() > op1.getPt().getY() || !Point.slopesEqual(op1.getPt(), op1b.getPt(), j2.getOffPt(), this.useFullRange);
        if (Reverse1) {
            op1b = op1.prev;
            while (op1b.getPt().equals(op1.getPt()) && op1b != op1) {
                op1b = op1b.prev;
            }
            if (op1b.getPt().getY() > op1.getPt().getY() || !Point.slopesEqual(op1.getPt(), op1b.getPt(), j2.getOffPt(), this.useFullRange)) {
                return false;
            }
        }
        Path.OutPt op2b = op2.next;
        while (op2b.getPt().equals(op2.getPt()) && op2b != op2) {
            op2b = op2b.next;
        }
        boolean bl4 = Reverse2 = op2b.getPt().getY() > op2.getPt().getY() || !Point.slopesEqual(op2.getPt(), op2b.getPt(), j2.getOffPt(), this.useFullRange);
        if (Reverse2) {
            op2b = op2.prev;
            while (op2b.getPt().equals(op2.getPt()) && op2b != op2) {
                op2b = op2b.prev;
            }
            if (op2b.getPt().getY() > op2.getPt().getY() || !Point.slopesEqual(op2.getPt(), op2b.getPt(), j2.getOffPt(), this.useFullRange)) {
                return false;
            }
        }
        if (op1b == op1 || op2b == op2 || op1b == op2b || outRec1 == outRec2 && Reverse1 == Reverse2) {
            return false;
        }
        if (Reverse1) {
            op1b = op1.duplicate(false);
            op2b = op2.duplicate(true);
            op1.prev = op2;
            op2.next = op1;
            op1b.next = op2b;
            op2b.prev = op1b;
            j2.outPt1 = op1;
            j2.outPt2 = op1b;
            return true;
        }
        op1b = op1.duplicate(true);
        op2b = op2.duplicate(false);
        op1.next = op2;
        op2.prev = op1;
        op1b.prev = op2b;
        op2b.next = op1b;
        j2.outPt1 = op1;
        j2.outPt2 = op1b;
        return true;
    }

    private static Paths minkowski(Path pattern, Path path2, boolean IsSum, boolean IsClosed) {
        Path p2;
        int i2;
        int delta = IsClosed ? 1 : 0;
        int polyCnt = pattern.size();
        int pathCnt = path2.size();
        Paths result2 = new Paths(pathCnt);
        if (IsSum) {
            for (i2 = 0; i2 < pathCnt; ++i2) {
                p2 = new Path(polyCnt);
                for (Point.LongPoint ip : pattern) {
                    p2.add(new Point.LongPoint(((Point.LongPoint)path2.get(i2)).getX() + ip.getX(), ((Point.LongPoint)path2.get(i2)).getY() + ip.getY(), 0L));
                }
                result2.add(p2);
            }
        } else {
            for (i2 = 0; i2 < pathCnt; ++i2) {
                p2 = new Path(polyCnt);
                for (Point.LongPoint ip : pattern) {
                    p2.add(new Point.LongPoint(((Point.LongPoint)path2.get(i2)).getX() - ip.getX(), ((Point.LongPoint)path2.get(i2)).getY() - ip.getY(), 0L));
                }
                result2.add(p2);
            }
        }
        Paths quads = new Paths((pathCnt + delta) * (polyCnt + 1));
        for (int i3 = 0; i3 < pathCnt - 1 + delta; ++i3) {
            for (int j2 = 0; j2 < polyCnt; ++j2) {
                Path quad = new Path(4);
                quad.add(((Path)result2.get(i3 % pathCnt)).get(j2 % polyCnt));
                quad.add(((Path)result2.get((i3 + 1) % pathCnt)).get(j2 % polyCnt));
                quad.add(((Path)result2.get((i3 + 1) % pathCnt)).get((j2 + 1) % polyCnt));
                quad.add(((Path)result2.get(i3 % pathCnt)).get((j2 + 1) % polyCnt));
                if (!quad.orientation()) {
                    Collections.reverse(quad);
                }
                quads.add(quad);
            }
        }
        return quads;
    }

    public static Paths minkowskiDiff(Path poly1, Path poly2) {
        Paths paths = DefaultClipper.minkowski(poly1, poly2, false, true);
        DefaultClipper c2 = new DefaultClipper();
        c2.addPaths(paths, Clipper.PolyType.SUBJECT, true);
        c2.execute(Clipper.ClipType.UNION, paths, Clipper.PolyFillType.NON_ZERO, Clipper.PolyFillType.NON_ZERO);
        return paths;
    }

    public static Paths minkowskiSum(Path pattern, Path path2, boolean pathIsClosed) {
        Paths paths = DefaultClipper.minkowski(pattern, path2, true, pathIsClosed);
        DefaultClipper c2 = new DefaultClipper();
        c2.addPaths(paths, Clipper.PolyType.SUBJECT, true);
        c2.execute(Clipper.ClipType.UNION, paths, Clipper.PolyFillType.NON_ZERO, Clipper.PolyFillType.NON_ZERO);
        return paths;
    }

    public static Paths minkowskiSum(Path pattern, Paths paths, boolean pathIsClosed) {
        Paths solution = new Paths();
        DefaultClipper c2 = new DefaultClipper();
        for (int i2 = 0; i2 < paths.size(); ++i2) {
            Paths tmp = DefaultClipper.minkowski(pattern, (Path)paths.get(i2), true, pathIsClosed);
            c2.addPaths(tmp, Clipper.PolyType.SUBJECT, true);
            if (!pathIsClosed) continue;
            Path path2 = ((Path)paths.get(i2)).TranslatePath((Point.LongPoint)pattern.get(0));
            c2.addPath(path2, Clipper.PolyType.CLIP, true);
        }
        c2.execute(Clipper.ClipType.UNION, solution, Clipper.PolyFillType.NON_ZERO, Clipper.PolyFillType.NON_ZERO);
        return solution;
    }

    private static boolean poly2ContainsPoly1(Path.OutPt outPt1, Path.OutPt outPt2) {
        Path.OutPt op = outPt1;
        do {
            int res;
            if ((res = DefaultClipper.isPointInPolygon(op.getPt(), outPt2)) < 0) continue;
            return res > 0;
        } while ((op = op.next) != outPt1);
        return true;
    }

    public static Paths simplifyPolygon(Path poly) {
        return DefaultClipper.simplifyPolygon(poly, Clipper.PolyFillType.EVEN_ODD);
    }

    public static Paths simplifyPolygon(Path poly, Clipper.PolyFillType fillType) {
        Paths result2 = new Paths();
        DefaultClipper c2 = new DefaultClipper(2);
        c2.addPath(poly, Clipper.PolyType.SUBJECT, true);
        c2.execute(Clipper.ClipType.UNION, result2, fillType, fillType);
        return result2;
    }

    public static Paths simplifyPolygons(Paths polys) {
        return DefaultClipper.simplifyPolygons(polys, Clipper.PolyFillType.EVEN_ODD);
    }

    public static Paths simplifyPolygons(Paths polys, Clipper.PolyFillType fillType) {
        Paths result2 = new Paths();
        DefaultClipper c2 = new DefaultClipper(2);
        c2.addPaths(polys, Clipper.PolyType.SUBJECT, true);
        c2.execute(Clipper.ClipType.UNION, result2, fillType, fillType);
        return result2;
    }

    public DefaultClipper() {
        this(0);
    }

    public DefaultClipper(int InitOptions) {
        super((4 & InitOptions) != 0);
        this.polyOuts = new ArrayList<Path.OutRec>();
        this.joins = new ArrayList<Path.Join>();
        this.ghostJoins = new ArrayList<Path.Join>();
        this.reverseSolution = (1 & InitOptions) != 0;
        this.strictlySimple = (2 & InitOptions) != 0;
        this.zFillFunction = null;
    }

    private void insertScanbeam(long Y) {
        if (this.scanbeam == null) {
            this.scanbeam = new ClipperBase.Scanbeam();
            this.scanbeam.next = null;
            this.scanbeam.y = Y;
        } else if (Y > this.scanbeam.y) {
            ClipperBase.Scanbeam newSb = new ClipperBase.Scanbeam();
            newSb.y = Y;
            newSb.next = this.scanbeam;
            this.scanbeam = newSb;
        } else {
            ClipperBase.Scanbeam sb2 = this.scanbeam;
            while (sb2.next != null && Y <= sb2.next.y) {
                sb2 = sb2.next;
            }
            if (Y == sb2.y) {
                return;
            }
            ClipperBase.Scanbeam newSb = new ClipperBase.Scanbeam();
            newSb.y = Y;
            newSb.next = sb2.next;
            sb2.next = newSb;
        }
    }

    private void InsertMaxima(long X) {
        Path.Maxima newMax = new Path.Maxima();
        newMax.X = X;
        if (this.maxima == null) {
            this.maxima = newMax;
            this.maxima.Next = null;
            this.maxima.Prev = null;
        } else if (X < this.maxima.X) {
            newMax.Next = this.maxima;
            newMax.Prev = null;
            this.maxima = newMax;
        } else {
            Path.Maxima m2 = this.maxima;
            while (m2.Next != null && X >= m2.Next.X) {
                m2 = m2.Next;
            }
            if (X == m2.X) {
                return;
            }
            newMax.Next = m2.Next;
            newMax.Prev = m2;
            if (m2.Next != null) {
                m2.Next.Prev = newMax;
            }
            m2.Next = newMax;
        }
    }

    private void addEdgeToSEL(Edge edge) {
        LOGGER.entering(DefaultClipper.class.getName(), "addEdgeToSEL");
        if (this.sortedEdges == null) {
            this.sortedEdges = edge;
            edge.prevInSEL = null;
            edge.nextInSEL = null;
        } else {
            edge.nextInSEL = this.sortedEdges;
            edge.prevInSEL = null;
            this.sortedEdges.prevInSEL = edge;
            this.sortedEdges = edge;
        }
    }

    private void addGhostJoin(Path.OutPt Op, Point.LongPoint OffPt) {
        Path.Join j2 = new Path.Join();
        j2.outPt1 = Op;
        j2.setOffPt(OffPt);
        this.ghostJoins.add(j2);
    }

    private void addJoin(Path.OutPt Op1, Path.OutPt Op2, Point.LongPoint OffPt) {
        LOGGER.entering(DefaultClipper.class.getName(), "addJoin");
        Path.Join j2 = new Path.Join();
        j2.outPt1 = Op1;
        j2.outPt2 = Op2;
        j2.setOffPt(OffPt);
        this.joins.add(j2);
    }

    private void addLocalMaxPoly(Edge e1, Edge e2, Point.LongPoint pt) {
        this.addOutPt(e1, pt);
        if (e2.windDelta == 0) {
            this.addOutPt(e2, pt);
        }
        if (e1.outIdx == e2.outIdx) {
            e1.outIdx = -1;
            e2.outIdx = -1;
        } else if (e1.outIdx < e2.outIdx) {
            this.appendPolygon(e1, e2);
        } else {
            this.appendPolygon(e2, e1);
        }
    }

    private Path.OutPt addLocalMinPoly(Edge e1, Edge e2, Point.LongPoint pt) {
        Edge prevE;
        Edge e3;
        Path.OutPt result2;
        LOGGER.entering(DefaultClipper.class.getName(), "addLocalMinPoly");
        if (e2.isHorizontal() || e1.deltaX > e2.deltaX) {
            result2 = this.addOutPt(e1, pt);
            e2.outIdx = e1.outIdx;
            e1.side = Edge.Side.LEFT;
            e2.side = Edge.Side.RIGHT;
            e3 = e1;
            prevE = e3.prevInAEL == e2 ? e2.prevInAEL : e3.prevInAEL;
        } else {
            result2 = this.addOutPt(e2, pt);
            e1.outIdx = e2.outIdx;
            e1.side = Edge.Side.RIGHT;
            e2.side = Edge.Side.LEFT;
            e3 = e2;
            prevE = e3.prevInAEL == e1 ? e1.prevInAEL : e3.prevInAEL;
        }
        if (prevE != null && prevE.outIdx >= 0 && Edge.topX(prevE, pt.getY()) == Edge.topX(e3, pt.getY()) && Edge.slopesEqual(e3, prevE, this.useFullRange) && e3.windDelta != 0 && prevE.windDelta != 0) {
            Path.OutPt outPt = this.addOutPt(prevE, pt);
            this.addJoin(result2, outPt, e3.getTop());
        }
        return result2;
    }

    private Path.OutPt addOutPt(Edge e2, Point.LongPoint pt) {
        LOGGER.entering(DefaultClipper.class.getName(), "addOutPt");
        if (e2.outIdx < 0) {
            Path.OutPt newOp;
            Path.OutRec outRec = this.createOutRec();
            outRec.isOpen = e2.windDelta == 0;
            outRec.pts = newOp = new Path.OutPt();
            newOp.idx = outRec.Idx;
            newOp.pt = pt;
            newOp.next = newOp;
            newOp.prev = newOp;
            if (!outRec.isOpen) {
                this.setHoleState(e2, outRec);
            }
            e2.outIdx = outRec.Idx;
            return newOp;
        }
        Path.OutRec outRec = this.polyOuts.get(e2.outIdx);
        Path.OutPt op = outRec.getPoints();
        boolean ToFront = e2.side == Edge.Side.LEFT;
        LOGGER.finest("op=" + op.getPointCount());
        LOGGER.finest(ToFront + " " + pt + " " + op.getPt());
        if (ToFront && pt.equals(op.getPt())) {
            return op;
        }
        if (!ToFront && pt.equals(op.prev.getPt())) {
            return op.prev;
        }
        Path.OutPt newOp = new Path.OutPt();
        newOp.idx = outRec.Idx;
        newOp.setPt(new Point.LongPoint(pt));
        newOp.next = op;
        newOp.prev = op.prev;
        newOp.prev.next = newOp;
        op.prev = newOp;
        if (ToFront) {
            outRec.setPoints(newOp);
        }
        return newOp;
    }

    private Path.OutPt GetLastOutPt(Edge e2) {
        Path.OutRec outRec = this.polyOuts.get(e2.outIdx);
        if (e2.side == Edge.Side.LEFT) {
            return outRec.pts;
        }
        return outRec.pts.prev;
    }

    private void appendPolygon(Edge e1, Edge e2) {
        Edge.Side side;
        LOGGER.entering(DefaultClipper.class.getName(), "appendPolygon");
        Path.OutRec outRec1 = this.polyOuts.get(e1.outIdx);
        Path.OutRec outRec2 = this.polyOuts.get(e2.outIdx);
        LOGGER.finest("" + e1.outIdx);
        LOGGER.finest("" + e2.outIdx);
        Path.OutRec holeStateRec = DefaultClipper.isParam1RightOfParam2(outRec1, outRec2) ? outRec2 : (DefaultClipper.isParam1RightOfParam2(outRec2, outRec1) ? outRec1 : Path.OutPt.getLowerMostRec(outRec1, outRec2));
        Path.OutPt p1_lft = outRec1.getPoints();
        Path.OutPt p1_rt = p1_lft.prev;
        Path.OutPt p2_lft = outRec2.getPoints();
        Path.OutPt p2_rt = p2_lft.prev;
        LOGGER.finest("p1_lft.getPointCount() = " + p1_lft.getPointCount());
        LOGGER.finest("p1_rt.getPointCount() = " + p1_rt.getPointCount());
        LOGGER.finest("p2_lft.getPointCount() = " + p2_lft.getPointCount());
        LOGGER.finest("p2_rt.getPointCount() = " + p2_rt.getPointCount());
        if (e1.side == Edge.Side.LEFT) {
            if (e2.side == Edge.Side.LEFT) {
                p2_lft.reversePolyPtLinks();
                p2_lft.next = p1_lft;
                p1_lft.prev = p2_lft;
                p1_rt.next = p2_rt;
                p2_rt.prev = p1_rt;
                outRec1.setPoints(p2_rt);
            } else {
                p2_rt.next = p1_lft;
                p1_lft.prev = p2_rt;
                p2_lft.prev = p1_rt;
                p1_rt.next = p2_lft;
                outRec1.setPoints(p2_lft);
            }
            side = Edge.Side.LEFT;
        } else {
            if (e2.side == Edge.Side.RIGHT) {
                p2_lft.reversePolyPtLinks();
                p1_rt.next = p2_rt;
                p2_rt.prev = p1_rt;
                p2_lft.next = p1_lft;
                p1_lft.prev = p2_lft;
            } else {
                p1_rt.next = p2_lft;
                p2_lft.prev = p1_rt;
                p1_lft.prev = p2_rt;
                p2_rt.next = p1_lft;
            }
            side = Edge.Side.RIGHT;
        }
        outRec1.bottomPt = null;
        if (holeStateRec.equals(outRec2)) {
            if (outRec2.firstLeft != outRec1) {
                outRec1.firstLeft = outRec2.firstLeft;
            }
            outRec1.isHole = outRec2.isHole;
        }
        outRec2.setPoints(null);
        outRec2.bottomPt = null;
        outRec2.firstLeft = outRec1;
        int OKIdx = e1.outIdx;
        int ObsoleteIdx = e2.outIdx;
        e1.outIdx = -1;
        e2.outIdx = -1;
        Edge e3 = this.activeEdges;
        while (e3 != null) {
            if (e3.outIdx == ObsoleteIdx) {
                e3.outIdx = OKIdx;
                e3.side = side;
                break;
            }
            e3 = e3.nextInAEL;
        }
        outRec2.Idx = outRec1.Idx;
    }

    private void buildIntersectList(long topY) {
        Edge e2;
        if (this.activeEdges == null) {
            return;
        }
        this.sortedEdges = e2 = this.activeEdges;
        while (e2 != null) {
            e2.prevInSEL = e2.prevInAEL;
            e2.nextInSEL = e2.nextInAEL;
            e2.getCurrent().setX(Edge.topX(e2, topY));
            e2 = e2.nextInAEL;
        }
        boolean isModified = true;
        while (isModified && this.sortedEdges != null) {
            isModified = false;
            e2 = this.sortedEdges;
            while (e2.nextInSEL != null) {
                Edge eNext = e2.nextInSEL;
                Point.LongPoint[] pt = new Point.LongPoint[1];
                if (e2.getCurrent().getX() > eNext.getCurrent().getX()) {
                    this.intersectPoint(e2, eNext, pt);
                    IntersectNode newNode = new IntersectNode();
                    newNode.edge1 = e2;
                    newNode.Edge2 = eNext;
                    newNode.setPt(pt[0]);
                    this.intersectList.add(newNode);
                    this.swapPositionsInSEL(e2, eNext);
                    isModified = true;
                    continue;
                }
                e2 = eNext;
            }
            if (e2.prevInSEL == null) break;
            e2.prevInSEL.nextInSEL = null;
        }
        this.sortedEdges = null;
    }

    private void buildResult(Paths polyg) {
        polyg.clear();
        for (int i2 = 0; i2 < this.polyOuts.size(); ++i2) {
            Path.OutRec outRec = this.polyOuts.get(i2);
            if (outRec.getPoints() == null) continue;
            Path.OutPt p2 = outRec.getPoints().prev;
            int cnt = p2.getPointCount();
            LOGGER.finest("cnt = " + cnt);
            if (cnt < 2) continue;
            Path pg = new Path(cnt);
            for (int j2 = 0; j2 < cnt; ++j2) {
                pg.add(p2.getPt());
                p2 = p2.prev;
            }
            polyg.add(pg);
        }
    }

    private void buildResult2(PolyTree polytree) {
        Path.OutRec outRec;
        int i2;
        polytree.Clear();
        for (i2 = 0; i2 < this.polyOuts.size(); ++i2) {
            int cnt;
            outRec = this.polyOuts.get(i2);
            int n2 = cnt = outRec.getPoints() != null ? outRec.getPoints().getPointCount() : 0;
            if (outRec.isOpen && cnt < 2 || !outRec.isOpen && cnt < 3) continue;
            outRec.fixHoleLinkage();
            PolyNode pn = new PolyNode();
            polytree.getAllPolys().add(pn);
            outRec.polyNode = pn;
            Path.OutPt op = outRec.getPoints().prev;
            for (int j2 = 0; j2 < cnt; ++j2) {
                pn.getPolygon().add(op.getPt());
                op = op.prev;
            }
        }
        for (i2 = 0; i2 < this.polyOuts.size(); ++i2) {
            outRec = this.polyOuts.get(i2);
            if (outRec.polyNode == null) continue;
            if (outRec.isOpen) {
                outRec.polyNode.setOpen(true);
                polytree.addChild(outRec.polyNode);
                continue;
            }
            if (outRec.firstLeft != null && outRec.firstLeft.polyNode != null) {
                outRec.firstLeft.polyNode.addChild(outRec.polyNode);
                continue;
            }
            polytree.addChild(outRec.polyNode);
        }
    }

    private void copyAELToSEL() {
        Edge e2;
        this.sortedEdges = e2 = this.activeEdges;
        while (e2 != null) {
            e2.prevInSEL = e2.prevInAEL;
            e2.nextInSEL = e2.nextInAEL;
            e2 = e2.nextInAEL;
        }
    }

    private Path.OutRec createOutRec() {
        Path.OutRec result2 = new Path.OutRec();
        result2.Idx = -1;
        result2.isHole = false;
        result2.isOpen = false;
        result2.firstLeft = null;
        result2.setPoints(null);
        result2.bottomPt = null;
        result2.polyNode = null;
        this.polyOuts.add(result2);
        result2.Idx = this.polyOuts.size() - 1;
        return result2;
    }

    private void deleteFromAEL(Edge e2) {
        LOGGER.entering(DefaultClipper.class.getName(), "deleteFromAEL");
        Edge AelPrev = e2.prevInAEL;
        Edge AelNext = e2.nextInAEL;
        if (AelPrev == null && AelNext == null && e2 != this.activeEdges) {
            return;
        }
        if (AelPrev != null) {
            AelPrev.nextInAEL = AelNext;
        } else {
            this.activeEdges = AelNext;
        }
        if (AelNext != null) {
            AelNext.prevInAEL = AelPrev;
        }
        e2.nextInAEL = null;
        e2.prevInAEL = null;
        LOGGER.exiting(DefaultClipper.class.getName(), "deleteFromAEL");
    }

    private void deleteFromSEL(Edge e2) {
        LOGGER.entering(DefaultClipper.class.getName(), "deleteFromSEL");
        Edge SelPrev = e2.prevInSEL;
        Edge SelNext = e2.nextInSEL;
        if (SelPrev == null && SelNext == null && !e2.equals(this.sortedEdges)) {
            return;
        }
        if (SelPrev != null) {
            SelPrev.nextInSEL = SelNext;
        } else {
            this.sortedEdges = SelNext;
        }
        if (SelNext != null) {
            SelNext.prevInSEL = SelPrev;
        }
        e2.nextInSEL = null;
        e2.prevInSEL = null;
    }

    private boolean doHorzSegmentsOverlap(long seg1a, long seg1b, long seg2a, long seg2b) {
        long tmp;
        if (seg1a > seg1b) {
            tmp = seg1a;
            seg1a = seg1b;
            seg1b = tmp;
        }
        if (seg2a > seg2b) {
            tmp = seg2a;
            seg2a = seg2b;
            seg2b = tmp;
        }
        return seg1a < seg2b && seg2a < seg1b;
    }

    private void doMaxima(Edge e2) {
        Edge eMaxPair = e2.getMaximaPair();
        if (eMaxPair == null) {
            if (e2.outIdx >= 0) {
                this.addOutPt(e2, e2.getTop());
            }
            this.deleteFromAEL(e2);
            return;
        }
        Edge eNext = e2.nextInAEL;
        while (eNext != null && eNext != eMaxPair) {
            Point.LongPoint tmp = new Point.LongPoint(e2.getTop());
            this.intersectEdges(e2, eNext, tmp);
            e2.setTop(tmp);
            this.swapPositionsInAEL(e2, eNext);
            eNext = e2.nextInAEL;
        }
        if (e2.outIdx == -1 && eMaxPair.outIdx == -1) {
            this.deleteFromAEL(e2);
            this.deleteFromAEL(eMaxPair);
        } else if (e2.outIdx >= 0 && eMaxPair.outIdx >= 0) {
            if (e2.outIdx >= 0) {
                this.addLocalMaxPoly(e2, eMaxPair, e2.getTop());
            }
            this.deleteFromAEL(e2);
            this.deleteFromAEL(eMaxPair);
        } else if (e2.windDelta == 0) {
            if (e2.outIdx >= 0) {
                this.addOutPt(e2, e2.getTop());
                e2.outIdx = -1;
            }
            this.deleteFromAEL(e2);
            if (eMaxPair.outIdx >= 0) {
                this.addOutPt(eMaxPair, e2.getTop());
                eMaxPair.outIdx = -1;
            }
            this.deleteFromAEL(eMaxPair);
        } else {
            throw new IllegalStateException("DoMaxima error");
        }
    }

    private void doSimplePolygons() {
        int i2 = 0;
        while (i2 < this.polyOuts.size()) {
            Path.OutRec outrec;
            Path.OutPt op;
            if ((op = (outrec = this.polyOuts.get(i2++)).getPoints()) == null || outrec.isOpen) continue;
            do {
                Path.OutPt op2 = op.next;
                while (op2 != outrec.getPoints()) {
                    if (op.getPt().equals(op2.getPt()) && !op2.next.equals(op) && !op2.prev.equals(op)) {
                        Path.OutPt op4;
                        Path.OutPt op3 = op.prev;
                        op.prev = op4 = op2.prev;
                        op4.next = op;
                        op2.prev = op3;
                        op3.next = op2;
                        outrec.setPoints(op);
                        Path.OutRec outrec2 = this.createOutRec();
                        outrec2.setPoints(op2);
                        this.updateOutPtIdxs(outrec2);
                        if (DefaultClipper.poly2ContainsPoly1(outrec2.getPoints(), outrec.getPoints())) {
                            outrec2.isHole = !outrec.isHole;
                            outrec2.firstLeft = outrec;
                            if (this.usingPolyTree) {
                                this.fixupFirstLefts2(outrec2, outrec);
                            }
                        } else if (DefaultClipper.poly2ContainsPoly1(outrec.getPoints(), outrec2.getPoints())) {
                            outrec2.isHole = outrec.isHole;
                            outrec.isHole = !outrec2.isHole;
                            outrec2.firstLeft = outrec.firstLeft;
                            outrec.firstLeft = outrec2;
                            if (this.usingPolyTree) {
                                this.fixupFirstLefts2(outrec, outrec2);
                            }
                        } else {
                            outrec2.isHole = outrec.isHole;
                            outrec2.firstLeft = outrec.firstLeft;
                            if (this.usingPolyTree) {
                                this.fixupFirstLefts1(outrec, outrec2);
                            }
                        }
                        op2 = op;
                    }
                    op2 = op2.next;
                }
            } while ((op = op.next) != outrec.getPoints());
        }
    }

    private boolean EdgesAdjacent(IntersectNode inode) {
        return inode.edge1.nextInSEL == inode.Edge2 || inode.edge1.prevInSEL == inode.Edge2;
    }

    public boolean execute(Clipper.ClipType clipType, Paths solution, Clipper.PolyFillType FillType) {
        return this.execute(clipType, solution, FillType, FillType);
    }

    public boolean execute(Clipper.ClipType clipType, PolyTree polytree) {
        return this.execute(clipType, polytree, Clipper.PolyFillType.EVEN_ODD);
    }

    public boolean execute(Clipper.ClipType clipType, PolyTree polytree, Clipper.PolyFillType FillType) {
        return this.execute(clipType, polytree, FillType, FillType);
    }

    public boolean execute(Clipper.ClipType clipType, Paths solution) {
        return this.execute(clipType, solution, Clipper.PolyFillType.EVEN_ODD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Clipper.ClipType clipType, Paths solution, Clipper.PolyFillType subjFillType, Clipper.PolyFillType clipFillType) {
        DefaultClipper defaultClipper = this;
        synchronized (defaultClipper) {
            boolean bl;
            if (this.hasOpenPaths) {
                throw new IllegalStateException("Error: PolyTree struct is needed for open path clipping.");
            }
            solution.clear();
            this.subjFillType = subjFillType;
            this.clipFillType = clipFillType;
            this.clipType = clipType;
            this.usingPolyTree = false;
            try {
                boolean succeeded = this.executeInternal();
                if (succeeded) {
                    this.buildResult(solution);
                }
                bl = succeeded;
                this.polyOuts.clear();
            }
            catch (Throwable throwable) {
                this.polyOuts.clear();
                throw throwable;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Clipper.ClipType clipType, PolyTree polytree, Clipper.PolyFillType subjFillType, Clipper.PolyFillType clipFillType) {
        DefaultClipper defaultClipper = this;
        synchronized (defaultClipper) {
            boolean succeeded;
            this.subjFillType = subjFillType;
            this.clipFillType = clipFillType;
            this.clipType = clipType;
            this.usingPolyTree = true;
            try {
                succeeded = this.executeInternal();
                if (succeeded) {
                    this.buildResult2(polytree);
                }
            }
            finally {
                this.polyOuts.clear();
            }
            return succeeded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeInternal() {
        try {
            Path.OutRec outRec;
            int i2;
            this.reset();
            if (this.currentLM == null) {
                boolean bl = false;
                return bl;
            }
            long botY = this.popScanbeam();
            do {
                this.insertLocalMinimaIntoAEL(botY);
                this.processHorizontals();
                this.ghostJoins.clear();
                if (this.scanbeam == null) break;
                long topY = this.popScanbeam();
                if (!this.processIntersections(topY)) {
                    boolean bl = false;
                    return bl;
                }
                this.processEdgesAtTopOfScanbeam(topY);
                botY = topY;
            } while (this.scanbeam != null || this.currentLM != null);
            for (i2 = 0; i2 < this.polyOuts.size(); ++i2) {
                outRec = this.polyOuts.get(i2);
                if (outRec.pts == null || outRec.isOpen || (outRec.isHole ^ this.reverseSolution) != outRec.area() > 0.0) continue;
                outRec.getPoints().reversePolyPtLinks();
            }
            this.joinCommonEdges();
            for (i2 = 0; i2 < this.polyOuts.size(); ++i2) {
                outRec = this.polyOuts.get(i2);
                if (outRec.getPoints() == null) continue;
                if (outRec.isOpen) {
                    this.fixupOutPolyline(outRec);
                    continue;
                }
                this.fixupOutPolygon(outRec);
            }
            if (this.strictlySimple) {
                this.doSimplePolygons();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.joins.clear();
            this.ghostJoins.clear();
        }
    }

    private void fixupFirstLefts1(Path.OutRec OldOutRec, Path.OutRec NewOutRec) {
        for (int i2 = 0; i2 < this.polyOuts.size(); ++i2) {
            Path.OutRec firstLeft;
            Path.OutRec outRec = this.polyOuts.get(i2);
            if (outRec.getPoints() == null || outRec.firstLeft == null || !(firstLeft = DefaultClipper.parseFirstLeft(outRec.firstLeft)).equals(OldOutRec) || !DefaultClipper.poly2ContainsPoly1(outRec.getPoints(), NewOutRec.getPoints())) continue;
            outRec.firstLeft = NewOutRec;
        }
    }

    private void fixupFirstLefts2(Path.OutRec OldOutRec, Path.OutRec NewOutRec) {
        for (Path.OutRec outRec : this.polyOuts) {
            if (outRec.firstLeft != OldOutRec) continue;
            outRec.firstLeft = NewOutRec;
        }
    }

    private boolean fixupIntersectionOrder() {
        Collections.sort(this.intersectList, this.intersectNodeComparer);
        this.copyAELToSEL();
        int cnt = this.intersectList.size();
        for (int i2 = 0; i2 < cnt; ++i2) {
            if (!this.EdgesAdjacent(this.intersectList.get(i2))) {
                int j2;
                for (j2 = i2 + 1; j2 < cnt && !this.EdgesAdjacent(this.intersectList.get(j2)); ++j2) {
                }
                if (j2 == cnt) {
                    return false;
                }
                IntersectNode tmp = this.intersectList.get(i2);
                this.intersectList.set(i2, this.intersectList.get(j2));
                this.intersectList.set(j2, tmp);
            }
            this.swapPositionsInSEL(this.intersectList.get((int)i2).edge1, this.intersectList.get((int)i2).Edge2);
        }
        return true;
    }

    private void fixupOutPolyline(Path.OutRec outrec) {
        Path.OutPt pp = outrec.pts;
        Path.OutPt lastPP = pp.prev;
        while (pp != lastPP) {
            pp = pp.next;
            if (!pp.pt.equals(pp.prev.pt)) continue;
            if (pp == lastPP) {
                lastPP = pp.prev;
            }
            Path.OutPt tmpPP = pp.prev;
            tmpPP.next = pp.next;
            pp.next.prev = tmpPP;
            pp = tmpPP;
        }
        if (pp == pp.prev) {
            outrec.pts = null;
        }
    }

    private void fixupOutPolygon(Path.OutRec outRec) {
        boolean preserveCol;
        Path.OutPt lastOK = null;
        outRec.bottomPt = null;
        Path.OutPt pp = outRec.getPoints();
        boolean bl = preserveCol = this.preserveCollinear || this.strictlySimple;
        while (true) {
            if (pp.prev == pp || pp.prev == pp.next) {
                outRec.setPoints(null);
                return;
            }
            if (pp.getPt().equals(pp.next.getPt()) || pp.getPt().equals(pp.prev.getPt()) || Point.slopesEqual(pp.prev.getPt(), pp.getPt(), pp.next.getPt(), this.useFullRange) && (!preserveCol || !Point.isPt2BetweenPt1AndPt3(pp.prev.getPt(), pp.getPt(), pp.next.getPt()))) {
                lastOK = null;
                pp.prev.next = pp.next;
                pp.next.prev = pp.prev;
                pp = pp.prev;
                continue;
            }
            if (pp == lastOK) break;
            if (lastOK == null) {
                lastOK = pp;
            }
            pp = pp.next;
        }
        outRec.setPoints(pp);
    }

    private Path.OutRec getOutRec(int idx) {
        Path.OutRec outrec = this.polyOuts.get(idx);
        while (outrec != this.polyOuts.get(outrec.Idx)) {
            outrec = this.polyOuts.get(outrec.Idx);
        }
        return outrec;
    }

    private void insertEdgeIntoAEL(Edge edge, Edge startEdge) {
        LOGGER.entering(DefaultClipper.class.getName(), "insertEdgeIntoAEL");
        if (this.activeEdges == null) {
            edge.prevInAEL = null;
            edge.nextInAEL = null;
            LOGGER.finest("Edge " + edge.outIdx + " -> " + null);
            this.activeEdges = edge;
        } else if (startEdge == null && Edge.doesE2InsertBeforeE1(this.activeEdges, edge)) {
            edge.prevInAEL = null;
            edge.nextInAEL = this.activeEdges;
            LOGGER.finest("Edge " + edge.outIdx + " -> " + edge.nextInAEL.outIdx);
            this.activeEdges.prevInAEL = edge;
            this.activeEdges = edge;
        } else {
            LOGGER.finest("activeEdges unchanged");
            if (startEdge == null) {
                startEdge = this.activeEdges;
            }
            while (startEdge.nextInAEL != null && !Edge.doesE2InsertBeforeE1(startEdge.nextInAEL, edge)) {
                startEdge = startEdge.nextInAEL;
            }
            edge.nextInAEL = startEdge.nextInAEL;
            if (startEdge.nextInAEL != null) {
                startEdge.nextInAEL.prevInAEL = edge;
            }
            edge.prevInAEL = startEdge;
            startEdge.nextInAEL = edge;
        }
    }

    private void insertLocalMinimaIntoAEL(long botY) {
        LOGGER.entering(DefaultClipper.class.getName(), "insertLocalMinimaIntoAEL");
        while (this.currentLM != null && this.currentLM.y == botY) {
            Edge e2;
            Edge lb = this.currentLM.leftBound;
            Edge rb = this.currentLM.rightBound;
            this.popLocalMinima();
            Path.OutPt Op1 = null;
            if (lb == null) {
                this.insertEdgeIntoAEL(rb, null);
                this.updateWindingCount(rb);
                if (rb.isContributing(this.clipFillType, this.subjFillType, this.clipType)) {
                    Op1 = this.addOutPt(rb, rb.getBot());
                }
            } else if (rb == null) {
                this.insertEdgeIntoAEL(lb, null);
                this.updateWindingCount(lb);
                if (lb.isContributing(this.clipFillType, this.subjFillType, this.clipType)) {
                    Op1 = this.addOutPt(lb, lb.getBot());
                }
                this.insertScanbeam(lb.getTop().getY());
            } else {
                this.insertEdgeIntoAEL(lb, null);
                this.insertEdgeIntoAEL(rb, lb);
                this.updateWindingCount(lb);
                rb.windCnt = lb.windCnt;
                rb.windCnt2 = lb.windCnt2;
                if (lb.isContributing(this.clipFillType, this.subjFillType, this.clipType)) {
                    Op1 = this.addLocalMinPoly(lb, rb, lb.getBot());
                }
                this.insertScanbeam(lb.getTop().getY());
            }
            if (rb != null) {
                if (rb.isHorizontal()) {
                    this.addEdgeToSEL(rb);
                } else {
                    this.insertScanbeam(rb.getTop().getY());
                }
            }
            if (lb == null || rb == null) continue;
            if (Op1 != null && rb.isHorizontal() && this.ghostJoins.size() > 0 && rb.windDelta != 0) {
                for (int i2 = 0; i2 < this.ghostJoins.size(); ++i2) {
                    Path.Join j2 = this.ghostJoins.get(i2);
                    if (!this.doHorzSegmentsOverlap(j2.outPt1.getPt().getX(), j2.getOffPt().getX(), rb.getBot().getX(), rb.getTop().getX())) continue;
                    this.addJoin(j2.outPt1, Op1, j2.getOffPt());
                }
            }
            if (lb.outIdx >= 0 && lb.prevInAEL != null && lb.prevInAEL.getCurrent().getX() == lb.getBot().getX() && lb.prevInAEL.outIdx >= 0 && Edge.slopesEqual(lb.prevInAEL, lb, this.useFullRange) && lb.windDelta != 0 && lb.prevInAEL.windDelta != 0) {
                Path.OutPt Op2 = this.addOutPt(lb.prevInAEL, lb.getBot());
                this.addJoin(Op1, Op2, lb.getTop());
            }
            if (lb.nextInAEL == rb) continue;
            if (rb.outIdx >= 0 && rb.prevInAEL.outIdx >= 0 && Edge.slopesEqual(rb.prevInAEL, rb, this.useFullRange) && rb.windDelta != 0 && rb.prevInAEL.windDelta != 0) {
                Path.OutPt Op2 = this.addOutPt(rb.prevInAEL, rb.getBot());
                this.addJoin(Op1, Op2, rb.getTop());
            }
            if ((e2 = lb.nextInAEL) == null) continue;
            while (e2 != rb) {
                this.intersectEdges(rb, e2, lb.getCurrent());
                e2 = e2.nextInAEL;
            }
        }
    }

    private void intersectEdges(Edge e1, Edge e2, Point.LongPoint pt) {
        int e2Wc;
        int e1Wc;
        Clipper.PolyFillType e2FillType2;
        Clipper.PolyFillType e2FillType;
        Clipper.PolyFillType e1FillType2;
        Clipper.PolyFillType e1FillType;
        LOGGER.entering(DefaultClipper.class.getName(), "insersectEdges");
        boolean e1Contributing = e1.outIdx >= 0;
        boolean e2Contributing = e2.outIdx >= 0;
        this.setZ(pt, e1, e2);
        if (e1.windDelta == 0 || e2.windDelta == 0) {
            if (e1.windDelta == 0 && e2.windDelta == 0) {
                return;
            }
            if (e1.polyTyp == e2.polyTyp && e1.windDelta != e2.windDelta && this.clipType == Clipper.ClipType.UNION) {
                if (e1.windDelta == 0) {
                    if (e2Contributing) {
                        this.addOutPt(e1, pt);
                        if (e1Contributing) {
                            e1.outIdx = -1;
                        }
                    }
                } else if (e1Contributing) {
                    this.addOutPt(e2, pt);
                    if (e2Contributing) {
                        e2.outIdx = -1;
                    }
                }
            } else if (e1.polyTyp != e2.polyTyp) {
                if (e1.windDelta == 0 && Math.abs(e2.windCnt) == 1 && (this.clipType != Clipper.ClipType.UNION || e2.windCnt2 == 0)) {
                    this.addOutPt(e1, pt);
                    if (e1Contributing) {
                        e1.outIdx = -1;
                    }
                } else if (e2.windDelta == 0 && Math.abs(e1.windCnt) == 1 && (this.clipType != Clipper.ClipType.UNION || e1.windCnt2 == 0)) {
                    this.addOutPt(e2, pt);
                    if (e2Contributing) {
                        e2.outIdx = -1;
                    }
                }
            }
            return;
        }
        if (e1.polyTyp == e2.polyTyp) {
            if (e1.isEvenOddFillType(this.clipFillType, this.subjFillType)) {
                int oldE1WindCnt = e1.windCnt;
                e1.windCnt = e2.windCnt;
                e2.windCnt = oldE1WindCnt;
            } else {
                e1.windCnt = e1.windCnt + e2.windDelta == 0 ? -e1.windCnt : (e1.windCnt += e2.windDelta);
                e2.windCnt = e2.windCnt - e1.windDelta == 0 ? -e2.windCnt : (e2.windCnt -= e1.windDelta);
            }
        } else {
            if (!e2.isEvenOddFillType(this.clipFillType, this.subjFillType)) {
                e1.windCnt2 += e2.windDelta;
            } else {
                int n2 = e1.windCnt2 = e1.windCnt2 == 0 ? 1 : 0;
            }
            if (!e1.isEvenOddFillType(this.clipFillType, this.subjFillType)) {
                e2.windCnt2 -= e1.windDelta;
            } else {
                int n3 = e2.windCnt2 = e2.windCnt2 == 0 ? 1 : 0;
            }
        }
        if (e1.polyTyp == Clipper.PolyType.SUBJECT) {
            e1FillType = this.subjFillType;
            e1FillType2 = this.clipFillType;
        } else {
            e1FillType = this.clipFillType;
            e1FillType2 = this.subjFillType;
        }
        if (e2.polyTyp == Clipper.PolyType.SUBJECT) {
            e2FillType = this.subjFillType;
            e2FillType2 = this.clipFillType;
        } else {
            e2FillType = this.clipFillType;
            e2FillType2 = this.subjFillType;
        }
        switch (e1FillType) {
            case POSITIVE: {
                e1Wc = e1.windCnt;
                break;
            }
            case NEGATIVE: {
                e1Wc = -e1.windCnt;
                break;
            }
            default: {
                e1Wc = Math.abs(e1.windCnt);
            }
        }
        switch (e2FillType) {
            case POSITIVE: {
                e2Wc = e2.windCnt;
                break;
            }
            case NEGATIVE: {
                e2Wc = -e2.windCnt;
                break;
            }
            default: {
                e2Wc = Math.abs(e2.windCnt);
            }
        }
        if (e1Contributing && e2Contributing) {
            if (e1Wc != 0 && e1Wc != 1 || e2Wc != 0 && e2Wc != 1 || e1.polyTyp != e2.polyTyp && this.clipType != Clipper.ClipType.XOR) {
                this.addLocalMaxPoly(e1, e2, pt);
            } else {
                this.addOutPt(e1, pt);
                this.addOutPt(e2, pt);
                Edge.swapSides(e1, e2);
                Edge.swapPolyIndexes(e1, e2);
            }
        } else if (e1Contributing) {
            if (e2Wc == 0 || e2Wc == 1) {
                this.addOutPt(e1, pt);
                Edge.swapSides(e1, e2);
                Edge.swapPolyIndexes(e1, e2);
            }
        } else if (e2Contributing) {
            if (e1Wc == 0 || e1Wc == 1) {
                this.addOutPt(e2, pt);
                Edge.swapSides(e1, e2);
                Edge.swapPolyIndexes(e1, e2);
            }
        } else if (!(e1Wc != 0 && e1Wc != 1 || e2Wc != 0 && e2Wc != 1)) {
            int e2Wc2;
            int e1Wc2;
            switch (e1FillType2) {
                case POSITIVE: {
                    e1Wc2 = e1.windCnt2;
                    break;
                }
                case NEGATIVE: {
                    e1Wc2 = -e1.windCnt2;
                    break;
                }
                default: {
                    e1Wc2 = Math.abs(e1.windCnt2);
                }
            }
            switch (e2FillType2) {
                case POSITIVE: {
                    e2Wc2 = e2.windCnt2;
                    break;
                }
                case NEGATIVE: {
                    e2Wc2 = -e2.windCnt2;
                    break;
                }
                default: {
                    e2Wc2 = Math.abs(e2.windCnt2);
                }
            }
            if (e1.polyTyp != e2.polyTyp) {
                this.addLocalMinPoly(e1, e2, pt);
            } else if (e1Wc == 1 && e2Wc == 1) {
                switch (this.clipType) {
                    case INTERSECTION: {
                        if (e1Wc2 <= 0 || e2Wc2 <= 0) break;
                        this.addLocalMinPoly(e1, e2, pt);
                        break;
                    }
                    case UNION: {
                        if (e1Wc2 > 0 || e2Wc2 > 0) break;
                        this.addLocalMinPoly(e1, e2, pt);
                        break;
                    }
                    case DIFFERENCE: {
                        if ((e1.polyTyp != Clipper.PolyType.CLIP || e1Wc2 <= 0 || e2Wc2 <= 0) && (e1.polyTyp != Clipper.PolyType.SUBJECT || e1Wc2 > 0 || e2Wc2 > 0)) break;
                        this.addLocalMinPoly(e1, e2, pt);
                        break;
                    }
                    case XOR: {
                        this.addLocalMinPoly(e1, e2, pt);
                    }
                }
            } else {
                Edge.swapSides(e1, e2);
            }
        }
    }

    private void intersectPoint(Edge edge1, Edge edge2, Point.LongPoint[] ipV) {
        Point.LongPoint ip = ipV[0] = new Point.LongPoint();
        if (edge1.deltaX == edge2.deltaX) {
            ip.setY(edge1.getCurrent().getY());
            ip.setX(Edge.topX(edge1, ip.getY()));
            return;
        }
        if (edge1.getDelta().getX() == 0L) {
            ip.setX(edge1.getBot().getX());
            if (edge2.isHorizontal()) {
                ip.setY(edge2.getBot().getY());
            } else {
                double b2 = (double)edge2.getBot().getY() - (double)edge2.getBot().getX() / edge2.deltaX;
                ip.setY(Math.round((double)ip.getX() / edge2.deltaX + b2));
            }
        } else if (edge2.getDelta().getX() == 0L) {
            ip.setX(edge2.getBot().getX());
            if (edge1.isHorizontal()) {
                ip.setY(edge1.getBot().getY());
            } else {
                double b1 = (double)edge1.getBot().getY() - (double)edge1.getBot().getX() / edge1.deltaX;
                ip.setY(Math.round((double)ip.getX() / edge1.deltaX + b1));
            }
        } else {
            double b1 = (double)edge1.getBot().getX() - (double)edge1.getBot().getY() * edge1.deltaX;
            double b2 = (double)edge2.getBot().getX() - (double)edge2.getBot().getY() * edge2.deltaX;
            double q2 = (b2 - b1) / (edge1.deltaX - edge2.deltaX);
            ip.setY(Math.round(q2));
            if (Math.abs(edge1.deltaX) < Math.abs(edge2.deltaX)) {
                ip.setX(Math.round(edge1.deltaX * q2 + b1));
            } else {
                ip.setX(Math.round(edge2.deltaX * q2 + b2));
            }
        }
        if (ip.getY() < edge1.getTop().getY() || ip.getY() < edge2.getTop().getY()) {
            if (edge1.getTop().getY() > edge2.getTop().getY()) {
                ip.setY(edge1.getTop().getY());
            } else {
                ip.setY(edge2.getTop().getY());
            }
            if (Math.abs(edge1.deltaX) < Math.abs(edge2.deltaX)) {
                ip.setX(Edge.topX(edge1, ip.getY()));
            } else {
                ip.setX(Edge.topX(edge2, ip.getY()));
            }
        }
        if (ip.getY() > edge1.getCurrent().getY()) {
            ip.setY(edge1.getCurrent().getY());
            if (Math.abs(edge1.deltaX) > Math.abs(edge2.deltaX)) {
                ip.setX(Edge.topX(edge2, ip.getY()));
            } else {
                ip.setX(Edge.topX(edge1, ip.getY()));
            }
        }
    }

    private void joinCommonEdges() {
        for (int i2 = 0; i2 < this.joins.size(); ++i2) {
            Path.Join join = this.joins.get(i2);
            Path.OutRec outRec1 = this.getOutRec(join.outPt1.idx);
            Path.OutRec outRec2 = this.getOutRec(join.outPt2.idx);
            if (outRec1.getPoints() == null || outRec2.getPoints() == null || outRec1.isOpen || outRec2.isOpen) continue;
            Path.OutRec holeStateRec = outRec1 == outRec2 ? outRec1 : (DefaultClipper.isParam1RightOfParam2(outRec1, outRec2) ? outRec2 : (DefaultClipper.isParam1RightOfParam2(outRec2, outRec1) ? outRec1 : Path.OutPt.getLowerMostRec(outRec1, outRec2)));
            if (!this.joinPoints(join, outRec1, outRec2)) continue;
            if (outRec1 == outRec2) {
                outRec1.setPoints(join.outPt1);
                outRec1.bottomPt = null;
                outRec2 = this.createOutRec();
                outRec2.setPoints(join.outPt2);
                this.updateOutPtIdxs(outRec2);
                if (this.usingPolyTree) {
                    for (int j2 = 0; j2 < this.polyOuts.size() - 1; ++j2) {
                        Path.OutRec oRec = this.polyOuts.get(j2);
                        if (oRec.getPoints() == null || DefaultClipper.parseFirstLeft(oRec.firstLeft) != outRec1 || oRec.isHole == outRec1.isHole || !DefaultClipper.poly2ContainsPoly1(oRec.getPoints(), join.outPt2)) continue;
                        oRec.firstLeft = outRec2;
                    }
                }
                if (DefaultClipper.poly2ContainsPoly1(outRec2.getPoints(), outRec1.getPoints())) {
                    outRec2.isHole = !outRec1.isHole;
                    outRec2.firstLeft = outRec1;
                    if (this.usingPolyTree) {
                        this.fixupFirstLefts2(outRec2, outRec1);
                    }
                    if ((outRec2.isHole ^ this.reverseSolution) != outRec2.area() > 0.0) continue;
                    outRec2.getPoints().reversePolyPtLinks();
                    continue;
                }
                if (DefaultClipper.poly2ContainsPoly1(outRec1.getPoints(), outRec2.getPoints())) {
                    outRec2.isHole = outRec1.isHole;
                    outRec1.isHole = !outRec2.isHole;
                    outRec2.firstLeft = outRec1.firstLeft;
                    outRec1.firstLeft = outRec2;
                    if (this.usingPolyTree) {
                        this.fixupFirstLefts2(outRec1, outRec2);
                    }
                    if ((outRec1.isHole ^ this.reverseSolution) != outRec1.area() > 0.0) continue;
                    outRec1.getPoints().reversePolyPtLinks();
                    continue;
                }
                outRec2.isHole = outRec1.isHole;
                outRec2.firstLeft = outRec1.firstLeft;
                if (!this.usingPolyTree) continue;
                this.fixupFirstLefts1(outRec1, outRec2);
                continue;
            }
            outRec2.setPoints(null);
            outRec2.bottomPt = null;
            outRec2.Idx = outRec1.Idx;
            outRec1.isHole = holeStateRec.isHole;
            if (holeStateRec == outRec2) {
                outRec1.firstLeft = outRec2.firstLeft;
            }
            outRec2.firstLeft = outRec1;
            if (!this.usingPolyTree) continue;
            this.fixupFirstLefts2(outRec2, outRec1);
        }
    }

    private long popScanbeam() {
        LOGGER.entering(DefaultClipper.class.getName(), "popBeam");
        long y2 = this.scanbeam.y;
        this.scanbeam = this.scanbeam.next;
        return y2;
    }

    private void processEdgesAtTopOfScanbeam(long topY) {
        Path.OutPt op2;
        Edge[] t2;
        LOGGER.entering(DefaultClipper.class.getName(), "processEdgesAtTopOfScanbeam");
        Edge e2 = this.activeEdges;
        while (e2 != null) {
            Edge ePrev;
            boolean IsMaximaEdge = e2.isMaxima(topY);
            if (IsMaximaEdge) {
                Edge eMaxPair = e2.getMaximaPair();
                boolean bl = IsMaximaEdge = eMaxPair == null || !eMaxPair.isHorizontal();
            }
            if (IsMaximaEdge) {
                if (this.strictlySimple) {
                    this.InsertMaxima(e2.getTop().getX());
                }
                ePrev = e2.prevInAEL;
                this.doMaxima(e2);
                if (ePrev == null) {
                    e2 = this.activeEdges;
                    continue;
                }
                e2 = ePrev.nextInAEL;
                continue;
            }
            if (e2.isIntermediate(topY) && e2.nextInLML.isHorizontal()) {
                t2 = new Edge[]{e2};
                this.updateEdgeIntoAEL(t2);
                e2 = t2[0];
                if (e2.outIdx >= 0) {
                    this.addOutPt(e2, e2.getBot());
                }
                this.addEdgeToSEL(e2);
            } else {
                e2.getCurrent().setX(Edge.topX(e2, topY));
                e2.getCurrent().setY(topY);
            }
            if (this.strictlySimple) {
                ePrev = e2.prevInAEL;
                if (e2.outIdx >= 0 && e2.windDelta != 0 && ePrev != null && ePrev.outIdx >= 0 && ePrev.getCurrent().getX() == e2.getCurrent().getX() && ePrev.windDelta != 0) {
                    Point.LongPoint ip = new Point.LongPoint(e2.getCurrent());
                    this.setZ(ip, ePrev, e2);
                    Path.OutPt op = this.addOutPt(ePrev, ip);
                    op2 = this.addOutPt(e2, ip);
                    this.addJoin(op, op2, ip);
                }
            }
            e2 = e2.nextInAEL;
        }
        this.processHorizontals();
        this.maxima = null;
        e2 = this.activeEdges;
        while (e2 != null) {
            if (e2.isIntermediate(topY)) {
                Path.OutPt op = null;
                if (e2.outIdx >= 0) {
                    op = this.addOutPt(e2, e2.getTop());
                }
                t2 = new Edge[]{e2};
                this.updateEdgeIntoAEL(t2);
                e2 = t2[0];
                Edge ePrev = e2.prevInAEL;
                Edge eNext = e2.nextInAEL;
                if (ePrev != null && ePrev.getCurrent().getX() == e2.getBot().getX() && ePrev.getCurrent().getY() == e2.getBot().getY() && op != null && ePrev.outIdx >= 0 && ePrev.getCurrent().getY() > ePrev.getTop().getY() && Edge.slopesEqual(e2, ePrev, this.useFullRange) && e2.windDelta != 0 && ePrev.windDelta != 0) {
                    op2 = this.addOutPt(ePrev, e2.getBot());
                    this.addJoin(op, op2, e2.getTop());
                } else if (eNext != null && eNext.getCurrent().getX() == e2.getBot().getX() && eNext.getCurrent().getY() == e2.getBot().getY() && op != null && eNext.outIdx >= 0 && eNext.getCurrent().getY() > eNext.getTop().getY() && Edge.slopesEqual(e2, eNext, this.useFullRange) && e2.windDelta != 0 && eNext.windDelta != 0) {
                    op2 = this.addOutPt(eNext, e2.getBot());
                    this.addJoin(op, op2, e2.getTop());
                }
            }
            e2 = e2.nextInAEL;
        }
        LOGGER.exiting(DefaultClipper.class.getName(), "processEdgesAtTopOfScanbeam");
    }

    private void processHorizontal(Edge horzEdge) {
        Edge eNext;
        Path.OutPt op2;
        Path.Maxima currMax;
        LOGGER.entering(DefaultClipper.class.getName(), "isHorizontal");
        Clipper.Direction[] dir = new Clipper.Direction[1];
        long[] horzLeft = new long[1];
        long[] horzRight = new long[1];
        boolean IsOpen = horzEdge.outIdx >= 0 && this.polyOuts.get((int)horzEdge.outIdx).isOpen;
        DefaultClipper.getHorzDirection(horzEdge, dir, horzLeft, horzRight);
        Edge eLastHorz = horzEdge;
        Edge eMaxPair = null;
        while (eLastHorz.nextInLML != null && eLastHorz.nextInLML.isHorizontal()) {
            eLastHorz = eLastHorz.nextInLML;
        }
        if (eLastHorz.nextInLML == null) {
            eMaxPair = eLastHorz.getMaximaPair();
        }
        if ((currMax = this.maxima) != null) {
            if (dir[0] == Clipper.Direction.LEFT_TO_RIGHT) {
                while (currMax != null && currMax.X <= horzEdge.getBot().getX()) {
                    currMax = currMax.Next;
                }
                if (currMax != null && currMax.X >= eLastHorz.getBot().getX()) {
                    currMax = null;
                }
            } else {
                while (currMax.Next != null && currMax.Next.X < horzEdge.getBot().getX()) {
                    currMax = currMax.Next;
                }
                if (currMax.X <= eLastHorz.getTop().getX()) {
                    currMax = null;
                }
            }
        }
        Path.OutPt op1 = null;
        while (true) {
            boolean IsLastHorz = horzEdge == eLastHorz;
            Edge e2 = horzEdge.getNextInAEL(dir[0]);
            while (e2 != null) {
                Point.LongPoint Pt;
                if (currMax != null) {
                    if (dir[0] == Clipper.Direction.LEFT_TO_RIGHT) {
                        while (currMax != null && currMax.X < e2.getCurrent().getX()) {
                            if (horzEdge.outIdx >= 0 && !IsOpen) {
                                this.addOutPt(horzEdge, new Point.LongPoint(currMax.X, horzEdge.getBot().getY()));
                            }
                            currMax = currMax.Next;
                        }
                    } else {
                        while (currMax != null && currMax.X > e2.getCurrent().getX()) {
                            if (horzEdge.outIdx >= 0 && !IsOpen) {
                                this.addOutPt(horzEdge, new Point.LongPoint(currMax.X, horzEdge.getBot().getY()));
                            }
                            currMax = currMax.Prev;
                        }
                    }
                }
                if (dir[0] == Clipper.Direction.LEFT_TO_RIGHT && e2.getCurrent().getX() > horzRight[0] || dir[0] == Clipper.Direction.RIGHT_TO_LEFT && e2.getCurrent().getX() < horzLeft[0] || e2.getCurrent().getX() == horzEdge.getTop().getX() && horzEdge.nextInLML != null && e2.deltaX < horzEdge.nextInLML.deltaX) break;
                if (horzEdge.outIdx >= 0 && !IsOpen) {
                    op1 = this.addOutPt(horzEdge, e2.getCurrent());
                    Edge eNextHorz = this.sortedEdges;
                    while (eNextHorz != null) {
                        if (eNextHorz.outIdx >= 0 && this.doHorzSegmentsOverlap(horzEdge.getBot().getX(), horzEdge.getTop().getX(), eNextHorz.getBot().getX(), eNextHorz.getTop().getX())) {
                            op2 = this.GetLastOutPt(eNextHorz);
                            this.addJoin(op2, op1, eNextHorz.getTop());
                        }
                        eNextHorz = eNextHorz.nextInSEL;
                    }
                    this.addGhostJoin(op1, horzEdge.getBot());
                }
                if (e2 == eMaxPair && IsLastHorz) {
                    if (horzEdge.outIdx >= 0) {
                        this.addLocalMaxPoly(horzEdge, eMaxPair, horzEdge.getTop());
                    }
                    this.deleteFromAEL(horzEdge);
                    this.deleteFromAEL(eMaxPair);
                    return;
                }
                if (dir[0] == Clipper.Direction.LEFT_TO_RIGHT) {
                    Pt = new Point.LongPoint(e2.getCurrent().getX(), horzEdge.getCurrent().getY());
                    this.intersectEdges(horzEdge, e2, Pt);
                } else {
                    Pt = new Point.LongPoint(e2.getCurrent().getX(), horzEdge.getCurrent().getY());
                    this.intersectEdges(e2, horzEdge, Pt);
                }
                eNext = e2.getNextInAEL(dir[0]);
                this.swapPositionsInAEL(horzEdge, e2);
                e2 = eNext;
            }
            if (horzEdge.nextInLML == null || !horzEdge.nextInLML.isHorizontal()) break;
            Edge[] temp = new Edge[]{horzEdge};
            this.updateEdgeIntoAEL(temp);
            horzEdge = temp[0];
            if (horzEdge.outIdx >= 0) {
                this.addOutPt(horzEdge, horzEdge.getBot());
            }
            DefaultClipper.getHorzDirection(horzEdge, dir, horzLeft, horzRight);
        }
        if (horzEdge.outIdx >= 0 && op1 == null) {
            op1 = this.GetLastOutPt(horzEdge);
            Edge eNextHorz = this.sortedEdges;
            while (eNextHorz != null) {
                if (eNextHorz.outIdx >= 0 && this.doHorzSegmentsOverlap(horzEdge.getBot().getX(), horzEdge.getTop().getX(), eNextHorz.getBot().getX(), eNextHorz.getTop().getX())) {
                    Path.OutPt op22 = this.GetLastOutPt(eNextHorz);
                    this.addJoin(op22, op1, eNextHorz.getTop());
                }
                eNextHorz = eNextHorz.nextInSEL;
            }
            this.addGhostJoin(op1, horzEdge.getTop());
        }
        if (horzEdge.nextInLML != null) {
            if (horzEdge.outIdx >= 0) {
                op1 = this.addOutPt(horzEdge, horzEdge.getTop());
                Edge[] t2 = new Edge[]{horzEdge};
                this.updateEdgeIntoAEL(t2);
                horzEdge = t2[0];
                if (horzEdge.windDelta == 0) {
                    return;
                }
                Edge ePrev = horzEdge.prevInAEL;
                eNext = horzEdge.nextInAEL;
                if (ePrev != null && ePrev.getCurrent().getX() == horzEdge.getBot().getX() && ePrev.getCurrent().getY() == horzEdge.getBot().getY() && ePrev.windDelta != 0 && ePrev.outIdx >= 0 && ePrev.getCurrent().getY() > ePrev.getTop().getY() && Edge.slopesEqual(horzEdge, ePrev, this.useFullRange)) {
                    op2 = this.addOutPt(ePrev, horzEdge.getBot());
                    this.addJoin(op1, op2, horzEdge.getTop());
                } else if (eNext != null && eNext.getCurrent().getX() == horzEdge.getBot().getX() && eNext.getCurrent().getY() == horzEdge.getBot().getY() && eNext.windDelta != 0 && eNext.outIdx >= 0 && eNext.getCurrent().getY() > eNext.getTop().getY() && Edge.slopesEqual(horzEdge, eNext, this.useFullRange)) {
                    op2 = this.addOutPt(eNext, horzEdge.getBot());
                    this.addJoin(op1, op2, horzEdge.getTop());
                }
            } else {
                Edge[] t3 = new Edge[]{horzEdge};
                this.updateEdgeIntoAEL(t3);
                horzEdge = t3[0];
            }
        } else {
            if (horzEdge.outIdx >= 0) {
                this.addOutPt(horzEdge, horzEdge.getTop());
            }
            this.deleteFromAEL(horzEdge);
        }
    }

    private void processHorizontals() {
        LOGGER.entering(DefaultClipper.class.getName(), "processHorizontals");
        Edge horzEdge = this.sortedEdges;
        while (horzEdge != null) {
            this.deleteFromSEL(horzEdge);
            this.processHorizontal(horzEdge);
            horzEdge = this.sortedEdges;
        }
    }

    private boolean processIntersections(long topY) {
        LOGGER.entering(DefaultClipper.class.getName(), "processIntersections");
        if (this.activeEdges == null) {
            return true;
        }
        try {
            this.buildIntersectList(topY);
            if (this.intersectList.size() == 0) {
                return true;
            }
            if (this.intersectList.size() != 1 && !this.fixupIntersectionOrder()) {
                return false;
            }
            this.processIntersectList();
        }
        catch (Exception e2) {
            this.sortedEdges = null;
            this.intersectList.clear();
            throw new IllegalStateException("ProcessIntersections error", e2);
        }
        this.sortedEdges = null;
        return true;
    }

    private void processIntersectList() {
        for (int i2 = 0; i2 < this.intersectList.size(); ++i2) {
            IntersectNode iNode = this.intersectList.get(i2);
            this.intersectEdges(iNode.edge1, iNode.Edge2, iNode.getPt());
            this.swapPositionsInAEL(iNode.edge1, iNode.Edge2);
        }
        this.intersectList.clear();
    }

    protected void reset() {
        super.reset();
        this.scanbeam = null;
        this.maxima = null;
        this.activeEdges = null;
        this.sortedEdges = null;
        ClipperBase.LocalMinima lm = this.minimaList;
        while (lm != null) {
            this.insertScanbeam(lm.y);
            lm = lm.next;
        }
    }

    private void setHoleState(Edge e2, Path.OutRec outRec) {
        boolean isHole = false;
        Edge e22 = e2.prevInAEL;
        while (e22 != null) {
            if (e22.outIdx >= 0 && e22.windDelta != 0) {
                boolean bl = isHole = !isHole;
                if (outRec.firstLeft == null) {
                    outRec.firstLeft = this.polyOuts.get(e22.outIdx);
                }
            }
            e22 = e22.prevInAEL;
        }
        if (isHole) {
            outRec.isHole = true;
        }
    }

    private void setZ(Point.LongPoint pt, Edge e1, Edge e2) {
        if (pt.getZ() != 0L || this.zFillFunction == null) {
            return;
        }
        if (pt.equals(e1.getBot())) {
            pt.setZ(e1.getBot().getZ());
        } else if (pt.equals(e1.getTop())) {
            pt.setZ(e1.getTop().getZ());
        } else if (pt.equals(e2.getBot())) {
            pt.setZ(e2.getBot().getZ());
        } else if (pt.equals(e2.getTop())) {
            pt.setZ(e2.getTop().getZ());
        } else {
            this.zFillFunction.zFill(e1.getBot(), e1.getTop(), e2.getBot(), e2.getTop(), pt);
        }
    }

    private void swapPositionsInAEL(Edge edge1, Edge edge2) {
        LOGGER.entering(DefaultClipper.class.getName(), "swapPositionsInAEL");
        if (edge1.nextInAEL == edge1.prevInAEL || edge2.nextInAEL == edge2.prevInAEL) {
            return;
        }
        if (edge1.nextInAEL == edge2) {
            Edge prev;
            Edge next = edge2.nextInAEL;
            if (next != null) {
                next.prevInAEL = edge1;
            }
            if ((prev = edge1.prevInAEL) != null) {
                prev.nextInAEL = edge2;
            }
            edge2.prevInAEL = prev;
            edge2.nextInAEL = edge1;
            edge1.prevInAEL = edge2;
            edge1.nextInAEL = next;
        } else if (edge2.nextInAEL == edge1) {
            Edge prev;
            Edge next = edge1.nextInAEL;
            if (next != null) {
                next.prevInAEL = edge2;
            }
            if ((prev = edge2.prevInAEL) != null) {
                prev.nextInAEL = edge1;
            }
            edge1.prevInAEL = prev;
            edge1.nextInAEL = edge2;
            edge2.prevInAEL = edge1;
            edge2.nextInAEL = next;
        } else {
            Edge next = edge1.nextInAEL;
            Edge prev = edge1.prevInAEL;
            edge1.nextInAEL = edge2.nextInAEL;
            if (edge1.nextInAEL != null) {
                edge1.nextInAEL.prevInAEL = edge1;
            }
            edge1.prevInAEL = edge2.prevInAEL;
            if (edge1.prevInAEL != null) {
                edge1.prevInAEL.nextInAEL = edge1;
            }
            edge2.nextInAEL = next;
            if (edge2.nextInAEL != null) {
                edge2.nextInAEL.prevInAEL = edge2;
            }
            edge2.prevInAEL = prev;
            if (edge2.prevInAEL != null) {
                edge2.prevInAEL.nextInAEL = edge2;
            }
        }
        if (edge1.prevInAEL == null) {
            this.activeEdges = edge1;
        } else if (edge2.prevInAEL == null) {
            this.activeEdges = edge2;
        }
        LOGGER.exiting(DefaultClipper.class.getName(), "swapPositionsInAEL");
    }

    private void swapPositionsInSEL(Edge edge1, Edge edge2) {
        if (edge1.nextInSEL == null && edge1.prevInSEL == null) {
            return;
        }
        if (edge2.nextInSEL == null && edge2.prevInSEL == null) {
            return;
        }
        if (edge1.nextInSEL == edge2) {
            Edge prev;
            Edge next = edge2.nextInSEL;
            if (next != null) {
                next.prevInSEL = edge1;
            }
            if ((prev = edge1.prevInSEL) != null) {
                prev.nextInSEL = edge2;
            }
            edge2.prevInSEL = prev;
            edge2.nextInSEL = edge1;
            edge1.prevInSEL = edge2;
            edge1.nextInSEL = next;
        } else if (edge2.nextInSEL == edge1) {
            Edge prev;
            Edge next = edge1.nextInSEL;
            if (next != null) {
                next.prevInSEL = edge2;
            }
            if ((prev = edge2.prevInSEL) != null) {
                prev.nextInSEL = edge1;
            }
            edge1.prevInSEL = prev;
            edge1.nextInSEL = edge2;
            edge2.prevInSEL = edge1;
            edge2.nextInSEL = next;
        } else {
            Edge next = edge1.nextInSEL;
            Edge prev = edge1.prevInSEL;
            edge1.nextInSEL = edge2.nextInSEL;
            if (edge1.nextInSEL != null) {
                edge1.nextInSEL.prevInSEL = edge1;
            }
            edge1.prevInSEL = edge2.prevInSEL;
            if (edge1.prevInSEL != null) {
                edge1.prevInSEL.nextInSEL = edge1;
            }
            edge2.nextInSEL = next;
            if (edge2.nextInSEL != null) {
                edge2.nextInSEL.prevInSEL = edge2;
            }
            edge2.prevInSEL = prev;
            if (edge2.prevInSEL != null) {
                edge2.prevInSEL.nextInSEL = edge2;
            }
        }
        if (edge1.prevInSEL == null) {
            this.sortedEdges = edge1;
        } else if (edge2.prevInSEL == null) {
            this.sortedEdges = edge2;
        }
    }

    private void updateEdgeIntoAEL(Edge[] eV) {
        Edge e2 = eV[0];
        if (e2.nextInLML == null) {
            throw new IllegalStateException("UpdateEdgeIntoAEL: invalid call");
        }
        Edge AelPrev = e2.prevInAEL;
        Edge AelNext = e2.nextInAEL;
        e2.nextInLML.outIdx = e2.outIdx;
        if (AelPrev != null) {
            AelPrev.nextInAEL = e2.nextInLML;
        } else {
            this.activeEdges = e2.nextInLML;
        }
        if (AelNext != null) {
            AelNext.prevInAEL = e2.nextInLML;
        }
        e2.nextInLML.side = e2.side;
        e2.nextInLML.windDelta = e2.windDelta;
        e2.nextInLML.windCnt = e2.windCnt;
        e2.nextInLML.windCnt2 = e2.windCnt2;
        eV[0] = e2 = e2.nextInLML;
        e2.setCurrent(e2.getBot());
        e2.prevInAEL = AelPrev;
        e2.nextInAEL = AelNext;
        if (!e2.isHorizontal()) {
            this.insertScanbeam(e2.getTop().getY());
        }
    }

    private void updateOutPtIdxs(Path.OutRec outrec) {
        Path.OutPt op = outrec.getPoints();
        do {
            op.idx = outrec.Idx;
        } while ((op = op.prev) != outrec.getPoints());
    }

    private void updateWindingCount(Edge edge) {
        LOGGER.entering(DefaultClipper.class.getName(), "updateWindingCount");
        Edge e2 = edge.prevInAEL;
        while (e2 != null && (e2.polyTyp != edge.polyTyp || e2.windDelta == 0)) {
            e2 = e2.prevInAEL;
        }
        if (e2 == null) {
            edge.windCnt = edge.windDelta == 0 ? 1 : edge.windDelta;
            edge.windCnt2 = 0;
            e2 = this.activeEdges;
        } else if (edge.windDelta == 0 && this.clipType != Clipper.ClipType.UNION) {
            edge.windCnt = 1;
            edge.windCnt2 = e2.windCnt2;
            e2 = e2.nextInAEL;
        } else if (edge.isEvenOddFillType(this.clipFillType, this.subjFillType)) {
            if (edge.windDelta == 0) {
                boolean Inside = true;
                Edge e22 = e2.prevInAEL;
                while (e22 != null) {
                    if (e22.polyTyp == e2.polyTyp && e22.windDelta != 0) {
                        Inside = !Inside;
                    }
                    e22 = e22.prevInAEL;
                }
                edge.windCnt = Inside ? 0 : 1;
            } else {
                edge.windCnt = edge.windDelta;
            }
            edge.windCnt2 = e2.windCnt2;
            e2 = e2.nextInAEL;
        } else {
            edge.windCnt = e2.windCnt * e2.windDelta < 0 ? (Math.abs(e2.windCnt) > 1 ? (e2.windDelta * edge.windDelta < 0 ? e2.windCnt : e2.windCnt + edge.windDelta) : (edge.windDelta == 0 ? 1 : edge.windDelta)) : (edge.windDelta == 0 ? (e2.windCnt < 0 ? e2.windCnt - 1 : e2.windCnt + 1) : (e2.windDelta * edge.windDelta < 0 ? e2.windCnt : e2.windCnt + edge.windDelta));
            edge.windCnt2 = e2.windCnt2;
            e2 = e2.nextInAEL;
        }
        if (edge.isEvenOddAltFillType(this.clipFillType, this.subjFillType)) {
            while (e2 != edge) {
                if (e2.windDelta != 0) {
                    edge.windCnt2 = edge.windCnt2 == 0 ? 1 : 0;
                }
                e2 = e2.nextInAEL;
            }
        } else {
            while (e2 != edge) {
                edge.windCnt2 += e2.windDelta;
                e2 = e2.nextInAEL;
            }
        }
    }

    private class IntersectNode {
        Edge edge1;
        Edge Edge2;
        private Point.LongPoint pt;

        private IntersectNode() {
        }

        public Point.LongPoint getPt() {
            return this.pt;
        }

        public void setPt(Point.LongPoint pt) {
            this.pt = pt;
        }
    }
}

