/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Utilities;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.DocumentFont;
import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.fonts.cmaps.CMapByteCid;
import com.itextpdf.text.pdf.fonts.cmaps.CMapCache;
import com.itextpdf.text.pdf.fonts.cmaps.CMapCidUni;
import com.itextpdf.text.pdf.fonts.cmaps.CMapParserEx;
import com.itextpdf.text.pdf.fonts.cmaps.CMapSequence;
import com.itextpdf.text.pdf.fonts.cmaps.CMapToUnicode;
import com.itextpdf.text.pdf.fonts.cmaps.CidLocationFromByte;
import com.itextpdf.text.pdf.fonts.cmaps.IdentityToUnicode;
import java.io.IOException;
import java.util.Map;

public class CMapAwareDocumentFont
extends DocumentFont {
    private static final Logger LOGGER = LoggerFactory.getLogger(CMapAwareDocumentFont.class);
    private PdfDictionary fontDic;
    private int spaceWidth;
    private CMapToUnicode toUnicodeCmap;
    private CMapByteCid byteCid;
    private CMapCidUni cidUni;
    private char[] cidbyte2uni;
    private Map<Integer, Integer> uni2cid;

    public CMapAwareDocumentFont(PdfDictionary font) {
        super(font);
        this.fontDic = font;
        this.initFont();
    }

    public CMapAwareDocumentFont(PRIndirectReference refFont) {
        super(refFont);
        this.fontDic = (PdfDictionary)PdfReader.getPdfObjectRelease(refFont);
        this.initFont();
    }

    private void initFont() {
        this.processToUnicode();
        try {
            this.processUni2Byte();
            this.spaceWidth = super.getWidth(32);
            if (this.spaceWidth == 0) {
                this.spaceWidth = this.computeAverageWidth();
            }
            if (this.cjkEncoding != null) {
                this.byteCid = CMapCache.getCachedCMapByteCid(this.cjkEncoding);
                this.cidUni = CMapCache.getCachedCMapCidUni(this.uniMap);
            }
        }
        catch (Exception ex) {
            throw new ExceptionConverter(ex);
        }
    }

    private void processToUnicode() {
        PdfObject toUni = PdfReader.getPdfObjectRelease(this.fontDic.get(PdfName.TOUNICODE));
        if (toUni instanceof PRStream) {
            try {
                byte[] touni = PdfReader.getStreamBytes((PRStream)toUni);
                CidLocationFromByte lb = new CidLocationFromByte(touni);
                this.toUnicodeCmap = new CMapToUnicode();
                CMapParserEx.parseCid("", this.toUnicodeCmap, lb);
                this.uni2cid = this.toUnicodeCmap.createReverseMapping();
            }
            catch (IOException e2) {
                this.toUnicodeCmap = null;
                this.uni2cid = null;
            }
        } else if (this.isType0) {
            try {
                PdfName encodingName = this.fontDic.getAsName(PdfName.ENCODING);
                if (encodingName == null) {
                    return;
                }
                String enc = PdfName.decodeName(encodingName.toString());
                if (!enc.equals("Identity-H")) {
                    return;
                }
                PdfArray df = (PdfArray)PdfReader.getPdfObjectRelease(this.fontDic.get(PdfName.DESCENDANTFONTS));
                PdfDictionary cidft = (PdfDictionary)PdfReader.getPdfObjectRelease(df.getPdfObject(0));
                PdfDictionary cidinfo = cidft.getAsDict(PdfName.CIDSYSTEMINFO);
                if (cidinfo == null) {
                    return;
                }
                PdfString ordering = cidinfo.getAsString(PdfName.ORDERING);
                if (ordering == null) {
                    return;
                }
                CMapToUnicode touni = IdentityToUnicode.GetMapFromOrdering(ordering.toUnicodeString());
                if (touni == null) {
                    return;
                }
                this.toUnicodeCmap = touni;
                this.uni2cid = this.toUnicodeCmap.createReverseMapping();
            }
            catch (IOException e3) {
                this.toUnicodeCmap = null;
                this.uni2cid = null;
            }
        }
    }

    private void processUni2Byte() throws IOException {
        IntHashtable diffmap;
        IntHashtable byte2uni = this.getByte2Uni();
        int[] e2 = byte2uni.toOrderedKeys();
        if (e2.length == 0) {
            return;
        }
        this.cidbyte2uni = new char[256];
        for (int k2 = 0; k2 < e2.length; ++k2) {
            int key2 = e2[k2];
            if (key2 <= 255) {
                this.cidbyte2uni[key2] = (char)byte2uni.get(key2);
                continue;
            }
            LOGGER.warn("Font has illegal differences array.");
        }
        if (this.toUnicodeCmap != null) {
            Map<Integer, Integer> dm = this.toUnicodeCmap.createDirectMapping();
            for (Map.Entry<Integer, Integer> kv : dm.entrySet()) {
                if (kv.getKey() >= 256) continue;
                this.cidbyte2uni[kv.getKey().intValue()] = (char)kv.getValue().intValue();
            }
        }
        if ((diffmap = this.getDiffmap()) != null) {
            e2 = diffmap.toOrderedKeys();
            for (int k3 = 0; k3 < e2.length; ++k3) {
                int n2 = diffmap.get(e2[k3]);
                if (n2 >= 256) continue;
                this.cidbyte2uni[n2] = (char)e2[k3];
            }
        }
    }

    private int computeAverageWidth() {
        int count = 0;
        int total = 0;
        for (int i2 = 0; i2 < this.widths.length; ++i2) {
            if (this.widths[i2] == 0) continue;
            total += this.widths[i2];
            ++count;
        }
        return count != 0 ? total / count : 0;
    }

    public int getWidth(int char1) {
        if (char1 == 32) {
            return this.spaceWidth != 0 ? this.spaceWidth : this.defaultWidth;
        }
        return super.getWidth(char1);
    }

    private String decodeSingleCID(byte[] bytes, int offset, int len) {
        if (this.toUnicodeCmap != null) {
            if (offset + len > bytes.length) {
                throw new ArrayIndexOutOfBoundsException(MessageLocalization.getComposedMessage("invalid.index.1", offset + len));
            }
            String s2 = this.toUnicodeCmap.lookup(bytes, offset, len);
            if (s2 != null) {
                return s2;
            }
            if (len != 1 || this.cidbyte2uni == null) {
                return null;
            }
        }
        if (len == 1) {
            if (this.cidbyte2uni == null) {
                return "";
            }
            return new String(this.cidbyte2uni, 0xFF & bytes[offset], 1);
        }
        throw new Error("Multi-byte glyphs not implemented yet");
    }

    public String decode(byte[] cidbytes, int offset, int len) {
        StringBuilder sb = new StringBuilder();
        if (this.toUnicodeCmap == null && this.byteCid != null) {
            CMapSequence seq = new CMapSequence(cidbytes, offset, len);
            String cid = this.byteCid.decodeSequence(seq);
            for (int k2 = 0; k2 < cid.length(); ++k2) {
                int c2 = this.cidUni.lookup(cid.charAt(k2));
                if (c2 <= 0) continue;
                sb.append(Utilities.convertFromUtf32(c2));
            }
        } else {
            for (int i2 = offset; i2 < offset + len; ++i2) {
                String rslt = this.decodeSingleCID(cidbytes, i2, 1);
                if (rslt == null && i2 < offset + len - 1) {
                    rslt = this.decodeSingleCID(cidbytes, i2, 2);
                    ++i2;
                }
                if (rslt == null) continue;
                sb.append(rslt);
            }
        }
        return sb.toString();
    }

    public String encode(byte[] bytes, int offset, int len) {
        return this.decode(bytes, offset, len);
    }
}

