/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Control parent;
    boolean tracking;
    boolean cancelled;
    boolean stippled;
    Cursor clientCursor;
    Cursor resizeCursor;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int cursorOrientation = 0;
    boolean inEvent = false;
    NSWindow window;
    int oldX;
    int oldY;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite composite, int n) {
        super(composite, Tracker.checkStyle(n));
        this.parent = composite;
    }

    public Tracker(Display display, int n) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(n);
        this.display = display;
        this.reskinWidget();
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n = this.bounds.x + this.bounds.width / 2;
        int n2 = this.bounds.y;
        if (this.parent != null) {
            Point point = this.parent.toDisplay(n, n2);
            n = point.x;
            n2 = point.y;
        }
        this.display.setCursorLocation(n, n2);
        return new Point(n, n2);
    }

    Point adjustResizeCursor(boolean bl) {
        Object object;
        if (this.bounds == null) {
            return null;
        }
        int n = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int n2 = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        if (this.parent != null) {
            object = this.parent.toDisplay(n, n2);
            n = ((Point)object).x;
            n2 = ((Point)object).y;
        }
        if (bl) {
            this.display.setCursorLocation(n, n2);
        }
        if (this.clientCursor == null) {
            object = null;
            switch (this.cursorOrientation) {
                case 128: {
                    object = new Cursor(this.display, 7);
                    break;
                }
                case 1024: {
                    object = new Cursor(this.display, 7);
                    break;
                }
                case 16384: {
                    object = new Cursor(this.display, 9);
                    break;
                }
                case 131072: {
                    object = new Cursor(this.display, 9);
                    break;
                }
                case 16512: {
                    object = new Cursor(this.display, 8);
                    break;
                }
                case 132096: {
                    object = new Cursor(this.display, 8);
                    break;
                }
                case 17408: {
                    object = new Cursor(this.display, 6);
                    break;
                }
                case 131200: {
                    object = new Cursor(this.display, 6);
                    break;
                }
                default: {
                    object = new Cursor(this.display, 5);
                }
            }
            this.display.lockCursor = false;
            ((Cursor)object).handle.set();
            this.display.lockCursor = true;
            if (this.resizeCursor != null) {
                this.resizeCursor.dispose();
            }
            this.resizeCursor = object;
        }
        return new Point(n, n2);
    }

    static int checkStyle(int n) {
        if ((n & 0x24480) == 0) {
            n |= 0x24480;
        }
        return n;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int n = this.rectangles[0].x;
        int n2 = this.rectangles[0].y;
        int n3 = this.rectangles[0].x + this.rectangles[0].width;
        int n4 = this.rectangles[0].y + this.rectangles[0].height;
        for (int i = 1; i < this.rectangles.length; ++i) {
            int n5;
            int n6;
            if (this.rectangles[i].x < n) {
                n = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < n2) {
                n2 = this.rectangles[i].y;
            }
            if ((n6 = this.rectangles[i].x + this.rectangles[i].width) > n3) {
                n3 = n6;
            }
            if ((n5 = this.rectangles[i].y + this.rectangles[i].height) <= n4) continue;
            n4 = n5;
        }
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    Rectangle[] computeProportions(Rectangle[] rectangleArray) {
        Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            for (int i = 0; i < rectangleArray.length; ++i) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (this.bounds.width != 0) {
                    n = (rectangleArray[i].x - this.bounds.x) * 100 / this.bounds.width;
                    n3 = rectangleArray[i].width * 100 / this.bounds.width;
                } else {
                    n3 = 100;
                }
                if (this.bounds.height != 0) {
                    n2 = (rectangleArray[i].y - this.bounds.y) * 100 / this.bounds.height;
                    n4 = rectangleArray[i].height * 100 / this.bounds.height;
                } else {
                    n4 = 100;
                }
                rectangleArray2[i] = new Rectangle(n, n2, n3, n4);
            }
        }
        return rectangleArray2;
    }

    void drawRectangles(NSWindow nSWindow, Rectangle[] rectangleArray, boolean bl) {
        NSGraphicsContext nSGraphicsContext = nSWindow.graphicsContext();
        NSGraphicsContext.static_saveGraphicsState();
        NSGraphicsContext.setCurrentContext(nSGraphicsContext);
        nSGraphicsContext.saveGraphicsState();
        Point point = this.parent != null ? this.display.map(this.parent, null, 0, 0) : new Point(0, 0);
        nSGraphicsContext.setCompositingOperation(bl ? 0 : 2);
        NSRect nSRect = new NSRect();
        NSPoint nSPoint = new NSPoint();
        float f = this.display.getPrimaryFrame().height;
        for (int i = 0; i < rectangleArray.length; ++i) {
            Rectangle rectangle = rectangleArray[i];
            nSRect.x = rectangle.x + point.x;
            nSRect.y = f - (float)(rectangle.y + point.y + rectangle.height);
            nSRect.width = rectangle.width;
            nSRect.height = rectangle.height;
            nSPoint.x = nSRect.x;
            nSPoint.y = nSRect.y;
            nSPoint = nSWindow.convertScreenToBase(nSPoint);
            nSRect.x = nSPoint.x;
            nSRect.y = nSPoint.y;
            if (bl) {
                nSRect.width += 1.0f;
                nSRect.height += 1.0f;
                NSBezierPath.fillRect(nSRect);
                continue;
            }
            nSRect.x += 0.5f;
            nSRect.y += 0.5f;
            NSBezierPath.strokeRect(nSRect);
        }
        if (!bl) {
            nSGraphicsContext.flushGraphics();
        }
        nSGraphicsContext.restoreGraphicsState();
        NSGraphicsContext.static_restoreGraphicsState();
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        for (int i = 0; i < this.rectangles.length; ++i) {
            Rectangle rectangle = this.rectangles[i];
            rectangleArray[i] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return rectangleArray;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void mouse(NSEvent nSEvent) {
        NSPoint nSPoint;
        if (nSEvent == null || nSEvent.type() == 5) {
            nSPoint = NSEvent.mouseLocation();
        } else {
            nSPoint = nSEvent.locationInWindow();
            nSPoint = nSEvent.window().convertBaseToScreen(nSPoint);
        }
        nSPoint.y = this.display.getPrimaryFrame().height - nSPoint.y;
        int n = (int)nSPoint.x;
        int n2 = (int)nSPoint.y;
        if (n != this.oldX || n2 != this.oldY) {
            Rectangle[] rectangleArray = this.rectangles;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            for (int i = 0; i < this.rectangles.length; ++i) {
                Rectangle rectangle = this.rectangles[i];
                rectangleArray2[i] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            Event event = new Event();
            event.x = n;
            event.y = n2;
            if ((this.style & 0x10) != 0) {
                Point point;
                boolean bl = this.resizeRectangles(n - this.oldX, n2 - this.oldY);
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean bl2 = false;
                if (this.rectangles != rectangleArray) {
                    int n3 = this.rectangles.length;
                    if (n3 != rectangleArray2.length) {
                        bl2 = true;
                    } else {
                        for (int i = 0; i < n3; ++i) {
                            if (this.rectangles[i].equals(rectangleArray2[i])) continue;
                            bl2 = true;
                            break;
                        }
                    }
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    this.drawRectangles(this.window, rectangleArray2, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
                if ((point = this.adjustResizeCursor(bl)) != null) {
                    n = point.x;
                    n2 = point.y;
                }
            } else {
                this.moveRectangles(n - this.oldX, n2 - this.oldY);
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n4 = this.rectangles.length;
                    if (n4 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        for (int i = 0; i < n4; ++i) {
                            if (this.rectangles[i].equals(rectangleArray2[i])) continue;
                            bl = true;
                            break;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.drawRectangles(this.window, rectangleArray2, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
            }
            this.oldX = n;
            this.oldY = n2;
        }
        switch (nSEvent.type()) {
            case 2: 
            case 4: 
            case 26: {
                this.tracking = false;
            }
        }
    }

    void key(NSEvent nSEvent) {
        int n;
        int n2 = nSEvent.type();
        int n3 = nSEvent.modifierFlags();
        short s = nSEvent.keyCode();
        int n4 = Display.translateKey(s);
        switch (n2) {
            case 10: 
            case 11: {
                Event event = new Event();
                event.keyCode = n4;
                int n5 = n = n2 == 10 ? 1 : 2;
                if (!this.setKeyState(event, n, nSEvent) || this.sendKeyEvent(n, event)) break;
                return;
            }
            case 12: {
                int n6 = 0;
                switch (n4) {
                    case 65536: {
                        n6 = 524288;
                        break;
                    }
                    case 262144: {
                        n6 = 262144;
                        break;
                    }
                    case 0x400000: {
                        n6 = 0x100000;
                        break;
                    }
                    case 131072: {
                        n6 = 131072;
                        break;
                    }
                    case 16777298: {
                        Event event = new Event();
                        event.keyCode = n4;
                        this.setInputState(event, nSEvent, 1);
                        this.sendKeyEvent(1, event);
                        this.setInputState(event, nSEvent, 2);
                        this.sendKeyEvent(2, event);
                    }
                }
                if (n6 == 0) break;
                n = (n6 & n3) != 0 ? 1 : 2;
                Event event = new Event();
                event.keyCode = n4;
                this.setLocationMask(event, nSEvent);
                this.setInputState(event, nSEvent, n);
                if (this.sendKeyEvent(n, event)) break;
                return;
            }
        }
        int n7 = (n3 & 0x40000) != 0 ? 1 : 9;
        n = 0;
        int n8 = 0;
        switch (s) {
            case 53: {
                this.cancelled = true;
                this.tracking = false;
                break;
            }
            case 36: 
            case 76: {
                this.tracking = false;
                break;
            }
            case 123: {
                n = -n7;
                break;
            }
            case 124: {
                n = n7;
                break;
            }
            case 126: {
                n8 = -n7;
                break;
            }
            case 125: {
                n8 = n7;
            }
        }
        if (n != 0 || n8 != 0) {
            Point point;
            Rectangle[] rectangleArray = this.rectangles;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            for (int i = 0; i < this.rectangles.length; ++i) {
                Rectangle rectangle = this.rectangles[i];
                rectangleArray2[i] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            Event event = new Event();
            int n9 = this.oldX + n;
            int n10 = this.oldY + n8;
            event.x = n9;
            event.y = n10;
            if ((this.style & 0x10) != 0) {
                this.resizeRectangles(n, n8);
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n11 = this.rectangles.length;
                    if (n11 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        for (int i = 0; i < n11; ++i) {
                            if (this.rectangles[i].equals(rectangleArray2[i])) continue;
                            bl = true;
                            break;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.drawRectangles(this.window, rectangleArray2, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
                point = this.adjustResizeCursor(true);
            } else {
                this.moveRectangles(n, n8);
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n12 = this.rectangles.length;
                    if (n12 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        for (int i = 0; i < n12; ++i) {
                            if (this.rectangles[i].equals(rectangleArray2[i])) continue;
                            bl = true;
                            break;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.drawRectangles(this.window, rectangleArray2, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
                point = this.adjustMoveCursor();
            }
            if (point != null) {
                this.oldX = point.x;
                this.oldY = point.y;
            }
        }
    }

    void moveRectangles(int n, int n2) {
        if (this.bounds == null) {
            return;
        }
        if (n < 0 && (this.style & 0x4000) == 0) {
            n = 0;
        }
        if (n > 0 && (this.style & 0x20000) == 0) {
            n = 0;
        }
        if (n2 < 0 && (this.style & 0x80) == 0) {
            n2 = 0;
        }
        if (n2 > 0 && (this.style & 0x400) == 0) {
            n2 = 0;
        }
        if (n == 0 && n2 == 0) {
            return;
        }
        this.bounds.x += n;
        this.bounds.y += n2;
        for (int i = 0; i < this.rectangles.length; ++i) {
            this.rectangles[i].x += n;
            this.rectangles[i].y += n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean open() {
        Point point;
        int n;
        NSObject nSObject;
        this.checkWidget();
        Display display = this.display;
        this.cancelled = false;
        this.tracking = true;
        this.window = (NSWindow)new NSWindow().alloc();
        NSArray nSArray = NSScreen.screens();
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        float f3 = Float.MAX_VALUE;
        float f4 = Float.MIN_VALUE;
        int n2 = nSArray.count();
        for (int i = 0; i < n2; ++i) {
            nSObject = new NSScreen(nSArray.objectAtIndex(i));
            NSRect nSRect = ((NSScreen)nSObject).frame();
            float f5 = nSRect.x;
            float f6 = nSRect.x + nSRect.width;
            float f7 = nSRect.y;
            float f8 = nSRect.y + nSRect.height;
            if (f5 < f) {
                f = f5;
            }
            if (f6 < f) {
                f = f6;
            }
            if (f5 > f2) {
                f2 = f5;
            }
            if (f6 > f2) {
                f2 = f6;
            }
            if (f7 < f3) {
                f3 = f7;
            }
            if (f8 < f3) {
                f3 = f8;
            }
            if (f7 > f4) {
                f4 = f7;
            }
            if (!(f8 > f4)) continue;
            f4 = f8;
        }
        NSRect nSRect = new NSRect();
        nSRect.x = f;
        nSRect.y = f3;
        nSRect.width = f2 - f;
        nSRect.height = f4 - f3;
        this.window = this.window.initWithContentRect(nSRect, 0, 2, false);
        this.window.setOpaque(false);
        this.window.setLevel(25);
        this.window.setContentView(null);
        this.window.setBackgroundColor(NSColor.clearColor());
        nSObject = this.window.graphicsContext();
        NSGraphicsContext.static_saveGraphicsState();
        NSGraphicsContext.setCurrentContext((NSGraphicsContext)nSObject);
        ((NSGraphicsContext)nSObject).setCompositingOperation(0);
        nSRect.y = 0.0f;
        nSRect.x = 0.0f;
        NSBezierPath.fillRect(nSRect);
        NSGraphicsContext.static_restoreGraphicsState();
        this.window.orderFrontRegardless();
        this.drawRectangles(this.window, this.rectangles, false);
        int n3 = this.style & 0x480;
        if (n3 == 128 || n3 == 1024) {
            this.cursorOrientation |= n3;
        }
        if ((n = this.style & 0x24000) == 16384 || n == 131072) {
            this.cursorOrientation |= n;
        }
        boolean bl = false;
        NSApplication nSApplication = NSApplication.sharedApplication();
        NSEvent nSEvent = nSApplication.currentEvent();
        if (nSEvent != null) {
            switch (nSEvent.type()) {
                case 1: 
                case 3: 
                case 6: 
                case 7: 
                case 25: 
                case 27: {
                    bl = true;
                    break;
                }
            }
        }
        if ((point = bl ? display.getCursorLocation() : ((this.style & 0x10) != 0 ? this.adjustResizeCursor(true) : this.adjustMoveCursor())) != null) {
            this.oldX = point.x;
            this.oldY = point.y;
        }
        Control control = display.trackingControl;
        display.trackingControl = null;
        while (this.tracking && !this.cancelled) {
            Object var21_26;
            block34: {
                block33: {
                    display.addPool();
                    try {
                        if (this.parent != null && this.parent.isDisposed()) {
                            var21_26 = null;
                            display.removePool();
                            break;
                        }
                        display.runSkin();
                        display.runDeferredLayouts();
                        NSEvent nSEvent2 = nSApplication.nextEventMatchingMask(0, NSDate.distantFuture(), OS.NSDefaultRunLoopMode, true);
                        if (nSEvent2 == null) {
                            break block33;
                        }
                        int n4 = nSEvent2.type();
                        switch (n4) {
                            case 2: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 26: 
                            case 27: {
                                this.mouse(nSEvent2);
                                break;
                            }
                            case 10: 
                            case 11: 
                            case 12: {
                                this.key(nSEvent2);
                                break;
                            }
                        }
                        boolean bl2 = true;
                        switch (n4) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 25: 
                            case 26: 
                            case 27: {
                                bl2 = false;
                                break;
                            }
                        }
                        if (bl2) {
                            nSApplication.sendEvent(nSEvent2);
                        }
                        if (this.clientCursor != null && this.resizeCursor == null) {
                            display.lockCursor = false;
                            this.clientCursor.handle.set();
                            display.lockCursor = true;
                        }
                        display.runAsyncMessages(false);
                        break block34;
                    }
                    catch (Throwable throwable) {
                        var21_26 = null;
                        display.removePool();
                        throw throwable;
                    }
                }
                var21_26 = null;
                display.removePool();
                continue;
            }
            var21_26 = null;
            display.removePool();
        }
        if (this.resizeCursor != null) {
            this.resizeCursor.dispose();
        }
        this.resizeCursor = null;
        if (control != null && !control.isDisposed()) {
            display.trackingControl = control;
        }
        display.setCursor(display.findControl(true));
        if (!this.isDisposed()) {
            this.drawRectangles(this.window, this.rectangles, true);
        }
        if (this.window != null) {
            this.window.close();
        }
        this.tracking = false;
        this.window = null;
        if (this.cancelled) return false;
        return true;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, controlListener);
        this.eventTable.unhook(10, controlListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    boolean resizeRectangles(int n, int n2) {
        Rectangle rectangle;
        int n3;
        if (this.bounds == null) {
            return false;
        }
        boolean bl = false;
        if (n < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x4000;
            bl = true;
        }
        if (n > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x20000;
            bl = true;
        }
        if (n2 < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x80;
            bl = true;
        }
        if (n2 > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x400;
            bl = true;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (n > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return bl;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                n -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    for (n3 = 0; n3 < this.proportions.length; ++n3) {
                        rectangle = this.proportions[n3];
                        rectangle.x = 100 - rectangle.x - rectangle.width;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -n) {
            if ((this.style & 0x4000) == 0) {
                return bl;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            n += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                for (n3 = 0; n3 < this.proportions.length; ++n3) {
                    rectangle = this.proportions[n3];
                    rectangle.x = 100 - rectangle.x - rectangle.width;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (n2 > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return bl;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                n2 -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    for (n3 = 0; n3 < this.proportions.length; ++n3) {
                        rectangle = this.proportions[n3];
                        rectangle.y = 100 - rectangle.y - rectangle.height;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -n2) {
            if ((this.style & 0x80) == 0) {
                return bl;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            n2 += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                for (n3 = 0; n3 < this.proportions.length; ++n3) {
                    rectangle = this.proportions[n3];
                    rectangle.y = 100 - rectangle.y - rectangle.height;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += n;
            this.bounds.width -= n;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += n;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += n2;
            this.bounds.height -= n2;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += n2;
        }
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        for (int i = 0; i < this.rectangles.length; ++i) {
            Rectangle rectangle2 = this.proportions[i];
            rectangleArray[i] = new Rectangle(rectangle2.x * this.bounds.width / 100 + this.bounds.x, rectangle2.y * this.bounds.height / 100 + this.bounds.y, rectangle2.width * this.bounds.width / 100, rectangle2.height * this.bounds.height / 100);
        }
        this.rectangles = rectangleArray;
        return bl;
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        this.clientCursor = cursor;
        if (cursor != null) {
            this.display.lockCursor = false;
            if (this.inEvent) {
                cursor.handle.set();
            }
            this.display.lockCursor = true;
        }
    }

    public void setRectangles(Rectangle[] rectangleArray) {
        this.checkWidget();
        if (rectangleArray == null) {
            this.error(4);
        }
        int n = rectangleArray.length;
        this.rectangles = new Rectangle[n];
        for (int i = 0; i < n; ++i) {
            Rectangle rectangle = rectangleArray[i];
            if (rectangle == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.proportions = this.computeProportions(rectangleArray);
    }

    public void setStippled(boolean bl) {
        this.checkWidget();
        this.stippled = bl;
    }
}

