/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.HeaderBlock;
import com.monstarmike.tlmreader.primitives.Shorts;

public class HeaderVoltBlock
extends HeaderBlock {
    private boolean active;
    private short minVoltageInHunderthOfVolts;
    private short maxVoltageInHunderthOfVolts;
    private byte statusReport;
    private byte warningReport;

    public HeaderVoltBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
    }

    private void decode(byte[] rawData) {
        this.active = new Boolean(1 == rawData[7]);
        this.minVoltageInHunderthOfVolts = Shorts.fromBytes(rawData[13], rawData[12]);
        this.maxVoltageInHunderthOfVolts = Shorts.fromBytes(rawData[15], rawData[14]);
        this.statusReport = new Byte(rawData[16]);
        this.warningReport = new Byte(rawData[17]);
    }

    public static boolean isVoltHeader(byte[] bytes) {
        return bytes.length > 6 && bytes[4] == 1 && bytes[5] == 1;
    }

    public String toString() {
        return "VoltHeader; active: " + this.isActive() + ", minVolt: " + this.getMinVoltageInHunderthOfVolts() + ", maxVolt: " + this.getMaxVoltageInHunderthOfVolts() + ", statusReport: " + this.getStatusReport() + ", warningReport: " + this.getWarningReport();
    }

    public boolean isActive() {
        return this.active;
    }

    public short getMinVoltageInHunderthOfVolts() {
        return this.minVoltageInHunderthOfVolts;
    }

    public short getMaxVoltageInHunderthOfVolts() {
        return this.maxVoltageInHunderthOfVolts;
    }

    public String getStatusReport() {
        return this.convertReportTime(this.statusReport);
    }

    public String getWarningReport() {
        return this.convertReportTime(this.warningReport);
    }
}

