/*
 * Decompiled with CFR 0.152.
 */
package gde.device.wb;

import gde.Analyzer;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.PropertyType;
import gde.device.resource.DeviceXmlResource;
import gde.exception.DataInconsitsentException;
import gde.io.FileHandler;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class Triangoli
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(Triangoli.class.getName());
    final DataExplorer application;
    final Channels channels;

    public Triangoli(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.wb.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            String toolTipText = Triangoli.getImportToolTip();
            this.configureSerialPortMenu(0, toolTipText, toolTipText);
            this.updateFileExportMenu(this.application.getMenuBar().getExportMenu());
        }
    }

    public Triangoli(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.wb.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            String toolTipText = Triangoli.getImportToolTip();
            this.configureSerialPortMenu(0, toolTipText, toolTipText);
            this.updateFileExportMenu(this.application.getMenuBar().getExportMenu());
        }
    }

    public static String getImportToolTip() {
        DeviceConfiguration onlinecommanderConfiguration = Analyzer.getInstance().getDeviceConfigurations().get("Triangoli");
        String fileExtentions = onlinecommanderConfiguration != null ? onlinecommanderConfiguration.getDataBlockPreferredFileExtention() : "?";
        return Messages.getString((String)"GDE_MSGT2754", (Object[])new Object[]{fileExtentions});
    }

    public void updateFileExportMenu(Menu exportMenue) {
        if (exportMenue.getItem(exportMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0732"))) {
            new MenuItem(exportMenue, 2);
            MenuItem convertKMZ3DRelativeItem = new MenuItem(exportMenue, 8);
            convertKMZ3DRelativeItem.setText(Messages.getString((String)"GDE_MSGT2755"));
            convertKMZ3DRelativeItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKMZ3DRelativeItem action performed! " + String.valueOf(e));
                    Triangoli.this.export2KMZ3D(0);
                }
            });
            MenuItem convertKMZDAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZDAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT2756"));
            convertKMZDAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKMZDAbsoluteItem action performed! " + String.valueOf(e));
                    Triangoli.this.export2KMZ3D(1);
                }
            });
            convertKMZDAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZDAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT2757"));
            convertKMZDAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKMZDAbsoluteItem action performed! " + String.valueOf(e));
                    Triangoli.this.export2KMZ3D(2);
                }
            });
        }
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        int[] points = new int[recordSet.getNoneCalculationRecordNames().length];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 1;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        int index = 0;
        for (int i = 0; i < recordDataSize; ++i) {
            index = i * dataBufferSize + timeStampBufferSize;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + index);
            }
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((dataBuffer[0 + j * 4 + index] & 0xFF) << 24) + ((dataBuffer[1 + j * 4 + index] & 0xFF) << 16) + ((dataBuffer[2 + j * 4 + index] & 0xFF) << 8) + ((dataBuffer[3 + j * 4 + index] & 0xFF) << 0);
            }
            recordSet.addNoneCalculationRecordsPoints(points, (double)(((dataBuffer[0 + i * 4] & 0xFF) << 24) + ((dataBuffer[1 + i * 4] & 0xFF) << 16) + ((dataBuffer[2 + i * 4] & 0xFF) << 8) + ((dataBuffer[3 + i * 4] & 0xFF) << 0)) / 10.0);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
        if (recordSet.getRecordSetDescription().contains("(")) {
            recordSet.setRecordSetDescription(this.getName() + recordSet.getRecordSetDescription().substring(recordSet.getRecordSetDescription().lastIndexOf("(")));
        } else if (recordSet.getRecordSetDescription().contains(" - ")) {
            recordSet.setRecordSetDescription(this.getName() + recordSet.getRecordSetDescription().substring(recordSet.getRecordSetDescription().indexOf(" - ")));
        }
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                int ordinal = record.getOrdinal();
                switch (ordinal) {
                    default: {
                        dataTableRow[index + 1] = record.getFormattedTableValue(rowIndex);
                        break;
                    }
                    case 0: {
                        dataTableRow[index + 1] = String.format("%.0f", (double)record.realGet(rowIndex).intValue() / 1000.0);
                    }
                }
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public boolean isActualRecordSetWithGpsData() {
        RecordSet activeRecordSet;
        boolean containsGPSdata = false;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
            containsGPSdata = activeRecordSet.get(12).hasReasonableData() && activeRecordSet.get(13).hasReasonableData();
        }
        return containsGPSdata;
    }

    public boolean isGPSCoordinates(Record record) {
        int latOrdinal = 12;
        int lonOrdinal = 13;
        return record.getOrdinal() == 12 || record.getOrdinal() == 13;
    }

    public Integer getGPS2KMZMeasurementOrdinal() {
        if (this.kmzMeasurementOrdinal == null) {
            return 5;
        }
        return this.kmzMeasurementOrdinal;
    }

    public String exportFile(String fileEndingType, boolean isExport2TmpDir) {
        RecordSet activeRecordSet;
        String exportFileName = "";
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && fileEndingType.contains("kmz")) {
            int additionalMeasurementOrdinal = this.getGPS2KMZMeasurementOrdinal();
            int latOrdinal = 12;
            int lonOrdinal = 13;
            int altOrdinal = 6;
            int climbOrdinal = 7;
            exportFileName = new FileHandler().exportFileKMZ(13, 12, 6, additionalMeasurementOrdinal, 7, -1, -1, true, isExport2TmpDir);
        }
        return exportFileName;
    }

    public void export2KMZ3D(int type) {
        int latOrdinal = 12;
        int lonOrdinal = 13;
        int altOrdinal = 6;
        int climbOrdinal = 7;
        int speedOrdinal = 5;
        new FileHandler().exportFileKMZ(Messages.getString((String)"GDE_MSGT2753"), 13, 12, 6, 5, 7, -1, -1, type == 0, type == 2);
    }

    public double translateValue(Record record, double value) {
        double newValue = 0.0;
        int latOrdinal = 12;
        int lonOrdinal = 13;
        if (record.getOrdinal() == 12 || record.getOrdinal() == 13) {
            newValue = value / 1000.0;
        } else {
            double factor = record.getFactor();
            double offset = record.getOffset();
            double reduction = record.getReduction();
            if (record.getOrdinal() == 6 || record.getOrdinal() == 14) {
                boolean isSubtractFirst;
                PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
                boolean bl = isSubtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
                if (isSubtractFirst) {
                    reduction = (double)record.getFirst().intValue() / 1000.0;
                }
            }
            newValue = (value - reduction) * factor + offset;
        }
        log.log(java.util.logging.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double newValue = 0.0;
        int latOrdinal = 12;
        int lonOrdinal = 13;
        if (record.getOrdinal() == 12 || record.getOrdinal() == 13) {
            newValue = value * 1000.0;
        } else {
            double factor = record.getFactor();
            double offset = record.getOffset();
            double reduction = record.getReduction();
            if (record.getOrdinal() == 6 || record.getOrdinal() == 14) {
                boolean isSubtractFirst;
                PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
                boolean bl = isSubtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
                if (isSubtractFirst) {
                    reduction = (double)record.getFirst().intValue() / 1000.0;
                }
            }
            newValue = (value - offset) / factor + reduction;
        }
        log.log(java.util.logging.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        recordSet.syncScaleOfSyncableRecords();
        this.application.updateStatisticsData();
        this.channels.getActiveChannel().applyTemplate(recordSet.getName(), false);
        this.updateVisibilityStatus(recordSet, true);
        this.application.getActiveChannel().setFileDescription(recordSet.getFormatedTime_sec(0, true).trim().split(" ")[0]);
        recordSet.setSaved(true);
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return null;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return null;
    }

    public int getLovDataByteSize() {
        return 0;
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        return null;
    }

    public void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int channelConfigNumber = recordSet.getChannelConfigNumber();
        int displayableCounter = 0;
        boolean configChanged = this.isChangePropery();
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            MeasurementType measurement = this.getMeasurement(channelConfigNumber, i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, record.getName() + " = " + DeviceXmlResource.getInstance().getReplacement(this.getMeasurementNames(channelConfigNumber)[i]));
            }
            if (record.isActive() && record.isActive() != measurement.isActive()) {
                record.setActive(Boolean.valueOf(measurement.isActive()));
                record.setVisible(measurement.isActive());
                record.setDisplayable(measurement.isActive());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "switch " + record.getName() + " to " + measurement.isActive());
                }
            }
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData() && (measurement.isActive() || measurement.isCalculation()));
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, record.getName() + " hasReasonableData " + record.hasReasonableData());
                }
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            ++displayableCounter;
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "add to displayable counter: " + record.getName());
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "displayableCounter = " + displayableCounter);
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
        this.setChangePropery(configChanged);
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    public void open_closeCommPort() {
    }
}

