/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleListener;

class OleEventTable {
    int[] types;
    OleListener[] handlers;

    OleEventTable() {
    }

    void hook(int eventType, OleListener handler) {
        if (this.types == null) {
            this.types = new int[4];
        }
        if (this.handlers == null) {
            this.handlers = new OleListener[4];
        }
        int i2 = 0;
        while (i2 < this.types.length) {
            if (this.types[i2] == 0) {
                this.types[i2] = eventType;
                this.handlers[i2] = handler;
                return;
            }
            ++i2;
        }
        int size = this.types.length;
        int[] newTypes = new int[size + 4];
        OleListener[] newHandlers = new OleListener[size + 4];
        System.arraycopy(this.types, 0, newTypes, 0, size);
        System.arraycopy(this.handlers, 0, newHandlers, 0, size);
        this.types = newTypes;
        this.handlers = newHandlers;
        this.types[size] = eventType;
        this.handlers[size] = handler;
    }

    boolean hooks(int eventType) {
        if (this.handlers == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.types.length) {
            if (this.types[i2] == eventType) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    void sendEvent(OleEvent event) {
        if (this.handlers == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.types.length) {
            OleListener listener2;
            if (this.types[i2] == event.type && (listener2 = this.handlers[i2]) != null) {
                listener2.handleEvent(event);
            }
            ++i2;
        }
    }

    void unhook(int eventType, OleListener handler) {
        if (this.handlers == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.types.length) {
            if (this.types[i2] == eventType && this.handlers[i2] == handler) {
                this.types[i2] = 0;
                this.handlers[i2] = null;
                return;
            }
            ++i2;
        }
    }

    boolean hasEntries() {
        int i2 = 0;
        while (i2 < this.types.length) {
            if (this.types[i2] != 0) {
                return true;
            }
            ++i2;
        }
        return false;
    }
}

