/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.LZWCodec;

public final class GIFFileFormat
extends FileFormat {
    String signature;
    int screenWidth;
    int screenHeight;
    int backgroundPixel;
    int bitsPerPixel;
    int defaultDepth;
    int disposalMethod = 0;
    int delayTime = 0;
    int transparentPixel = -1;
    int repeatCount = 1;
    static final int GIF_APPLICATION_EXTENSION_BLOCK_ID = 255;
    static final int GIF_GRAPHICS_CONTROL_BLOCK_ID = 249;
    static final int GIF_PLAIN_TEXT_BLOCK_ID = 1;
    static final int GIF_COMMENT_BLOCK_ID = 254;
    static final int GIF_EXTENSION_BLOCK_ID = 33;
    static final int GIF_IMAGE_BLOCK_ID = 44;
    static final int GIF_TRAILER_ID = 59;
    static final byte[] GIF89a = new byte[]{71, 73, 70, 56, 57, 97};
    static final byte[] NETSCAPE2_0 = new byte[]{78, 69, 84, 83, 67, 65, 80, 69, 50, 46, 48};

    static PaletteData grayRamp(int numGrays) {
        int n2 = numGrays - 1;
        RGB[] colors = new RGB[numGrays];
        int i2 = 0;
        while (i2 < numGrays) {
            byte intensity = (byte)(i2 * 3 * 256 / n2);
            colors[i2] = new RGB(intensity, intensity, intensity);
            ++i2;
        }
        return new PaletteData(colors);
    }

    @Override
    boolean isFileFormat(LEDataInputStream stream) {
        try {
            byte[] signature2 = new byte[3];
            stream.read(signature2);
            stream.unread(signature2);
            return signature2[0] == 71 && signature2[1] == 73 && signature2[2] == 70;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    ImageData[] loadFromByteStream() {
        byte[] signature2 = new byte[3];
        byte[] versionBytes = new byte[3];
        byte[] block = new byte[7];
        try {
            this.inputStream.read(signature2);
            if (signature2[0] != 71 || signature2[1] != 73 || signature2[2] != 70) {
                SWT.error(40);
            }
            this.inputStream.read(versionBytes);
            this.inputStream.read(block);
        }
        catch (IOException e2) {
            SWT.error(39, e2);
        }
        this.loader.logicalScreenWidth = this.screenWidth = block[0] & 0xFF | (block[1] & 0xFF) << 8;
        this.loader.logicalScreenHeight = this.screenHeight = block[2] & 0xFF | (block[3] & 0xFF) << 8;
        byte bitField = block[4];
        this.backgroundPixel = block[5] & 0xFF;
        this.bitsPerPixel = (bitField >> 4 & 7) + 1;
        this.defaultDepth = (bitField & 7) + 1;
        PaletteData palette = null;
        if ((bitField & 0x80) != 0) {
            palette = this.readPalette(1 << this.defaultDepth);
        } else {
            this.backgroundPixel = -1;
            this.defaultDepth = this.bitsPerPixel;
        }
        this.loader.backgroundPixel = this.backgroundPixel;
        ImageData[] images = new ImageData[]{};
        int id = this.readID();
        while (id != 59 && id != -1) {
            if (id == 44) {
                ImageData image = this.readImageBlock(palette);
                if (this.loader.hasListeners()) {
                    this.loader.notifyListeners(new ImageLoaderEvent(this.loader, image, 3, true));
                }
                ImageData[] oldImages = images;
                images = new ImageData[oldImages.length + 1];
                System.arraycopy(oldImages, 0, images, 0, oldImages.length);
                images[images.length - 1] = image;
            } else if (id == 33) {
                this.readExtension();
            } else {
                if (images.length > 0) break;
                SWT.error(40);
            }
            id = this.readID();
            if (id != 0) continue;
            id = this.readID();
        }
        return images;
    }

    int readID() {
        try {
            return this.inputStream.read();
        }
        catch (IOException e2) {
            SWT.error(39, e2);
            return -1;
        }
    }

    byte[] readExtension() {
        int extensionID = this.readID();
        if (extensionID == 254) {
            return this.readCommentExtension();
        }
        if (extensionID == 1) {
            return this.readPlainTextExtension();
        }
        if (extensionID == 249) {
            return this.readGraphicsControlExtension();
        }
        if (extensionID == 255) {
            return this.readApplicationExtension();
        }
        try {
            int extSize = this.inputStream.read();
            if (extSize < 0) {
                SWT.error(40);
            }
            byte[] ext = new byte[extSize];
            this.inputStream.read(ext, 0, extSize);
            return ext;
        }
        catch (IOException e2) {
            SWT.error(39, e2);
            return null;
        }
    }

    byte[] readCommentExtension() {
        try {
            byte[] comment = new byte[]{};
            byte[] block = new byte[255];
            int size = this.inputStream.read();
            while (size > 0 && this.inputStream.read(block, 0, size) != -1) {
                byte[] oldComment = comment;
                comment = new byte[oldComment.length + size];
                System.arraycopy(oldComment, 0, comment, 0, oldComment.length);
                System.arraycopy(block, 0, comment, oldComment.length, size);
                size = this.inputStream.read();
            }
            return comment;
        }
        catch (Exception e2) {
            SWT.error(39, e2);
            return null;
        }
    }

    byte[] readPlainTextExtension() {
        try {
            this.inputStream.read();
            byte[] info = new byte[12];
            this.inputStream.read(info);
            byte[] text2 = new byte[]{};
            byte[] block = new byte[255];
            int size = this.inputStream.read();
            while (size > 0 && this.inputStream.read(block, 0, size) != -1) {
                byte[] oldText = text2;
                text2 = new byte[oldText.length + size];
                System.arraycopy(oldText, 0, text2, 0, oldText.length);
                System.arraycopy(block, 0, text2, oldText.length, size);
                size = this.inputStream.read();
            }
            return text2;
        }
        catch (Exception e2) {
            SWT.error(39, e2);
            return null;
        }
    }

    byte[] readGraphicsControlExtension() {
        try {
            this.inputStream.read();
            byte[] controlBlock = new byte[4];
            this.inputStream.read(controlBlock);
            byte bitField = controlBlock[0];
            this.disposalMethod = bitField >> 2 & 7;
            this.delayTime = controlBlock[1] & 0xFF | (controlBlock[2] & 0xFF) << 8;
            this.transparentPixel = (bitField & 1) != 0 ? controlBlock[3] & 0xFF : -1;
            return controlBlock;
        }
        catch (Exception e2) {
            SWT.error(39, e2);
            return null;
        }
    }

    byte[] readApplicationExtension() {
        try {
            boolean authentic;
            int blockSize = this.inputStream.read();
            byte[] blockData = new byte[blockSize];
            this.inputStream.read(blockData);
            byte[] data2 = new byte[]{};
            byte[] block = new byte[255];
            int size = this.inputStream.read();
            while (size > 0 && this.inputStream.read(block, 0, size) != -1) {
                byte[] oldData = data2;
                data2 = new byte[oldData.length + size];
                System.arraycopy(oldData, 0, data2, 0, oldData.length);
                System.arraycopy(block, 0, data2, oldData.length, size);
                size = this.inputStream.read();
            }
            boolean netscape = blockSize > 7 && blockData[0] == 78 && blockData[1] == 69 && blockData[2] == 84 && blockData[3] == 83 && blockData[4] == 67 && blockData[5] == 65 && blockData[6] == 80 && blockData[7] == 69;
            boolean bl = authentic = blockSize > 10 && blockData[8] == 50 && blockData[9] == 46 && blockData[10] == 48;
            if (netscape && authentic && data2[0] == 1) {
                this.loader.repeatCount = this.repeatCount = data2[1] & 0xFF | (data2[2] & 0xFF) << 8;
            }
            return data2;
        }
        catch (Exception e2) {
            SWT.error(39, e2);
            return null;
        }
    }

    ImageData readImageBlock(PaletteData defaultPalette) {
        PaletteData palette;
        int depth;
        boolean interlaced;
        byte[] block = new byte[9];
        try {
            this.inputStream.read(block);
        }
        catch (IOException e2) {
            SWT.error(39, e2);
        }
        int left2 = block[0] & 0xFF | (block[1] & 0xFF) << 8;
        int top2 = block[2] & 0xFF | (block[3] & 0xFF) << 8;
        int width = block[4] & 0xFF | (block[5] & 0xFF) << 8;
        int height = block[6] & 0xFF | (block[7] & 0xFF) << 8;
        byte bitField = block[8];
        boolean bl = interlaced = (bitField & 0x40) != 0;
        if ((bitField & 0x80) != 0) {
            depth = (bitField & 7) + 1;
            palette = this.readPalette(1 << depth);
        } else {
            depth = this.defaultDepth;
            palette = defaultPalette;
        }
        if (this.transparentPixel > 1 << depth) {
            this.transparentPixel = -1;
        }
        if (depth != 1 && depth != 4 && depth != 8) {
            depth = depth < 4 ? 4 : 8;
        }
        if (palette == null) {
            palette = GIFFileFormat.grayRamp(1 << depth);
        }
        int initialCodeSize = -1;
        try {
            initialCodeSize = this.inputStream.read();
        }
        catch (IOException e3) {
            SWT.error(39, e3);
        }
        if (initialCodeSize < 0) {
            SWT.error(40);
        }
        ImageData image = ImageData.internal_new(width, height, depth, palette, 4, null, 0, null, null, -1, this.transparentPixel, 2, left2, top2, this.disposalMethod, this.delayTime);
        LZWCodec codec = new LZWCodec();
        codec.decode(this.inputStream, this.loader, image, interlaced, initialCodeSize);
        return image;
    }

    PaletteData readPalette(int numColors) {
        byte[] bytes = new byte[numColors * 3];
        try {
            if (this.inputStream.read(bytes) != bytes.length) {
                SWT.error(40);
            }
        }
        catch (IOException e2) {
            SWT.error(39, e2);
        }
        RGB[] colors = new RGB[numColors];
        int i2 = 0;
        while (i2 < numColors) {
            colors[i2] = new RGB(bytes[i2 * 3] & 0xFF, bytes[i2 * 3 + 1] & 0xFF, bytes[i2 * 3 + 2] & 0xFF);
            ++i2;
        }
        return new PaletteData(colors);
    }

    @Override
    void unloadIntoByteStream(ImageLoader loader2) {
        ImageData[] data2 = loader2.data;
        int frameCount = data2.length;
        boolean multi = frameCount > 1;
        ImageData firstImage = data2[0];
        int logicalScreenWidth = multi ? loader2.logicalScreenWidth : firstImage.width;
        int logicalScreenHeight = multi ? loader2.logicalScreenHeight : firstImage.height;
        int backgroundPixel = loader2.backgroundPixel;
        int depth = firstImage.depth;
        PaletteData palette = firstImage.palette;
        RGB[] colors = palette.getRGBs();
        int globalTable = 1;
        if (depth != 1 && depth != 4 && depth != 8) {
            SWT.error(38);
        }
        int i2 = 0;
        while (i2 < frameCount) {
            if (data2[i2].palette.isDirect) {
                SWT.error(40);
            }
            if (multi) {
                if (data2[i2].height > logicalScreenHeight || data2[i2].width > logicalScreenWidth || data2[i2].depth != depth) {
                    SWT.error(40);
                }
                if (globalTable == 1) {
                    RGB[] rgbs = data2[i2].palette.getRGBs();
                    if (rgbs.length != colors.length) {
                        globalTable = 0;
                    } else {
                        int j2 = 0;
                        while (j2 < colors.length) {
                            if (rgbs[j2].red != colors[j2].red || rgbs[j2].green != colors[j2].green || rgbs[j2].blue != colors[j2].blue) {
                                globalTable = 0;
                            }
                            ++j2;
                        }
                    }
                }
            }
            ++i2;
        }
        try {
            this.outputStream.write(GIF89a);
            int bitField = globalTable * 128 + (depth - 1) * 16 + depth - 1;
            this.outputStream.writeShort((short)logicalScreenWidth);
            this.outputStream.writeShort((short)logicalScreenHeight);
            this.outputStream.write(bitField);
            this.outputStream.write(backgroundPixel);
            this.outputStream.write(0);
        }
        catch (IOException e2) {
            SWT.error(39, e2);
        }
        if (globalTable == 1) {
            this.writePalette(palette, depth);
        }
        if (multi) {
            int repeatCount = loader2.repeatCount;
            try {
                this.outputStream.write(33);
                this.outputStream.write(255);
                this.outputStream.write(NETSCAPE2_0.length);
                this.outputStream.write(NETSCAPE2_0);
                this.outputStream.write(3);
                this.outputStream.write(1);
                this.outputStream.writeShort((short)repeatCount);
                this.outputStream.write(0);
            }
            catch (IOException e3) {
                SWT.error(39, e3);
            }
        }
        int frame = 0;
        while (frame < frameCount) {
            if (multi || data2[frame].transparentPixel != -1) {
                this.writeGraphicsControlBlock(data2[frame]);
            }
            int x2 = data2[frame].x;
            int y2 = data2[frame].y;
            int width = data2[frame].width;
            int height = data2[frame].height;
            try {
                this.outputStream.write(44);
                byte[] block = new byte[]{(byte)(x2 & 0xFF), (byte)(x2 >> 8 & 0xFF), (byte)(y2 & 0xFF), (byte)(y2 >> 8 & 0xFF), (byte)(width & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(height & 0xFF), (byte)(height >> 8 & 0xFF), (byte)(globalTable == 0 ? depth - 1 | 0x80 : 0)};
                this.outputStream.write(block);
            }
            catch (IOException e4) {
                SWT.error(39, e4);
            }
            if (globalTable == 0) {
                this.writePalette(data2[frame].palette, depth);
            }
            try {
                this.outputStream.write(depth);
            }
            catch (IOException e5) {
                SWT.error(39, e5);
            }
            new LZWCodec().encode(this.outputStream, data2[frame]);
            ++frame;
        }
        try {
            this.outputStream.write(59);
        }
        catch (IOException e6) {
            SWT.error(39, e6);
        }
    }

    void writeGraphicsControlBlock(ImageData image) {
        try {
            this.outputStream.write(33);
            this.outputStream.write(249);
            byte[] gcBlock = new byte[]{0, 0, 0, 0};
            if (image.transparentPixel != -1) {
                gcBlock[0] = 1;
                gcBlock[3] = (byte)image.transparentPixel;
            }
            if (image.disposalMethod != 0) {
                gcBlock[0] = (byte)(gcBlock[0] | (byte)((image.disposalMethod & 7) << 2));
            }
            if (image.delayTime != 0) {
                gcBlock[1] = (byte)(image.delayTime & 0xFF);
                gcBlock[2] = (byte)(image.delayTime >> 8 & 0xFF);
            }
            this.outputStream.write((byte)gcBlock.length);
            this.outputStream.write(gcBlock);
            this.outputStream.write(0);
        }
        catch (IOException e2) {
            SWT.error(39, e2);
        }
    }

    void writePalette(PaletteData palette, int depth) {
        byte[] bytes = new byte[(1 << depth) * 3];
        int offset = 0;
        int i2 = 0;
        while (i2 < palette.colors.length) {
            RGB color = palette.colors[i2];
            bytes[offset] = (byte)color.red;
            bytes[offset + 1] = (byte)color.green;
            bytes[offset + 2] = (byte)color.blue;
            offset += 3;
            ++i2;
        }
        try {
            this.outputStream.write(bytes);
        }
        catch (IOException e2) {
            SWT.error(39, e2);
        }
    }
}

